

' VB.NET declare statements for NAG Fortran Library DLL Mark 31.0
' Copyright 2025, Numerical Algorithms Group Ltd, Oxford, UK.

Imports System.Runtime.InteropServices

Module nag_declarations

Const NAGTRUE As Integer = -1
Const NAGFALSE As Integer = 0

<StructLayout(LayoutKind.Sequential)> Structure Complex
  Dim Real_Part As Double
  Dim Imag_Part As Double
End Structure

<StructLayout(LayoutKind.Sequential)> Structure ComplexSingle
  Dim Real_Part As Single
  Dim Imag_Part As Single
End Structure


' chapter a00

   Declare Sub A00AAF Lib "NLW6I31DE_nag.dll" ( _
   )


   Declare Function A00ACF Lib "NLW6I31DE_nag.dll" ( _
   ) as Integer


   Declare Sub A00ADF Lib "NLW6I31DE_nag.dll" ( _
    ByVal IMPL As string, _
    ByVal PREC As string, _
    ByVal PCODE As string, _
    ByRef MKMAJ As Integer, _
    ByRef MKMIN As Integer, _
    ByVal HDWARE As string, _
    ByVal OPSYS As string, _
    ByVal FCOMP As string, _
    ByVal VEND As string, _
    ByRef LICVAL As Integer, _
    ByVal IMPLLength As long, _
    ByVal PRECLength As long, _
    ByVal PCODELength As long, _
    ByVal HDWARELength As long, _
    ByVal OPSYSLength As long, _
    ByVal FCOMPLength As long, _
    ByVal VENDLength As long _
    )


' chapter a02

   Declare Sub A02AAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XR As Double, _
    ByRef XI As Double, _
    ByRef YR As Double, _
    ByRef YI As Double _
   )


   Declare Function A02ABF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XR As Double, _
    ByRef XI As Double _
   ) as Double


   Declare Sub A02ACF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XR As Double, _
    ByRef XI As Double, _
    ByRef YR As Double, _
    ByRef YI As Double, _
    ByRef ZR As Double, _
    ByRef ZI As Double _
   )


' chapter c02

   Declare Sub C02AAF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal A As Complex(), _
    ByRef N As Integer, _
    ByRef ITMAX As Integer, _
    ByRef POLISH As Integer, _
    <Out()> ByVal Z As Complex(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal COND As Double(), _
    <Out()> ByVal CONV As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02ABF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal A As Double(), _
    ByRef N As Integer, _
    ByRef ITMAX As Integer, _
    ByRef POLISH As Integer, _
    <Out()> ByVal Z As Complex(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal COND As Double(), _
    <Out()> ByVal CONV As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02AFF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal A As Double(,), _
    ByRef N As Integer, _
    ByRef SCAL As Integer, _
    <Out()> ByVal Z As Double(,), _
    <Out()> ByVal W As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02AGF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal A As Double(), _
    ByRef N As Integer, _
    ByRef SCAL As Integer, _
    <Out()> ByVal Z As Double(,), _
    <Out()> ByVal W As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02AHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef BR As Double, _
    ByRef BI As Double, _
    ByRef CR As Double, _
    ByRef CI As Double, _
    <Out()> ByVal ZSM As Double(), _
    <Out()> ByVal ZLG As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02AJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    <Out()> ByVal ZSM As Double(), _
    <Out()> ByVal ZLG As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02AKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef U As Double, _
    ByRef R As Double, _
    ByRef S As Double, _
    ByRef T As Double, _
    <Out()> ByVal ZEROR As Double(), _
    <Out()> ByVal ZEROI As Double(), _
    <Out()> ByVal ERREST As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02ALF Lib "NLW6I31DE_nag.dll" ( _
    ByRef E As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef D As Double, _
    <Out()> ByVal ZEROR As Double(), _
    <Out()> ByVal ZEROI As Double(), _
    <Out()> ByVal ERREST As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02AMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef U As Complex, _
    ByRef R As Complex, _
    ByRef S As Complex, _
    ByRef T As Complex, _
    <Out()> ByVal ZEROR As Double(), _
    <Out()> ByVal ZEROI As Double(), _
    <Out()> ByVal ERREST As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C02ANF Lib "NLW6I31DE_nag.dll" ( _
    ByRef E As Complex, _
    ByRef A As Complex, _
    ByRef B As Complex, _
    ByRef C As Complex, _
    ByRef D As Complex, _
    <Out()> ByVal ZEROR As Double(), _
    <Out()> ByVal ZEROI As Double(), _
    <Out()> ByVal ERREST As Double(), _
    ByRef IFAIL As Integer _
   )


' chapter c05

  Delegate Function C05AUF_F_DELEGATE( _
    ByRef X As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  ) as Double

   Declare Sub C05AUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef H As Double, _
    ByRef EPS As Double, _
    ByRef ETA As Double, _
    ByVal F As C05AUF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C05AVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef FX As Double, _
    ByRef H As Double, _
    ByRef BOUNDL As Double, _
    ByRef BOUNDU As Double, _
    ByRef Y As Double, _
    <[In](),Out()> ByVal C As Double(), _
    ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function C05AWF_F_DELEGATE( _
    ByRef X As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  ) as Double

   Declare Sub C05AWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef EPS As Double, _
    ByRef ETA As Double, _
    ByVal F As C05AWF_F_DELEGATE, _
    ByRef NFMAX As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C05AXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef FX As Double, _
    ByRef TOL As Double, _
    ByRef IR As Integer, _
    ByRef SCAL As Double, _
    <[In](),Out()> ByVal C As Double(), _
    ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function C05AYF_F_DELEGATE( _
    ByRef X As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  ) as Double

   Declare Sub C05AYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef EPS As Double, _
    ByRef ETA As Double, _
    ByVal F As C05AYF_F_DELEGATE, _
    ByRef X As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C05AZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByRef FX As Double, _
    ByRef TOLX As Double, _
    ByRef IR As Integer, _
    <[In](),Out()> ByVal C As Double(), _
    ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Function C05BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef BRANCH As Integer, _
    ByRef OFFSET As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Sub C05BBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef BRANCH As Integer, _
    ByRef OFFSET As Integer, _
    ByRef Z As Complex, _
    ByRef W As Complex, _
    ByRef RESID As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub C05MBF_FCN_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr, _
    ByRef IFLAG As Integer _
  )

   Declare Sub C05MBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As C05MBF_FCN_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), _
    ByRef ATOL As Double, _
    ByRef RTOL As Double, _
    ByRef M As Integer, _
    ByRef CNDTOL As Double, _
    ByRef ASTART As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


   Declare Sub C05MDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal FVEC As Double(), _
    ByRef ATOL As Double, _
    ByRef RTOL As Double, _
    ByRef M As Integer, _
    ByRef CNDTOL As Double, _
    ByRef ASTART As Integer, _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub C05QBF_FCN_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef IFLAG As Integer _
  )

   Declare Sub C05QBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As C05QBF_FCN_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), _
    ByRef XTOL As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub C05QCF_FCN_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef IFLAG As Integer _
  )

   Declare Sub C05QCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As C05QCF_FCN_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), ByRef XTOL As Double, ByRef MAXFEV As Integer, _
    ByRef ML As Integer, ByRef MU As Integer, ByRef EPSFCN As Double, _
    ByRef MODE As Integer, <[In](),Out()> ByVal DIAG As Double(), ByRef FACTOR As Double, _
    ByRef NPRINT As Integer, ByRef NFEV As Integer, <Out()> ByVal FJAC As Double(,), _
    <Out()> ByVal R As Double(), <Out()> ByVal QTF As Double(), <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), ByRef IFAIL As Integer _
   )


   Declare Sub C05QDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal FVEC As Double(), _
    ByRef XTOL As Double, _
    ByRef ML As Integer, _
    ByRef MU As Integer, _
    ByRef EPSFCN As Double, _
    ByRef MODE As Integer, _
    <[In](),Out()> ByVal DIAG As Double(), _
    ByRef FACTOR As Double, _
    <[In](),Out()> ByVal FJAC As Double(,), _
    <[In](),Out()> ByVal R As Double(), _
    <[In](),Out()> ByVal QTF As Double(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub C05QSF_FCN_DELEGATE( _
    ByRef N As Integer, _
    ByRef LINDF As Integer, _
    ByVal INDF_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef IFLAG As Integer _
  )

   Declare Sub C05QSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As C05QSF_FCN_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), _
    ByRef XTOL As Double, _
    ByRef INIT As Integer, _
    <[In](),Out()> ByVal RCOMM As Double(), _
    ByRef LRCOMM As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub C05RBF_FCN_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef IFLAG As Integer _
  )

   Declare Sub C05RBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As C05RBF_FCN_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), _
    <Out()> ByVal FJAC As Double(,), _
    ByRef XTOL As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub C05RCF_FCN_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef IFLAG As Integer _
  )

   Declare Sub C05RCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As C05RCF_FCN_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), _
    <Out()> ByVal FJAC As Double(,), _
    ByRef XTOL As Double, _
    ByRef MAXFEV As Integer, _
    ByRef MODE As Integer, _
    <[In](),Out()> ByVal DIAG As Double(), _
    ByRef FACTOR As Double, _
    ByRef NPRINT As Integer, _
    ByRef NFEV As Integer, _
    ByRef NJEV As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal QTF As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C05RDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal FVEC As Double(), _
    <[In](),Out()> ByVal FJAC As Double(,), _
    ByRef XTOL As Double, _
    ByRef MODE As Integer, _
    <[In](),Out()> ByVal DIAG As Double(), _
    ByRef FACTOR As Double, _
    <[In](),Out()> ByVal R As Double(), _
    <[In](),Out()> ByVal QTF As Double(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C05ZDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal FVEC As Double(), _
    <[In]()> ByVal FJAC As Double(,), _
    <Out()> ByVal XP As Double(), _
    <[In]()> ByVal FVECP As Double(), _
    <Out()> ByVal ERR As Double(), _
    ByRef IFAIL As Integer _
   )


' chapter c06

   Declare Sub C06BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef SEQN As Double, _
    ByRef NCALL As Integer, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06DCF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal X As Double(), _
    ByRef LX As Integer, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    <[In]()> ByVal C As Double(), _
    ByRef N As Integer, _
    ByRef S As Integer, _
    <Out()> ByVal RES As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06FAF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal X As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06FBF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal X As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06FCF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06FFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByRef L As Integer, _
    <[In]()> ByVal ND As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal Y As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06FJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    <[In]()> ByVal ND As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal Y As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06FKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef JOB As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06FXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef N3 As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal Y As Double(), _
    ByVal INIT As string, _
    <[In](),Out()> ByVal TRIGN1 As Double(), _
    <[In](),Out()> ByVal TRIGN2 As Double(), _
    <[In](),Out()> ByVal TRIGN3 As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal INITLength As long _
    )


  Delegate Sub C06LAF_F_DELEGATE( _
    ByRef PR As Double, _
    ByRef PI As Double, _
    ByRef FR As Double, _
    ByRef FI As Double _
  )

   Declare Sub C06LAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As C06LAF_F_DELEGATE, _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(), _
    <Out()> ByVal VALINV As Double(), _
    <Out()> ByVal ERREST As Double(), _
    ByRef RELERR As Double, _
    ByRef ALPHAB As Double, _
    ByRef TFAC As Double, _
    ByRef MXTERM As Integer, _
    ByRef NTERMS As Integer, _
    ByRef NA As Integer, _
    ByRef ALOW As Double, _
    ByRef AHIGH As Double, _
    ByRef NFEVAL As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Function C06LBF_F_DELEGATE( _
    ByRef S As Complex _
  ) as Complex

   Declare Sub C06LBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As C06LBF_F_DELEGATE, _
    ByRef SIGMA0 As Double, _
    ByRef SIGMA As Double, _
    ByRef B As Double, _
    ByRef EPSTOL As Double, _
    ByRef MMAX As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal ACOEF As Double(), _
    <Out()> ByVal ERRVEC As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06LCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Double, _
    ByRef SIGMA As Double, _
    ByRef B As Double, _
    ByRef M As Integer, _
    <[In]()> ByVal ACOEF As Double(), _
    <[In]()> ByVal ERRVEC As Double(), _
    ByRef FINV As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06PAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef N As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef NDIM As Integer, _
    ByRef L As Integer, _
    <[In]()> ByVal ND As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef NDIM As Integer, _
    <[In]()> ByVal ND As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef JOB As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef N As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06PPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal Y As Complex(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06PWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06PXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef N3 As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06PYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef N3 As Integer, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal Y As Complex(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06PZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef N3 As Integer, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06RAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06RBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06RCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06RDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal DIRECTLength As long _
    )


   Declare Sub C06REF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06RFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06RGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IDIR As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06RHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IDIR As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C06SAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef D As Integer, _
    <[In]()> ByVal SRCS As Double(,), _
    ByRef N As Integer, _
    <[In]()> ByVal TRGS As Double(,), _
    ByRef M As Integer, _
    <[In]()> ByVal Q As Double(), _
    ByRef P1 As Integer, _
    ByRef P2 As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal HIN As Double(), _
    ByRef LHIN As Integer, _
    ByRef TOL As Double, _
    <Out()> ByVal V As Double(), _
    <Out()> ByVal TERM As Double(), _
    ByRef IFAIL As Integer _
   )


' chapter c09

   Declare Sub C09AAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal WAVNAM As string, _
    ByVal WTRANS As string, _
    ByVal MODE As string, _
    ByRef N As Integer, _
    ByRef NWLMAX As Integer, _
    ByRef NF As Integer, _
    ByRef NWC As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal WAVNAMLength As long, _
    ByVal WTRANSLength As long, _
    ByVal MODELength As long _
    )


   Declare Sub C09ABF Lib "NLW6I31DE_nag.dll" ( _
    ByVal WAVNAM As string, _
    ByVal WTRANS As string, _
    ByVal MODE As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NWLMAX As Integer, _
    ByRef NF As Integer, _
    ByRef NWCT As Integer, _
    ByRef NWCN As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal WAVNAMLength As long, _
    ByVal WTRANSLength As long, _
    ByVal MODELength As long _
    )


   Declare Sub C09ACF Lib "NLW6I31DE_nag.dll" ( _
    ByVal WAVNAM As string, _
    ByVal WTRANS As string, _
    ByVal MODE As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef FR As Integer, _
    ByRef NWLMAX As Integer, _
    ByRef NF As Integer, _
    ByRef NWCT As Integer, _
    ByRef NWCN As Integer, _
    ByRef NWCFR As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal WAVNAMLength As long, _
    ByVal WTRANSLength As long, _
    ByVal MODELength As long _
    )


   Declare Sub C09BAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal WAVNAM As string, _
    ByRef WPARAM As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef NSCAL As Integer, _
    <[In]()> ByVal SCALES As Integer(), _
    <Out()> ByVal C As Double(,), _
    ByRef IFAIL As Integer, _
    ByVal WAVNAMLength As long _
    )


   Declare Sub C09CAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef LENC As Integer, _
    <Out()> ByVal CA As Double(), _
    <Out()> ByVal CD As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09CBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LENC As Integer, _
    <[In]()> ByVal CA As Double(), _
    <[In]()> ByVal CD As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal Y As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09CCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef LENC As Integer, _
    <Out()> ByVal C As Double(), _
    ByRef NWL As Integer, _
    <Out()> ByVal DWTLEV As Integer(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09CDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NWLINV As Integer, _
    ByRef LENC As Integer, _
    <[In]()> ByVal C As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal Y As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09DAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef LENC As Integer, _
    <Out()> ByVal CA As Double(), _
    <Out()> ByVal CD As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09DBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LENC As Integer, _
    <[In]()> ByVal CA As Double(), _
    <[In]()> ByVal CD As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal Y As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09DCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByVal KEEPA As string, _
    ByRef LENC As Integer, _
    <Out()> ByVal C As Double(), _
    ByRef NWL As Integer, _
    ByRef NA As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal KEEPALength As long _
    )


   Declare Sub C09DDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NWLINV As Integer, _
    ByVal KEEPA As string, _
    ByRef LENC As Integer, _
    <[In]()> ByVal C As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal Y As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal KEEPALength As long _
    )


   Declare Sub C09EAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal CA As Double(,), _
    ByRef LDCA As Integer, _
    <Out()> ByVal CH As Double(,), _
    ByRef LDCH As Integer, _
    <Out()> ByVal CV As Double(,), _
    ByRef LDCV As Integer, _
    <Out()> ByVal CD As Double(,), _
    ByRef LDCD As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09EBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal CA As Double(,), _
    ByRef LDCA As Integer, _
    <[In]()> ByVal CH As Double(,), _
    ByRef LDCH As Integer, _
    <[In]()> ByVal CV As Double(,), _
    ByRef LDCV As Integer, _
    <[In]()> ByVal CD As Double(,), _
    ByRef LDCD As Integer, _
    <Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09ECF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef LENC As Integer, _
    <Out()> ByVal C As Double(), _
    ByRef NWL As Integer, _
    <Out()> ByVal DWTLVM As Integer(), _
    <Out()> ByVal DWTLVN As Integer(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09EDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NWLINV As Integer, _
    ByRef LENC As Integer, _
    <[In]()> ByVal C As Double(), _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09EYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ILEV As Integer, _
    ByRef CINDEX As Integer, _
    ByRef LENC As Integer, _
    <[In]()> ByVal C As Double(), _
    <Out()> ByVal D As Double(,), _
    ByRef LDD As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09EZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ILEV As Integer, _
    ByRef CINDEX As Integer, _
    ByRef LENC As Integer, _
    <[In](),Out()> ByVal C As Double(), _
    <[In]()> ByVal D As Double(,), _
    ByRef LDD As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09FAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef FR As Integer, _
    <[In]()> ByVal A As Double(,,), _
    ByRef LDA As Integer, _
    ByRef SDA As Integer, _
    ByRef LENC As Integer, _
    <Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09FBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef FR As Integer, _
    ByRef LENC As Integer, _
    <[In]()> ByVal C As Double(), _
    <Out()> ByVal B As Double(,,), _
    ByRef LDB As Integer, _
    ByRef SDB As Integer, _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09FCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef FR As Integer, _
    <[In]()> ByVal A As Double(,,), _
    ByRef LDA As Integer, _
    ByRef SDA As Integer, _
    ByRef LENC As Integer, _
    <Out()> ByVal C As Double(), _
    ByRef NWL As Integer, _
    <Out()> ByVal DWTLVM As Integer(), _
    <Out()> ByVal DWTLVN As Integer(), _
    <Out()> ByVal DWTLVFR As Integer(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09FDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NWLINV As Integer, _
    ByRef LENC As Integer, _
    <[In]()> ByVal C As Double(), _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef FR As Integer, _
    <Out()> ByVal B As Double(,,), _
    ByRef LDB As Integer, _
    ByRef SDB As Integer, _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09FYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ILEV As Integer, _
    ByRef CINDEX As Integer, _
    ByRef LENC As Integer, _
    <[In]()> ByVal C As Double(), _
    <Out()> ByVal D As Double(,,), _
    ByRef LDD As Integer, _
    ByRef SDD As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub C09FZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ILEV As Integer, _
    ByRef CINDEX As Integer, _
    ByRef LENC As Integer, _
    <[In](),Out()> ByVal C As Double(), _
    <[In]()> ByVal D As Double(,,), _
    ByRef LDD As Integer, _
    ByRef SDD As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


' chapter d01

  Delegate Function D01AHF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Function D01AHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef EPSR As Double, _
    ByRef NPTS As Integer, _
    ByRef RELERR As Double, _
    ByVal F As D01AHF_F_DELEGATE, _
    ByRef NLIMIT As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


  Delegate Function D01AJF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01AJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01AJF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01AKF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01AKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01AKF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01ALF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01ALF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01ALF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef NPTS As Integer, _
    <[In]()> ByVal POINTS As Double(), _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01AMF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01AMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01AMF_F_DELEGATE, _
    ByRef BOUND As Double, _
    ByRef INF As Integer, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01ANF_G_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01ANF Lib "NLW6I31DE_nag.dll" ( _
    ByVal G As D01ANF_G_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef OMEGA As Double, _
    ByRef KEY As Integer, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01APF_G_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01APF Lib "NLW6I31DE_nag.dll" ( _
    ByVal G As D01APF_G_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef ALFA As Double, _
    ByRef BETA As Double, _
    ByRef KEY As Integer, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01AQF_G_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01AQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal G As D01AQF_G_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01ARF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01ARF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByVal F As D01ARF_F_DELEGATE, _
    ByRef RELACC As Double, _
    ByRef ABSACC As Double, _
    ByRef MAXRUL As Integer, _
    ByRef IPARM As Integer, _
    ByRef ACC As Double, _
    ByRef ANS As Double, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal ALPHA As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01ASF_G_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01ASF Lib "NLW6I31DE_nag.dll" ( _
    ByVal G As D01ASF_G_DELEGATE, _
    ByRef A As Double, _
    ByRef OMEGA As Double, _
    ByRef KEY As Integer, _
    ByRef EPSABS As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    ByRef LIMLST As Integer, _
    ByRef LST As Integer, _
    <Out()> ByVal ERLST As Double(), _
    <Out()> ByVal RSLST As Double(), _
    <Out()> ByVal IERLST As Integer(), _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01ATF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByVal FV_rptr As IntPtr, _
    ByRef N As Integer _
  )

   Declare Sub D01ATF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01ATF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01AUF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByVal FV_rptr As IntPtr, _
    ByRef N As Integer _
  )

   Declare Sub D01AUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01AUF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef KEY As Integer, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01BCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef D As Double, _
    ByRef N As Integer, _
    <Out()> ByVal WEIGHT As Double(), _
    <Out()> ByVal ABSCIS As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01BDF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D01BDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01BDF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double _
   )


  Delegate Function D01DAF_PHI1_DELEGATE( _
    ByRef Y As Double _
  ) as Double

  Delegate Function D01DAF_PHI2_DELEGATE( _
    ByRef Y As Double _
  ) as Double

  Delegate Function D01DAF_F_DELEGATE( _
    ByRef X As Double, _
    ByRef Y As Double _
  ) as Double

   Declare Sub D01DAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef YA As Double, _
    ByRef YB As Double, _
    ByVal PHI1 As D01DAF_PHI1_DELEGATE, _
    ByVal PHI2 As D01DAF_PHI2_DELEGATE, _
    ByVal F As D01DAF_F_DELEGATE, _
    ByRef ABSACC As Double, _
    ByRef ANS As Double, _
    ByRef NPTS As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01EAF_FUNSUB_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal Z_rptr As IntPtr, _
    ByRef NFUN As Integer, _
    ByVal F_rptr As IntPtr _
  )

   Declare Sub D01EAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(), _
    ByRef MINCLS As Integer, _
    ByRef MAXCLS As Integer, _
    ByRef NFUN As Integer, _
    ByVal FUNSUB As D01EAF_FUNSUB_DELEGATE, _
    ByRef ABSREQ As Double, _
    ByRef RELREQ As Double, _
    ByRef LENWRK As Integer, _
    <[In](),Out()> ByVal WRKSTR As Double(), _
    <Out()> ByVal FINEST As Double(), _
    <Out()> ByVal ABSEST As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01ESF_F_DELEGATE( _
    ByRef NI As Integer, _
    ByRef NDIM As Integer, _
    ByRef NX As Integer, _
    ByRef XTR As Double, _
    ByRef NNTR As Integer, _
    ByVal ICOLZP_iptr As IntPtr, _
    ByVal IROWIX_iptr As IntPtr, _
    ByVal XS_rptr As IntPtr, _
    ByVal QS_iptr As IntPtr, _
    ByVal FM_rptr As IntPtr, _
    ByRef IFLAG As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D01ESF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NI As Integer, _
    ByRef NDIM As Integer, _
    ByVal F As D01ESF_F_DELEGATE, _
    <[In]()> ByVal MAXDLV As Integer(), _
    <Out()> ByVal DINEST As Double(), _
    <Out()> ByVal ERREST As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    <[In]()> ByVal IOPTS As Integer(), _
    <[In]()> ByVal OPTS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01FBF_F_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr _
  ) as Double

   Declare Function D01FBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    <[In]()> ByVal NPTVEC As Integer(), _
    ByRef LWA As Integer, _
    <[In]()> ByVal WEIGHT As Double(), _
    <[In]()> ByVal ABSCIS As Double(), _
    ByVal F As D01FBF_F_DELEGATE, _
    ByRef IFAIL As Integer _
   ) as Double


  Delegate Function D01FCF_F_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal Z_rptr As IntPtr _
  ) as Double

   Declare Sub D01FCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(), _
    ByRef MINPTS As Integer, _
    ByRef MAXPTS As Integer, _
    ByVal F As D01FCF_F_DELEGATE, _
    ByRef EPS As Double, _
    ByRef ACC As Double, _
    ByRef LENWRK As Integer, _
    <Out()> ByVal WRKSTR As Double(), _
    ByRef FINVAL As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01FDF_F_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr _
  ) as Double

  Delegate Sub D01FDF_REGION_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef J As Integer, _
    ByRef C As Double, _
    ByRef D As Double _
  )

   Declare Sub D01FDV Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef J As Integer, _
    ByRef C As Double, _
    ByRef D As Double _
  )

   Declare Sub D01FDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByVal F As D01FDF_F_DELEGATE, _
    ByRef SIGMA As Double, _
    ByVal REGION As D01FDF_REGION_DELEGATE, _
    ByRef LIMIT As Integer, _
    ByRef R0 As Double, _
    ByRef U As Double, _
    ByRef RESULT As Double, _
    ByRef NCALLS As Integer, _
    ByRef IFAIL As Integer _
   )




   Declare Sub D01GAF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    ByRef N As Integer, _
    ByRef ANS As Double, _
    ByRef ER As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01GBF_F_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr _
  ) as Double

   Declare Sub D01GBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(), _
    ByRef MINCLS As Integer, _
    ByRef MAXCLS As Integer, _
    ByVal F As D01GBF_F_DELEGATE, _
    ByRef EPS As Double, _
    ByRef ACC As Double, _
    ByRef LENWRK As Integer, _
    <[In](),Out()> ByVal WRKSTR As Double(), _
    ByRef FINEST As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01GCF_F_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr _
  ) as Double

  Delegate Sub D01GCF_REGION_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef J As Integer, _
    ByRef C As Double, _
    ByRef D As Double _
  )

   Declare Sub D01GCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByVal F As D01GCF_F_DELEGATE, _
    ByVal REGION As D01GCF_REGION_DELEGATE, _
    ByRef NPTS As Integer, _
    <[In](),Out()> ByVal VK As Double(), _
    ByRef NRAND As Integer, _
    ByRef ITRANS As Integer, _
    ByRef RES As Double, _
    ByRef ERR As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01GDF_VECFUN_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FV_rptr As IntPtr, _
    ByRef M As Integer _
  )

  Delegate Sub D01GDF_VECREG_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef J As Integer, _
    ByVal C_rptr As IntPtr, _
    ByVal D_rptr As IntPtr, _
    ByRef M As Integer _
  )

   Declare Sub D01GDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByVal VECFUN As D01GDF_VECFUN_DELEGATE, _
    ByVal VECREG As D01GDF_VECREG_DELEGATE, _
    ByRef NPTS As Integer, _
    <[In](),Out()> ByVal VK As Double(), _
    ByRef NRAND As Integer, _
    ByRef ITRANS As Integer, _
    ByRef RES As Double, _
    ByRef ERR As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01GYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByRef NPTS As Integer, _
    <Out()> ByVal VK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01GZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByRef NP1 As Integer, _
    ByRef NP2 As Integer, _
    <Out()> ByVal VK As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01JAF_F_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr _
  ) as Double

   Declare Sub D01JAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01JAF_F_DELEGATE, _
    ByRef NDIM As Integer, _
    ByRef RADIUS As Double, _
    ByRef EPSA As Double, _
    ByRef EPSR As Double, _
    ByRef METHOD As Integer, _
    ByRef ICOORD As Integer, _
    ByRef RESULT As Double, _
    ByRef ESTERR As Double, _
    ByRef NEVALS As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D01PAF_F_DELEGATE( _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr _
  ) as Double

   Declare Sub D01PAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    <[In](),Out()> ByVal VERT As Double(,), _
    ByRef LDVERT As Integer, _
    ByRef SDVERT As Integer, _
    ByVal F As D01PAF_F_DELEGATE, _
    ByRef MINORD As Integer, _
    ByRef MAXORD As Integer, _
    <[In](),Out()> ByVal FINVLS As Double(), _
    ByRef ESTERR As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01RAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, ByRef NI As Integer, ByRef A As Double, _
    ByRef B As Double, ByRef SID As Integer, <[In](),Out()> ByVal NEEDI As Integer(), _
    <[In](),Out()> ByVal X As Double(), ByRef LENX As Integer, ByRef NX As Integer, _
    <[In]()> ByVal FM As Double(,), ByRef LDFM As Integer, <[In](),Out()> ByVal DINEST As Double(), _
    <[In](),Out()> ByVal ERREST As Double(), <[In]()> ByVal IOPTS As Integer(), <[In]()> ByVal OPTS As Double(), _
    <[In](),Out()> ByVal ICOM As Integer(), ByRef LICOM As Integer, <[In](),Out()> ByVal COM As Double(), _
    ByRef LCOM As Integer, ByRef IFAIL As Integer _
   )


   Declare Sub D01RCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NI As Integer, _
    ByRef LENXRQ As Integer, _
    ByRef LDFMRQ As Integer, _
    ByRef SDFMRQ As Integer, _
    ByRef LICMIN As Integer, _
    ByRef LICMAX As Integer, _
    ByRef LCMIN As Integer, _
    ByRef LCMAX As Integer, _
    <[In]()> ByVal IOPTS As Integer(), _
    <[In]()> ByVal OPTS As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01RGF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByRef NX As Integer, _
    ByVal FV_rptr As IntPtr, _
    ByRef IFLAG As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D01RGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByVal F As D01RGF_F_DELEGATE, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef DINEST As Double, _
    ByRef ERREST As Double, _
    ByRef NEVALS As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01RJF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByRef NX As Integer, _
    ByVal FV_rptr As IntPtr, _
    ByRef IFLAG As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub D01RJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01RJF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef MAXSUB As Integer, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal IINFO As Integer(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01RKF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByRef NX As Integer, _
    ByVal FV_rptr As IntPtr, _
    ByRef IFLAG As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub D01RKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01RKF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef KEY As Integer, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef MAXSUB As Integer, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal IINFO As Integer(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01RLF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByRef NX As Integer, _
    ByVal FV_rptr As IntPtr, _
    ByRef IFLAG As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub D01RLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01RLF_F_DELEGATE, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef NPTS As Integer, _
    <[In]()> ByVal POINTS As Double(), _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef MAXSUB As Integer, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal IINFO As Integer(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01RMF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByRef NX As Integer, _
    ByVal FV_rptr As IntPtr, _
    ByRef IFLAG As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub D01RMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01RMF_F_DELEGATE, _
    ByRef BOUND As Double, _
    ByRef INF As Integer, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef MAXSUB As Integer, _
    ByRef RESULT As Double, _
    ByRef ABSERR As Double, _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal IINFO As Integer(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01TBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef KEY As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef N As Integer, _
    <Out()> ByVal WEIGHT As Double(), _
    <Out()> ByVal ABSCIS As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01TCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef D As Double, _
    ByRef N As Integer, _
    <Out()> ByVal WEIGHT As Double(), _
    <Out()> ByVal ABSCIS As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01TDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In](),Out()> ByVal B As Double(), _
    <[In](),Out()> ByVal C As Double(), _
    ByRef MUZERO As Double, _
    <Out()> ByVal WEIGHT As Double(), _
    <Out()> ByVal ABSCIS As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01TEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal MU As Double(), _
    <Out()> ByVal A As Double(), _
    <Out()> ByVal B As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01UAF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByRef NX As Integer, _
    ByVal FV_rptr As IntPtr, _
    ByRef IFLAG As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D01UAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef KEY As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef N As Integer, _
    ByVal F As D01UAF_F_DELEGATE, _
    ByRef DINEST As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D01UBF_F_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByVal FV_rptr As IntPtr, _
    ByRef N As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef ISTOP As Integer _
  )

   Declare Sub D01UBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D01UBF_F_DELEGATE, _
    ByRef N As Integer, _
    ByRef ANS As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D01ZKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    <[In](),Out()> ByVal IOPTS As Integer(), _
    ByRef LIOPTS As Integer, _
    <[In](),Out()> ByVal OPTS As Double(), _
    ByRef LOPTS As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Sub D01ZLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByRef IVALUE As Integer, _
    ByRef RVALUE As Double, _
    ByVal CVALUE As string, _
    ByRef OPTYPE As Integer, _
    <[In]()> ByVal IOPTS As Integer(), _
    <[In]()> ByVal OPTS As Double(), _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long, _
    ByVal CVALUELength As long _
    )


' chapter d02

  Delegate Sub D02AGF_AUX_DELEGATE( _
    ByVal F_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByRef X As Double, _
    ByVal PARAM_rptr As IntPtr _
  )

  Delegate Sub D02AGF_BCAUX_DELEGATE( _
    ByVal G0_rptr As IntPtr, _
    ByVal G1_rptr As IntPtr, _
    ByVal PARAM_rptr As IntPtr _
  )

  Delegate Sub D02AGF_RAAUX_DELEGATE( _
    ByRef X0 As Double, _
    ByRef X1 As Double, _
    ByRef R As Double, _
    ByVal PARAM_rptr As IntPtr _
  )

  Delegate Sub D02AGF_PRSOL_DELEGATE( _
    ByVal PARAM_rptr As IntPtr, _
    ByRef RES As Double, _
    ByRef N1 As Integer, _
    ByVal ERR_rptr As IntPtr _
  )

   Declare Sub D02AGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef H As Double, _
    <[In]()> ByVal E As Double(), _
    <[In]()> ByVal PARERR As Double(), _
    <[In](),Out()> ByVal PARAM As Double(), _
    <Out()> ByVal C As Double(,), _
    ByRef N As Integer, _
    ByRef N1 As Integer, _
    ByRef M1 As Integer, _
    ByVal AUX As D02AGF_AUX_DELEGATE, _
    ByVal BCAUX As D02AGF_BCAUX_DELEGATE, _
    ByVal RAAUX As D02AGF_RAAUX_DELEGATE, _
    ByVal PRSOL As D02AGF_PRSOL_DELEGATE, _
    <Out()> ByVal MAT As Double(,), _
    <[In]()> ByVal COPY As Double(,), _
    <Out()> ByVal WSPACE As Double(,), _
    <Out()> ByVal WSPAC1 As Double(), _
    <Out()> ByVal WSPAC2 As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02BGF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

   Declare Sub D02BGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef XEND As Double, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef TOL As Double, _
    ByRef HMAX As Double, _
    ByRef M As Integer, _
    ByRef VAL As Double, _
    ByVal FCN As D02BGF_FCN_DELEGATE, _
    <Out()> ByVal W As Double(,), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02BHF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

  Delegate Function D02BHF_G_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr _
  ) as Double

   Declare Sub D02BHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef XEND As Double, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef TOL As Double, _
    ByRef IRELAB As Integer, _
    ByRef HMAX As Double, _
    ByVal FCN As D02BHF_FCN_DELEGATE, _
    ByVal G As D02BHF_G_DELEGATE, _
    <Out()> ByVal W As Double(,), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02BJF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

  Delegate Sub D02BJF_OUTPUT_DELEGATE( _
    ByRef XSOL As Double, _
    ByVal Y_rptr As IntPtr _
  )

   Declare Sub D02BJX Lib "NLW6I31DE_nag.dll" ( _
    ByRef XSOL As Double, _
    ByVal Y_rptr As IntPtr _
  )

  Delegate Function D02BJF_G_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr _
  ) as Double

   Declare Function D02BJW Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr _
  ) as Double

   Declare Sub D02BJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef XEND As Double, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByVal FCN As D02BJF_FCN_DELEGATE, _
    ByRef TOL As Double, _
    ByVal RELABS As string, _
    ByVal OUTPUT As D02BJF_OUTPUT_DELEGATE, _
    ByVal G As D02BJF_G_DELEGATE, _
    <Out()> ByVal W As Double(), _
    ByRef IFAIL As Integer, _
    ByVal RELABSLength As long _
    )


  Delegate Sub D02CJF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

  Delegate Sub D02CJF_OUTPUT_DELEGATE( _
    ByRef XSOL As Double, _
    ByVal Y_rptr As IntPtr _
  )

   Declare Sub D02CJX Lib "NLW6I31DE_nag.dll" ( _
    ByRef XSOL As Double, _
    ByVal Y_rptr As IntPtr _
  )

  Delegate Function D02CJF_G_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr _
  ) as Double

   Declare Function D02CJW Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr _
  ) as Double

   Declare Sub D02CJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef XEND As Double, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByVal FCN As D02CJF_FCN_DELEGATE, _
    ByRef TOL As Double, _
    ByVal RELABS As string, _
    ByVal OUTPUT As D02CJF_OUTPUT_DELEGATE, _
    ByVal G As D02CJF_G_DELEGATE, _
    <Out()> ByVal W As Double(), _
    ByRef IFAIL As Integer, _
    ByVal RELABSLength As long _
    )


  Delegate Sub D02EJF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

  Delegate Sub D02EJF_PEDERV_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal PW_rptr As IntPtr _
  )

   Declare Sub D02EJY Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal PW_rptr As IntPtr _
  )

  Delegate Sub D02EJF_OUTPUT_DELEGATE( _
    ByRef XSOL As Double, _
    ByVal Y_rptr As IntPtr _
  )

   Declare Sub D02EJX Lib "NLW6I31DE_nag.dll" ( _
    ByRef XSOL As Double, _
    ByVal Y_rptr As IntPtr _
  )

  Delegate Function D02EJF_G_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr _
  ) as Double

   Declare Function D02EJW Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr _
  ) as Double

   Declare Sub D02EJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef XEND As Double, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByVal FCN As D02EJF_FCN_DELEGATE, _
    ByVal PEDERV As D02EJF_PEDERV_DELEGATE, _
    ByRef TOL As Double, _
    ByVal RELABS As string, _
    ByVal OUTPUT As D02EJF_OUTPUT_DELEGATE, _
    ByVal G As D02EJF_G_DELEGATE, _
    <Out()> ByVal W As Double(), _
    ByRef IW As Integer, _
    ByRef IFAIL As Integer, _
    ByVal RELABSLength As long _
    )


  Delegate Sub D02GAF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

   Declare Sub D02GAF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal U As Double(,), _
    <[In]()> ByVal V As Double(,), _
    ByRef N As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef TOL As Double, _
    ByVal FCN As D02GAF_FCN_DELEGATE, _
    ByRef MNP As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal Y As Double(,), _
    ByRef NP As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02GAW Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef EPS As Double, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal F As Double(), _
    ByRef N As Integer _
   )


   Declare Sub D02GAX Lib "NLW6I31DE_nag.dll" ( _
    ByRef EPS As Double, _
    <[In]()> ByVal YA As Double(), _
    <[In]()> ByVal YB As Double(), _
    <Out()> ByVal BCEP As Double(), _
    ByRef N As Integer _
   )


   Declare Sub D02GAY Lib "NLW6I31DE_nag.dll" ( _
    ByRef EPS As Double, _
    <[In]()> ByVal YA As Double(), _
    <[In]()> ByVal YB As Double(), _
    <Out()> ByVal AJ As Double(,), _
    <Out()> ByVal BJ As Double(,), _
    ByRef N As Integer _
   )


   Declare Sub D02GAZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef EPS As Double, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal F As Double(,), _
    ByRef N As Integer _
   )


  Delegate Sub D02GBF_FCNF_DELEGATE( _
    ByRef X As Double, _
    ByVal F_rptr As IntPtr _
  )

  Delegate Sub D02GBF_FCNG_DELEGATE( _
    ByRef X As Double, _
    ByVal G_rptr As IntPtr _
  )

   Declare Sub D02GBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef N As Integer, _
    ByRef TOL As Double, _
    ByVal FCNF As D02GBF_FCNF_DELEGATE, _
    ByVal FCNG As D02GBF_FCNG_DELEGATE, _
    <[In](),Out()> ByVal C As Double(,), _
    <[In](),Out()> ByVal D As Double(,), _
    <[In](),Out()> ByVal GAM As Double(), _
    ByRef MNP As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal Y As Double(,), _
    ByRef NP As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02HAF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

   Declare Sub D02HAF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal U As Double(,), _
    <[In]()> ByVal V As Double(,), _
    ByRef N As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef TOL As Double, _
    ByVal FCN As D02HAF_FCN_DELEGATE, _
    <Out()> ByVal SOLN As Double(,), _
    ByRef M1 As Integer, _
    <Out()> ByVal W As Double(,), _
    ByRef SDW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02HBF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal P_rptr As IntPtr _
  )

  Delegate Sub D02HBF_BC_DELEGATE( _
    ByVal G1_rptr As IntPtr, _
    ByVal G2_rptr As IntPtr, _
    ByVal P_rptr As IntPtr _
  )

  Delegate Sub D02HBF_RANGE_DELEGATE( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByVal P_rptr As IntPtr _
  )

   Declare Sub D02HBF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal P As Double(), _
    ByRef N1 As Integer, _
    <[In]()> ByVal PE As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef N As Integer, _
    <Out()> ByVal SOLN As Double(,), _
    ByRef M1 As Integer, _
    ByVal FCN As D02HBF_FCN_DELEGATE, _
    ByVal BC As D02HBF_BC_DELEGATE, _
    ByVal RANGE As D02HBF_RANGE_DELEGATE, _
    <Out()> ByVal W As Double(,), _
    ByRef SDW As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02HBW Lib "NLW6I31DE_nag.dll" ( _
    ByRef Z As Double, _
    <[In]()> ByVal Y As Double(), _
    ByRef N As Integer _
   )


   Declare Sub D02HBZ Lib "NLW6I31DE_nag.dll" ( _
    <Out()> ByVal E As Double(), _
    ByRef Q As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef M As Integer _
   )


  Delegate Function D02JAF_CF_DELEGATE( _
    ByRef J As Integer, _
    ByRef X As Double _
  ) as Double

  Delegate Sub D02JAF_BC_DELEGATE( _
    ByRef I As Integer, _
    ByRef J As Integer, _
    ByRef RHS As Double _
  )

   Declare Sub D02JAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal CF As D02JAF_CF_DELEGATE, _
    ByVal BC As D02JAF_BC_DELEGATE, _
    ByRef X0 As Double, _
    ByRef X1 As Double, _
    ByRef K1 As Integer, _
    ByRef KP As Integer, _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef IFAIL As Integer _
   )


  Delegate Function D02JBF_CF_DELEGATE( _
    ByRef I As Integer, _
    ByRef J As Integer, _
    ByRef X As Double _
  ) as Double

  Delegate Sub D02JBF_BC_DELEGATE( _
    ByRef I As Integer, _
    ByRef J As Integer, _
    ByRef RHS As Double _
  )

   Declare Sub D02JBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal CF As D02JBF_CF_DELEGATE, _
    ByVal BC As D02JBF_BC_DELEGATE, _
    ByRef X0 As Double, _
    ByRef X1 As Double, _
    ByRef K1 As Integer, _
    ByRef KP As Integer, _
    <Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02KAF_COEFFN_DELEGATE( _
    ByRef P As Double, _
    ByRef Q As Double, _
    ByRef DQDL As Double, _
    ByRef X As Double, _
    ByRef ELAM As Double, _
    ByRef JINT As Integer _
  )

  Delegate Sub D02KAF_MONIT_DELEGATE( _
    ByRef NIT As Integer, _
    ByRef IFLAG As Integer, _
    ByRef ELAM As Double, _
    ByVal FINFO_rptr As IntPtr _
  )

   Declare Sub D02KAY Lib "NLW6I31DE_nag.dll" ( _
    ByRef NIT As Integer, _
    ByRef IFLAG As Integer, _
    ByRef ELAM As Double, _
    ByVal FINFO_rptr As IntPtr _
  )

   Declare Sub D02KAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XL As Double, _
    ByRef XR As Double, _
    ByVal COEFFN As D02KAF_COEFFN_DELEGATE, _
    <[In](),Out()> ByVal BCOND As Double(,), _
    ByRef K As Integer, _
    ByRef TOL As Double, _
    ByRef ELAM As Double, _
    ByRef DELAM As Double, _
    ByVal MONIT As D02KAF_MONIT_DELEGATE, _
    ByRef IFAIL As Integer _
   )




  Delegate Sub D02KDF_COEFFN_DELEGATE( _
    ByRef P As Double, _
    ByRef Q As Double, _
    ByRef DQDL As Double, _
    ByRef X As Double, _
    ByRef ELAM As Double, _
    ByRef JINT As Integer _
  )

  Delegate Sub D02KDF_BDYVAL_DELEGATE( _
    ByRef XL As Double, _
    ByRef XR As Double, _
    ByRef ELAM As Double, _
    ByVal YL_rptr As IntPtr, _
    ByVal YR_rptr As IntPtr _
  )

  Delegate Sub D02KDF_MONIT_DELEGATE( _
    ByRef NIT As Integer, _
    ByRef IFLAG As Integer, _
    ByRef ELAM As Double, _
    ByVal FINFO_rptr As IntPtr _
  )


   Declare Sub D02KDF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal XPOINT As Double(), _
    ByRef M As Integer, _
    ByVal COEFFN As D02KDF_COEFFN_DELEGATE, _
    ByVal BDYVAL As D02KDF_BDYVAL_DELEGATE, _
    ByRef K As Integer, _
    ByRef TOL As Double, _
    ByRef ELAM As Double, _
    ByRef DELAM As Double, _
    <[In](),Out()> ByVal HMAX As Double(,), _
    ByRef MAXIT As Integer, _
    ByRef MAXFUN As Integer, _
    ByVal MONIT As D02KDF_MONIT_DELEGATE, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02KEF_COEFFN_DELEGATE( _
    ByRef P As Double, _
    ByRef Q As Double, _
    ByRef DQDL As Double, _
    ByRef X As Double, _
    ByRef ELAM As Double, _
    ByRef JINT As Integer _
  )

  Delegate Sub D02KEF_BDYVAL_DELEGATE( _
    ByRef XL As Double, _
    ByRef XR As Double, _
    ByRef ELAM As Double, _
    ByVal YL_rptr As IntPtr, _
    ByVal YR_rptr As IntPtr _
  )

  Delegate Sub D02KEF_MONIT_DELEGATE( _
    ByRef NIT As Integer, _
    ByRef IFLAG As Integer, _
    ByRef ELAM As Double, _
    ByVal FINFO_rptr As IntPtr _
  )


  Delegate Sub D02KEF_REPORT_DELEGATE( _
    ByRef X As Double, _
    ByVal V_rptr As IntPtr, _
    ByRef JINT As Integer _
  )

   Declare Sub D02KEF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal XPOINT As Double(), _
    ByRef M As Integer, _
    ByRef MATCH As Integer, _
    ByVal COEFFN As D02KEF_COEFFN_DELEGATE, _
    ByVal BDYVAL As D02KEF_BDYVAL_DELEGATE, _
    ByRef K As Integer, _
    ByRef TOL As Double, _
    ByRef ELAM As Double, _
    ByRef DELAM As Double, _
    <[In](),Out()> ByVal HMAX As Double(,), _
    ByRef MAXIT As Integer, _
    ByRef MAXFUN As Integer, _
    ByVal MONIT As D02KEF_MONIT_DELEGATE, _
    ByVal REPORT As D02KEF_REPORT_DELEGATE, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02LAF_FCN_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

   Declare Sub D02LAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As D02LAF_FCN_DELEGATE, _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByRef TEND As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    <[In](),Out()> ByVal YP As Double(), _
    <[In](),Out()> ByVal YDP As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02LXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef H As Double, _
    ByRef TOL As Double, _
    <[In]()> ByVal THRES As Double(), _
    <[In]()> ByVal THRESP As Double(), _
    ByRef MAXSTP As Integer, _
    ByRef START As Integer, _
    ByRef ONESTP As Integer, _
    ByRef HIGH As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02LYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef HNEXT As Double, _
    ByRef HUSED As Double, _
    ByRef HSTART As Double, _
    ByRef NSUCC As Integer, _
    ByRef NFAIL As Integer, _
    ByRef NATT As Integer, _
    <Out()> ByVal THRES As Double(), _
    <Out()> ByVal THRESP As Double(), _
    <[In]()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02LZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal YP As Double(), _
    ByRef NWANT As Integer, _
    ByRef TWANT As Double, _
    <Out()> ByVal YWANT As Double(), _
    <Out()> ByVal YPWANT As Double(), _
    <[In]()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02MCF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal ICOM As Integer() _
   )


   Declare Sub D02MVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQMAX As Integer, _
    ByRef SDYSAV As Integer, _
    ByRef MAXORD As Integer, _
    <[In](),Out()> ByVal CON As Double(), _
    ByRef TCRIT As Double, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef H0 As Double, _
    ByRef MAXSTP As Integer, _
    ByRef MXHNIL As Integer, _
    ByVal NORM As string, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub D02MWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef MAXORD As Integer, _
    ByVal JCEVAL As string, _
    ByRef HMAX As Double, _
    ByRef H0 As Double, _
    ByRef ITOL As Integer, _
    <Out()> ByVal ICOM As Integer(), _
    ByRef LICOM As Integer, _
    <Out()> ByVal COM As Double(), _
    ByRef LCOM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal JCEVALLength As long _
    )


   Declare Sub D02MZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef TSOL As Double, _
    <Out()> ByVal SOL As Double(), _
    ByRef M As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef NEQ As Integer, _
    <[In]()> ByVal YSAV As Double(,), _
    ByRef SDYSAV As Integer, _
    <[In]()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02NBF_FCN_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D02NBF_JAC_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByVal P_rptr As IntPtr _
  )

   Declare Sub D02NBZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByVal P_rptr As IntPtr _
  )

  Delegate Sub D02NBF_MONITR_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef T As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal YSAV_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal ACOR_rptr As IntPtr, _
    ByRef IMON As Integer, _
    ByRef INLN As Integer, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef NQU As Integer _
  )

   Declare Sub D02NBY Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef T As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal YSAV_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal ACOR_rptr As IntPtr, _
    ByRef IMON As Integer, _
    ByRef INLN As Integer, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef NQU As Integer _
  )

   Declare Sub D02NBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), ByVal FCN As D02NBF_FCN_DELEGATE, _
    <[In](),Out()> ByVal YSAV As Double(,), ByRef SDYSAV As Integer, ByVal JAC As D02NBF_JAC_DELEGATE, _
    <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, ByVal MONITR As D02NBF_MONITR_DELEGATE, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IFAIL As Integer _
   )






  Delegate Sub D02NCF_FCN_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D02NCF_JAC_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef ML As Integer, _
    ByRef MU As Integer, _
    ByVal P_rptr As IntPtr _
  )

   Declare Sub D02NCZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef ML As Integer, _
    ByRef MU As Integer, _
    ByVal P_rptr As IntPtr _
  )

  Delegate Sub D02NCF_MONITR_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef T As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal YSAV_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal ACOR_rptr As IntPtr, _
    ByRef IMON As Integer, _
    ByRef INLN As Integer, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef NQU As Integer _
  )


   Declare Sub D02NCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), ByVal FCN As D02NCF_FCN_DELEGATE, _
    <[In](),Out()> ByVal YSAV As Double(,), ByRef SDYSAV As Integer, ByVal JAC As D02NCF_JAC_DELEGATE, _
    <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, <[In](),Out()> ByVal JACPVT As Integer(), _
    ByRef NJCPVT As Integer, ByVal MONITR As D02NCF_MONITR_DELEGATE, ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, ByRef IFAIL As Integer _
   )




  Delegate Sub D02NDF_FCN_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D02NDF_JAC_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef J As Integer, _
    ByVal PDJ_rptr As IntPtr _
  )

   Declare Sub D02NDZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef J As Integer, _
    ByVal PDJ_rptr As IntPtr _
  )

  Delegate Sub D02NDF_MONITR_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef T As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal YSAV_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal ACOR_rptr As IntPtr, _
    ByRef IMON As Integer, _
    ByRef INLN As Integer, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef NQU As Integer _
  )


   Declare Sub D02NDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), ByVal FCN As D02NDF_FCN_DELEGATE, _
    <[In](),Out()> ByVal YSAV As Double(,), ByRef SDYSAV As Integer, ByVal JAC As D02NDF_JAC_DELEGATE, _
    <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, <[In](),Out()> ByVal JACPVT As Integer(), _
    ByRef NJCPVT As Integer, ByVal MONITR As D02NDF_MONITR_DELEGATE, ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, ByRef IFAIL As Integer _
   )




  Delegate Sub D02NEF_RES_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D02NEF_JAC_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal PD_rptr As IntPtr, _
    ByRef CJ As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D02NEZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal PD_rptr As IntPtr, _
    ByRef CJ As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D02NEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByRef TOUT As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    <[In](),Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RTOL As Double(), _
    <[In](),Out()> ByVal ATOL As Double(), _
    ByRef ITASK As Integer, _
    ByVal RES As D02NEF_RES_DELEGATE, _
    ByVal JAC As D02NEF_JAC_DELEGATE, _
    <[In](),Out()> ByVal ICOM As Integer(), _
    <[In](),Out()> ByVal COM As Double(), _
    ByRef LCOM As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )




  Delegate Sub D02NGF_RESID_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D02NGF_JAC_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByVal P_rptr As IntPtr _
  )

   Declare Sub D02NGZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByVal P_rptr As IntPtr _
  )

  Delegate Sub D02NGF_MONITR_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef T As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal YSAV_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal ACOR_rptr As IntPtr, _
    ByRef IMON As Integer, _
    ByRef INLN As Integer, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef NQU As Integer _
  )


   Declare Sub D02NGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <[In](),Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), ByVal RESID As D02NGF_RESID_DELEGATE, _
    <[In](),Out()> ByVal YSAV As Double(,), ByRef SDYSAV As Integer, ByVal JAC As D02NGF_JAC_DELEGATE, _
    <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, ByVal MONITR As D02NGF_MONITR_DELEGATE, _
    <[In](),Out()> ByVal LDERIV As Integer(), ByRef ITASK As Integer, ByRef ITRACE As Integer, _
    ByRef IFAIL As Integer _
   )




  Delegate Sub D02NHF_RESID_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D02NHF_JAC_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef ML As Integer, _
    ByRef MU As Integer, _
    ByVal P_rptr As IntPtr _
  )

   Declare Sub D02NHZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef ML As Integer, _
    ByRef MU As Integer, _
    ByVal P_rptr As IntPtr _
  )

  Delegate Sub D02NHF_MONITR_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef T As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal YSAV_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal ACOR_rptr As IntPtr, _
    ByRef IMON As Integer, _
    ByRef INLN As Integer, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef NQU As Integer _
  )


   Declare Sub D02NHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <[In](),Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), ByVal RESID As D02NHF_RESID_DELEGATE, _
    <[In](),Out()> ByVal YSAV As Double(,), ByRef SDYSAV As Integer, ByVal JAC As D02NHF_JAC_DELEGATE, _
    <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, <[In](),Out()> ByVal JACPVT As Integer(), _
    ByRef NJCPVT As Integer, ByVal MONITR As D02NHF_MONITR_DELEGATE, <[In](),Out()> ByVal LDERIV As Integer(), _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IFAIL As Integer _
   )




  Delegate Sub D02NJF_RESID_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D02NJF_JAC_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef J As Integer, _
    ByVal PDJ_rptr As IntPtr _
  )

   Declare Sub D02NJZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef T As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByRef H As Double, _
    ByRef D As Double, _
    ByRef J As Integer, _
    ByVal PDJ_rptr As IntPtr _
  )

  Delegate Sub D02NJF_MONITR_DELEGATE( _
    ByRef NEQ As Integer, _
    ByRef LDYSAV As Integer, _
    ByRef T As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YDOT_rptr As IntPtr, _
    ByVal YSAV_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal ACOR_rptr As IntPtr, _
    ByRef IMON As Integer, _
    ByRef INLN As Integer, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef NQU As Integer _
  )


   Declare Sub D02NJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <[In](),Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), ByVal RESID As D02NJF_RESID_DELEGATE, _
    <[In](),Out()> ByVal YSAV As Double(,), ByRef SDYSAV As Integer, ByVal JAC As D02NJF_JAC_DELEGATE, _
    <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, <[In](),Out()> ByVal JACPVT As Integer(), _
    ByRef NJCPVT As Integer, ByVal MONITR As D02NJF_MONITR_DELEGATE, <[In](),Out()> ByVal LDERIV As Integer(), _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IFAIL As Integer _
   )




   Declare Sub D02NMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <[In](),Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), <[In](),Out()> ByVal YSAV As Double(,), _
    ByRef SDYSAV As Integer, <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, _
    <[In](),Out()> ByVal JACPVT As Integer(), ByRef NJCPVT As Integer, ByRef IMON As Integer, _
    ByRef INLN As Integer, ByRef IRES As Integer, ByRef IREVCM As Integer, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IFAIL As Integer _
   )


   Declare Sub D02NNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, ByRef LDYSAV As Integer, ByRef T As Double, _
    ByRef TOUT As Double, <[In](),Out()> ByVal Y As Double(), <[In](),Out()> ByVal YDOT As Double(), _
    <[In](),Out()> ByVal RWORK As Double(), <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), _
    ByRef ITOL As Integer, <[In](),Out()> ByVal INFORM As Integer(), <[In](),Out()> ByVal YSAV As Double(,), _
    ByRef SDYSAV As Integer, <[In](),Out()> ByVal WKJAC As Double(), ByRef NWKJAC As Integer, _
    <[In](),Out()> ByVal JACPVT As Integer(), ByRef NJCPVT As Integer, ByRef IMON As Integer, _
    ByRef INLN As Integer, ByRef IRES As Integer, ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal LDERIV As Integer(), ByRef ITASK As Integer, ByRef ITRACE As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02NPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef ML As Integer, _
    ByRef MU As Integer, _
    <[In](),Out()> ByVal ICOM As Integer(), _
    ByRef LICOM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02NRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef J As Integer, _
    ByRef IPLACE As Integer, _
    <[In]()> ByVal INFORM As Integer() _
   )


   Declare Sub D02NSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef NEQMAX As Integer, _
    ByVal JCEVAL As string, _
    ByRef NWKJAC As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal JCEVALLength As long _
    )


   Declare Sub D02NTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef NEQMAX As Integer, _
    ByVal JCEVAL As string, _
    ByRef ML As Integer, _
    ByRef MU As Integer, _
    ByRef NWKJAC As Integer, _
    ByRef NJCPVT As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal JCEVALLength As long _
    )


   Declare Sub D02NUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef NEQMAX As Integer, _
    ByVal JCEVAL As string, _
    ByRef NWKJAC As Integer, _
    <[In]()> ByVal IA As Integer(), _
    ByRef NIA As Integer, _
    <[In]()> ByVal JA As Integer(), _
    ByRef NJA As Integer, _
    <Out()> ByVal JACPVT As Integer(), _
    ByRef NJCPVT As Integer, _
    ByRef SENS As Double, _
    ByRef U As Double, _
    ByRef ETA As Double, _
    ByRef LBLOCK As Integer, _
    ByRef ISPLIT As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal JCEVALLength As long _
    )


   Declare Sub D02NVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQMAX As Integer, _
    ByRef SDYSAV As Integer, _
    ByRef MAXORD As Integer, _
    ByVal METHOD As string, _
    ByRef PETZLD As Integer, _
    <[In](),Out()> ByVal CON As Double(), _
    ByRef TCRIT As Double, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef H0 As Double, _
    ByRef MAXSTP As Integer, _
    ByRef MXHNIL As Integer, _
    ByVal NORM As string, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal NORMLength As long _
    )


   Declare Sub D02NWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQMAX As Integer, _
    ByRef SDYSAV As Integer, _
    ByRef MAXORD As Integer, _
    <[In](),Out()> ByVal CON As Double(), _
    ByRef TCRIT As Double, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef H0 As Double, _
    ByRef MAXSTP As Integer, _
    ByRef MXHNIL As Integer, _
    ByVal NORM As string, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub D02NXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ICALL As Integer, _
    ByRef LIWREQ As Integer, _
    ByRef LIWUSD As Integer, _
    ByRef LRWREQ As Integer, _
    ByRef LRWUSD As Integer, _
    ByRef NLU As Integer, _
    ByRef NNZ As Integer, _
    ByRef NGP As Integer, _
    ByRef ISPLIT As Integer, _
    ByRef IGROW As Integer, _
    ByRef LBLOCK As Integer, _
    ByRef NBLOCK As Integer, _
    <[In]()> ByVal INFORM As Integer() _
   )


   Declare Sub D02NYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    ByRef NEQMAX As Integer, _
    ByRef HU As Double, _
    ByRef H As Double, _
    ByRef TCUR As Double, _
    ByRef TOLSF As Double, _
    <[In]()> ByVal RWORK As Double(), _
    ByRef NST As Integer, _
    ByRef NRE As Integer, _
    ByRef NJE As Integer, _
    ByRef NQU As Integer, _
    ByRef NQ As Integer, _
    ByRef NITER As Integer, _
    ByRef IMXER As Integer, _
    <Out()> ByVal ALGEQU As Integer(), _
    <[In]()> ByVal INFORM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02NZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQMAX As Integer, _
    ByRef TCRIT As Double, _
    ByRef H As Double, _
    ByRef HMIN As Double, _
    ByRef HMAX As Double, _
    ByRef MAXSTP As Integer, _
    ByRef MXHNIL As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02PEF_F_DELEGATE( _
    ByRef T As Double, _
    ByRef N As Integer, _
    ByVal Y_rptr As IntPtr, _
    ByVal YP_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D02PEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D02PEF_F_DELEGATE, _
    ByRef N As Integer, _
    ByRef TWANT As Double, _
    ByRef TGOT As Double, _
    <[In](),Out()> ByVal YGOT As Double(), _
    <Out()> ByVal YPGOT As Double(), _
    <[In](),Out()> ByVal YMAX As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02PFF_F_DELEGATE( _
    ByRef T As Double, _
    ByRef N As Integer, _
    ByVal Y_rptr As IntPtr, _
    ByVal YP_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D02PFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal F As D02PFF_F_DELEGATE, _
    ByRef N As Integer, _
    ByRef TNOW As Double, _
    <Out()> ByVal YNOW As Double(), _
    <Out()> ByVal YPNOW As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02PGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef N As Integer, _
    ByRef T As Double, _
    <Out()> ByVal Y As Double(), _
    <[In]()> ByVal YP As Double(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02PHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef N As Integer, _
    ByRef NWANT As Integer, _
    ByRef T As Double, _
    <Out()> ByVal Y As Double(), _
    <[In]()> ByVal YP As Double(), _
    <[In](),Out()> ByVal WCOMM As Double(), _
    ByRef LWCOMM As Integer, _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02PJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ICHECK As Integer, _
    ByRef N As Integer, _
    ByRef NWANT As Integer, _
    ByRef T As Double, _
    ByRef IDERIV As Integer, _
    <Out()> ByVal SOL As Double(), _
    <[In](),Out()> ByVal WCOMM As Double(), _
    ByRef LWCOMM As Integer, _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02PQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef TSTART As Double, _
    ByRef TEND As Double, _
    <[In]()> ByVal YINIT As Double(), _
    ByRef TOL As Double, _
    <[In]()> ByVal THRESH As Double(), _
    ByRef METHOD As Integer, _
    ByRef HSTART As Double, _
    <Out()> ByVal IWSAV As Integer(), _
    <Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02PRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef TENDNU As Double, _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02PSF_F_DELEGATE( _
    ByRef T As Double, _
    ByRef N As Integer, _
    ByVal Y_rptr As IntPtr, _
    ByVal YP_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D02PSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef TWANT As Double, _
    ByRef IDERIV As Integer, _
    ByRef NWANT As Integer, _
    <Out()> ByVal YWANT As Double(), _
    <Out()> ByVal YPWANT As Double(), _
    ByVal F As D02PSF_F_DELEGATE, _
    <[In](),Out()> ByVal WCOMM As Double(), _
    ByRef LWCOMM As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02PTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef FEVALS As Integer, _
    ByRef STEPCOST As Integer, _
    ByRef WASTE As Double, _
    ByRef STEPSOK As Integer, _
    ByRef HNEXT As Double, _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In]()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02PUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <Out()> ByVal RMSERR As Double(), _
    ByRef ERRMAX As Double, _
    ByRef TERRMX As Double, _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02QFF_FCN_DELEGATE( _
    ByRef NEQF As Integer, _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr _
  )

  Delegate Function D02QFF_G_DELEGATE( _
    ByRef NEQF As Integer, _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YP_rptr As IntPtr, _
    ByRef K As Integer _
  ) as Double

   Declare Function D02QFZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQF As Integer, _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal YP_rptr As IntPtr, _
    ByRef K As Integer _
  ) as Double

   Declare Sub D02QFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FCN As D02QFF_FCN_DELEGATE, _
    ByRef NEQF As Integer, _
    ByRef T As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef TOUT As Double, _
    ByVal G As D02QFF_G_DELEGATE, _
    ByRef NEQG As Integer, _
    ByRef ROOT As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <[In](),Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02QGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQF As Integer, _
    ByRef T As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef TOUT As Double, _
    ByRef NEQG As Integer, _
    ByRef ROOT As Integer, _
    ByRef IREVCM As Integer, _
    ByRef TRVCM As Double, _
    ByRef YRVCM As Integer, _
    ByRef YPRVCM As Integer, _
    ByRef GRVCM As Double, _
    ByRef KGRVCM As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <[In](),Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02QWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STATEF As string, ByRef NEQF As Integer, ByRef VECTOL As Integer, _
    <[In]()> ByVal ATOL As Double(), ByRef LATOL As Integer, <[In]()> ByVal RTOL As Double(), _
    ByRef LRTOL As Integer, ByRef ONESTP As Integer, ByRef CRIT As Integer, _
    ByRef TCRIT As Double, ByRef HMAX As Double, ByRef MAXSTP As Integer, _
    ByRef NEQG As Integer, ByRef ALTERG As Integer, ByRef SOPHST As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), ByRef LRWORK As Integer, <[In](),Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef IFAIL As Integer, _
    ByVal STATEFLength As long _
    )


   Declare Sub D02QXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQF As Integer, _
    <Out()> ByVal YP As Double(), _
    ByRef TCURR As Double, _
    ByRef HLAST As Double, _
    ByRef HNEXT As Double, _
    ByRef ODLAST As Integer, _
    ByRef ODNEXT As Integer, _
    ByRef NSUCC As Integer, _
    ByRef NFAIL As Integer, _
    ByRef TOLFAC As Double, _
    ByRef BADCMP As Integer, _
    <[In]()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <[In]()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02QYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQG As Integer, _
    ByRef INDEX As Integer, _
    ByRef ITYPE As Integer, _
    <Out()> ByVal EVENTS As Integer(), _
    <Out()> ByVal RESIDS As Double(), _
    <[In]()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <[In]()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02QZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQF As Integer, _
    ByRef TWANT As Double, _
    ByRef NWANT As Integer, _
    <Out()> ByVal YWANT As Double(), _
    <Out()> ByVal YPWANT As Double(), _
    <[In]()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <[In]()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02RAF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByRef EPS As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef N As Integer _
  )

  Delegate Sub D02RAF_G_DELEGATE( _
    ByRef EPS As Double, _
    ByVal YA_rptr As IntPtr, _
    ByVal YB_rptr As IntPtr, _
    ByVal BC_rptr As IntPtr, _
    ByRef N As Integer _
  )

  Delegate Sub D02RAF_JACOBF_DELEGATE( _
    ByRef X As Double, _
    ByRef EPS As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef N As Integer _
  )


  Delegate Sub D02RAF_JACOBG_DELEGATE( _
    ByRef EPS As Double, _
    ByVal YA_rptr As IntPtr, _
    ByVal YB_rptr As IntPtr, _
    ByVal AJ_rptr As IntPtr, _
    ByVal BJ_rptr As IntPtr, _
    ByRef N As Integer _
  )


  Delegate Sub D02RAF_JACEPS_DELEGATE( _
    ByRef X As Double, _
    ByRef EPS As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef N As Integer _
  )


  Delegate Sub D02RAF_JACGEP_DELEGATE( _
    ByRef EPS As Double, _
    ByVal YA_rptr As IntPtr, _
    ByVal YB_rptr As IntPtr, _
    ByVal BCEP_rptr As IntPtr, _
    ByRef N As Integer _
  )


   Declare Sub D02RAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef MNP As Integer, ByRef NP As Integer, _
    ByRef NUMBEG As Integer, ByRef NUMMIX As Integer, ByRef TOL As Double, _
    ByRef INIT As Integer, <[In](),Out()> ByVal X As Double(), <[In](),Out()> ByVal Y As Double(,), _
    ByRef LDY As Integer, <Out()> ByVal ABT As Double(), ByVal FCN As D02RAF_FCN_DELEGATE, _
    ByVal G As D02RAF_G_DELEGATE, ByRef IJAC As Integer, ByVal JACOBF As D02RAF_JACOBF_DELEGATE, _
    ByVal JACOBG As D02RAF_JACOBG_DELEGATE, ByRef DELEPS As Double, ByVal JACEPS As D02RAF_JACEPS_DELEGATE, _
    ByVal JACGEP As D02RAF_JACGEP_DELEGATE, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, ByRef IFAIL As Integer _
   )


  Delegate Sub D02SAF_RANGE_DELEGATE( _
    ByVal X_rptr As IntPtr, _
    ByRef NPOINT As Integer, _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer _
  )

  Delegate Sub D02SAF_BC_DELEGATE( _
    ByVal G1_rptr As IntPtr, _
    ByVal G2_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer, _
    ByRef N As Integer _
  )

  Delegate Sub D02SAF_FCN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef N As Integer, _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer, _
    ByRef I As Integer _
  )

  Delegate Sub D02SAF_EQN_DELEGATE( _
    ByVal E_rptr As IntPtr, _
    ByRef Q As Integer, _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer _
  )


  Delegate Function D02SAF_CONSTR_DELEGATE( _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer _
  ) as Integer

   Declare Function D02HBY Lib "NLW6I31DE_nag.dll" ( _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer _
  ) as Integer

  Delegate Sub D02SAF_MONIT_DELEGATE( _
    ByRef ISTATE As Integer, _
    ByRef IFLAG As Integer, _
    ByRef IFAIL1 As Integer, _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer, _
    ByVal F_rptr As IntPtr, _
    ByRef PNORM As Double, _
    ByRef PNORM1 As Double, _
    ByRef EPS As Double, _
    ByVal D_rptr As IntPtr _
  )

   Declare Sub D02SAS Lib "NLW6I31DE_nag.dll" ( _
    ByRef ISTATE As Integer, _
    ByRef IFLAG As Integer, _
    ByRef IFAIL1 As Integer, _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer, _
    ByVal F_rptr As IntPtr, _
    ByRef PNORM As Double, _
    ByRef PNORM1 As Double, _
    ByRef EPS As Double, _
    ByVal D_rptr As IntPtr _
  )

   Declare Sub D02HBX Lib "NLW6I31DE_nag.dll" ( _
    ByRef ISTATE As Integer, _
    ByRef IFLAG As Integer, _
    ByRef IFAIL1 As Integer, _
    ByVal P_rptr As IntPtr, _
    ByRef M As Integer, _
    ByVal F_rptr As IntPtr, _
    ByRef PNORM As Double, _
    ByRef PNORM1 As Double, _
    ByRef EPS As Double, _
    ByVal D_rptr As IntPtr _
  )

  Delegate Sub D02SAF_PRSOL_DELEGATE( _
    ByRef Z As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef N As Integer _
  )


   Declare Sub D02SAF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal P As Double(), ByRef M As Integer, ByRef N As Integer, _
    ByRef N1 As Integer, <[In]()> ByVal PE As Double(), <[In](),Out()> ByVal PF As Double(), _
    <[In]()> ByVal E As Double(), <[In](),Out()> ByVal DP As Double(), ByRef NPOINT As Integer, _
    <[In](),Out()> ByVal SWP As Double(,), ByRef LDSWP As Integer, ByRef ICOUNT As Integer, _
    ByVal RANGE As D02SAF_RANGE_DELEGATE, ByVal BC As D02SAF_BC_DELEGATE, ByVal FCN As D02SAF_FCN_DELEGATE, _
    ByVal EQN As D02SAF_EQN_DELEGATE, ByVal CONSTR As D02SAF_CONSTR_DELEGATE, ByRef YMAX As Double, _
    ByVal MONIT As D02SAF_MONIT_DELEGATE, ByVal PRSOL As D02SAF_PRSOL_DELEGATE, <Out()> ByVal W As Double(,), _
    ByRef LDW As Integer, ByRef SDW As Integer, ByRef IFAIL As Integer _
   )




  Delegate Sub D02TGF_COEFF_DELEGATE( _
    ByRef X As Double, _
    ByRef I As Integer, _
    ByVal A_rptr As IntPtr, _
    ByRef IA As Integer, _
    ByRef IA1 As Integer, _
    ByRef RHS As Double _
  )

  Delegate Sub D02TGF_BDYC_DELEGATE( _
    ByRef X As Double, _
    ByRef I As Integer, _
    ByRef J As Integer, _
    ByVal A_rptr As IntPtr, _
    ByRef IA As Integer, _
    ByRef IA1 As Integer, _
    ByRef RHS As Double _
  )

   Declare Sub D02TGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal M As Integer(), _
    <[In]()> ByVal L As Integer(), _
    ByRef X0 As Double, _
    ByRef X1 As Double, _
    ByRef K1 As Integer, _
    ByRef KP As Integer, _
    <Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal COEFF As D02TGF_COEFF_DELEGATE, _
    ByVal BDYC As D02TGF_BDYC_DELEGATE, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D02TLF_FFUN_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef NEQ As Integer, _
    ByVal M_iptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D02TLF_FJAC_DELEGATE( _
    ByRef X As Double, _
    ByVal Y_rptr As IntPtr, _
    ByRef NEQ As Integer, _
    ByVal M_iptr As IntPtr, _
    ByVal DFDY_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D02TLF_GAFUN_DELEGATE( _
    ByVal YA_rptr As IntPtr, _
    ByRef NEQ As Integer, _
    ByVal M_iptr As IntPtr, _
    ByRef NLBC As Integer, _
    ByVal GA_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D02TLF_GBFUN_DELEGATE( _
    ByVal YB_rptr As IntPtr, _
    ByRef NEQ As Integer, _
    ByVal M_iptr As IntPtr, _
    ByRef NRBC As Integer, _
    ByVal GB_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D02TLF_GAJAC_DELEGATE( _
    ByVal YA_rptr As IntPtr, _
    ByRef NEQ As Integer, _
    ByVal M_iptr As IntPtr, _
    ByRef NLBC As Integer, _
    ByVal DGADY_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D02TLF_GBJAC_DELEGATE( _
    ByVal YB_rptr As IntPtr, _
    ByRef NEQ As Integer, _
    ByVal M_iptr As IntPtr, _
    ByRef NRBC As Integer, _
    ByVal DGBDY_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D02TLF_GUESS_DELEGATE( _
    ByRef X As Double, _
    ByRef NEQ As Integer, _
    ByVal M_iptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal DYM_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D02TLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FFUN As D02TLF_FFUN_DELEGATE, _
    ByVal FJAC As D02TLF_FJAC_DELEGATE, _
    ByVal GAFUN As D02TLF_GAFUN_DELEGATE, _
    ByVal GBFUN As D02TLF_GBFUN_DELEGATE, _
    ByVal GAJAC As D02TLF_GAJAC_DELEGATE, _
    ByVal GBJAC As D02TLF_GBJAC_DELEGATE, _
    ByVal GUESS As D02TLF_GUESS_DELEGATE, _
    <[In](),Out()> ByVal RCOMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02TVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    <[In]()> ByVal M As Integer(), _
    ByRef NLBC As Integer, _
    ByRef NRBC As Integer, _
    ByRef NCOL As Integer, _
    <[In]()> ByVal TOLS As Double(), _
    ByRef MXMESH As Integer, _
    ByRef NMESH As Integer, _
    <[In]()> ByVal MESH As Double(), _
    <[In]()> ByVal IPMESH As Integer(), _
    <Out()> ByVal RCOMM As Double(), _
    ByRef LRCOMM As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02TXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MXMESH As Integer, _
    ByRef NMESH As Integer, _
    <[In]()> ByVal MESH As Double(), _
    <[In]()> ByVal IPMESH As Integer(), _
    <[In](),Out()> ByVal RCOMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02TYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    <Out()> ByVal Y As Double(,), _
    ByRef NEQ As Integer, _
    ByRef MMAX As Integer, _
    <[In](),Out()> ByVal RCOMM As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02TZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MXMESH As Integer, _
    ByRef NMESH As Integer, _
    <Out()> ByVal MESH As Double(), _
    <Out()> ByVal IPMESH As Integer(), _
    ByRef ERMX As Double, _
    ByRef IERMX As Integer, _
    ByRef IJERMX As Integer, _
    <[In]()> ByVal RCOMM As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal F As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef Q As Integer, _
    <[In]()> ByVal C As Double(), _
    <Out()> ByVal F As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    <Out()> ByVal X As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal F As Double(), _
    <Out()> ByVal FD As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef M As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In](),Out()> ByVal BMAT As Double(,), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal BVEC As Double(), _
    <[In](),Out()> ByVal F As Double(), _
    <Out()> ByVal UC As Double(,), _
    ByRef RESID As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NIP As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal F As Double(), _
    <Out()> ByVal XIP As Double(), _
    <Out()> ByVal FIP As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02UZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef K As Integer, _
    ByRef X As Double, _
    ByRef T As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02XJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XSOL As Double, _
    <Out()> ByVal SOL As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal YSAV As Double(,), _
    ByRef LDYSAV As Integer, _
    ByRef SDYSAV As Integer, _
    ByRef NEQ As Integer, _
    ByRef X As Double, _
    ByRef NQU As Integer, _
    ByRef HU As Double, _
    ByRef H As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D02XKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XSOL As Double, _
    <Out()> ByVal SOL As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal YSAV As Double(,), _
    ByRef LDYSAV As Integer, _
    ByRef SDYSAV As Integer, _
    <[In]()> ByVal ACOR As Double(), _
    ByRef NEQ As Integer, _
    ByRef X As Double, _
    ByRef NQU As Integer, _
    ByRef HU As Double, _
    ByRef H As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Function D02ZAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEQ As Integer, _
    <[In]()> ByVal V As Double(), _
    <[In]()> ByVal W As Double(), _
    ByRef IFAIL As Integer _
   ) as Double


' chapter d03

   Declare Sub D03EAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef STAGE1 As Integer, _
    ByRef EXT As Integer, _
    ByRef DORM As Integer, _
    ByRef N As Integer, _
    ByRef P As Double, _
    ByRef Q As Double, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    ByRef N1P1 As Integer, _
    <[In](),Out()> ByVal PHI As Double(), _
    <[In](),Out()> ByVal PHID As Double(), _
    ByRef ALPHA As Double, _
    <Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByRef NP4 As Integer, _
    <Out()> ByVal ICINT As Integer(), _
    ByRef NP1 As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03EBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, ByRef N2 As Integer, ByRef LDA As Integer, _
    <[In]()> ByVal A As Double(,), <[In]()> ByVal B As Double(,), <[In]()> ByVal C As Double(,), _
    <[In]()> ByVal D As Double(,), <[In]()> ByVal E As Double(,), <[In]()> ByVal Q As Double(,), _
    <[In](),Out()> ByVal T As Double(,), ByRef APARAM As Double, ByRef ITMAX As Integer, _
    ByRef ITCOUN As Integer, ByRef ITUSED As Integer, ByRef NDIR As Integer, _
    ByRef IXN As Integer, ByRef IYN As Integer, ByRef CONRES As Double, _
    ByRef CONCHN As Double, <Out()> ByVal RESIDS As Double(), <Out()> ByVal CHNGS As Double(), _
    <Out()> ByVal WRKSP1 As Double(,), <Out()> ByVal WRKSP2 As Double(,), <Out()> ByVal WRKSP3 As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03ECF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, ByRef N2 As Integer, ByRef N3 As Integer, _
    ByRef LDA As Integer, ByRef SDA As Integer, <[In]()> ByVal A As Double(,,), _
    <[In]()> ByVal B As Double(,,), <[In]()> ByVal C As Double(,,), <[In]()> ByVal D As Double(,,), _
    <[In]()> ByVal E As Double(,,), <[In]()> ByVal F As Double(,,), <[In]()> ByVal G As Double(,,), _
    <[In]()> ByVal Q As Double(,,), <[In](),Out()> ByVal T As Double(,,), ByRef APARAM As Double, _
    ByRef ITMAX As Integer, ByRef ITCOUN As Integer, ByRef ITUSED As Integer, _
    ByRef NDIR As Integer, ByRef IXN As Integer, ByRef IYN As Integer, _
    ByRef IZN As Integer, ByRef CONRES As Double, ByRef CONCHN As Double, _
    <Out()> ByVal RESIDS As Double(), <Out()> ByVal CHNGS As Double(), <Out()> ByVal WRKSP1 As Double(,,), _
    <Out()> ByVal WRKSP2 As Double(,,), <Out()> ByVal WRKSP3 As Double(,,), <Out()> ByVal WRKSP4 As Double(,,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03EDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NGX As Integer, _
    ByRef NGY As Integer, _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    <[In](),Out()> ByVal RHS As Double(), _
    <[In](),Out()> ByVal UB As Double(), _
    ByRef MAXIT As Integer, _
    ByRef ACC As Double, _
    <Out()> ByVal US As Double(), _
    <Out()> ByVal U As Double(), _
    ByRef IOUT As Integer, _
    ByRef NUMIT As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D03EEF_PDEF_DELEGATE( _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByRef ALPHA As Double, _
    ByRef BETA As Double, _
    ByRef GAMMA As Double, _
    ByRef DELTA As Double, _
    ByRef EPSLON As Double, _
    ByRef PHI As Double, _
    ByRef PSI As Double _
  )

  Delegate Sub D03EEF_BNDY_DELEGATE( _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef IBND As Integer _
  )

   Declare Sub D03EEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    ByRef YMIN As Double, _
    ByRef YMAX As Double, _
    ByVal PDEF As D03EEF_PDEF_DELEGATE, _
    ByVal BNDY As D03EEF_BNDY_DELEGATE, _
    ByRef NGX As Integer, _
    ByRef NGY As Integer, _
    ByRef LDA As Integer, _
    <Out()> ByVal A As Double(,), _
    <Out()> ByVal RHS As Double(), _
    ByVal SCHEME As string, _
    ByRef IFAIL As Integer, _
    ByVal SCHEMELength As long _
    )


   Declare Sub D03FAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XS As Double, ByRef XF As Double, ByRef L As Integer, _
    ByRef LBDCND As Integer, <[In]()> ByVal BDXS As Double(,), <[In]()> ByVal BDXF As Double(,), _
    ByRef YS As Double, ByRef YF As Double, ByRef M As Integer, _
    ByRef MBDCND As Integer, <[In]()> ByVal BDYS As Double(,), <[In]()> ByVal BDYF As Double(,), _
    ByRef ZS As Double, ByRef ZF As Double, ByRef N As Integer, _
    ByRef NBDCND As Integer, <[In]()> ByVal BDZS As Double(,), <[In]()> ByVal BDZF As Double(,), _
    ByRef LAMBDA As Double, ByRef LDF As Integer, ByRef LDF2 As Integer, _
    <[In](),Out()> ByVal F As Double(,,), ByRef PERTRB As Double, <Out()> ByVal W As Double(), _
    ByRef LWRK As Integer, ByRef IFAIL As Integer _
   )


  Delegate Function D03MAF_ISIN_DELEGATE( _
    ByRef X As Double, _
    ByRef Y As Double _
  ) as Integer

   Declare Sub D03MAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef H As Double, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NB As Integer, _
    ByRef NPTS As Integer, _
    <Out()> ByVal PLACES As Double(,), _
    <Out()> ByVal INDX As Integer(,), _
    ByRef SDINDX As Integer, _
    ByVal ISIN As D03MAF_ISIN_DELEGATE, _
    <Out()> ByVal DIST As Double(,), _
    ByRef SDDIST As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03NCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef KOPT As Integer, ByRef X As Double, ByVal MESH As string, _
    ByRef NS As Integer, <[In](),Out()> ByVal S As Double(), ByRef NT As Integer, _
    <[In](),Out()> ByVal T As Double(), <[In]()> ByVal TDPAR As Integer(), <[In]()> ByVal R As Double(), _
    <[In]()> ByVal Q As Double(), <[In]()> ByVal SIGMA As Double(), ByRef ALPHA As Double, _
    ByRef NTKEEP As Integer, <Out()> ByVal F As Double(,), <Out()> ByVal THETA As Double(,), _
    <Out()> ByVal DELTA As Double(,), <Out()> ByVal GAMMA As Double(,), <Out()> ByVal LAMBDA As Double(,), _
    <Out()> ByVal RHO As Double(,), ByRef LDF As Integer, <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef IFAIL As Integer, _
    ByVal MESHLength As long _
    )


   Declare Sub D03NDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef KOPT As Integer, _
    ByRef X As Double, _
    ByRef S As Double, _
    ByRef T As Double, _
    ByRef TMAT As Double, _
    <[In]()> ByVal TDPAR As Integer(), _
    <[In]()> ByVal R As Double(), _
    <[In]()> ByVal Q As Double(), _
    <[In]()> ByVal SIGMA As Double(), _
    ByRef F As Double, _
    ByRef THETA As Double, _
    ByRef DELTA As Double, _
    ByRef GAMMA As Double, _
    ByRef LAMBDA As Double, _
    ByRef RHO As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03NEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef T0 As Double, _
    ByRef TMAT As Double, _
    ByRef NTD As Integer, _
    <[In]()> ByVal TD As Double(), _
    <[In]()> ByVal PHID As Double(), _
    <Out()> ByVal PHIAV As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D03PCA_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PCA_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D03PCA Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PCA_PDEDEF_DELEGATE, ByVal BNDARY As D03PCA_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(,), ByRef NPTS As Integer, <[In]()> ByVal X As Double(), _
    ByRef ACC As Double, <[In](),Out()> ByVal RSAVE As Double(), ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, ByRef IND As Integer, <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), ByVal CWSAV As string, <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer, _
    ByVal CWSAVLength As long _
    )

  Delegate Sub D03PCF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PCF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

   Declare Sub D03PCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef M As Integer, _
    ByRef TS As Double, _
    ByRef TOUT As Double, _
    ByVal PDEDEF As D03PCF_PDEDEF_DELEGATE, _
    ByVal BNDARY As D03PCF_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(,), _
    ByRef NPTS As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef ACC As Double, _
    <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), _
    ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, _
    ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D53PCK Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    <[In]()> ByVal V As Double(), _
    <[In]()> ByVal VDOT As Double(), _
    ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), _
    <[In]()> ByVal UCP As Double(,), _
    <[In]()> ByVal UCPX As Double(,), _
    <[In]()> ByVal RCP As Double(,), _
    <[In]()> ByVal UCPT As Double(,), _
    <[In]()> ByVal UCPTX As Double(,), _
    <Out()> ByVal F As Double(), _
    ByRef IRES As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double() _
   )

   Declare Sub D03PCK Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    <[In]()> ByVal V As Double(), _
    <[In]()> ByVal VDOT As Double(), _
    ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), _
    <[In]()> ByVal UCP As Double(,), _
    <[In]()> ByVal UCPX As Double(,), _
    <[In]()> ByVal RCP As Double(,), _
    <[In]()> ByVal UCPT As Double(,), _
    <[In]()> ByVal UCPTX As Double(,), _
    <Out()> ByVal F As Double(), _
    ByRef IRES As Integer _
   )


   Declare Sub D53PCL Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Double, _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal U As Double(,), _
    <[In]()> ByVal R As Double(,), _
    <Out()> ByVal FMON As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double() _
   )

   Declare Sub D03PCL Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Double, _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal U As Double(,), _
    <[In]()> ByVal R As Double(,), _
    <Out()> ByVal FMON As Double() _
   )


  Delegate Sub D03PDA_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByRef NPTL As Integer, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PDA_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PDA_UINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D03PDA Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PDA_PDEDEF_DELEGATE, ByVal BNDARY As D03PDA_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(,), ByRef NBKPTS As Integer, <[In]()> ByVal XBKPTS As Double(), _
    ByRef NPOLY As Integer, ByRef NPTS As Integer, <Out()> ByVal X As Double(), _
    ByVal UINIT As D03PDA_UINIT_DELEGATE, ByRef ACC As Double, <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IND As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), ByVal CWSAV As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer, _
    ByVal CWSAVLength As long _
    )

  Delegate Sub D03PDF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByRef NPTL As Integer, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PDF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PDF_UINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr _
  )

   Declare Sub D03PDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PDF_PDEDEF_DELEGATE, ByVal BNDARY As D03PDF_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(,), ByRef NBKPTS As Integer, <[In]()> ByVal XBKPTS As Double(), _
    ByRef NPOLY As Integer, ByRef NPTS As Integer, <Out()> ByVal X As Double(), _
    ByVal UINIT As D03PDF_UINIT_DELEGATE, ByRef ACC As Double, <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D03PEF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PEF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef IBND As Integer, _
    ByRef NOBC As Integer, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

   Declare Sub D03PEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef TS As Double, _
    ByRef TOUT As Double, _
    ByVal PDEDEF As D03PEF_PDEDEF_DELEGATE, _
    ByVal BNDARY As D03PEF_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(,), _
    ByRef NPTS As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef NLEFT As Integer, _
    ByRef ACC As Double, _
    <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), _
    ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, _
    ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03PEK Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    <[In]()> ByVal V As Double(), _
    <[In]()> ByVal VDOT As Double(), _
    ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), _
    <[In]()> ByVal UCP As Double(,), _
    <[In]()> ByVal UCPX As Double(,), _
    <[In]()> ByVal UCPT As Double(,), _
    <Out()> ByVal R As Double(), _
    ByRef IRES As Integer _
   )


   Declare Sub D03PEL Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Double, _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal U As Double(,), _
    <Out()> ByVal FMON As Double() _
   )


  Delegate Sub D03PFF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal D_rptr As IntPtr, _
    ByVal S_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

   Declare Sub D03PFP Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal D_rptr As IntPtr, _
    ByVal S_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PFF_NUMFLX_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal ULEFT_rptr As IntPtr, _
    ByVal URIGHT_rptr As IntPtr, _
    ByVal FLUX_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PFF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal G_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

   Declare Sub D03PFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef TS As Double, _
    ByRef TOUT As Double, _
    ByVal PDEDEF As D03PFF_PDEDEF_DELEGATE, _
    ByVal NUMFLX As D03PFF_NUMFLX_DELEGATE, _
    ByVal BNDARY As D03PFF_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(,), _
    ByRef NPTS As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal ACC As Double(), _
    ByRef TSMAX As Double, _
    <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), _
    ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, _
    ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D03PHA_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PHA_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PHA_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal RCP_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal UCPTX_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


   Declare Sub D03PHA Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PHA_PDEDEF_DELEGATE, ByVal BNDARY As D03PHA_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(), ByRef NPTS As Integer, <[In]()> ByVal X As Double(), _
    ByRef NV As Integer, ByVal ODEDEF As D03PHA_ODEDEF_DELEGATE, ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, <[In]()> ByVal RTOL As Double(), _
    <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, ByVal NORM As string, _
    ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IND As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), ByVal CWSAV As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long, _
    ByVal CWSAVLength As long _
    )

  Delegate Sub D03PHF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PHF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PHF_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal RCP_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal UCPTX_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


   Declare Sub D03PHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PHF_PDEDEF_DELEGATE, ByVal BNDARY As D03PHF_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(), ByRef NPTS As Integer, <[In]()> ByVal X As Double(), _
    ByRef NV As Integer, ByVal ODEDEF As D03PHF_ODEDEF_DELEGATE, ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, <[In]()> ByVal RTOL As Double(), _
    <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, ByVal NORM As string, _
    ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IND As Integer, _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long _
    )


  Delegate Sub D03PJA_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByRef NPTL As Integer, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PJA_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PJA_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal RCP_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal UCPTX_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


  Delegate Sub D03PJA_UVINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub D03PJA Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PJA_PDEDEF_DELEGATE, ByVal BNDARY As D03PJA_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(), ByRef NBKPTS As Integer, <[In]()> ByVal XBKPTS As Double(), _
    ByRef NPOLY As Integer, ByRef NPTS As Integer, <Out()> ByVal X As Double(), _
    ByRef NV As Integer, ByVal ODEDEF As D03PJA_ODEDEF_DELEGATE, ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, ByVal UVINIT As D03PJA_UVINIT_DELEGATE, _
    <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, _
    ByVal NORM As string, ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), _
    <[In](),Out()> ByVal RSAVE As Double(), ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), _
    ByRef LISAVE As Integer, ByRef ITASK As Integer, ByRef ITRACE As Integer, _
    ByRef IND As Integer, <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    ByVal CWSAV As string, <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long, _
    ByVal CWSAVLength As long _
    )

  Delegate Sub D03PJF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByRef NPTL As Integer, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PJF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PJF_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal RCP_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal UCPTX_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


  Delegate Sub D03PJF_UVINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr _
  )

   Declare Sub D03PJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PJF_PDEDEF_DELEGATE, ByVal BNDARY As D03PJF_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(), ByRef NBKPTS As Integer, <[In]()> ByVal XBKPTS As Double(), _
    ByRef NPOLY As Integer, ByRef NPTS As Integer, <Out()> ByVal X As Double(), _
    ByRef NV As Integer, ByVal ODEDEF As D03PJF_ODEDEF_DELEGATE, ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, ByVal UVINIT As D03PJF_UVINIT_DELEGATE, _
    <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, _
    ByVal NORM As string, ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), _
    <[In](),Out()> ByVal RSAVE As Double(), ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), _
    ByRef LISAVE As Integer, ByRef ITASK As Integer, ByRef ITRACE As Integer, _
    ByRef IND As Integer, ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long _
    )


  Delegate Sub D03PKF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PKF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef IBND As Integer, _
    ByRef NOBC As Integer, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PKF_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


   Declare Sub D03PKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef TS As Double, ByRef TOUT As Double, _
    ByVal PDEDEF As D03PKF_PDEDEF_DELEGATE, ByVal BNDARY As D03PKF_BNDARY_DELEGATE, <[In](),Out()> ByVal U As Double(), _
    ByRef NPTS As Integer, <[In]()> ByVal X As Double(), ByRef NLEFT As Integer, _
    ByRef NV As Integer, ByVal ODEDEF As D03PKF_ODEDEF_DELEGATE, ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, <[In]()> ByVal RTOL As Double(), _
    <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, ByVal NORM As string, _
    ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IND As Integer, _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long _
    )


  Delegate Sub D03PLF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal D_rptr As IntPtr, _
    ByVal S_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

   Declare Sub D03PLP Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal D_rptr As IntPtr, _
    ByVal S_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PLF_NUMFLX_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal ULEFT_rptr As IntPtr, _
    ByVal URIGHT_rptr As IntPtr, _
    ByVal FLUX_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PLF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal G_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PLF_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


   Declare Sub D03PLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef TS As Double, ByRef TOUT As Double, _
    ByVal PDEDEF As D03PLF_PDEDEF_DELEGATE, ByVal NUMFLX As D03PLF_NUMFLX_DELEGATE, ByVal BNDARY As D03PLF_BNDARY_DELEGATE, _
    <[In](),Out()> ByVal U As Double(), ByRef NPTS As Integer, <[In]()> ByVal X As Double(), _
    ByRef NV As Integer, ByVal ODEDEF As D03PLF_ODEDEF_DELEGATE, ByRef NXI As Integer, _
    <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, <[In]()> ByVal RTOL As Double(), _
    <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, ByVal NORM As string, _
    ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, _
    ByRef ITASK As Integer, ByRef ITRACE As Integer, ByRef IND As Integer, _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long _
    )


  Delegate Sub D03PPA_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PPA_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PPA_UVINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByRef NXI As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XI_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub D03PPA_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal RCP_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal UCPTX_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


  Delegate Sub D03PPA_MONITF_DELEGATE( _
    ByRef T As Double, _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal FMON_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


   Declare Sub D03PPA Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PPA_PDEDEF_DELEGATE, ByVal BNDARY As D03PPA_BNDARY_DELEGATE, _
    ByVal UVINIT As D03PPA_UVINIT_DELEGATE, <[In](),Out()> ByVal U As Double(), ByRef NPTS As Integer, _
    <[In](),Out()> ByVal X As Double(), ByRef NV As Integer, ByVal ODEDEF As D03PPA_ODEDEF_DELEGATE, _
    ByRef NXI As Integer, <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, _
    <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, _
    ByVal NORM As string, ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), _
    ByRef REMESH As Integer, ByRef NXFIX As Integer, <[In]()> ByVal XFIX As Double(), _
    ByRef NRMESH As Integer, ByRef DXMESH As Double, ByRef TRMESH As Double, _
    ByRef IPMINF As Integer, ByRef XRATIO As Double, ByRef CON As Double, _
    ByVal MONITF As D03PPA_MONITF_DELEGATE, <[In](),Out()> ByVal RSAVE As Double(), ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, ByRef IND As Integer, <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), ByVal CWSAV As string, <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long, _
    ByVal CWSAVLength As long _
    )

  Delegate Sub D03PPF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal Q_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PPF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal BETA_rptr As IntPtr, _
    ByVal GAMMA_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PPF_UVINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByRef NXI As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XI_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr _
  )

  Delegate Sub D03PPF_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal RCP_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal UCPTX_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


  Delegate Sub D03PPF_MONITF_DELEGATE( _
    ByRef T As Double, _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByVal FMON_rptr As IntPtr _
  )


   Declare Sub D03PPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef M As Integer, ByRef TS As Double, _
    ByRef TOUT As Double, ByVal PDEDEF As D03PPF_PDEDEF_DELEGATE, ByVal BNDARY As D03PPF_BNDARY_DELEGATE, _
    ByVal UVINIT As D03PPF_UVINIT_DELEGATE, <[In](),Out()> ByVal U As Double(), ByRef NPTS As Integer, _
    <[In](),Out()> ByVal X As Double(), ByRef NV As Integer, ByVal ODEDEF As D03PPF_ODEDEF_DELEGATE, _
    ByRef NXI As Integer, <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, _
    <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, _
    ByVal NORM As string, ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), _
    ByRef REMESH As Integer, ByRef NXFIX As Integer, <[In]()> ByVal XFIX As Double(), _
    ByRef NRMESH As Integer, ByRef DXMESH As Double, ByRef TRMESH As Double, _
    ByRef IPMINF As Integer, ByRef XRATIO As Double, ByRef CON As Double, _
    ByVal MONITF As D03PPF_MONITF_DELEGATE, <[In](),Out()> ByVal RSAVE As Double(), ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, ByRef IND As Integer, ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long _
    )


  Delegate Sub D03PRF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PRF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef IBND As Integer, _
    ByRef NOBC As Integer, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PRF_UVINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByRef NXI As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XI_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr _
  )

  Delegate Sub D03PRF_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


  Delegate Sub D03PRF_MONITF_DELEGATE( _
    ByRef T As Double, _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal FMON_rptr As IntPtr _
  )


   Declare Sub D03PRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef TS As Double, ByRef TOUT As Double, _
    ByVal PDEDEF As D03PRF_PDEDEF_DELEGATE, ByVal BNDARY As D03PRF_BNDARY_DELEGATE, ByVal UVINIT As D03PRF_UVINIT_DELEGATE, _
    <[In](),Out()> ByVal U As Double(), ByRef NPTS As Integer, <[In](),Out()> ByVal X As Double(), _
    ByRef NLEFT As Integer, ByRef NV As Integer, ByVal ODEDEF As D03PRF_ODEDEF_DELEGATE, _
    ByRef NXI As Integer, <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, _
    <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, _
    ByVal NORM As string, ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), _
    ByRef REMESH As Integer, ByRef NXFIX As Integer, <[In]()> ByVal XFIX As Double(), _
    ByRef NRMESH As Integer, ByRef DXMESH As Double, ByRef TRMESH As Double, _
    ByRef IPMINF As Integer, ByRef XRATIO As Double, ByRef CON As Double, _
    ByVal MONITF As D03PRF_MONITF_DELEGATE, <[In](),Out()> ByVal RSAVE As Double(), ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, ByRef IND As Integer, ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long _
    )


  Delegate Sub D03PSF_PDEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByVal U_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByVal P_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal D_rptr As IntPtr, _
    ByVal S_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


  Delegate Sub D03PSF_NUMFLX_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef X As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal ULEFT_rptr As IntPtr, _
    ByVal URIGHT_rptr As IntPtr, _
    ByVal FLUX_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PSF_BNDARY_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef IBND As Integer, _
    ByVal G_rptr As IntPtr, _
    ByRef IRES As Integer _
  )

  Delegate Sub D03PSF_UVINIT_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef NPTS As Integer, _
    ByRef NXI As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XI_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr _
  )

  Delegate Sub D03PSF_ODEDEF_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef NV As Integer, _
    ByVal V_rptr As IntPtr, _
    ByVal VDOT_rptr As IntPtr, _
    ByRef NXI As Integer, _
    ByVal XI_rptr As IntPtr, _
    ByVal UCP_rptr As IntPtr, _
    ByVal UCPX_rptr As IntPtr, _
    ByVal UCPT_rptr As IntPtr, _
    ByVal R_rptr As IntPtr, _
    ByRef IRES As Integer _
  )


  Delegate Sub D03PSF_MONITF_DELEGATE( _
    ByRef T As Double, _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal FMON_rptr As IntPtr _
  )


   Declare Sub D03PSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef TS As Double, ByRef TOUT As Double, _
    ByVal PDEDEF As D03PSF_PDEDEF_DELEGATE, ByVal NUMFLX As D03PSF_NUMFLX_DELEGATE, ByVal BNDARY As D03PSF_BNDARY_DELEGATE, _
    ByVal UVINIT As D03PSF_UVINIT_DELEGATE, <[In](),Out()> ByVal U As Double(), ByRef NPTS As Integer, _
    <[In](),Out()> ByVal X As Double(), ByRef NV As Integer, ByVal ODEDEF As D03PSF_ODEDEF_DELEGATE, _
    ByRef NXI As Integer, <[In]()> ByVal XI As Double(), ByRef NEQN As Integer, _
    <[In]()> ByVal RTOL As Double(), <[In]()> ByVal ATOL As Double(), ByRef ITOL As Integer, _
    ByVal NORM As string, ByVal LAOPT As string, <[In]()> ByVal ALGOPT As Double(), _
    ByRef REMESH As Integer, ByRef NXFIX As Integer, <[In]()> ByVal XFIX As Double(), _
    ByRef NRMESH As Integer, ByRef DXMESH As Double, ByRef TRMESH As Double, _
    ByRef IPMINF As Integer, ByRef XRATIO As Double, ByRef CON As Double, _
    ByVal MONITF As D03PSF_MONITF_DELEGATE, <[In](),Out()> ByVal RSAVE As Double(), ByRef LRSAVE As Integer, _
    <[In](),Out()> ByVal ISAVE As Integer(), ByRef LISAVE As Integer, ByRef ITASK As Integer, _
    ByRef ITRACE As Integer, ByRef IND As Integer, ByRef IFAIL As Integer, _
    ByVal NORMLength As long, _
    ByVal LAOPTLength As long _
    )


   Declare Sub D03PUF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal ULEFT As Double(), _
    <[In]()> ByVal URIGHT As Double(), _
    ByRef GAMMA As Double, _
    <Out()> ByVal FLUX As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03PVF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal ULEFT As Double(), _
    <[In]()> ByVal URIGHT As Double(), _
    ByRef GAMMA As Double, _
    ByVal PATH As string, _
    <Out()> ByVal FLUX As Double(), _
    ByRef IFAIL As Integer, _
    ByVal PATHLength As long _
    )


   Declare Sub D03PWF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal ULEFT As Double(), _
    <[In]()> ByVal URIGHT As Double(), _
    ByRef GAMMA As Double, _
    <Out()> ByVal FLUX As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03PXF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal ULEFT As Double(), _
    <[In]()> ByVal URIGHT As Double(), _
    ByRef GAMMA As Double, _
    ByRef TOL As Double, _
    ByRef NITER As Integer, _
    <Out()> ByVal FLUX As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03PYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    <[In]()> ByVal U As Double(,), _
    ByRef NBKPTS As Integer, _
    <[In]()> ByVal XBKPTS As Double(), _
    ByRef NPOLY As Integer, _
    ByRef NPTS As Integer, _
    <[In]()> ByVal XP As Double(), _
    ByRef INTPTS As Integer, _
    ByRef ITYPE As Integer, _
    <Out()> ByVal UP As Double(,,), _
    <[In](),Out()> ByVal RSAVE As Double(), _
    ByRef LRSAVE As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03PZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal U As Double(,), _
    ByRef NPTS As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal XP As Double(), _
    ByRef INTPTS As Integer, _
    ByRef ITYPE As Integer, _
    <Out()> ByVal UP As Double(,,), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub D03RAF_PDEDEF_DELEGATE( _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal UY_rptr As IntPtr, _
    ByVal UXX_rptr As IntPtr, _
    ByVal UXY_rptr As IntPtr, _
    ByVal UYY_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr _
  )

  Delegate Sub D03RAF_BNDARY_DELEGATE( _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal UY_rptr As IntPtr, _
    ByRef NBPTS As Integer, _
    ByVal LBND_iptr As IntPtr, _
    ByVal RES_rptr As IntPtr _
  )

  Delegate Sub D03RAF_PDEIV_DELEGATE( _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal U_rptr As IntPtr _
  )

  Delegate Sub D03RAF_MONITR_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef DT As Double, _
    ByRef DTNEW As Double, _
    ByRef TLAST As Integer, _
    ByRef NLEV As Integer, _
    ByVal NGPTS_iptr As IntPtr, _
    ByVal XPTS_rptr As IntPtr, _
    ByVal YPTS_rptr As IntPtr, _
    ByVal LSOL_iptr As IntPtr, _
    ByVal SOL_rptr As IntPtr, _
    ByRef IERR As Integer _
  )

   Declare Sub D03RAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef TS As Double, ByRef TOUT As Double, _
    <[In](),Out()> ByVal DT As Double(), ByRef XMIN As Double, ByRef XMAX As Double, _
    ByRef YMIN As Double, ByRef YMAX As Double, ByRef NX As Integer, _
    ByRef NY As Integer, ByRef TOLS As Double, ByRef TOLT As Double, _
    ByVal PDEDEF As D03RAF_PDEDEF_DELEGATE, ByVal BNDARY As D03RAF_BNDARY_DELEGATE, ByVal PDEIV As D03RAF_PDEIV_DELEGATE, _
    ByVal MONITR As D03RAF_MONITR_DELEGATE, <[In]()> ByVal OPTI As Integer(), <[In]()> ByVal OPTR As Double(,), _
    <[In](),Out()> ByVal RWK As Double(), ByRef LENRWK As Integer, <[In](),Out()> ByVal IWK As Integer(), _
    ByRef LENIWK As Integer, <Out()> ByVal LWK As Integer(), ByRef LENLWK As Integer, _
    ByRef ITRACE As Integer, ByRef IND As Integer, ByRef IFAIL As Integer _
   )


  Delegate Sub D03RBF_INIDOM_DELEGATE( _
    ByRef MAXPTS As Integer, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    ByRef YMIN As Double, _
    ByRef YMAX As Double, _
    ByRef NX As Integer, _
    ByRef NY As Integer, _
    ByRef NPTS As Integer, _
    ByRef NROWS As Integer, _
    ByRef NBNDS As Integer, _
    ByRef NBPTS As Integer, _
    ByVal LROW_iptr As IntPtr, _
    ByVal IROW_iptr As IntPtr, _
    ByVal ICOL_iptr As IntPtr, _
    ByVal LLBND_iptr As IntPtr, _
    ByVal ILBND_iptr As IntPtr, _
    ByVal LBND_iptr As IntPtr, _
    ByRef IERR As Integer _
  )

  Delegate Sub D03RBF_PDEDEF_DELEGATE( _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal UY_rptr As IntPtr, _
    ByVal UXX_rptr As IntPtr, _
    ByVal UXY_rptr As IntPtr, _
    ByVal UYY_rptr As IntPtr, _
    ByVal RES_rptr As IntPtr _
  )

  Delegate Sub D03RBF_BNDARY_DELEGATE( _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal U_rptr As IntPtr, _
    ByVal UT_rptr As IntPtr, _
    ByVal UX_rptr As IntPtr, _
    ByVal UY_rptr As IntPtr, _
    ByRef NBNDS As Integer, _
    ByRef NBPTS As Integer, _
    ByVal LLBND_iptr As IntPtr, _
    ByVal ILBND_iptr As IntPtr, _
    ByVal LBND_iptr As IntPtr, _
    ByVal RES_rptr As IntPtr _
  )

  Delegate Sub D03RBF_PDEIV_DELEGATE( _
    ByRef NPTS As Integer, _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal U_rptr As IntPtr _
  )

  Delegate Sub D03RBF_MONITR_DELEGATE( _
    ByRef NPDE As Integer, _
    ByRef T As Double, _
    ByRef DT As Double, _
    ByRef DTNEW As Double, _
    ByRef TLAST As Integer, _
    ByRef NLEV As Integer, _
    ByRef XMIN As Double, _
    ByRef YMIN As Double, _
    ByRef DXB As Double, _
    ByRef DYB As Double, _
    ByVal LGRID_iptr As IntPtr, _
    ByVal ISTRUC_iptr As IntPtr, _
    ByVal LSOL_iptr As IntPtr, _
    ByVal SOL_rptr As IntPtr, _
    ByRef IERR As Integer _
  )

   Declare Sub D03RBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPDE As Integer, ByRef TS As Double, ByRef TOUT As Double, _
    <[In](),Out()> ByVal DT As Double(), ByRef TOLS As Double, ByRef TOLT As Double, _
    ByVal INIDOM As D03RBF_INIDOM_DELEGATE, ByVal PDEDEF As D03RBF_PDEDEF_DELEGATE, ByVal BNDARY As D03RBF_BNDARY_DELEGATE, _
    ByVal PDEIV As D03RBF_PDEIV_DELEGATE, ByVal MONITR As D03RBF_MONITR_DELEGATE, <[In]()> ByVal OPTI As Integer(), _
    <[In]()> ByVal OPTR As Double(,), <[In](),Out()> ByVal RWK As Double(), ByRef LENRWK As Integer, _
    <[In](),Out()> ByVal IWK As Integer(), ByRef LENIWK As Integer, <Out()> ByVal LWK As Integer(), _
    ByRef LENLWK As Integer, ByRef ITRACE As Integer, ByRef IND As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03RZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LEVEL As Integer, _
    ByRef NLEV As Integer, _
    ByRef XMIN As Double, _
    ByRef YMIN As Double, _
    ByRef DXB As Double, _
    ByRef DYB As Double, _
    <[In]()> ByVal LGRID As Integer(), _
    <[In]()> ByVal ISTRUC As Integer(), _
    ByRef NPTS As Integer, _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal Y As Double(), _
    ByRef LENXY As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03UAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef LDA As Integer, _
    <[In]()> ByVal A As Double(,), _
    <[In]()> ByVal B As Double(,), _
    <[In]()> ByVal C As Double(,), _
    <[In]()> ByVal D As Double(,), _
    <[In]()> ByVal E As Double(,), _
    ByRef APARAM As Double, _
    ByRef IT As Integer, _
    <[In](),Out()> ByVal R As Double(,), _
    <Out()> ByVal WRKSP1 As Double(,), _
    <Out()> ByVal WRKSP2 As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D03UBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef N3 As Integer, _
    ByRef LDA As Integer, _
    ByRef SDA As Integer, _
    <[In]()> ByVal A As Double(,,), _
    <[In]()> ByVal B As Double(,,), _
    <[In]()> ByVal C As Double(,,), _
    <[In]()> ByVal D As Double(,,), _
    <[In]()> ByVal E As Double(,,), _
    <[In]()> ByVal F As Double(,,), _
    <[In]()> ByVal G As Double(,,), _
    ByRef APARAM As Double, _
    ByRef IT As Integer, _
    <[In](),Out()> ByVal R As Double(,,), _
    <Out()> ByVal WRKSP1 As Double(,,), _
    <Out()> ByVal WRKSP2 As Double(,,), _
    <Out()> ByVal WRKSP3 As Double(,,), _
    ByRef IFAIL As Integer _
   )


' chapter d04

  Delegate Function D04AAF_F_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D04AAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef XVAL As Double, _
    ByRef NDER As Integer, _
    ByRef HBASE As Double, _
    <Out()> ByVal DER As Double(), _
    <Out()> ByVal EREST As Double(), _
    ByVal F As D04AAF_F_DELEGATE, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D04BAF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal XVAL As Double(), _
    <[In]()> ByVal FVAL As Double(), _
    <Out()> ByVal DER As Double(), _
    <Out()> ByVal EREST As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D04BBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X_0 As Double, _
    ByRef HBASE As Double, _
    <Out()> ByVal XVAL As Double() _
   )


' chapter d05

  Delegate Function D05AAF_K1_DELEGATE( _
    ByRef X As Double, _
    ByRef S As Double _
  ) as Double

  Delegate Function D05AAF_K2_DELEGATE( _
    ByRef X As Double, _
    ByRef S As Double _
  ) as Double

  Delegate Function D05AAF_G_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D05AAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LAMBDA As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByVal K1 As D05AAF_K1_DELEGATE, _
    ByVal K2 As D05AAF_K2_DELEGATE, _
    ByVal G As D05AAF_G_DELEGATE, _
    <Out()> ByVal F As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef N As Integer, _
    ByRef IND As Integer, _
    <Out()> ByVal W1 As Double(,), _
    <Out()> ByVal W2 As Double(,), _
    <Out()> ByVal WD As Double(), _
    ByRef LDW1 As Integer, _
    ByRef LDW2 As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D05ABF_K_DELEGATE( _
    ByRef X As Double, _
    ByRef S As Double _
  ) as Double

  Delegate Function D05ABF_G_DELEGATE( _
    ByRef X As Double _
  ) as Double

   Declare Sub D05ABF Lib "NLW6I31DE_nag.dll" ( _
    ByVal K As D05ABF_K_DELEGATE, _
    ByVal G As D05ABF_G_DELEGATE, _
    ByRef LAMBDA As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef ODOREV As Integer, _
    ByRef EV As Integer, _
    ByRef N As Integer, _
    <Out()> ByVal CM As Double(,), _
    <Out()> ByVal F1 As Double(,), _
    <Out()> ByVal WK As Double(,), _
    ByRef LDCM As Integer, _
    ByRef NT2P1 As Integer, _
    <Out()> ByVal F As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Function D05BAF_CK_DELEGATE( _
    ByRef T As Double _
  ) as Double

  Delegate Function D05BAF_CG_DELEGATE( _
    ByRef S As Double, _
    ByRef Y As Double _
  ) as Double

  Delegate Function D05BAF_CF_DELEGATE( _
    ByRef T As Double _
  ) as Double

   Declare Sub D05BAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CK As D05BAF_CK_DELEGATE, _
    ByVal CG As D05BAF_CG_DELEGATE, _
    ByVal CF As D05BAF_CF_DELEGATE, _
    ByVal METHOD As string, _
    ByRef IORDER As Integer, _
    ByRef ALIM As Double, _
    ByRef TLIM As Double, _
    <Out()> ByVal YN As Double(), _
    <Out()> ByVal ERREST As Double(), _
    ByRef NMESH As Integer, _
    ByRef TOL As Double, _
    ByRef THRESH As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


  Delegate Function D05BDF_CK_DELEGATE( _
    ByRef T As Double _
  ) as Double

  Delegate Function D05BDF_CF_DELEGATE( _
    ByRef T As Double _
  ) as Double

  Delegate Function D05BDF_CG_DELEGATE( _
    ByRef S As Double, _
    ByRef Y As Double _
  ) as Double

   Declare Sub D05BDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CK As D05BDF_CK_DELEGATE, _
    ByVal CF As D05BDF_CF_DELEGATE, _
    ByVal CG As D05BDF_CG_DELEGATE, _
    ByVal INITWT As string, _
    ByRef IORDER As Integer, _
    ByRef TLIM As Double, _
    ByRef TOLNL As Double, _
    ByRef NMESH As Integer, _
    <Out()> ByVal YN As Double(), _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef LWK As Integer, _
    <Out()> ByVal NCT As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal INITWTLength As long _
    )


  Delegate Function D05BEF_CK_DELEGATE( _
    ByRef T As Double _
  ) as Double

  Delegate Function D05BEF_CF_DELEGATE( _
    ByRef T As Double _
  ) as Double

  Delegate Function D05BEF_CG_DELEGATE( _
    ByRef S As Double, _
    ByRef Y As Double _
  ) as Double

   Declare Sub D05BEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CK As D05BEF_CK_DELEGATE, _
    ByVal CF As D05BEF_CF_DELEGATE, _
    ByVal CG As D05BEF_CG_DELEGATE, _
    ByVal INITWT As string, _
    ByRef IORDER As Integer, _
    ByRef TLIM As Double, _
    ByRef TOLNL As Double, _
    ByRef NMESH As Integer, _
    <[In](),Out()> ByVal YN As Double(), _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef LWK As Integer, _
    <Out()> ByVal NCT As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal INITWTLength As long _
    )


   Declare Sub D05BWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByRef IORDER As Integer, _
    <Out()> ByVal OMEGA As Double(), _
    ByRef NOMG As Integer, _
    ByRef LENSW As Integer, _
    <Out()> ByVal SW As Double(,), _
    ByRef LDSW As Integer, _
    ByRef NWT As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Sub D05BYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IORDER As Integer, _
    ByRef IQ As Integer, _
    ByRef LENFW As Integer, _
    <Out()> ByVal WT As Double(), _
    <Out()> ByVal SW As Double(,), _
    ByRef LDSW As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWK As Integer, _
    ByRef IFAIL As Integer _
   )


' chapter d06

   Declare Sub D06AAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVB As Integer, _
    ByRef NVMAX As Integer, _
    ByRef NEDGE As Integer, _
    <[In]()> ByVal EDGE As Integer(,), _
    ByRef NV As Integer, _
    ByRef NELT As Integer, _
    <[In](),Out()> ByVal COOR As Double(,), _
    <Out()> ByVal CONN As Integer(,), _
    <[In]()> ByVal BSPACE As Double(), _
    ByRef SMOOTH As Integer, _
    ByRef COEF As Double, _
    ByRef POWER As Double, _
    ByRef ITRACE As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D06ABF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVB As Integer, _
    ByRef NVINT As Integer, _
    ByRef NVMAX As Integer, _
    ByRef NEDGE As Integer, _
    <[In]()> ByVal EDGE As Integer(,), _
    ByRef NV As Integer, _
    ByRef NELT As Integer, _
    <[In](),Out()> ByVal COOR As Double(,), _
    <Out()> ByVal CONN As Integer(,), _
    <[In]()> ByVal WEIGHT As Double(), _
    ByRef NPROPA As Integer, _
    ByRef ITRACE As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D06ACF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVB As Integer, _
    ByRef NVINT As Integer, _
    ByRef NVMAX As Integer, _
    ByRef NEDGE As Integer, _
    <[In]()> ByVal EDGE As Integer(,), _
    ByRef NV As Integer, _
    ByRef NELT As Integer, _
    <[In](),Out()> ByVal COOR As Double(,), _
    <Out()> ByVal CONN As Integer(,), _
    <[In]()> ByVal WEIGHT As Double(), _
    ByRef ITRACE As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Function D06BAF_FBND_DELEGATE( _
    ByRef I As Integer, _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr _
  ) as Double

   Declare Function D06BAD Lib "NLW6I31DE_nag.dll" ( _
    ByRef I As Integer, _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr _
  ) as Double

   Declare Sub D06BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NLINES As Integer, <[In]()> ByVal COORCH As Double(,), <[In]()> ByVal LINED As Integer(,), _
    ByVal FBND As D06BAF_FBND_DELEGATE, <[In]()> ByVal CRUS As Double(,), ByRef SDCRUS As Integer, _
    <[In]()> ByVal RATE As Double(), ByRef NCOMP As Integer, <[In]()> ByVal NLCOMP As Integer(), _
    <[In]()> ByVal LCOMP As Integer(), ByRef NVMAX As Integer, ByRef NEDMX As Integer, _
    ByRef NVB As Integer, <Out()> ByVal COOR As Double(,), ByRef NEDGE As Integer, _
    <Out()> ByVal EDGE As Integer(,), ByRef ITRACE As Integer, <[In](),Out()> ByVal RUSER As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), <Out()> ByVal RWORK As Double(), ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, ByRef IFAIL As Integer _
   )


   Declare Sub D06CAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NV As Integer, _
    ByRef NELT As Integer, _
    ByRef NEDGE As Integer, _
    <[In](),Out()> ByVal COOR As Double(,), _
    <[In]()> ByVal EDGE As Integer(,), _
    <[In]()> ByVal CONN As Integer(,), _
    ByRef NVFIX As Integer, _
    <[In]()> ByVal NUMFIX As Integer(), _
    ByRef ITRACE As Integer, _
    ByRef NQINT As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D06CBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NV As Integer, _
    ByRef NELT As Integer, _
    ByRef NNZMAX As Integer, _
    <[In]()> ByVal CONN As Integer(,), _
    ByRef NNZ As Integer, _
    <Out()> ByVal IROW As Integer(), _
    <Out()> ByVal ICOL As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub D06CCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NV As Integer, _
    ByRef NELT As Integer, _
    ByRef NEDGE As Integer, _
    ByRef NNZMAX As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal COOR As Double(,), _
    <[In](),Out()> ByVal EDGE As Integer(,), _
    <[In](),Out()> ByVal CONN As Integer(,), _
    <Out()> ByVal IROW As Integer(), _
    <Out()> ByVal ICOL As Integer(), _
    ByRef ITRACE As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D06DAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NV As Integer, _
    ByRef NEDGE As Integer, _
    ByRef NELT As Integer, _
    ByRef NTRANS As Integer, _
    <[In]()> ByVal ITYPE As Integer(), _
    <[In]()> ByVal TRANS As Double(,), _
    <[In](),Out()> ByVal COORI As Double(,), _
    <[In](),Out()> ByVal EDGEI As Integer(,), _
    <[In](),Out()> ByVal CONNI As Integer(,), _
    <Out()> ByVal COORO As Double(,), _
    <Out()> ByVal EDGEO As Integer(,), _
    <Out()> ByVal CONNO As Integer(,), _
    ByRef ITRACE As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub D06DBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef EPS As Double, ByRef NV1 As Integer, ByRef NELT1 As Integer, _
    ByRef NEDGE1 As Integer, <[In]()> ByVal COOR1 As Double(,), <[In]()> ByVal EDGE1 As Integer(,), _
    <[In]()> ByVal CONN1 As Integer(,), <[In]()> ByVal REFT1 As Integer(), ByRef NV2 As Integer, _
    ByRef NELT2 As Integer, ByRef NEDGE2 As Integer, <[In]()> ByVal COOR2 As Double(,), _
    <[In]()> ByVal EDGE2 As Integer(,), <[In]()> ByVal CONN2 As Integer(,), <[In]()> ByVal REFT2 As Integer(), _
    ByRef NV3 As Integer, ByRef NELT3 As Integer, ByRef NEDGE3 As Integer, _
    <Out()> ByVal COOR3 As Double(,), <Out()> ByVal EDGE3 As Integer(,), <Out()> ByVal CONN3 As Integer(,), _
    <Out()> ByVal REFT3 As Integer(), ByRef ITRACE As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef IFAIL As Integer _
   )


' chapter e01

   Declare Sub E01AAF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal A As Double(), _
    <[In](),Out()> ByVal B As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef N As Integer, _
    ByRef X As Double _
   )


   Declare Sub E01ABF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef P As Double, _
    <[In](),Out()> ByVal A As Double(), _
    <Out()> ByVal G As Double(), _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01AEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal IP As Integer(), _
    ByRef N As Integer, _
    ByRef ITMIN As Integer, _
    ByRef ITMAX As Integer, _
    <Out()> ByVal A As Double(), _
    <Out()> ByVal WRK As Double(), _
    ByRef LWRK As Integer, _
    <Out()> ByVal IWRK As Integer(), _
    ByRef LIWRK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal LAMDA As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef LCK As Integer, _
    <Out()> ByVal WRK As Double(), _
    ByRef LWRK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01BEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal F As Double(), _
    <Out()> ByVal D As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01BFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal D As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal PX As Double(), _
    <Out()> ByVal PF As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01BGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal D As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal PX As Double(), _
    <Out()> ByVal PF As Double(), _
    <Out()> ByVal PD As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01BHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal D As Double(), _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef PINT As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01CEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef LAM As Double, _
    ByRef NEGFOR As Integer, _
    ByRef YFOR As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal COMM As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01CFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal VAL As Double(), _
    <Out()> ByVal FWD As Double(), _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01DAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MX As Integer, _
    ByRef MY As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), _
    ByRef PX As Integer, _
    ByRef PY As Integer, _
    <Out()> ByVal LAMDA As Double(), _
    <Out()> ByVal MU As Double(), _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal WRK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01EAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal TRIANG As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01EBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal TRIANG As Integer(), _
    <[In]()> ByVal PX As Double(), _
    <[In]()> ByVal PY As Double(), _
    <Out()> ByVal PF As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01RAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal F As Double(), _
    ByRef M As Integer, _
    <Out()> ByVal A As Double(), _
    <Out()> ByVal U As Double(), _
    <Out()> ByVal IW As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01RBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal U As Double(), _
    ByRef X As Double, _
    ByRef F As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01SAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), _
    <Out()> ByVal TRIANG As Integer(), _
    <Out()> ByVal GRADS As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01SBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal TRIANG As Integer(), _
    <[In]()> ByVal GRADS As Double(,), _
    ByRef PX As Double, _
    ByRef PY As Double, _
    ByRef PF As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01SGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), _
    ByRef NW As Integer, _
    ByRef NQ As Integer, _
    <Out()> ByVal IQ As Integer(), _
    ByRef LIQ As Integer, _
    <Out()> ByVal RQ As Double(), _
    ByRef LRQ As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01SHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal IQ As Integer(), _
    ByRef LIQ As Integer, _
    <[In]()> ByVal RQ As Double(), _
    ByRef LRQ As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal U As Double(), _
    <[In]()> ByVal V As Double(), _
    <Out()> ByVal Q As Double(), _
    <Out()> ByVal QX As Double(), _
    <Out()> ByVal QY As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01TGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal Z As Double(), _
    <[In]()> ByVal F As Double(), _
    ByRef NW As Integer, _
    ByRef NQ As Integer, _
    <Out()> ByVal IQ As Integer(), _
    ByRef LIQ As Integer, _
    <Out()> ByVal RQ As Double(), _
    ByRef LRQ As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01THF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal Z As Double(), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal IQ As Integer(), _
    ByRef LIQ As Integer, _
    <[In]()> ByVal RQ As Double(), _
    ByRef LRQ As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal U As Double(), _
    <[In]()> ByVal V As Double(), _
    <[In]()> ByVal W As Double(), _
    <Out()> ByVal Q As Double(), _
    <Out()> ByVal QX As Double(), _
    <Out()> ByVal QY As Double(), _
    <Out()> ByVal QZ As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01TKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    <[In]()> ByVal F As Double(), _
    ByRef NW As Integer, _
    ByRef NQ As Integer, _
    <Out()> ByVal IQ As Integer(), _
    <Out()> ByVal RQ As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01TLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal IQ As Integer(), _
    <[In]()> ByVal RQ As Double(), _
    ByRef N As Integer, _
    <[In]()> ByVal XE As Double(,), _
    <Out()> ByVal Q As Double(), _
    <Out()> ByVal QX As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01TMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    <[In]()> ByVal F As Double(), _
    ByRef NW As Integer, _
    ByRef NQ As Integer, _
    <Out()> ByVal IQ As Integer(), _
    <Out()> ByVal RQ As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01TNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal IQ As Integer(), _
    <[In]()> ByVal RQ As Double(), _
    ByRef N As Integer, _
    <[In]()> ByVal XE As Double(,), _
    <Out()> ByVal Q As Double(), _
    <Out()> ByVal QX As Double(,), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01ZAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef D As Integer, _
    <[In]()> ByVal NARR As Integer(), _
    ByRef UNIFORM As Integer, _
    <[In]()> ByVal AXIS As Double(), _
    ByRef LX As Integer, _
    <[In]()> ByVal V As Double(), _
    <[In]()> ByVal POINT As Double(), _
    ByRef METHOD As Integer, _
    ByRef K As Integer, _
    ByRef WF As Double, _
    ByRef ANS As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01ZMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef D As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    <[In]()> ByVal F As Double(), _
    ByRef NW As Integer, _
    ByRef NQ As Integer, _
    <Out()> ByVal IQ As Integer(), _
    <Out()> ByVal RQ As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E01ZNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef D As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    <[In]()> ByVal F As Double(), _
    <[In]()> ByVal IQ As Integer(), _
    <[In]()> ByVal RQ As Double(), _
    ByRef N As Integer, _
    <[In]()> ByVal XE As Double(,), _
    <Out()> ByVal Q As Double(), _
    <Out()> ByVal QX As Double(,), _
    ByRef IFAIL As Integer _
   )


' chapter e02

   Declare Sub E02ADF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef KPLUS1 As Integer, _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal W As Double(), _
    <Out()> ByVal WORK1 As Double(), _
    <Out()> ByVal WORK2 As Double(), _
    <Out()> ByVal A As Double(,), _
    <Out()> ByVal S As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02AEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPLUS1 As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef XCAP As Double, _
    ByRef P As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02AFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPLUS1 As Integer, _
    <[In]()> ByVal F As Double(), _
    <Out()> ByVal A As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02AGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef KPLUS1 As Integer, ByRef LDA As Integer, _
    ByRef XMIN As Double, ByRef XMAX As Double, <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), <[In]()> ByVal W As Double(), ByRef MF As Integer, _
    <[In]()> ByVal XF As Double(), <[In]()> ByVal YF As Double(), ByRef LYF As Integer, _
    <[In]()> ByVal IP As Integer(), <Out()> ByVal A As Double(,), <Out()> ByVal S As Double(), _
    ByRef NP1 As Integer, <Out()> ByVal WRK As Double(), ByRef LWRK As Integer, _
    <Out()> ByVal IWRK As Integer(), ByRef LIWRK As Integer, ByRef IFAIL As Integer _
   )


   Declare Sub E02AHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NP1 As Integer, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    <[In]()> ByVal A As Double(), _
    ByRef IA1 As Integer, _
    ByRef LA As Integer, _
    ByRef PATM1 As Double, _
    <Out()> ByVal ADIF As Double(), _
    ByRef IADIF1 As Integer, _
    ByRef LADIF As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02AJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NP1 As Integer, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    <[In]()> ByVal A As Double(), _
    ByRef IA1 As Integer, _
    ByRef LA As Integer, _
    ByRef QATM1 As Double, _
    <Out()> ByVal AINTC As Double(), _
    ByRef IAINT1 As Integer, _
    ByRef LAINT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02AKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NP1 As Integer, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    <[In]()> ByVal A As Double(), _
    ByRef IA1 As Integer, _
    ByRef LA As Integer, _
    ByRef X As Double, _
    ByRef RESULT As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02ALF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    ByRef M As Integer, _
    <Out()> ByVal A As Double(), _
    ByRef REF As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef NCAP7 As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal W As Double(), _
    <[In](),Out()> ByVal LAMDA As Double(), _
    <Out()> ByVal WORK1 As Double(), _
    <Out()> ByVal WORK2 As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef SS As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02BBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCAP7 As Integer, _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal C As Double(), _
    ByRef X As Double, _
    ByRef S As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02BCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCAP7 As Integer, _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal C As Double(), _
    ByRef X As Double, _
    ByRef LEFT As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02BDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCAP7 As Integer, _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal C As Double(), _
    ByRef DINT As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02BEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal START As string, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal W As Double(), _
    ByRef S As Double, _
    ByRef NEST As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal LAMDA As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef FP As Double, _
    <[In](),Out()> ByVal WRK As Double(), _
    ByRef LWRK As Integer, _
    <[In](),Out()> ByVal IWRK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal STARTLength As long _
    )


   Declare Sub E02BFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef START As Integer, _
    ByRef NCAP7 As Integer, _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal C As Double(), _
    ByRef DERIV As Integer, _
    ByRef XORD As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In](),Out()> ByVal IXLOC As Integer(), _
    ByRef NX As Integer, _
    <Out()> ByVal S As Double(,), _
    ByRef LDS As Integer, _
    <[In](),Out()> ByVal IWRK As Integer(), _
    ByRef LIWRK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02CAF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal M As Integer(), ByRef N As Integer, ByRef K As Integer, _
    ByRef L As Integer, <[In]()> ByVal X As Double(), <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), <[In]()> ByVal W As Double(), ByRef MTOT As Integer, _
    <Out()> ByVal A As Double(), ByRef NA As Integer, <[In]()> ByVal XMIN As Double(), _
    <[In]()> ByVal XMAX As Double(), <[In]()> ByVal NUX As Double(), ByRef INUXP1 As Integer, _
    <[In]()> ByVal NUY As Double(), ByRef INUYP1 As Integer, <Out()> ByVal WORK As Double(), _
    ByRef NWORK As Integer, ByRef IFAIL As Integer _
   )


   Declare Sub E02CBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MFIRST As Integer, _
    ByRef MLAST As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    ByRef Y As Double, _
    ByRef YMIN As Double, _
    ByRef YMAX As Double, _
    <Out()> ByVal FF As Double(), _
    <[In]()> ByVal A As Double(), _
    ByRef NA As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef NWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02DAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef PX As Integer, ByRef PY As Integer, _
    <[In]()> ByVal X As Double(), <[In]()> ByVal Y As Double(), <[In]()> ByVal F As Double(), _
    <[In]()> ByVal W As Double(), <[In](),Out()> ByVal LAMDA As Double(), <[In](),Out()> ByVal MU As Double(), _
    <[In]()> ByVal POINT As Integer(), ByRef NPOINT As Integer, <Out()> ByVal DL As Double(), _
    <Out()> ByVal C As Double(), ByRef NC As Integer, <Out()> ByVal WS As Double(), _
    ByRef NWS As Integer, ByRef EPS As Double, ByRef SIGMA As Double, _
    ByRef RANK As Integer, ByRef IFAIL As Integer _
   )


   Declare Sub E02DCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal START As string, ByRef MX As Integer, <[In]()> ByVal X As Double(), _
    ByRef MY As Integer, <[In]()> ByVal Y As Double(), <[In]()> ByVal F As Double(), _
    ByRef S As Double, ByRef NXEST As Integer, ByRef NYEST As Integer, _
    ByRef NX As Integer, <[In](),Out()> ByVal LAMDA As Double(), ByRef NY As Integer, _
    <[In](),Out()> ByVal MU As Double(), <Out()> ByVal C As Double(), ByRef FP As Double, _
    <[In](),Out()> ByVal WRK As Double(), ByRef LWRK As Integer, <[In](),Out()> ByVal IWRK As Integer(), _
    ByRef LIWRK As Integer, ByRef IFAIL As Integer, _
    ByVal STARTLength As long _
    )


   Declare Sub E02DDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal START As string, ByRef M As Integer, <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal Y As Double(), <[In]()> ByVal F As Double(), <[In]()> ByVal W As Double(), _
    ByRef S As Double, ByRef NXEST As Integer, ByRef NYEST As Integer, _
    ByRef NX As Integer, <[In](),Out()> ByVal LAMDA As Double(), ByRef NY As Integer, _
    <[In](),Out()> ByVal MU As Double(), <Out()> ByVal C As Double(), ByRef FP As Double, _
    ByRef RANK As Integer, <[In](),Out()> ByVal WRK As Double(), ByRef LWRK As Integer, _
    <Out()> ByVal IWRK As Integer(), ByRef LIWRK As Integer, ByRef IFAIL As Integer, _
    ByVal STARTLength As long _
    )


   Declare Sub E02DEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef PX As Integer, _
    ByRef PY As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal MU As Double(), _
    <[In]()> ByVal C As Double(), _
    <Out()> ByVal FF As Double(), _
    <Out()> ByVal WRK As Double(), _
    <Out()> ByVal IWRK As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02DFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MX As Integer, _
    ByRef MY As Integer, _
    ByRef PX As Integer, _
    ByRef PY As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal MU As Double(), _
    <[In]()> ByVal C As Double(), _
    <Out()> ByVal FF As Double(), _
    <Out()> ByVal WRK As Double(), _
    ByRef LWRK As Integer, _
    <Out()> ByVal IWRK As Integer(), _
    ByRef LIWRK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02DHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MX As Integer, _
    ByRef MY As Integer, _
    ByRef PX As Integer, _
    ByRef PY As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal MU As Double(), _
    <[In]()> ByVal C As Double(), _
    ByRef NUX As Integer, _
    ByRef NUY As Integer, _
    <Out()> ByVal Z As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02GAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(), _
    ByRef NPLUS2 As Integer, _
    ByRef TOLER As Double, _
    <Out()> ByVal X As Double(), _
    ByRef RESID As Double, _
    ByRef IRANK As Integer, _
    ByRef ITER As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E02GBF_MONIT_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NITER As Integer, _
    ByRef K As Integer, _
    ByRef EL1N As Double _
  )

   Declare Sub E02GBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef MPL As Integer, _
    <[In](),Out()> ByVal E As Double(,), _
    ByRef LDE As Integer, _
    <[In]()> ByVal F As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef MXS As Integer, _
    ByVal MONIT As E02GBF_MONIT_DELEGATE, _
    ByRef IPRINT As Integer, _
    ByRef K As Integer, _
    ByRef EL1N As Double, _
    <Out()> ByVal INDX As Integer(), _
    <Out()> ByVal W As Double(), _
    ByRef IW As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02GCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef SDA As Integer, _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    <[In](),Out()> ByVal B As Double(), _
    ByRef TOL As Double, _
    ByRef RELERR As Double, _
    <Out()> ByVal X As Double(), _
    ByRef RESMAX As Double, _
    ByRef IRANK As Integer, _
    ByRef ITER As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02JDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <[In]()> ByVal F As Double(), _
    ByRef LSMINP As Integer, _
    ByRef LSMAXP As Integer, _
    ByRef NXCELS As Integer, _
    ByRef NYCELS As Integer, _
    ByRef LCOEFS As Integer, _
    <Out()> ByVal COEFS As Double(), _
    <[In](),Out()> ByVal IOPTS As Integer(), _
    <[In](),Out()> ByVal OPTS As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02JEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NEVALV As Integer, _
    <[In]()> ByVal XEVALV As Double(), _
    <[In]()> ByVal YEVALV As Double(), _
    <[In]()> ByVal COEFS As Double(), _
    <Out()> ByVal FEVALV As Double(), _
    <[In]()> ByVal IOPTS As Integer(), _
    <[In]()> ByVal OPTS As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02JFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NXEVAL As Integer, _
    ByRef NYEVAL As Integer, _
    <[In]()> ByVal XEVALM As Double(), _
    <[In]()> ByVal YEVALM As Double(), _
    <[In]()> ByVal COEFS As Double(), _
    <Out()> ByVal FEVALM As Double(,), _
    <[In]()> ByVal IOPTS As Integer(), _
    <[In]()> ByVal OPTS As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02RAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IA As Integer, _
    ByRef IB As Integer, _
    <[In]()> ByVal C As Double(), _
    ByRef IC As Integer, _
    <Out()> ByVal A As Double(), _
    <Out()> ByVal B As Double(), _
    <Out()> ByVal W As Double(), _
    ByRef JW As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02RBF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal A As Double(), _
    ByRef IA As Integer, _
    <[In]()> ByVal B As Double(), _
    ByRef IB As Integer, _
    ByRef X As Double, _
    ByRef ANS As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02ZAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef PX As Integer, _
    ByRef PY As Integer, _
    <[In]()> ByVal LAMDA As Double(), _
    <[In]()> ByVal MU As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal POINT As Integer(), _
    ByRef NPOINT As Integer, _
    <Out()> ByVal ADRES As Integer(), _
    ByRef NADRES As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E02ZKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    <[In](),Out()> ByVal IOPTS As Integer(), _
    ByRef LIOPTS As Integer, _
    <[In](),Out()> ByVal OPTS As Double(), _
    ByRef LOPTS As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Sub E02ZLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByRef IVALUE As Integer, _
    ByRef RVALUE As Double, _
    ByVal CVALUE As string, _
    ByRef OPTYPE As Integer, _
    <[In]()> ByVal IOPTS As Integer(), _
    <[In]()> ByVal OPTS As Double(), _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long, _
    ByVal CVALUELength As long _
    )


' chapter e04

  Delegate Sub E04ABA_FUNCT_DELEGATE( _
    ByRef XC As Double, _
    ByRef FC As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04ABA Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUNCT As E04ABA_FUNCT_DELEGATE, _
    ByRef E1 As Double, _
    ByRef E2 As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef MAXCAL As Integer, _
    ByRef X As Double, _
    ByRef F As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )

  Delegate Sub E04ABF_FUNCT_DELEGATE( _
    ByRef XC As Double, _
    ByRef FC As Double _
  )

   Declare Sub E04ABF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUNCT As E04ABF_FUNCT_DELEGATE, _
    ByRef E1 As Double, _
    ByRef E2 As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef MAXCAL As Integer, _
    ByRef X As Double, _
    ByRef F As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04BBA_FUNCT_DELEGATE( _
    ByRef XC As Double, _
    ByRef FC As Double, _
    ByRef GC As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04BBA Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUNCT As E04BBA_FUNCT_DELEGATE, _
    ByRef E1 As Double, _
    ByRef E2 As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef MAXCAL As Integer, _
    ByRef X As Double, _
    ByRef F As Double, _
    ByRef G As Double, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )

  Delegate Sub E04BBF_FUNCT_DELEGATE( _
    ByRef XC As Double, _
    ByRef FC As Double, _
    ByRef GC As Double _
  )

   Declare Sub E04BBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUNCT As E04BBF_FUNCT_DELEGATE, _
    ByRef E1 As Double, _
    ByRef E2 As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef MAXCAL As Integer, _
    ByRef X As Double, _
    ByRef F As Double, _
    ByRef G As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04CBF_FUNCT_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04CBF_MONIT_DELEGATE( _
    ByRef FMIN As Double, _
    ByRef FMAX As Double, _
    ByVal SIM_rptr As IntPtr, _
    ByRef N As Integer, _
    ByRef NCALL As Integer, _
    ByRef SERROR As Double, _
    ByRef VRATIO As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04CBK Lib "NLW6I31DE_nag.dll" ( _
    ByRef FMIN As Double, _
    ByRef FMAX As Double, _
    ByVal SIM_rptr As IntPtr, _
    ByRef N As Integer, _
    ByRef NCALL As Integer, _
    ByRef SERROR As Double, _
    ByRef VRATIO As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04CBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef F As Double, _
    ByRef TOLF As Double, _
    ByRef TOLX As Double, _
    ByVal FUNCT As E04CBF_FUNCT_DELEGATE, _
    ByVal MONIT As E04CBF_MONIT_DELEGATE, _
    ByRef MAXCAL As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )




  Delegate Sub E04DGA_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04DGA Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal OBJFUN As E04DGA_OBJFUN_DELEGATE, _
    ByRef ITER As Integer, _
    ByRef OBJF As Double, _
    <Out()> ByVal OBJGRD As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal WORK As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )

  Delegate Sub E04DGF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04DGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal OBJFUN As E04DGF_OBJFUN_DELEGATE, _
    ByRef ITER As Integer, _
    ByRef OBJF As Double, _
    <Out()> ByVal OBJGRD As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal WORK As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04DJA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04DJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )


   Declare Sub E04DKA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04DKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


  Delegate Sub E04FCF_LSQFUN_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04FCF_LSQMON_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal S_rptr As IntPtr, _
    ByRef IGRADE As Integer, _
    ByRef NITER As Integer, _
    ByRef NF As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04FDZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal S_rptr As IntPtr, _
    ByRef IGRADE As Integer, _
    ByRef NITER As Integer, _
    ByRef NF As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04FCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByVal LSQFUN As E04FCF_LSQFUN_DELEGATE, _
    ByVal LSQMON As E04FCF_LSQMON_DELEGATE, ByRef IPRINT As Integer, ByRef MAXCAL As Integer, _
    ByRef ETA As Double, ByRef XTOL As Double, ByRef STEPMX As Double, _
    <[In](),Out()> ByVal X As Double(), ByRef FSUMSQ As Double, <Out()> ByVal FVEC As Double(), _
    <Out()> ByVal FJAC As Double(,), ByRef LDFJAC As Integer, <Out()> ByVal S As Double(), _
    <Out()> ByVal V As Double(,), ByRef LDV As Integer, ByRef NITER As Integer, _
    ByRef NF As Integer, <[In](),Out()> ByVal IW As Integer(), ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), ByRef LW As Integer, ByRef IFAIL As Integer _
   )




  Delegate Sub E04FFF_OBJFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByVal RX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04FFF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04FFU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04FFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OBJFUN As E04FFF_OBJFUN_DELEGATE, _
    ByVal MONIT As E04FFF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NRES As Integer, _
    <Out()> ByVal RX As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )




   Declare Sub E04FGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef NEVAL As Integer, _
    ByRef MAXEVAL As Integer, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef NRES As Integer, _
    <[In](),Out()> ByVal RX As Double(,), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04FYF_LSFUN1_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04FYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal LSFUN1 As E04FYF_LSFUN1_DELEGATE, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef FSUMSQ As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04GBF_LSQLIN_DELEGATE( _
    ByRef SELCT As Integer _
  )

   Declare Sub E04FCV Lib "NLW6I31DE_nag.dll" ( _
    ByRef SELCT As Integer _
  )

   Declare Sub E04HEV Lib "NLW6I31DE_nag.dll" ( _
    ByRef SELCT As Integer _
  )

  Delegate Sub E04GBF_LSQFUN_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04GBF_LSQMON_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal S_rptr As IntPtr, _
    ByRef IGRADE As Integer, _
    ByRef NITER As Integer, _
    ByRef NF As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )


   Declare Sub E04GBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByVal LSQLIN As E04GBF_LSQLIN_DELEGATE, _
    ByVal LSQFUN As E04GBF_LSQFUN_DELEGATE, ByVal LSQMON As E04GBF_LSQMON_DELEGATE, ByRef IPRINT As Integer, _
    ByRef MAXCAL As Integer, ByRef ETA As Double, ByRef XTOL As Double, _
    ByRef STEPMX As Double, <[In](),Out()> ByVal X As Double(), ByRef FSUMSQ As Double, _
    <Out()> ByVal FVEC As Double(), <Out()> ByVal FJAC As Double(,), ByRef LDFJAC As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    ByRef NITER As Integer, ByRef NF As Integer, <[In](),Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, <[In](),Out()> ByVal W As Double(), ByRef LW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04GDF_LSQFUN_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04GDF_LSQMON_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal S_rptr As IntPtr, _
    ByRef IGRADE As Integer, _
    ByRef NITER As Integer, _
    ByRef NF As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )


   Declare Sub E04GDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByVal LSQFUN As E04GDF_LSQFUN_DELEGATE, _
    ByVal LSQMON As E04GDF_LSQMON_DELEGATE, ByRef IPRINT As Integer, ByRef MAXCAL As Integer, _
    ByRef ETA As Double, ByRef XTOL As Double, ByRef STEPMX As Double, _
    <[In](),Out()> ByVal X As Double(), ByRef FSUMSQ As Double, <Out()> ByVal FVEC As Double(), _
    <Out()> ByVal FJAC As Double(,), ByRef LDFJAC As Integer, <Out()> ByVal S As Double(), _
    <Out()> ByVal V As Double(,), ByRef LDV As Integer, ByRef NITER As Integer, _
    ByRef NF As Integer, <[In](),Out()> ByVal IW As Integer(), ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), ByRef LW As Integer, ByRef IFAIL As Integer _
   )


  Delegate Sub E04GGF_LSQFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByVal RX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GGF_LSQGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByRef NNZRD As Integer, _
    ByVal RDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GGF_LSQHES_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByVal LAMBDA_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04GGU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByVal LAMBDA_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GGF_LSQHPRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByVal HXY_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04GGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByVal HXY_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GGF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )


   Declare Sub E04GGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal LSQFUN As E04GGF_LSQFUN_DELEGATE, _
    ByVal LSQGRD As E04GGF_LSQGRD_DELEGATE, _
    ByVal LSQHES As E04GGF_LSQHES_DELEGATE, _
    ByVal LSQHPRD As E04GGF_LSQHPRD_DELEGATE, _
    ByVal MONIT As E04GGF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NRES As Integer, _
    <Out()> ByVal RX As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04GNF_LSQFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByVal RX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GNF_LSQGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NRES As Integer, _
    ByRef NNZRD As Integer, _
    ByVal RDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GNF_CONFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByVal GX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04STX Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByVal GX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GNF_CONGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZGD As Integer, _
    ByVal GDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04STY Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZGD As Integer, _
    ByVal GDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04GNF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )


   Declare Sub E04GNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal LSQFUN As E04GNF_LSQFUN_DELEGATE, _
    ByVal LSQGRD As E04GNF_LSQGRD_DELEGATE, _
    ByVal CONFUN As E04GNF_CONFUN_DELEGATE, _
    ByVal CONGRD As E04GNF_CONGRD_DELEGATE, _
    ByVal MONIT As E04GNF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NRES As Integer, _
    <Out()> ByVal RX As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04GYF_LSFUN2_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04GYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal LSFUN2 As E04GYF_LSFUN2_DELEGATE, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef FSUMSQ As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04GZF_LSFUN2_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04GZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal LSFUN2 As E04GZF_LSFUN2_DELEGATE, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef FSUMSQ As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04HCF_FUNCT_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04HCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal FUNCT As E04HCF_FUNCT_DELEGATE, _
    <[In]()> ByVal X As Double(), _
    ByRef F As Double, _
    <Out()> ByVal G As Double(), _
    <[In](),Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04HDF_FUNCT_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04HDF_H_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FHESL_rptr As IntPtr, _
    ByRef LH As Integer, _
    ByVal FHESD_rptr As IntPtr, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04HDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal FUNCT As E04HDF_FUNCT_DELEGATE, _
    ByVal H As E04HDF_H_DELEGATE, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal G As Double(), _
    <Out()> ByVal HESL As Double(), _
    ByRef LH As Integer, _
    <Out()> ByVal HESD As Double(), _
    <[In](),Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04HEF_LSQFUN_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04HEF_LSQHES_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal XC_rptr As IntPtr, _
    ByVal B_rptr As IntPtr, _
    ByRef LB As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04HEF_LSQMON_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal S_rptr As IntPtr, _
    ByRef IGRADE As Integer, _
    ByRef NITER As Integer, _
    ByRef NF As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )


   Declare Sub E04HEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByVal LSQFUN As E04HEF_LSQFUN_DELEGATE, _
    ByVal LSQHES As E04HEF_LSQHES_DELEGATE, ByVal LSQMON As E04HEF_LSQMON_DELEGATE, ByRef IPRINT As Integer, _
    ByRef MAXCAL As Integer, ByRef ETA As Double, ByRef XTOL As Double, _
    ByRef STEPMX As Double, <[In](),Out()> ByVal X As Double(), ByRef FSUMSQ As Double, _
    <Out()> ByVal FVEC As Double(), <Out()> ByVal FJAC As Double(,), ByRef LDFJAC As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    ByRef NITER As Integer, ByRef NF As Integer, <[In](),Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, <[In](),Out()> ByVal W As Double(), ByRef LW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04HYF_LSFUN2_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04HYF_LSHES2_DELEGATE( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal XC_rptr As IntPtr, _
    ByVal B_rptr As IntPtr, _
    ByRef LB As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04HYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal LSFUN2 As E04HYF_LSFUN2_DELEGATE, _
    ByVal LSHES2 As E04HYF_LSHES2_DELEGATE, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef FSUMSQ As Double, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04JCF_OBJFUN_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef F As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

  Delegate Sub E04JCF_MONFUN_DELEGATE( _
    ByRef N As Integer, _
    ByRef NF As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef F As Double, _
    ByRef RHO As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04JCP Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NF As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef F As Double, _
    ByRef RHO As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04JCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OBJFUN As E04JCF_OBJFUN_DELEGATE, _
    ByRef N As Integer, _
    ByRef NPT As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), _
    ByRef RHOBEG As Double, _
    ByRef RHOEND As Double, _
    ByVal MONFUN As E04JCF_MONFUN_DELEGATE, _
    ByRef MAXCAL As Integer, _
    ByRef F As Double, _
    ByRef NF As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04JDF_OBJFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04JDV Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04JDF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04JDU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04JDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OBJFUN As E04JDF_OBJFUN_DELEGATE, _
    ByVal MONIT As E04JDF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )




   Declare Sub E04JEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef NEVAL As Integer, _
    ByRef MAXEVAL As Integer, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    <[In](),Out()> ByVal F As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04JYF_FUNCT1_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04JYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef IBOUND As Integer, _
    ByVal FUNCT1 As E04JYF_FUNCT1_DELEGATE, _
    <[In](),Out()> ByVal BL As Double(), _
    <[In](),Out()> ByVal BU As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef F As Double, _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04KDF_FUNCT_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04KDF_MONIT_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal ISTATE_iptr As IntPtr, _
    ByRef GPJNRM As Double, _
    ByRef COND As Double, _
    ByRef POSDEF As Integer, _
    ByRef NITER As Integer, _
    ByRef NF As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04KDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByVal FUNCT As E04KDF_FUNCT_DELEGATE, ByVal MONIT As E04KDF_MONIT_DELEGATE, _
    ByRef IPRINT As Integer, ByRef MAXCAL As Integer, ByRef ETA As Double, _
    ByRef XTOL As Double, ByRef DELTA As Double, ByRef STEPMX As Double, _
    ByRef IBOUND As Integer, <[In](),Out()> ByVal BL As Double(), <[In](),Out()> ByVal BU As Double(), _
    <[In](),Out()> ByVal X As Double(), <Out()> ByVal HESL As Double(), ByRef LH As Integer, _
    <Out()> ByVal HESD As Double(), <Out()> ByVal ISTATE As Integer(), ByRef F As Double, _
    <Out()> ByVal G As Double(), <[In](),Out()> ByVal IW As Integer(), ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), ByRef LW As Integer, ByRef IFAIL As Integer _
   )


  Delegate Sub E04KFF_OBJFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04KFV Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04KFF_OBJGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZFD As Integer, _
    ByVal FDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04KFW Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZFD As Integer, _
    ByVal FDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04KFF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04KFU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04KFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OBJFUN As E04KFF_OBJFUN_DELEGATE, _
    ByVal OBJGRD As E04KFF_OBJGRD_DELEGATE, _
    ByVal MONIT As E04KFF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )




  Delegate Sub E04KYF_FUNCT2_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04KYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef IBOUND As Integer, _
    ByVal FUNCT2 As E04KYF_FUNCT2_DELEGATE, _
    <[In](),Out()> ByVal BL As Double(), _
    <[In](),Out()> ByVal BU As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef F As Double, _
    <Out()> ByVal G As Double(), _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04KZF_FUNCT2_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04KZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef IBOUND As Integer, _
    ByVal FUNCT2 As E04KZF_FUNCT2_DELEGATE, _
    <[In](),Out()> ByVal BL As Double(), _
    <[In](),Out()> ByVal BU As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef F As Double, _
    <Out()> ByVal G As Double(), _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04LBF_FUNCT_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04LBF_H_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FHESL_rptr As IntPtr, _
    ByRef LH As Integer, _
    ByVal FHESD_rptr As IntPtr, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04LBF_MONIT_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal ISTATE_iptr As IntPtr, _
    ByRef GPJNRM As Double, _
    ByRef COND As Double, _
    ByRef POSDEF As Integer, _
    ByRef NITER As Integer, _
    ByRef NF As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04LBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByVal FUNCT As E04LBF_FUNCT_DELEGATE, ByVal H As E04LBF_H_DELEGATE, _
    ByVal MONIT As E04LBF_MONIT_DELEGATE, ByRef IPRINT As Integer, ByRef MAXCAL As Integer, _
    ByRef ETA As Double, ByRef XTOL As Double, ByRef STEPMX As Double, _
    ByRef IBOUND As Integer, <[In](),Out()> ByVal BL As Double(), <[In](),Out()> ByVal BU As Double(), _
    <[In](),Out()> ByVal X As Double(), <Out()> ByVal HESL As Double(), ByRef LH As Integer, _
    <Out()> ByVal HESD As Double(), <Out()> ByVal ISTATE As Integer(), ByRef F As Double, _
    <Out()> ByVal G As Double(), <[In](),Out()> ByVal IW As Integer(), ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), ByRef LW As Integer, ByRef IFAIL As Integer _
   )


  Delegate Sub E04LYF_FUNCT2_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByRef FC As Double, _
    ByVal GC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04LYF_HESS2_DELEGATE( _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal HESLC_rptr As IntPtr, _
    ByRef LH As Integer, _
    ByVal HESDC_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04LYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef IBOUND As Integer, _
    ByVal FUNCT2 As E04LYF_FUNCT2_DELEGATE, _
    ByVal HESS2 As E04LYF_HESS2_DELEGATE, _
    <[In](),Out()> ByVal BL As Double(), _
    <[In](),Out()> ByVal BU As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef F As Double, _
    <Out()> ByVal G As Double(), _
    <Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04MFA Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NCLIN As Integer, <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), _
    <[In]()> ByVal CVEC As Double(), <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal X As Double(), _
    ByRef ITER As Integer, ByRef OBJ As Double, <Out()> ByVal AX As Double(), _
    <Out()> ByVal CLAMDA As Double(), <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer _
   )

   Declare Sub E04MFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NCLIN As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), _
    <[In]()> ByVal CVEC As Double(), _
    <[In](),Out()> ByVal ISTATE As Integer(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef ITER As Integer, _
    ByRef OBJ As Double, _
    <Out()> ByVal AX As Double(), _
    <Out()> ByVal CLAMDA As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04MGA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04MGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )


   Declare Sub E04MHA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04MHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


  Delegate Sub E04MKF_MONIT_DELEGATE( _
    ByRef HANDLE As IntPtr, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04MKU Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04MKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NNZU As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    ByVal MONIT As E04MKF_MONIT_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )




  Delegate Sub E04MTF_MONIT_DELEGATE( _
    ByRef HANDLE As IntPtr, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04MTU Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04MTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NNZU As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    ByVal MONIT As E04MTF_MONIT_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )




   Declare Sub E04MWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef OUTFILE As Integer, ByRef N As Integer, ByRef M As Integer, _
    ByRef NNZC As Integer, ByRef NNZA As Integer, ByRef NCOLH As Integer, _
    ByRef NNZH As Integer, ByRef LINTVAR As Integer, <[In]()> ByVal IDXC As Integer(), _
    <[In]()> ByVal C As Double(), ByRef IOBJ As Integer, <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROWA As Integer(), <[In]()> ByVal ICCOLA As Integer(), <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), ByVal PNAMES As string, ByRef NNAME As Integer, _
    ByVal CRNAME As string, <[In]()> ByVal H As Double(), <[In]()> ByVal IROWH As Integer(), _
    <[In]()> ByVal ICCOLH As Integer(), ByRef MINMAX As Integer, <[In]()> ByVal INTVAR As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal PNAMESLength As long, _
    ByVal CRNAMELength As long _
    )


   Declare Sub E04MXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef INFILE As Integer, ByRef MAXN As Integer, ByRef MAXM As Integer, _
    ByRef MAXNNZ As Integer, ByRef MAXNCOLH As Integer, ByRef MAXNNZH As Integer, _
    ByRef MAXLINTVAR As Integer, ByRef MPSLST As Integer, ByRef N As Integer, _
    ByRef M As Integer, ByRef NNZ As Integer, ByRef NCOLH As Integer, _
    ByRef NNZH As Integer, ByRef LINTVAR As Integer, ByRef IOBJ As Integer, _
    <Out()> ByVal A As Double(), <Out()> ByVal IROWA As Integer(), <Out()> ByVal ICCOLA As Integer(), _
    <Out()> ByVal BL As Double(), <Out()> ByVal BU As Double(), ByVal PNAMES As string, _
    ByRef NNAME As Integer, ByVal CRNAME As string, <Out()> ByVal H As Double(), _
    <Out()> ByVal IROWH As Integer(), <Out()> ByVal ICCOLH As Integer(), ByRef MINMAX As Integer, _
    <Out()> ByVal INTVAR As Integer(), ByRef IFAIL As Integer, _
    ByVal PNAMESLength As long, _
    ByVal CRNAMELength As long _
    )


   Declare Sub E04MZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef INFILE As Integer, ByRef MAXN As Integer, ByRef MAXM As Integer, _
    ByRef MAXNNZ As Integer, ByRef XBLDEF As Double, ByRef XBUDEF As Double, _
    ByRef MPSLST As Integer, ByRef N As Integer, ByRef M As Integer, _
    ByRef NNZ As Integer, ByRef IOBJ As Integer, ByRef NCOLH As Integer, _
    <Out()> ByVal A As Double(), <Out()> ByVal HA As Integer(), <Out()> ByVal KA As Integer(), _
    <Out()> ByVal BL As Double(), <Out()> ByVal BU As Double(), ByVal START As string, _
    ByVal NAMES As string, ByRef NNAME As Integer, ByVal CRNAME As string, _
    <Out()> ByVal XS As Double(), <Out()> ByVal ISTATE As Integer(), ByRef IFAIL As Integer, _
    ByVal STARTLength As long, _
    ByVal NAMESLength As long, _
    ByVal CRNAMELength As long _
    )


   Declare Sub E04NCA Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByRef NCLIN As Integer, _
    ByRef LDC As Integer, ByRef LDA As Integer, <[In]()> ByVal C As Double(,), _
    <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), <[In]()> ByVal CVEC As Double(), _
    <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal KX As Integer(), <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal A As Double(,), <[In](),Out()> ByVal B As Double(), ByRef ITER As Integer, _
    ByRef OBJ As Double, <Out()> ByVal CLAMDA As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )

   Declare Sub E04NCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByRef NCLIN As Integer, _
    ByRef LDC As Integer, ByRef LDA As Integer, <[In]()> ByVal C As Double(,), _
    <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), <[In]()> ByVal CVEC As Double(), _
    <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal KX As Integer(), <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal A As Double(,), <[In](),Out()> ByVal B As Double(), ByRef ITER As Integer, _
    ByRef OBJ As Double, <Out()> ByVal CLAMDA As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04NDA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04NDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )


   Declare Sub E04NEA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04NEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


  Delegate Sub E04NFA_QPHESS_DELEGATE( _
    ByRef N As Integer, _
    ByRef JTHCOL As Integer, _
    ByVal H_rptr As IntPtr, _
    ByRef LDH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal IWSAV_iptr As IntPtr _
  )

   Declare Sub E54NFU Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef JTHCOL As Integer, _
    ByVal H_rptr As IntPtr, _
    ByRef LDH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal IWSAV_iptr As IntPtr _
  )

   Declare Sub E04NFA Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NCLIN As Integer, <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), _
    <[In]()> ByVal CVEC As Double(), <[In]()> ByVal H As Double(,), ByRef LDH As Integer, _
    ByVal QPHESS As E04NFA_QPHESS_DELEGATE, <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal X As Double(), _
    ByRef ITER As Integer, ByRef OBJ As Double, <Out()> ByVal AX As Double(), _
    <Out()> ByVal CLAMDA As Double(), <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer _
   )

  Delegate Sub E04NFF_QPHESS_DELEGATE( _
    ByRef N As Integer, _
    ByRef JTHCOL As Integer, _
    ByVal H_rptr As IntPtr, _
    ByRef LDH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr _
  )

   Declare Sub E04NFU Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef JTHCOL As Integer, _
    ByVal H_rptr As IntPtr, _
    ByRef LDH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr _
  )

   Declare Sub E04NFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NCLIN As Integer, <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), _
    <[In]()> ByVal CVEC As Double(), <[In]()> ByVal H As Double(,), ByRef LDH As Integer, _
    ByVal QPHESS As E04NFF_QPHESS_DELEGATE, <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal X As Double(), _
    ByRef ITER As Integer, ByRef OBJ As Double, <Out()> ByVal AX As Double(), _
    <Out()> ByVal CLAMDA As Double(), <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, ByRef IFAIL As Integer _
   )


   Declare Sub E04NGA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04NGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )


   Declare Sub E04NHA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04NHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


  Delegate Sub E04NKA_QPHX_DELEGATE( _
    ByRef NSTATE As Integer, _
    ByRef NCOLH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E54NKU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NSTATE As Integer, _
    ByRef NCOLH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04NKA Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef M As Integer, ByRef NNZ As Integer, _
    ByRef IOBJ As Integer, ByRef NCOLH As Integer, ByVal QPHX As E04NKA_QPHX_DELEGATE, _
    <[In](),Out()> ByVal A As Double(), <[In]()> ByVal HA As Integer(), <[In]()> ByVal KA As Integer(), _
    <[In](),Out()> ByVal BL As Double(), <[In](),Out()> ByVal BU As Double(), ByVal START As string, _
    ByVal NAMES As string, ByRef NNAME As Integer, ByVal CRNAME As string, _
    ByRef NS As Integer, <[In](),Out()> ByVal XS As Double(), <[In](),Out()> ByVal ISTATE As Integer(), _
    ByRef MINIZ As Integer, ByRef MINZ As Integer, ByRef NINF As Integer, _
    ByRef SINF As Double, ByRef OBJ As Double, <Out()> ByVal CLAMDA As Double(), _
    <Out()> ByVal IZ As Integer(), ByRef LENIZ As Integer, <Out()> ByVal Z As Double(), _
    ByRef LENZ As Integer, <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STARTLength As long, _
    ByVal NAMESLength As long, _
    ByVal CRNAMELength As long _
    )

  Delegate Sub E04NKF_QPHX_DELEGATE( _
    ByRef NSTATE As Integer, _
    ByRef NCOLH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr _
  )

   Declare Sub E04NKU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NSTATE As Integer, _
    ByRef NCOLH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr _
  )

   Declare Sub E04NKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef M As Integer, ByRef NNZ As Integer, _
    ByRef IOBJ As Integer, ByRef NCOLH As Integer, ByVal QPHX As E04NKF_QPHX_DELEGATE, _
    <[In](),Out()> ByVal A As Double(), <[In]()> ByVal HA As Integer(), <[In]()> ByVal KA As Integer(), _
    <[In](),Out()> ByVal BL As Double(), <[In](),Out()> ByVal BU As Double(), ByVal START As string, _
    ByVal NAMES As string, ByRef NNAME As Integer, ByVal CRNAME As string, _
    ByRef NS As Integer, <[In](),Out()> ByVal XS As Double(), <[In](),Out()> ByVal ISTATE As Integer(), _
    ByRef MINIZ As Integer, ByRef MINZ As Integer, ByRef NINF As Integer, _
    ByRef SINF As Double, ByRef OBJ As Double, <Out()> ByVal CLAMDA As Double(), _
    <Out()> ByVal IZ As Integer(), ByRef LENIZ As Integer, <Out()> ByVal Z As Double(), _
    ByRef LENZ As Integer, ByRef IFAIL As Integer, _
    ByVal STARTLength As long, _
    ByVal NAMESLength As long, _
    ByVal CRNAMELength As long _
    )





   Declare Sub E04NLA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04NLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )


   Declare Sub E04NMA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04NMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


   Declare Sub E04NPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CW As string, _
    ByRef LENCW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LENIW As Integer, _
    <Out()> ByVal RW As Double(), _
    ByRef LENRW As Integer, _
    ByRef IFAIL As Integer, _
    ByVal CWLength As long _
    )


  Delegate Sub E04NQF_QPHX_DELEGATE( _
    ByRef NCOLH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal CUSER_chptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal CUSER_chptrLength As long _
   )

   Declare Sub E04NSH Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCOLH As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal HX_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal CUSER_chptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal CUSER_chptrLength As long _
   )

   Declare Sub E04NQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal START As string, ByVal QPHX As E04NQF_QPHX_DELEGATE, ByRef M As Integer, _
    ByRef N As Integer, ByRef NE As Integer, ByRef NNAME As Integer, _
    ByRef LENC As Integer, ByRef NCOLH As Integer, ByRef IOBJ As Integer, _
    ByRef OBJADD As Double, ByVal PROB As string, <[In](),Out()> ByVal ACOL As Double(), _
    <[In]()> ByVal INDA As Integer(), <[In]()> ByVal LOCA As Integer(), <[In](),Out()> ByVal BL As Double(), _
    <[In](),Out()> ByVal BU As Double(), <[In](),Out()> ByVal C As Double(), ByVal NAMES As string, _
    <[In]()> ByVal HELAST As Integer(), <[In](),Out()> ByVal HS As Integer(), <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal PI As Double(), <Out()> ByVal RC As Double(), ByRef NS As Integer, _
    ByRef NINF As Integer, ByRef SINF As Double, ByRef OBJ As Double, _
    ByVal CW As string, ByRef LENCW As Integer, <[In](),Out()> ByVal IW As Integer(), _
    ByRef LENIW As Integer, <[In](),Out()> ByVal RW As Double(), ByRef LENRW As Integer, _
    ByVal CUSER As string, <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STARTLength As long, _
    ByVal PROBLength As long, _
    ByVal NAMESLength As long, _
    ByVal CWLength As long, _
    ByVal CUSERLength As long _
    )


   Declare Sub E04NRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ISPECS As Integer, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal CWLength As long _
    )


   Declare Sub E04NSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )




   Declare Sub E04NTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef IVALUE As Integer, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04NUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef RVALUE As Double, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04NXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef IVALUE As Integer, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04NYF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef RVALUE As Double, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04PCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(), _
    <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), _
    ByRef TOL As Double, _
    <Out()> ByVal X As Double(), _
    ByRef RNORM As Double, _
    ByRef NFREE As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal INDX As Integer(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04PTF_MONIT_DELEGATE( _
    ByRef HANDLE As IntPtr, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04PTU Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E04PTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NNZU As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    ByRef NNZUC As Integer, _
    <[In](),Out()> ByVal UC As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    ByVal MONIT As E04PTF_MONIT_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )




   Declare Sub E04RAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal GTYPE As string, _
    ByRef LGROUP As Integer, _
    <[In]()> ByVal GROUP As Integer(), _
    ByRef IDGROUP As Integer, _
    ByRef IFAIL As Integer, _
    ByVal GTYPELength As long _
    )


   Declare Sub E04RCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal PTYPE As string, _
    ByRef LIDX As Integer, _
    <[In]()> ByVal IDX As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal PTYPELength As long _
    )


   Declare Sub E04RDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef INFILE As Integer, _
    ByRef MAXNVAR As Integer, _
    ByRef MAXNBLK As Integer, _
    ByRef MAXNNZ As Integer, _
    ByRef FILELST As Integer, _
    ByRef NVAR As Integer, _
    ByRef NBLK As Integer, _
    ByRef NNZ As Integer, _
    <Out()> ByVal CVEC As Double(), _
    <Out()> ByVal NNZA As Integer(), _
    <Out()> ByVal IROWA As Integer(), _
    <Out()> ByVal ICOLA As Integer(), _
    <Out()> ByVal A As Double(), _
    <Out()> ByVal BLKSIZEA As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04REF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    <[In]()> ByVal CVEC As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NNZC As Integer, _
    <[In]()> ByVal IDXC As Integer(), _
    <[In]()> ByVal C As Double(), _
    ByRef NNZH As Integer, _
    <[In]()> ByVal IROWH As Integer(), _
    <[In]()> ByVal ICOLH As Integer(), _
    <[In]()> ByVal H As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NNZFD As Integer, _
    <[In]()> ByVal IDXFD As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NCLIN As Integer, _
    <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), _
    ByRef NNZB As Integer, _
    <[In]()> ByVal IROWB As Integer(), _
    <[In]()> ByVal ICOLB As Integer(), _
    <[In]()> ByVal B As Double(), _
    ByRef IDLC As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NCNLN As Integer, _
    <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), _
    ByRef NNZGD As Integer, _
    <[In]()> ByVal IROWGD As Integer(), _
    <[In]()> ByVal ICOLGD As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IDF As Integer, _
    ByRef NNZH As Integer, _
    <[In]()> ByVal IROWH As Integer(), _
    <[In]()> ByVal ICOLH As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NRES As Integer, _
    ByRef ISPARSE As Integer, _
    ByRef NNZRD As Integer, _
    <[In]()> ByVal IROWRD As Integer(), _
    <[In]()> ByVal ICOLRD As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    ByRef DIMA As Integer, _
    <[In]()> ByVal NNZA As Integer(), _
    ByRef NNZASUM As Integer, _
    <[In]()> ByVal IROWA As Integer(), _
    <[In]()> ByVal ICOLA As Integer(), _
    <[In]()> ByVal A As Double(), _
    ByRef NBLK As Integer, _
    <[In]()> ByVal BLKSIZEA As Integer(), _
    ByRef IDBLK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NQ As Integer, _
    <[In]()> ByVal QI As Integer(), _
    <[In]()> ByVal QJ As Integer(), _
    ByRef DIMQ As Integer, _
    <[In]()> ByVal NNZQ As Integer(), _
    ByRef NNZQSUM As Integer, _
    <[In]()> ByVal IROWQ As Integer(), _
    <[In]()> ByVal ICOLQ As Integer(), _
    <[In]()> ByVal Q As Double(), _
    ByRef IDBLK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef S As Double, _
    ByRef NNZR As Integer, _
    <[In]()> ByVal IDXR As Integer(), _
    <[In]()> ByVal R As Double(), _
    ByRef NNZQ As Integer, _
    <[In]()> ByVal IROWQ As Integer(), _
    <[In]()> ByVal ICOLQ As Integer(), _
    <[In]()> ByVal Q As Double(), _
    ByRef IDQC As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef S As Double, _
    ByRef NNZR As Integer, _
    <[In]()> ByVal IDXR As Integer(), _
    <[In]()> ByVal R As Double(), _
    ByRef MF As Integer, _
    ByRef NNZF As Integer, _
    <[In]()> ByVal IROWF As Integer(), _
    <[In]()> ByVal ICOLF As Integer(), _
    <[In]()> ByVal F As Double(), _
    ByRef IDQC As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04RWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal CMDSTR As string, _
    ByRef IOFLAG As Integer, _
    ByRef LIARR As Integer, _
    <[In](),Out()> ByVal IARR As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal CMDSTRLength As long _
    )


   Declare Sub E04RXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal CMDSTR As string, _
    ByRef IOFLAG As Integer, _
    ByRef LRARR As Integer, _
    <[In](),Out()> ByVal RARR As Double(), _
    ByRef IFAIL As Integer, _
    ByVal CMDSTRLength As long _
    )


   Declare Sub E04RYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NOUT As Integer, _
    ByVal CMDSTR As string, _
    ByRef IFAIL As Integer, _
    ByVal CMDSTRLength As long _
    )


   Declare Sub E04RZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04SAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal FILE As string, _
    ByVal FTYPE As string, _
    <Out()> ByVal PINFO As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal FILELength As long, _
    ByVal FTYPELength As long _
    )


  Delegate Sub E04SRF_OBJFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04SRV Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04SRF_OBJGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZFD As Integer, _
    ByVal FDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04SRW Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZFD As Integer, _
    ByVal FDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04SRF_CONFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByVal GX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04SRX Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByVal GX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04SRF_CONGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZGD As Integer, _
    ByVal GDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04SRY Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZGD As Integer, _
    ByVal GDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04SRF_HESS_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByRef IDF As Integer, _
    ByRef SIGMA As Double, _
    ByVal LAMBDA_rptr As IntPtr, _
    ByRef NNZH As Integer, _
    ByVal HX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04SRZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByRef IDF As Integer, _
    ByRef SIGMA As Double, _
    ByVal LAMBDA_rptr As IntPtr, _
    ByRef NNZH As Integer, _
    ByVal HX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04SRF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZU As Integer, _
    ByVal U_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04SRU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZU As Integer, _
    ByVal U_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04SRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OBJFUN As E04SRF_OBJFUN_DELEGATE, _
    ByVal OBJGRD As E04SRF_OBJGRD_DELEGATE, _
    ByVal CONFUN As E04SRF_CONFUN_DELEGATE, _
    ByVal CONGRD As E04SRF_CONGRD_DELEGATE, _
    ByVal HESS As E04SRF_HESS_DELEGATE, _
    ByVal MONIT As E04SRF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NNZU As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04STF_OBJFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04STV Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04STF_OBJGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZFD As Integer, _
    ByVal FDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04STW Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZFD As Integer, _
    ByVal FDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04STF_CONFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByVal GX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )


  Delegate Sub E04STF_CONGRD_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZGD As Integer, _
    ByVal GDX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )


  Delegate Sub E04STF_HESS_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByRef IDF As Integer, _
    ByRef SIGMA As Double, _
    ByVal LAMBDA_rptr As IntPtr, _
    ByRef NNZH As Integer, _
    ByVal HX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04STZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NCNLN As Integer, _
    ByRef IDF As Integer, _
    ByRef SIGMA As Double, _
    ByVal LAMBDA_rptr As IntPtr, _
    ByRef NNZH As Integer, _
    ByVal HX_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

  Delegate Sub E04STF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZU As Integer, _
    ByVal U_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04STU Lib "NLW6I31DE_nag.dll" ( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NNZU As Integer, _
    ByVal U_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )

   Declare Sub E04STF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OBJFUN As E04STF_OBJFUN_DELEGATE, _
    ByVal OBJGRD As E04STF_OBJGRD_DELEGATE, _
    ByVal CONFUN As E04STF_CONFUN_DELEGATE, _
    ByVal CONGRD As E04STF_CONGRD_DELEGATE, _
    ByVal HESS As E04STF_HESS_DELEGATE, _
    ByVal MONIT As E04STF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NNZU As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04SVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NVAR As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef NNZU As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    ByRef NNZUC As Integer, _
    <[In](),Out()> ByVal UC As Double(), _
    ByRef NNZUA As Integer, _
    <[In](),Out()> ByVal UA As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    ByRef INFORM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04TAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef NADD As Integer, _
    ByRef NVAR As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04TBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal COMP As string, _
    ByRef LIDX As Integer, _
    <[In]()> ByVal IDX As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal COMPLength As long _
    )


   Declare Sub E04TCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal COMP As string, _
    ByRef LIDX As Integer, _
    <[In]()> ByVal IDX As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal COMPLength As long _
    )


   Declare Sub E04TDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal COMP As string, _
    ByRef IDX As Integer, _
    ByRef BLI As Double, _
    ByRef BUI As Double, _
    ByRef IFAIL As Integer, _
    ByVal COMPLength As long _
    )


   Declare Sub E04TEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IDXCI As Integer, _
    ByRef CI As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04TJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IDLC As Integer, _
    ByRef ICOLBJ As Integer, _
    ByRef BIJ As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04UCA_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E54UDM Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04UCA_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04UCA Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NCLIN As Integer, ByRef NCNLN As Integer, _
    ByRef LDA As Integer, ByRef LDCJ As Integer, ByRef LDR As Integer, _
    <[In]()> ByVal A As Double(,), <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), _
    ByVal CONFUN As E04UCA_CONFUN_DELEGATE, ByVal OBJFUN As E04UCA_OBJFUN_DELEGATE, ByRef ITER As Integer, _
    <[In](),Out()> ByVal ISTATE As Integer(), <Out()> ByVal C As Double(), <[In](),Out()> ByVal CJAC As Double(,), _
    <[In](),Out()> ByVal CLAMDA As Double(), ByRef OBJF As Double, <Out()> ByVal OBJGRD As Double(), _
    <[In](),Out()> ByVal R As Double(,), <[In](),Out()> ByVal X As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer _
   )

  Delegate Sub E04UCF_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04UDM Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04UCF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04UCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NCLIN As Integer, ByRef NCNLN As Integer, _
    ByRef LDA As Integer, ByRef LDCJ As Integer, ByRef LDR As Integer, _
    <[In]()> ByVal A As Double(,), <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), _
    ByVal CONFUN As E04UCF_CONFUN_DELEGATE, ByVal OBJFUN As E04UCF_OBJFUN_DELEGATE, ByRef ITER As Integer, _
    <[In](),Out()> ByVal ISTATE As Integer(), <Out()> ByVal C As Double(), <[In](),Out()> ByVal CJAC As Double(,), _
    <[In](),Out()> ByVal CLAMDA As Double(), ByRef OBJF As Double, <Out()> ByVal OBJGRD As Double(), _
    <[In](),Out()> ByVal R As Double(,), <[In](),Out()> ByVal X As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), ByRef IFAIL As Integer _
   )


   Declare Sub E04UDA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04UDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )




   Declare Sub E04UEA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04UEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


   Declare Sub E04UFA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, ByRef N As Integer, ByRef NCLIN As Integer, _
    ByRef NCNLN As Integer, ByRef LDA As Integer, ByRef LDCJ As Integer, _
    ByRef LDR As Integer, <[In]()> ByVal A As Double(,), <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), ByRef ITER As Integer, <[In](),Out()> ByVal ISTATE As Integer(), _
    <[In](),Out()> ByVal C As Double(), <[In](),Out()> ByVal CJAC As Double(,), <[In](),Out()> ByVal CLAMDA As Double(), _
    ByRef OBJF As Double, <[In](),Out()> ByVal OBJGRD As Double(), <[In](),Out()> ByVal R As Double(,), _
    <[In](),Out()> ByVal X As Double(), <Out()> ByVal NEEDC As Integer(), <[In](),Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, <[In](),Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    ByVal CWSAV As string, <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer, _
    ByVal CWSAVLength As long _
    )

   Declare Sub E04UFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, ByRef N As Integer, ByRef NCLIN As Integer, _
    ByRef NCNLN As Integer, ByRef LDA As Integer, ByRef LDCJ As Integer, _
    ByRef LDR As Integer, <[In]()> ByVal A As Double(,), <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), ByRef ITER As Integer, <[In](),Out()> ByVal ISTATE As Integer(), _
    <[In](),Out()> ByVal C As Double(), <[In](),Out()> ByVal CJAC As Double(,), <[In](),Out()> ByVal CLAMDA As Double(), _
    ByRef OBJF As Double, <[In](),Out()> ByVal OBJGRD As Double(), <[In](),Out()> ByVal R As Double(,), _
    <[In](),Out()> ByVal X As Double(), <Out()> ByVal NEEDC As Integer(), <[In](),Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, <[In](),Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04UGA_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef NJNLN As Integer, _
    ByRef NNZJAC As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E54UGM Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef NJNLN As Integer, _
    ByRef NNZJAC As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04UGA_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NONLN As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E54UGN Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NONLN As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04UGA Lib "NLW6I31DE_nag.dll" ( _
    ByVal CONFUN As E04UGA_CONFUN_DELEGATE, ByVal OBJFUN As E04UGA_OBJFUN_DELEGATE, ByRef N As Integer, _
    ByRef M As Integer, ByRef NCNLN As Integer, ByRef NONLN As Integer, _
    ByRef NJNLN As Integer, ByRef IOBJ As Integer, ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), <[In]()> ByVal HA As Integer(), <[In]()> ByVal KA As Integer(), _
    <[In](),Out()> ByVal BL As Double(), <[In](),Out()> ByVal BU As Double(), ByVal START As string, _
    ByRef NNAME As Integer, ByVal NAMES As string, ByRef NS As Integer, _
    <[In](),Out()> ByVal XS As Double(), <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal CLAMDA As Double(), _
    ByRef MINIZ As Integer, ByRef MINZ As Integer, ByRef NINF As Integer, _
    ByRef SINF As Double, ByRef OBJ As Double, <Out()> ByVal IZ As Integer(), _
    ByRef LENIZ As Integer, <Out()> ByVal Z As Double(), ByRef LENZ As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), ByRef IFAIL As Integer, _
    ByVal STARTLength As long, _
    ByVal NAMESLength As long _
    )

  Delegate Sub E04UGF_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef NJNLN As Integer, _
    ByRef NNZJAC As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04UGM Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef NJNLN As Integer, _
    ByRef NNZJAC As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04UGF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NONLN As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04UGN Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NONLN As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04UGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CONFUN As E04UGF_CONFUN_DELEGATE, ByVal OBJFUN As E04UGF_OBJFUN_DELEGATE, ByRef N As Integer, _
    ByRef M As Integer, ByRef NCNLN As Integer, ByRef NONLN As Integer, _
    ByRef NJNLN As Integer, ByRef IOBJ As Integer, ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), <[In]()> ByVal HA As Integer(), <[In]()> ByVal KA As Integer(), _
    <[In](),Out()> ByVal BL As Double(), <[In](),Out()> ByVal BU As Double(), ByVal START As string, _
    ByRef NNAME As Integer, ByVal NAMES As string, ByRef NS As Integer, _
    <[In](),Out()> ByVal XS As Double(), <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal CLAMDA As Double(), _
    ByRef MINIZ As Integer, ByRef MINZ As Integer, ByRef NINF As Integer, _
    ByRef SINF As Double, ByRef OBJ As Double, <Out()> ByVal IZ As Integer(), _
    ByRef LENIZ As Integer, <Out()> ByVal Z As Double(), ByRef LENZ As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), ByRef IFAIL As Integer, _
    ByVal STARTLength As long, _
    ByVal NAMESLength As long _
    )






   Declare Sub E04UHA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04UHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )


   Declare Sub E04UJA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04UJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


   Declare Sub E04UQA Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer _
   )

   Declare Sub E04UQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTNS As Integer, _
    ByRef INFORM As Integer _
   )


   Declare Sub E04URA Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal LWSAV As Integer(), _
    <[In](),Out()> ByVal IWSAV As Integer(), _
    <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef INFORM As Integer, _
    ByVal STRLength As long _
    )

   Declare Sub E04URF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    ByVal STRLength As long  _
    )


  Delegate Sub E04USA_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


  Delegate Sub E04USA_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef LDFJ As Integer, _
    ByRef NEEDFI As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04USA Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByRef NCLIN As Integer, _
    ByRef NCNLN As Integer, ByRef LDA As Integer, ByRef LDCJ As Integer, _
    ByRef LDFJ As Integer, ByRef LDR As Integer, <[In]()> ByVal A As Double(,), _
    <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), <[In]()> ByVal Y As Double(), _
    ByVal CONFUN As E04USA_CONFUN_DELEGATE, ByVal OBJFUN As E04USA_OBJFUN_DELEGATE, ByRef ITER As Integer, _
    <[In](),Out()> ByVal ISTATE As Integer(), <Out()> ByVal C As Double(), <[In](),Out()> ByVal CJAC As Double(,), _
    <Out()> ByVal F As Double(), <[In](),Out()> ByVal FJAC As Double(,), <[In](),Out()> ByVal CLAMDA As Double(), _
    ByRef OBJF As Double, <[In](),Out()> ByVal R As Double(,), <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    <[In](),Out()> ByVal LWSAV As Integer(), <[In](),Out()> ByVal IWSAV As Integer(), <[In](),Out()> ByVal RWSAV As Double(), _
    ByRef IFAIL As Integer _
   )

  Delegate Sub E04USF_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


  Delegate Sub E04USF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef LDFJ As Integer, _
    ByRef NEEDFI As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04USF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByRef NCLIN As Integer, _
    ByRef NCNLN As Integer, ByRef LDA As Integer, ByRef LDCJ As Integer, _
    ByRef LDFJ As Integer, ByRef LDR As Integer, <[In]()> ByVal A As Double(,), _
    <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), <[In]()> ByVal Y As Double(), _
    ByVal CONFUN As E04USF_CONFUN_DELEGATE, ByVal OBJFUN As E04USF_OBJFUN_DELEGATE, ByRef ITER As Integer, _
    <[In](),Out()> ByVal ISTATE As Integer(), <Out()> ByVal C As Double(), <[In](),Out()> ByVal CJAC As Double(,), _
    <Out()> ByVal F As Double(), <[In](),Out()> ByVal FJAC As Double(,), <[In](),Out()> ByVal CLAMDA As Double(), _
    ByRef OBJF As Double, <[In](),Out()> ByVal R As Double(,), <[In](),Out()> ByVal X As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04VGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CW As string, _
    ByRef LENCW As Integer, _
    <Out()> ByVal IW As Integer(), _
    ByRef LENIW As Integer, _
    <Out()> ByVal RW As Double(), _
    ByRef LENRW As Integer, _
    ByRef IFAIL As Integer, _
    ByVal CWLength As long _
    )


  Delegate Sub E04VHF_USRFUN_DELEGATE( _
    ByRef STATUS As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NEEDF As Integer, _
    ByRef NF As Integer, _
    ByVal F_rptr As IntPtr, _
    ByRef NEEDG As Integer, _
    ByRef LENG As Integer, _
    ByVal G_rptr As IntPtr, _
    ByVal CUSER_chptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal CUSER_chptrLength As long _
   )

   Declare Sub E04VHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef START As Integer, ByRef NF As Integer, ByRef N As Integer, _
    ByRef NXNAME As Integer, ByRef NFNAME As Integer, ByRef OBJADD As Double, _
    ByRef OBJROW As Integer, ByVal PROB As string, ByVal USRFUN As E04VHF_USRFUN_DELEGATE, _
    <[In]()> ByVal IAFUN As Integer(), <[In]()> ByVal JAVAR As Integer(), <[In]()> ByVal A As Double(), _
    ByRef LENA As Integer, ByRef NEA As Integer, <[In]()> ByVal IGFUN As Integer(), _
    <[In]()> ByVal JGVAR As Integer(), ByRef LENG As Integer, ByRef NEG As Integer, _
    <[In]()> ByVal XLOW As Double(), <[In]()> ByVal XUPP As Double(), ByVal XNAMES As string, _
    <[In]()> ByVal FLOW As Double(), <[In]()> ByVal FUPP As Double(), ByVal FNAMES As string, _
    <[In](),Out()> ByVal X As Double(), <[In](),Out()> ByVal XSTATE As Integer(), <Out()> ByVal XMUL As Double(), _
    <[In](),Out()> ByVal F As Double(), <[In](),Out()> ByVal FSTATE As Integer(), <[In](),Out()> ByVal FMUL As Double(), _
    ByRef NS As Integer, ByRef NINF As Integer, ByRef SINF As Double, _
    ByVal CW As string, ByRef LENCW As Integer, <[In](),Out()> ByVal IW As Integer(), _
    ByRef LENIW As Integer, <[In](),Out()> ByVal RW As Double(), ByRef LENRW As Integer, _
    ByVal CUSER As string, <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer, _
    ByVal PROBLength As long, _
    ByVal XNAMESLength As long, _
    ByVal FNAMESLength As long, _
    ByVal CWLength As long, _
    ByVal CUSERLength As long _
    )


  Delegate Sub E04VJF_USRFUN_DELEGATE( _
    ByRef STATUS As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef NEEDF As Integer, _
    ByRef NF As Integer, _
    ByVal F_rptr As IntPtr, _
    ByRef NEEDG As Integer, _
    ByRef LENG As Integer, _
    ByVal G_rptr As IntPtr, _
    ByVal CUSER_chptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByVal CUSER_chptrLength As long _
   )

   Declare Sub E04VJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NF As Integer, ByRef N As Integer, ByVal USRFUN As E04VJF_USRFUN_DELEGATE, _
    <Out()> ByVal IAFUN As Integer(), <Out()> ByVal JAVAR As Integer(), <Out()> ByVal A As Double(), _
    ByRef LENA As Integer, ByRef NEA As Integer, <Out()> ByVal IGFUN As Integer(), _
    <Out()> ByVal JGVAR As Integer(), ByRef LENG As Integer, ByRef NEG As Integer, _
    <[In]()> ByVal X As Double(), <[In]()> ByVal XLOW As Double(), <[In]()> ByVal XUPP As Double(), _
    ByVal CW As string, ByRef LENCW As Integer, <[In](),Out()> ByVal IW As Integer(), _
    ByRef LENIW As Integer, <[In](),Out()> ByVal RW As Double(), ByRef LENRW As Integer, _
    ByVal CUSER As string, <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer, _
    ByVal CWLength As long, _
    ByVal CUSERLength As long _
    )


   Declare Sub E04VKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ISPECS As Integer, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal CWLength As long _
    )


   Declare Sub E04VLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04VMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef IVALUE As Integer, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04VNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef RVALUE As Double, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04VRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef IVALUE As Integer, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04VSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef RVALUE As Double, _
    ByVal CW As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long, _
    ByVal CWLength As long _
    )


   Declare Sub E04WBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal RNAME As string, _
    ByVal CWSAV As string, _
    ByRef LCWSAV As Integer, _
    <Out()> ByVal LWSAV As Integer(), _
    ByRef LLWSAV As Integer, _
    <Out()> ByVal IWSAV As Integer(), _
    ByRef LIWSAV As Integer, _
    <Out()> ByVal RWSAV As Double(), _
    ByRef LRWSAV As Integer, _
    ByRef IFAIL As Integer, _
    ByVal RNAMELength As long, _
    ByVal CWSAVLength As long _
    )


   Declare Sub E04WCF Lib "NLW6I31DE_nag.dll" ( _
    <Out()> ByVal IW As Integer(), _
    ByRef LENIW As Integer, _
    <Out()> ByVal RW As Double(), _
    ByRef LENRW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04WDF_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal CCON_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04WDP Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal CCON_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E04WDF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal GRAD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04WDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NCLIN As Integer, ByRef NCNLN As Integer, _
    ByRef LDA As Integer, ByRef LDCJ As Integer, ByRef LDH As Integer, _
    <[In]()> ByVal A As Double(,), <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), _
    ByVal CONFUN As E04WDF_CONFUN_DELEGATE, ByVal OBJFUN As E04WDF_OBJFUN_DELEGATE, ByRef MAJITS As Integer, _
    <[In](),Out()> ByVal ISTATE As Integer(), <[In](),Out()> ByVal CCON As Double(), <[In](),Out()> ByVal CJAC As Double(,), _
    <[In](),Out()> ByVal CLAMDA As Double(), ByRef OBJF As Double, <Out()> ByVal GRAD As Double(), _
    <[In](),Out()> ByVal H As Double(,), <[In](),Out()> ByVal X As Double(), <[In](),Out()> ByVal IW As Integer(), _
    ByRef LENIW As Integer, <[In](),Out()> ByVal RW As Double(), ByRef LENRW As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), ByRef IFAIL As Integer _
   )




   Declare Sub E04WEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ISPECS As Integer, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04WFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long _
    )


   Declare Sub E04WGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef IVALUE As Integer, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long _
    )


   Declare Sub E04WHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef RVALUE As Double, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long _
    )


   Declare Sub E04WKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef IVALUE As Integer, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long _
    )


   Declare Sub E04WLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal ST As string, _
    ByRef RVALUE As Double, _
    <[In](),Out()> ByVal IW As Integer(), _
    <[In](),Out()> ByVal RW As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STLength As long _
    )


  Delegate Sub E04XAA_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04XAA Lib "NLW6I31DE_nag.dll" ( _
    ByRef MSGLVL As Integer, ByRef N As Integer, ByRef EPSRF As Double, _
    <[In](),Out()> ByVal X As Double(), ByRef MODE As Integer, ByVal OBJFUN As E04XAA_OBJFUN_DELEGATE, _
    ByRef LDH As Integer, <[In](),Out()> ByVal HFORW As Double(), ByRef OBJF As Double, _
    <Out()> ByVal OBJGRD As Double(), <Out()> ByVal HCNTRL As Double(), <Out()> ByVal H As Double(,), _
    ByRef IWARN As Integer, <Out()> ByVal WORK As Double(), <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), <Out()> ByVal INFO As Integer(), <[In]()> ByVal LWSAV As Integer(), _
    <[In]()> ByVal IWSAV As Integer(), <[In]()> ByVal RWSAV As Double(), ByRef IFAIL As Integer _
   )

  Delegate Sub E04XAF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E04XAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef MSGLVL As Integer, _
    ByRef N As Integer, _
    ByRef EPSRF As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef MODE As Integer, _
    ByVal OBJFUN As E04XAF_OBJFUN_DELEGATE, _
    ByRef LDH As Integer, _
    <[In](),Out()> ByVal HFORW As Double(), _
    ByRef OBJF As Double, _
    <Out()> ByVal OBJGRD As Double(), _
    <Out()> ByVal HCNTRL As Double(), _
    <Out()> ByVal H As Double(,), _
    ByRef IWARN As Integer, _
    <Out()> ByVal WORK As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    <Out()> ByVal INFO As Integer(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04YAF_LSQFUN_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04YAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal LSQFUN As E04YAF_LSQFUN_DELEGATE, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), _
    <Out()> ByVal FJAC As Double(,), _
    ByRef LDFJAC As Integer, _
    <[In](),Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E04YBF_LSQFUN_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal XC_rptr As IntPtr, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal FJAC_rptr As IntPtr, _
    ByRef LDFJAC As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

  Delegate Sub E04YBF_LSQHES_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal FVEC_rptr As IntPtr, _
    ByVal XC_rptr As IntPtr, _
    ByVal B_rptr As IntPtr, _
    ByRef LB As Integer, _
    ByVal IW_iptr As IntPtr, _
    ByRef LIW As Integer, _
    ByVal W_rptr As IntPtr, _
    ByRef LW As Integer _
  )

   Declare Sub E04YBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal LSQFUN As E04YBF_LSQFUN_DELEGATE, _
    ByVal LSQHES As E04YBF_LSQHES_DELEGATE, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal FVEC As Double(), _
    <Out()> ByVal FJAC As Double(,), _
    ByRef LDFJAC As Integer, _
    <Out()> ByVal B As Double(), _
    ByRef LB As Integer, _
    <[In](),Out()> ByVal IW As Integer(), _
    ByRef LIW As Integer, _
    <[In](),Out()> ByVal W As Double(), _
    ByRef LW As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04YCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef JOB As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef FSUMSQ As Double, _
    <[In]()> ByVal S As Double(), _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal CJ As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E04ZMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OPTSTR As string, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Sub E04ZNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OPTSTR As string, _
    ByRef IVALUE As Integer, _
    ByRef RVALUE As Double, _
    ByVal CVALUE As string, _
    ByRef OPTYPE As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long, _
    ByVal CVALUELength As long _
    )


   Declare Sub E04ZPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef INFILE As Integer, _
    ByRef IFAIL As Integer _
   )


' chapter e05

   Declare Sub E05JAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N_R As Integer, _
    <Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E05JBF_OBJFUN_DELEGATE( _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef F As Double, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

  Delegate Sub E05JBF_MONIT_DELEGATE( _
    ByRef N As Integer, _
    ByRef NCALL As Integer, _
    ByVal XBEST_rptr As IntPtr, _
    ByVal ICOUNT_iptr As IntPtr, _
    ByRef NINIT As Integer, _
    ByVal LIST_rptr As IntPtr, _
    ByVal NUMPTS_iptr As IntPtr, _
    ByVal INITPT_iptr As IntPtr, _
    ByRef NBASKT As Integer, _
    ByVal XBASKT_rptr As IntPtr, _
    ByVal BOXL_rptr As IntPtr, _
    ByVal BOXU_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E05JBK Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NCALL As Integer, _
    ByVal XBEST_rptr As IntPtr, _
    ByVal ICOUNT_iptr As IntPtr, _
    ByRef NINIT As Integer, _
    ByVal LIST_rptr As IntPtr, _
    ByVal NUMPTS_iptr As IntPtr, _
    ByVal INITPT_iptr As IntPtr, _
    ByRef NBASKT As Integer, _
    ByVal XBASKT_rptr As IntPtr, _
    ByVal BOXL_rptr As IntPtr, _
    ByVal BOXU_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E05JBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal OBJFUN As E05JBF_OBJFUN_DELEGATE, _
    ByRef IBOUND As Integer, _
    ByRef IINIT As Integer, _
    <[In](),Out()> ByVal BL As Double(), _
    <[In](),Out()> ByVal BU As Double(), _
    ByRef SDLIST As Integer, _
    <[In](),Out()> ByVal LIST As Double(,), _
    <[In](),Out()> ByVal NUMPTS As Integer(), _
    <[In](),Out()> ByVal INITPT As Integer(), _
    ByVal MONIT As E05JBF_MONIT_DELEGATE, _
    <Out()> ByVal X As Double(), _
    ByRef OBJ As Double, _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E05JCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IOPTS As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub E05JDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Sub E05JEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByVal CVALUE As string, _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long, _
    ByVal CVALUELength As long _
    )


   Declare Sub E05JFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByRef IVALUE As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Sub E05JGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByRef RVALUE As Double, _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Function E05JHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    <[In]()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    ) as Integer


   Declare Sub E05JJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByVal CVALUE As string, _
    <[In]()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long, _
    ByVal CVALUELength As long _
    )


   Declare Sub E05JKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByRef IVALUE As Integer, _
    <[In]()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Sub E05JLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByRef RVALUE As Double, _
    <[In]()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


  Delegate Sub E05KBF_OBJFUN_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef FX As Double, _
    ByRef INFORM As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )


  Delegate Sub E05KBF_MONIT_DELEGATE( _
    ByRef NVAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef INFORM As Integer, _
    ByVal RINFO_rptr As IntPtr, _
    ByVal STATS_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef CPUSER As IntPtr _
  )


   Declare Sub E05KBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal OBJFUN As E05KBF_OBJFUN_DELEGATE, _
    ByVal MONIT As E05KBF_MONIT_DELEGATE, _
    ByRef NVAR As Integer, _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal RINFO As Double(), _
    <Out()> ByVal STATS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef CPUSER As IntPtr, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E05SAF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal VECOUT_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E05SAF_MONMOD_DELEGATE( _
    ByRef NDIM As Integer, _
    ByRef NPAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XB_rptr As IntPtr, _
    ByRef FB As Double, _
    ByVal XBEST_rptr As IntPtr, _
    ByVal FBEST_rptr As IntPtr, _
    ByVal ITT_iptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E05SXM Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByRef NPAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XB_rptr As IntPtr, _
    ByRef FB As Double, _
    ByVal XBEST_rptr As IntPtr, _
    ByVal FBEST_rptr As IntPtr, _
    ByVal ITT_iptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E05SAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByRef NPAR As Integer, _
    <Out()> ByVal XB As Double(), _
    ByRef FB As Double, _
    <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), _
    ByVal OBJFUN As E05SAF_OBJFUN_DELEGATE, _
    ByVal MONMOD As E05SAF_MONMOD_DELEGATE, _
    <[In](),Out()> ByVal IOPTS As Integer(), _
    <[In](),Out()> ByVal OPTS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    <Out()> ByVal ITT As Integer(), _
    ByRef INFORM As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub E05SBF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NDIM As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal VECOUT_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E05SBF_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCON As Integer, _
    ByRef NDIM As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub E05SZM Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NCON As Integer, _
    ByRef NDIM As Integer, _
    ByRef LDCJ As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJAC_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E05SBF_MONMOD_DELEGATE( _
    ByRef NDIM As Integer, _
    ByRef NCON As Integer, _
    ByRef NPAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XB_rptr As IntPtr, _
    ByRef FB As Double, _
    ByVal CB_rptr As IntPtr, _
    ByVal XBEST_rptr As IntPtr, _
    ByVal FBEST_rptr As IntPtr, _
    ByVal CBEST_rptr As IntPtr, _
    ByVal ITT_iptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E05SYM Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, _
    ByRef NCON As Integer, _
    ByRef NPAR As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal XB_rptr As IntPtr, _
    ByRef FB As Double, _
    ByVal CB_rptr As IntPtr, _
    ByVal XBEST_rptr As IntPtr, _
    ByVal FBEST_rptr As IntPtr, _
    ByVal CBEST_rptr As IntPtr, _
    ByVal ITT_iptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef INFORM As Integer _
  )

   Declare Sub E05SBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NDIM As Integer, ByRef NCON As Integer, ByRef NPAR As Integer, _
    <Out()> ByVal XB As Double(), ByRef FB As Double, <Out()> ByVal CB As Double(), _
    <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), <[In](),Out()> ByVal XBEST As Double(,), _
    <[In](),Out()> ByVal FBEST As Double(), <[In](),Out()> ByVal CBEST As Double(,), ByVal OBJFUN As E05SBF_OBJFUN_DELEGATE, _
    ByVal CONFUN As E05SBF_CONFUN_DELEGATE, ByVal MONMOD As E05SBF_MONMOD_DELEGATE, <[In](),Out()> ByVal IOPTS As Integer(), _
    <[In](),Out()> ByVal OPTS As Double(), <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    <Out()> ByVal ITT As Integer(), ByRef INFORM As Integer, ByRef IFAIL As Integer _
   )






  Delegate Sub E05UCF_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJSL As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJSL_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


  Delegate Sub E05UCF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByRef OBJF As Double, _
    ByVal OBJGRD_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E05UCF_START_DELEGATE( _
    ByRef NPTS As Integer, _
    ByVal QUAS_rptr As IntPtr, _
    ByRef N As Integer, _
    ByRef REPEAT As Integer, _
    ByVal BL_rptr As IntPtr, _
    ByVal BU_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef MODE As Integer _
  )

   Declare Sub E05UCZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NPTS As Integer, _
    ByVal QUAS_rptr As IntPtr, _
    ByRef N As Integer, _
    ByRef REPEAT As Integer, _
    ByVal BL_rptr As IntPtr, _
    ByVal BU_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef MODE As Integer _
  )

   Declare Sub E05UCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NCLIN As Integer, ByRef NCNLN As Integer, _
    <[In]()> ByVal A As Double(,), ByRef LDA As Integer, <[In]()> ByVal BL As Double(), _
    <[In]()> ByVal BU As Double(), ByVal CONFUN As E05UCF_CONFUN_DELEGATE, ByVal OBJFUN As E05UCF_OBJFUN_DELEGATE, _
    ByRef NPTS As Integer, <Out()> ByVal X As Double(,), ByRef LDX As Integer, _
    ByVal START As E05UCF_START_DELEGATE, ByRef REPEAT As Integer, ByRef NB As Integer, _
    <Out()> ByVal OBJF As Double(), <Out()> ByVal OBJGRD As Double(,), ByRef LDOBJD As Integer, _
    <Out()> ByVal ITER As Integer(), <Out()> ByVal C As Double(,), ByRef LDC As Integer, _
    <Out()> ByVal CJAC As Double(,,), ByRef LDCJAC As Integer, ByRef SDCJAC As Integer, _
    <Out()> ByVal R As Double(,,), ByRef LDR As Integer, ByRef SDR As Integer, _
    <Out()> ByVal CLAMDA As Double(,), ByRef LDCLDA As Integer, <Out()> ByVal ISTATE As Integer(,), _
    ByRef LISTAT As Integer, <[In](),Out()> ByVal IOPTS As Integer(), <[In](),Out()> ByVal OPTS As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), <Out()> ByVal INFO As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub E05UDM Lib "NLW6I31DE_nag.dll" ( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJSL As Integer, _
    <[In]()> ByVal NEEDC As Integer(), _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal CJSL As Double(,), _
    ByRef NSTATE As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double() _
   )


  Delegate Sub E05USF_CONFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef NCNLN As Integer, _
    ByRef N As Integer, _
    ByRef LDCJSL As Integer, _
    ByVal NEEDC_iptr As IntPtr, _
    ByVal X_rptr As IntPtr, _
    ByVal C_rptr As IntPtr, _
    ByVal CJSL_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


  Delegate Sub E05USF_OBJFUN_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef LDFJSL As Integer, _
    ByRef NEEDFI As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal F_rptr As IntPtr, _
    ByVal FJSL_rptr As IntPtr, _
    ByRef NSTATE As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub E05USF_START_DELEGATE( _
    ByRef NPTS As Integer, _
    ByVal QUAS_rptr As IntPtr, _
    ByRef N As Integer, _
    ByRef REPEAT1 As Integer, _
    ByVal BL_rptr As IntPtr, _
    ByVal BU_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef MODE As Integer _
  )


   Declare Sub E05USF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, ByRef NCLIN As Integer, _
    ByRef NCNLN As Integer, <[In]()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In]()> ByVal BL As Double(), <[In]()> ByVal BU As Double(), <[In]()> ByVal Y As Double(), _
    ByVal CONFUN As E05USF_CONFUN_DELEGATE, ByVal OBJFUN As E05USF_OBJFUN_DELEGATE, ByRef NPTS As Integer, _
    <Out()> ByVal X As Double(,), ByRef LDX As Integer, ByVal START As E05USF_START_DELEGATE, _
    ByRef REPEAT1 As Integer, ByRef NB As Integer, <Out()> ByVal OBJF As Double(), _
    <Out()> ByVal F As Double(,), <Out()> ByVal FJAC As Double(,,), ByRef LDFJAC As Integer, _
    ByRef SDFJAC As Integer, <Out()> ByVal ITER As Integer(), <Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, <Out()> ByVal CJAC As Double(,,), ByRef LDCJAC As Integer, _
    ByRef SDCJAC As Integer, <Out()> ByVal CLAMDA As Double(,), ByRef LDCLDA As Integer, _
    <Out()> ByVal ISTATE As Integer(,), ByRef LISTAT As Integer, <[In](),Out()> ByVal IOPTS As Integer(), _
    <[In](),Out()> ByVal OPTS As Double(), <[In](),Out()> ByVal IUSER As Integer(), <[In](),Out()> ByVal RUSER As Double(), _
    <Out()> ByVal INFO As Integer(), ByRef IFAIL As Integer _
   )


   Declare Sub E05ZKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    <[In](),Out()> ByVal IOPTS As Integer(), _
    ByRef LIOPTS As Integer, _
    <[In](),Out()> ByVal OPTS As Double(), _
    ByRef LOPTS As Integer, _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long _
    )


   Declare Sub E05ZLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal OPTSTR As string, _
    ByRef IVALUE As Integer, _
    ByRef RVALUE As Double, _
    ByVal CVALUE As string, _
    ByRef OPTYPE As Integer, _
    <[In]()> ByVal IOPTS As Integer(), _
    <[In]()> ByVal OPTS As Double(), _
    ByRef IFAIL As Integer, _
    ByVal OPTSTRLength As long, _
    ByVal CVALUELength As long _
    )


' chapter f01

   Declare Sub F01ABF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef N As Integer, _
    <Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal Z As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01ADF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01BLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef T As Double, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AIJMAX As Double(), _
    ByRef IRANK As Integer, _
    <Out()> ByVal INC As Integer(), _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal DU As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01BRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    ByRef LICN As Integer, _
    <[In](),Out()> ByVal IRN As Integer(), _
    ByRef LIRN As Integer, _
    <[In](),Out()> ByVal ICN As Integer(), _
    ByRef PIVOT As Double, _
    <Out()> ByVal IKEEP As Integer(), _
    <Out()> ByVal IW As Integer(), _
    <Out()> ByVal W As Double(), _
    ByRef LBLOCK As Integer, _
    ByRef GROW As Integer, _
    <[In]()> ByVal ABORT As Integer(), _
    <Out()> ByVal IDISP As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01BSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    ByRef LICN As Integer, _
    <[In]()> ByVal IVECT As Integer(), _
    <[In]()> ByVal JVECT As Integer(), _
    <[In](),Out()> ByVal ICN As Integer(), _
    <[In]()> ByVal IKEEP As Integer(), _
    <Out()> ByVal IW As Integer(), _
    <Out()> ByVal W As Double(), _
    ByRef GROW As Integer, _
    ByRef ETA As Double, _
    ByRef RPMIN As Double, _
    ByRef ABORT As Integer, _
    <[In]()> ByVal IDISP As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01BUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M1 As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01BVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef MA1 As Integer, _
    ByRef MB1 As Integer, _
    ByRef M3 As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal W As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01CKF Lib "NLW6I31DE_nag.dll" ( _
    <Out()> ByVal A As Double(,), _
    <[In](),Out()> ByVal B As Double(,), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef N As Integer, _
    ByRef P As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal Z As Double(), _
    ByRef IZ As Integer, _
    ByRef OPT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01CRF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal A As Double(), _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef MN As Integer, _
    <Out()> ByVal MOVE As Integer(), _
    ByRef LMOVE As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01CTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByRef IFAIL As Integer, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )


   Declare Sub F01CWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Complex, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByRef IFAIL As Integer, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )


   Declare Sub F01DFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )


   Declare Sub F01DGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef IFAIL As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long _
    )


   Declare Sub F01DTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )


   Declare Sub F01DUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef IFAIL As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long _
    )


   Declare Sub F01ECF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01EDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


  Delegate Sub F01EFF_F_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FX_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01EFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal F As F01EFF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F01EJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef IMNORM As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01EKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUN As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef IMNORM As Double, _
    ByRef IFAIL As Integer, _
    ByVal FUNLength As long _
    )


  Delegate Sub F01ELF_F_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01ELF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal F As F01ELF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef IMNORM As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub F01EMF_F_DELEGATE( _
    ByRef M As Integer, _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01EMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal F As F01EMF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef IMNORM As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01ENF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01EPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01EQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef P As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01FCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01FDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


  Delegate Sub F01FFF_F_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal FX_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01FFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal F As F01FFF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F01FJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01FKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUN As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer, _
    ByVal FUNLength As long _
    )


  Delegate Sub F01FLF_F_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01FLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal F As F01FLF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub F01FMF_F_DELEGATE( _
    ByRef M As Integer, _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01FMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal F As F01FMF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01FNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01FPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01FQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef P As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01GAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef T As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01GBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef T As Double, _
    ByRef TR As Double, _
    <[In](),Out()> ByVal B2 As Double(,), _
    ByRef LDB2 As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Double(,), _
    ByRef LDY As Integer, _
    <[In](),Out()> ByVal P As Double(), _
    <[In](),Out()> ByVal R As Double(), _
    <[In](),Out()> ByVal Z As Double(), _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01HAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef T As Complex, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01HBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, ByRef N As Integer, ByRef M As Integer, _
    <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, ByRef T As Complex, _
    ByRef TR As Complex, <[In](),Out()> ByVal B2 As Complex(,), ByRef LDB2 As Integer, _
    <[In](),Out()> ByVal X As Complex(,), ByRef LDX As Integer, <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, <[In](),Out()> ByVal P As Complex(), <[In](),Out()> ByVal R As Complex(), _
    <[In](),Out()> ByVal Z As Complex(), <[In](),Out()> ByVal CCOMM As Complex(), <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), ByRef IFAIL As Integer _
   )


   Declare Sub F01JAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUN As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef CONDA As Double, _
    ByRef NORMA As Double, _
    ByRef NORMFA As Double, _
    ByRef IFAIL As Integer, _
    ByVal FUNLength As long _
    )


  Delegate Sub F01JBF_F_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01JBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal F As F01JBF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef CONDA As Double, _
    ByRef NORMA As Double, _
    ByRef NORMFA As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub F01JCF_F_DELEGATE( _
    ByRef M As Integer, _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01JCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal F As F01JCF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef CONDA As Double, _
    ByRef NORMA As Double, _
    ByRef NORMFA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01JDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef ALPHA As Double, _
    ByRef CONDSA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01JEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef P As Double, _
    ByRef CONDPA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01JFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal E As Double(,), _
    ByRef LDE As Integer, _
    ByRef P As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01JGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef CONDEA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01JHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal E As Double(,), _
    ByRef LDE As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01JJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef CONDLA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01JKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal E As Double(,), _
    ByRef LDE As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FUN As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef CONDA As Double, _
    ByRef NORMA As Double, _
    ByRef NORMFA As Double, _
    ByRef IFAIL As Integer, _
    ByVal FUNLength As long _
    )


  Delegate Sub F01KBF_F_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01KBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal F As F01KBF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef CONDA As Double, _
    ByRef NORMA As Double, _
    ByRef NORMFA As Double, _
    ByRef IFAIL As Integer _
   )


  Delegate Sub F01KCF_F_DELEGATE( _
    ByRef M As Integer, _
    ByRef IFLAG As Integer, _
    ByRef NZ As Integer, _
    ByVal Z_cptr As IntPtr, _
    ByVal FZ_cptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F01KCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal F As F01KCF_F_DELEGATE, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFLAG As Integer, _
    ByRef CONDA As Double, _
    ByRef NORMA As Double, _
    ByRef NORMFA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef ALPHA As Double, _
    ByRef CONDSA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef P As Double, _
    ByRef CONDPA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal E As Complex(,), _
    ByRef LDE As Integer, _
    ByRef P As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef CONDEA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal E As Complex(,), _
    ByRef LDE As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef CONDLA As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01KKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal E As Complex(,), _
    ByRef LDE As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01LEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    ByRef LAMBDA As Double, _
    <[In](),Out()> ByVal B As Double(), _
    <[In](),Out()> ByVal C As Double(), _
    ByRef TOL As Double, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01LHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NBLOKS As Integer, _
    <[In]()> ByVal BLKSTR As Integer(,), _
    <[In](),Out()> ByVal A As Double(), _
    ByRef LENA As Integer, _
    <Out()> ByVal PIVOT As Integer(), _
    ByRef TOL As Double, _
    ByRef KPIVOT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01MCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LAL As Integer, _
    <[In](),Out()> ByVal NROW As Integer(), _
    <Out()> ByVal AL As Double(), _
    <Out()> ByVal D As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01MDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal OFFDIAG As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef DELTA As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F01MEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal OFFDIAG As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F01QGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal ZETA As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01QJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal ZETA As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01QKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal WHERET As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NROWP As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal ZETA As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal WHERETLength As long _
    )


   Declare Sub F01RGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal THETA As Complex(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01RJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal THETA As Complex(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01RKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal WHERET As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NROWP As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal THETA As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal WHERETLength As long _
    )


   Declare Sub F01SAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal W As Double(,), _
    ByRef LDW As Integer, _
    <[In](),Out()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    ByRef SEED As Integer, _
    ByRef ERRTOL As Double, _
    ByRef MAXIT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F01SBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal W As Double(,), _
    ByRef LDW As Integer, _
    <[In](),Out()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    <[In](),Out()> ByVal HT As Double(,), _
    ByRef LDHT As Integer, _
    ByRef SEED As Integer, _
    ByRef ERRTOL As Double, _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub DTRTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTRTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTPTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTPTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTRTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTRTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTFTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Double(), _
    <Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Double(), _
    <Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTFTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Complex(), _
    <Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Complex(), _
    <Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTPTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTPTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTFTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Double(), _
    <Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Double(), _
    <Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTFTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Complex(), _
    <Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F01VMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AR As Complex(), _
    <Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub F01ZAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(), _
    ByRef IFAIL As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub F01ZBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub F01ZCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef IFAIL As Integer, _
    ByVal JOBLength As long _
    )


   Declare Sub F01ZDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef IFAIL As Integer, _
    ByVal JOBLength As long _
    )


' chapter f02

   Declare Sub F02ECF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CRIT As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef WL As Double, _
    ByRef WU As Double, _
    ByRef MEST As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal VI As Double(,), _
    ByRef LDVI As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal BWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal CRITLength As long _
    )


  Delegate Sub F02EKF_MONIT_DELEGATE( _
    ByRef NCV As Integer, _
    ByRef NITER As Integer, _
    ByRef NCONV As Integer, _
    ByVal W_cptr As IntPtr, _
    ByVal RZEST_rptr As IntPtr, _
    ByRef ISTAT As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F02EKZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCV As Integer, _
    ByRef NITER As Integer, _
    ByRef NCONV As Integer, _
    ByVal W_cptr As IntPtr, _
    ByVal RZEST_rptr As IntPtr, _
    ByRef ISTAT As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub F02EKF_OPTIO_DELEGATE( _
    ByVal ICOMM_iptr As IntPtr, _
    ByVal COMM_rptr As IntPtr, _
    ByRef ISTAT As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F02EKY Lib "NLW6I31DE_nag.dll" ( _
    ByVal ICOMM_iptr As IntPtr, _
    ByVal COMM_rptr As IntPtr, _
    ByRef ISTAT As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F02EKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    <[In]()> ByVal ICOLZP As Integer(), _
    <[In]()> ByVal IROWIX As Integer(), _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    ByRef SIGMA As Double, _
    ByVal MONIT As F02EKF_MONIT_DELEGATE, _
    ByVal OPTIO As F02EKF_OPTIO_DELEGATE, _
    ByRef NCONV As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal RESID As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )






  Delegate Function F02FJF_DOT_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal Z_rptr As IntPtr, _
    ByVal W_rptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef LRUSER As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByRef LIUSER As Integer _
  ) as Double

  Delegate Sub F02FJF_IMAGE_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef N As Integer, _
    ByVal Z_rptr As IntPtr, _
    ByVal W_rptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef LRUSER As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByRef LIUSER As Integer _
  )

  Delegate Sub F02FJF_MONIT_DELEGATE( _
    ByRef ISTATE As Integer, _
    ByRef NEXTIT As Integer, _
    ByRef NEVALS As Integer, _
    ByRef NEVECS As Integer, _
    ByRef K As Integer, _
    ByVal F_rptr As IntPtr, _
    ByVal D_rptr As IntPtr _
  )

   Declare Sub F02FJZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef ISTATE As Integer, _
    ByRef NEXTIT As Integer, _
    ByRef NEVALS As Integer, _
    ByRef NEVECS As Integer, _
    ByRef K As Integer, _
    ByVal F_rptr As IntPtr, _
    ByVal D_rptr As IntPtr _
  )

   Declare Sub F02FJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef K As Integer, _
    ByRef NOITS As Integer, _
    ByRef TOL As Double, _
    ByVal DOT As F02FJF_DOT_DELEGATE, _
    ByVal IMAGE As F02FJF_IMAGE_DELEGATE, _
    ByVal MONIT As F02FJF_MONIT_DELEGATE, _
    ByRef NOVECS As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef LRUSER As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), _
    ByRef LIUSER As Integer, _
    ByRef IFAIL As Integer _
   )




  Delegate Sub F02FKF_MONIT_DELEGATE( _
    ByRef NCV As Integer, _
    ByRef NITER As Integer, _
    ByRef NCONV As Integer, _
    ByVal W_rptr As IntPtr, _
    ByVal RZEST_rptr As IntPtr, _
    ByRef ISTAT As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F02FKZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCV As Integer, _
    ByRef NITER As Integer, _
    ByRef NCONV As Integer, _
    ByVal W_rptr As IntPtr, _
    ByVal RZEST_rptr As IntPtr, _
    ByRef ISTAT As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

  Delegate Sub F02FKF_OPTIO_DELEGATE( _
    ByVal ICOMM_iptr As IntPtr, _
    ByVal COMM_rptr As IntPtr, _
    ByRef ISTAT As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )


   Declare Sub F02FKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    ByRef SIGMA As Double, _
    ByVal MONIT As F02FKF_MONIT_DELEGATE, _
    ByVal OPTIO As F02FKF_OPTIO_DELEGATE, _
    ByRef NCONV As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal RESID As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )




   Declare Sub F02GCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CRIT As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef WL As Double, _
    ByRef WU As Double, _
    ByRef MEST As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal BWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal CRITLength As long _
    )


   Declare Sub F02JCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef SCAL As Integer, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByRef SENSE As Integer, ByRef TOL As Double, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, <[In](),Out()> ByVal C As Double(,), ByRef LDC As Integer, _
    <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), <Out()> ByVal BETA As Double(), _
    <Out()> ByVal VL As Double(,), ByRef LDVL As Integer, <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, <Out()> ByVal S As Double(), <Out()> ByVal BEVL As Double(), _
    <Out()> ByVal BEVR As Double(), ByRef IWARN As Integer, ByRef IFAIL As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


   Declare Sub F02JQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef SCAL As Integer, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByRef SENSE As Integer, ByRef TOL As Double, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <[In](),Out()> ByVal C As Complex(,), ByRef LDC As Integer, _
    <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, <Out()> ByVal VR As Complex(,), ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal BEVL As Double(), <Out()> ByVal BEVR As Double(), _
    ByRef IWARN As Integer, ByRef IFAIL As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


  Delegate Sub F02WGF_AV_DELEGATE( _
    ByRef IFLAG As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal AX_rptr As IntPtr, _
    ByVal IUSER_iptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr _
  )

   Declare Sub F02WGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef NCV As Integer, _
    ByVal AV As F02WGF_AV_DELEGATE, _
    ByRef NCONV As Integer, _
    <Out()> ByVal SIGMA As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal RESID As Double(), _
    <[In](),Out()> ByVal IUSER As Integer(), _
    <[In](),Out()> ByVal RUSER As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F02WUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef NCOLB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef WANTQ As Integer, _
    <Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal SV As Double(), _
    ByRef WANTP As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F02XUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef NCOLB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef WANTQ As Integer, _
    <Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal SV As Double(), _
    ByRef WANTP As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal CWORK As Complex(), _
    ByRef IFAIL As Integer _
   )


' chapter f03

   Declare Sub F03BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef D As Double, _
    ByRef ID As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F03BFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef D As Double, _
    ByRef ID As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F03BHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    ByRef D As Double, _
    ByRef ID As Integer, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F03BNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef D As Complex, _
    <Out()> ByVal ID As Integer(), _
    ByRef IFAIL As Integer _
   )


' chapter f04

   Declare Sub F04AMF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef IR As Integer, _
    ByRef EPS As Double, _
    <Out()> ByVal QR As Double(,), _
    ByRef LDQR As Integer, _
    <Out()> ByVal ALPHA As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal Y As Double(), _
    <Out()> ByVal Z As Double(), _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04AXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LICN As Integer, _
    <[In]()> ByVal ICN As Integer(), _
    <[In](),Out()> ByVal IKEEP As Integer(), _
    <[In](),Out()> ByVal RHS As Double(), _
    <Out()> ByVal W As Double(), _
    ByRef MTYPE As Integer, _
    <[In]()> ByVal IDISP As Integer(), _
    ByRef RESID As Double _
   )


   Declare Sub F04BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04BBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04BCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal DL As Double(), _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal DU As Double(), _
    <Out()> ByVal DU2 As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04BDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04BEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04BFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04BGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04BHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04BJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04CAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04CBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04CCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal DL As Complex(), _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal DU As Complex(), _
    <Out()> ByVal DU2 As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04CDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04CEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04CFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04CGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04CHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04CJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04DHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04DJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef RCOND As Double, _
    ByRef ERRBND As Double, _
    ByRef IFAIL As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F04FEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(), _
    <Out()> ByVal X As Double(), _
    ByRef WANTP As Integer, _
    <Out()> ByVal P As Double(), _
    ByRef WANTV As Integer, _
    <Out()> ByVal V As Double(), _
    ByRef VLAST As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04FFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(), _
    <[In]()> ByVal B As Double(), _
    <Out()> ByVal X As Double(), _
    ByRef WANTP As Integer, _
    <Out()> ByVal P As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04JGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(), _
    ByRef TOL As Double, _
    ByRef SVD As Integer, _
    ByRef SIGMA As Double, _
    ByRef IRANK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04LEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef JOB As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(), _
    <[In]()> ByVal C As Double(), _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef TOL As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04LHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NBLOKS As Integer, _
    <[In]()> ByVal BLKSTR As Integer(,), _
    <[In]()> ByVal A As Double(), _
    ByRef LENA As Integer, _
    <[In]()> ByVal PIVOT As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef IR As Integer, _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub F04MCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal AL As Double(), _
    ByRef LAL As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal NROW As Integer(), _
    ByRef IR As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef ISELCT As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04MEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef V As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04MFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(), _
    <[In]()> ByVal B As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef P As Double, _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


  Delegate Sub F04QAF_APROD_DELEGATE( _
    ByRef MODE As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByVal X_rptr As IntPtr, _
    ByVal Y_rptr As IntPtr, _
    ByVal RUSER_rptr As IntPtr, _
    ByRef LRUSER As Integer, _
    ByVal IUSER_iptr As IntPtr, _
    ByRef LIUSER As Integer _
  )

   Declare Sub F04QAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, ByRef N As Integer, <[In](),Out()> ByVal B As Double(), _
    <Out()> ByVal X As Double(), <Out()> ByVal SE As Double(), ByVal APROD As F04QAF_APROD_DELEGATE, _
    ByRef DAMP As Double, ByRef ATOL As Double, ByRef BTOL As Double, _
    ByRef CONLIM As Double, ByRef ITNLIM As Integer, ByRef MSGLVL As Integer, _
    ByRef ITN As Integer, ByRef ANORM As Double, ByRef ACOND As Double, _
    ByRef RNORM As Double, ByRef ARNORM As Double, ByRef XNORM As Double, _
    <Out()> ByVal WORK As Double(,), <[In](),Out()> ByVal RUSER As Double(), ByRef LRUSER As Integer, _
    <[In](),Out()> ByVal IUSER As Integer(), ByRef LIUSER As Integer, ByRef INFORM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04YAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef JOB As Integer, _
    ByRef P As Integer, _
    ByRef SIGMA As Double, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef SVD As Integer, _
    ByRef IRANK As Integer, _
    <[In]()> ByVal SV As Double(), _
    <Out()> ByVal CJ As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04YDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Double(,), _
    ByRef LDY As Integer, _
    ByRef ESTNRM As Double, _
    ByRef T As Integer, _
    ByRef SEED As Integer, _
    <[In](),Out()> ByVal WORK As Double(), _
    <[In](),Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F04ZDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef ESTNRM As Double, _
    ByRef T As Integer, _
    ByRef SEED As Integer, _
    <[In](),Out()> ByVal WORK As Complex(), _
    <[In](),Out()> ByVal RWORK As Double(), _
    <[In](),Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer _
   )


' chapter f05

   Declare Sub F05AAF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef M As Integer, _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef CC As Double, _
    ByRef ICOL As Integer, _
    ByRef IFAIL As Integer _
   )


' chapter f06

   Declare Sub DROTG Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef S As Double _
   )

   Declare Sub F06AAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Sub F06BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Sub F06BCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Double, _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Sub F06BEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByRef Z As Double, _
    ByRef C As Double, _
    ByRef S As Double, _
    ByVal JOBLength As long _
    )


   Declare Sub F06BHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByRef Z As Double, _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Function F06BLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef FAIL As Integer _
   ) as Double


   Declare Function F06BMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef SCAL As Double, _
    ByRef SSQ As Double _
   ) as Double


   Declare Function F06BNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double _
   ) as Double


   Declare Function F06BPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef C As Double _
   ) as Double


   Declare Sub F06CAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Complex, _
    ByRef B As Complex, _
    ByRef C As Double, _
    ByRef S As Complex _
   )


   Declare Sub F06CBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Complex, _
    ByRef B As Complex, _
    ByRef C As Complex, _
    ByRef S As Double _
   )


   Declare Sub F06CCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Complex, _
    ByRef C As Double, _
    ByRef S As Complex _
   )


   Declare Sub F06CDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Complex, _
    ByRef C As Complex, _
    ByRef S As Double _
   )


   Declare Sub F06CHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Complex, _
    ByRef Y As Complex, _
    ByRef Z As Complex, _
    ByRef C As Double, _
    ByRef S As Complex _
   )


   Declare Function F06CLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Complex, _
    ByRef B As Complex, _
    ByRef FAIL As Integer _
   ) as Complex


   Declare Sub F06DBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef CON As Integer, _
    <[In](),Out()> ByVal X As Integer(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06DFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Integer(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Integer(), _
    ByRef INCY As Integer _
   )


   Declare Function DDOT Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   ) as Double

   Declare Function F06EAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   ) as Double


   Declare Sub DAXPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )

   Declare Sub F06ECF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )


   Declare Sub DSCAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer _
   )

   Declare Sub F06EDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer _
   )


   Declare Sub DCOPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )

   Declare Sub F06EFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )


   Declare Sub DSWAP Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )

   Declare Sub F06EGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )


   Declare Function DNRM2 Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Double

   Declare Function F06EJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Double


   Declare Function DASUM Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Double

   Declare Function F06EKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Double


   Declare Sub DROT Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByRef C As Double, _
    ByRef S As Double _
   )

   Declare Sub F06EPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Function DDOTI Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In]()> ByVal Y As Double() _
   ) as Double

   Declare Function F06ERF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In]()> ByVal Y As Double() _
   ) as Double


   Declare Sub DAXPYI Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    ByRef A As Double, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Double() _
   )

   Declare Sub F06ETF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    ByRef A As Double, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Double() _
   )


   Declare Sub DGTHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer() _
   )

   Declare Sub F06EUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer() _
   )


   Declare Sub DGTHRZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer() _
   )

   Declare Sub F06EVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer() _
   )


   Declare Sub DSCTR Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Double() _
   )

   Declare Sub F06EWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Double() _
   )


   Declare Sub DROTI Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef C As Double, _
    ByRef S As Double _
   )

   Declare Sub F06EXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Function F06FAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef J As Integer, _
    ByRef TOLX As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef TOLY As Double, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   ) as Double


   Declare Sub F06FBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef CON As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06FCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    ByRef INCD As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06FDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )


   Declare Sub F06FEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06FGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06FJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef SCAL As Double, _
    ByRef SUMSQ As Double _
   )


   Declare Function F06FKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal W As Double(), _
    ByRef INCW As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Double


   Declare Sub F06FLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef XMAX As Double, _
    ByRef XMIN As Double _
   )


   Declare Sub F06FPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Sub F06FQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal S As Double() _
, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Sub F06FRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef TOL As Double, _
    ByRef ZETA As Double _
   )


   Declare Sub F06FSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef TOL As Double, _
    ByRef Z1 As Double _
   )


   Declare Sub F06FTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef DELTA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByRef ZETA As Double, _
    <[In]()> ByVal Z As Double(), _
    ByRef INCZ As Integer _
   )


   Declare Sub F06FUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal Z As Double(), _
    ByRef INCZ As Integer, _
    ByRef Z1 As Double, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer _
   )


   Declare Function ZDOTU Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   ) as Complex

   Declare Function F06GAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   ) as Complex


   Declare Function ZDOTC Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   ) as Complex

   Declare Function F06GBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   ) as Complex


   Declare Sub ZAXPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )

   Declare Sub F06GCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )


   Declare Sub ZSCAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )

   Declare Sub F06GDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )


   Declare Sub ZCOPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )

   Declare Sub F06GFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )


   Declare Sub ZSWAP Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )

   Declare Sub F06GGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )


   Declare Function ZDOTUI Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In]()> ByVal Y As Complex() _
   ) as Complex

   Declare Function F06GRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In]()> ByVal Y As Complex() _
   ) as Complex


   Declare Function ZDOTCI Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In]()> ByVal Y As Complex() _
   ) as Complex

   Declare Function F06GSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In]()> ByVal Y As Complex() _
   ) as Complex


   Declare Sub ZAXPYI Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    ByRef A As Complex, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Complex() _
   )

   Declare Sub F06GTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    ByRef A As Complex, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Complex() _
   )


   Declare Sub ZGTHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer() _
   )

   Declare Sub F06GUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer() _
   )


   Declare Sub ZGTHRZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer() _
   )

   Declare Sub F06GVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer() _
   )


   Declare Sub ZSCTR Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Complex() _
   )

   Declare Sub F06GWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NZ As Integer, _
    <[In]()> ByVal X As Complex(), _
    <[In]()> ByVal INDX As Integer(), _
    <[In](),Out()> ByVal Y As Complex() _
   )


   Declare Sub F06HBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef CON As Complex, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06HCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Complex(), _
    ByRef INCD As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06HDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )


   Declare Sub F06HGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )


   Declare Sub ZROT Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal CX As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal CY As Complex(), _
    ByRef INCY As Integer, _
    ByRef C As Double, _
    ByRef S As Complex _
   )

   Declare Sub F06HMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal CX As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal CY As Complex(), _
    ByRef INCY As Integer, _
    ByRef C As Double, _
    ByRef S As Complex _
   )


   Declare Sub F06HPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByRef C As Complex, _
    ByRef S As Complex _
   )


   Declare Sub F06HQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal S As Complex() _
, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Sub F06HRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef TOL As Double, _
    ByRef THETA As Complex _
   )


   Declare Sub F06HTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef DELTA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByRef THETA As Complex, _
    <[In]()> ByVal Z As Complex(), _
    ByRef INCZ As Integer _
   )


   Declare Sub ZDSCAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )

   Declare Sub F06JDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )


   Declare Function DZNRM2 Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Double

   Declare Function F06JJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Double


   Declare Function DZASUM Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Double

   Declare Function F06JKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Double


   Declare Function IDAMAX Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Integer

   Declare Function F06JLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Integer


   Declare Function IZAMAX Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Integer

   Declare Function F06JMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Integer


   Declare Sub F06KCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    ByRef INCD As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06KDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )


   Declare Sub F06KEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   )


   Declare Sub F06KFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )


   Declare Sub F06KJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef SCAL As Double, _
    ByRef SUMSQ As Double _
   )


   Declare Function F06KLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef TOL As Double _
   ) as Integer


   Declare Sub ZDROT Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByRef C As Double, _
    ByRef S As Double _
   )

   Declare Sub F06KPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByRef C As Double, _
    ByRef S As Double _
   )


   Declare Sub DGEMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06PAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06PBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DSYMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06PCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06PDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06PEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTRMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06PFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06PGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06PHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTRSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06PJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06PKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06PLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DGER Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer _
   )

   Declare Sub F06PMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer _
   )


   Declare Sub DSYR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06PPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal AP As Double() _
, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06PQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal AP As Double() _
, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYR2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06PRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPR2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal AP As Double() _
, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06PSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal AP As Double() _
, _
    ByVal UPLOLength As long _
    )


   Declare Sub F06QFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal MATRIX As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal MATRIXLength As long _
    )


   Declare Sub F06QHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal MATRIX As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef CON As Double, _
    ByRef DIAG As Double, _
    <Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal MATRIXLength As long _
    )


   Declare Sub F06QJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal PERM As Integer(), _
    ByRef K As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub F06QKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal PERM As Double(), _
    ByRef K As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub F06QMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In]()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Sub F06QPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal S As Double() _
   )


   Declare Sub F06QQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal S As Double() _
   )


   Declare Sub F06QRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06QSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06QTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06QVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06QWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06QXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In]()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Function F06RAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06RBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06RCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06RDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06REF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06RJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    ) as Double


   Declare Function F06RKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    ) as Double


   Declare Function F06RLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    ) as Double


   Declare Function F06RMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06RNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal DL As Double(), _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal DU As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06RPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Sub ZGEMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06SAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06SBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZHEMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06SCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06SDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06SEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTRMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06SFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06SGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06SHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTRSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06SJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06SKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06SLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZGERU Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer _
   )

   Declare Sub F06SMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer _
   )


   Declare Sub ZGERC Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer _
   )

   Declare Sub F06SNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer _
   )


   Declare Sub ZHER Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06SPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal AP As Complex() _
, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06SQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal AP As Complex() _
, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHER2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06SRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPR2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal AP As Complex() _
, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06SSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal AP As Complex() _
, _
    ByVal UPLOLength As long _
    )


   Declare Sub F06TAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F06TBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F06TCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub F06TDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal AP As Complex() _
, _
    ByVal UPLOLength As long _
    )


   Declare Sub F06TFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal MATRIX As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal MATRIXLength As long _
    )


   Declare Sub F06THF Lib "NLW6I31DE_nag.dll" ( _
    ByVal MATRIX As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef CON As Complex, _
    ByRef DIAG As Complex, _
    <Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal MATRIXLength As long _
    )


   Declare Sub F06TMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In]()> ByVal S As Complex(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal UPLOLength As long, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Sub F06TPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal S As Complex() _
   )


   Declare Sub F06TQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal C As Double(), _
    <Out()> ByVal S As Complex() _
   )


   Declare Sub F06TRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <Out()> ByVal C As Complex(), _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06TSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Complex(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06TTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Complex(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06TVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Complex(), _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06TWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In](),Out()> ByVal S As Complex(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long _
    )


   Declare Sub F06TXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In]()> ByVal S As Complex(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Sub F06TYF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Complex(), _
    <[In]()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Function F06UAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06UBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06UCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06UDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06UEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06UFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06UGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06UHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Function F06UJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    ) as Double


   Declare Function F06UKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    ) as Double


   Declare Function F06ULF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    ) as Double


   Declare Function F06UMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06UNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal DL As Complex(), _
    <[In]()> ByVal D As Complex(), _
    <[In]()> ByVal DU As Complex() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Function F06UPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex() _
, _
    ByVal NORMLength As long _
    ) as Double


   Declare Sub F06VJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal PERM As Integer(), _
    ByRef K As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub F06VKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal PERM As Double(), _
    ByRef K As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub F06VXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal PIVOT As string, _
    ByVal DIRECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K1 As Integer, _
    ByRef K2 As Integer, _
    <[In]()> ByVal C As Double(), _
    <[In]()> ByVal S As Double(), _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByVal SIDELength As long, _
    ByVal PIVOTLength As long, _
    ByVal DIRECTLength As long _
    )


   Declare Function DLANSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    ) as Double

   Declare Function F06WAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Sub DTFSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal TRANSRLength As long, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06WBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal TRANSRLength As long, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DSFRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double() _
, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06WCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double() _
, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Function ZLANHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    ) as Double

   Declare Function F06WNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(), _
    <Out()> ByVal WORK As Double() _
, _
    ByVal NORMLength As long, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    ) as Double


   Declare Sub ZTFSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal TRANSRLength As long, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06WPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal TRANSRLength As long, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZHFRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Complex() _
, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06WQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Complex() _
, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )

   Declare Sub F06YAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )


   Declare Sub DSYMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06YCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTRMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06YFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTRSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06YJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DSYRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06YPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DSYR2K Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06YRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )

   Declare Sub F06ZAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSA As string, _
    ByVal TRANSB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal TRANSALength As long, _
    ByVal TRANSBLength As long _
    )


   Declare Sub ZHEMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06ZCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTRMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06ZFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTRSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F06ZJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANSA As string, _
    ByVal DIAG As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSALength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZHERK Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06ZPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZHER2K Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06ZRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZSYMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F06ZTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06ZUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZSYR2K Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F06ZWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


' chapter f07

   Declare Sub DGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07AAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGESVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Double(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    ByVal EQUED As string, <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07ABF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Double(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    ByVal EQUED As string, <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub DSGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal SWORK As Single(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07ACF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal SWORK As Single(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGETRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07ADF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub DGETRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07AEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )

   Declare Sub F07AFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )


   Declare Sub DGECON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )

   Declare Sub F07AGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub DGERFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Double(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07AHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Double(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGETRI Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07AJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07ANF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGESVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    ByVal EQUED As string, <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07APF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    ByVal EQUED As string, <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub ZCGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal SWORK As ComplexSingle(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07AQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal SWORK As ComplexSingle(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGETRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07ARF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZGETRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07ASF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )

   Declare Sub F07ATF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGECON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )

   Declare Sub F07AUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub ZGERFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07AVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGETRI Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07AWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGBSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef KL As Integer, ByRef KU As Integer, ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Double(,), _
    ByRef LDAFB As Integer, <[In](),Out()> ByVal IPIV As Integer(), ByVal EQUED As string, _
    <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Double(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07BBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef KL As Integer, ByRef KU As Integer, ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Double(,), _
    ByRef LDAFB As Integer, <[In](),Out()> ByVal IPIV As Integer(), ByVal EQUED As string, _
    <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Double(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub DGBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07BDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub DGBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07BEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )

   Declare Sub F07BFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )


   Declare Sub DGBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )

   Declare Sub F07BGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub DGBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Double(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07BHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Double(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGBSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07BNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef KL As Integer, ByRef KU As Integer, ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Complex(,), _
    ByRef LDAFB As Integer, <[In](),Out()> ByVal IPIV As Integer(), ByVal EQUED As string, _
    <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Complex(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07BPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef KL As Integer, ByRef KU As Integer, ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Complex(,), _
    ByRef LDAFB As Integer, <[In](),Out()> ByVal IPIV As Integer(), ByVal EQUED As string, _
    <[In](),Out()> ByVal R As Double(), <[In](),Out()> ByVal C As Double(), <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Complex(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub ZGBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07BRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZGBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07BSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )

   Declare Sub F07BTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef ROWCND As Double, _
    ByRef COLCND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )

   Declare Sub F07BUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub ZGBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Complex(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07BVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Complex(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal DL As Double(), _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal DU As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07CAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal DL As Double(), _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal DU As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal DL As Double(), <[In]()> ByVal D As Double(), _
    <[In]()> ByVal DU As Double(), <[In](),Out()> ByVal DLF As Double(), <[In](),Out()> ByVal DF As Double(), _
    <[In](),Out()> ByVal DUF As Double(), <[In](),Out()> ByVal DU2 As Double(), <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07CBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal DL As Double(), <[In]()> ByVal D As Double(), _
    <[In]()> ByVal DU As Double(), <[In](),Out()> ByVal DLF As Double(), <[In](),Out()> ByVal DF As Double(), _
    <[In](),Out()> ByVal DUF As Double(), <[In](),Out()> ByVal DU2 As Double(), <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal DL As Double(), _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal DU As Double(), _
    <Out()> ByVal DU2 As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07CDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal DL As Double(), _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal DU As Double(), _
    <Out()> ByVal DU2 As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub DGTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Double(), _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal DU As Double(), _
    <[In]()> ByVal DU2 As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07CEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Double(), _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal DU As Double(), _
    <[In]()> ByVal DU2 As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGTCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal DL As Double(), _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal DU As Double(), _
    <[In]()> ByVal DU2 As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )

   Declare Sub F07CGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal DL As Double(), _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal DU As Double(), _
    <[In]()> ByVal DU2 As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub DGTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef N As Integer, ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Double(), <[In]()> ByVal D As Double(), <[In]()> ByVal DU As Double(), _
    <[In]()> ByVal DLF As Double(), <[In]()> ByVal DF As Double(), <[In]()> ByVal DUF As Double(), _
    <[In]()> ByVal DU2 As Double(), <[In]()> ByVal IPIV As Integer(), <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, <[In](),Out()> ByVal X As Double(,), ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07CHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef N As Integer, ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Double(), <[In]()> ByVal D As Double(), <[In]()> ByVal DU As Double(), _
    <[In]()> ByVal DLF As Double(), <[In]()> ByVal DF As Double(), <[In]()> ByVal DUF As Double(), _
    <[In]()> ByVal DU2 As Double(), <[In]()> ByVal IPIV As Integer(), <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, <[In](),Out()> ByVal X As Double(,), ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal DL As Complex(), _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal DU As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07CNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal DL As Complex(), _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal DU As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal DL As Complex(), <[In]()> ByVal D As Complex(), _
    <[In]()> ByVal DU As Complex(), <[In](),Out()> ByVal DLF As Complex(), <[In](),Out()> ByVal DF As Complex(), _
    <[In](),Out()> ByVal DUF As Complex(), <[In](),Out()> ByVal DU2 As Complex(), <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07CPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal TRANS As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal DL As Complex(), <[In]()> ByVal D As Complex(), _
    <[In]()> ByVal DU As Complex(), <[In](),Out()> ByVal DLF As Complex(), <[In](),Out()> ByVal DF As Complex(), _
    <[In](),Out()> ByVal DUF As Complex(), <[In](),Out()> ByVal DU2 As Complex(), <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal DL As Complex(), _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal DU As Complex(), _
    <Out()> ByVal DU2 As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07CRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal DL As Complex(), _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal DU As Complex(), _
    <Out()> ByVal DU2 As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZGTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Complex(), _
    <[In]()> ByVal D As Complex(), _
    <[In]()> ByVal DU As Complex(), _
    <[In]()> ByVal DU2 As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07CSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Complex(), _
    <[In]()> ByVal D As Complex(), _
    <[In]()> ByVal DU As Complex(), _
    <[In]()> ByVal DU2 As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGTCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal DL As Complex(), _
    <[In]()> ByVal D As Complex(), _
    <[In]()> ByVal DU As Complex(), _
    <[In]()> ByVal DU2 As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )

   Declare Sub F07CUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal DL As Complex(), _
    <[In]()> ByVal D As Complex(), _
    <[In]()> ByVal DU As Complex(), _
    <[In]()> ByVal DU2 As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub ZGTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef N As Integer, ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Complex(), <[In]()> ByVal D As Complex(), <[In]()> ByVal DU As Complex(), _
    <[In]()> ByVal DLF As Complex(), <[In]()> ByVal DF As Complex(), <[In]()> ByVal DUF As Complex(), _
    <[In]()> ByVal DU2 As Complex(), <[In]()> ByVal IPIV As Integer(), <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <[In](),Out()> ByVal X As Complex(,), ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F07CVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef N As Integer, ByRef NRHS As Integer, _
    <[In]()> ByVal DL As Complex(), <[In]()> ByVal D As Complex(), <[In]()> ByVal DU As Complex(), _
    <[In]()> ByVal DLF As Complex(), <[In]()> ByVal DF As Complex(), <[In]()> ByVal DUF As Complex(), _
    <[In]()> ByVal DU2 As Complex(), <[In]()> ByVal IPIV As Integer(), <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <[In](),Out()> ByVal X As Complex(,), ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPOSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Double(,), ByRef LDAF As Integer, ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), ByRef LDX As Integer, ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07FBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Double(,), ByRef LDAF As Integer, ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), ByRef LDX As Integer, ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub DSPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Double(,), _
    <Out()> ByVal SWORK As Single(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Double(,), _
    <Out()> ByVal SWORK As Single(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPOTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPOTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPOEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )

   Declare Sub F07FFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )


   Declare Sub DPOCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPORFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Double(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Double(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPOTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPOSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), ByRef LDX As Integer, ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07FPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), ByRef LDX As Integer, ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub ZCPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Complex(,), _
    <Out()> ByVal SWORK As ComplexSingle(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Complex(,), _
    <Out()> ByVal SWORK As ComplexSingle(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef ITER As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPOTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPOTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPOEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )

   Declare Sub F07FTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer _
   )


   Declare Sub ZPOCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPORFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPOTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07FWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal AFP As Double(), _
    ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07GBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal AFP As Double(), _
    ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub DPPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPPEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal AFP As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal AFP As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal AFP As Complex(), _
    ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07GPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal AFP As Complex(), _
    ByVal EQUED As string, _
    <[In](),Out()> ByVal S As Double(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub ZPPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPPEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal AFP As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal AFP As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07GWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef KD As Integer, ByRef NRHS As Integer, <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Double(,), ByRef LDAFB As Integer, _
    ByVal EQUED As string, <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Double(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07HBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef KD As Integer, ByRef NRHS As Integer, <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Double(,), ByRef LDAFB As Integer, _
    ByVal EQUED As string, <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Double(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub DPBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Double(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Double(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef KD As Integer, ByRef NRHS As Integer, <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Complex(,), ByRef LDAFB As Integer, _
    ByVal EQUED As string, <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Complex(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )

   Declare Sub F07HPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef KD As Integer, ByRef NRHS As Integer, <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, <[In](),Out()> ByVal AFB As Complex(,), ByRef LDAFB As Integer, _
    ByVal EQUED As string, <[In](),Out()> ByVal S As Double(), <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <Out()> ByVal X As Complex(,), ByRef LDX As Integer, _
    ByRef RCOND As Double, <Out()> ByVal FERR As Double(), <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long, _
    ByVal EQUEDLength As long _
    )


   Declare Sub ZPBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef SCOND As Double, _
    ByRef AMAX As Double, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Complex(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07HVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal AFB As Complex(,), _
    ByRef LDAFB As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07JAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DPTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    <[In](),Out()> ByVal DF As Double(), _
    <[In](),Out()> ByVal EF As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long _
    )

   Declare Sub F07JBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    <[In](),Out()> ByVal DF As Double(), _
    <[In](),Out()> ByVal EF As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long _
    )


   Declare Sub DPTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07JDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub DPTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07JEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DPTCON Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07JGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub DPTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    <[In]()> ByVal DF As Double(), _
    <[In]()> ByVal EF As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07JHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    <[In]()> ByVal DF As Double(), _
    <[In]()> ByVal EF As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZPTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F07JNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZPTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    <[In](),Out()> ByVal DF As Double(), _
    <[In](),Out()> ByVal EF As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long _
    )

   Declare Sub F07JPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    <[In](),Out()> ByVal DF As Double(), _
    <[In](),Out()> ByVal EF As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long _
    )


   Declare Sub ZPTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Complex(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07JRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Complex(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZPTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07JSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPTCON Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F07JUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZPTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    <[In]()> ByVal DF As Double(), _
    <[In]()> ByVal EF As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07JVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Complex(), _
    <[In]()> ByVal DF As Double(), _
    <[In]()> ByVal EF As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPSTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal PIV As Integer(), _
    ByRef RANK As Integer, _
    ByRef TOL As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07KDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal PIV As Integer(), _
    ByRef RANK As Integer, _
    ByRef TOL As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPSTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal PIV As Integer(), _
    ByRef RANK As Integer, _
    ByRef TOL As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07KRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal PIV As Integer(), _
    ByRef RANK As Integer, _
    ByRef TOL As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Double(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Double(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Double(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Double(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHESV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHESVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHETRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHETRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHECON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHERFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHETRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07MWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07NNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07NPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, ByVal UPLO As string, ByRef N As Integer, _
    ByRef NRHS As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In](),Out()> ByVal AF As Complex(,), ByRef LDAF As Integer, <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, ByRef RCOND As Double, <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07NRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07NSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07NUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07NVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal AF As Complex(,), _
    ByRef LDAF As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSYTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07NWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal AFP As Double(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal AFP As Double(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal AFP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal AFP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal AFP As Complex(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal AFP As Complex(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal AFP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal AFP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07PWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07QNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal AFP As Complex(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07QPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal FACT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal AFP As Complex(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal FACTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07QRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal IPIV As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07QSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07QUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal AFP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07QVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal AFP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZSPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07QWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal IPIV As Integer(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTRTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07TEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTRCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07TGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTRRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07THF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTRTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07TJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTRTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07TSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTRCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07TUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTRRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07TVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTRTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07TWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07UEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07UGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07UHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07UJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07USF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07UUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07UVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07UWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07VEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07VGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DTBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07VHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07VSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07VUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    ByRef RCOND As Double, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal NORMLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZTBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07VVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In]()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub DPFTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07WDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPFTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AR As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07WEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AR As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07WJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DTFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07WKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Double(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


   Declare Sub ZPFTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07WRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPFTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AR As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07WSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In]()> ByVal AR As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F07WWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZTFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )

   Declare Sub F07WXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANSR As string, _
    ByVal UPLO As string, _
    ByVal DIAG As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AR As Complex(), _
    ByRef INFO As Integer, _
    ByVal TRANSRLength As long, _
    ByVal UPLOLength As long, _
    ByVal DIAGLength As long _
    )


' chapter f08

   Declare Sub DGELS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08AAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08ABF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub DGEMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08ACF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08AEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORGQR Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08AFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORMQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08AGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGELQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08AHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORGLQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08AJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORMLQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08AKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGELS Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08ANF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08APF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZGEMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08AQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ASF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNGQR Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ATF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNMQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08AUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGELQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08AVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNGLQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08AWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNMLQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08AXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGELSY Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DTPQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08BBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub DTPMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In]()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C1 As Double(,), _
    ByRef LDC1 As Integer, _
    <[In](),Out()> ByVal C2 As Double(,), _
    ByRef LDC2 As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08BCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In]()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C1 As Double(,), _
    ByRef LDC1 As Integer, _
    <[In](),Out()> ByVal C2 As Double(,), _
    ByRef LDC2 As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEQPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08BEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub DGEQP3 Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08BFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DTZRZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08BHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORMRZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08BKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGELSY Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08BNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZTPQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08BPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZTPMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In]()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C1 As Complex(,), _
    ByRef LDC1 As Integer, _
    <[In](),Out()> ByVal C2 As Complex(,), _
    ByRef LDC2 As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08BQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    ByRef NB As Integer, _
    <[In]()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <[In]()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal C1 As Complex(,), _
    ByRef LDC1 As Integer, _
    <[In](),Out()> ByVal C2 As Complex(,), _
    ByRef LDC2 As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEQPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08BSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZGEQP3 Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08BTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal JPVT As Integer(), _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZTZRZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08BVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNMRZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08BXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef L As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEQLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORGQL Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORMQL Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08CGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGERQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORGRQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORMRQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08CKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEQLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNGQL Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNMQL Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08CUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGERQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNGRQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08CWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNMRQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08CXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DSYEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYEVR Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal ISUPPZ As Integer(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal ISUPPZ As Integer(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DORGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DORMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08FGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DDISNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <Out()> ByVal SEP As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )

   Declare Sub F08FLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <Out()> ByVal SEP As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )


   Declare Sub ZHEEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHEEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHEEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHEEVR Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal ISUPPZ As Integer(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef LRWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal ISUPPZ As Integer(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef LRWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHETRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZUNGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08FTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZUNMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08FUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DSPEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    ByRef M As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    ByRef M As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DOPGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Double(), _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DOPMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08GGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZHPEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    ByRef M As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    ByRef M As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAU As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZUPGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08GTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In]()> ByVal AP As Complex(), _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZUPMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08GUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal UPLO As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal UPLOLength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DSBEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KD As Integer, <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KD As Integer, <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KD As Integer, <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KD As Integer, <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08HSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KD As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSTEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long _
    )

   Declare Sub F08JAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long _
    )


   Declare Sub DSTEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    ByRef M As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )

   Declare Sub F08JBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    ByRef M As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )


   Declare Sub DSTEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )

   Declare Sub F08JCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )


   Declare Sub DSTEVR Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), <[In](),Out()> ByVal E As Double(), ByRef VL As Double, _
    ByRef VU As Double, ByRef IL As Integer, ByRef IU As Integer, _
    ByRef ABSTOL As Double, ByRef M As Integer, <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, <Out()> ByVal ISUPPZ As Integer(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )

   Declare Sub F08JDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), <[In](),Out()> ByVal E As Double(), ByRef VL As Double, _
    ByRef VU As Double, ByRef IL As Integer, ByRef IU As Integer, _
    ByRef ABSTOL As Double, ByRef M As Integer, <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, <Out()> ByVal ISUPPZ As Integer(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )


   Declare Sub DSTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08JEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )


   Declare Sub DSTERF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08JFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub DPTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08JGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )


   Declare Sub DSTEDC Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08JHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )


   Declare Sub DSTEBZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal RANGE As string, _
    ByVal ORDER As string, _
    ByRef N As Integer, _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef M As Integer, _
    ByRef NSPLIT As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal IBLOCK As Integer(), _
    <Out()> ByVal ISPLIT As Integer(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal RANGELength As long, _
    ByVal ORDERLength As long _
    )

   Declare Sub F08JJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal RANGE As string, _
    ByVal ORDER As string, _
    ByRef N As Integer, _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef ABSTOL As Double, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef M As Integer, _
    ByRef NSPLIT As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal IBLOCK As Integer(), _
    <Out()> ByVal ISPLIT As Integer(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal RANGELength As long, _
    ByVal ORDERLength As long _
    )


   Declare Sub DSTEIN Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal W As Double(), _
    <[In]()> ByVal IBLOCK As Integer(), _
    <[In]()> ByVal ISPLIT As Integer(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal IFAILV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08JKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal W As Double(), _
    <[In]()> ByVal IBLOCK As Integer(), _
    <[In]()> ByVal ISPLIT As Integer(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal IFAILV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub DSTEGR Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), <[In](),Out()> ByVal E As Double(), ByRef VL As Double, _
    ByRef VU As Double, ByRef IL As Integer, ByRef IU As Integer, _
    ByRef ABSTOL As Double, ByRef M As Integer, <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, <Out()> ByVal ISUPPZ As Integer(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )

   Declare Sub F08JLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), <[In](),Out()> ByVal E As Double(), ByRef VL As Double, _
    ByRef VU As Double, ByRef IL As Integer, ByRef IU As Integer, _
    ByRef ABSTOL As Double, ByRef M As Integer, <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, <Out()> ByVal ISUPPZ As Integer(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )


   Declare Sub ZSTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08JSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )


   Declare Sub ZPTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08JUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )


   Declare Sub ZSTEDC Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08JVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPZLength As long _
    )


   Declare Sub ZSTEIN Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal W As Double(), _
    <[In]()> ByVal IBLOCK As Integer(), _
    <[In]()> ByVal ISPLIT As Integer(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal IFAILV As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08JXF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef M As Integer, _
    <[In]()> ByVal W As Double(), _
    <[In]()> ByVal IBLOCK As Integer(), _
    <[In]()> ByVal ISPLIT As Integer(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal IFAILV As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZSTEGR Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), <[In](),Out()> ByVal E As Double(), ByRef VL As Double, _
    ByRef VU As Double, ByRef IL As Integer, ByRef IU As Integer, _
    ByRef ABSTOL As Double, ByRef M As Integer, <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, <Out()> ByVal ISUPPZ As Integer(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )

   Declare Sub F08JYF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), <[In](),Out()> ByVal E As Double(), ByRef VL As Double, _
    ByRef VU As Double, ByRef IL As Integer, ByRef IU As Integer, _
    ByRef ABSTOL As Double, ByRef M As Integer, <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, <Out()> ByVal ISUPPZ As Integer(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )


   Declare Sub DGELSS Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08KAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGESVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, _
    ByVal JOBVT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long _
    )

   Declare Sub F08KBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, _
    ByVal JOBVT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long _
    )


   Declare Sub DGELSD Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08KCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub DGESDD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long _
    )

   Declare Sub F08KDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long _
    )


   Declare Sub DGEBRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAUQ As Double(), _
    <Out()> ByVal TAUP As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08KEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAUQ As Double(), _
    <Out()> ByVal TAUP As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORGBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )

   Declare Sub F08KFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )


   Declare Sub DORMBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08KGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEJSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, _
    ByVal JOBU As string, _
    ByVal JOBV As string, _
    ByVal JOBR As string, _
    ByVal JOBT As string, _
    ByVal JOBP As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal SVA As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBRLength As long, _
    ByVal JOBTLength As long, _
    ByVal JOBPLength As long _
    )

   Declare Sub F08KHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, _
    ByVal JOBU As string, _
    ByVal JOBV As string, _
    ByVal JOBR As string, _
    ByVal JOBT As string, _
    ByVal JOBP As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal SVA As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBRLength As long, _
    ByVal JOBTLength As long, _
    ByVal JOBPLength As long _
    )


   Declare Sub DGESVJ Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, _
    ByVal JOBU As string, _
    ByVal JOBV As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal SVA As Double(), _
    ByRef MV As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long _
    )

   Declare Sub F08KJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, _
    ByVal JOBU As string, _
    ByVal JOBV As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal SVA As Double(), _
    ByRef MV As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long _
    )


   Declare Sub DGESVDX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBVT As string, ByVal RANGE As string, _
    ByRef M As Integer, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef NS As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal U As Double(,), ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), ByRef LDVT As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long, _
    ByVal RANGELength As long _
    )

   Declare Sub F08KMF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBVT As string, ByVal RANGE As string, _
    ByRef M As Integer, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef NS As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal U As Double(,), ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), ByRef LDVT As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long, _
    ByVal RANGELength As long _
    )


   Declare Sub ZGELSS Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08KNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZGESVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, _
    ByVal JOBVT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Complex(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long _
    )

   Declare Sub F08KPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, _
    ByVal JOBVT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Complex(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long _
    )


   Declare Sub ZGELSD Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer _
   )

   Declare Sub F08KQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal S As Double(), _
    ByRef RCOND As Double, _
    ByRef RANK As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer _
   )


   Declare Sub ZGESDD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Complex(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long _
    )

   Declare Sub F08KRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Complex(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long _
    )


   Declare Sub ZGEBRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAUQ As Complex(), _
    <Out()> ByVal TAUP As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08KSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal TAUQ As Complex(), _
    <Out()> ByVal TAUP As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNGBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )

   Declare Sub F08KTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )


   Declare Sub ZUNMBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08KUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEJSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, ByVal JOBU As string, ByVal JOBV As string, _
    ByVal JOBR As string, ByVal JOBT As string, ByVal JOBP As string, _
    ByRef M As Integer, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <Out()> ByVal SVA As Double(), <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal CWORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBRLength As long, _
    ByVal JOBTLength As long, _
    ByVal JOBPLength As long _
    )

   Declare Sub F08KVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, ByVal JOBU As string, ByVal JOBV As string, _
    ByVal JOBR As string, ByVal JOBT As string, ByVal JOBP As string, _
    ByRef M As Integer, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <Out()> ByVal SVA As Double(), <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal CWORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBRLength As long, _
    ByVal JOBTLength As long, _
    ByVal JOBPLength As long _
    )


   Declare Sub ZGESVJ Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, _
    ByVal JOBU As string, _
    ByVal JOBV As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal SVA As Double(), _
    ByRef MV As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal CWORK As Complex(), _
    ByRef LWORK As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long _
    )

   Declare Sub F08KWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBA As string, _
    ByVal JOBU As string, _
    ByVal JOBV As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal SVA As Double(), _
    ByRef MV As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <Out()> ByVal CWORK As Complex(), _
    ByRef LWORK As Integer, _
    <[In](),Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBALength As long, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long _
    )


   Declare Sub ZGESVDX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBVT As string, ByVal RANGE As string, _
    ByRef M As Integer, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef NS As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal U As Complex(,), ByRef LDU As Integer, _
    <Out()> ByVal VT As Complex(,), ByRef LDVT As Integer, <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long, _
    ByVal RANGELength As long _
    )

   Declare Sub F08KZF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBVT As string, ByVal RANGE As string, _
    ByRef M As Integer, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef NS As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal U As Complex(,), ByRef LDU As Integer, _
    <Out()> ByVal VT As Complex(,), ByRef LDVT As Integer, <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long, _
    ByVal RANGELength As long _
    )


   Declare Sub DGBBRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NCC As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal PT As Double(,), _
    ByRef LDPT As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )

   Declare Sub F08LEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NCC As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal PT As Double(,), _
    ByRef LDPT As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )


   Declare Sub ZGBBRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NCC As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal PT As Complex(,), _
    ByRef LDPT As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )

   Declare Sub F08LSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NCC As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal E As Double(), _
    <Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal PT As Complex(,), _
    ByRef LDPT As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long _
    )


   Declare Sub DBDSVDX Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef NS As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )

   Declare Sub F08MBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal JOBZ As string, _
    ByVal RANGE As string, _
    ByRef N As Integer, _
    <[In]()> ByVal D As Double(), _
    <[In]()> ByVal E As Double(), _
    ByRef VL As Double, _
    ByRef VU As Double, _
    ByRef IL As Integer, _
    ByRef IU As Integer, _
    ByRef NS As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long _
    )


   Declare Sub DBDSDC Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal COMPQ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal Q As Double(), _
    <Out()> ByVal IQ As Integer(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal COMPQLength As long _
    )

   Declare Sub F08MDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByVal COMPQ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <Out()> ByVal Q As Double(), _
    <Out()> ByVal IQ As Integer(), _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long, _
    ByVal COMPQLength As long _
    )


   Declare Sub DBDSQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NCVT As Integer, _
    ByRef NRU As Integer, _
    ByRef NCC As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <[In](),Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08MEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NCVT As Integer, _
    ByRef NRU As Integer, _
    ByRef NCC As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    <[In](),Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZBDSQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NCVT As Integer, _
    ByRef NRU As Integer, _
    ByRef NCC As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal VT As Complex(,), _
    ByRef LDVT As Integer, _
    <[In](),Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08MSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef NCVT As Integer, _
    ByRef NRU As Integer, _
    ByRef NCC As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal E As Double(), _
    <[In](),Out()> ByVal VT As Complex(,), _
    ByRef LDVT As Integer, _
    <[In](),Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DGEEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    <Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )

   Declare Sub F08NAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    <Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


   Declare Sub DGEEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <Out()> ByVal WR As Double(), <Out()> ByVal WI As Double(), _
    <Out()> ByVal VL As Double(,), ByRef LDVL As Integer, <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <Out()> ByVal SCAL As Double(), ByRef ABNRM As Double, <Out()> ByVal RCONDE As Double(), _
    <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )

   Declare Sub F08NBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <Out()> ByVal WR As Double(), <Out()> ByVal WI As Double(), _
    <Out()> ByVal VL As Double(,), ByRef LDVL As Integer, <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <Out()> ByVal SCAL As Double(), ByRef ABNRM As Double, <Out()> ByVal RCONDE As Double(), _
    <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )


   Declare Sub DGEHRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08NEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORGHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08NFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DORMHR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08NGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Double(), _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub DGEBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal SCAL As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )

   Declare Sub F08NHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal SCAL As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )


   Declare Sub DGEBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal SCAL As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )

   Declare Sub F08NJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal SCAL As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )


   Declare Sub ZGEEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )

   Declare Sub F08NNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


   Declare Sub ZGEEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <Out()> ByVal W As Complex(), <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, <Out()> ByVal VR As Complex(,), ByRef LDVR As Integer, _
    ByRef ILO As Integer, ByRef IHI As Integer, <Out()> ByVal SCAL As Double(), _
    ByRef ABNRM As Double, <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )

   Declare Sub F08NPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <Out()> ByVal W As Complex(), <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, <Out()> ByVal VR As Complex(,), ByRef LDVR As Integer, _
    ByRef ILO As Integer, ByRef IHI As Integer, <Out()> ByVal SCAL As Double(), _
    ByRef ABNRM As Double, <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )


   Declare Sub ZGEHRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08NSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNGHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08NTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZUNMHR Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08NUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal TAU As Complex(), _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZGEBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal SCAL As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )

   Declare Sub F08NVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal SCAL As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )


   Declare Sub ZGEBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal SCAL As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )

   Declare Sub F08NWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal SCAL As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )


  Delegate Function DGEES_SEL_DELEGATE( _
    ByRef WR As Double, _
    ByRef WI As Double _
  ) as Integer

   Declare Function F08PAZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef WR As Double, _
    ByRef WI As Double _
  ) as Integer

   Declare Sub DGEES Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, _
    ByVal SORT As string, _
    ByVal SEL As DGEES_SEL_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef SDIM As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    <Out()> ByVal VS As Double(,), _
    ByRef LDVS As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long _
    )

  Delegate Function F08PAF_SEL_DELEGATE( _
    ByRef WR As Double, _
    ByRef WI As Double _
  ) as Integer


   Declare Sub F08PAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, _
    ByVal SORT As string, _
    ByVal SEL As F08PAF_SEL_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef SDIM As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    <Out()> ByVal VS As Double(,), _
    ByRef LDVS As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long _
    )


  Delegate Function DGEESX_SEL_DELEGATE( _
    ByRef WR As Double, _
    ByRef WI As Double _
  ) as Integer


   Declare Sub DGEESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, ByVal SORT As string, ByVal SEL As DGEESX_SEL_DELEGATE, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, ByRef SDIM As Integer, <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), <Out()> ByVal VS As Double(,), ByRef LDVS As Integer, _
    ByRef RCONDE As Double, ByRef RCONDV As Double, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )

  Delegate Function F08PBF_SEL_DELEGATE( _
    ByRef WR As Double, _
    ByRef WI As Double _
  ) as Integer


   Declare Sub F08PBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, ByVal SORT As string, ByVal SEL As F08PBF_SEL_DELEGATE, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, ByRef SDIM As Integer, <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), <Out()> ByVal VS As Double(,), ByRef LDVS As Integer, _
    ByRef RCONDE As Double, ByRef RCONDV As Double, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )


   Declare Sub DHSEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08PEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPZLength As long _
    )


   Declare Sub DHSEIN Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal EIGSRC As string, _
    ByVal INITV As string, _
    <[In](),Out()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    <[In](),Out()> ByVal WR As Double(), _
    <[In]()> ByVal WI As Double(), _
    <[In](),Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IFAILL As Integer(), _
    <Out()> ByVal IFAILR As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal EIGSRCLength As long, _
    ByVal INITVLength As long _
    )

   Declare Sub F08PKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal EIGSRC As string, _
    ByVal INITV As string, _
    <[In](),Out()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    <[In](),Out()> ByVal WR As Double(), _
    <[In]()> ByVal WI As Double(), _
    <[In](),Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IFAILL As Integer(), _
    <Out()> ByVal IFAILR As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal EIGSRCLength As long, _
    ByVal INITVLength As long _
    )


  Delegate Function ZGEES_SEL_DELEGATE( _
    ByRef W As Complex _
  ) as Integer

   Declare Function F08PNZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef W As Complex _
  ) as Integer

   Declare Sub ZGEES Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, _
    ByVal SORT As string, _
    ByVal SEL As ZGEES_SEL_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef SDIM As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal VS As Complex(,), _
    ByRef LDVS As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal BWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long _
    )

  Delegate Function F08PNF_SEL_DELEGATE( _
    ByRef W As Complex _
  ) as Integer


   Declare Sub F08PNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, _
    ByVal SORT As string, _
    ByVal SEL As F08PNF_SEL_DELEGATE, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef SDIM As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal VS As Complex(,), _
    ByRef LDVS As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal BWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long _
    )


  Delegate Function ZGEESX_SEL_DELEGATE( _
    ByRef W As Complex _
  ) as Integer


   Declare Sub ZGEESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, _
    ByVal SORT As string, _
    ByVal SEL As ZGEESX_SEL_DELEGATE, _
    ByVal SENSE As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef SDIM As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal VS As Complex(,), _
    ByRef LDVS As Integer, _
    ByRef RCONDE As Double, _
    ByRef RCONDV As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal BWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )

  Delegate Function F08PPF_SEL_DELEGATE( _
    ByRef W As Complex _
  ) as Integer


   Declare Sub F08PPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVS As string, _
    ByVal SORT As string, _
    ByVal SEL As F08PPF_SEL_DELEGATE, _
    ByVal SENSE As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    ByRef SDIM As Integer, _
    <Out()> ByVal W As Complex(), _
    <Out()> ByVal VS As Complex(,), _
    ByRef LDVS As Integer, _
    ByRef RCONDE As Double, _
    ByRef RCONDV As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal BWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBVSLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )


   Declare Sub ZHSEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal H As Complex(,), _
    ByRef LDH As Integer, _
    <Out()> ByVal W As Complex(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08PSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal H As Complex(,), _
    ByRef LDH As Integer, _
    <Out()> ByVal W As Complex(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPZLength As long _
    )


   Declare Sub ZHSEIN Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal EIGSRC As string, _
    ByVal INITV As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal H As Complex(,), _
    ByRef LDH As Integer, _
    <[In](),Out()> ByVal W As Complex(), _
    <[In](),Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IFAILL As Integer(), _
    <Out()> ByVal IFAILR As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal EIGSRCLength As long, _
    ByVal INITVLength As long _
    )

   Declare Sub F08PXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal EIGSRC As string, _
    ByVal INITV As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal H As Complex(,), _
    ByRef LDH As Integer, _
    <[In](),Out()> ByVal W As Complex(), _
    <[In](),Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IFAILL As Integer(), _
    <Out()> ByVal IFAILR As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal EIGSRCLength As long, _
    ByVal INITVLength As long _
    )


   Declare Sub DTREXC Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long _
    )

   Declare Sub F08QFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long _
    )


   Declare Sub DTRSEN Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPQ As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    ByRef M As Integer, _
    ByRef S As Double, _
    ByRef SEP As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long _
    )

   Declare Sub F08QGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPQ As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal WR As Double(), _
    <Out()> ByVal WI As Double(), _
    ByRef M As Integer, _
    ByRef S As Double, _
    ByRef SEP As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long _
    )


   Declare Sub DTRSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANA As string, _
    ByVal TRANB As string, _
    ByRef ISGN As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByRef SCAL As Double, _
    ByRef INFO As Integer, _
    ByVal TRANALength As long, _
    ByVal TRANBLength As long _
    )

   Declare Sub F08QHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANA As string, _
    ByVal TRANB As string, _
    ByRef ISGN As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByRef SCAL As Double, _
    ByRef INFO As Integer, _
    ByVal TRANALength As long, _
    ByVal TRANBLength As long _
    )


   Declare Sub DTREVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In](),Out()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08QKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In](),Out()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub DTRSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In]()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In]()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal SEP As Double(), _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(,), _
    ByRef LDWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08QLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal T As Double(,), _
    ByRef LDT As Integer, _
    <[In]()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In]()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal SEP As Double(), _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(,), _
    ByRef LDWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub ZTREXC Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long _
    )

   Declare Sub F08QTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long _
    )


   Declare Sub ZTRSEN Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPQ As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal W As Complex(), _
    ByRef M As Integer, _
    ByRef S As Double, _
    ByRef SEP As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long _
    )

   Declare Sub F08QUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal COMPQ As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <Out()> ByVal W As Complex(), _
    ByRef M As Integer, _
    ByRef S As Double, _
    ByRef SEP As Double, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long _
    )


   Declare Sub ZTRSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANA As string, _
    ByVal TRANB As string, _
    ByRef ISGN As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByRef SCAL As Double, _
    ByRef INFO As Integer, _
    ByVal TRANALength As long, _
    ByVal TRANBLength As long _
    )

   Declare Sub F08QVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANA As string, _
    ByVal TRANB As string, _
    ByRef ISGN As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, _
    ByRef SCAL As Double, _
    ByRef INFO As Integer, _
    ByVal TRANALength As long, _
    ByVal TRANBLength As long _
    )


   Declare Sub ZTREVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08QXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In](),Out()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In](),Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub ZTRSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In]()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In]()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal SEP As Double(), _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(,), _
    ByRef LDWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08QYF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal T As Complex(,), _
    ByRef LDT As Integer, _
    <[In]()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In]()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal SEP As Double(), _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(,), _
    ByRef LDWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub DORCSD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU1 As string, ByVal JOBU2 As string, ByVal JOBV1T As string, _
    ByVal JOBV2T As string, ByVal TRANS As string, ByVal SIGNS As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef Q As Integer, _
    <[In](),Out()> ByVal X11 As Double(,), ByRef LDX11 As Integer, <[In](),Out()> ByVal X12 As Double(,), _
    ByRef LDX12 As Integer, <[In](),Out()> ByVal X21 As Double(,), ByRef LDX21 As Integer, _
    <[In](),Out()> ByVal X22 As Double(,), ByRef LDX22 As Integer, <Out()> ByVal THETA As Double(), _
    <Out()> ByVal U1 As Double(,), ByRef LDU1 As Integer, <Out()> ByVal U2 As Double(,), _
    ByRef LDU2 As Integer, <Out()> ByVal V1T As Double(,), ByRef LDV1T As Integer, _
    <Out()> ByVal V2T As Double(,), ByRef LDV2T As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBU1Length As long, _
    ByVal JOBU2Length As long, _
    ByVal JOBV1TLength As long, _
    ByVal JOBV2TLength As long, _
    ByVal TRANSLength As long, _
    ByVal SIGNSLength As long _
    )

   Declare Sub F08RAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU1 As string, ByVal JOBU2 As string, ByVal JOBV1T As string, _
    ByVal JOBV2T As string, ByVal TRANS As string, ByVal SIGNS As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef Q As Integer, _
    <[In](),Out()> ByVal X11 As Double(,), ByRef LDX11 As Integer, <[In](),Out()> ByVal X12 As Double(,), _
    ByRef LDX12 As Integer, <[In](),Out()> ByVal X21 As Double(,), ByRef LDX21 As Integer, _
    <[In](),Out()> ByVal X22 As Double(,), ByRef LDX22 As Integer, <Out()> ByVal THETA As Double(), _
    <Out()> ByVal U1 As Double(,), ByRef LDU1 As Integer, <Out()> ByVal U2 As Double(,), _
    ByRef LDU2 As Integer, <Out()> ByVal V1T As Double(,), ByRef LDV1T As Integer, _
    <Out()> ByVal V2T As Double(,), ByRef LDV2T As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBU1Length As long, _
    ByVal JOBU2Length As long, _
    ByVal JOBV1TLength As long, _
    ByVal JOBV2TLength As long, _
    ByVal TRANSLength As long, _
    ByVal SIGNSLength As long _
    )


   Declare Sub ZUNCSD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU1 As string, ByVal JOBU2 As string, ByVal JOBV1T As string, _
    ByVal JOBV2T As string, ByVal TRANS As string, ByVal SIGNS As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef Q As Integer, _
    <[In](),Out()> ByVal X11 As Complex(,), ByRef LDX11 As Integer, <[In](),Out()> ByVal X12 As Complex(,), _
    ByRef LDX12 As Integer, <[In](),Out()> ByVal X21 As Complex(,), ByRef LDX21 As Integer, _
    <[In](),Out()> ByVal X22 As Complex(,), ByRef LDX22 As Integer, <Out()> ByVal THETA As Double(), _
    <Out()> ByVal U1 As Complex(,), ByRef LDU1 As Integer, <Out()> ByVal U2 As Complex(,), _
    ByRef LDU2 As Integer, <Out()> ByVal V1T As Complex(,), ByRef LDV1T As Integer, _
    <Out()> ByVal V2T As Complex(,), ByRef LDV2T As Integer, <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBU1Length As long, _
    ByVal JOBU2Length As long, _
    ByVal JOBV1TLength As long, _
    ByVal JOBV2TLength As long, _
    ByVal TRANSLength As long, _
    ByVal SIGNSLength As long _
    )

   Declare Sub F08RNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU1 As string, ByVal JOBU2 As string, ByVal JOBV1T As string, _
    ByVal JOBV2T As string, ByVal TRANS As string, ByVal SIGNS As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef Q As Integer, _
    <[In](),Out()> ByVal X11 As Complex(,), ByRef LDX11 As Integer, <[In](),Out()> ByVal X12 As Complex(,), _
    ByRef LDX12 As Integer, <[In](),Out()> ByVal X21 As Complex(,), ByRef LDX21 As Integer, _
    <[In](),Out()> ByVal X22 As Complex(,), ByRef LDX22 As Integer, <Out()> ByVal THETA As Double(), _
    <Out()> ByVal U1 As Complex(,), ByRef LDU1 As Integer, <Out()> ByVal U2 As Complex(,), _
    ByRef LDU2 As Integer, <Out()> ByVal V1T As Complex(,), ByRef LDV1T As Integer, _
    <Out()> ByVal V2T As Complex(,), ByRef LDV2T As Integer, <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBU1Length As long, _
    ByVal JOBU2Length As long, _
    ByVal JOBV1TLength As long, _
    ByVal JOBV2TLength As long, _
    ByVal TRANSLength As long, _
    ByVal SIGNSLength As long _
    )


   Declare Sub DSYGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSYGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHEGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHEGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHEGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHEGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08SSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal BP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal BP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal BP As Double(), ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef ABSTOL As Double, _
    ByRef M As Integer, <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal BP As Double(), ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef ABSTOL As Double, _
    ByRef M As Integer, <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal BP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In](),Out()> ByVal BP As Double(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSPGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In]()> ByVal BP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Double(), _
    <[In]()> ByVal BP As Double(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal BP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal BP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal BP As Complex(), ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef ABSTOL As Double, _
    ByRef M As Integer, <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, ByVal JOBZ As string, ByVal RANGE As string, _
    ByVal UPLO As string, ByRef N As Integer, <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal BP As Complex(), ByRef VL As Double, ByRef VU As Double, _
    ByRef IL As Integer, ByRef IU As Integer, ByRef ABSTOL As Double, _
    ByRef M As Integer, <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), _
    <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal BP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In](),Out()> ByVal BP As Complex(), _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHPGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal BP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08TSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITYPE As Integer, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal AP As Complex(), _
    <[In]()> ByVal BP As Complex(), _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBGV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBGVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KA As Integer, ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), ByRef LDAB As Integer, <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KA As Integer, ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), ByRef LDAB As Integer, <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Double(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), <Out()> ByVal IWORK As Integer(), <Out()> ByVal JFAIL As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBGVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DSBGST Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub DPBSTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal BB As Double(,), _
    ByRef LDBB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBGV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBGVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KA As Integer, ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), ByRef LDAB As Integer, <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, ByVal RANGE As string, ByVal UPLO As string, _
    ByRef N As Integer, ByRef KA As Integer, ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), ByRef LDAB As Integer, <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, _
    ByRef VL As Double, ByRef VU As Double, ByRef IL As Integer, _
    ByRef IU As Integer, ByRef ABSTOL As Double, ByRef M As Integer, _
    <Out()> ByVal W As Double(), <Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal JFAIL As Integer(), ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal RANGELength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBGVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBZ As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal W As Double(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef LRWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBZLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZHBGST Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08USF Lib "NLW6I31DE_nag.dll" ( _
    ByVal VECT As string, _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KA As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    <Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal VECTLength As long, _
    ByVal UPLOLength As long _
    )


   Declare Sub ZPBSTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )

   Declare Sub F08UTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal UPLO As string, _
    ByRef N As Integer, _
    ByRef KB As Integer, _
    <[In](),Out()> ByVal BB As Complex(,), _
    ByRef LDBB As Integer, _
    ByRef INFO As Integer, _
    ByVal UPLOLength As long _
    )


   Declare Sub DGGSVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Double(), _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub DGGSVD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub DGGSVP Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal TAU As Double(), <Out()> ByVal WORK As Double(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal TAU As Double(), <Out()> ByVal WORK As Double(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub DGGSVP3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal TAU As Double(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Double(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal TAU As Double(), <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub ZGGSVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub ZGGSVD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef N As Integer, ByRef P As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub ZGGSVP Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal TAU As Complex(), <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal TAU As Complex(), <Out()> ByVal WORK As Complex(), _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub ZGGSVP3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal TAU As Complex(), <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08VUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, ByRef TOLA As Double, ByRef TOLB As Double, _
    ByRef K As Integer, ByRef L As Integer, <Out()> ByVal U As Complex(,), _
    ByRef LDU As Integer, <Out()> ByVal V As Complex(,), ByRef LDV As Integer, _
    <Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal TAU As Complex(), <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub DGGEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), _
    <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), _
    <Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )

   Declare Sub F08WAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), _
    <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), _
    <Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


   Declare Sub DGGEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), <Out()> ByVal BETA As Double(), _
    <Out()> ByVal VL As Double(,), ByRef LDVL As Integer, <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <Out()> ByVal LSCALE As Double(), <Out()> ByVal RSCALE As Double(), ByRef ABNRM As Double, _
    ByRef BBNRM As Double, <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )

   Declare Sub F08WBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), <Out()> ByVal BETA As Double(), _
    <Out()> ByVal VL As Double(,), ByRef LDVL As Integer, <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <Out()> ByVal LSCALE As Double(), <Out()> ByVal RSCALE As Double(), ByRef ABNRM As Double, _
    ByRef BBNRM As Double, <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )


   Declare Sub DGGEV3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), _
    <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), _
    <Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )

   Declare Sub F08WCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), _
    <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), _
    <Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


   Declare Sub DGGHRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08WEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )


   Declare Sub DGGHD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08WFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )


   Declare Sub DGGBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal LSCALE As Double(), _
    <Out()> ByVal RSCALE As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )

   Declare Sub F08WHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal LSCALE As Double(), _
    <Out()> ByVal RSCALE As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )


   Declare Sub DGGBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal LSCALE As Double(), _
    <[In]()> ByVal RSCALE As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )

   Declare Sub F08WJF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal LSCALE As Double(), _
    <[In]()> ByVal RSCALE As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )


   Declare Sub ZGGEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), _
    <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )

   Declare Sub F08WNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), _
    <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


   Declare Sub ZGGEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, <Out()> ByVal VR As Complex(,), ByRef LDVR As Integer, _
    ByRef ILO As Integer, ByRef IHI As Integer, <Out()> ByVal LSCALE As Double(), _
    <Out()> ByVal RSCALE As Double(), ByRef ABNRM As Double, ByRef BBNRM As Double, _
    <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )

   Declare Sub F08WPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal BALANC As string, ByVal JOBVL As string, ByVal JOBVR As string, _
    ByVal SENSE As string, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, <Out()> ByVal VR As Complex(,), ByRef LDVR As Integer, _
    ByRef ILO As Integer, ByRef IHI As Integer, <Out()> ByVal LSCALE As Double(), _
    <Out()> ByVal RSCALE As Double(), ByRef ABNRM As Double, ByRef BBNRM As Double, _
    <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal BALANCLength As long, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long, _
    ByVal SENSELength As long _
    )


   Declare Sub ZGGEV3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), _
    <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )

   Declare Sub F08WQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVL As string, _
    ByVal JOBVR As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), _
    <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBVLLength As long, _
    ByVal JOBVRLength As long _
    )


   Declare Sub ZGGHRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08WSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )


   Declare Sub ZGGHD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08WTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal COMPQ As string, _
    ByVal COMPZ As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )


   Declare Sub ZGGBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal LSCALE As Double(), _
    <Out()> ByVal RSCALE As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )

   Declare Sub F08WVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <Out()> ByVal LSCALE As Double(), _
    <Out()> ByVal RSCALE As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal JOBLength As long _
    )


   Declare Sub ZGGBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal LSCALE As Double(), _
    <[In]()> ByVal RSCALE As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )

   Declare Sub F08WWF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, _
    ByVal SIDE As string, _
    ByRef N As Integer, _
    ByRef ILO As Integer, _
    ByRef IHI As Integer, _
    <[In]()> ByVal LSCALE As Double(), _
    <[In]()> ByVal RSCALE As Double(), _
    ByRef M As Integer, _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal SIDELength As long _
    )


  Delegate Function DGGES_SELCTG_DELEGATE( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef B As Double _
  ) as Integer

   Declare Function F08XAZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef B As Double _
  ) as Integer

   Declare Sub DGGES Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As DGGES_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), <Out()> ByVal VSL As Double(,), ByRef LDVSL As Integer, _
    <Out()> ByVal VSR As Double(,), ByRef LDVSR As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )

  Delegate Function F08XAF_SELCTG_DELEGATE( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef B As Double _
  ) as Integer


   Declare Sub F08XAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As F08XAF_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), <Out()> ByVal VSL As Double(,), ByRef LDVSL As Integer, _
    <Out()> ByVal VSR As Double(,), ByRef LDVSR As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )


  Delegate Function DGGESX_SELCTG_DELEGATE( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef B As Double _
  ) as Integer


   Declare Sub DGGESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As DGGESX_SELCTG_DELEGATE, ByVal SENSE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, ByRef SDIM As Integer, <Out()> ByVal ALPHAR As Double(), _
    <Out()> ByVal ALPHAI As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal VSL As Double(,), _
    ByRef LDVSL As Integer, <Out()> ByVal VSR As Double(,), ByRef LDVSR As Integer, _
    <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )

  Delegate Function F08XBF_SELCTG_DELEGATE( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef B As Double _
  ) as Integer


   Declare Sub F08XBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As F08XBF_SELCTG_DELEGATE, ByVal SENSE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, ByRef SDIM As Integer, <Out()> ByVal ALPHAR As Double(), _
    <Out()> ByVal ALPHAI As Double(), <Out()> ByVal BETA As Double(), <Out()> ByVal VSL As Double(,), _
    ByRef LDVSL As Integer, <Out()> ByVal VSR As Double(,), ByRef LDVSR As Integer, _
    <Out()> ByVal RCONDE As Double(), <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )


  Delegate Function DGGES3_SELCTG_DELEGATE( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef B As Double _
  ) as Integer


   Declare Sub DGGES3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As DGGES3_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), <Out()> ByVal VSL As Double(,), ByRef LDVSL As Integer, _
    <Out()> ByVal VSR As Double(,), ByRef LDVSR As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )

  Delegate Function F08XCF_SELCTG_DELEGATE( _
    ByRef AR As Double, _
    ByRef AI As Double, _
    ByRef B As Double _
  ) as Integer


   Declare Sub F08XCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As F08XCF_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), <Out()> ByVal VSL As Double(,), ByRef LDVSL As Integer, _
    <Out()> ByVal VSR As Double(,), ByRef LDVSR As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )


   Declare Sub DHGEQZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal COMPQ As string, ByVal COMPZ As string, _
    ByRef N As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), <[In](),Out()> ByVal Q As Double(,), ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), ByRef LDZ As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08XEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal COMPQ As string, ByVal COMPZ As string, _
    ByRef N As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Double(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), _
    <Out()> ByVal BETA As Double(), <[In](),Out()> ByVal Q As Double(,), ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), ByRef LDZ As Integer, <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )


  Delegate Function ZGGES_SELCTG_DELEGATE( _
    ByRef A As Complex, _
    ByRef B As Complex _
  ) as Integer

   Declare Function F08XNZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef A As Complex, _
    ByRef B As Complex _
  ) as Integer

   Declare Sub ZGGES Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As ZGGES_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VSL As Complex(,), ByRef LDVSL As Integer, <Out()> ByVal VSR As Complex(,), _
    ByRef LDVSR As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )

  Delegate Function F08XNF_SELCTG_DELEGATE( _
    ByRef A As Complex, _
    ByRef B As Complex _
  ) as Integer


   Declare Sub F08XNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As F08XNF_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VSL As Complex(,), ByRef LDVSL As Integer, <Out()> ByVal VSR As Complex(,), _
    ByRef LDVSR As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )


  Delegate Function ZGGESX_SELCTG_DELEGATE( _
    ByRef A As Complex, _
    ByRef B As Complex _
  ) as Integer


   Declare Sub ZGGESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As ZGGESX_SELCTG_DELEGATE, ByVal SENSE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, ByRef SDIM As Integer, <Out()> ByVal ALPHA As Complex(), _
    <Out()> ByVal BETA As Complex(), <Out()> ByVal VSL As Complex(,), ByRef LDVSL As Integer, _
    <Out()> ByVal VSR As Complex(,), ByRef LDVSR As Integer, <Out()> ByVal RCONDE As Double(), _
    <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )

  Delegate Function F08XPF_SELCTG_DELEGATE( _
    ByRef A As Complex, _
    ByRef B As Complex _
  ) as Integer


   Declare Sub F08XPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As F08XPF_SELCTG_DELEGATE, ByVal SENSE As string, ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, ByRef SDIM As Integer, <Out()> ByVal ALPHA As Complex(), _
    <Out()> ByVal BETA As Complex(), <Out()> ByVal VSL As Complex(,), ByRef LDVSL As Integer, _
    <Out()> ByVal VSR As Complex(,), ByRef LDVSR As Integer, <Out()> ByVal RCONDE As Double(), _
    <Out()> ByVal RCONDV As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long, _
    ByVal SENSELength As long _
    )


  Delegate Function ZGGES3_SELCTG_DELEGATE( _
    ByRef A As Complex, _
    ByRef B As Complex _
  ) as Integer


   Declare Sub ZGGES3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As ZGGES3_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VSL As Complex(,), ByRef LDVSL As Integer, <Out()> ByVal VSR As Complex(,), _
    ByRef LDVSR As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )

  Delegate Function F08XQF_SELCTG_DELEGATE( _
    ByRef A As Complex, _
    ByRef B As Complex _
  ) as Integer


   Declare Sub F08XQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBVSL As string, ByVal JOBVSR As string, ByVal SORT As string, _
    ByVal SELCTG As F08XQF_SELCTG_DELEGATE, ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef SDIM As Integer, <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), _
    <Out()> ByVal VSL As Complex(,), ByRef LDVSL As Integer, <Out()> ByVal VSR As Complex(,), _
    ByRef LDVSR As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), <Out()> ByVal BWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBVSLLength As long, _
    ByVal JOBVSRLength As long, _
    ByVal SORTLength As long _
    )


   Declare Sub ZHGEQZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal COMPQ As string, ByVal COMPZ As string, _
    ByRef N As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), _
    <[In](),Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )

   Declare Sub F08XSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal COMPQ As string, ByVal COMPZ As string, _
    ByRef N As Integer, ByRef ILO As Integer, ByRef IHI As Integer, _
    <[In](),Out()> ByVal A As Complex(,), ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), _
    <[In](),Out()> ByVal Q As Complex(,), ByRef LDQ As Integer, <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal RWORK As Double(), ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal COMPQLength As long, _
    ByVal COMPZLength As long _
    )


   Declare Sub DTGSJA Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef TOLA As Double, ByRef TOLB As Double, <Out()> ByVal ALPHA As Double(), _
    <Out()> ByVal BETA As Double(), <[In](),Out()> ByVal U As Double(,), ByRef LDU As Integer, _
    <[In](),Out()> ByVal V As Double(,), ByRef LDV As Integer, <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, <Out()> ByVal WORK As Double(), ByRef NCYCLE As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08YEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    ByRef TOLA As Double, ByRef TOLB As Double, <Out()> ByVal ALPHA As Double(), _
    <Out()> ByVal BETA As Double(), <[In](),Out()> ByVal U As Double(,), ByRef LDU As Integer, _
    <[In](),Out()> ByVal V As Double(,), ByRef LDV As Integer, <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, <Out()> ByVal WORK As Double(), ByRef NCYCLE As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub DTGEXC Lib "NLW6I31DE_nag.dll" ( _
    ByRef WANTQ As Integer, _
    ByRef WANTZ As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08YFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef WANTQ As Integer, _
    ByRef WANTZ As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Double(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DTGSEN Lib "NLW6I31DE_nag.dll" ( _
    ByRef IJOB As Integer, ByRef WANTQ As Integer, ByRef WANTZ As Integer, _
    <[In]()> ByVal SEL As Integer(), ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), <Out()> ByVal BETA As Double(), _
    <[In](),Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, ByRef M As Integer, ByRef PL As Double, _
    ByRef PR As Double, <Out()> ByVal DIF As Double(), <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08YGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IJOB As Integer, ByRef WANTQ As Integer, ByRef WANTZ As Integer, _
    <[In]()> ByVal SEL As Integer(), ByRef N As Integer, <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Double(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHAR As Double(), <Out()> ByVal ALPHAI As Double(), <Out()> ByVal BETA As Double(), _
    <[In](),Out()> ByVal Q As Double(,), ByRef LDQ As Integer, <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, ByRef M As Integer, ByRef PL As Double, _
    ByRef PR As Double, <Out()> ByVal DIF As Double(), <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DTGSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef IJOB As Integer, ByRef M As Integer, _
    ByRef N As Integer, <[In]()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, <[In]()> ByVal D As Double(,), ByRef LDD As Integer, _
    <[In]()> ByVal E As Double(,), ByRef LDE As Integer, <[In](),Out()> ByVal F As Double(,), _
    ByRef LDF As Integer, ByRef SCAL As Double, ByRef DIF As Double, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08YHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef IJOB As Integer, ByRef M As Integer, _
    ByRef N As Integer, <[In]()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, <[In]()> ByVal D As Double(,), ByRef LDD As Integer, _
    <[In]()> ByVal E As Double(,), ByRef LDE As Integer, <[In](),Out()> ByVal F As Double(,), _
    ByRef LDF As Integer, ByRef SCAL As Double, ByRef DIF As Double, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub DTGEVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08YKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Double(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub DTGSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal HOWMNY As string, <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, <[In]()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <[In]()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, <[In]()> ByVal VR As Double(,), ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal DIF As Double(), ByRef MM As Integer, _
    ByRef M As Integer, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08YLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal HOWMNY As string, <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, <[In]()> ByVal A As Double(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Double(,), ByRef LDB As Integer, <[In]()> ByVal VL As Double(,), _
    ByRef LDVL As Integer, <[In]()> ByVal VR As Double(,), ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal DIF As Double(), ByRef MM As Integer, _
    ByRef M As Integer, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub ZTGSJA Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef TOLA As Double, ByRef TOLB As Double, <Out()> ByVal ALPHA As Double(), _
    <Out()> ByVal BETA As Double(), <[In](),Out()> ByVal U As Complex(,), ByRef LDU As Integer, _
    <[In](),Out()> ByVal V As Complex(,), ByRef LDV As Integer, <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, <Out()> ByVal WORK As Complex(), ByRef NCYCLE As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )

   Declare Sub F08YSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, ByVal JOBV As string, ByVal JOBQ As string, _
    ByRef M As Integer, ByRef P As Integer, ByRef N As Integer, _
    ByRef K As Integer, ByRef L As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    ByRef TOLA As Double, ByRef TOLB As Double, <Out()> ByVal ALPHA As Double(), _
    <Out()> ByVal BETA As Double(), <[In](),Out()> ByVal U As Complex(,), ByRef LDU As Integer, _
    <[In](),Out()> ByVal V As Complex(,), ByRef LDV As Integer, <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, <Out()> ByVal WORK As Complex(), ByRef NCYCLE As Integer, _
    ByRef INFO As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVLength As long, _
    ByVal JOBQLength As long _
    )


   Declare Sub ZTGEXC Lib "NLW6I31DE_nag.dll" ( _
    ByRef WANTQ As Integer, _
    ByRef WANTZ As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08YTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef WANTQ As Integer, _
    ByRef WANTZ As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef IFST As Integer, _
    ByRef ILST As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZTGSEN Lib "NLW6I31DE_nag.dll" ( _
    ByRef IJOB As Integer, ByRef WANTQ As Integer, ByRef WANTZ As Integer, _
    <[In]()> ByVal SEL As Integer(), ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, <[In](),Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    ByRef M As Integer, ByRef PL As Double, ByRef PR As Double, _
    <Out()> ByVal DIF As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, ByRef INFO As Integer _
   )

   Declare Sub F08YUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IJOB As Integer, ByRef WANTQ As Integer, ByRef WANTZ As Integer, _
    <[In]()> ByVal SEL As Integer(), ByRef N As Integer, <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, <[In](),Out()> ByVal B As Complex(,), ByRef LDB As Integer, _
    <Out()> ByVal ALPHA As Complex(), <Out()> ByVal BETA As Complex(), <[In](),Out()> ByVal Q As Complex(,), _
    ByRef LDQ As Integer, <[In](),Out()> ByVal Z As Complex(,), ByRef LDZ As Integer, _
    ByRef M As Integer, ByRef PL As Double, ByRef PR As Double, _
    <Out()> ByVal DIF As Double(), <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef LIWORK As Integer, ByRef INFO As Integer _
   )


   Declare Sub ZTGSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef IJOB As Integer, ByRef M As Integer, _
    ByRef N As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, <[In]()> ByVal D As Complex(,), ByRef LDD As Integer, _
    <[In]()> ByVal E As Complex(,), ByRef LDE As Integer, <[In](),Out()> ByVal F As Complex(,), _
    ByRef LDF As Integer, ByRef SCAL As Double, ByRef DIF As Double, _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )

   Declare Sub F08YVF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, ByRef IJOB As Integer, ByRef M As Integer, _
    ByRef N As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <[In](),Out()> ByVal C As Complex(,), _
    ByRef LDC As Integer, <[In]()> ByVal D As Complex(,), ByRef LDD As Integer, _
    <[In]()> ByVal E As Complex(,), ByRef LDE As Integer, <[In](),Out()> ByVal F As Complex(,), _
    ByRef LDF As Integer, ByRef SCAL As Double, ByRef DIF As Double, _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, <Out()> ByVal IWORK As Integer(), _
    ByRef INFO As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub ZTGEVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08YXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SIDE As string, _
    ByVal HOWMNY As string, _
    <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, _
    <[In](),Out()> ByVal VR As Complex(,), _
    ByRef LDVR As Integer, _
    ByRef MM As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal WORK As Complex(), _
    <Out()> ByVal RWORK As Double(), _
    ByRef INFO As Integer, _
    ByVal SIDELength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub ZTGSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal HOWMNY As string, <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <[In]()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, <[In]()> ByVal VR As Complex(,), ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal DIF As Double(), ByRef MM As Integer, _
    ByRef M As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )

   Declare Sub F08YYF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOB As string, ByVal HOWMNY As string, <[In]()> ByVal SEL As Integer(), _
    ByRef N As Integer, <[In]()> ByVal A As Complex(,), ByRef LDA As Integer, _
    <[In]()> ByVal B As Complex(,), ByRef LDB As Integer, <[In]()> ByVal VL As Complex(,), _
    ByRef LDVL As Integer, <[In]()> ByVal VR As Complex(,), ByRef LDVR As Integer, _
    <Out()> ByVal S As Double(), <Out()> ByVal DIF As Double(), ByRef MM As Integer, _
    ByRef M As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), ByRef INFO As Integer, _
    ByVal JOBLength As long, _
    ByVal HOWMNYLength As long _
    )


   Declare Sub DGGLSE Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal D As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Double(), _
    <[In](),Out()> ByVal D As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGGGLM Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal Y As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal Y As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGGQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub DGGRQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef P As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef P As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Double(), _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGGLSE Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Complex(), _
    <[In](),Out()> ByVal D As Complex(), _
    <Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal C As Complex(), _
    <[In](),Out()> ByVal D As Complex(), _
    <Out()> ByVal X As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGGGLM Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal D As Complex(), _
    <Out()> ByVal X As Complex(), _
    <Out()> ByVal Y As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal D As Complex(), _
    <Out()> ByVal X As Complex(), _
    <Out()> ByVal Y As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGGQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef P As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


   Declare Sub ZGGRQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef P As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )

   Declare Sub F08ZTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef P As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Complex(,), _
    ByRef LDA As Integer, _
    <Out()> ByVal TAUA As Complex(), _
    <[In](),Out()> ByVal B As Complex(,), _
    ByRef LDB As Integer, _
    <Out()> ByVal TAUB As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef INFO As Integer _
   )


' chapter f10

   Declare Sub F10CAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal JOBU As string, _
    ByVal JOBVT As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef K As Integer, _
    ByRef RTOL_ABS As Double, _
    ByRef RTOL_REL As Double, _
    <[In](),Out()> ByVal STATE As Integer(), _
    <Out()> ByVal S As Double(), _
    <Out()> ByVal U As Double(,), _
    ByRef LDU As Integer, _
    <Out()> ByVal VT As Double(,), _
    ByRef LDVT As Integer, _
    ByRef R As Integer, _
    ByRef IFAIL As Integer, _
    ByVal JOBULength As long, _
    ByVal JOBVTLength As long _
    )


   Declare Sub F10DAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    ByRef K As Integer, _
    <[In](),Out()> ByVal STATE As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long _
    )


' chapter f11

   Declare Sub F11BDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByVal NORM As string, _
    ByVal WEIGHT As string, _
    ByRef ITERM As Integer, _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    ByRef MONIT As Integer, _
    ByRef LWREQ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long, _
    ByVal NORMLength As long, _
    ByVal WEIGHTLength As long _
    )


   Declare Sub F11BEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    <[In](),Out()> ByVal V As Double(), _
    <[In]()> ByVal WGT As Double(), _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11BFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITN As Integer, _
    ByRef STPLHS As Double, _
    ByRef STPRHS As Double, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    <[In]()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11BRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByVal NORM As string, _
    ByVal WEIGHT As string, _
    ByRef ITERM As Integer, _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    ByRef MONIT As Integer, _
    ByRef LWREQ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long, _
    ByVal NORMLength As long, _
    ByVal WEIGHTLength As long _
    )


   Declare Sub F11BSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal U As Complex(), _
    <[In](),Out()> ByVal V As Complex(), _
    <[In]()> ByVal WGT As Double(), _
    <[In](),Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11BTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITN As Integer, _
    ByRef STPLHS As Double, _
    ByRef STPRHS As Double, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    <[In](),Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11DAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    ByRef LA As Integer, _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByRef LFILL As Integer, _
    ByRef DTOL As Double, _
    ByVal PSTRAT As string, _
    ByVal MILU As string, _
    <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), _
    <Out()> ByVal ISTR As Integer(), _
    <Out()> ByVal IDIAG As Integer(), _
    ByRef NNZC As Integer, _
    ByRef NPIVM As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal PSTRATLength As long, _
    ByVal MILULength As long _
    )


   Declare Sub F11DBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), _
    <[In]()> ByVal ISTR As Integer(), _
    <[In]()> ByVal IDIAG As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11DCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, ByRef N As Integer, ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), ByRef LA As Integer, <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), <[In](),Out()> ByVal IPIVP As Integer(), <[In](),Out()> ByVal IPIVQ As Integer(), _
    <[In]()> ByVal ISTR As Integer(), <[In]()> ByVal IDIAG As Integer(), <[In]()> ByVal B As Double(), _
    ByRef M As Integer, ByRef TOL As Double, ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Double(), ByRef RNORM As Double, ByRef ITN As Integer, _
    <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Sub F11DDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In]()> ByVal RDIAG As Double(), _
    ByRef OMEGA As Double, _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11DEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByRef OMEGA As Double, _
    <[In]()> ByVal B As Double(), _
    ByRef M As Integer, _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef RNORM As Double, _
    ByRef ITN As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long _
    )


   Declare Sub F11DFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NNZ As Integer, <[In](),Out()> ByVal A As Double(), _
    ByRef LA As Integer, <[In](),Out()> ByVal IROW As Integer(), <[In](),Out()> ByVal ICOL As Integer(), _
    ByRef NB As Integer, <[In]()> ByVal ISTB As Integer(), <[In]()> ByVal INDB As Integer(), _
    ByRef LINDB As Integer, <[In]()> ByVal LFILL As Integer(), <[In]()> ByVal DTOL As Double(), _
    ByVal PSTRAT As string, ByVal MILU As string, <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), <Out()> ByVal ISTR As Integer(), <Out()> ByVal IDIAG As Integer(), _
    ByRef NNZC As Integer, <Out()> ByVal NPIVM As Integer(), <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef IFAIL As Integer, _
    ByVal PSTRATLength As long, _
    ByVal MILULength As long _
    )


   Declare Sub F11DGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, ByRef N As Integer, ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), ByRef LA As Integer, <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), ByRef NB As Integer, <[In]()> ByVal ISTB As Integer(), _
    <[In]()> ByVal INDB As Integer(), ByRef LINDB As Integer, <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), <[In]()> ByVal ISTR As Integer(), <[In]()> ByVal IDIAG As Integer(), _
    <[In]()> ByVal B As Double(), ByRef M As Integer, ByRef TOL As Double, _
    ByRef MAXITN As Integer, <[In](),Out()> ByVal X As Double(), ByRef RNORM As Double, _
    ByRef ITN As Integer, <Out()> ByVal WORK As Double(), ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Sub F11DKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STORE As string, _
    ByVal TRANS As string, _
    ByVal INIT As string, _
    ByRef NITER As Integer, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal B As Double(), _
    <Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal DIAG As Double(), _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STORELength As long, _
    ByVal TRANSLength As long, _
    ByVal INITLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11DNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Complex(), _
    ByRef LA As Integer, _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByRef LFILL As Integer, _
    ByRef DTOL As Double, _
    ByVal PSTRAT As string, _
    ByVal MILU As string, _
    <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), _
    <Out()> ByVal ISTR As Integer(), _
    <Out()> ByVal IDIAG As Integer(), _
    ByRef NNZC As Integer, _
    ByRef NPIVM As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal PSTRATLength As long, _
    ByVal MILULength As long _
    )


   Declare Sub F11DPF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(), _
    ByRef LA As Integer, _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), _
    <[In]()> ByVal ISTR As Integer(), _
    <[In]()> ByVal IDIAG As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11DQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, ByRef N As Integer, ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), ByRef LA As Integer, <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), <[In](),Out()> ByVal IPIVP As Integer(), <[In](),Out()> ByVal IPIVQ As Integer(), _
    <[In]()> ByVal ISTR As Integer(), <[In]()> ByVal IDIAG As Integer(), <[In]()> ByVal B As Complex(), _
    ByRef M As Integer, ByRef TOL As Double, ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Complex(), ByRef RNORM As Double, ByRef ITN As Integer, _
    <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Sub F11DRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In]()> ByVal RDIAG As Complex(), _
    ByRef OMEGA As Double, _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11DSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByRef OMEGA As Double, _
    <[In]()> ByVal B As Complex(), _
    ByRef M As Integer, _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef RNORM As Double, _
    ByRef ITN As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long _
    )


   Declare Sub F11DTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, ByRef NNZ As Integer, <[In](),Out()> ByVal A As Complex(), _
    ByRef LA As Integer, <[In](),Out()> ByVal IROW As Integer(), <[In](),Out()> ByVal ICOL As Integer(), _
    ByRef NB As Integer, <[In]()> ByVal ISTB As Integer(), <[In]()> ByVal INDB As Integer(), _
    ByRef LINDB As Integer, <[In]()> ByVal LFILL As Integer(), <[In]()> ByVal DTOL As Double(), _
    ByVal PSTRAT As string, ByVal MILU As string, <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), <Out()> ByVal ISTR As Integer(), <Out()> ByVal IDIAG As Integer(), _
    ByRef NNZC As Integer, <Out()> ByVal NPIVM As Integer(), <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, ByRef IFAIL As Integer, _
    ByVal PSTRATLength As long, _
    ByVal MILULength As long _
    )


   Declare Sub F11DUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, ByRef N As Integer, ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), ByRef LA As Integer, <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), ByRef NB As Integer, <[In]()> ByVal ISTB As Integer(), _
    <[In]()> ByVal INDB As Integer(), ByRef LINDB As Integer, <[In](),Out()> ByVal IPIVP As Integer(), _
    <[In](),Out()> ByVal IPIVQ As Integer(), <[In]()> ByVal ISTR As Integer(), <[In]()> ByVal IDIAG As Integer(), _
    <[In]()> ByVal B As Complex(), ByRef M As Integer, ByRef TOL As Double, _
    ByRef MAXITN As Integer, <[In](),Out()> ByVal X As Complex(), ByRef RNORM As Double, _
    ByRef ITN As Integer, <Out()> ByVal WORK As Complex(), ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Sub F11DXF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STORE As string, _
    ByVal TRANS As string, _
    ByVal INIT As string, _
    ByRef NITER As Integer, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal B As Complex(), _
    <Out()> ByVal X As Complex(), _
    <[In](),Out()> ByVal DIAG As Complex(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal STORELength As long, _
    ByVal TRANSLength As long, _
    ByVal INITLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11GDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByVal SIGCMP As string, _
    ByVal NORM As string, _
    ByVal WEIGHT As string, _
    ByRef ITERM As Integer, _
    ByRef N As Integer, _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    ByRef SIGTOL As Double, _
    ByRef MAXITS As Integer, _
    ByRef MONIT As Integer, _
    ByRef LWREQ As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long, _
    ByVal SIGCMPLength As long, _
    ByVal NORMLength As long, _
    ByVal WEIGHTLength As long _
    )


   Declare Sub F11GEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal U As Double(), _
    <[In](),Out()> ByVal V As Double(), _
    <[In]()> ByVal WGT As Double(), _
    <[In](),Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11GFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITN As Integer, _
    ByRef STPLHS As Double, _
    ByRef STPRHS As Double, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    ByRef ITS As Integer, _
    ByRef SIGERR As Double, _
    <[In]()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11GRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByVal SIGCMP As string, _
    ByVal NORM As string, _
    ByVal WEIGHT As string, _
    ByRef ITERM As Integer, _
    ByRef N As Integer, _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    ByRef SIGTOL As Double, _
    ByRef MAXITS As Integer, _
    ByRef MONIT As Integer, _
    ByRef LWREQ As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long, _
    ByVal SIGCMPLength As long, _
    ByVal NORMLength As long, _
    ByVal WEIGHTLength As long _
    )


   Declare Sub F11GSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal U As Complex(), _
    <[In](),Out()> ByVal V As Complex(), _
    <[In]()> ByVal WGT As Double(), _
    <[In](),Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11GTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ITN As Integer, _
    ByRef STPLHS As Double, _
    ByRef STPRHS As Double, _
    ByRef ANORM As Double, _
    ByRef SIGMAX As Double, _
    ByRef ITS As Integer, _
    ByRef SIGERR As Double, _
    <[In]()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11JAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    ByRef LA As Integer, _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByRef LFILL As Integer, _
    ByRef DTOL As Double, _
    ByVal MIC As string, _
    ByRef DSCALE As Double, _
    ByVal PSTRAT As string, _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal ISTR As Integer(), _
    ByRef NNZC As Integer, _
    ByRef NPIVM As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal MICLength As long, _
    ByVal PSTRATLength As long _
    )


   Declare Sub F11JBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal ISTR As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    ByRef IFAIL As Integer, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11JCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal ISTR As Integer(), _
    <[In]()> ByVal B As Double(), _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef RNORM As Double, _
    ByRef ITN As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Sub F11JDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In]()> ByVal RDIAG As Double(), _
    ByRef OMEGA As Double, _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11JEF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByRef OMEGA As Double, _
    <[In]()> ByVal B As Double(), _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    ByRef RNORM As Double, _
    ByRef ITN As Integer, _
    <Out()> ByVal WORK As Double(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long _
    )


   Declare Sub F11JNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Complex(), _
    ByRef LA As Integer, _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByRef LFILL As Integer, _
    ByRef DTOL As Double, _
    ByVal MIC As string, _
    ByRef DSCALE As Double, _
    ByVal PSTRAT As string, _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <Out()> ByVal ISTR As Integer(), _
    ByRef NNZC As Integer, _
    ByRef NPIVM As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef LIWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal MICLength As long, _
    ByVal PSTRATLength As long _
    )


   Declare Sub F11JPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal A As Complex(), _
    ByRef LA As Integer, _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal ISTR As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11JQF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    ByRef LA As Integer, _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In](),Out()> ByVal IPIV As Integer(), _
    <[In]()> ByVal ISTR As Integer(), _
    <[In]()> ByVal B As Complex(), _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef RNORM As Double, _
    ByRef ITN As Integer, _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Sub F11JRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    <[In]()> ByVal RDIAG As Double(), _
    ByRef OMEGA As Double, _
    ByVal CHECK As string, _
    <[In]()> ByVal Y As Complex(), _
    <Out()> ByVal X As Complex(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11JSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByVal PRECON As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByRef OMEGA As Double, _
    <[In]()> ByVal B As Complex(), _
    ByRef TOL As Double, _
    ByRef MAXITN As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    ByRef RNORM As Double, _
    ByRef ITN As Integer, _
    <Out()> ByVal RDIAG As Double(), _
    <Out()> ByVal WORK As Complex(), _
    ByRef LWORK As Integer, _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long, _
    ByVal PRECONLength As long _
    )


   Declare Sub F11MDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SPEC As string, _
    ByRef N As Integer, _
    <[In]()> ByVal ICOLZP As Integer(), _
    <[In]()> ByVal IROWIX As Integer(), _
    <[In](),Out()> ByVal IPRM As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal SPECLength As long _
    )


   Declare Sub F11MEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal IROWIX As Integer(), _
    <[In]()> ByVal A As Double(), _
    <[In](),Out()> ByVal IPRM As Integer(), _
    ByRef THRESH As Double, _
    ByRef NZLMX As Integer, _
    ByRef NZLUMX As Integer, _
    ByRef NZUMX As Integer, _
    <Out()> ByVal IL As Integer(), _
    <Out()> ByVal LVAL As Double(), _
    <Out()> ByVal IU As Integer(), _
    <Out()> ByVal UVAL As Double(), _
    ByRef NNZL As Integer, _
    ByRef NNZU As Integer, _
    ByRef FLOP As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11MFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal IPRM As Integer(), _
    <[In]()> ByVal IL As Integer(), _
    <[In]()> ByVal LVAL As Double(), _
    <[In]()> ByVal IU As Integer(), _
    <[In]()> ByVal UVAL As Double(), _
    ByRef NRHS As Integer, _
    <[In](),Out()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub F11MGF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef N As Integer, _
    <[In]()> ByVal IL As Integer(), _
    <[In]()> ByVal LVAL As Double(), _
    <[In]()> ByVal IU As Integer(), _
    <[In]()> ByVal UVAL As Double(), _
    ByRef ANORM As Double, _
    ByRef RCOND As Double, _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub F11MHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    <[In]()> ByVal ICOLZP As Integer(), _
    <[In]()> ByVal IROWIX As Integer(), _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IPRM As Integer(), _
    <[In]()> ByVal IL As Integer(), _
    <[In]()> ByVal LVAL As Double(), _
    <[In]()> ByVal IU As Integer(), _
    <[In]()> ByVal UVAL As Double(), _
    ByRef NRHS As Integer, _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal FERR As Double(), _
    <Out()> ByVal BERR As Double(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub F11MKF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef M As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal ICOLZP As Integer(), _
    <[In]()> ByVal IROWIX As Integer(), _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal C As Double(,), _
    ByRef LDC As Integer, _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long _
    )


   Declare Sub F11MLF Lib "NLW6I31DE_nag.dll" ( _
    ByVal NORM As string, _
    ByRef ANORM As Double, _
    ByRef N As Integer, _
    <[In]()> ByVal ICOLZP As Integer(), _
    <[In]()> ByVal IROWIX As Integer(), _
    <[In]()> ByVal A As Double(), _
    ByRef IFAIL As Integer, _
    ByVal NORMLength As long _
    )


   Declare Sub F11MMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal ICOLZP As Integer(), _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IPRM As Integer(), _
    <[In]()> ByVal IL As Integer(), _
    <[In]()> ByVal LVAL As Double(), _
    <[In]()> ByVal IU As Integer(), _
    <[In]()> ByVal UVAL As Double(), _
    ByRef RPG As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11XAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal Y As Double(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11XEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal Y As Double(), _
    ByRef IFAIL As Integer, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11XNF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TRANS As string, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal X As Complex(), _
    <Out()> ByVal Y As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal TRANSLength As long, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11XSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal A As Complex(), _
    <[In]()> ByVal IROW As Integer(), _
    <[In]()> ByVal ICOL As Integer(), _
    ByVal CHECK As string, _
    <[In]()> ByVal X As Complex(), _
    <Out()> ByVal Y As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal CHECKLength As long _
    )


   Declare Sub F11YEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In]()> ByVal ICOLZP As Integer(), _
    <[In]()> ByVal IROWIX As Integer(), _
    <[In]()> ByVal LOPTS As Integer(), _
    <[In]()> ByVal MASK As Integer(), _
    <Out()> ByVal PERM As Integer(), _
    <Out()> ByVal INFO As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F11ZAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByVal DUP As string, _
    ByVal ZER As string, _
    <Out()> ByVal ISTR As Integer(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal DUPLength As long, _
    ByVal ZERLength As long _
    )


   Declare Sub F11ZBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByVal DUP As string, _
    ByVal ZER As string, _
    <Out()> ByVal ISTR As Integer(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal DUPLength As long, _
    ByVal ZERLength As long _
    )


   Declare Sub F11ZCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    <[In](),Out()> ByVal ISTC As Integer(), _
    ByRef STORE As Integer, _
    ByVal DUP As string, _
    ByVal ZER As string, _
    ByRef IFAIL As Integer, _
    ByVal DUPLength As long, _
    ByVal ZERLength As long _
    )


   Declare Sub F11ZNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Complex(), _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByVal DUP As string, _
    ByVal ZER As string, _
    <Out()> ByVal ISTR As Integer(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal DUPLength As long, _
    ByVal ZERLength As long _
    )


   Declare Sub F11ZPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NNZ As Integer, _
    <[In](),Out()> ByVal A As Complex(), _
    <[In](),Out()> ByVal IROW As Integer(), _
    <[In](),Out()> ByVal ICOL As Integer(), _
    ByVal DUP As string, _
    ByVal ZER As string, _
    <Out()> ByVal ISTR As Integer(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal DUPLength As long, _
    ByVal ZERLength As long _
    )


' chapter f12

   Declare Sub F12AAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    <Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12ABF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal MX As Double(), _
    ByRef NSHIFT As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12ACF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCONV As Integer, _
    <Out()> ByVal DR As Double(), _
    <Out()> ByVal DI As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef SIGMAR As Double, _
    ByRef SIGMAI As Double, _
    <[In]()> ByVal RESID As Double(), _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12ADF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STRLength As long _
    )


   Declare Sub F12AEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NITER As Integer, _
    ByRef NCONV As Integer, _
    <Out()> ByVal RITZR As Double(), _
    <Out()> ByVal RITZI As Double(), _
    <Out()> ByVal RZEST As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    <[In]()> ByVal COMM As Double() _
   )


   Declare Sub F12AFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    <Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12AGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal MB As Double(,), _
    ByRef LDMB As Integer, _
    ByRef SIGMAR As Double, _
    ByRef SIGMAI As Double, _
    ByRef NCONV As Integer, _
    <Out()> ByVal DR As Double(), _
    <Out()> ByVal DI As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12ANF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    <Out()> ByVal COMM As Complex(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12APF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal RESID As Complex(), _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal X As Complex(), _
    <[In](),Out()> ByVal MX As Complex(), _
    ByRef NSHIFT As Integer, _
    <[In](),Out()> ByVal COMM As Complex(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12AQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCONV As Integer, _
    <Out()> ByVal D As Complex(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef SIGMA As Complex, _
    <[In]()> ByVal RESID As Complex(), _
    <[In](),Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal COMM As Complex(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12ARF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    <[In](),Out()> ByVal COMM As Complex(), _
    ByRef IFAIL As Integer, _
    ByVal STRLength As long _
    )


   Declare Sub F12ASF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NITER As Integer, _
    ByRef NCONV As Integer, _
    <Out()> ByVal RITZ As Complex(), _
    <Out()> ByVal RZEST As Complex(), _
    <[In]()> ByVal ICOMM As Integer(), _
    <[In]()> ByVal COMM As Complex() _
   )


   Declare Sub F12ATF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    <Out()> ByVal COMM As Complex(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12AUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal MB As Complex(,), _
    ByRef LDMB As Integer, _
    ByRef SIGMA As Complex, _
    ByRef NCONV As Integer, _
    <Out()> ByVal D As Complex(), _
    <Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    <[In](),Out()> ByVal RESID As Complex(), _
    <Out()> ByVal V As Complex(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal COMM As Complex(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12FAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    <Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12FBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IREVCM As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal X As Double(), _
    <[In](),Out()> ByVal MX As Double(), _
    ByRef NSHIFT As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12FCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NCONV As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef SIGMA As Double, _
    <[In]()> ByVal RESID As Double(), _
    <[In](),Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12FDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal STR As string, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    <[In](),Out()> ByVal COMM As Double(), _
    ByRef IFAIL As Integer, _
    ByVal STRLength As long _
    )


   Declare Sub F12FEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NITER As Integer, _
    ByRef NCONV As Integer, _
    <Out()> ByVal RITZ As Double(), _
    <Out()> ByVal RZEST As Double(), _
    <[In]()> ByVal ICOMM As Integer(), _
    <[In]()> ByVal COMM As Double() _
   )


   Declare Sub F12FFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef NEV As Integer, _
    ByRef NCV As Integer, _
    <Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    <Out()> ByVal COMM As Double(), _
    ByRef LCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12FGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer, _
    <[In]()> ByVal MB As Double(,), _
    ByRef LDMB As Integer, _
    ByRef SIGMA As Double, _
    ByRef NCONV As Integer, _
    <Out()> ByVal D As Double(), _
    <Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    <Out()> ByVal V As Double(,), _
    ByRef LDV As Integer, _
    <[In](),Out()> ByVal COMM As Double(), _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByVal STR As string, _
    ByRef IFAIL As Integer, _
    ByVal STRLength As long _
    )


   Declare Sub F12JEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef EMIN As Double, _
    ByRef EMAX As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef EMID As Complex, _
    ByRef R As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef CCN As Integer, _
    <[In]()> ByVal NEDGE As Integer(), _
    <[In]()> ByVal TEDGE As Integer(), _
    <[In]()> ByVal ZEDGE As Complex(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef ZE As Complex, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef M0 As Integer, _
    ByRef NCONV As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef EPS As Double, _
    ByRef ITER As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef ZE As Complex, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef M0 As Integer, _
    ByRef NCONV As Integer, _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal Z As Double(,), _
    ByRef LDZ As Integer, _
    ByRef EPS As Double, _
    ByRef ITER As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef ZE As Complex, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef M0 As Integer, _
    ByRef NCONV As Integer, _
    <[In](),Out()> ByVal D As Double(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef EPS As Double, _
    ByRef ITER As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef ZE As Complex, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef M0 As Integer, _
    ByRef NCONV As Integer, _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef EPS As Double, _
    ByRef ITER As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef ZE As Complex, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef M0 As Integer, _
    ByRef NCONV As Integer, _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef EPS As Double, _
    ByRef ITER As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef DEG As Integer, _
    ByRef ZE As Complex, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef K As Integer, _
    ByRef M0 As Integer, _
    ByRef NCONV As Integer, _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef EPS As Double, _
    ByRef ITER As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JVF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IREVCM As Integer, _
    ByRef DEG As Integer, _
    ByRef ZE As Complex, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal X As Complex(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal Y As Complex(,), _
    ByRef LDY As Integer, _
    ByRef K As Integer, _
    ByRef M0 As Integer, _
    ByRef NCONV As Integer, _
    <[In](),Out()> ByVal D As Complex(), _
    <[In](),Out()> ByVal Z As Complex(,), _
    ByRef LDZ As Integer, _
    ByRef EPS As Double, _
    ByRef ITER As Integer, _
    <[In](),Out()> ByVal RESID As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub F12JZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef HANDLE As IntPtr, _
    ByRef IFAIL As Integer _
   )


' chapter f16

   Declare Function F16DLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Integer(), _
    ByRef INCX As Integer _
   ) as Integer


   Declare Sub F16DNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Integer(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef I As Integer _
   )


   Declare Sub F16DPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Integer(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef I As Integer _
   )


   Declare Sub F16DQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Integer(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef I As Integer _
   )


   Declare Sub F16DRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Integer(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef I As Integer _
   )


   Declare Sub BLAS_DDOT Lib "NLW6I31DE_nag.dll" ( _
    ByRef CONJ As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByRef R As Double _
   )

   Declare Sub F16EAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef CONJ As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    ByRef R As Double _
   )


   Declare Sub BLAS_DAXPBY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )

   Declare Sub F16ECF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In](),Out()> ByVal Y As Double(), _
    ByRef INCY As Integer _
   )


   Declare Sub BLAS_DWAXPBY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal W As Double(), _
    ByRef INCW As Integer _
   )

   Declare Sub F16EHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef BETA As Double, _
    <[In]()> ByVal Y As Double(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal W As Double(), _
    ByRef INCW As Integer _
   )


   Declare Function BLAS_DSUM Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Double

   Declare Function F16ELF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer _
   ) as Double


   Declare Sub BLAS_ZAXPBY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )

   Declare Sub F16GCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In](),Out()> ByVal Y As Complex(), _
    ByRef INCY As Integer _
   )


   Declare Sub BLAS_ZWAXPBY Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal W As Complex(), _
    ByRef INCW As Integer _
   )

   Declare Sub F16GHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef ALPHA As Complex, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef BETA As Complex, _
    <[In]()> ByVal Y As Complex(), _
    ByRef INCY As Integer, _
    <[In](),Out()> ByVal W As Complex(), _
    ByRef INCW As Integer _
   )


   Declare Function BLAS_ZSUM Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Complex

   Declare Function F16GLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer _
   ) as Complex


   Declare Sub BLAS_DMAX_VAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )

   Declare Sub F16JNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )


   Declare Sub BLAS_DMIN_VAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )

   Declare Sub F16JPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )


   Declare Sub BLAS_DAMAX_VAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )

   Declare Sub F16JQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )


   Declare Sub BLAS_DAMIN_VAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )

   Declare Sub F16JRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )


   Declare Sub BLAS_ZAMAX_VAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )

   Declare Sub F16JSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )


   Declare Sub BLAS_ZAMIN_VAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )

   Declare Sub F16JTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Complex(), _
    ByRef INCX As Integer, _
    ByRef K As Integer, _
    ByRef R As Double _
   )


   Declare Function F16RBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef INORM As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Double(,), _
    ByRef LDAB As Integer _
   ) as Double


   Declare Function F16UBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef INORM As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    ByRef KL As Integer, _
    ByRef KU As Integer, _
    <[In]()> ByVal AB As Complex(,), _
    ByRef LDAB As Integer _
   ) as Double


' chapter g01

   Declare Sub G01ABF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X1 As Double(), _
    <[In]()> ByVal X2 As Double(), _
    ByRef IWT As Integer, _
    <[In](),Out()> ByVal WT As Double(), _
    <Out()> ByVal RES As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01ADF Lib "NLW6I31DE_nag.dll" ( _
    ByRef K As Integer, _
    <[In]()> ByVal X As Double(), _
    <[In]()> ByVal IFREQ As Integer(), _
    ByRef XMEAN As Double, _
    ByRef S2 As Double, _
    ByRef S3 As Double, _
    ByRef S4 As Double, _
    ByRef N As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01AEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef K As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef ICLASS As Integer, _
    <[In](),Out()> ByVal CB As Double(), _
    <Out()> ByVal IFREQ As Integer(), _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01AFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LDNOB As Integer, _
    ByRef LDPRED As Integer, _
    ByRef M As Integer, _
    ByRef N As Integer, _
    <[In](),Out()> ByVal NOBS As Integer(,), _
    ByRef NUM As Integer, _
    <Out()> ByVal PRED As Double(,), _
    ByRef CHIS As Double, _
    <Out()> ByVal P As Double(), _
    ByRef NPOS As Integer, _
    ByRef NDF As Integer, _
    ByRef M1 As Integer, _
    ByRef N1 As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01ALF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal IWRK As Integer(), _
    <Out()> ByVal RES As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01AMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <[In](),Out()> ByVal RV As Double(), _
    ByRef NQ As Integer, _
    <[In]()> ByVal Q As Double(), _
    <Out()> ByVal QV As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01ANF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IND As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal RV As Double(), _
    ByRef NB As Integer, _
    ByRef EPS As Double, _
    ByRef NP As Integer, _
    <[In]()> ByVal Q As Double(), _
    <Out()> ByVal QV As Double(), _
    ByRef NQ As Integer, _
    <[In](),Out()> ByVal RCOMM As Double(), _
    ByRef LRCOMM As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01APF Lib "NLW6I31DE_nag.dll" ( _
    ByRef IND As Integer, _
    <[In]()> ByVal RV As Double(), _
    ByRef NB As Integer, _
    ByRef EPS As Double, _
    ByRef NP As Integer, _
    <[In]()> ByVal Q As Double(), _
    <Out()> ByVal QV As Double(), _
    ByRef NQ As Integer, _
    <[In](),Out()> ByVal RCOMM As Double(), _
    ByRef LRCOMM As Integer, _
    <[In](),Out()> ByVal ICOMM As Integer(), _
    ByRef LICOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01ARF Lib "NLW6I31DE_nag.dll" ( _
    ByVal RANGE As string, _
    ByVal PRT As string, _
    ByRef N As Integer, _
    <[In]()> ByVal Y As Double(), _
    ByRef NSTEPX As Integer, _
    ByRef NSTEPY As Integer, _
    ByRef UNIT As Double, _
    ByVal PLOT As string, _
    ByRef LDPLOT As Integer, _
    ByRef LINES As Integer, _
    <Out()> ByVal SORTY As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal RANGELength As long, _
    ByVal PRTLength As long, _
    ByVal PLOTLength As long _
    )


   Declare Sub G01ASF Lib "NLW6I31DE_nag.dll" ( _
    ByVal PRT As string, _
    ByRef M As Integer, _
    <[In]()> ByVal N As Integer(), _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef NSTEPX As Integer, _
    ByRef NSTEPY As Integer, _
    ByVal PLOT As string, _
    ByRef LDPLOT As Integer, _
    <Out()> ByVal FIVEPT As Double(), _
    <Out()> ByVal IWORK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal PRTLength As long, _
    ByVal PLOTLength As long _
    )


   Declare Sub G01ATF Lib "NLW6I31DE_nag.dll" ( _
    ByRef NB As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef IWT As Integer, _
    <[In]()> ByVal WT As Double(), _
    ByRef PN As Integer, _
    ByRef XMEAN As Double, _
    ByRef XSD As Double, _
    ByRef XSKEW As Double, _
    ByRef XKURT As Double, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    <[In](),Out()> ByVal RCOMM As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01AUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef B As Integer, _
    <[In]()> ByVal MRCOMM As Double(,), _
    ByRef PN As Integer, _
    ByRef XMEAN As Double, _
    ByRef XSD As Double, _
    ByRef XSKEW As Double, _
    ByRef XKURT As Double, _
    ByRef XMIN As Double, _
    ByRef XMAX As Double, _
    <Out()> ByVal RCOMM As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01BJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef P As Double, _
    ByRef K As Integer, _
    ByRef PLEK As Double, _
    ByRef PGTK As Double, _
    ByRef PEQK As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01BKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef RLAMDA As Double, _
    ByRef K As Integer, _
    ByRef PLEK As Double, _
    ByRef PGTK As Double, _
    ByRef PEQK As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01BLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef L As Integer, _
    ByRef M As Integer, _
    ByRef K As Integer, _
    ByRef PLEK As Double, _
    ByRef PGTK As Double, _
    ByRef PEQK As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01DAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <Out()> ByVal PP As Double(), _
    ByRef ETOL As Double, _
    ByRef ERREST As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef IW As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01DBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    <Out()> ByVal PP As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01DCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef EXP1 As Double, _
    ByRef EXP2 As Double, _
    ByRef SUMSSQ As Double, _
    <Out()> ByVal VEC As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01DDF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal X As Double(), _
    ByRef N As Integer, _
    ByRef CALWTS As Integer, _
    <[In](),Out()> ByVal A As Double(), _
    ByRef W As Double, _
    ByRef PW As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01DHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal SCORES As string, _
    ByVal TIES As string, _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(), _
    <Out()> ByVal R As Double(), _
    <Out()> ByVal IWRK As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal SCORESLength As long, _
    ByVal TIESLength As long _
    )


   Declare Function G01EAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef X As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01EBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef T As Double, _
    ByRef DF As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01ECF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef X As Double, _
    ByRef DF As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01EDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef F As Double, _
    ByRef DF1 As Double, _
    ByRef DF2 As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Sub G01EEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef TOL As Double, _
    ByRef P As Double, _
    ByRef Q As Double, _
    ByRef PDF As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Function G01EFF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef G As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01EMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef Q As Double, _
    ByRef V As Double, _
    ByRef IR As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Sub G01EPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef IP As Integer, _
    ByRef D As Double, _
    ByRef PDL As Double, _
    ByRef PDU As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Function G01ERF Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Double, _
    ByRef VK As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01ETF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double _
   ) as Double


   Declare Function G01EUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    <[In]()> ByVal RCOMM As Double(), _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01EWF Lib "NLW6I31DE_nag.dll" ( _
    ByRef METHOD As Integer, _
    ByRef TYP As Integer, _
    ByRef N As Integer, _
    ByRef TS As Double, _
    ByRef NSAMP As Integer, _
    <[In](),Out()> ByVal STATE As Integer(), _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01EYF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef D As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01EZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N1 As Integer, _
    ByRef N2 As Integer, _
    ByRef D As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01FAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef P As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01FBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef P As Double, _
    ByRef DF As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01FCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef P As Double, _
    ByRef DF As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01FDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef P As Double, _
    ByRef DF1 As Double, _
    ByRef DF2 As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01FEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef P As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef TOL As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01FFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef P As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef TOL As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01FMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef P As Double, _
    ByRef V As Double, _
    ByRef IR As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01FTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01GBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef T As Double, _
    ByRef DF As Double, _
    ByRef DELTA As Double, _
    ByRef TOL As Double, _
    ByRef MAXIT As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01GCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef DF As Double, _
    ByRef RLAMDA As Double, _
    ByRef TOL As Double, _
    ByRef MAXIT As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01GDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef F As Double, _
    ByRef DF1 As Double, _
    ByRef DF2 As Double, _
    ByRef RLAMDA As Double, _
    ByRef TOL As Double, _
    ByRef MAXIT As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01GEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef RLAMDA As Double, _
    ByRef TOL As Double, _
    ByRef MAXIT As Integer, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01HAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef Y As Double, _
    ByRef RHO As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01HBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(), _
    <[In]()> ByVal XMU As Double(), _
    <[In]()> ByVal SIG As Double(,), _
    ByRef LDSIG As Integer, _
    ByRef TOL As Double, _
    <Out()> ByVal WK As Double(), _
    ByRef LWK As Integer, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01HCF Lib "NLW6I31DE_nag.dll" ( _
    ByVal TAIL As string, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(), _
    ByRef DF As Integer, _
    ByRef RHO As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Function G01HDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByVal TAIL As string, _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal B As Double(), _
    ByRef NU As Double, _
    <[In]()> ByVal DELTA As Double(), _
    ByRef ISCOV As Integer, _
    <[In](),Out()> ByVal RC As Double(,), _
    ByRef LDRC As Integer, _
    ByRef EPSABS As Double, _
    ByRef EPSREL As Double, _
    ByRef NUMSUB As Integer, _
    ByRef NSAMPL As Integer, _
    ByRef FMAX As Integer, _
    ByRef ERREST As Double, _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    ) as Double


   Declare Sub G01JCF Lib "NLW6I31DE_nag.dll" ( _
    <[In]()> ByVal A As Double(), _
    <[In]()> ByVal MULT As Integer(), _
    <[In]()> ByVal RLAMDA As Double(), _
    ByRef N As Integer, _
    ByRef C As Double, _
    ByRef P As Double, _
    ByRef PDF As Double, _
    ByRef TOL As Double, _
    ByRef MAXIT As Integer, _
    <Out()> ByVal WRK As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01JDF Lib "NLW6I31DE_nag.dll" ( _
    ByVal METHOD As string, _
    ByRef N As Integer, _
    <[In]()> ByVal RLAM As Double(), _
    ByRef D As Double, _
    ByRef C As Double, _
    ByRef PROB As Double, _
    <Out()> ByVal WORK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal METHODLength As long _
    )


   Declare Function G01KAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef XMEAN As Double, _
    ByRef XSTD As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Function G01KFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    ByRef A As Double, _
    ByRef B As Double, _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Sub G01KKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ILOG As Integer, _
    ByRef LX As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LB As Integer, _
    <[In]()> ByVal B As Double(), _
    <Out()> ByVal PDF As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01KQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ILOG As Integer, _
    ByRef LX As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef LXMU As Integer, _
    <[In]()> ByVal XMU As Double(), _
    ByRef LXSTD As Integer, _
    <[In]()> ByVal XSTD As Double(), _
    <Out()> ByVal PDF As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01LBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef ILOG As Integer, _
    ByRef K As Integer, _
    ByRef N As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal XMU As Double(), _
    ByRef IULD As Integer, _
    <[In]()> ByVal SIG As Double(,), _
    ByRef LDSIG As Integer, _
    <Out()> ByVal PDF As Double(), _
    ByRef RANK As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Function G01MBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double _
   ) as Double


   Declare Function G01MTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double _
   ) as Double


   Declare Function G01MUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double, _
    <[In]()> ByVal RCOMM As Double(), _
    ByRef IFAIL As Integer _
   ) as Double


   Declare Sub G01NAF Lib "NLW6I31DE_nag.dll" ( _
    ByVal MOM As string, _
    ByVal MEAN As string, _
    ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), _
    ByRef LDA As Integer, _
    <[In]()> ByVal EMU As Double(), _
    <[In]()> ByVal SIGMA As Double(,), _
    ByRef LDSIG As Integer, _
    ByRef L As Integer, _
    <Out()> ByVal RKUM As Double(), _
    <Out()> ByVal RMOM As Double(), _
    <Out()> ByVal WK As Double(), _
    ByRef IFAIL As Integer, _
    ByVal MOMLength As long, _
    ByVal MEANLength As long _
    )


   Declare Sub G01NBF Lib "NLW6I31DE_nag.dll" ( _
    ByVal CAS As string, ByVal MEAN As string, ByRef N As Integer, _
    <[In]()> ByVal A As Double(,), ByRef LDA As Integer, <[In]()> ByVal B As Double(,), _
    ByRef LDB As Integer, <[In]()> ByVal C As Double(,), ByRef LDC As Integer, _
    <[In]()> ByVal ELA As Double(), <[In]()> ByVal EMU As Double(), <[In]()> ByVal SIGMA As Double(,), _
    ByRef LDSIG As Integer, ByRef L1 As Integer, ByRef L2 As Integer, _
    ByRef LMAX As Integer, <Out()> ByVal RMOM As Double(), ByRef ABSERR As Double, _
    ByRef EPS As Double, <Out()> ByVal WK As Double(), ByRef IFAIL As Integer, _
    ByVal CASLength As long, _
    ByVal MEANLength As long _
    )


   Declare Function G01PTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double _
   ) as Double


   Declare Function G01QTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double _
   ) as Double


   Declare Function G01RTF Lib "NLW6I31DE_nag.dll" ( _
    ByRef X As Double _
   ) as Double


   Declare Sub G01SAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LX As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef LXMU As Integer, _
    <[In]()> ByVal XMU As Double(), _
    ByRef LXSTD As Integer, _
    <[In]()> ByVal XSTD As Double(), _
    <Out()> ByVal P As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01SBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LT As Integer, _
    <[In]()> ByVal T As Double(), _
    ByRef LDF As Integer, _
    <[In]()> ByVal DF As Double(), _
    <Out()> ByVal P As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01SCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LX As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef LDF As Integer, _
    <[In]()> ByVal DF As Double(), _
    <Out()> ByVal P As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01SDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LF As Integer, _
    <[In]()> ByVal F As Double(), _
    ByRef LDF1 As Integer, _
    <[In]()> ByVal DF1 As Double(), _
    ByRef LDF2 As Integer, _
    <[In]()> ByVal DF2 As Double(), _
    <Out()> ByVal P As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01SEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LBETA As Integer, _
    <[In]()> ByVal BETA As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LB As Integer, _
    <[In]()> ByVal B As Double(), _
    <Out()> ByVal P As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01SFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LG As Integer, _
    <[In]()> ByVal G As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LB As Integer, _
    <[In]()> ByVal B As Double(), _
    <Out()> ByVal P As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01SJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LN As Integer, _
    <[In]()> ByVal N As Integer(), _
    ByRef LP As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef LK As Integer, _
    <[In]()> ByVal K As Integer(), _
    <Out()> ByVal PLEK As Double(), _
    <Out()> ByVal PGTK As Double(), _
    <Out()> ByVal PEQK As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01SKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LL As Integer, _
    <[In]()> ByVal L As Double(), _
    ByRef LK As Integer, _
    <[In]()> ByVal K As Integer(), _
    <Out()> ByVal PLEK As Double(), _
    <Out()> ByVal PGTK As Double(), _
    <Out()> ByVal PEQK As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01SLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LN As Integer, _
    <[In]()> ByVal N As Integer(), _
    ByRef LL As Integer, _
    <[In]()> ByVal L As Integer(), _
    ByRef LM As Integer, _
    <[In]()> ByVal M As Integer(), _
    ByRef LK As Integer, _
    <[In]()> ByVal K As Integer(), _
    <Out()> ByVal PLEK As Double(), _
    <Out()> ByVal PGTK As Double(), _
    <Out()> ByVal PEQK As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01TAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LP As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef LXMU As Integer, _
    <[In]()> ByVal XMU As Double(), _
    ByRef LXSTD As Integer, _
    <[In]()> ByVal XSTD As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01TBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LP As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef LDF As Integer, _
    <[In]()> ByVal DF As Double(), _
    <Out()> ByVal T As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01TCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LP As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef LDF As Integer, _
    <[In]()> ByVal DF As Double(), _
    <Out()> ByVal X As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01TDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LP As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef LDF1 As Integer, _
    <[In]()> ByVal DF1 As Double(), _
    ByRef LDF2 As Integer, _
    <[In]()> ByVal DF2 As Double(), _
    <Out()> ByVal F As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01TEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LP As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LB As Integer, _
    <[In]()> ByVal B As Double(), _
    ByRef TOL As Double, _
    <Out()> ByVal BETA As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01TFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef LTAIL As Integer, _
    ByVal TAIL As string, _
    ByRef LP As Integer, _
    <[In]()> ByVal P As Double(), _
    ByRef LA As Integer, _
    <[In]()> ByVal A As Double(), _
    ByRef LB As Integer, _
    <[In]()> ByVal B As Double(), _
    ByRef TOL As Double, _
    <Out()> ByVal G As Double(), _
    <Out()> ByVal IVALID As Integer(), _
    ByRef IFAIL As Integer, _
    ByVal TAILLength As long _
    )


   Declare Sub G01WAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef M As Integer, _
    ByRef NB As Integer, _
    <[In]()> ByVal X As Double(), _
    ByRef IWT As Integer, _
    <[In]()> ByVal WT As Double(), _
    ByRef PN As Integer, _
    <Out()> ByVal RMEAN As Double(), _
    <Out()> ByVal RSD As Double(), _
    ByRef LRSD As Integer, _
    <[In](),Out()> ByVal RCOMM As Double(), _
    ByRef LRCOMM As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G01ZUF Lib "NLW6I31DE_nag.dll" ( _
    ByRef RKAPPA As Double, _
    ByRef BETA2 As Double, _
    ByRef MODE As Integer, _
    ByRef XL As Double, _
    ByRef XU As Double, _
    <Out()> ByVal RCOMM As Double(), _
    ByRef IFAIL As Integer _
   )


' chapter g02

   Declare Sub G02AAF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByRef ERRTOL As Double, _
    ByRef MAXITS As Integer, _
    ByRef MAXIT As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ITER As Integer, _
    ByRef FEVAL As Integer, _
    ByRef NRMGRD As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02ABF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByVal OPT As string, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal W As Double(), _
    ByRef ERRTOL As Double, _
    ByRef MAXITS As Integer, _
    ByRef MAXIT As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ITER As Integer, _
    ByRef FEVAL As Integer, _
    ByRef NRMGRD As Double, _
    ByRef IFAIL As Integer, _
    ByVal OPTLength As long _
    )


   Declare Sub G02AEF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ERRTOL As Double, _
    ByRef MAXIT As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ITER As Integer, _
    ByRef FEVAL As Integer, _
    ByRef NRMPGD As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02AJF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In](),Out()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    ByRef ERRTOL As Double, _
    ByRef MAXIT As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ITER As Integer, _
    ByRef NORM As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02AKF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByRef RANK As Integer, _
    ByRef ERRTOL As Double, _
    ByRef RANKTOL As Double, _
    ByRef MAXITS As Integer, _
    ByRef MAXIT As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef F As Double, _
    ByRef RANKERR As Double, _
    ByRef NSUB As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02ANF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByRef K As Integer, _
    ByRef ERRTOL As Double, _
    ByRef EIGTOL As Double, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ALPHA As Double, _
    ByRef ITER As Integer, _
    ByRef EIGMIN As Double, _
    ByRef NORM As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02APF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByRef THETA As Double, _
    <[In](),Out()> ByVal H As Double(,), _
    ByRef LDH As Integer, _
    ByRef ERRTOL As Double, _
    ByRef EIGTOL As Double, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ALPHA As Double, _
    ByRef ITER As Integer, _
    ByRef EIGMIN As Double, _
    ByRef NORM As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02ASF Lib "NLW6I31DE_nag.dll" ( _
    <[In](),Out()> ByVal G As Double(,), _
    ByRef LDG As Integer, _
    ByRef N As Integer, _
    ByRef ALPHA As Double, _
    <[In]()> ByVal H As Integer(,), _
    ByRef LDH As Integer, _
    ByRef ERRTOL As Double, _
    ByRef MAXIT As Integer, _
    ByRef M As Integer, _
    <Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ITS As Integer, _
    ByRef FNORM As Double, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BAF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSP As Double(,), _
    ByRef LDSSP As Integer, _
    <Out()> ByVal R As Double(,), _
    ByRef LDR As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BBF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal MISS As Integer(), _
    <[In](),Out()> ByVal XMISS As Double(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSP As Double(,), _
    ByRef LDSSP As Integer, _
    <Out()> ByVal R As Double(,), _
    ByRef LDR As Integer, _
    ByRef NCASES As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BCF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal MISS As Integer(), _
    <[In]()> ByVal XMISS As Double(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSP As Double(,), _
    ByRef LDSSP As Integer, _
    <Out()> ByVal R As Double(,), _
    ByRef LDR As Integer, _
    ByRef NCASES As Integer, _
    <Out()> ByVal CNT As Double(,), _
    ByRef LDCNT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BDF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSPZ As Double(,), _
    ByRef LDSSPZ As Integer, _
    <Out()> ByVal RZ As Double(,), _
    ByRef LDRZ As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BEF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal MISS As Integer(), _
    <[In](),Out()> ByVal XMISS As Double(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSPZ As Double(,), _
    ByRef LDSSPZ As Integer, _
    <Out()> ByVal RZ As Double(,), _
    ByRef LDRZ As Integer, _
    ByRef NCASES As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BFF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal MISS As Integer(), _
    <[In]()> ByVal XMISS As Double(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSPZ As Double(,), _
    ByRef LDSSPZ As Integer, _
    <Out()> ByVal RZ As Double(,), _
    ByRef LDRZ As Integer, _
    ByRef NCASES As Integer, _
    <Out()> ByVal CNT As Double(,), _
    ByRef LDCNT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BGF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef NVARS As Integer, _
    <[In]()> ByVal KVAR As Integer(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSP As Double(,), _
    ByRef LDSSP As Integer, _
    <Out()> ByVal R As Double(,), _
    ByRef LDR As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BHF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal MISS As Integer(), _
    <[In](),Out()> ByVal XMISS As Double(), _
    ByRef MISTYP As Integer, _
    ByRef NVARS As Integer, _
    <[In]()> ByVal KVAR As Integer(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSP As Double(,), _
    ByRef LDSSP As Integer, _
    <Out()> ByVal R As Double(,), _
    ByRef LDR As Integer, _
    ByRef NCASES As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BJF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal MISS As Integer(), _
    <[In]()> ByVal XMISS As Double(), _
    ByRef NVARS As Integer, _
    <[In]()> ByVal KVAR As Integer(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSP As Double(,), _
    ByRef LDSSP As Integer, _
    <Out()> ByVal R As Double(,), _
    ByRef LDR As Integer, _
    ByRef NCASES As Integer, _
    <Out()> ByVal CNT As Double(,), _
    ByRef LDCNT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BKF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef NVARS As Integer, _
    <[In]()> ByVal KVAR As Integer(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSPZ As Double(,), _
    ByRef LDSSPZ As Integer, _
    <Out()> ByVal RZ As Double(,), _
    ByRef LDRZ As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal MISS As Integer(), _
    <[In](),Out()> ByVal XMISS As Double(), _
    ByRef MISTYP As Integer, _
    ByRef NVARS As Integer, _
    <[In]()> ByVal KVAR As Integer(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSPZ As Double(,), _
    ByRef LDSSPZ As Integer, _
    <Out()> ByVal RZ As Double(,), _
    ByRef LDRZ As Integer, _
    ByRef NCASES As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BMF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal MISS As Integer(), _
    <[In]()> ByVal XMISS As Double(), _
    ByRef NVARS As Integer, _
    <[In]()> ByVal KVAR As Integer(), _
    <Out()> ByVal XBAR As Double(), _
    <Out()> ByVal STD As Double(), _
    <Out()> ByVal SSPZ As Double(,), _
    ByRef LDSSPZ As Integer, _
    <Out()> ByVal RZ As Double(,), _
    ByRef LDRZ As Integer, _
    ByRef NCASES As Integer, _
    <Out()> ByVal CNT As Double(,), _
    ByRef LDCNT As Integer, _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BNF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ITYPE As Integer, _
    <Out()> ByVal RR As Double(,), _
    ByRef LDRR As Integer, _
    <Out()> ByVal KWORKA As Integer(), _
    <Out()> ByVal KWORKB As Integer(), _
    <Out()> ByVal WORK1 As Double(), _
    <Out()> ByVal WORK2 As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In](),Out()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal MISS As Integer(), _
    <[In](),Out()> ByVal XMISS As Double(), _
    ByRef ITYPE As Integer, _
    <Out()> ByVal RR As Double(,), _
    ByRef LDRR As Integer, _
    ByRef NCASES As Integer, _
    <Out()> ByVal INCASE As Integer(), _
    <Out()> ByVal KWORKA As Integer(), _
    <Out()> ByVal KWORKB As Integer(), _
    <Out()> ByVal KWORKC As Integer(), _
    <Out()> ByVal WORK1 As Double(), _
    <Out()> ByVal WORK2 As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    ByRef ITYPE As Integer, _
    <Out()> ByVal RR As Double(,), _
    ByRef LDRR As Integer, _
    <Out()> ByVal KWORKA As Integer(), _
    <Out()> ByVal KWORKB As Integer(), _
    <Out()> ByVal WORK1 As Double(), _
    <Out()> ByVal WORK2 As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In](),Out()> ByVal MISS As Integer(), _
    <[In](),Out()> ByVal XMISS As Double(), _
    ByRef ITYPE As Integer, _
    <Out()> ByVal RR As Double(,), _
    ByRef LDRR As Integer, _
    ByRef NCASES As Integer, _
    <Out()> ByVal INCASE As Integer(), _
    <Out()> ByVal KWORKA As Integer(), _
    <Out()> ByVal KWORKB As Integer(), _
    <Out()> ByVal KWORKC As Integer(), _
    <Out()> ByVal WORK1 As Double(), _
    <Out()> ByVal WORK2 As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BSF Lib "NLW6I31DE_nag.dll" ( _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal MISS As Integer(), _
    <[In]()> ByVal XMISS As Double(), _
    ByRef ITYPE As Integer, _
    <Out()> ByVal RR As Double(,), _
    ByRef LDRR As Integer, _
    ByRef NCASES As Integer, _
    <Out()> ByVal CNT As Double(,), _
    ByRef LDCNT As Integer, _
    <Out()> ByVal KWORKA As Integer(), _
    <Out()> ByVal KWORKB As Integer(), _
    <Out()> ByVal KWORKC As Integer(), _
    <Out()> ByVal KWORKD As Integer(), _
    <Out()> ByVal WORK1 As Double(), _
    <Out()> ByVal WORK2 As Double(), _
    ByRef IFAIL As Integer _
   )


   Declare Sub G02BTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal MEAN As string, _
    ByRef M As Integer, _
    ByRef WT As Double, _
    <[In]()> ByVal X As Double(), _
    ByRef INCX As Integer, _
    ByRef SW As Double, _
    <[In](),Out()> ByVal XBAR As Double(), _
    <[In](),Out()> ByVal C As Double(), _
    ByRef IFAIL As Integer, _
    ByVal MEANLength As long _
    )


   Declare Sub G02BUF Lib "NLW6I31DE_nag.dll" ( _
    ByVal MEAN As string, _
    ByVal WEIGHT As string, _
    ByRef N As Integer, _
    ByRef M As Integer, _
    <[In]()> ByVal X As Double(,), _
    ByRef LDX As Integer, _
    <[In]()> ByVal WT As Double(), _
    ByRef SW As Double, _
    <Out()> ByVal WMEAN As Double(), _
    <Out()> ByVal C As Double(), _
    ByRef IFAIL As Integer, _
   