' Linear algrebra and other miscellaneous examples

Option Explicit On 
Imports System.Math
Imports System.Text
Imports System.Runtime.InteropServices
Imports Microsoft.VisualBasic

Module Module1

    Const NAGTRUE As Integer = -1
    Const NAGFALSE As Integer = 0


    Sub F08FAFE()
        Const N As Integer = 4
        Const LWORK As Integer = 64 * N
        'Remember array indices start at 0
        Dim A(N - 1, N - 1) As Double, w(N - 1) As Double, work(LWORK - 1) As Double
        Dim info As Integer
        Dim strResult As New StringBuilder
        'Remember in general arrays need transposing, we can just change UPLO
        A(0, 0) = 4.16
        A(1, 0) = -3.12
        A(1, 1) = 5.03
        A(2, 0) = 0.56
        A(2, 1) = -0.83
        A(2, 2) = 0.76
        A(3, 0) = -0.1
        A(3, 1) = 1.18
        A(3, 2) = 0.34
        A(3, 3) = 1.18

        Call F08FAF("V", "U", N, A, N, w, work, LWORK, info, 1, 1)

        If info <> 0 Then
            strResult.Append("Error - info = " & info.ToString)
        Else
            strResult.Append("F08FAF Example Results" & vbCrLf)
            strResult.Append(vbCrLf & "Eigenvalues" & vbCrLf)
            strResult.Append(Format(w(0), "###0.0000"))
            strResult.Append(vbCrLf)
            strResult.Append(Format(w(1), "###0.0000"))
            strResult.Append(vbCrLf)
            strResult.Append(Format(w(2), "###0.0000"))
            strResult.Append(vbCrLf)
            strResult.Append(Format(w(3), "###0.0000"))
            strResult.Append(vbCrLf)

        End If

        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub

    Sub F01ADFE()
        Const N As Integer = 4, IA As Integer = N + 1
        'Remember array indices start at 0
        Dim A(N - 1, IA - 1) As Double
        Dim ifail As Integer
        Dim strResult As New StringBuilder
        'Remember in general arrays need transposing
        A(0, 0) = 5
        A(1, 0) = 7
        A(2, 0) = 6
        A(3, 0) = 5

        A(1, 1) = 10
        A(2, 1) = 8
        A(3, 1) = 7

        A(2, 2) = 10
        A(3, 2) = 9

        A(3, 3) = 10

        ifail = 1

        Call F01ADF(N, A, IA, ifail)

        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        Else
            strResult.Append("F01ADF Example Results" & vbCrLf)
            strResult.Append(vbCrLf & "Lower Triangle of Inverse" & vbCrLf)
            strResult.Append(Format(A(0, 1), "###0.00"))
            strResult.Append(vbCrLf)
            strResult.Append(Format(A(0, 2), "###0.00"))
            strResult.Append("  ")
            strResult.Append(Format(A(1, 2), "###0.00"))
            strResult.Append(vbCrLf)
            strResult.Append(Format(A(0, 3), "###0.00"))
            strResult.Append("  ")
            strResult.Append(Format(A(1, 3), "###0.00"))
            strResult.Append("  ")
            strResult.Append(Format(A(2, 3), "###0.00"))
            strResult.Append(vbCrLf)
            strResult.Append(Format(A(0, 4), "###0.00"))
            strResult.Append("  ")
            strResult.Append(Format(A(1, 4), "###0.00"))
            strResult.Append("  ")
            strResult.Append(Format(A(2, 4), "###0.00"))
            strResult.Append("  ")
            strResult.Append(Format(A(3, 4), "###0.00"))
            strResult.Append(vbCrLf)

        End If

        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub

    Sub F01CKFE()
        Const M As Integer = 2, N As Integer = 3
        'Remember array indices start at 0
        Dim A(M - 1, M - 1) As Double, B(N - 1, M - 1) As Double, C(M - 1, N - 1) As Double, Z(0) As Double
        Dim ifail As Integer
        Dim strResult As New StringBuilder

        B(0, 0) = 0.0#
        C(0, 0) = 0.0#
        B(0, 1) = 1.0#
        C(1, 0) = 1.0#

        B(1, 0) = 1.0#
        C(0, 1) = 1.0#
        B(1, 1) = 2.0#
        C(1, 1) = 2.0#

        B(2, 0) = 2.0#
        C(0, 2) = 2.0#
        B(2, 1) = 3.0#
        C(1, 2) = 3.0#

        ifail = 1
        Call F01CKF(A, B, C, M, M, N, Z, 1, 1, ifail)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        Else
            strResult.Append("F01CKF Example Results" & vbCrLf)
            strResult.Append(vbCrLf & "Resulting Matrix A" & vbCrLf)
            strResult.Append(Format(A(0, 0), "##0.0"))
            strResult.Append("  ")
            strResult.Append(Format(A(1, 0), "##0.0"))
            strResult.Append(vbCrLf)
            strResult.Append(Format(A(0, 1), "##0.0"))
            strResult.Append("  ")
            strResult.Append(Format(A(1, 1), "##0.0"))
            strResult.Append(vbCrLf)

        End If
        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub

    Sub F01CRFE()
        Const N As Integer = 7, M As Integer = 3, MN As Integer = M * N, LMOVE As Integer = (M + N) / 2
        'Remember array indices start at 0
        Dim A(MN - 1) As Double
        Dim MOVE(LMOVE - 1) As Integer
        Dim i As Integer, ifail As Integer
        Dim strResult As New StringBuilder

        For i = 0 To MN - 1
            A(i) = i + 1
        Next i

        ifail = 1

        Call F01CRF(A, M, N, MN, MOVE, LMOVE, ifail)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        Else
            strResult.Append("F01CRF Example Results" & vbCrLf)
            strResult.Append(vbCrLf & "Resulting Matrix A" & vbCrLf)

            For i = 0 To 14 Step 7
                strResult.Append(Format(A(i), "###0.0"))
                strResult.Append("  ")
                strResult.Append(Format(A(i + 1), "###0.0"))
                strResult.Append("  ")
                strResult.Append(Format(A(i + 2), "###0.0"))
                strResult.Append("  ")
                strResult.Append(Format(A(i + 3), "###0.0"))
                strResult.Append("  ")
                strResult.Append(Format(A(i + 4), "###0.0"))
                strResult.Append("  ")
                strResult.Append(Format(A(i + 5), "###0.0"))
                strResult.Append("  ")
                strResult.Append(Format(A(i + 6), "###0.0"))
                strResult.Append(vbCrLf)
            Next i
        End If
        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub


    Sub D01BDFE()
        Const A As Double = 0.0#, B As Double = 1.0#
        Dim epsabs As Double, epsrel As Double
        Dim myres As Double, abserr As Double
        Dim strResult As New StringBuilder

        epsabs = 0.0#
        epsrel = 0.0001


        Call D01BDF(AddressOf FUN, A, B, epsabs, epsrel, myres, abserr)

        strResult.Append("D01BDF Example Results" & vbCrLf)
        strResult.Append(vbCrLf & "Result of Integration" & vbCrLf)
        strResult.Append(Format(myres, "###0.00000"))
        MessageBox.Show(strResult.ToString)
        strResult = Nothing


    End Sub

    Function FUN(ByRef x As Double) As Double
        FUN = x * x * Sin(10 * PI * x)
        Exit Function
    End Function

    Sub C05AZFE()
        Dim fx As Double, tolx As Double, x As Double, y As Double
        Dim ifail As Integer, ind As Integer, ir As Integer
        'Remember array indices start at 0
        Dim c(17) As Double
        Dim strResult As New StringBuilder

        tolx = 0.00001
        x = 0.0#
        y = 1.0#
        ir = 0
        ind = 1
        ifail = 1
l20:
        Call C05AZF(x, y, fx, tolx, ir, c, ind, ifail)
        Select Case ind

            Case 0
                strResult.Append("C05AZF Example Results" & vbCrLf)
                strResult.Append(vbCrLf & "Solution" & vbCrLf)
                strResult.Append("x = " & Format(x, "##0.0000") & vbCrLf)
                strResult.Append("y = " & Format(y, "##0.0000") & vbCrLf)
                strResult.Append("fx = " & Format(fx, "E") & vbCrLf)
                strResult.Append("ifail = " & ifail.ToString & vbCrLf)

            Case 2, 3, 4
                fx = F(x)
                GoTo l20


            Case Else
                strResult.Append("C05AZF Example Results" & vbCrLf)
                strResult.Append(vbCrLf & "Failure" & vbCrLf)
                strResult.Append(vbCrLf & "x = " & x.ToString & vbCrLf)
                strResult.Append("ind = " & ind.ToString & vbCrLf)


        End Select

        MessageBox.Show(strResult.ToString)
        strResult = Nothing



    End Sub

    Function F(ByRef x As Double) As Double
        F = Exp(-x) - x
        Exit Function
    End Function


    'Examples with Strings or arrays of Strings as input and output parameters

    Sub M01CCFE()

        Dim ch(10) As String
        Dim ch_len As Integer
        Dim i As Integer, ifail As Integer, l1 As Integer, l2 As Integer, m As Integer
        Dim strResult As New StringBuilder
        Dim ch_all As String

        ch(0) = "A02AAF   289"
        ch(1) = "A02ABF   523"
        ch(2) = "A02ACF   531"
        ch(3) = "C02ADF   169"
        ch(4) = "C02AEF   599"
        ch(5) = "C05ADF  1351"
        ch(6) = "C05AGF   240"
        ch(7) = "C05AJF   136"
        ch(8) = "C05AVF   211"
        ch(9) = "C05AXF   183"
        ch(10) = "C05AZF  2181"

        m = 11
        l1 = 7
        l2 = 12
        ifail = 1

        ch_all = ""
        For i = 0 To m - 1
            ch_all = ch_all & ch(i)
        Next

        ch_len = 12

        M01CCF(ch_all, 1, m, l1, l2, "Reverse ASCII", ifail, ch_len, 13)

        For i = 0 To m - 1
            ch(i) = ch_all.Substring(i * ch_len, ch_len)
        Next

        strResult.Append("M01CCF Example Results" & vbCrLf & vbCrLf)
        strResult.Append("Records sorted on columns " & l1.ToString)
        strResult.Append(" to " & l2.ToString & vbCrLf & vbCrLf)
        For i = 0 To m - 1
            strResult.Append(ch(i).ToString & vbCrLf)
        Next
        strResult.Append(vbCrLf & "ifail on exit = " & ifail.ToString & vbCrLf)
        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub


    Sub G02BAFE()
        Dim M As Integer = 3
        Dim N As Integer = 5
        Dim IA As Integer = N
        Dim ISSP As Integer = M
        Dim ICORR As Integer = M

        Dim I As Integer
        Dim IFAIL As Integer
        Dim J As Integer

        Dim A(M - 1, IA - 1) As Double
        Dim AMEAN(M - 1) As Double
        Dim CORR(M - 1, ICORR - 1) As Double
        Dim SSP(M - 1, ISSP - 1) As Double
        Dim STD(M - 1) As Double

        Dim strResult As New StringBuilder

        'START DATA INITIALISATION
        A(0, 0) = 2.0
        A(0, 1) = 4.0
        A(0, 2) = 9.0
        A(0, 3) = 0.0
        A(0, 4) = 12.0

        A(1, 0) = 3.0
        A(1, 1) = 6.0
        A(1, 2) = 9.0
        A(1, 3) = 12.0
        A(1, 4) = -1.0

        A(2, 0) = 3.0
        A(2, 1) = 4.0
        A(2, 2) = 0.0
        A(2, 3) = 2.0
        A(2, 4) = 5.0

        'END DATA INITIALISATION

        strResult.Append("G02BAF Example Program Results" & vbCrLf)
        strResult.Append("Number of variables (columns) = " & M & vbCrLf)
        strResult.Append("Number of cases (rows) = " & N & vbCrLf)
        strResult.Append(vbCrLf)
        strResult.Append("Data matrix is:" & vbCrLf)
        For I = 0 To N - 1
            For J = 0 To M - 1
                strResult.Append(Format(A(J, I), "###0.0") & "  ")
            Next
            strResult.Append(vbCrLf)
        Next
        strResult.Append(vbCrLf)
        IFAIL = 1
        Call G02BAF(N, M, A, IA, AMEAN, STD, SSP, ISSP, CORR, ICORR, IFAIL)

        If (IFAIL <> 0) Then
            strResult.Append("Routine fails, IFAIL = " & IFAIL & vbCrLf)
        Else
            strResult.Append("Variable   Mean  St. dev." & vbCrLf)
            For I = 0 To M - 1
                strResult.Append("  " & Format((I + 1), "###0"))
                strResult.Append("            ")
                strResult.Append(Format(AMEAN(I), "###0.000"))
                strResult.Append("     ")
                strResult.Append(Format(STD(I), "###0.000") & vbCrLf)
            Next
            strResult.Append(vbCrLf)
            strResult.Append("Sums of squares and cross-products of derivations" & vbCrLf)
            For I = 0 To M - 1
                For J = 0 To M - 1
                    strResult.Append(Format(SSP(J, I), "###000.00") & "  ")
                Next
                strResult.Append(vbCrLf)
            Next
            strResult.Append(vbCrLf)
            strResult.Append("Correlation coefficients" & vbCrLf)
            For I = 0 To M - 1
                For J = 0 To M - 1
                    strResult.Append(Format(CORR(J, I), "###0.000") & "   ")
                Next
                strResult.Append(vbCrLf)
            Next
        End If

        MessageBox.Show(strResult.ToString)

        strResult = Nothing
    End Sub


    Sub F07FBFE()

        Const NMAX As Integer = 8
        Const LDA As Integer = NMAX
        Const LDAF As Integer = NMAX
        Const LDB As Integer = NMAX
        Const LDX As Integer = NMAX
        Const NRHSMX As Integer = NMAX

        Dim rcond As Double
        Dim info As Integer
        Dim n As Integer
        Dim nrhs As Integer
        Dim equed As String
        Dim a(LDA - 1, NMAX - 1) As Double
        Dim af(LDAF - 1, NMAX - 1) As Double
        Dim b(LDB - 1, NRHSMX - 1) As Double
        Dim berr(NRHSMX - 1) As Double
        Dim ferr(NRHSMX - 1) As Double
        Dim s(NMAX - 1) As Double
        Dim work(3 * NMAX - 1) As Double
        Dim x(LDX - 1, NRHSMX - 1) As Double
        Dim iwork(NMAX - 1) As Integer

        Dim len_equed As Integer
        Dim strResult As New StringBuilder

        n = 4
        nrhs = 2

        'use 'Lower' instead of 'Upper' to transpose matrix A
        a(0, 0) = 4.16
        a(0, 1) = -3.12
        a(0, 2) = 0.56
        a(0, 3) = -0.1
        a(1, 1) = 5.03
        a(1, 2) = -0.83
        a(1, 3) = 1.18
        a(2, 2) = 0.76
        a(2, 3) = 0.34
        a(3, 3) = 1.18

        'transpose matrix B for VB.NET (note difference from VB6)
        b(0, 0) = 8.7
        b(0, 1) = -13.35
        b(0, 2) = 1.89
        b(0, 3) = -4.14
        b(1, 0) = 8.3
        b(1, 1) = 2.13
        b(1, 2) = 1.61
        b(1, 3) = 5.0

        equed = "z"     ' dummy value
        len_equed = 1

        Call F07FBF("Equilibration", "Lower", n, nrhs, a, LDA, _
        af, LDAF, equed, s, b, LDB, x, LDX, _
        rcond, ferr, berr, work, iwork, info, 13, 5, len_equed)

        strResult.Append("F07FBF Example Results" & vbCrLf & vbCrLf)
        If (info = 0 Or info = n + 1) Then
            strResult.Append("Solution(s)" & vbCrLf & vbCrLf)
            strResult.Append("x(1,1) = " & Format(x(0, 0), "##0.0000") & vbCrLf)
            strResult.Append("x(1,2) = " & Format(x(0, 1), "##0.0000") & vbCrLf)
            strResult.Append("x(1,3) = " & Format(x(0, 2), "##0.0000") & vbCrLf)
            strResult.Append("x(1,4) = " & Format(x(0, 3), "##0.0000") & vbCrLf)
            strResult.Append(vbCrLf)
            strResult.Append("x(2,1) = " & Format(x(1, 0), "##0.0000") & vbCrLf)
            strResult.Append("x(2,2) = " & Format(x(1, 1), "##0.0000") & vbCrLf)
            strResult.Append("x(2,3) = " & Format(x(1, 2), "##0.0000") & vbCrLf)
            strResult.Append("x(2,4) = " & Format(x(1, 3), "##0.0000") & vbCrLf)
            strResult.Append(vbCrLf & "Backward errors (machine-dependent)" & vbCrLf)
            strResult.Append("   " & Format(berr(0), "E") & "   " & Format(berr(1), "E") & vbCrLf)
            strResult.Append(vbCrLf & "Estimated forward error bounds (machine-dependent)" & vbCrLf)
            strResult.Append("   " & Format(ferr(0), "E") & "   " & Format(ferr(1), "E") & vbCrLf)
            strResult.Append(vbCrLf & "Estimate of reciprocal condition number" & vbCrLf)
            strResult.Append("   " & Format(rcond, "E") & vbCrLf)
            If equed.Equals("N") Then
                strResult.Append(vbCrLf & "A has not been equilibrated" & vbCrLf)
            ElseIf equed.Equals("Y") Then
                strResult.Append(vbCrLf & "A has been row and column scaled" & vbCrLf)
            Else
                strResult.Append(vbCrLf & "equed returned " & equed & vbCrLf)
            End If
            If info = n + 1 Then
                strResult.Append(vbCrLf & "The matrix A is singular to working precision" _
                    & vbCrLf)
            End If
        ElseIf info > 0 Then
            strResult.Append("The leading minor of order " & _
                info.ToString & " is not positive definite" & vbCrLf)
        Else    'info < 0
            strResult.Append("info returned " & info & vbCrLf)
        End If

        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub

    Sub G02EEFE()

        Const NMAX As Integer = 20, MMAX As Integer = 6
        Dim chrss As Double, f As Double, fin As Double = 2.0, rss As Double
        Dim i As Integer, idf As Integer, ifail As Integer, ifr As Integer, _
            im As Integer, istep As Integer, j As Integer, _
            m As Integer = MMAX, n As Integer = NMAX, nterm As Integer
        Dim addvar As Integer
        Dim mean As Char = "M"c, weight As Char = "U"c
        Dim newvar As String
        Dim exss(MMAX - 1) As Double, p(MMAX) As Double, _
            q(MMAX + 1, NMAX - 1) As Double, wk(2 * MMAX - 1) As Double, _
            wt(NMAX - 1) As Double
        Dim x(,) As Double = { _
            {0, 7, 15, 22, 29, 37, 44, 48, 65, 72, 80, 86, 93, 100, 107, 122, 129, 151, 171, 220}, _
            {1125, 920, 835, 1000, 1150, 990, 840, 650, 640, 583, 570, 570, 510, 555, 460, 275, 510, 165, 244, 79}, _
            {232, 268, 271, 237, 192, 202, 184, 200, 180, 165, 151, 171, 243, 147, 286, 198, 196, 210, 327, 334}, _
            {7160, 8804, 8108, 6370, 6441, 5154, 5896, 5336, 5041, 5012, 4825, 4391, 4320, 3709, 3969, 3558, 4361, 3301, 2964, 2777}, _
            {85.9, 86.5, 85.2, 83.8, 82.1, 79.2, 81.2, 80.6, 78.4, 79.3, 78.7, 78.0, 72.3, 74.9, 74.4, 72.5, 57.7, 71.8, 72.5, 71.9}, _
            {8905, 7388, 5348, 8056, 6960, 5690, 6932, 5400, 3177, 4461, 3901, 5002, 4665, 4642, 4840, 4479, 4200, 3410, 3360, 2599}}
        Dim y() As Double = {1.5563, 0.8976, 0.7482, 0.716, 0.301, 0.3617, 0.1139, 0.1139, -0.2218, -0.1549, 0.0, 0.0, -0.0969, -0.2218, -0.3979, -0.1549, -0.2218, -0.3979, -0.5229, -0.0458}
        Dim isx() As Integer = {0, 1, 1, 1, 1, 2}
        Dim free(MMAX - 1) As String, model(MMAX - 1) As String
        Dim name() As String = {"DAY", "BOD", "TKN", "TS ", "TVS", "COD"}
        Dim name_all As String, free_all As String, model_all As String
        Dim name_len As Integer, free_len As Integer, model_len As Integer
        Dim newvar_len As Integer
        Dim strResult As New StringBuilder

        If mean.Equals("M"c) Then
            im = 1
        Else
            im = 0
        End If
        istep = 0

        name_all = ""
        model_all = ""
        free_all = ""
        For i = 0 To m - 1
            name_all = name_all & name(i)
            model_all = model_all & "123"   'dummy value to get right length of string
            free_all = free_all & "123"     '  ditto
        Next
        name_len = name(0).Length
        model_len = 3
        free_len = 3
        newvar = "123"  'dummy value to get right length of string
        newvar_len = 3

        strResult.Append("G02EEF Example Results" & vbCrLf)

        For i = 1 To m

            strResult.Append(vbCrLf)

            ifail = 1
            Call G02EEF(istep, mean, weight, n, m, x, NMAX, _
                name_all, isx, MMAX, y, wt, fin, addvar, _
                newvar, chrss, f, model_all, nterm, _
                rss, idf, ifr, free_all, exss, q, NMAX, _
                p, wk, ifail, 1, 1, name_len, newvar_len, model_len, free_len)

            For j = 0 To m - 1
                free(j) = free_all.Substring(j * free_len, free_len)
                model(j) = model_all.Substring(j * model_len, model_len)
            Next

            If ifail <> 0 Then
                strResult.Append("ifail = " & ifail.ToString & vbCrLf)
                Exit For
            End If

            strResult.Append("Step " & istep.ToString & vbCrLf)
            If addvar = NAGFALSE Then  'False
                strResult.Append("No further variables added maximum F = " & _
                    Format(f, "##0.0000") & vbCrLf)
                strResult.Append("Free variables:")
                For j = 0 To ifr - 1
                    strResult.Append("   " & free(j))
                Next
                strResult.Append(vbCrLf)
                strResult.Append("Change in residual sums of squares for free variables:" _
                    & vbCrLf)
                For j = 0 To ifr - 1
                    strResult.Append("   " & Format(exss(j), "##0.0000"))
                Next
                strResult.Append(vbCrLf)
                Exit For
            Else
                strResult.Append("Added variable is " & newvar & vbCrLf)
                strResult.Append("Change in residual sum of squares = " _
                    & Format(chrss, "##0.0000") & vbCrLf)
                strResult.Append("F statistic = " & Format(f, "##0.00") & vbCrLf)
                strResult.Append(vbCrLf)
                strResult.Append("Variables in model:")
                For j = 0 To nterm - 1
                    strResult.Append("   " & model(j))
                Next
                strResult.Append(vbCrLf & vbCrLf)
                strResult.Append("Residual sum of squares = " & Format(rss, "##0.0000") _
                    & vbCrLf)
                strResult.Append("Degrees of freedom = " & Format(idf) _
                    & vbCrLf)
                strResult.Append(vbCrLf)
                If ifr = 0 Then
                    strResult.Append("No free variables remaining" & vbCrLf)
                    Exit Sub
                End If
                strResult.Append("Free variables:")
                For j = 0 To ifr - 1
                    strResult.Append("   " & free(j))
                Next
                strResult.Append(vbCrLf)
                strResult.Append("Change in residual sums of squares for free variables:" _
                    & vbCrLf)
                For j = 0 To ifr - 1
                    strResult.Append("   " & Format(exss(j), "##0.0000"))
                Next
                strResult.Append(vbCrLf)
            End If

        Next i
        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub

    'Example using Complex

    Sub S17DGFE()

        Dim ai As Complex, z As Complex
        Dim ifail As Integer, nz As Integer
        Dim deriv As Char, scale As Char
        Dim deriv_len As Integer = 1, scale_len As Integer = 1
        Dim strResult As New StringBuilder

        deriv = "F"c

        z.Real_Part = 0.3
        z.Imag_Part = 0.4

        scale = "U"c

        ifail = 1
        Call S17DGF(deriv, z, scale, ai, nz, ifail, deriv_len, scale_len)

        strResult.Append("S17DGF Example Results" & vbCrLf & vbCrLf)
        strResult.Append("z = (" & Format(z.Real_Part, "##0.00") & ", " & _
            Format(z.Imag_Part, "##0.00") & ")" & vbCrLf)
        strResult.Append("Airy function ai(z) = (" & Format(ai.Real_Part, "##0.0000") & ", " & _
            Format(ai.Imag_Part, "##0.0000") & ")" & vbCrLf)
        strResult.Append("nz = " & nz.ToString & vbCrLf)
        strResult.Append("ifail = " & ifail.ToString & vbCrLf)
        MessageBox.Show(strResult.ToString)
        strResult = Nothing

    End Sub

    'Example using c_ptr

    Sub E04JDFE()
        Dim infbnd As Double = 1.0E+20#
        Dim cpuser As IntPtr, handle As IntPtr
        Dim i As Integer, ifail As Integer, nvar As Integer
        Dim lx() As Double, ux() As Double, x() As Double
        Dim rinfo(99) As Double, ruser(0) As Double, stats(99) As Double
        Dim idxfd() As Integer
        Dim iuser(0) As Integer
        Dim optstr1 As String = "DFO Trust Region Tolerance = 5.0e-6"
        Dim optstr2 As String = "Print Solution = YES"
        Dim optstr3 As String = "DFO Starting Trust Region = 0.2"
        Dim strResult As New StringBuilder

        nvar = 4
        cpuser = 0  'c_null_ptr
        ifail = 1
        Call E04RAF(handle, nvar, ifail)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If


        ReDim idxfd(nvar - 1)
        For i = 1 To nvar
            idxfd(i - 1) = i
        Next
        ifail = 1
        Call E04RGF(handle, nvar, idxfd, ifail)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If

        Call E04ZMF(handle, optstr1, ifail, optstr1.Length)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If
        Call E04ZMF(handle, optstr2, ifail, optstr2.Length)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If
        Call E04ZMF(handle, optstr3, ifail, optstr3.Length)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If

        ReDim x(nvar)
        x = {3.0#, -1.0#, 0.0#, 1.0#}

        ReDim lx(nvar)
        lx = {1.0#, -2.0#, -infbnd, 1.0#}
        ReDim ux(nvar)
        ux = {3.0#, 0.0#, infbnd, 3.0#}

        ifail = 1
        Call E04RHF(handle, nvar, lx, ux, ifail)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If

        Call E04JDF(handle, AddressOf E04JDFE_objfun, AddressOf E04JDU, nvar, x, rinfo, stats, iuser, ruser, cpuser, ifail)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If

        ifail = 1
        Call E04RZF(handle, ifail)
        If ifail <> 0 Then
            strResult.Append("Error - ifail = " & ifail.ToString)
        End If

    End Sub

    Sub E04JDFE_objfun(
        ByRef NVAR As Integer,
        ByVal X_rptr As IntPtr,
        ByRef FX As Double,
        ByRef INFORM As Integer,
        ByVal IUSER_iptr As IntPtr,
        ByVal RUSER_rptr As IntPtr,
        ByRef CPUSER As IntPtr
    )

        Dim x(NVAR - 1) As Double

        Call Marshal.Copy(X_rptr, x, 0, NVAR)

        FX = (x(0) + 10.0# * x(1)) ^ 2 + 5.0# * (x(2) - x(3)) ^ 2 +
            (x(1) - 2.0# * x(2)) ^ 4 + 10.0# * (x(0) - x(3)) ^ 4
    End Sub

End Module
