

' VBA7 64bit declare statements for NAG Fortran Library DLL Mark 31.0
' Copyright 2025, Numerical Algorithms Group Ltd, Oxford, UK.

' chapter f01
   Declare Ptrsafe Sub DTRTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ap As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ap As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTPTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTRTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ar As double, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ar As Complex, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTFTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTFTTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTPTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef ar As double, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPTTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef ar As Complex, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTFTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As double, _
    ByRef ap As double, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTFTTP Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As Complex, _
    ByRef ap As Complex, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )


' chapter f02

' chapter f03

' chapter f04

' chapter f05

' chapter f06
   Declare Ptrsafe Sub DROTG Lib "NLW6I31DE_nag.dll" ( _
    ByRef a As double, _
    ByRef b As double, _
    ByRef c As double, _
    ByRef s As double _
   )

   Declare Ptrsafe Function DDOT Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long _
   ) As double

   Declare Ptrsafe Sub DAXPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long _
   )

   Declare Ptrsafe Sub DSCAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As double, _
    ByRef incx As long _
   )

   Declare Ptrsafe Sub DCOPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long _
   )

   Declare Ptrsafe Sub DSWAP Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long _
   )

   Declare Ptrsafe Function DNRM2 Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As double, _
    ByRef incx As long _
   ) As double

   Declare Ptrsafe Function DASUM Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As double, _
    ByRef incx As long _
   ) As double

   Declare Ptrsafe Sub DROT Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long, _
    ByRef c As double, _
    ByRef s As double _
   )

   Declare Ptrsafe Function DDOTI Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef x As double, _
    ByRef indx As long, _
    ByRef y As double _
   ) As double

   Declare Ptrsafe Sub DAXPYI Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef a As double, _
    ByRef x As double, _
    ByRef indx As long, _
    ByRef y As double _
   )

   Declare Ptrsafe Sub DGTHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef y As double, _
    ByRef x As double, _
    ByRef indx As long _
   )

   Declare Ptrsafe Sub DGTHRZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef y As double, _
    ByRef x As double, _
    ByRef indx As long _
   )

   Declare Ptrsafe Sub DSCTR Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef x As double, _
    ByRef indx As long, _
    ByRef y As double _
   )

   Declare Ptrsafe Sub DROTI Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef x As double, _
    ByRef indx As long, _
    ByRef y As double, _
    ByRef c As double, _
    ByRef s As double _
   )

   Declare Ptrsafe Function ZDOTU Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long _
   ) as Complex

   Declare Ptrsafe Function ZDOTC Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long _
   ) as Complex

   Declare Ptrsafe Sub ZAXPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long _
   )

   Declare Ptrsafe Sub ZSCAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef x As Complex, _
    ByRef incx As long _
   )

   Declare Ptrsafe Sub ZCOPY Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long _
   )

   Declare Ptrsafe Sub ZSWAP Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long _
   )

   Declare Ptrsafe Function ZDOTUI Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef x As Complex, _
    ByRef indx As long, _
    ByRef y As Complex _
   ) as Complex

   Declare Ptrsafe Function ZDOTCI Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef x As Complex, _
    ByRef indx As long, _
    ByRef y As Complex _
   ) as Complex

   Declare Ptrsafe Sub ZAXPYI Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef a As Complex, _
    ByRef x As Complex, _
    ByRef indx As long, _
    ByRef y As Complex _
   )

   Declare Ptrsafe Sub ZGTHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef y As Complex, _
    ByRef x As Complex, _
    ByRef indx As long _
   )

   Declare Ptrsafe Sub ZGTHRZ Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef y As Complex, _
    ByRef x As Complex, _
    ByRef indx As long _
   )

   Declare Ptrsafe Sub ZSCTR Lib "NLW6I31DE_nag.dll" ( _
    ByRef nz As long, _
    ByRef x As Complex, _
    ByRef indx As long, _
    ByRef y As Complex _
   )

   Declare Ptrsafe Sub ZROT Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef cx As Complex, _
    ByRef incx As long, _
    ByRef cy As Complex, _
    ByRef incy As long, _
    ByRef c As double, _
    ByRef s As Complex _
   )

   Declare Ptrsafe Sub ZDSCAL Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As Complex, _
    ByRef incx As long _
   )

   Declare Ptrsafe Function DZNRM2 Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long _
   ) As double

   Declare Ptrsafe Function DZASUM Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long _
   ) As double

   Declare Ptrsafe Function IDAMAX Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As double, _
    ByRef incx As long _
   ) As long

   Declare Ptrsafe Function IZAMAX Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long _
   ) As long

   Declare Ptrsafe Sub ZDROT Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByRef c As double, _
    ByRef s As double _
   )

   Declare Ptrsafe Sub DGEMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef beta As double, _
    ByRef y As double, _
    ByRef incy As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef beta As double, _
    ByRef y As double, _
    ByRef incy As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DSYMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef beta As double, _
    ByRef y As double, _
    ByRef incy As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef beta As double, _
    ByRef y As double, _
    ByRef incy As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef ap As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef beta As double, _
    ByRef y As double, _
    ByRef incy As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTRMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTRSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef x As double, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DGER Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long, _
    ByRef a As double, _
    ByRef lda As long _
   )

   Declare Ptrsafe Sub DSYR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef ap As double, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYR2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPR2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As double, _
    ByRef incx As long, _
    ByRef y As double, _
    ByRef incy As long, _
    ByRef ap As double, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef beta As Complex, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef beta As Complex, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef beta As Complex, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef beta As Complex, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef ap As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef beta As Complex, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTBMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPMV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZGERU Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByRef a As Complex, _
    ByRef lda As long _
   )

   Declare Ptrsafe Sub ZGERC Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByRef a As Complex, _
    ByRef lda As long _
   )

   Declare Ptrsafe Sub ZHER Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef ap As Complex, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHER2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPR2 Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef x As Complex, _
    ByRef incx As long, _
    ByRef y As Complex, _
    ByRef incy As long, _
    ByRef ap As Complex, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Function DLANSF Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef work As double, _
    ByVal NORMLength As LongLong, ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    ) As double

   Declare Ptrsafe Sub DTFSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByVal TRANSRLength As LongLong, ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DSFRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef beta As double, _
    ByRef c As double, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Function ZLANHF Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef work As double, _
    ByVal NORMLength As LongLong, ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    ) As double

   Declare Ptrsafe Sub ZTFSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByVal TRANSRLength As LongLong, ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZHFRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As double, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef beta As double, _
    ByRef c As Complex, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal transa As string, _
    ByVal transb As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef beta As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByVal TRANSALength As LongLong, ByVal TRANSBLength As LongLong _
    )

   Declare Ptrsafe Sub DSYMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef beta As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTRMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal transa As string, _
    ByVal diag As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSALength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTRSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal transa As string, _
    ByVal diag As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSALength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DSYRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef beta As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DSYR2K Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As double, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef beta As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal transa As string, _
    ByVal transb As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef beta As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByVal TRANSALength As LongLong, ByVal TRANSBLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef beta As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal transa As string, _
    ByVal diag As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSALength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRSM Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal transa As string, _
    ByVal diag As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSALength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZHERK Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As double, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef beta As double, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZHER2K Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef beta As double, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYMM Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef beta As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYRK Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef beta As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYR2K Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef alpha As Complex, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef beta As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )


' chapter f07
   Declare Ptrsafe Sub DGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGESVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal trans As string, ByRef n As long, _
    ByRef nrhs As long, ByRef a As double, ByRef lda As long, _
    ByRef af As double, ByRef ldaf As long, ByRef ipiv As long, _
    ByVal equed As string, ByRef r As double, ByRef c As double, _
    ByRef b As double, ByRef ldb As long, ByRef x As double, _
    ByRef ldx As long, ByRef rcond As double, ByRef ferr As double, _
    ByRef berr As double, ByRef work As double, ByRef iwork As long, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal TRANSLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub DSGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef work As double, _
    ByRef swork As Single, _
    ByRef iter As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGETRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGETRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef r As double, _
    ByRef c As double, _
    ByRef rowcnd As double, _
    ByRef colcnd As double, _
    ByRef amax As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGECON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal NORMLength As LongLong _
    )

   Declare Ptrsafe Sub DGERFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef af As double, _
    ByRef ldaf As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGETRI Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGESVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal trans As string, ByRef n As long, _
    ByRef nrhs As long, ByRef a As Complex, ByRef lda As long, _
    ByRef af As Complex, ByRef ldaf As long, ByRef ipiv As long, _
    ByVal equed As string, ByRef r As double, ByRef c As double, _
    ByRef b As Complex, ByRef ldb As long, ByRef x As Complex, _
    ByRef ldx As long, ByRef rcond As double, ByRef ferr As double, _
    ByRef berr As double, ByRef work As Complex, ByRef rwork As double, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal TRANSLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub ZCGESV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef work As Complex, _
    ByRef swork As ComplexSingle, _
    ByRef rwork As double, _
    ByRef iter As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGETRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGETRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef r As double, _
    ByRef c As double, _
    ByRef rowcnd As double, _
    ByRef colcnd As double, _
    ByRef amax As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGECON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal NORMLength As LongLong _
    )

   Declare Ptrsafe Sub ZGERFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef af As Complex, _
    ByRef ldaf As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGETRI Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGBSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal trans As string, ByRef n As long, _
    ByRef kl As long, ByRef ku As long, ByRef nrhs As long, _
    ByRef ab As double, ByRef ldab As long, ByRef afb As double, _
    ByRef ldafb As long, ByRef ipiv As long, ByVal equed As string, _
    ByRef r As double, ByRef c As double, ByRef b As double, _
    ByRef ldb As long, ByRef x As double, ByRef ldx As long, _
    ByRef rcond As double, ByRef ferr As double, ByRef berr As double, _
    ByRef work As double, ByRef iwork As long, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal TRANSLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub DGBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef r As double, _
    ByRef c As double, _
    ByRef rowcnd As double, _
    ByRef colcnd As double, _
    ByRef amax As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal NORMLength As LongLong _
    )

   Declare Ptrsafe Sub DGBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef afb As double, _
    ByRef ldafb As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGBSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal trans As string, ByRef n As long, _
    ByRef kl As long, ByRef ku As long, ByRef nrhs As long, _
    ByRef ab As Complex, ByRef ldab As long, ByRef afb As Complex, _
    ByRef ldafb As long, ByRef ipiv As long, ByVal equed As string, _
    ByRef r As double, ByRef c As double, ByRef b As Complex, _
    ByRef ldb As long, ByRef x As Complex, ByRef ldx As long, _
    ByRef rcond As double, ByRef ferr As double, ByRef berr As double, _
    ByRef work As Complex, ByRef rwork As double, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal TRANSLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub ZGBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef r As double, _
    ByRef c As double, _
    ByRef rowcnd As double, _
    ByRef colcnd As double, _
    ByRef amax As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal NORMLength As LongLong _
    )

   Declare Ptrsafe Sub ZGBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef afb As Complex, _
    ByRef ldafb As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef dl As double, _
    ByRef d As double, _
    ByRef du As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal trans As string, ByRef n As long, _
    ByRef nrhs As long, ByRef dl As double, ByRef d As double, _
    ByRef du As double, ByRef dlf As double, ByRef df As double, _
    ByRef duf As double, ByRef du2 As double, ByRef ipiv As long, _
    ByRef b As double, ByRef ldb As long, ByRef x As double, _
    ByRef ldx As long, ByRef rcond As double, ByRef ferr As double, _
    ByRef berr As double, ByRef work As double, ByRef iwork As long, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef dl As double, _
    ByRef d As double, _
    ByRef du As double, _
    ByRef du2 As double, _
    ByRef ipiv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef dl As double, _
    ByRef d As double, _
    ByRef du As double, _
    ByRef du2 As double, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGTCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByRef n As long, _
    ByRef dl As double, _
    ByRef d As double, _
    ByRef du As double, _
    ByRef du2 As double, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal NORMLength As LongLong _
    )

   Declare Ptrsafe Sub DGTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, ByRef n As long, ByRef nrhs As long, _
    ByRef dl As double, ByRef d As double, ByRef du As double, _
    ByRef dlf As double, ByRef df As double, ByRef duf As double, _
    ByRef du2 As double, ByRef ipiv As long, ByRef b As double, _
    ByRef ldb As long, ByRef x As double, ByRef ldx As long, _
    ByRef ferr As double, ByRef berr As double, ByRef work As double, _
    ByRef iwork As long, ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef dl As Complex, _
    ByRef d As Complex, _
    ByRef du As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal trans As string, ByRef n As long, _
    ByRef nrhs As long, ByRef dl As Complex, ByRef d As Complex, _
    ByRef du As Complex, ByRef dlf As Complex, ByRef df As Complex, _
    ByRef duf As Complex, ByRef du2 As Complex, ByRef ipiv As long, _
    ByRef b As Complex, ByRef ldb As long, ByRef x As Complex, _
    ByRef ldx As long, ByRef rcond As double, ByRef ferr As double, _
    ByRef berr As double, ByRef work As Complex, ByRef rwork As double, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef dl As Complex, _
    ByRef d As Complex, _
    ByRef du As Complex, _
    ByRef du2 As Complex, _
    ByRef ipiv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef dl As Complex, _
    ByRef d As Complex, _
    ByRef du As Complex, _
    ByRef du2 As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGTCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByRef n As long, _
    ByRef dl As Complex, _
    ByRef d As Complex, _
    ByRef du As Complex, _
    ByRef du2 As Complex, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal NORMLength As LongLong _
    )

   Declare Ptrsafe Sub ZGTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, ByRef n As long, ByRef nrhs As long, _
    ByRef dl As Complex, ByRef d As Complex, ByRef du As Complex, _
    ByRef dlf As Complex, ByRef df As Complex, ByRef duf As Complex, _
    ByRef du2 As Complex, ByRef ipiv As long, ByRef b As Complex, _
    ByRef ldb As long, ByRef x As Complex, ByRef ldx As long, _
    ByRef ferr As double, ByRef berr As double, ByRef work As Complex, _
    ByRef rwork As double, ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPOSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal uplo As string, ByRef n As long, _
    ByRef nrhs As long, ByRef a As double, ByRef lda As long, _
    ByRef af As double, ByRef ldaf As long, ByVal equed As string, _
    ByRef s As double, ByRef b As double, ByRef ldb As long, _
    ByRef x As double, ByRef ldx As long, ByRef rcond As double, _
    ByRef ferr As double, ByRef berr As double, ByRef work As double, _
    ByRef iwork As long, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub DSPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef work As double, _
    ByRef swork As Single, _
    ByRef iter As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPOTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPOTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPOEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef s As double, _
    ByRef scond As double, _
    ByRef amax As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DPOCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPORFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef af As double, _
    ByRef ldaf As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPOTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPOSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal uplo As string, ByRef n As long, _
    ByRef nrhs As long, ByRef a As Complex, ByRef lda As long, _
    ByRef af As Complex, ByRef ldaf As long, ByVal equed As string, _
    ByRef s As double, ByRef b As Complex, ByRef ldb As long, _
    ByRef x As Complex, ByRef ldx As long, ByRef rcond As double, _
    ByRef ferr As double, ByRef berr As double, ByRef work As Complex, _
    ByRef rwork As double, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub ZCPOSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef work As Complex, _
    ByRef swork As ComplexSingle, _
    ByRef rwork As double, _
    ByRef iter As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPOTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPOTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPOEQU Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef s As double, _
    ByRef scond As double, _
    ByRef amax As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZPOCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPORFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef af As Complex, _
    ByRef ldaf As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPOTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef afp As double, _
    ByVal equed As string, _
    ByRef s As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef rcond As double, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub DPPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPPEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef s As double, _
    ByRef scond As double, _
    ByRef amax As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef afp As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef afp As Complex, _
    ByVal equed As string, _
    ByRef s As double, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef rcond As double, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef s As double, _
    ByRef scond As double, _
    ByRef amax As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef afp As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal uplo As string, ByRef n As long, _
    ByRef kd As long, ByRef nrhs As long, ByRef ab As double, _
    ByRef ldab As long, ByRef afb As double, ByRef ldafb As long, _
    ByVal equed As string, ByRef s As double, ByRef b As double, _
    ByRef ldb As long, ByRef x As double, ByRef ldx As long, _
    ByRef rcond As double, ByRef ferr As double, ByRef berr As double, _
    ByRef work As double, ByRef iwork As long, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub DPBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef s As double, _
    ByRef scond As double, _
    ByRef amax As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef afb As double, _
    ByRef ldafb As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal uplo As string, ByRef n As long, _
    ByRef kd As long, ByRef nrhs As long, ByRef ab As Complex, _
    ByRef ldab As long, ByRef afb As Complex, ByRef ldafb As long, _
    ByVal equed As string, ByRef s As double, ByRef b As Complex, _
    ByRef ldb As long, ByRef x As Complex, ByRef ldx As long, _
    ByRef rcond As double, ByRef ferr As double, ByRef berr As double, _
    ByRef work As Complex, ByRef rwork As double, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong, ByVal EQUEDLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBEQU Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef s As double, _
    ByRef scond As double, _
    ByRef amax As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef afb As Complex, _
    ByRef ldafb As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DPTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef df As double, _
    ByRef ef As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef rcond As double, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal FACTLength As LongLong _
    )

   Declare Ptrsafe Sub DPTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DPTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DPTCON Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DPTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef df As double, _
    ByRef ef As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZPTSV Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZPTSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As Complex, _
    ByRef df As double, _
    ByRef ef As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef rcond As double, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal FACTLength As LongLong _
    )

   Declare Ptrsafe Sub ZPTTRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As Complex, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZPTTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPTCON Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As Complex, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef rwork As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZPTRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef d As double, _
    ByRef e As Complex, _
    ByRef df As double, _
    ByRef ef As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPSTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef piv As long, _
    ByRef rank As long, _
    ByRef tol As double, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPSTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef piv As long, _
    ByRef rank As long, _
    ByRef tol As double, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal uplo As string, ByRef n As long, _
    ByRef nrhs As long, ByRef a As double, ByRef lda As long, _
    ByRef af As double, ByRef ldaf As long, ByRef ipiv As long, _
    ByRef b As double, ByRef ldb As long, ByRef x As double, _
    ByRef ldx As long, ByRef rcond As double, ByRef ferr As double, _
    ByRef berr As double, ByRef work As double, ByRef lwork As long, _
    ByRef iwork As long, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef af As double, _
    ByRef ldaf As long, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHESV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHESVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal uplo As string, ByRef n As long, _
    ByRef nrhs As long, ByRef a As Complex, ByRef lda As long, _
    ByRef af As Complex, ByRef ldaf As long, ByRef ipiv As long, _
    ByRef b As Complex, ByRef ldb As long, ByRef x As Complex, _
    ByRef ldx As long, ByRef rcond As double, ByRef ferr As double, _
    ByRef berr As double, ByRef work As Complex, ByRef lwork As long, _
    ByRef rwork As double, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHETRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHETRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHECON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHERFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef af As Complex, _
    ByRef ldaf As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHETRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, ByVal uplo As string, ByRef n As long, _
    ByRef nrhs As long, ByRef a As Complex, ByRef lda As long, _
    ByRef af As Complex, ByRef ldaf As long, ByRef ipiv As long, _
    ByRef b As Complex, ByRef ldb As long, ByRef x As Complex, _
    ByRef ldx As long, ByRef rcond As double, ByRef ferr As double, _
    ByRef berr As double, ByRef work As Complex, ByRef lwork As long, _
    ByRef rwork As double, ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef af As Complex, _
    ByRef ldaf As long, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSYTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ipiv As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef afp As double, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef rcond As double, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef ipiv As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef afp As double, _
    ByRef ipiv As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef ipiv As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef afp As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef rcond As double, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef afp As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSPSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSPSVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal fact As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef afp As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef rcond As double, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal FACTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSPTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef anorm As double, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef afp As Complex, _
    ByRef ipiv As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZSPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef ipiv As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTRTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTRCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal NORMLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTRRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTRTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal NORMLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal NORMLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal NORMLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ap As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTPTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef rcond As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal NORMLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DTBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTBTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTBCON Lib "NLW6I31DE_nag.dll" ( _
    ByVal norm As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef rcond As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal NORMLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZTBRFS Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef nrhs As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef ferr As double, _
    ByRef berr As double, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub DPFTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As double, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPFTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ar As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As double, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DTFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ar As double, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )

   Declare Ptrsafe Sub ZPFTRF Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As Complex, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPFTRS Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef ar As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ar As Complex, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZTFTRI Lib "NLW6I31DE_nag.dll" ( _
    ByVal transr As string, _
    ByVal uplo As string, _
    ByVal diag As string, _
    ByRef n As long, _
    ByRef ar As Complex, _
    ByRef info As long, _
    ByVal TRANSRLength As LongLong, ByVal UPLOLength As LongLong, ByVal DIAGLength As LongLong _
    )


' chapter f08
   Declare Ptrsafe Sub DGELS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nb As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef work As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGEMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef nb As long, _
    ByRef v As double, _
    ByRef ldv As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORGQR Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORMQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGELQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORGLQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORMLQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGELS Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nb As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef work As Complex, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGEMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef nb As long, _
    ByRef v As Complex, _
    ByRef ldv As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNGQR Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNMQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGELQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNGLQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNMLQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGELSY Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef jpvt As long, _
    ByRef rcond As double, _
    ByRef rank As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DTPQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef l As long, _
    ByRef nb As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef work As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DTPMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef l As long, _
    ByRef nb As long, _
    ByRef v As double, _
    ByRef ldv As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef c1 As double, _
    ByRef ldc1 As long, _
    ByRef c2 As double, _
    ByRef ldc2 As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEQPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef jpvt As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGEQP3 Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef jpvt As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DTZRZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORMRZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef l As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGELSY Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef jpvt As long, _
    ByRef rcond As double, _
    ByRef rank As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZTPQRT Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef l As long, _
    ByRef nb As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef work As Complex, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZTPMQRT Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef l As long, _
    ByRef nb As long, _
    ByRef v As Complex, _
    ByRef ldv As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef c1 As Complex, _
    ByRef ldc1 As long, _
    ByRef c2 As Complex, _
    ByRef ldc2 As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEQPF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef jpvt As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGEQP3 Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef jpvt As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZTZRZF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNMRZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef l As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEQLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORGQL Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORMQL Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGERQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORGRQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORMRQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEQLF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNGQL Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNMQL Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGERQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNGRQ Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNMRQ Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DSYEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef w As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef a As double, ByRef lda As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As double, ByRef ldz As long, _
    ByRef work As double, ByRef lwork As long, ByRef iwork As long, _
    ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef w As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYEVR Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef a As double, ByRef lda As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As double, ByRef ldz As long, _
    ByRef isuppz As long, ByRef work As double, ByRef lwork As long, _
    ByRef iwork As long, ByRef liwork As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DORGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DORMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DDISNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef sep As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef w As double, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef a As Complex, ByRef lda As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As Complex, ByRef ldz As long, _
    ByRef work As Complex, ByRef lwork As long, ByRef rwork As double, _
    ByRef iwork As long, ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef w As double, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEEVR Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef a As Complex, ByRef lda As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As Complex, ByRef ldz As long, _
    ByRef isuppz As long, ByRef work As Complex, ByRef lwork As long, _
    ByRef rwork As double, ByRef lrwork As long, ByRef iwork As long, _
    ByRef liwork As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHETRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZUNGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZUNMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DSPEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal range As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef vl As double, _
    ByRef vu As double, _
    ByRef il As long, _
    ByRef iu As long, _
    ByRef abstol As double, _
    ByRef m As long, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef jfail As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef tau As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DOPGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef tau As double, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DOPMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal range As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef vl As double, _
    ByRef vu As double, _
    ByRef il As long, _
    ByRef iu As long, _
    ByRef abstol As double, _
    ByRef m As long, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef iwork As long, _
    ByRef jfail As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef tau As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZUPGTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef tau As Complex, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZUPMTR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal uplo As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal UPLOLength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DSBEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef kd As long, ByRef ab As double, _
    ByRef ldab As long, ByRef q As double, ByRef ldq As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As double, ByRef ldz As long, _
    ByRef work As double, ByRef iwork As long, ByRef jfail As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal VECTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef kd As long, ByRef ab As Complex, _
    ByRef ldab As long, ByRef q As Complex, ByRef ldq As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As Complex, ByRef ldz As long, _
    ByRef work As Complex, ByRef rwork As double, ByRef iwork As long, _
    ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBTRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kd As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef work As Complex, _
    ByRef info As long, _
    ByVal VECTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSTEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong _
    )

   Declare Ptrsafe Sub DSTEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal range As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef vl As double, _
    ByRef vu As double, _
    ByRef il As long, _
    ByRef iu As long, _
    ByRef abstol As double, _
    ByRef m As long, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef jfail As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong _
    )

   Declare Ptrsafe Sub DSTEVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong _
    )

   Declare Ptrsafe Sub DSTEVR Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByRef n As long, _
    ByRef d As double, ByRef e As double, ByRef vl As double, _
    ByRef vu As double, ByRef il As long, ByRef iu As long, _
    ByRef abstol As double, ByRef m As long, ByRef w As double, _
    ByRef z As double, ByRef ldz As long, ByRef isuppz As long, _
    ByRef work As double, ByRef lwork As long, ByRef iwork As long, _
    ByRef liwork As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong _
    )

   Declare Ptrsafe Sub DSTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub DSTERF Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DPTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub DSTEDC Lib "NLW6I31DE_nag.dll" ( _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub DSTEBZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal range As string, _
    ByVal order As string, _
    ByRef n As long, _
    ByRef vl As double, _
    ByRef vu As double, _
    ByRef il As long, _
    ByRef iu As long, _
    ByRef abstol As double, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef m As long, _
    ByRef nsplit As long, _
    ByRef w As double, _
    ByRef iblock As long, _
    ByRef isplit As long, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal RANGELength As LongLong, ByVal ORDERLength As LongLong _
    )

   Declare Ptrsafe Sub DSTEIN Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef m As long, _
    ByRef w As double, _
    ByRef iblock As long, _
    ByRef isplit As long, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef ifailv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DSTEGR Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByRef n As long, _
    ByRef d As double, ByRef e As double, ByRef vl As double, _
    ByRef vu As double, ByRef il As long, ByRef iu As long, _
    ByRef abstol As double, ByRef m As long, ByRef w As double, _
    ByRef z As double, ByRef ldz As long, ByRef isuppz As long, _
    ByRef work As double, ByRef lwork As long, ByRef iwork As long, _
    ByRef liwork As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong _
    )

   Declare Ptrsafe Sub ZSTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub ZPTEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub ZSTEDC Lib "NLW6I31DE_nag.dll" ( _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub ZSTEIN Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef m As long, _
    ByRef w As double, _
    ByRef iblock As long, _
    ByRef isplit As long, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef ifailv As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZSTEGR Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByRef n As long, _
    ByRef d As double, ByRef e As double, ByRef vl As double, _
    ByRef vu As double, ByRef il As long, ByRef iu As long, _
    ByRef abstol As double, ByRef m As long, ByRef w As double, _
    ByRef z As Complex, ByRef ldz As long, ByRef isuppz As long, _
    ByRef work As double, ByRef lwork As long, ByRef iwork As long, _
    ByRef liwork As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong _
    )

   Declare Ptrsafe Sub DGELSS Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef s As double, _
    ByRef rcond As double, _
    ByRef rank As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGESVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, _
    ByVal jobvt As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef s As double, _
    ByRef u As double, _
    ByRef ldu As long, _
    ByRef vt As double, _
    ByRef ldvt As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVTLength As LongLong _
    )

   Declare Ptrsafe Sub DGELSD Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef s As double, _
    ByRef rcond As double, _
    ByRef rank As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGESDD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef s As double, _
    ByRef u As double, _
    ByRef ldu As long, _
    ByRef vt As double, _
    ByRef ldvt As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong _
    )

   Declare Ptrsafe Sub DGEBRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef tauq As double, _
    ByRef taup As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORGBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal VECTLength As LongLong _
    )

   Declare Ptrsafe Sub DORMBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal VECTLength As LongLong, ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEJSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal joba As string, _
    ByVal jobu As string, _
    ByVal jobv As string, _
    ByVal jobr As string, _
    ByVal jobt As string, _
    ByVal jobp As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef sva As double, _
    ByRef u As double, _
    ByRef ldu As long, _
    ByRef v As double, _
    ByRef ldv As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal JOBALength As LongLong, ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBRLength As LongLong, ByVal JOBTLength As LongLong, ByVal JOBPLength As LongLong _
    )

   Declare Ptrsafe Sub DGESVJ Lib "NLW6I31DE_nag.dll" ( _
    ByVal joba As string, _
    ByVal jobu As string, _
    ByVal jobv As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef sva As double, _
    ByRef mv As long, _
    ByRef v As double, _
    ByRef ldv As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBALength As LongLong, ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong _
    )

   Declare Ptrsafe Sub DGESVDX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobvt As string, ByVal range As string, _
    ByRef m As long, ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef vl As double, ByRef vu As double, _
    ByRef il As long, ByRef iu As long, ByRef ns As long, _
    ByRef s As double, ByRef u As double, ByRef ldu As long, _
    ByRef vt As double, ByRef ldvt As long, ByRef work As double, _
    ByRef lwork As long, ByRef iwork As long, ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVTLength As LongLong, ByVal RANGELength As LongLong _
    )

   Declare Ptrsafe Sub ZGELSS Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef s As double, _
    ByRef rcond As double, _
    ByRef rank As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGESVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, _
    ByVal jobvt As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef s As double, _
    ByRef u As Complex, _
    ByRef ldu As long, _
    ByRef vt As Complex, _
    ByRef ldvt As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVTLength As LongLong _
    )

   Declare Ptrsafe Sub ZGELSD Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef nrhs As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef s As double, _
    ByRef rcond As double, _
    ByRef rank As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef iwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGESDD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef s As double, _
    ByRef u As Complex, _
    ByRef ldu As long, _
    ByRef vt As Complex, _
    ByRef ldvt As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEBRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef tauq As Complex, _
    ByRef taup As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNGBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal VECTLength As LongLong _
    )

   Declare Ptrsafe Sub ZUNMBR Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef k As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal VECTLength As LongLong, ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEJSV Lib "NLW6I31DE_nag.dll" ( _
    ByVal joba As string, ByVal jobu As string, ByVal jobv As string, _
    ByVal jobr As string, ByVal jobt As string, ByVal jobp As string, _
    ByRef m As long, ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef sva As double, ByRef u As Complex, _
    ByRef ldu As long, ByRef v As Complex, ByRef ldv As long, _
    ByRef cwork As Complex, ByRef lwork As long, ByRef rwork As double, _
    ByRef lrwork As long, ByRef iwork As long, ByRef info As long, _
    ByVal JOBALength As LongLong, ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBRLength As LongLong, ByVal JOBTLength As LongLong, ByVal JOBPLength As LongLong _
    )

   Declare Ptrsafe Sub ZGESVJ Lib "NLW6I31DE_nag.dll" ( _
    ByVal joba As string, _
    ByVal jobu As string, _
    ByVal jobv As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef sva As double, _
    ByRef mv As long, _
    ByRef v As Complex, _
    ByRef ldv As long, _
    ByRef cwork As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef info As long, _
    ByVal JOBALength As LongLong, ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong _
    )

   Declare Ptrsafe Sub ZGESVDX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobvt As string, ByVal range As string, _
    ByRef m As long, ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef vl As double, ByRef vu As double, _
    ByRef il As long, ByRef iu As long, ByRef ns As long, _
    ByRef s As double, ByRef u As Complex, ByRef ldu As long, _
    ByRef vt As Complex, ByRef ldvt As long, ByRef work As Complex, _
    ByRef lwork As long, ByRef rwork As double, ByRef iwork As long, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVTLength As LongLong, ByVal RANGELength As LongLong _
    )

   Declare Ptrsafe Sub DGBBRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef ncc As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef pt As double, _
    ByRef ldpt As long, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal VECTLength As LongLong _
    )

   Declare Ptrsafe Sub ZGBBRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef ncc As long, _
    ByRef kl As long, _
    ByRef ku As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef pt As Complex, _
    ByRef ldpt As long, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal VECTLength As LongLong _
    )

   Declare Ptrsafe Sub DBDSVDX Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal jobz As string, _
    ByVal range As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef vl As double, _
    ByRef vu As double, _
    ByRef il As long, _
    ByRef iu As long, _
    ByRef ns As long, _
    ByRef s As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong _
    )

   Declare Ptrsafe Sub DBDSDC Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByVal compq As string, _
    ByRef n As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef u As double, _
    ByRef ldu As long, _
    ByRef vt As double, _
    ByRef ldvt As long, _
    ByRef q As double, _
    ByRef iq As long, _
    ByRef work As double, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong, ByVal COMPQLength As LongLong _
    )

   Declare Ptrsafe Sub DBDSQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ncvt As long, _
    ByRef nru As long, _
    ByRef ncc As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef vt As double, _
    ByRef ldvt As long, _
    ByRef u As double, _
    ByRef ldu As long, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZBDSQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ncvt As long, _
    ByRef nru As long, _
    ByRef ncc As long, _
    ByRef d As double, _
    ByRef e As double, _
    ByRef vt As Complex, _
    ByRef ldvt As long, _
    ByRef u As Complex, _
    ByRef ldu As long, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DGEEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvl As string, _
    ByVal jobvr As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef wr As double, _
    ByRef wi As double, _
    ByRef vl As double, _
    ByRef ldvl As long, _
    ByRef vr As double, _
    ByRef ldvr As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong _
    )

   Declare Ptrsafe Sub DGEEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal balanc As string, ByVal jobvl As string, ByVal jobvr As string, _
    ByVal sense As string, ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef wr As double, ByRef wi As double, _
    ByRef vl As double, ByRef ldvl As long, ByRef vr As double, _
    ByRef ldvr As long, ByRef ilo As long, ByRef ihi As long, _
    ByRef scal As double, ByRef abnrm As double, ByRef rconde As double, _
    ByRef rcondv As double, ByRef work As double, ByRef lwork As long, _
    ByRef iwork As long, ByRef info As long, _
    ByVal BALANCLength As LongLong, ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong, ByVal SENSELength As LongLong _
    )

   Declare Ptrsafe Sub DGEHRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORGHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DORMHR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef tau As double, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DGEBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef scal As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong _
    )

   Declare Ptrsafe Sub DGEBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal side As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef scal As double, _
    ByRef m As long, _
    ByRef v As double, _
    ByRef ldv As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal SIDELength As LongLong _
    )

   Declare Ptrsafe Sub ZGEEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvl As string, _
    ByVal jobvr As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef w As Complex, _
    ByRef vl As Complex, _
    ByRef ldvl As long, _
    ByRef vr As Complex, _
    ByRef ldvr As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal balanc As string, ByVal jobvl As string, ByVal jobvr As string, _
    ByVal sense As string, ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef w As Complex, ByRef vl As Complex, _
    ByRef ldvl As long, ByRef vr As Complex, ByRef ldvr As long, _
    ByRef ilo As long, ByRef ihi As long, ByRef scal As double, _
    ByRef abnrm As double, ByRef rconde As double, ByRef rcondv As double, _
    ByRef work As Complex, ByRef lwork As long, ByRef rwork As double, _
    ByRef info As long, _
    ByVal BALANCLength As LongLong, ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong, ByVal SENSELength As LongLong _
    )

   Declare Ptrsafe Sub ZGEHRD Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNGHR Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZUNMHR Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal trans As string, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef tau As Complex, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef scal As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong _
    )

   Declare Ptrsafe Sub ZGEBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal side As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef scal As double, _
    ByRef m As long, _
    ByRef v As Complex, _
    ByRef ldv As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal SIDELength As LongLong _
    )

' skeleton code for callback function
'  Function DGEES_SEL( _
'      ByRef wr As double, _
'      ByRef wi As double _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub DGEES Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvs As string, _
    ByVal sort As string, _
    ByVal sel As longPtr, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef sdim As long, _
    ByRef wr As double, _
    ByRef wi As double, _
    ByRef vs As double, _
    ByRef ldvs As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef bwork As long, _
    ByRef info As long, _
    ByVal JOBVSLength As LongLong, ByVal SORTLength As LongLong _
    )

' skeleton code for callback function
'  Function DGEESX_SEL( _
'      ByRef wr As double, _
'      ByRef wi As double _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub DGEESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvs As string, ByVal sort As string, ByVal sel As longPtr, _
    ByVal sense As string, ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef sdim As long, ByRef wr As double, _
    ByRef wi As double, ByRef vs As double, ByRef ldvs As long, _
    ByRef rconde As double, ByRef rcondv As double, ByRef work As double, _
    ByRef lwork As long, ByRef iwork As long, ByRef liwork As long, _
    ByRef bwork As long, ByRef info As long, _
    ByVal JOBVSLength As LongLong, ByVal SORTLength As LongLong, ByVal SENSELength As LongLong _
    )

   Declare Ptrsafe Sub DHSEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef h As double, _
    ByRef ldh As long, _
    ByRef wr As double, _
    ByRef wi As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub DHSEIN Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal eigsrc As string, _
    ByVal initv As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef h As double, _
    ByRef ldh As long, _
    ByRef wr As double, _
    ByRef wi As double, _
    ByRef vl As double, _
    ByRef ldvl As long, _
    ByRef vr As double, _
    ByRef ldvr As long, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As double, _
    ByRef ifaill As long, _
    ByRef ifailr As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal EIGSRCLength As LongLong, ByVal INITVLength As LongLong _
    )

' skeleton code for callback function
'  Function ZGEES_SEL( _
'      ByRef w As Complex _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub ZGEES Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvs As string, _
    ByVal sort As string, _
    ByVal sel As longPtr, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef sdim As long, _
    ByRef w As Complex, _
    ByRef vs As Complex, _
    ByRef ldvs As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef bwork As long, _
    ByRef info As long, _
    ByVal JOBVSLength As LongLong, ByVal SORTLength As LongLong _
    )

' skeleton code for callback function
'  Function ZGEESX_SEL( _
'      ByRef w As Complex _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub ZGEESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvs As string, _
    ByVal sort As string, _
    ByVal sel As longPtr, _
    ByVal sense As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef sdim As long, _
    ByRef w As Complex, _
    ByRef vs As Complex, _
    ByRef ldvs As long, _
    ByRef rconde As double, _
    ByRef rcondv As double, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef bwork As long, _
    ByRef info As long, _
    ByVal JOBVSLength As LongLong, ByVal SORTLength As LongLong, ByVal SENSELength As LongLong _
    )

   Declare Ptrsafe Sub ZHSEQR Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef h As Complex, _
    ByRef ldh As long, _
    ByRef w As Complex, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub ZHSEIN Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal eigsrc As string, _
    ByVal initv As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef h As Complex, _
    ByRef ldh As long, _
    ByRef w As Complex, _
    ByRef vl As Complex, _
    ByRef ldvl As long, _
    ByRef vr As Complex, _
    ByRef ldvr As long, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef ifaill As long, _
    ByRef ifailr As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal EIGSRCLength As LongLong, ByVal INITVLength As LongLong _
    )

   Declare Ptrsafe Sub DTREXC Lib "NLW6I31DE_nag.dll" ( _
    ByVal compq As string, _
    ByRef n As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef ifst As long, _
    ByRef ilst As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal COMPQLength As LongLong _
    )

   Declare Ptrsafe Sub DTRSEN Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal compq As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef wr As double, _
    ByRef wi As double, _
    ByRef m As long, _
    ByRef s As double, _
    ByRef sep As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal COMPQLength As LongLong _
    )

   Declare Ptrsafe Sub DTRSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal trana As string, _
    ByVal tranb As string, _
    ByRef isgn As long, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef c As double, _
    ByRef ldc As long, _
    ByRef scal As double, _
    ByRef info As long, _
    ByVal TRANALength As LongLong, ByVal TRANBLength As LongLong _
    )

   Declare Ptrsafe Sub DTREVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal howmny As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef vl As double, _
    ByRef ldvl As long, _
    ByRef vr As double, _
    ByRef ldvr As long, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub DTRSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal howmny As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef t As double, _
    ByRef ldt As long, _
    ByRef vl As double, _
    ByRef ldvl As long, _
    ByRef vr As double, _
    ByRef ldvr As long, _
    ByRef s As double, _
    ByRef sep As double, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As double, _
    ByRef ldwork As long, _
    ByRef iwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub ZTREXC Lib "NLW6I31DE_nag.dll" ( _
    ByVal compq As string, _
    ByRef n As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef ifst As long, _
    ByRef ilst As long, _
    ByRef info As long, _
    ByVal COMPQLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRSEN Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal compq As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef w As Complex, _
    ByRef m As long, _
    ByRef s As double, _
    ByRef sep As double, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal COMPQLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal trana As string, _
    ByVal tranb As string, _
    ByRef isgn As long, _
    ByRef m As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef c As Complex, _
    ByRef ldc As long, _
    ByRef scal As double, _
    ByRef info As long, _
    ByVal TRANALength As LongLong, ByVal TRANBLength As LongLong _
    )

   Declare Ptrsafe Sub ZTREVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal howmny As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef vl As Complex, _
    ByRef ldvl As long, _
    ByRef vr As Complex, _
    ByRef ldvr As long, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub ZTRSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal howmny As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef t As Complex, _
    ByRef ldt As long, _
    ByRef vl As Complex, _
    ByRef ldvl As long, _
    ByRef vr As Complex, _
    ByRef ldvr As long, _
    ByRef s As double, _
    ByRef sep As double, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As Complex, _
    ByRef ldwork As long, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub DORCSD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu1 As string, ByVal jobu2 As string, ByVal jobv1t As string, _
    ByVal jobv2t As string, ByVal trans As string, ByVal signs As string, _
    ByRef m As long, ByRef p As long, ByRef q As long, _
    ByRef x11 As double, ByRef ldx11 As long, ByRef x12 As double, _
    ByRef ldx12 As long, ByRef x21 As double, ByRef ldx21 As long, _
    ByRef x22 As double, ByRef ldx22 As long, ByRef theta As double, _
    ByRef u1 As double, ByRef ldu1 As long, ByRef u2 As double, _
    ByRef ldu2 As long, ByRef v1t As double, ByRef ldv1t As long, _
    ByRef v2t As double, ByRef ldv2t As long, ByRef work As double, _
    ByRef lwork As long, ByRef iwork As long, ByRef info As long, _
    ByVal JOBU1Length As LongLong, ByVal JOBU2Length As LongLong, ByVal JOBV1TLength As LongLong, ByVal JOBV2TLength As LongLong, ByVal TRANSLength As LongLong, ByVal SIGNSLength As LongLong _
    )

   Declare Ptrsafe Sub ZUNCSD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu1 As string, ByVal jobu2 As string, ByVal jobv1t As string, _
    ByVal jobv2t As string, ByVal trans As string, ByVal signs As string, _
    ByRef m As long, ByRef p As long, ByRef q As long, _
    ByRef x11 As Complex, ByRef ldx11 As long, ByRef x12 As Complex, _
    ByRef ldx12 As long, ByRef x21 As Complex, ByRef ldx21 As long, _
    ByRef x22 As Complex, ByRef ldx22 As long, ByRef theta As double, _
    ByRef u1 As Complex, ByRef ldu1 As long, ByRef u2 As Complex, _
    ByRef ldu2 As long, ByRef v1t As Complex, ByRef ldv1t As long, _
    ByRef v2t As Complex, ByRef ldv2t As long, ByRef work As Complex, _
    ByRef lwork As long, ByRef rwork As double, ByRef lrwork As long, _
    ByRef iwork As long, ByRef info As long, _
    ByVal JOBU1Length As LongLong, ByVal JOBU2Length As LongLong, ByVal JOBV1TLength As LongLong, ByVal JOBV2TLength As LongLong, ByVal TRANSLength As LongLong, ByVal SIGNSLength As LongLong _
    )

   Declare Ptrsafe Sub DSYGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef w As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, ByVal jobz As string, ByVal range As string, _
    ByVal uplo As string, ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As double, ByRef ldz As long, _
    ByRef work As double, ByRef lwork As long, ByRef iwork As long, _
    ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef w As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSYGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef w As double, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, ByVal jobz As string, ByVal range As string, _
    ByVal uplo As string, ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As Complex, ByRef ldz As long, _
    ByRef work As Complex, ByRef lwork As long, ByRef rwork As double, _
    ByRef iwork As long, ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef w As double, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHEGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef bp As double, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, ByVal jobz As string, ByVal range As string, _
    ByVal uplo As string, ByRef n As long, ByRef ap As double, _
    ByRef bp As double, ByRef vl As double, ByRef vu As double, _
    ByRef il As long, ByRef iu As long, ByRef abstol As double, _
    ByRef m As long, ByRef w As double, ByRef z As double, _
    ByRef ldz As long, ByRef work As double, ByRef iwork As long, _
    ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef bp As double, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSPGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As double, _
    ByRef bp As double, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPGV Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef bp As Complex, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPGVX Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, ByVal jobz As string, ByVal range As string, _
    ByVal uplo As string, ByRef n As long, ByRef ap As Complex, _
    ByRef bp As Complex, ByRef vl As double, ByRef vu As double, _
    ByRef il As long, ByRef iu As long, ByRef abstol As double, _
    ByRef m As long, ByRef w As double, ByRef z As Complex, _
    ByRef ldz As long, ByRef work As Complex, ByRef rwork As double, _
    ByRef iwork As long, ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPGVD Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef bp As Complex, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHPGST Lib "NLW6I31DE_nag.dll" ( _
    ByRef itype As long, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ap As Complex, _
    ByRef bp As Complex, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBGV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ka As long, _
    ByRef kb As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef bb As double, _
    ByRef ldbb As long, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBGVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef ka As long, ByRef kb As long, _
    ByRef ab As double, ByRef ldab As long, ByRef bb As double, _
    ByRef ldbb As long, ByRef q As double, ByRef ldq As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As double, ByRef ldz As long, _
    ByRef work As double, ByRef iwork As long, ByRef jfail As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBGVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ka As long, _
    ByRef kb As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef bb As double, _
    ByRef ldbb As long, _
    ByRef w As double, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DSBGST Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ka As long, _
    ByRef kb As long, _
    ByRef ab As double, _
    ByRef ldab As long, _
    ByRef bb As double, _
    ByRef ldbb As long, _
    ByRef x As double, _
    ByRef ldx As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal VECTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DPBSTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kb As long, _
    ByRef bb As double, _
    ByRef ldbb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBGV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ka As long, _
    ByRef kb As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef bb As Complex, _
    ByRef ldbb As long, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBGVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, ByVal range As string, ByVal uplo As string, _
    ByRef n As long, ByRef ka As long, ByRef kb As long, _
    ByRef ab As Complex, ByRef ldab As long, ByRef bb As Complex, _
    ByRef ldbb As long, ByRef q As Complex, ByRef ldq As long, _
    ByRef vl As double, ByRef vu As double, ByRef il As long, _
    ByRef iu As long, ByRef abstol As double, ByRef m As long, _
    ByRef w As double, ByRef z As Complex, ByRef ldz As long, _
    ByRef work As Complex, ByRef rwork As double, ByRef iwork As long, _
    ByRef jfail As long, ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal RANGELength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBGVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobz As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ka As long, _
    ByRef kb As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef bb As Complex, _
    ByRef ldbb As long, _
    ByRef w As double, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef lrwork As long, _
    ByRef iwork As long, _
    ByRef liwork As long, _
    ByRef info As long, _
    ByVal JOBZLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZHBGST Lib "NLW6I31DE_nag.dll" ( _
    ByVal vect As string, _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef ka As long, _
    ByRef kb As long, _
    ByRef ab As Complex, _
    ByRef ldab As long, _
    ByRef bb As Complex, _
    ByRef ldbb As long, _
    ByRef x As Complex, _
    ByRef ldx As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal VECTLength As LongLong, ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub ZPBSTF Lib "NLW6I31DE_nag.dll" ( _
    ByVal uplo As string, _
    ByRef n As long, _
    ByRef kb As long, _
    ByRef bb As Complex, _
    ByRef ldbb As long, _
    ByRef info As long, _
    ByVal UPLOLength As LongLong _
    )

   Declare Ptrsafe Sub DGGSVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef n As long, ByRef p As long, _
    ByRef k As long, ByRef l As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef alpha As double, ByRef beta As double, ByRef u As double, _
    ByRef ldu As long, ByRef v As double, ByRef ldv As long, _
    ByRef q As double, ByRef ldq As long, ByRef work As double, _
    ByRef iwork As long, ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub DGGSVD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef n As long, ByRef p As long, _
    ByRef k As long, ByRef l As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef alpha As double, ByRef beta As double, ByRef u As double, _
    ByRef ldu As long, ByRef v As double, ByRef ldv As long, _
    ByRef q As double, ByRef ldq As long, ByRef work As double, _
    ByRef lwork As long, ByRef iwork As long, ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub DGGSVP Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef p As long, ByRef n As long, _
    ByRef a As double, ByRef lda As long, ByRef b As double, _
    ByRef ldb As long, ByRef tola As double, ByRef tolb As double, _
    ByRef k As long, ByRef l As long, ByRef u As double, _
    ByRef ldu As long, ByRef v As double, ByRef ldv As long, _
    ByRef q As double, ByRef ldq As long, ByRef iwork As long, _
    ByRef tau As double, ByRef work As double, ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub DGGSVP3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef p As long, ByRef n As long, _
    ByRef a As double, ByRef lda As long, ByRef b As double, _
    ByRef ldb As long, ByRef tola As double, ByRef tolb As double, _
    ByRef k As long, ByRef l As long, ByRef u As double, _
    ByRef ldu As long, ByRef v As double, ByRef ldv As long, _
    ByRef q As double, ByRef ldq As long, ByRef iwork As long, _
    ByRef tau As double, ByRef work As double, ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGSVD Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef n As long, ByRef p As long, _
    ByRef k As long, ByRef l As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef alpha As double, ByRef beta As double, ByRef u As Complex, _
    ByRef ldu As long, ByRef v As Complex, ByRef ldv As long, _
    ByRef q As Complex, ByRef ldq As long, ByRef work As Complex, _
    ByRef rwork As double, ByRef iwork As long, ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGSVD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef n As long, ByRef p As long, _
    ByRef k As long, ByRef l As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef alpha As double, ByRef beta As double, ByRef u As Complex, _
    ByRef ldu As long, ByRef v As Complex, ByRef ldv As long, _
    ByRef q As Complex, ByRef ldq As long, ByRef work As Complex, _
    ByRef lwork As long, ByRef rwork As double, ByRef iwork As long, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGSVP Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef p As long, ByRef n As long, _
    ByRef a As Complex, ByRef lda As long, ByRef b As Complex, _
    ByRef ldb As long, ByRef tola As double, ByRef tolb As double, _
    ByRef k As long, ByRef l As long, ByRef u As Complex, _
    ByRef ldu As long, ByRef v As Complex, ByRef ldv As long, _
    ByRef q As Complex, ByRef ldq As long, ByRef iwork As long, _
    ByRef rwork As double, ByRef tau As Complex, ByRef work As Complex, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGSVP3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef p As long, ByRef n As long, _
    ByRef a As Complex, ByRef lda As long, ByRef b As Complex, _
    ByRef ldb As long, ByRef tola As double, ByRef tolb As double, _
    ByRef k As long, ByRef l As long, ByRef u As Complex, _
    ByRef ldu As long, ByRef v As Complex, ByRef ldv As long, _
    ByRef q As Complex, ByRef ldq As long, ByRef iwork As long, _
    ByRef rwork As double, ByRef tau As Complex, ByRef work As Complex, _
    ByRef lwork As long, ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub DGGEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvl As string, _
    ByVal jobvr As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef alphar As double, _
    ByRef alphai As double, _
    ByRef beta As double, _
    ByRef vl As double, _
    ByRef ldvl As long, _
    ByRef vr As double, _
    ByRef ldvr As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong _
    )

   Declare Ptrsafe Sub DGGEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal balanc As string, ByVal jobvl As string, ByVal jobvr As string, _
    ByVal sense As string, ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef alphar As double, ByRef alphai As double, ByRef beta As double, _
    ByRef vl As double, ByRef ldvl As long, ByRef vr As double, _
    ByRef ldvr As long, ByRef ilo As long, ByRef ihi As long, _
    ByRef lscale As double, ByRef rscale As double, ByRef abnrm As double, _
    ByRef bbnrm As double, ByRef rconde As double, ByRef rcondv As double, _
    ByRef work As double, ByRef lwork As long, ByRef iwork As long, _
    ByRef bwork As long, ByRef info As long, _
    ByVal BALANCLength As LongLong, ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong, ByVal SENSELength As LongLong _
    )

   Declare Ptrsafe Sub DGGEV3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvl As string, _
    ByVal jobvr As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef alphar As double, _
    ByRef alphai As double, _
    ByRef beta As double, _
    ByRef vl As double, _
    ByRef ldvl As long, _
    ByRef vr As double, _
    ByRef ldvr As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong _
    )

   Declare Ptrsafe Sub DGGHRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal compq As string, _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef info As long, _
    ByVal COMPQLength As LongLong, ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub DGGHD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal compq As string, _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal COMPQLength As LongLong, ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub DGGBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef lscale As double, _
    ByRef rscale As double, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong _
    )

   Declare Ptrsafe Sub DGGBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal side As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef lscale As double, _
    ByRef rscale As double, _
    ByRef m As long, _
    ByRef v As double, _
    ByRef ldv As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal SIDELength As LongLong _
    )

   Declare Ptrsafe Sub ZGGEV Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvl As string, _
    ByVal jobvr As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef alpha As Complex, _
    ByRef beta As Complex, _
    ByRef vl As Complex, _
    ByRef ldvl As long, _
    ByRef vr As Complex, _
    ByRef ldvr As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGEVX Lib "NLW6I31DE_nag.dll" ( _
    ByVal balanc As string, ByVal jobvl As string, ByVal jobvr As string, _
    ByVal sense As string, ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef alpha As Complex, ByRef beta As Complex, ByRef vl As Complex, _
    ByRef ldvl As long, ByRef vr As Complex, ByRef ldvr As long, _
    ByRef ilo As long, ByRef ihi As long, ByRef lscale As double, _
    ByRef rscale As double, ByRef abnrm As double, ByRef bbnrm As double, _
    ByRef rconde As double, ByRef rcondv As double, ByRef work As Complex, _
    ByRef lwork As long, ByRef rwork As double, ByRef iwork As long, _
    ByRef bwork As long, ByRef info As long, _
    ByVal BALANCLength As LongLong, ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong, ByVal SENSELength As LongLong _
    )

   Declare Ptrsafe Sub ZGGEV3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvl As string, _
    ByVal jobvr As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef alpha As Complex, _
    ByRef beta As Complex, _
    ByRef vl As Complex, _
    ByRef ldvl As long, _
    ByRef vr As Complex, _
    ByRef ldvr As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal JOBVLLength As LongLong, ByVal JOBVRLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGHRD Lib "NLW6I31DE_nag.dll" ( _
    ByVal compq As string, _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef info As long, _
    ByVal COMPQLength As LongLong, ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGHD3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal compq As string, _
    ByVal compz As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long, _
    ByVal COMPQLength As LongLong, ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGBAL Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef lscale As double, _
    ByRef rscale As double, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal JOBLength As LongLong _
    )

   Declare Ptrsafe Sub ZGGBAK Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, _
    ByVal side As string, _
    ByRef n As long, _
    ByRef ilo As long, _
    ByRef ihi As long, _
    ByRef lscale As double, _
    ByRef rscale As double, _
    ByRef m As long, _
    ByRef v As Complex, _
    ByRef ldv As long, _
    ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal SIDELength As LongLong _
    )

' skeleton code for callback function
'  Function DGGES_SELCTG( _
'      ByRef ar As double, _
'      ByRef ai As double, _
'      ByRef b As double _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub DGGES Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvsl As string, ByVal jobvsr As string, ByVal sort As string, _
    ByVal selctg As longPtr, _
    ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef sdim As long, ByRef alphar As double, ByRef alphai As double, _
    ByRef beta As double, ByRef vsl As double, ByRef ldvsl As long, _
    ByRef vsr As double, ByRef ldvsr As long, ByRef work As double, _
    ByRef lwork As long, ByRef bwork As long, ByRef info As long, _
    ByVal JOBVSLLength As LongLong, ByVal JOBVSRLength As LongLong, ByVal SORTLength As LongLong _
    )

' skeleton code for callback function
'  Function DGGESX_SELCTG( _
'      ByRef ar As double, _
'      ByRef ai As double, _
'      ByRef b As double _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub DGGESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvsl As string, ByVal jobvsr As string, ByVal sort As string, _
    ByVal selctg As longPtr, _
    ByVal sense As string, ByRef n As long, _
    ByRef a As double, ByRef lda As long, ByRef b As double, _
    ByRef ldb As long, ByRef sdim As long, ByRef alphar As double, _
    ByRef alphai As double, ByRef beta As double, ByRef vsl As double, _
    ByRef ldvsl As long, ByRef vsr As double, ByRef ldvsr As long, _
    ByRef rconde As double, ByRef rcondv As double, ByRef work As double, _
    ByRef lwork As long, ByRef iwork As long, ByRef liwork As long, _
    ByRef bwork As long, ByRef info As long, _
    ByVal JOBVSLLength As LongLong, ByVal JOBVSRLength As LongLong, ByVal SORTLength As LongLong, ByVal SENSELength As LongLong _
    )

' skeleton code for callback function
'  Function DGGES3_SELCTG( _
'      ByRef ar As double, _
'      ByRef ai As double, _
'      ByRef b As double _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub DGGES3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvsl As string, ByVal jobvsr As string, ByVal sort As string, _
    ByVal selctg As longPtr, _
    ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef sdim As long, ByRef alphar As double, ByRef alphai As double, _
    ByRef beta As double, ByRef vsl As double, ByRef ldvsl As long, _
    ByRef vsr As double, ByRef ldvsr As long, ByRef work As double, _
    ByRef lwork As long, ByRef bwork As long, ByRef info As long, _
    ByVal JOBVSLLength As LongLong, ByVal JOBVSRLength As LongLong, ByVal SORTLength As LongLong _
    )

   Declare Ptrsafe Sub DHGEQZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, ByVal compq As string, ByVal compz As string, _
    ByRef n As long, ByRef ilo As long, ByRef ihi As long, _
    ByRef a As double, ByRef lda As long, ByRef b As double, _
    ByRef ldb As long, ByRef alphar As double, ByRef alphai As double, _
    ByRef beta As double, ByRef q As double, ByRef ldq As long, _
    ByRef z As double, ByRef ldz As long, ByRef work As double, _
    ByRef lwork As long, ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal COMPQLength As LongLong, ByVal COMPZLength As LongLong _
    )

' skeleton code for callback function
'  Function ZGGES_SELCTG( _
'      ByRef a As Complex, _
'      ByRef b As Complex _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub ZGGES Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvsl As string, ByVal jobvsr As string, ByVal sort As string, _
    ByVal selctg As longPtr, _
    ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef sdim As long, ByRef alpha As Complex, ByRef beta As Complex, _
    ByRef vsl As Complex, ByRef ldvsl As long, ByRef vsr As Complex, _
    ByRef ldvsr As long, ByRef work As Complex, ByRef lwork As long, _
    ByRef rwork As double, ByRef bwork As long, ByRef info As long, _
    ByVal JOBVSLLength As LongLong, ByVal JOBVSRLength As LongLong, ByVal SORTLength As LongLong _
    )

' skeleton code for callback function
'  Function ZGGESX_SELCTG( _
'      ByRef a As Complex, _
'      ByRef b As Complex _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub ZGGESX Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvsl As string, ByVal jobvsr As string, ByVal sort As string, _
    ByVal selctg As longPtr, _
    ByVal sense As string, ByRef n As long, _
    ByRef a As Complex, ByRef lda As long, ByRef b As Complex, _
    ByRef ldb As long, ByRef sdim As long, ByRef alpha As Complex, _
    ByRef beta As Complex, ByRef vsl As Complex, ByRef ldvsl As long, _
    ByRef vsr As Complex, ByRef ldvsr As long, ByRef rconde As double, _
    ByRef rcondv As double, ByRef work As Complex, ByRef lwork As long, _
    ByRef rwork As double, ByRef iwork As long, ByRef liwork As long, _
    ByRef bwork As long, ByRef info As long, _
    ByVal JOBVSLLength As LongLong, ByVal JOBVSRLength As LongLong, ByVal SORTLength As LongLong, ByVal SENSELength As LongLong _
    )

' skeleton code for callback function
'  Function ZGGES3_SELCTG( _
'      ByRef a As Complex, _
'      ByRef b As Complex _
'    ) As long
'      ' your code here
'  End Function

   Declare Ptrsafe Sub ZGGES3 Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobvsl As string, ByVal jobvsr As string, ByVal sort As string, _
    ByVal selctg As longPtr, _
    ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef sdim As long, ByRef alpha As Complex, ByRef beta As Complex, _
    ByRef vsl As Complex, ByRef ldvsl As long, ByRef vsr As Complex, _
    ByRef ldvsr As long, ByRef work As Complex, ByRef lwork As long, _
    ByRef rwork As double, ByRef bwork As long, ByRef info As long, _
    ByVal JOBVSLLength As LongLong, ByVal JOBVSRLength As LongLong, ByVal SORTLength As LongLong _
    )

   Declare Ptrsafe Sub ZHGEQZ Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, ByVal compq As string, ByVal compz As string, _
    ByRef n As long, ByRef ilo As long, ByRef ihi As long, _
    ByRef a As Complex, ByRef lda As long, ByRef b As Complex, _
    ByRef ldb As long, ByRef alpha As Complex, ByRef beta As Complex, _
    ByRef q As Complex, ByRef ldq As long, ByRef z As Complex, _
    ByRef ldz As long, ByRef work As Complex, ByRef lwork As long, _
    ByRef rwork As double, ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal COMPQLength As LongLong, ByVal COMPZLength As LongLong _
    )

   Declare Ptrsafe Sub DTGSJA Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef p As long, ByRef n As long, _
    ByRef k As long, ByRef l As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef tola As double, ByRef tolb As double, ByRef alpha As double, _
    ByRef beta As double, ByRef u As double, ByRef ldu As long, _
    ByRef v As double, ByRef ldv As long, ByRef q As double, _
    ByRef ldq As long, ByRef work As double, ByRef ncycle As long, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub DTGEXC Lib "NLW6I31DE_nag.dll" ( _
    ByRef wantq As long, _
    ByRef wantz As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef q As double, _
    ByRef ldq As long, _
    ByRef z As double, _
    ByRef ldz As long, _
    ByRef ifst As long, _
    ByRef ilst As long, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DTGSEN Lib "NLW6I31DE_nag.dll" ( _
    ByRef ijob As long, ByRef wantq As long, ByRef wantz As long, _
    ByRef sel As long, ByRef n As long, ByRef a As double, _
    ByRef lda As long, ByRef b As double, ByRef ldb As long, _
    ByRef alphar As double, ByRef alphai As double, ByRef beta As double, _
    ByRef q As double, ByRef ldq As long, ByRef z As double, _
    ByRef ldz As long, ByRef m As long, ByRef pl As double, _
    ByRef pr As double, ByRef dif As double, ByRef work As double, _
    ByRef lwork As long, ByRef iwork As long, ByRef liwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DTGSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, ByRef ijob As long, ByRef m As long, _
    ByRef n As long, ByRef a As double, ByRef lda As long, _
    ByRef b As double, ByRef ldb As long, ByRef c As double, _
    ByRef ldc As long, ByRef d As double, ByRef ldd As long, _
    ByRef e As double, ByRef lde As long, ByRef f As double, _
    ByRef ldf As long, ByRef scal As double, ByRef dif As double, _
    ByRef work As double, ByRef lwork As long, ByRef iwork As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub DTGEVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal howmny As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef vl As double, _
    ByRef ldvl As long, _
    ByRef vr As double, _
    ByRef ldvr As long, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As double, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub DTGSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, ByVal howmny As string, ByRef sel As long, _
    ByRef n As long, ByRef a As double, ByRef lda As long, _
    ByRef b As double, ByRef ldb As long, ByRef vl As double, _
    ByRef ldvl As long, ByRef vr As double, ByRef ldvr As long, _
    ByRef s As double, ByRef dif As double, ByRef mm As long, _
    ByRef m As long, ByRef work As double, ByRef lwork As long, _
    ByRef iwork As long, ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub ZTGSJA Lib "NLW6I31DE_nag.dll" ( _
    ByVal jobu As string, ByVal jobv As string, ByVal jobq As string, _
    ByRef m As long, ByRef p As long, ByRef n As long, _
    ByRef k As long, ByRef l As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef tola As double, ByRef tolb As double, ByRef alpha As double, _
    ByRef beta As double, ByRef u As Complex, ByRef ldu As long, _
    ByRef v As Complex, ByRef ldv As long, ByRef q As Complex, _
    ByRef ldq As long, ByRef work As Complex, ByRef ncycle As long, _
    ByRef info As long, _
    ByVal JOBULength As LongLong, ByVal JOBVLength As LongLong, ByVal JOBQLength As LongLong _
    )

   Declare Ptrsafe Sub ZTGEXC Lib "NLW6I31DE_nag.dll" ( _
    ByRef wantq As long, _
    ByRef wantz As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef q As Complex, _
    ByRef ldq As long, _
    ByRef z As Complex, _
    ByRef ldz As long, _
    ByRef ifst As long, _
    ByRef ilst As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZTGSEN Lib "NLW6I31DE_nag.dll" ( _
    ByRef ijob As long, ByRef wantq As long, ByRef wantz As long, _
    ByRef sel As long, ByRef n As long, ByRef a As Complex, _
    ByRef lda As long, ByRef b As Complex, ByRef ldb As long, _
    ByRef alpha As Complex, ByRef beta As Complex, ByRef q As Complex, _
    ByRef ldq As long, ByRef z As Complex, ByRef ldz As long, _
    ByRef m As long, ByRef pl As double, ByRef pr As double, _
    ByRef dif As double, ByRef work As Complex, ByRef lwork As long, _
    ByRef iwork As long, ByRef liwork As long, ByRef info As long _
   )

   Declare Ptrsafe Sub ZTGSYL Lib "NLW6I31DE_nag.dll" ( _
    ByVal trans As string, ByRef ijob As long, ByRef m As long, _
    ByRef n As long, ByRef a As Complex, ByRef lda As long, _
    ByRef b As Complex, ByRef ldb As long, ByRef c As Complex, _
    ByRef ldc As long, ByRef d As Complex, ByRef ldd As long, _
    ByRef e As Complex, ByRef lde As long, ByRef f As Complex, _
    ByRef ldf As long, ByRef scal As double, ByRef dif As double, _
    ByRef work As Complex, ByRef lwork As long, ByRef iwork As long, _
    ByRef info As long, _
    ByVal TRANSLength As LongLong _
    )

   Declare Ptrsafe Sub ZTGEVC Lib "NLW6I31DE_nag.dll" ( _
    ByVal side As string, _
    ByVal howmny As string, _
    ByRef sel As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef vl As Complex, _
    ByRef ldvl As long, _
    ByRef vr As Complex, _
    ByRef ldvr As long, _
    ByRef mm As long, _
    ByRef m As long, _
    ByRef work As Complex, _
    ByRef rwork As double, _
    ByRef info As long, _
    ByVal SIDELength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub ZTGSNA Lib "NLW6I31DE_nag.dll" ( _
    ByVal job As string, ByVal howmny As string, ByRef sel As long, _
    ByRef n As long, ByRef a As Complex, ByRef lda As long, _
    ByRef b As Complex, ByRef ldb As long, ByRef vl As Complex, _
    ByRef ldvl As long, ByRef vr As Complex, ByRef ldvr As long, _
    ByRef s As double, ByRef dif As double, ByRef mm As long, _
    ByRef m As long, ByRef work As Complex, ByRef lwork As long, _
    ByRef iwork As long, ByRef info As long, _
    ByVal JOBLength As LongLong, ByVal HOWMNYLength As LongLong _
    )

   Declare Ptrsafe Sub DGGLSE Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef p As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef c As double, _
    ByRef d As double, _
    ByRef x As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGGGLM Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef p As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef d As double, _
    ByRef x As double, _
    ByRef y As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGGQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef m As long, _
    ByRef p As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef taua As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef taub As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub DGGRQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef p As long, _
    ByRef n As long, _
    ByRef a As double, _
    ByRef lda As long, _
    ByRef taua As double, _
    ByRef b As double, _
    ByRef ldb As long, _
    ByRef taub As double, _
    ByRef work As double, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGGLSE Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef p As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef c As Complex, _
    ByRef d As Complex, _
    ByRef x As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGGGLM Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef n As long, _
    ByRef p As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef d As Complex, _
    ByRef x As Complex, _
    ByRef y As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGGQRF Lib "NLW6I31DE_nag.dll" ( _
    ByRef n As long, _
    ByRef m As long, _
    ByRef p As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef taua As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef taub As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

   Declare Ptrsafe Sub ZGGRQF Lib "NLW6I31DE_nag.dll" ( _
    ByRef m As long, _
    ByRef p As long, _
    ByRef n As long, _
    ByRef a As Complex, _
    ByRef lda As long, _
    ByRef taua As Complex, _
    ByRef b As Complex, _
    ByRef ldb As long, _
    ByRef taub As Complex, _
    ByRef work As Complex, _
    ByRef lwork As long, _
    ByRef info As long _
   )

