

// C# declare statements for NAG Fortran Library DLL Mark 31.0
// Copyright 2025, Numerical Algorithms Group Ltd, Oxford, UK.

namespace NagLibrary
{
using System;
using System.Text;
using System.Runtime.InteropServices;

public static class nag_declarations
{


public const int NAGTRUE = -1;
public const int NAGFALSE = 0;

[StructLayout(LayoutKind.Sequential)] 
 public struct Complex
{
  public double Real_Part;
  public double Imag_Part;
}

[StructLayout(LayoutKind.Sequential)] 
 public struct ComplexSingle
{
  public float Real_Part;
  public float Imag_Part;
}


// chapter a00

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void A00AAF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool A00ACF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void A00ADF(
    StringBuilder IMPL,
    StringBuilder PREC,
    StringBuilder PCODE,
    ref int MKMAJ,
    ref int MKMIN,
    StringBuilder HDWARE,
    StringBuilder OPSYS,
    StringBuilder FCOMP,
    StringBuilder VEND,
    ref int LICVAL
,
    long IMPLLength,
    long PRECLength,
    long PCODELength,
    long HDWARELength,
    long OPSYSLength,
    long FCOMPLength,
    long VENDLength
    );


// chapter a02

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void A02AAF(
    ref double XR,
    ref double XI,
    ref double YR,
    ref double YI
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double A02ABF(
    ref double XR,
    ref double XI
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void A02ACF(
    ref double XR,
    ref double XI,
    ref double YR,
    ref double YI,
    ref double ZR,
    ref double ZI
   );


// chapter c02

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02AAF(
    [In] Complex[] A,
    ref int N,
    ref int ITMAX,
    ref int POLISH,
    [Out] Complex[] Z,
    [Out] double[] BERR,
    [Out] double[] COND,
    [Out] int[] CONV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02ABF(
    [In] double[] A,
    ref int N,
    ref int ITMAX,
    ref int POLISH,
    [Out] Complex[] Z,
    [Out] double[] BERR,
    [Out] double[] COND,
    [Out] int[] CONV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02AFF(
    [In] double[,] A,
    ref int N,
    ref int SCAL,
    [Out] double[,] Z,
    [Out] double[] W,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02AGF(
    [In] double[] A,
    ref int N,
    ref int SCAL,
    [Out] double[,] Z,
    [Out] double[] W,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02AHF(
    ref double AR,
    ref double AI,
    ref double BR,
    ref double BI,
    ref double CR,
    ref double CI,
    [Out] double[] ZSM,
    [Out] double[] ZLG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02AJF(
    ref double A,
    ref double B,
    ref double C,
    [Out] double[] ZSM,
    [Out] double[] ZLG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02AKF(
    ref double U,
    ref double R,
    ref double S,
    ref double T,
    [Out] double[] ZEROR,
    [Out] double[] ZEROI,
    [Out] double[] ERREST,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02ALF(
    ref double E,
    ref double A,
    ref double B,
    ref double C,
    ref double D,
    [Out] double[] ZEROR,
    [Out] double[] ZEROI,
    [Out] double[] ERREST,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02AMF(
    ref Complex U,
    ref Complex R,
    ref Complex S,
    ref Complex T,
    [Out] double[] ZEROR,
    [Out] double[] ZEROI,
    [Out] double[] ERREST,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C02ANF(
    ref Complex E,
    ref Complex A,
    ref Complex B,
    ref Complex C,
    ref Complex D,
    [Out] double[] ZEROR,
    [Out] double[] ZEROI,
    [Out] double[] ERREST,
    ref int IFAIL
   );


// chapter c05

public delegate double C05AUF_F_DELEGATE(
    ref double X,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05AUF(
    ref double X,
    ref double H,
    ref double EPS,
    ref double ETA,
    C05AUF_F_DELEGATE F,
    ref double A,
    ref double B,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05AVF(
    ref double X,
    ref double FX,
    ref double H,
    ref double BOUNDL,
    ref double BOUNDU,
    ref double Y,
    [In,Out] double[] C,
    ref int IND,
    ref int IFAIL
   );


public delegate double C05AWF_F_DELEGATE(
    ref double X,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05AWF(
    ref double X,
    ref double EPS,
    ref double ETA,
    C05AWF_F_DELEGATE F,
    ref int NFMAX,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05AXF(
    ref double X,
    ref double FX,
    ref double TOL,
    ref int IR,
    ref double SCAL,
    [In,Out] double[] C,
    ref int IND,
    ref int IFAIL
   );


public delegate double C05AYF_F_DELEGATE(
    ref double X,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05AYF(
    ref double A,
    ref double B,
    ref double EPS,
    ref double ETA,
    C05AYF_F_DELEGATE F,
    ref double X,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05AZF(
    ref double X,
    ref double Y,
    ref double FX,
    ref double TOLX,
    ref int IR,
    [In,Out] double[] C,
    ref int IND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double C05BAF(
    ref double X,
    ref int BRANCH,
    ref int OFFSET,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05BBF(
    ref int BRANCH,
    ref int OFFSET,
    ref Complex Z,
    ref Complex W,
    ref double RESID,
    ref int IFAIL
   );


public delegate void C05MBF_FCN_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    IntPtr FVEC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int IFLAG
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05MBF(
    C05MBF_FCN_DELEGATE FCN,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] FVEC,
    ref double ATOL,
    ref double RTOL,
    ref int M,
    ref double CNDTOL,
    ref int ASTART,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05MDF(
    ref int IREVCM,
    ref int N,
    [In,Out] double[] X,
    [In,Out] double[] FVEC,
    ref double ATOL,
    ref double RTOL,
    ref int M,
    ref double CNDTOL,
    ref int ASTART,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


public delegate void C05QBF_FCN_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    IntPtr FVEC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int IFLAG
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05QBF(
    C05QBF_FCN_DELEGATE FCN,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] FVEC,
    ref double XTOL,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void C05QCF_FCN_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    IntPtr FVEC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int IFLAG
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05QCF(
    C05QCF_FCN_DELEGATE FCN, ref int N, [In,Out] double[] X,
    [Out] double[] FVEC, ref double XTOL, ref int MAXFEV,
    ref int ML, ref int MU, ref double EPSFCN,
    ref int MODE, [In,Out] double[] DIAG, ref double FACTOR,
    ref int NPRINT, ref int NFEV, [Out] double[,] FJAC,
    [Out] double[] R, [Out] double[] QTF, [In,Out] int[] IUSER,
    [In,Out] double[] RUSER, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05QDF(
    ref int IREVCM,
    ref int N,
    [In,Out] double[] X,
    [In,Out] double[] FVEC,
    ref double XTOL,
    ref int ML,
    ref int MU,
    ref double EPSFCN,
    ref int MODE,
    [In,Out] double[] DIAG,
    ref double FACTOR,
    [In,Out] double[,] FJAC,
    [In,Out] double[] R,
    [In,Out] double[] QTF,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


public delegate void C05QSF_FCN_DELEGATE(
    ref int N,
    ref int LINDF,
    IntPtr INDF_iptr,
    IntPtr X_rptr,
    IntPtr FVEC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int IFLAG
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05QSF(
    C05QSF_FCN_DELEGATE FCN,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] FVEC,
    ref double XTOL,
    ref int INIT,
    [In,Out] double[] RCOMM,
    ref int LRCOMM,
    [In,Out] int[] ICOMM,
    ref int LICOMM,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void C05RBF_FCN_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int IFLAG
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05RBF(
    C05RBF_FCN_DELEGATE FCN,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] FVEC,
    [Out] double[,] FJAC,
    ref double XTOL,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void C05RCF_FCN_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int IFLAG
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05RCF(
    C05RCF_FCN_DELEGATE FCN,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] FVEC,
    [Out] double[,] FJAC,
    ref double XTOL,
    ref int MAXFEV,
    ref int MODE,
    [In,Out] double[] DIAG,
    ref double FACTOR,
    ref int NPRINT,
    ref int NFEV,
    ref int NJEV,
    [Out] double[] R,
    [Out] double[] QTF,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05RDF(
    ref int IREVCM,
    ref int N,
    [In,Out] double[] X,
    [In,Out] double[] FVEC,
    [In,Out] double[,] FJAC,
    ref double XTOL,
    ref int MODE,
    [In,Out] double[] DIAG,
    ref double FACTOR,
    [In,Out] double[] R,
    [In,Out] double[] QTF,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C05ZDF(
    ref int MODE,
    ref int M,
    ref int N,
    [In] double[] X,
    [In] double[] FVEC,
    [In] double[,] FJAC,
    [Out] double[] XP,
    [In] double[] FVECP,
    [Out] double[] ERR,
    ref int IFAIL
   );


// chapter c06

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06BAF(
    ref double SEQN,
    ref int NCALL,
    ref double RESULT,
    ref double ABSERR,
    [In,Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06DCF(
    [In] double[] X,
    ref int LX,
    ref double XMIN,
    ref double XMAX,
    [In] double[] C,
    ref int N,
    ref int S,
    [Out] double[] RES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06FAF(
    [In,Out] double[] X,
    ref int N,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06FBF(
    [In,Out] double[] X,
    ref int N,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06FCF(
    [In,Out] double[] X,
    [In,Out] double[] Y,
    ref int N,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06FFF(
    ref int NDIM,
    ref int L,
    [In] int[] ND,
    ref int N,
    [In,Out] double[] X,
    [In,Out] double[] Y,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06FJF(
    ref int NDIM,
    [In] int[] ND,
    ref int N,
    [In,Out] double[] X,
    [In,Out] double[] Y,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06FKF(
    ref int JOB,
    [In,Out] double[] X,
    [In,Out] double[] Y,
    ref int N,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06FXF(
    ref int N1,
    ref int N2,
    ref int N3,
    [In,Out] double[] X,
    [In,Out] double[] Y,
    string INIT,
    [In,Out] double[] TRIGN1,
    [In,Out] double[] TRIGN2,
    [In,Out] double[] TRIGN3,
    [Out] double[] WORK,
    ref int IFAIL
,
    long INITLength
    );


public delegate void C06LAF_F_DELEGATE(
    ref double PR,
    ref double PI,
    ref double FR,
    ref double FI
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06LAF(
    C06LAF_F_DELEGATE F,
    ref int N,
    [In] double[] T,
    [Out] double[] VALINV,
    [Out] double[] ERREST,
    ref double RELERR,
    ref double ALPHAB,
    ref double TFAC,
    ref int MXTERM,
    ref int NTERMS,
    ref int NA,
    ref double ALOW,
    ref double AHIGH,
    ref int NFEVAL,
    [Out] double[] WORK,
    ref int IFAIL
   );


public delegate Complex C06LBF_F_DELEGATE(
    ref Complex S
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06LBF(
    C06LBF_F_DELEGATE F,
    ref double SIGMA0,
    ref double SIGMA,
    ref double B,
    ref double EPSTOL,
    ref int MMAX,
    ref int M,
    [Out] double[] ACOEF,
    [Out] double[] ERRVEC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06LCF(
    ref double T,
    ref double SIGMA,
    ref double B,
    ref int M,
    [In] double[] ACOEF,
    [In] double[] ERRVEC,
    ref double FINV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PAF(
    string DIRECT,
    [In,Out] double[] X,
    ref int N,
    [Out] double[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PCF(
    string DIRECT,
    [In,Out] Complex[] X,
    ref int N,
    [Out] Complex[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PFF(
    string DIRECT,
    ref int NDIM,
    ref int L,
    [In] int[] ND,
    ref int N,
    [In,Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PJF(
    string DIRECT,
    ref int NDIM,
    [In] int[] ND,
    ref int N,
    [In,Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PKF(
    ref int JOB,
    [In,Out] Complex[] X,
    [In,Out] Complex[] Y,
    ref int N,
    [Out] Complex[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PPF(
    string DIRECT,
    ref int M,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PQF(
    string DIRECT,
    ref int N,
    ref int M,
    [In,Out] double[] X,
    [Out] double[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PRF(
    string DIRECT,
    ref int M,
    ref int N,
    [In,Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PSF(
    string DIRECT,
    ref int N,
    ref int M,
    [In,Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PUF(
    string DIRECT,
    ref int M,
    ref int N,
    [In,Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PVF(
    ref int M,
    ref int N,
    [In] double[] X,
    [Out] Complex[] Y,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PWF(
    ref int M,
    ref int N,
    [In] Complex[] Y,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PXF(
    string DIRECT,
    ref int N1,
    ref int N2,
    ref int N3,
    [In,Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PYF(
    ref int N1,
    ref int N2,
    ref int N3,
    [In] double[] X,
    [Out] Complex[] Y,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06PZF(
    ref int N1,
    ref int N2,
    ref int N3,
    [In] Complex[] Y,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06RAF(
    ref int M,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06RBF(
    ref int M,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06RCF(
    string DIRECT,
    ref int M,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06RDF(
    string DIRECT,
    ref int M,
    ref int N,
    [In,Out] double[] X,
    [Out] double[] WORK,
    ref int IFAIL
,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06REF(
    ref int M,
    ref int N,
    [In,Out] double[,] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06RFF(
    ref int M,
    ref int N,
    [In,Out] double[,] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06RGF(
    ref int IDIR,
    ref int M,
    ref int N,
    [In,Out] double[,] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06RHF(
    ref int IDIR,
    ref int M,
    ref int N,
    [In,Out] double[,] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C06SAF(
    ref int D,
    [In] double[,] SRCS,
    ref int N,
    [In] double[,] TRGS,
    ref int M,
    [In] double[] Q,
    ref int P1,
    ref int P2,
    ref int K,
    [In] double[] HIN,
    ref int LHIN,
    ref double TOL,
    [Out] double[] V,
    [Out] double[] TERM,
    ref int IFAIL
   );


// chapter c09

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09AAF(
    string WAVNAM,
    string WTRANS,
    string MODE,
    ref int N,
    ref int NWLMAX,
    ref int NF,
    ref int NWC,
    [Out] int[] ICOMM,
    ref int IFAIL
,
    long WAVNAMLength,
    long WTRANSLength,
    long MODELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09ABF(
    string WAVNAM,
    string WTRANS,
    string MODE,
    ref int M,
    ref int N,
    ref int NWLMAX,
    ref int NF,
    ref int NWCT,
    ref int NWCN,
    [Out] int[] ICOMM,
    ref int IFAIL
,
    long WAVNAMLength,
    long WTRANSLength,
    long MODELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09ACF(
    string WAVNAM,
    string WTRANS,
    string MODE,
    ref int M,
    ref int N,
    ref int FR,
    ref int NWLMAX,
    ref int NF,
    ref int NWCT,
    ref int NWCN,
    ref int NWCFR,
    [Out] int[] ICOMM,
    ref int IFAIL
,
    long WAVNAMLength,
    long WTRANSLength,
    long MODELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09BAF(
    string WAVNAM,
    ref int WPARAM,
    ref int N,
    [In] double[] X,
    ref int NSCAL,
    [In] int[] SCALES,
    [Out] double[,] C,
    ref int IFAIL
,
    long WAVNAMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09CAF(
    ref int N,
    [In] double[] X,
    ref int LENC,
    [Out] double[] CA,
    [Out] double[] CD,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09CBF(
    ref int LENC,
    [In] double[] CA,
    [In] double[] CD,
    ref int N,
    [Out] double[] Y,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09CCF(
    ref int N,
    [In] double[] X,
    ref int LENC,
    [Out] double[] C,
    ref int NWL,
    [Out] int[] DWTLEV,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09CDF(
    ref int NWLINV,
    ref int LENC,
    [In] double[] C,
    ref int N,
    [Out] double[] Y,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09DAF(
    ref int N,
    [In] double[] X,
    ref int LENC,
    [Out] double[] CA,
    [Out] double[] CD,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09DBF(
    ref int LENC,
    [In] double[] CA,
    [In] double[] CD,
    ref int N,
    [Out] double[] Y,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09DCF(
    ref int N,
    [In] double[] X,
    string KEEPA,
    ref int LENC,
    [Out] double[] C,
    ref int NWL,
    ref int NA,
    [In,Out] int[] ICOMM,
    ref int IFAIL
,
    long KEEPALength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09DDF(
    ref int NWLINV,
    string KEEPA,
    ref int LENC,
    [In] double[] C,
    ref int N,
    [Out] double[] Y,
    [In] int[] ICOMM,
    ref int IFAIL
,
    long KEEPALength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09EAF(
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[,] CA,
    ref int LDCA,
    [Out] double[,] CH,
    ref int LDCH,
    [Out] double[,] CV,
    ref int LDCV,
    [Out] double[,] CD,
    ref int LDCD,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09EBF(
    ref int M,
    ref int N,
    [In] double[,] CA,
    ref int LDCA,
    [In] double[,] CH,
    ref int LDCH,
    [In] double[,] CV,
    ref int LDCV,
    [In] double[,] CD,
    ref int LDCD,
    [Out] double[,] B,
    ref int LDB,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09ECF(
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref int LENC,
    [Out] double[] C,
    ref int NWL,
    [Out] int[] DWTLVM,
    [Out] int[] DWTLVN,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09EDF(
    ref int NWLINV,
    ref int LENC,
    [In] double[] C,
    ref int M,
    ref int N,
    [Out] double[,] B,
    ref int LDB,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09EYF(
    ref int ILEV,
    ref int CINDEX,
    ref int LENC,
    [In] double[] C,
    [Out] double[,] D,
    ref int LDD,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09EZF(
    ref int ILEV,
    ref int CINDEX,
    ref int LENC,
    [In,Out] double[] C,
    [In] double[,] D,
    ref int LDD,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09FAF(
    ref int M,
    ref int N,
    ref int FR,
    [In] double[,,] A,
    ref int LDA,
    ref int SDA,
    ref int LENC,
    [Out] double[] C,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09FBF(
    ref int M,
    ref int N,
    ref int FR,
    ref int LENC,
    [In] double[] C,
    [Out] double[,,] B,
    ref int LDB,
    ref int SDB,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09FCF(
    ref int M,
    ref int N,
    ref int FR,
    [In] double[,,] A,
    ref int LDA,
    ref int SDA,
    ref int LENC,
    [Out] double[] C,
    ref int NWL,
    [Out] int[] DWTLVM,
    [Out] int[] DWTLVN,
    [Out] int[] DWTLVFR,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09FDF(
    ref int NWLINV,
    ref int LENC,
    [In] double[] C,
    ref int M,
    ref int N,
    ref int FR,
    [Out] double[,,] B,
    ref int LDB,
    ref int SDB,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09FYF(
    ref int ILEV,
    ref int CINDEX,
    ref int LENC,
    [In] double[] C,
    [Out] double[,,] D,
    ref int LDD,
    ref int SDD,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void C09FZF(
    ref int ILEV,
    ref int CINDEX,
    ref int LENC,
    [In,Out] double[] C,
    [In] double[,,] D,
    ref int LDD,
    ref int SDD,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


// chapter d01

public delegate double D01AHF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D01AHF(
    ref double A,
    ref double B,
    ref double EPSR,
    ref int NPTS,
    ref double RELERR,
    D01AHF_F_DELEGATE F,
    ref int NLIMIT,
    ref int IFAIL
   );


public delegate double D01AJF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01AJF(
    D01AJF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate double D01AKF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01AKF(
    D01AKF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate double D01ALF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ALF(
    D01ALF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref int NPTS,
    [In] double[] POINTS,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate double D01AMF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01AMF(
    D01AMF_F_DELEGATE F,
    ref double BOUND,
    ref int INF,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate double D01ANF_G_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ANF(
    D01ANF_G_DELEGATE G,
    ref double A,
    ref double B,
    ref double OMEGA,
    ref int KEY,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate double D01APF_G_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01APF(
    D01APF_G_DELEGATE G,
    ref double A,
    ref double B,
    ref double ALFA,
    ref double BETA,
    ref int KEY,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate double D01AQF_G_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01AQF(
    D01AQF_G_DELEGATE G,
    ref double A,
    ref double B,
    ref double C,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate double D01ARF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ARF(
    ref double A,
    ref double B,
    D01ARF_F_DELEGATE F,
    ref double RELACC,
    ref double ABSACC,
    ref int MAXRUL,
    ref int IPARM,
    ref double ACC,
    ref double ANS,
    ref int N,
    [In,Out] double[] ALPHA,
    ref int IFAIL
   );


public delegate double D01ASF_G_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ASF(
    D01ASF_G_DELEGATE G,
    ref double A,
    ref double OMEGA,
    ref int KEY,
    ref double EPSABS,
    ref double RESULT,
    ref double ABSERR,
    ref int LIMLST,
    ref int LST,
    [Out] double[] ERLST,
    [Out] double[] RSLST,
    [Out] int[] IERLST,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate void D01ATF_F_DELEGATE(
    IntPtr X_rptr,
    IntPtr FV_rptr,
    ref int N
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ATF(
    D01ATF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate void D01AUF_F_DELEGATE(
    IntPtr X_rptr,
    IntPtr FV_rptr,
    ref int N
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01AUF(
    D01AUF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref int KEY,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01BCF(
    ref int ITYPE,
    ref double A,
    ref double B,
    ref double C,
    ref double D,
    ref int N,
    [Out] double[] WEIGHT,
    [Out] double[] ABSCIS,
    ref int IFAIL
   );


public delegate double D01BDF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01BDF(
    D01BDF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref double EPSABS,
    ref double EPSREL,
    ref double RESULT,
    ref double ABSERR
   );


public delegate double D01DAF_PHI1_DELEGATE(
    ref double Y
  );

public delegate double D01DAF_PHI2_DELEGATE(
    ref double Y
  );

public delegate double D01DAF_F_DELEGATE(
    ref double X,
    ref double Y
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01DAF(
    ref double YA,
    ref double YB,
    D01DAF_PHI1_DELEGATE PHI1,
    D01DAF_PHI2_DELEGATE PHI2,
    D01DAF_F_DELEGATE F,
    ref double ABSACC,
    ref double ANS,
    ref int NPTS,
    ref int IFAIL
   );


public delegate void D01EAF_FUNSUB_DELEGATE(
    ref int NDIM,
    IntPtr Z_rptr,
    ref int NFUN,
    IntPtr F_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01EAF(
    ref int NDIM,
    [In] double[] A,
    [In] double[] B,
    ref int MINCLS,
    ref int MAXCLS,
    ref int NFUN,
    D01EAF_FUNSUB_DELEGATE FUNSUB,
    ref double ABSREQ,
    ref double RELREQ,
    ref int LENWRK,
    [In,Out] double[] WRKSTR,
    [Out] double[] FINEST,
    [Out] double[] ABSEST,
    ref int IFAIL
   );


public delegate void D01ESF_F_DELEGATE(
    ref int NI,
    ref int NDIM,
    ref int NX,
    ref double XTR,
    ref int NNTR,
    IntPtr ICOLZP_iptr,
    IntPtr IROWIX_iptr,
    IntPtr XS_rptr,
    IntPtr QS_iptr,
    IntPtr FM_rptr,
    ref int IFLAG,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ESF(
    ref int NI,
    ref int NDIM,
    D01ESF_F_DELEGATE F,
    [In] int[] MAXDLV,
    [Out] double[] DINEST,
    [Out] double[] ERREST,
    [Out] int[] IVALID,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate double D01FBF_F_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D01FBF(
    ref int NDIM,
    [In] int[] NPTVEC,
    ref int LWA,
    [In] double[] WEIGHT,
    [In] double[] ABSCIS,
    D01FBF_F_DELEGATE F,
    ref int IFAIL
   );


public delegate double D01FCF_F_DELEGATE(
    ref int NDIM,
    IntPtr Z_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01FCF(
    ref int NDIM,
    [In] double[] A,
    [In] double[] B,
    ref int MINPTS,
    ref int MAXPTS,
    D01FCF_F_DELEGATE F,
    ref double EPS,
    ref double ACC,
    ref int LENWRK,
    [Out] double[] WRKSTR,
    ref double FINVAL,
    ref int IFAIL
   );


public delegate double D01FDF_F_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr
  );

public delegate void D01FDF_REGION_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr,
    ref int J,
    ref double C,
    ref double D
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01FDV(
    ref int NDIM,
    IntPtr X_rptr,
    ref int J,
    ref double C,
    ref double D
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01FDF(
    ref int NDIM,
    D01FDF_F_DELEGATE F,
    ref double SIGMA,
    D01FDF_REGION_DELEGATE REGION,
    ref int LIMIT,
    ref double R0,
    ref double U,
    ref double RESULT,
    ref int NCALLS,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01GAF(
    [In] double[] X,
    [In] double[] Y,
    ref int N,
    ref double ANS,
    ref double ER,
    ref int IFAIL
   );


public delegate double D01GBF_F_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01GBF(
    ref int NDIM,
    [In] double[] A,
    [In] double[] B,
    ref int MINCLS,
    ref int MAXCLS,
    D01GBF_F_DELEGATE F,
    ref double EPS,
    ref double ACC,
    ref int LENWRK,
    [In,Out] double[] WRKSTR,
    ref double FINEST,
    ref int IFAIL
   );


public delegate double D01GCF_F_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr
  );

public delegate void D01GCF_REGION_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr,
    ref int J,
    ref double C,
    ref double D
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01GCF(
    ref int NDIM,
    D01GCF_F_DELEGATE F,
    D01GCF_REGION_DELEGATE REGION,
    ref int NPTS,
    [In,Out] double[] VK,
    ref int NRAND,
    ref int ITRANS,
    ref double RES,
    ref double ERR,
    ref int IFAIL
   );


public delegate void D01GDF_VECFUN_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr,
    IntPtr FV_rptr,
    ref int M
  );

public delegate void D01GDF_VECREG_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr,
    ref int J,
    IntPtr C_rptr,
    IntPtr D_rptr,
    ref int M
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01GDF(
    ref int NDIM,
    D01GDF_VECFUN_DELEGATE VECFUN,
    D01GDF_VECREG_DELEGATE VECREG,
    ref int NPTS,
    [In,Out] double[] VK,
    ref int NRAND,
    ref int ITRANS,
    ref double RES,
    ref double ERR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01GYF(
    ref int NDIM,
    ref int NPTS,
    [Out] double[] VK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01GZF(
    ref int NDIM,
    ref int NP1,
    ref int NP2,
    [Out] double[] VK,
    ref int IFAIL
   );


public delegate double D01JAF_F_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01JAF(
    D01JAF_F_DELEGATE F,
    ref int NDIM,
    ref double RADIUS,
    ref double EPSA,
    ref double EPSR,
    ref int METHOD,
    ref int ICOORD,
    ref double RESULT,
    ref double ESTERR,
    ref int NEVALS,
    ref int IFAIL
   );


public delegate double D01PAF_F_DELEGATE(
    ref int NDIM,
    IntPtr X_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01PAF(
    ref int NDIM,
    [In,Out] double[,] VERT,
    ref int LDVERT,
    ref int SDVERT,
    D01PAF_F_DELEGATE F,
    ref int MINORD,
    ref int MAXORD,
    [In,Out] double[] FINVLS,
    ref double ESTERR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01RAF(
    ref int IREVCM, ref int NI, ref double A,
    ref double B, ref int SID, [In,Out] int[] NEEDI,
    [In,Out] double[] X, ref int LENX, ref int NX,
    [In] double[,] FM, ref int LDFM, [In,Out] double[] DINEST,
    [In,Out] double[] ERREST, [In] int[] IOPTS, [In] double[] OPTS,
    [In,Out] int[] ICOM, ref int LICOM, [In,Out] double[] COM,
    ref int LCOM, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01RCF(
    ref int NI,
    ref int LENXRQ,
    ref int LDFMRQ,
    ref int SDFMRQ,
    ref int LICMIN,
    ref int LICMAX,
    ref int LCMIN,
    ref int LCMAX,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
   );


public delegate void D01RGF_F_DELEGATE(
    IntPtr X_rptr,
    ref int NX,
    IntPtr FV_rptr,
    ref int IFLAG,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01RGF(
    ref double A,
    ref double B,
    D01RGF_F_DELEGATE F,
    ref double EPSABS,
    ref double EPSREL,
    ref double DINEST,
    ref double ERREST,
    ref int NEVALS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void D01RJF_F_DELEGATE(
    IntPtr X_rptr,
    ref int NX,
    IntPtr FV_rptr,
    ref int IFLAG,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01RJF(
    D01RJF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref double EPSABS,
    ref double EPSREL,
    ref int MAXSUB,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] RINFO,
    [Out] int[] IINFO,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


public delegate void D01RKF_F_DELEGATE(
    IntPtr X_rptr,
    ref int NX,
    IntPtr FV_rptr,
    ref int IFLAG,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01RKF(
    D01RKF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref int KEY,
    ref double EPSABS,
    ref double EPSREL,
    ref int MAXSUB,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] RINFO,
    [Out] int[] IINFO,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


public delegate void D01RLF_F_DELEGATE(
    IntPtr X_rptr,
    ref int NX,
    IntPtr FV_rptr,
    ref int IFLAG,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01RLF(
    D01RLF_F_DELEGATE F,
    ref double A,
    ref double B,
    ref int NPTS,
    [In] double[] POINTS,
    ref double EPSABS,
    ref double EPSREL,
    ref int MAXSUB,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] RINFO,
    [Out] int[] IINFO,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


public delegate void D01RMF_F_DELEGATE(
    IntPtr X_rptr,
    ref int NX,
    IntPtr FV_rptr,
    ref int IFLAG,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01RMF(
    D01RMF_F_DELEGATE F,
    ref double BOUND,
    ref int INF,
    ref double EPSABS,
    ref double EPSREL,
    ref int MAXSUB,
    ref double RESULT,
    ref double ABSERR,
    [Out] double[] RINFO,
    [Out] int[] IINFO,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01TBF(
    ref int KEY,
    ref double A,
    ref double B,
    ref int N,
    [Out] double[] WEIGHT,
    [Out] double[] ABSCIS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01TCF(
    ref int ITYPE,
    ref double A,
    ref double B,
    ref double C,
    ref double D,
    ref int N,
    [Out] double[] WEIGHT,
    [Out] double[] ABSCIS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01TDF(
    ref int N,
    [In] double[] A,
    [In,Out] double[] B,
    [In,Out] double[] C,
    ref double MUZERO,
    [Out] double[] WEIGHT,
    [Out] double[] ABSCIS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01TEF(
    ref int N,
    [In] double[] MU,
    [Out] double[] A,
    [Out] double[] B,
    [Out] double[] C,
    ref int IFAIL
   );


public delegate void D01UAF_F_DELEGATE(
    IntPtr X_rptr,
    ref int NX,
    IntPtr FV_rptr,
    ref int IFLAG,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01UAF(
    ref int KEY,
    ref double A,
    ref double B,
    ref int N,
    D01UAF_F_DELEGATE F,
    ref double DINEST,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void D01UBF_F_DELEGATE(
    IntPtr X_rptr,
    IntPtr FV_rptr,
    ref int N,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int ISTOP
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01UBF(
    D01UBF_F_DELEGATE F,
    ref int N,
    ref double ANS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ZKF(
    string OPTSTR,
    [In,Out] int[] IOPTS,
    ref int LIOPTS,
    [In,Out] double[] OPTS,
    ref int LOPTS,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D01ZLF(
    string OPTSTR,
    ref int IVALUE,
    ref double RVALUE,
    StringBuilder CVALUE,
    ref int OPTYPE,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


// chapter d02

public delegate void D02AGF_AUX_DELEGATE(
    IntPtr F_rptr,
    IntPtr Y_rptr,
    ref double X,
    IntPtr PARAM_rptr
  );

public delegate void D02AGF_BCAUX_DELEGATE(
    IntPtr G0_rptr,
    IntPtr G1_rptr,
    IntPtr PARAM_rptr
  );

public delegate void D02AGF_RAAUX_DELEGATE(
    ref double X0,
    ref double X1,
    ref double R,
    IntPtr PARAM_rptr
  );

public delegate void D02AGF_PRSOL_DELEGATE(
    IntPtr PARAM_rptr,
    ref double RES,
    ref int N1,
    IntPtr ERR_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02AGF(
    ref double H,
    [In] double[] E,
    [In] double[] PARERR,
    [In,Out] double[] PARAM,
    [Out] double[,] C,
    ref int N,
    ref int N1,
    ref int M1,
    D02AGF_AUX_DELEGATE AUX,
    D02AGF_BCAUX_DELEGATE BCAUX,
    D02AGF_RAAUX_DELEGATE RAAUX,
    D02AGF_PRSOL_DELEGATE PRSOL,
    [Out] double[,] MAT,
    [In] double[,] COPY,
    [Out] double[,] WSPACE,
    [Out] double[] WSPAC1,
    [Out] double[] WSPAC2,
    ref int IFAIL
   );


public delegate void D02BGF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02BGF(
    ref double X,
    ref double XEND,
    ref int N,
    [In,Out] double[] Y,
    ref double TOL,
    ref double HMAX,
    ref int M,
    ref double VAL,
    D02BGF_FCN_DELEGATE FCN,
    [Out] double[,] W,
    ref int IFAIL
   );


public delegate void D02BHF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

public delegate double D02BHF_G_DELEGATE(
    ref double X,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02BHF(
    ref double X,
    ref double XEND,
    ref int N,
    [In,Out] double[] Y,
    ref double TOL,
    ref int IRELAB,
    ref double HMAX,
    D02BHF_FCN_DELEGATE FCN,
    D02BHF_G_DELEGATE G,
    [Out] double[,] W,
    ref int IFAIL
   );


public delegate void D02BJF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

public delegate void D02BJF_OUTPUT_DELEGATE(
    ref double XSOL,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02BJX(
    ref double XSOL,
    IntPtr Y_rptr
  );

public delegate double D02BJF_G_DELEGATE(
    ref double X,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D02BJW(
    ref double X,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02BJF(
    ref double X,
    ref double XEND,
    ref int N,
    [In,Out] double[] Y,
    D02BJF_FCN_DELEGATE FCN,
    ref double TOL,
    string RELABS,
    D02BJF_OUTPUT_DELEGATE OUTPUT,
    D02BJF_G_DELEGATE G,
    [Out] double[] W,
    ref int IFAIL
,
    long RELABSLength
    );


public delegate void D02CJF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

public delegate void D02CJF_OUTPUT_DELEGATE(
    ref double XSOL,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02CJX(
    ref double XSOL,
    IntPtr Y_rptr
  );

public delegate double D02CJF_G_DELEGATE(
    ref double X,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D02CJW(
    ref double X,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02CJF(
    ref double X,
    ref double XEND,
    ref int N,
    [In,Out] double[] Y,
    D02CJF_FCN_DELEGATE FCN,
    ref double TOL,
    string RELABS,
    D02CJF_OUTPUT_DELEGATE OUTPUT,
    D02CJF_G_DELEGATE G,
    [Out] double[] W,
    ref int IFAIL
,
    long RELABSLength
    );


public delegate void D02EJF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

public delegate void D02EJF_PEDERV_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr PW_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02EJY(
    ref double X,
    IntPtr Y_rptr,
    IntPtr PW_rptr
  );

public delegate void D02EJF_OUTPUT_DELEGATE(
    ref double XSOL,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02EJX(
    ref double XSOL,
    IntPtr Y_rptr
  );

public delegate double D02EJF_G_DELEGATE(
    ref double X,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D02EJW(
    ref double X,
    IntPtr Y_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02EJF(
    ref double X,
    ref double XEND,
    ref int N,
    [In,Out] double[] Y,
    D02EJF_FCN_DELEGATE FCN,
    D02EJF_PEDERV_DELEGATE PEDERV,
    ref double TOL,
    string RELABS,
    D02EJF_OUTPUT_DELEGATE OUTPUT,
    D02EJF_G_DELEGATE G,
    [Out] double[] W,
    ref int IW,
    ref int IFAIL
,
    long RELABSLength
    );


public delegate void D02GAF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02GAF(
    [In] double[,] U,
    [In] double[,] V,
    ref int N,
    ref double A,
    ref double B,
    ref double TOL,
    D02GAF_FCN_DELEGATE FCN,
    ref int MNP,
    [In,Out] double[] X,
    [Out] double[,] Y,
    ref int NP,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02GAW(
    ref double X,
    ref double EPS,
    [In] double[] Y,
    [Out] double[] F,
    ref int N
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02GAX(
    ref double EPS,
    [In] double[] YA,
    [In] double[] YB,
    [Out] double[] BCEP,
    ref int N
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02GAY(
    ref double EPS,
    [In] double[] YA,
    [In] double[] YB,
    [Out] double[,] AJ,
    [Out] double[,] BJ,
    ref int N
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02GAZ(
    ref double X,
    ref double EPS,
    [In] double[] Y,
    [Out] double[,] F,
    ref int N
   );


public delegate void D02GBF_FCNF_DELEGATE(
    ref double X,
    IntPtr F_rptr
  );

public delegate void D02GBF_FCNG_DELEGATE(
    ref double X,
    IntPtr G_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02GBF(
    ref double A,
    ref double B,
    ref int N,
    ref double TOL,
    D02GBF_FCNF_DELEGATE FCNF,
    D02GBF_FCNG_DELEGATE FCNG,
    [In,Out] double[,] C,
    [In,Out] double[,] D,
    [In,Out] double[] GAM,
    ref int MNP,
    [In,Out] double[] X,
    [Out] double[,] Y,
    ref int NP,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate void D02HAF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02HAF(
    [In,Out] double[,] U,
    [In] double[,] V,
    ref int N,
    ref double A,
    ref double B,
    ref double TOL,
    D02HAF_FCN_DELEGATE FCN,
    [Out] double[,] SOLN,
    ref int M1,
    [Out] double[,] W,
    ref int SDW,
    ref int IFAIL
   );


public delegate void D02HBF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    IntPtr P_rptr
  );

public delegate void D02HBF_BC_DELEGATE(
    IntPtr G1_rptr,
    IntPtr G2_rptr,
    IntPtr P_rptr
  );

public delegate void D02HBF_RANGE_DELEGATE(
    ref double A,
    ref double B,
    IntPtr P_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02HBF(
    [In,Out] double[] P,
    ref int N1,
    [In] double[] PE,
    [In] double[] E,
    ref int N,
    [Out] double[,] SOLN,
    ref int M1,
    D02HBF_FCN_DELEGATE FCN,
    D02HBF_BC_DELEGATE BC,
    D02HBF_RANGE_DELEGATE RANGE,
    [Out] double[,] W,
    ref int SDW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02HBW(
    ref double Z,
    [In] double[] Y,
    ref int N
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02HBZ(
    [Out] double[] E,
    ref int Q,
    [In] double[] P,
    ref int M
   );


public delegate double D02JAF_CF_DELEGATE(
    ref int J,
    ref double X
  );

public delegate void D02JAF_BC_DELEGATE(
    ref int I,
    ref int J,
    ref double RHS
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02JAF(
    ref int N,
    D02JAF_CF_DELEGATE CF,
    D02JAF_BC_DELEGATE BC,
    ref double X0,
    ref double X1,
    ref int K1,
    ref int KP,
    [Out] double[] C,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int IFAIL
   );


public delegate double D02JBF_CF_DELEGATE(
    ref int I,
    ref int J,
    ref double X
  );

public delegate void D02JBF_BC_DELEGATE(
    ref int I,
    ref int J,
    ref double RHS
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02JBF(
    ref int N,
    D02JBF_CF_DELEGATE CF,
    D02JBF_BC_DELEGATE BC,
    ref double X0,
    ref double X1,
    ref int K1,
    ref int KP,
    [Out] double[,] C,
    ref int LDC,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate void D02KAF_COEFFN_DELEGATE(
    ref double P,
    ref double Q,
    ref double DQDL,
    ref double X,
    ref double ELAM,
    ref int JINT
  );

public delegate void D02KAF_MONIT_DELEGATE(
    ref int NIT,
    ref int IFLAG,
    ref double ELAM,
    IntPtr FINFO_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02KAY(
    ref int NIT,
    ref int IFLAG,
    ref double ELAM,
    IntPtr FINFO_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02KAF(
    ref double XL,
    ref double XR,
    D02KAF_COEFFN_DELEGATE COEFFN,
    [In,Out] double[,] BCOND,
    ref int K,
    ref double TOL,
    ref double ELAM,
    ref double DELAM,
    D02KAF_MONIT_DELEGATE MONIT,
    ref int IFAIL
   );




public delegate void D02KDF_COEFFN_DELEGATE(
    ref double P,
    ref double Q,
    ref double DQDL,
    ref double X,
    ref double ELAM,
    ref int JINT
  );

public delegate void D02KDF_BDYVAL_DELEGATE(
    ref double XL,
    ref double XR,
    ref double ELAM,
    IntPtr YL_rptr,
    IntPtr YR_rptr
  );

public delegate void D02KDF_MONIT_DELEGATE(
    ref int NIT,
    ref int IFLAG,
    ref double ELAM,
    IntPtr FINFO_rptr
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02KDF(
    [In] double[] XPOINT,
    ref int M,
    D02KDF_COEFFN_DELEGATE COEFFN,
    D02KDF_BDYVAL_DELEGATE BDYVAL,
    ref int K,
    ref double TOL,
    ref double ELAM,
    ref double DELAM,
    [In,Out] double[,] HMAX,
    ref int MAXIT,
    ref int MAXFUN,
    D02KDF_MONIT_DELEGATE MONIT,
    ref int IFAIL
   );


public delegate void D02KEF_COEFFN_DELEGATE(
    ref double P,
    ref double Q,
    ref double DQDL,
    ref double X,
    ref double ELAM,
    ref int JINT
  );

public delegate void D02KEF_BDYVAL_DELEGATE(
    ref double XL,
    ref double XR,
    ref double ELAM,
    IntPtr YL_rptr,
    IntPtr YR_rptr
  );

public delegate void D02KEF_MONIT_DELEGATE(
    ref int NIT,
    ref int IFLAG,
    ref double ELAM,
    IntPtr FINFO_rptr
  );


public delegate void D02KEF_REPORT_DELEGATE(
    ref double X,
    IntPtr V_rptr,
    ref int JINT
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02KEF(
    [In] double[] XPOINT,
    ref int M,
    ref int MATCH,
    D02KEF_COEFFN_DELEGATE COEFFN,
    D02KEF_BDYVAL_DELEGATE BDYVAL,
    ref int K,
    ref double TOL,
    ref double ELAM,
    ref double DELAM,
    [In,Out] double[,] HMAX,
    ref int MAXIT,
    ref int MAXFUN,
    D02KEF_MONIT_DELEGATE MONIT,
    D02KEF_REPORT_DELEGATE REPORT,
    ref int IFAIL
   );


public delegate void D02LAF_FCN_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02LAF(
    D02LAF_FCN_DELEGATE FCN,
    ref int NEQ,
    ref double T,
    ref double TEND,
    [In,Out] double[] Y,
    [In,Out] double[] YP,
    [In,Out] double[] YDP,
    [In,Out] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02LXF(
    ref int NEQ,
    ref double H,
    ref double TOL,
    [In] double[] THRES,
    [In] double[] THRESP,
    ref int MAXSTP,
    ref int START,
    ref int ONESTP,
    ref int HIGH,
    [In,Out] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02LYF(
    ref int NEQ,
    ref double HNEXT,
    ref double HUSED,
    ref double HSTART,
    ref int NSUCC,
    ref int NFAIL,
    ref int NATT,
    [Out] double[] THRES,
    [Out] double[] THRESP,
    [In] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02LZF(
    ref int NEQ,
    ref double T,
    [In] double[] Y,
    [In] double[] YP,
    ref int NWANT,
    ref double TWANT,
    [Out] double[] YWANT,
    [Out] double[] YPWANT,
    [In] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02MCF(
    [In,Out] int[] ICOM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02MVF(
    ref int NEQMAX,
    ref int SDYSAV,
    ref int MAXORD,
    [In,Out] double[] CON,
    ref double TCRIT,
    ref double HMIN,
    ref double HMAX,
    ref double H0,
    ref int MAXSTP,
    ref int MXHNIL,
    string NORM,
    [In,Out] double[] RWORK,
    ref int IFAIL
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02MWF(
    ref int NEQ,
    ref int MAXORD,
    string JCEVAL,
    ref double HMAX,
    ref double H0,
    ref int ITOL,
    [Out] int[] ICOM,
    ref int LICOM,
    [Out] double[] COM,
    ref int LCOM,
    ref int IFAIL
,
    long JCEVALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02MZF(
    ref double TSOL,
    [Out] double[] SOL,
    ref int M,
    ref int LDYSAV,
    ref int NEQ,
    [In] double[,] YSAV,
    ref int SDYSAV,
    [In] double[] RWORK,
    ref int IFAIL
   );


public delegate void D02NBF_FCN_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    ref int IRES
  );

public delegate void D02NBF_JAC_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    ref double H,
    ref double D,
    IntPtr P_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NBZ(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    ref double H,
    ref double D,
    IntPtr P_rptr
  );

public delegate void D02NBF_MONITR_DELEGATE(
    ref int NEQ,
    ref int LDYSAV,
    ref double T,
    ref double HLAST,
    ref double HNEXT,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr YSAV_rptr,
    IntPtr R_rptr,
    IntPtr ACOR_rptr,
    ref int IMON,
    ref int INLN,
    ref double HMIN,
    ref double HMAX,
    ref int NQU
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NBY(
    ref int NEQ,
    ref int LDYSAV,
    ref double T,
    ref double HLAST,
    ref double HNEXT,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr YSAV_rptr,
    IntPtr R_rptr,
    IntPtr ACOR_rptr,
    ref int IMON,
    ref int INLN,
    ref double HMIN,
    ref double HMAX,
    ref int NQU
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NBF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, D02NBF_FCN_DELEGATE FCN,
    [In,Out] double[,] YSAV, ref int SDYSAV, D02NBF_JAC_DELEGATE JAC,
    [In,Out] double[] WKJAC, ref int NWKJAC, D02NBF_MONITR_DELEGATE MONITR,
    ref int ITASK, ref int ITRACE, ref int IFAIL
   );






public delegate void D02NCF_FCN_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    ref int IRES
  );

public delegate void D02NCF_JAC_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    ref double H,
    ref double D,
    ref int ML,
    ref int MU,
    IntPtr P_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NCZ(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    ref double H,
    ref double D,
    ref int ML,
    ref int MU,
    IntPtr P_rptr
  );

public delegate void D02NCF_MONITR_DELEGATE(
    ref int NEQ,
    ref int LDYSAV,
    ref double T,
    ref double HLAST,
    ref double HNEXT,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr YSAV_rptr,
    IntPtr R_rptr,
    IntPtr ACOR_rptr,
    ref int IMON,
    ref int INLN,
    ref double HMIN,
    ref double HMAX,
    ref int NQU
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NCF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, D02NCF_FCN_DELEGATE FCN,
    [In,Out] double[,] YSAV, ref int SDYSAV, D02NCF_JAC_DELEGATE JAC,
    [In,Out] double[] WKJAC, ref int NWKJAC, [In,Out] int[] JACPVT,
    ref int NJCPVT, D02NCF_MONITR_DELEGATE MONITR, ref int ITASK,
    ref int ITRACE, ref int IFAIL
   );




public delegate void D02NDF_FCN_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    ref int IRES
  );

public delegate void D02NDF_JAC_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    ref double H,
    ref double D,
    ref int J,
    IntPtr PDJ_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NDZ(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    ref double H,
    ref double D,
    ref int J,
    IntPtr PDJ_rptr
  );

public delegate void D02NDF_MONITR_DELEGATE(
    ref int NEQ,
    ref int LDYSAV,
    ref double T,
    ref double HLAST,
    ref double HNEXT,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr YSAV_rptr,
    IntPtr R_rptr,
    IntPtr ACOR_rptr,
    ref int IMON,
    ref int INLN,
    ref double HMIN,
    ref double HMAX,
    ref int NQU
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NDF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, D02NDF_FCN_DELEGATE FCN,
    [In,Out] double[,] YSAV, ref int SDYSAV, D02NDF_JAC_DELEGATE JAC,
    [In,Out] double[] WKJAC, ref int NWKJAC, [In,Out] int[] JACPVT,
    ref int NJCPVT, D02NDF_MONITR_DELEGATE MONITR, ref int ITASK,
    ref int ITRACE, ref int IFAIL
   );




public delegate void D02NEF_RES_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr R_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D02NEF_JAC_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr PD_rptr,
    ref double CJ,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NEZ(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr PD_rptr,
    ref double CJ,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NEF(
    ref int NEQ,
    ref double T,
    ref double TOUT,
    [In,Out] double[] Y,
    [In,Out] double[] YDOT,
    [In,Out] double[] RTOL,
    [In,Out] double[] ATOL,
    ref int ITASK,
    D02NEF_RES_DELEGATE RES,
    D02NEF_JAC_DELEGATE JAC,
    [In,Out] int[] ICOM,
    [In,Out] double[] COM,
    ref int LCOM,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );




public delegate void D02NGF_RESID_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D02NGF_JAC_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    ref double H,
    ref double D,
    IntPtr P_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NGZ(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    ref double H,
    ref double D,
    IntPtr P_rptr
  );

public delegate void D02NGF_MONITR_DELEGATE(
    ref int NEQ,
    ref int LDYSAV,
    ref double T,
    ref double HLAST,
    ref double HNEXT,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr YSAV_rptr,
    IntPtr R_rptr,
    IntPtr ACOR_rptr,
    ref int IMON,
    ref int INLN,
    ref double HMIN,
    ref double HMAX,
    ref int NQU
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NGF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [In,Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, D02NGF_RESID_DELEGATE RESID,
    [In,Out] double[,] YSAV, ref int SDYSAV, D02NGF_JAC_DELEGATE JAC,
    [In,Out] double[] WKJAC, ref int NWKJAC, D02NGF_MONITR_DELEGATE MONITR,
    [In,Out] int[] LDERIV, ref int ITASK, ref int ITRACE,
    ref int IFAIL
   );




public delegate void D02NHF_RESID_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D02NHF_JAC_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    ref double H,
    ref double D,
    ref int ML,
    ref int MU,
    IntPtr P_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NHZ(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    ref double H,
    ref double D,
    ref int ML,
    ref int MU,
    IntPtr P_rptr
  );

public delegate void D02NHF_MONITR_DELEGATE(
    ref int NEQ,
    ref int LDYSAV,
    ref double T,
    ref double HLAST,
    ref double HNEXT,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr YSAV_rptr,
    IntPtr R_rptr,
    IntPtr ACOR_rptr,
    ref int IMON,
    ref int INLN,
    ref double HMIN,
    ref double HMAX,
    ref int NQU
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NHF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [In,Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, D02NHF_RESID_DELEGATE RESID,
    [In,Out] double[,] YSAV, ref int SDYSAV, D02NHF_JAC_DELEGATE JAC,
    [In,Out] double[] WKJAC, ref int NWKJAC, [In,Out] int[] JACPVT,
    ref int NJCPVT, D02NHF_MONITR_DELEGATE MONITR, [In,Out] int[] LDERIV,
    ref int ITASK, ref int ITRACE, ref int IFAIL
   );




public delegate void D02NJF_RESID_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D02NJF_JAC_DELEGATE(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    ref double H,
    ref double D,
    ref int J,
    IntPtr PDJ_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NJZ(
    ref int NEQ,
    ref double T,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    ref double H,
    ref double D,
    ref int J,
    IntPtr PDJ_rptr
  );

public delegate void D02NJF_MONITR_DELEGATE(
    ref int NEQ,
    ref int LDYSAV,
    ref double T,
    ref double HLAST,
    ref double HNEXT,
    IntPtr Y_rptr,
    IntPtr YDOT_rptr,
    IntPtr YSAV_rptr,
    IntPtr R_rptr,
    IntPtr ACOR_rptr,
    ref int IMON,
    ref int INLN,
    ref double HMIN,
    ref double HMAX,
    ref int NQU
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NJF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [In,Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, D02NJF_RESID_DELEGATE RESID,
    [In,Out] double[,] YSAV, ref int SDYSAV, D02NJF_JAC_DELEGATE JAC,
    [In,Out] double[] WKJAC, ref int NWKJAC, [In,Out] int[] JACPVT,
    ref int NJCPVT, D02NJF_MONITR_DELEGATE MONITR, [In,Out] int[] LDERIV,
    ref int ITASK, ref int ITRACE, ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NMF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [In,Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, [In,Out] double[,] YSAV,
    ref int SDYSAV, [In,Out] double[] WKJAC, ref int NWKJAC,
    [In,Out] int[] JACPVT, ref int NJCPVT, ref int IMON,
    ref int INLN, ref int IRES, ref int IREVCM,
    ref int ITASK, ref int ITRACE, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NNF(
    ref int NEQ, ref int LDYSAV, ref double T,
    ref double TOUT, [In,Out] double[] Y, [In,Out] double[] YDOT,
    [In,Out] double[] RWORK, [In] double[] RTOL, [In] double[] ATOL,
    ref int ITOL, [In,Out] int[] INFORM, [In,Out] double[,] YSAV,
    ref int SDYSAV, [In,Out] double[] WKJAC, ref int NWKJAC,
    [In,Out] int[] JACPVT, ref int NJCPVT, ref int IMON,
    ref int INLN, ref int IRES, ref int IREVCM,
    [In,Out] int[] LDERIV, ref int ITASK, ref int ITRACE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NPF(
    ref int NEQ,
    ref int ML,
    ref int MU,
    [In,Out] int[] ICOM,
    ref int LICOM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NRF(
    ref int J,
    ref int IPLACE,
    [In] int[] INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NSF(
    ref int NEQ,
    ref int NEQMAX,
    string JCEVAL,
    ref int NWKJAC,
    [In,Out] double[] RWORK,
    ref int IFAIL
,
    long JCEVALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NTF(
    ref int NEQ,
    ref int NEQMAX,
    string JCEVAL,
    ref int ML,
    ref int MU,
    ref int NWKJAC,
    ref int NJCPVT,
    [In,Out] double[] RWORK,
    ref int IFAIL
,
    long JCEVALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NUF(
    ref int NEQ,
    ref int NEQMAX,
    string JCEVAL,
    ref int NWKJAC,
    [In] int[] IA,
    ref int NIA,
    [In] int[] JA,
    ref int NJA,
    [Out] int[] JACPVT,
    ref int NJCPVT,
    ref double SENS,
    ref double U,
    ref double ETA,
    ref int LBLOCK,
    ref int ISPLIT,
    [In,Out] double[] RWORK,
    ref int IFAIL
,
    long JCEVALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NVF(
    ref int NEQMAX,
    ref int SDYSAV,
    ref int MAXORD,
    string METHOD,
    ref int PETZLD,
    [In,Out] double[] CON,
    ref double TCRIT,
    ref double HMIN,
    ref double HMAX,
    ref double H0,
    ref int MAXSTP,
    ref int MXHNIL,
    string NORM,
    [In,Out] double[] RWORK,
    ref int IFAIL
,
    long METHODLength,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NWF(
    ref int NEQMAX,
    ref int SDYSAV,
    ref int MAXORD,
    [In,Out] double[] CON,
    ref double TCRIT,
    ref double HMIN,
    ref double HMAX,
    ref double H0,
    ref int MAXSTP,
    ref int MXHNIL,
    string NORM,
    [In,Out] double[] RWORK,
    ref int IFAIL
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NXF(
    ref int ICALL,
    ref int LIWREQ,
    ref int LIWUSD,
    ref int LRWREQ,
    ref int LRWUSD,
    ref int NLU,
    ref int NNZ,
    ref int NGP,
    ref int ISPLIT,
    ref int IGROW,
    ref int LBLOCK,
    ref int NBLOCK,
    [In] int[] INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NYF(
    ref int NEQ,
    ref int NEQMAX,
    ref double HU,
    ref double H,
    ref double TCUR,
    ref double TOLSF,
    [In] double[] RWORK,
    ref int NST,
    ref int NRE,
    ref int NJE,
    ref int NQU,
    ref int NQ,
    ref int NITER,
    ref int IMXER,
    [Out] int[] ALGEQU,
    [In] int[] INFORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02NZF(
    ref int NEQMAX,
    ref double TCRIT,
    ref double H,
    ref double HMIN,
    ref double HMAX,
    ref int MAXSTP,
    ref int MXHNIL,
    [In,Out] double[] RWORK,
    ref int IFAIL
   );


public delegate void D02PEF_F_DELEGATE(
    ref double T,
    ref int N,
    IntPtr Y_rptr,
    IntPtr YP_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PEF(
    D02PEF_F_DELEGATE F,
    ref int N,
    ref double TWANT,
    ref double TGOT,
    [In,Out] double[] YGOT,
    [Out] double[] YPGOT,
    [In,Out] double[] YMAX,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


public delegate void D02PFF_F_DELEGATE(
    ref double T,
    ref int N,
    IntPtr Y_rptr,
    IntPtr YP_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PFF(
    D02PFF_F_DELEGATE F,
    ref int N,
    ref double TNOW,
    [Out] double[] YNOW,
    [Out] double[] YPNOW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PGF(
    ref int IREVCM,
    ref int N,
    ref double T,
    [Out] double[] Y,
    [In] double[] YP,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PHF(
    ref int IREVCM,
    ref int N,
    ref int NWANT,
    ref double T,
    [Out] double[] Y,
    [In] double[] YP,
    [In,Out] double[] WCOMM,
    ref int LWCOMM,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PJF(
    ref int ICHECK,
    ref int N,
    ref int NWANT,
    ref double T,
    ref int IDERIV,
    [Out] double[] SOL,
    [In,Out] double[] WCOMM,
    ref int LWCOMM,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PQF(
    ref int N,
    ref double TSTART,
    ref double TEND,
    [In] double[] YINIT,
    ref double TOL,
    [In] double[] THRESH,
    ref int METHOD,
    ref double HSTART,
    [Out] int[] IWSAV,
    [Out] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PRF(
    ref double TENDNU,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


public delegate void D02PSF_F_DELEGATE(
    ref double T,
    ref int N,
    IntPtr Y_rptr,
    IntPtr YP_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PSF(
    ref int N,
    ref double TWANT,
    ref int IDERIV,
    ref int NWANT,
    [Out] double[] YWANT,
    [Out] double[] YPWANT,
    D02PSF_F_DELEGATE F,
    [In,Out] double[] WCOMM,
    ref int LWCOMM,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PTF(
    ref int FEVALS,
    ref int STEPCOST,
    ref double WASTE,
    ref int STEPSOK,
    ref double HNEXT,
    [In,Out] int[] IWSAV,
    [In] double[] RWSAV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02PUF(
    ref int N,
    [Out] double[] RMSERR,
    ref double ERRMAX,
    ref double TERRMX,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );


public delegate void D02QFF_FCN_DELEGATE(
    ref int NEQF,
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr
  );

public delegate double D02QFF_G_DELEGATE(
    ref int NEQF,
    ref double X,
    IntPtr Y_rptr,
    IntPtr YP_rptr,
    ref int K
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D02QFZ(
    ref int NEQF,
    ref double X,
    IntPtr Y_rptr,
    IntPtr YP_rptr,
    ref int K
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02QFF(
    D02QFF_FCN_DELEGATE FCN,
    ref int NEQF,
    ref double T,
    [In,Out] double[] Y,
    ref double TOUT,
    D02QFF_G_DELEGATE G,
    ref int NEQG,
    ref int ROOT,
    [In,Out] double[] RWORK,
    ref int LRWORK,
    [In,Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02QGF(
    ref int NEQF,
    ref double T,
    [In,Out] double[] Y,
    ref double TOUT,
    ref int NEQG,
    ref int ROOT,
    ref int IREVCM,
    ref double TRVCM,
    ref int YRVCM,
    ref int YPRVCM,
    ref double GRVCM,
    ref int KGRVCM,
    [In,Out] double[] RWORK,
    ref int LRWORK,
    [In,Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02QWF(
    StringBuilder STATEF, ref int NEQF, ref int VECTOL,
    [In] double[] ATOL, ref int LATOL, [In] double[] RTOL,
    ref int LRTOL, ref int ONESTP, ref int CRIT,
    ref double TCRIT, ref double HMAX, ref int MAXSTP,
    ref int NEQG, ref int ALTERG, ref int SOPHST,
    [In,Out] double[] RWORK, ref int LRWORK, [In,Out] int[] IWORK,
    ref int LIWORK, ref int IFAIL
,
    long STATEFLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02QXF(
    ref int NEQF,
    [Out] double[] YP,
    ref double TCURR,
    ref double HLAST,
    ref double HNEXT,
    ref int ODLAST,
    ref int ODNEXT,
    ref int NSUCC,
    ref int NFAIL,
    ref double TOLFAC,
    ref int BADCMP,
    [In] double[] RWORK,
    ref int LRWORK,
    [In] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02QYF(
    ref int NEQG,
    ref int INDEX,
    ref int ITYPE,
    [Out] int[] EVENTS,
    [Out] double[] RESIDS,
    [In] double[] RWORK,
    ref int LRWORK,
    [In] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02QZF(
    ref int NEQF,
    ref double TWANT,
    ref int NWANT,
    [Out] double[] YWANT,
    [Out] double[] YPWANT,
    [In] double[] RWORK,
    ref int LRWORK,
    [In] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


public delegate void D02RAF_FCN_DELEGATE(
    ref double X,
    ref double EPS,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    ref int N
  );

public delegate void D02RAF_G_DELEGATE(
    ref double EPS,
    IntPtr YA_rptr,
    IntPtr YB_rptr,
    IntPtr BC_rptr,
    ref int N
  );

public delegate void D02RAF_JACOBF_DELEGATE(
    ref double X,
    ref double EPS,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    ref int N
  );


public delegate void D02RAF_JACOBG_DELEGATE(
    ref double EPS,
    IntPtr YA_rptr,
    IntPtr YB_rptr,
    IntPtr AJ_rptr,
    IntPtr BJ_rptr,
    ref int N
  );


public delegate void D02RAF_JACEPS_DELEGATE(
    ref double X,
    ref double EPS,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    ref int N
  );


public delegate void D02RAF_JACGEP_DELEGATE(
    ref double EPS,
    IntPtr YA_rptr,
    IntPtr YB_rptr,
    IntPtr BCEP_rptr,
    ref int N
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02RAF(
    ref int N, ref int MNP, ref int NP,
    ref int NUMBEG, ref int NUMMIX, ref double TOL,
    ref int INIT, [In,Out] double[] X, [In,Out] double[,] Y,
    ref int LDY, [Out] double[] ABT, D02RAF_FCN_DELEGATE FCN,
    D02RAF_G_DELEGATE G, ref int IJAC, D02RAF_JACOBF_DELEGATE JACOBF,
    D02RAF_JACOBG_DELEGATE JACOBG, ref double DELEPS, D02RAF_JACEPS_DELEGATE JACEPS,
    D02RAF_JACGEP_DELEGATE JACGEP, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int LIWORK, ref int IFAIL
   );


public delegate void D02SAF_RANGE_DELEGATE(
    IntPtr X_rptr,
    ref int NPOINT,
    IntPtr P_rptr,
    ref int M
  );

public delegate void D02SAF_BC_DELEGATE(
    IntPtr G1_rptr,
    IntPtr G2_rptr,
    IntPtr P_rptr,
    ref int M,
    ref int N
  );

public delegate void D02SAF_FCN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    IntPtr F_rptr,
    ref int N,
    IntPtr P_rptr,
    ref int M,
    ref int I
  );

public delegate void D02SAF_EQN_DELEGATE(
    IntPtr E_rptr,
    ref int Q,
    IntPtr P_rptr,
    ref int M
  );


public delegate bool D02SAF_CONSTR_DELEGATE(
    IntPtr P_rptr,
    ref int M
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool D02HBY(
    IntPtr P_rptr,
    ref int M
  );

public delegate void D02SAF_MONIT_DELEGATE(
    ref int ISTATE,
    ref int IFLAG,
    ref int IFAIL1,
    IntPtr P_rptr,
    ref int M,
    IntPtr F_rptr,
    ref double PNORM,
    ref double PNORM1,
    ref double EPS,
    IntPtr D_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02SAS(
    ref int ISTATE,
    ref int IFLAG,
    ref int IFAIL1,
    IntPtr P_rptr,
    ref int M,
    IntPtr F_rptr,
    ref double PNORM,
    ref double PNORM1,
    ref double EPS,
    IntPtr D_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02HBX(
    ref int ISTATE,
    ref int IFLAG,
    ref int IFAIL1,
    IntPtr P_rptr,
    ref int M,
    IntPtr F_rptr,
    ref double PNORM,
    ref double PNORM1,
    ref double EPS,
    IntPtr D_rptr
  );

public delegate void D02SAF_PRSOL_DELEGATE(
    ref double Z,
    IntPtr Y_rptr,
    ref int N
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02SAF(
    [In,Out] double[] P, ref int M, ref int N,
    ref int N1, [In] double[] PE, [In,Out] double[] PF,
    [In] double[] E, [In,Out] double[] DP, ref int NPOINT,
    [In,Out] double[,] SWP, ref int LDSWP, ref int ICOUNT,
    D02SAF_RANGE_DELEGATE RANGE, D02SAF_BC_DELEGATE BC, D02SAF_FCN_DELEGATE FCN,
    D02SAF_EQN_DELEGATE EQN, D02SAF_CONSTR_DELEGATE CONSTR, ref double YMAX,
    D02SAF_MONIT_DELEGATE MONIT, D02SAF_PRSOL_DELEGATE PRSOL, [Out] double[,] W,
    ref int LDW, ref int SDW, ref int IFAIL
   );




public delegate void D02TGF_COEFF_DELEGATE(
    ref double X,
    ref int I,
    IntPtr A_rptr,
    ref int IA,
    ref int IA1,
    ref double RHS
  );

public delegate void D02TGF_BDYC_DELEGATE(
    ref double X,
    ref int I,
    ref int J,
    IntPtr A_rptr,
    ref int IA,
    ref int IA1,
    ref double RHS
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02TGF(
    ref int N,
    [In] int[] M,
    [In] int[] L,
    ref double X0,
    ref double X1,
    ref int K1,
    ref int KP,
    [Out] double[,] C,
    ref int LDC,
    D02TGF_COEFF_DELEGATE COEFF,
    D02TGF_BDYC_DELEGATE BDYC,
    [Out] double[] W,
    ref int LW,
    [Out] int[] IW,
    ref int LIW,
    ref int IFAIL
   );


public delegate void D02TLF_FFUN_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    ref int NEQ,
    IntPtr M_iptr,
    IntPtr F_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D02TLF_FJAC_DELEGATE(
    ref double X,
    IntPtr Y_rptr,
    ref int NEQ,
    IntPtr M_iptr,
    IntPtr DFDY_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D02TLF_GAFUN_DELEGATE(
    IntPtr YA_rptr,
    ref int NEQ,
    IntPtr M_iptr,
    ref int NLBC,
    IntPtr GA_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D02TLF_GBFUN_DELEGATE(
    IntPtr YB_rptr,
    ref int NEQ,
    IntPtr M_iptr,
    ref int NRBC,
    IntPtr GB_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D02TLF_GAJAC_DELEGATE(
    IntPtr YA_rptr,
    ref int NEQ,
    IntPtr M_iptr,
    ref int NLBC,
    IntPtr DGADY_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D02TLF_GBJAC_DELEGATE(
    IntPtr YB_rptr,
    ref int NEQ,
    IntPtr M_iptr,
    ref int NRBC,
    IntPtr DGBDY_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D02TLF_GUESS_DELEGATE(
    ref double X,
    ref int NEQ,
    IntPtr M_iptr,
    IntPtr Y_rptr,
    IntPtr DYM_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02TLF(
    D02TLF_FFUN_DELEGATE FFUN,
    D02TLF_FJAC_DELEGATE FJAC,
    D02TLF_GAFUN_DELEGATE GAFUN,
    D02TLF_GBFUN_DELEGATE GBFUN,
    D02TLF_GAJAC_DELEGATE GAJAC,
    D02TLF_GBJAC_DELEGATE GBJAC,
    D02TLF_GUESS_DELEGATE GUESS,
    [In,Out] double[] RCOMM,
    [In,Out] int[] ICOMM,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02TVF(
    ref int NEQ,
    [In] int[] M,
    ref int NLBC,
    ref int NRBC,
    ref int NCOL,
    [In] double[] TOLS,
    ref int MXMESH,
    ref int NMESH,
    [In] double[] MESH,
    [In] int[] IPMESH,
    [Out] double[] RCOMM,
    ref int LRCOMM,
    [Out] int[] ICOMM,
    ref int LICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02TXF(
    ref int MXMESH,
    ref int NMESH,
    [In] double[] MESH,
    [In] int[] IPMESH,
    [In,Out] double[] RCOMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02TYF(
    ref double X,
    [Out] double[,] Y,
    ref int NEQ,
    ref int MMAX,
    [In,Out] double[] RCOMM,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02TZF(
    ref int MXMESH,
    ref int NMESH,
    [Out] double[] MESH,
    [Out] int[] IPMESH,
    ref double ERMX,
    ref int IERMX,
    ref int IJERMX,
    [In] double[] RCOMM,
    [In] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UAF(
    ref int N,
    [In] double[] F,
    [Out] double[] C,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UBF(
    ref int N,
    ref double A,
    ref double B,
    ref int Q,
    [In] double[] C,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UCF(
    ref int N,
    ref double A,
    ref double B,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UDF(
    ref int N,
    [In] double[] F,
    [Out] double[] FD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UEF(
    ref int N,
    ref double A,
    ref double B,
    ref int M,
    [In] double[] C,
    [In,Out] double[,] BMAT,
    [In] double[] Y,
    [In] double[] BVEC,
    [In,Out] double[] F,
    [Out] double[,] UC,
    ref double RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UWF(
    ref int N,
    ref int NIP,
    [In] double[] X,
    [In] double[] F,
    [Out] double[] XIP,
    [Out] double[] FIP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UYF(
    ref int N,
    [Out] double[] W,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02UZF(
    ref int K,
    ref double X,
    ref double T,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02XJF(
    ref double XSOL,
    [Out] double[] SOL,
    ref int M,
    [In] double[,] YSAV,
    ref int LDYSAV,
    ref int SDYSAV,
    ref int NEQ,
    ref double X,
    ref int NQU,
    ref double HU,
    ref double H,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D02XKF(
    ref double XSOL,
    [Out] double[] SOL,
    ref int M,
    [In] double[,] YSAV,
    ref int LDYSAV,
    ref int SDYSAV,
    [In] double[] ACOR,
    ref int NEQ,
    ref double X,
    ref int NQU,
    ref double HU,
    ref double H,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D02ZAF(
    ref int NEQ,
    [In] double[] V,
    [In] double[] W,
    ref int IFAIL
   );


// chapter d03

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03EAF(
    ref int STAGE1,
    ref int EXT,
    ref int DORM,
    ref int N,
    ref double P,
    ref double Q,
    [In] double[] X,
    [In] double[] Y,
    ref int N1P1,
    [In,Out] double[] PHI,
    [In,Out] double[] PHID,
    ref double ALPHA,
    [Out] double[,] C,
    ref int LDC,
    ref int NP4,
    [Out] int[] ICINT,
    ref int NP1,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03EBF(
    ref int N1, ref int N2, ref int LDA,
    [In] double[,] A, [In] double[,] B, [In] double[,] C,
    [In] double[,] D, [In] double[,] E, [In] double[,] Q,
    [In,Out] double[,] T, ref double APARAM, ref int ITMAX,
    ref int ITCOUN, ref int ITUSED, ref int NDIR,
    ref int IXN, ref int IYN, ref double CONRES,
    ref double CONCHN, [Out] double[] RESIDS, [Out] double[] CHNGS,
    [Out] double[,] WRKSP1, [Out] double[,] WRKSP2, [Out] double[,] WRKSP3,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03ECF(
    ref int N1, ref int N2, ref int N3,
    ref int LDA, ref int SDA, [In] double[,,] A,
    [In] double[,,] B, [In] double[,,] C, [In] double[,,] D,
    [In] double[,,] E, [In] double[,,] F, [In] double[,,] G,
    [In] double[,,] Q, [In,Out] double[,,] T, ref double APARAM,
    ref int ITMAX, ref int ITCOUN, ref int ITUSED,
    ref int NDIR, ref int IXN, ref int IYN,
    ref int IZN, ref double CONRES, ref double CONCHN,
    [Out] double[] RESIDS, [Out] double[] CHNGS, [Out] double[,,] WRKSP1,
    [Out] double[,,] WRKSP2, [Out] double[,,] WRKSP3, [Out] double[,,] WRKSP4,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03EDF(
    ref int NGX,
    ref int NGY,
    ref int LDA,
    [In,Out] double[,] A,
    [In,Out] double[] RHS,
    [In,Out] double[] UB,
    ref int MAXIT,
    ref double ACC,
    [Out] double[] US,
    [Out] double[] U,
    ref int IOUT,
    ref int NUMIT,
    ref int IFAIL
   );


public delegate void D03EEF_PDEF_DELEGATE(
    ref double X,
    ref double Y,
    ref double ALPHA,
    ref double BETA,
    ref double GAMMA,
    ref double DELTA,
    ref double EPSLON,
    ref double PHI,
    ref double PSI
  );

public delegate void D03EEF_BNDY_DELEGATE(
    ref double X,
    ref double Y,
    ref double A,
    ref double B,
    ref double C,
    ref int IBND
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03EEF(
    ref double XMIN,
    ref double XMAX,
    ref double YMIN,
    ref double YMAX,
    D03EEF_PDEF_DELEGATE PDEF,
    D03EEF_BNDY_DELEGATE BNDY,
    ref int NGX,
    ref int NGY,
    ref int LDA,
    [Out] double[,] A,
    [Out] double[] RHS,
    string SCHEME,
    ref int IFAIL
,
    long SCHEMELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03FAF(
    ref double XS, ref double XF, ref int L,
    ref int LBDCND, [In] double[,] BDXS, [In] double[,] BDXF,
    ref double YS, ref double YF, ref int M,
    ref int MBDCND, [In] double[,] BDYS, [In] double[,] BDYF,
    ref double ZS, ref double ZF, ref int N,
    ref int NBDCND, [In] double[,] BDZS, [In] double[,] BDZF,
    ref double LAMBDA, ref int LDF, ref int LDF2,
    [In,Out] double[,,] F, ref double PERTRB, [Out] double[] W,
    ref int LWRK, ref int IFAIL
   );


public delegate int D03MAF_ISIN_DELEGATE(
    ref double X,
    ref double Y
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03MAF(
    ref double H,
    ref int M,
    ref int N,
    ref int NB,
    ref int NPTS,
    [Out] double[,] PLACES,
    [Out] int[,] INDX,
    ref int SDINDX,
    D03MAF_ISIN_DELEGATE ISIN,
    [Out] double[,] DIST,
    ref int SDDIST,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03NCF(
    ref int KOPT, ref double X, string MESH,
    ref int NS, [In,Out] double[] S, ref int NT,
    [In,Out] double[] T, [In] int[] TDPAR, [In] double[] R,
    [In] double[] Q, [In] double[] SIGMA, ref double ALPHA,
    ref int NTKEEP, [Out] double[,] F, [Out] double[,] THETA,
    [Out] double[,] DELTA, [Out] double[,] GAMMA, [Out] double[,] LAMBDA,
    [Out] double[,] RHO, ref int LDF, [Out] double[] WORK,
    [Out] int[] IWORK, ref int IFAIL
,
    long MESHLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03NDF(
    ref int KOPT,
    ref double X,
    ref double S,
    ref double T,
    ref double TMAT,
    [In] int[] TDPAR,
    [In] double[] R,
    [In] double[] Q,
    [In] double[] SIGMA,
    ref double F,
    ref double THETA,
    ref double DELTA,
    ref double GAMMA,
    ref double LAMBDA,
    ref double RHO,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03NEF(
    ref double T0,
    ref double TMAT,
    ref int NTD,
    [In] double[] TD,
    [In] double[] PHID,
    [Out] double[] PHIAV,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


public delegate void D03PCA_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PCA_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PCA(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PCA_PDEDEF_DELEGATE PDEDEF, D03PCA_BNDARY_DELEGATE BNDARY,
    [In,Out] double[,] U, ref int NPTS, [In] double[] X,
    ref double ACC, [In,Out] double[] RSAVE, ref int LRSAVE,
    [In,Out] int[] ISAVE, ref int LISAVE, ref int ITASK,
    ref int ITRACE, ref int IND, [In,Out] int[] IUSER,
    [In,Out] double[] RUSER, [In,Out] byte[,] CWSAV, [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV, [In,Out] double[] RWSAV, ref int IFAIL
,
    long CWSAVLength
    );

public delegate void D03PCF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D03PCF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PCF(
    ref int NPDE,
    ref int M,
    ref double TS,
    ref double TOUT,
    D03PCF_PDEDEF_DELEGATE PDEDEF,
    D03PCF_BNDARY_DELEGATE BNDARY,
    [In,Out] double[,] U,
    ref int NPTS,
    [In] double[] X,
    ref double ACC,
    [In,Out] double[] RSAVE,
    ref int LRSAVE,
    [In,Out] int[] ISAVE,
    ref int LISAVE,
    ref int ITASK,
    ref int ITRACE,
    ref int IND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D53PCK(
    ref int NPDE,
    ref double T,
    ref int NV,
    [In] double[] V,
    [In] double[] VDOT,
    ref int NXI,
    [In] double[] XI,
    [In] double[,] UCP,
    [In] double[,] UCPX,
    [In] double[,] RCP,
    [In] double[,] UCPT,
    [In] double[,] UCPTX,
    [Out] double[] F,
    ref int IRES,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PCK(
    ref int NPDE,
    ref double T,
    ref int NV,
    [In] double[] V,
    [In] double[] VDOT,
    ref int NXI,
    [In] double[] XI,
    [In] double[,] UCP,
    [In] double[,] UCPX,
    [In] double[,] RCP,
    [In] double[,] UCPT,
    [In] double[,] UCPTX,
    [Out] double[] F,
    ref int IRES
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D53PCL(
    ref double T,
    ref int NPTS,
    ref int NPDE,
    [In] double[] X,
    [In] double[,] U,
    [In] double[,] R,
    [Out] double[] FMON,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PCL(
    ref double T,
    ref int NPTS,
    ref int NPDE,
    [In] double[] X,
    [In] double[,] U,
    [In] double[,] R,
    [Out] double[] FMON
   );


public delegate void D03PDA_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    ref int NPTL,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PDA_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PDA_UINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    IntPtr X_rptr,
    IntPtr U_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PDA(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PDA_PDEDEF_DELEGATE PDEDEF, D03PDA_BNDARY_DELEGATE BNDARY,
    [In,Out] double[,] U, ref int NBKPTS, [In] double[] XBKPTS,
    ref int NPOLY, ref int NPTS, [Out] double[] X,
    D03PDA_UINIT_DELEGATE UINIT, ref double ACC, [In,Out] double[] RSAVE,
    ref int LRSAVE, [In,Out] int[] ISAVE, ref int LISAVE,
    ref int ITASK, ref int ITRACE, ref int IND,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, [In,Out] byte[,] CWSAV,
    [In,Out] int[] LWSAV, [In,Out] int[] IWSAV, [In,Out] double[] RWSAV,
    ref int IFAIL
,
    long CWSAVLength
    );

public delegate void D03PDF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    ref int NPTL,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D03PDF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES
  );

public delegate void D03PDF_UINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    IntPtr X_rptr,
    IntPtr U_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PDF(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PDF_PDEDEF_DELEGATE PDEDEF, D03PDF_BNDARY_DELEGATE BNDARY,
    [In,Out] double[,] U, ref int NBKPTS, [In] double[] XBKPTS,
    ref int NPOLY, ref int NPTS, [Out] double[] X,
    D03PDF_UINIT_DELEGATE UINIT, ref double ACC, [In,Out] double[] RSAVE,
    ref int LRSAVE, [In,Out] int[] ISAVE, ref int LISAVE,
    ref int ITASK, ref int ITRACE, ref int IND,
    ref int IFAIL
   );


public delegate void D03PEF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr UX_rptr,
    IntPtr RES_rptr,
    ref int IRES
  );

public delegate void D03PEF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int IBND,
    ref int NOBC,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr RES_rptr,
    ref int IRES
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PEF(
    ref int NPDE,
    ref double TS,
    ref double TOUT,
    D03PEF_PDEDEF_DELEGATE PDEDEF,
    D03PEF_BNDARY_DELEGATE BNDARY,
    [In,Out] double[,] U,
    ref int NPTS,
    [In] double[] X,
    ref int NLEFT,
    ref double ACC,
    [In,Out] double[] RSAVE,
    ref int LRSAVE,
    [In,Out] int[] ISAVE,
    ref int LISAVE,
    ref int ITASK,
    ref int ITRACE,
    ref int IND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PEK(
    ref int NPDE,
    ref double T,
    ref int NV,
    [In] double[] V,
    [In] double[] VDOT,
    ref int NXI,
    [In] double[] XI,
    [In] double[,] UCP,
    [In] double[,] UCPX,
    [In] double[,] UCPT,
    [Out] double[] R,
    ref int IRES
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PEL(
    ref double T,
    ref int NPTS,
    ref int NPDE,
    [In] double[] X,
    [In] double[,] U,
    [Out] double[] FMON
   );


public delegate void D03PFF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    IntPtr P_rptr,
    IntPtr C_rptr,
    IntPtr D_rptr,
    IntPtr S_rptr,
    ref int IRES
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PFP(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    IntPtr P_rptr,
    IntPtr C_rptr,
    IntPtr D_rptr,
    IntPtr S_rptr,
    ref int IRES
  );

public delegate void D03PFF_NUMFLX_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr ULEFT_rptr,
    IntPtr URIGHT_rptr,
    IntPtr FLUX_rptr,
    ref int IRES
  );

public delegate void D03PFF_BNDARY_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    ref double T,
    IntPtr X_rptr,
    IntPtr U_rptr,
    ref int IBND,
    IntPtr G_rptr,
    ref int IRES
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PFF(
    ref int NPDE,
    ref double TS,
    ref double TOUT,
    D03PFF_PDEDEF_DELEGATE PDEDEF,
    D03PFF_NUMFLX_DELEGATE NUMFLX,
    D03PFF_BNDARY_DELEGATE BNDARY,
    [In,Out] double[,] U,
    ref int NPTS,
    [In] double[] X,
    [In] double[] ACC,
    ref double TSMAX,
    [In,Out] double[] RSAVE,
    ref int LRSAVE,
    [In,Out] int[] ISAVE,
    ref int LISAVE,
    ref int ITASK,
    ref int ITRACE,
    ref int IND,
    ref int IFAIL
   );


public delegate void D03PHA_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PHA_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PHA_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr RCP_rptr,
    IntPtr UCPT_rptr,
    IntPtr UCPTX_rptr,
    IntPtr F_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PHA(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PHA_PDEDEF_DELEGATE PDEDEF, D03PHA_BNDARY_DELEGATE BNDARY,
    [In,Out] double[] U, ref int NPTS, [In] double[] X,
    ref int NV, D03PHA_ODEDEF_DELEGATE ODEDEF, ref int NXI,
    [In] double[] XI, ref int NEQN, [In] double[] RTOL,
    [In] double[] ATOL, ref int ITOL, string NORM,
    string LAOPT, [In] double[] ALGOPT, [In,Out] double[] RSAVE,
    ref int LRSAVE, [In,Out] int[] ISAVE, ref int LISAVE,
    ref int ITASK, ref int ITRACE, ref int IND,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, [In,Out] byte[,] CWSAV,
    [In,Out] int[] LWSAV, [In,Out] int[] IWSAV, [In,Out] double[] RWSAV,
    ref int IFAIL
,
    long NORMLength,
    long LAOPTLength,
    long CWSAVLength
    );

public delegate void D03PHF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D03PHF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES
  );

public delegate void D03PHF_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr RCP_rptr,
    IntPtr UCPT_rptr,
    IntPtr UCPTX_rptr,
    IntPtr F_rptr,
    ref int IRES
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PHF(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PHF_PDEDEF_DELEGATE PDEDEF, D03PHF_BNDARY_DELEGATE BNDARY,
    [In,Out] double[] U, ref int NPTS, [In] double[] X,
    ref int NV, D03PHF_ODEDEF_DELEGATE ODEDEF, ref int NXI,
    [In] double[] XI, ref int NEQN, [In] double[] RTOL,
    [In] double[] ATOL, ref int ITOL, string NORM,
    string LAOPT, [In] double[] ALGOPT, [In,Out] double[] RSAVE,
    ref int LRSAVE, [In,Out] int[] ISAVE, ref int LISAVE,
    ref int ITASK, ref int ITRACE, ref int IND,
    ref int IFAIL
,
    long NORMLength,
    long LAOPTLength
    );


public delegate void D03PJA_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    ref int NPTL,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PJA_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PJA_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr RCP_rptr,
    IntPtr UCPT_rptr,
    IntPtr UCPTX_rptr,
    IntPtr F_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


public delegate void D03PJA_UVINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    IntPtr X_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PJA(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PJA_PDEDEF_DELEGATE PDEDEF, D03PJA_BNDARY_DELEGATE BNDARY,
    [In,Out] double[] U, ref int NBKPTS, [In] double[] XBKPTS,
    ref int NPOLY, ref int NPTS, [Out] double[] X,
    ref int NV, D03PJA_ODEDEF_DELEGATE ODEDEF, ref int NXI,
    [In] double[] XI, ref int NEQN, D03PJA_UVINIT_DELEGATE UVINIT,
    [In] double[] RTOL, [In] double[] ATOL, ref int ITOL,
    string NORM, string LAOPT, [In] double[] ALGOPT,
    [In,Out] double[] RSAVE, ref int LRSAVE, [In,Out] int[] ISAVE,
    ref int LISAVE, ref int ITASK, ref int ITRACE,
    ref int IND, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    [In,Out] byte[,] CWSAV, [In,Out] int[] LWSAV, [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV, ref int IFAIL
,
    long NORMLength,
    long LAOPTLength,
    long CWSAVLength
    );

public delegate void D03PJF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    ref int NPTL,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D03PJF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES
  );

public delegate void D03PJF_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr RCP_rptr,
    IntPtr UCPT_rptr,
    IntPtr UCPTX_rptr,
    IntPtr F_rptr,
    ref int IRES
  );


public delegate void D03PJF_UVINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    IntPtr X_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PJF(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PJF_PDEDEF_DELEGATE PDEDEF, D03PJF_BNDARY_DELEGATE BNDARY,
    [In,Out] double[] U, ref int NBKPTS, [In] double[] XBKPTS,
    ref int NPOLY, ref int NPTS, [Out] double[] X,
    ref int NV, D03PJF_ODEDEF_DELEGATE ODEDEF, ref int NXI,
    [In] double[] XI, ref int NEQN, D03PJF_UVINIT_DELEGATE UVINIT,
    [In] double[] RTOL, [In] double[] ATOL, ref int ITOL,
    string NORM, string LAOPT, [In] double[] ALGOPT,
    [In,Out] double[] RSAVE, ref int LRSAVE, [In,Out] int[] ISAVE,
    ref int LISAVE, ref int ITASK, ref int ITRACE,
    ref int IND, ref int IFAIL
,
    long NORMLength,
    long LAOPTLength
    );


public delegate void D03PKF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr RES_rptr,
    ref int IRES
  );

public delegate void D03PKF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int IBND,
    ref int NOBC,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr RES_rptr,
    ref int IRES
  );

public delegate void D03PKF_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr UCPT_rptr,
    IntPtr R_rptr,
    ref int IRES
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PKF(
    ref int NPDE, ref double TS, ref double TOUT,
    D03PKF_PDEDEF_DELEGATE PDEDEF, D03PKF_BNDARY_DELEGATE BNDARY, [In,Out] double[] U,
    ref int NPTS, [In] double[] X, ref int NLEFT,
    ref int NV, D03PKF_ODEDEF_DELEGATE ODEDEF, ref int NXI,
    [In] double[] XI, ref int NEQN, [In] double[] RTOL,
    [In] double[] ATOL, ref int ITOL, string NORM,
    string LAOPT, [In] double[] ALGOPT, [In,Out] double[] RSAVE,
    ref int LRSAVE, [In,Out] int[] ISAVE, ref int LISAVE,
    ref int ITASK, ref int ITRACE, ref int IND,
    ref int IFAIL
,
    long NORMLength,
    long LAOPTLength
    );


public delegate void D03PLF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr C_rptr,
    IntPtr D_rptr,
    IntPtr S_rptr,
    ref int IRES
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PLP(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr C_rptr,
    IntPtr D_rptr,
    IntPtr S_rptr,
    ref int IRES
  );

public delegate void D03PLF_NUMFLX_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    ref int NV,
    IntPtr V_rptr,
    IntPtr ULEFT_rptr,
    IntPtr URIGHT_rptr,
    IntPtr FLUX_rptr,
    ref int IRES
  );

public delegate void D03PLF_BNDARY_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    ref double T,
    IntPtr X_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr G_rptr,
    ref int IRES
  );

public delegate void D03PLF_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr UCPT_rptr,
    IntPtr R_rptr,
    ref int IRES
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PLF(
    ref int NPDE, ref double TS, ref double TOUT,
    D03PLF_PDEDEF_DELEGATE PDEDEF, D03PLF_NUMFLX_DELEGATE NUMFLX, D03PLF_BNDARY_DELEGATE BNDARY,
    [In,Out] double[] U, ref int NPTS, [In] double[] X,
    ref int NV, D03PLF_ODEDEF_DELEGATE ODEDEF, ref int NXI,
    [In] double[] XI, ref int NEQN, [In] double[] RTOL,
    [In] double[] ATOL, ref int ITOL, string NORM,
    string LAOPT, [In] double[] ALGOPT, [In,Out] double[] RSAVE,
    ref int LRSAVE, [In,Out] int[] ISAVE, ref int LISAVE,
    ref int ITASK, ref int ITRACE, ref int IND,
    ref int IFAIL
,
    long NORMLength,
    long LAOPTLength
    );


public delegate void D03PPA_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PPA_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PPA_UVINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    ref int NXI,
    IntPtr X_rptr,
    IntPtr XI_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void D03PPA_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr RCP_rptr,
    IntPtr UCPT_rptr,
    IntPtr UCPTX_rptr,
    IntPtr F_rptr,
    ref int IRES,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


public delegate void D03PPA_MONITF_DELEGATE(
    ref double T,
    ref int NPTS,
    ref int NPDE,
    IntPtr X_rptr,
    IntPtr U_rptr,
    IntPtr R_rptr,
    IntPtr FMON_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PPA(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PPA_PDEDEF_DELEGATE PDEDEF, D03PPA_BNDARY_DELEGATE BNDARY,
    D03PPA_UVINIT_DELEGATE UVINIT, [In,Out] double[] U, ref int NPTS,
    [In,Out] double[] X, ref int NV, D03PPA_ODEDEF_DELEGATE ODEDEF,
    ref int NXI, [In] double[] XI, ref int NEQN,
    [In] double[] RTOL, [In] double[] ATOL, ref int ITOL,
    string NORM, string LAOPT, [In] double[] ALGOPT,
    ref int REMESH, ref int NXFIX, [In] double[] XFIX,
    ref int NRMESH, ref double DXMESH, ref double TRMESH,
    ref int IPMINF, ref double XRATIO, ref double CON,
    D03PPA_MONITF_DELEGATE MONITF, [In,Out] double[] RSAVE, ref int LRSAVE,
    [In,Out] int[] ISAVE, ref int LISAVE, ref int ITASK,
    ref int ITRACE, ref int IND, [In,Out] int[] IUSER,
    [In,Out] double[] RUSER, [In,Out] byte[,] CWSAV, [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV, [In,Out] double[] RWSAV, ref int IFAIL
,
    long NORMLength,
    long LAOPTLength,
    long CWSAVLength
    );

public delegate void D03PPF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr Q_rptr,
    IntPtr R_rptr,
    ref int IRES
  );

public delegate void D03PPF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr BETA_rptr,
    IntPtr GAMMA_rptr,
    ref int IRES
  );

public delegate void D03PPF_UVINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    ref int NXI,
    IntPtr X_rptr,
    IntPtr XI_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr
  );

public delegate void D03PPF_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr RCP_rptr,
    IntPtr UCPT_rptr,
    IntPtr UCPTX_rptr,
    IntPtr F_rptr,
    ref int IRES
  );


public delegate void D03PPF_MONITF_DELEGATE(
    ref double T,
    ref int NPTS,
    ref int NPDE,
    IntPtr X_rptr,
    IntPtr U_rptr,
    IntPtr R_rptr,
    IntPtr FMON_rptr
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PPF(
    ref int NPDE, ref int M, ref double TS,
    ref double TOUT, D03PPF_PDEDEF_DELEGATE PDEDEF, D03PPF_BNDARY_DELEGATE BNDARY,
    D03PPF_UVINIT_DELEGATE UVINIT, [In,Out] double[] U, ref int NPTS,
    [In,Out] double[] X, ref int NV, D03PPF_ODEDEF_DELEGATE ODEDEF,
    ref int NXI, [In] double[] XI, ref int NEQN,
    [In] double[] RTOL, [In] double[] ATOL, ref int ITOL,
    string NORM, string LAOPT, [In] double[] ALGOPT,
    ref int REMESH, ref int NXFIX, [In] double[] XFIX,
    ref int NRMESH, ref double DXMESH, ref double TRMESH,
    ref int IPMINF, ref double XRATIO, ref double CON,
    D03PPF_MONITF_DELEGATE MONITF, [In,Out] double[] RSAVE, ref int LRSAVE,
    [In,Out] int[] ISAVE, ref int LISAVE, ref int ITASK,
    ref int ITRACE, ref int IND, ref int IFAIL
,
    long NORMLength,
    long LAOPTLength
    );


public delegate void D03PRF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr RES_rptr,
    ref int IRES
  );

public delegate void D03PRF_BNDARY_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int IBND,
    ref int NOBC,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr RES_rptr,
    ref int IRES
  );

public delegate void D03PRF_UVINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    ref int NXI,
    IntPtr X_rptr,
    IntPtr XI_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr
  );

public delegate void D03PRF_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr UCPT_rptr,
    IntPtr R_rptr,
    ref int IRES
  );


public delegate void D03PRF_MONITF_DELEGATE(
    ref double T,
    ref int NPTS,
    ref int NPDE,
    IntPtr X_rptr,
    IntPtr U_rptr,
    IntPtr FMON_rptr
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PRF(
    ref int NPDE, ref double TS, ref double TOUT,
    D03PRF_PDEDEF_DELEGATE PDEDEF, D03PRF_BNDARY_DELEGATE BNDARY, D03PRF_UVINIT_DELEGATE UVINIT,
    [In,Out] double[] U, ref int NPTS, [In,Out] double[] X,
    ref int NLEFT, ref int NV, D03PRF_ODEDEF_DELEGATE ODEDEF,
    ref int NXI, [In] double[] XI, ref int NEQN,
    [In] double[] RTOL, [In] double[] ATOL, ref int ITOL,
    string NORM, string LAOPT, [In] double[] ALGOPT,
    ref int REMESH, ref int NXFIX, [In] double[] XFIX,
    ref int NRMESH, ref double DXMESH, ref double TRMESH,
    ref int IPMINF, ref double XRATIO, ref double CON,
    D03PRF_MONITF_DELEGATE MONITF, [In,Out] double[] RSAVE, ref int LRSAVE,
    [In,Out] int[] ISAVE, ref int LISAVE, ref int ITASK,
    ref int ITRACE, ref int IND, ref int IFAIL
,
    long NORMLength,
    long LAOPTLength
    );


public delegate void D03PSF_PDEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    IntPtr U_rptr,
    IntPtr UX_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    IntPtr P_rptr,
    IntPtr C_rptr,
    IntPtr D_rptr,
    IntPtr S_rptr,
    ref int IRES
  );


public delegate void D03PSF_NUMFLX_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double X,
    ref int NV,
    IntPtr V_rptr,
    IntPtr ULEFT_rptr,
    IntPtr URIGHT_rptr,
    IntPtr FLUX_rptr,
    ref int IRES
  );

public delegate void D03PSF_BNDARY_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    ref double T,
    IntPtr X_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int IBND,
    IntPtr G_rptr,
    ref int IRES
  );

public delegate void D03PSF_UVINIT_DELEGATE(
    ref int NPDE,
    ref int NPTS,
    ref int NXI,
    IntPtr X_rptr,
    IntPtr XI_rptr,
    IntPtr U_rptr,
    ref int NV,
    IntPtr V_rptr
  );

public delegate void D03PSF_ODEDEF_DELEGATE(
    ref int NPDE,
    ref double T,
    ref int NV,
    IntPtr V_rptr,
    IntPtr VDOT_rptr,
    ref int NXI,
    IntPtr XI_rptr,
    IntPtr UCP_rptr,
    IntPtr UCPX_rptr,
    IntPtr UCPT_rptr,
    IntPtr R_rptr,
    ref int IRES
  );


public delegate void D03PSF_MONITF_DELEGATE(
    ref double T,
    ref int NPTS,
    ref int NPDE,
    IntPtr X_rptr,
    IntPtr U_rptr,
    IntPtr FMON_rptr
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PSF(
    ref int NPDE, ref double TS, ref double TOUT,
    D03PSF_PDEDEF_DELEGATE PDEDEF, D03PSF_NUMFLX_DELEGATE NUMFLX, D03PSF_BNDARY_DELEGATE BNDARY,
    D03PSF_UVINIT_DELEGATE UVINIT, [In,Out] double[] U, ref int NPTS,
    [In,Out] double[] X, ref int NV, D03PSF_ODEDEF_DELEGATE ODEDEF,
    ref int NXI, [In] double[] XI, ref int NEQN,
    [In] double[] RTOL, [In] double[] ATOL, ref int ITOL,
    string NORM, string LAOPT, [In] double[] ALGOPT,
    ref int REMESH, ref int NXFIX, [In] double[] XFIX,
    ref int NRMESH, ref double DXMESH, ref double TRMESH,
    ref int IPMINF, ref double XRATIO, ref double CON,
    D03PSF_MONITF_DELEGATE MONITF, [In,Out] double[] RSAVE, ref int LRSAVE,
    [In,Out] int[] ISAVE, ref int LISAVE, ref int ITASK,
    ref int ITRACE, ref int IND, ref int IFAIL
,
    long NORMLength,
    long LAOPTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PUF(
    [In] double[] ULEFT,
    [In] double[] URIGHT,
    ref double GAMMA,
    [Out] double[] FLUX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PVF(
    [In] double[] ULEFT,
    [In] double[] URIGHT,
    ref double GAMMA,
    string PATH,
    [Out] double[] FLUX,
    ref int IFAIL
,
    long PATHLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PWF(
    [In] double[] ULEFT,
    [In] double[] URIGHT,
    ref double GAMMA,
    [Out] double[] FLUX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PXF(
    [In] double[] ULEFT,
    [In] double[] URIGHT,
    ref double GAMMA,
    ref double TOL,
    ref int NITER,
    [Out] double[] FLUX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PYF(
    ref int NPDE,
    [In] double[,] U,
    ref int NBKPTS,
    [In] double[] XBKPTS,
    ref int NPOLY,
    ref int NPTS,
    [In] double[] XP,
    ref int INTPTS,
    ref int ITYPE,
    [Out] double[,,] UP,
    [In,Out] double[] RSAVE,
    ref int LRSAVE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03PZF(
    ref int NPDE,
    ref int M,
    [In] double[,] U,
    ref int NPTS,
    [In] double[] X,
    [In] double[] XP,
    ref int INTPTS,
    ref int ITYPE,
    [Out] double[,,] UP,
    ref int IFAIL
   );


public delegate void D03RAF_PDEDEF_DELEGATE(
    ref int NPTS,
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr UX_rptr,
    IntPtr UY_rptr,
    IntPtr UXX_rptr,
    IntPtr UXY_rptr,
    IntPtr UYY_rptr,
    IntPtr RES_rptr
  );

public delegate void D03RAF_BNDARY_DELEGATE(
    ref int NPTS,
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr UX_rptr,
    IntPtr UY_rptr,
    ref int NBPTS,
    IntPtr LBND_iptr,
    IntPtr RES_rptr
  );

public delegate void D03RAF_PDEIV_DELEGATE(
    ref int NPTS,
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    IntPtr U_rptr
  );

public delegate void D03RAF_MONITR_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double DT,
    ref double DTNEW,
    ref int TLAST,
    ref int NLEV,
    IntPtr NGPTS_iptr,
    IntPtr XPTS_rptr,
    IntPtr YPTS_rptr,
    IntPtr LSOL_iptr,
    IntPtr SOL_rptr,
    ref int IERR
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03RAF(
    ref int NPDE, ref double TS, ref double TOUT,
    [In,Out] double[] DT, ref double XMIN, ref double XMAX,
    ref double YMIN, ref double YMAX, ref int NX,
    ref int NY, ref double TOLS, ref double TOLT,
    D03RAF_PDEDEF_DELEGATE PDEDEF, D03RAF_BNDARY_DELEGATE BNDARY, D03RAF_PDEIV_DELEGATE PDEIV,
    D03RAF_MONITR_DELEGATE MONITR, [In] int[] OPTI, [In] double[,] OPTR,
    [In,Out] double[] RWK, ref int LENRWK, [In,Out] int[] IWK,
    ref int LENIWK, [Out] int[] LWK, ref int LENLWK,
    ref int ITRACE, ref int IND, ref int IFAIL
   );


public delegate void D03RBF_INIDOM_DELEGATE(
    ref int MAXPTS,
    ref double XMIN,
    ref double XMAX,
    ref double YMIN,
    ref double YMAX,
    ref int NX,
    ref int NY,
    ref int NPTS,
    ref int NROWS,
    ref int NBNDS,
    ref int NBPTS,
    IntPtr LROW_iptr,
    IntPtr IROW_iptr,
    IntPtr ICOL_iptr,
    IntPtr LLBND_iptr,
    IntPtr ILBND_iptr,
    IntPtr LBND_iptr,
    ref int IERR
  );

public delegate void D03RBF_PDEDEF_DELEGATE(
    ref int NPTS,
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr UX_rptr,
    IntPtr UY_rptr,
    IntPtr UXX_rptr,
    IntPtr UXY_rptr,
    IntPtr UYY_rptr,
    IntPtr RES_rptr
  );

public delegate void D03RBF_BNDARY_DELEGATE(
    ref int NPTS,
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    IntPtr U_rptr,
    IntPtr UT_rptr,
    IntPtr UX_rptr,
    IntPtr UY_rptr,
    ref int NBNDS,
    ref int NBPTS,
    IntPtr LLBND_iptr,
    IntPtr ILBND_iptr,
    IntPtr LBND_iptr,
    IntPtr RES_rptr
  );

public delegate void D03RBF_PDEIV_DELEGATE(
    ref int NPTS,
    ref int NPDE,
    ref double T,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    IntPtr U_rptr
  );

public delegate void D03RBF_MONITR_DELEGATE(
    ref int NPDE,
    ref double T,
    ref double DT,
    ref double DTNEW,
    ref int TLAST,
    ref int NLEV,
    ref double XMIN,
    ref double YMIN,
    ref double DXB,
    ref double DYB,
    IntPtr LGRID_iptr,
    IntPtr ISTRUC_iptr,
    IntPtr LSOL_iptr,
    IntPtr SOL_rptr,
    ref int IERR
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03RBF(
    ref int NPDE, ref double TS, ref double TOUT,
    [In,Out] double[] DT, ref double TOLS, ref double TOLT,
    D03RBF_INIDOM_DELEGATE INIDOM, D03RBF_PDEDEF_DELEGATE PDEDEF, D03RBF_BNDARY_DELEGATE BNDARY,
    D03RBF_PDEIV_DELEGATE PDEIV, D03RBF_MONITR_DELEGATE MONITR, [In] int[] OPTI,
    [In] double[,] OPTR, [In,Out] double[] RWK, ref int LENRWK,
    [In,Out] int[] IWK, ref int LENIWK, [Out] int[] LWK,
    ref int LENLWK, ref int ITRACE, ref int IND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03RZF(
    ref int LEVEL,
    ref int NLEV,
    ref double XMIN,
    ref double YMIN,
    ref double DXB,
    ref double DYB,
    [In] int[] LGRID,
    [In] int[] ISTRUC,
    ref int NPTS,
    [Out] double[] X,
    [Out] double[] Y,
    ref int LENXY,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03UAF(
    ref int N1,
    ref int N2,
    ref int LDA,
    [In] double[,] A,
    [In] double[,] B,
    [In] double[,] C,
    [In] double[,] D,
    [In] double[,] E,
    ref double APARAM,
    ref int IT,
    [In,Out] double[,] R,
    [Out] double[,] WRKSP1,
    [Out] double[,] WRKSP2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D03UBF(
    ref int N1,
    ref int N2,
    ref int N3,
    ref int LDA,
    ref int SDA,
    [In] double[,,] A,
    [In] double[,,] B,
    [In] double[,,] C,
    [In] double[,,] D,
    [In] double[,,] E,
    [In] double[,,] F,
    [In] double[,,] G,
    ref double APARAM,
    ref int IT,
    [In,Out] double[,,] R,
    [Out] double[,,] WRKSP1,
    [Out] double[,,] WRKSP2,
    [Out] double[,,] WRKSP3,
    ref int IFAIL
   );


// chapter d04

public delegate double D04AAF_F_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D04AAF(
    ref double XVAL,
    ref int NDER,
    ref double HBASE,
    [Out] double[] DER,
    [Out] double[] EREST,
    D04AAF_F_DELEGATE F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D04BAF(
    [In] double[] XVAL,
    [In] double[] FVAL,
    [Out] double[] DER,
    [Out] double[] EREST,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D04BBF(
    ref double X_0,
    ref double HBASE,
    [Out] double[] XVAL
   );


// chapter d05

public delegate double D05AAF_K1_DELEGATE(
    ref double X,
    ref double S
  );

public delegate double D05AAF_K2_DELEGATE(
    ref double X,
    ref double S
  );

public delegate double D05AAF_G_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D05AAF(
    ref double LAMBDA,
    ref double A,
    ref double B,
    D05AAF_K1_DELEGATE K1,
    D05AAF_K2_DELEGATE K2,
    D05AAF_G_DELEGATE G,
    [Out] double[] F,
    [Out] double[] C,
    ref int N,
    ref int IND,
    [Out] double[,] W1,
    [Out] double[,] W2,
    [Out] double[] WD,
    ref int LDW1,
    ref int LDW2,
    ref int IFAIL
   );


public delegate double D05ABF_K_DELEGATE(
    ref double X,
    ref double S
  );

public delegate double D05ABF_G_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D05ABF(
    D05ABF_K_DELEGATE K,
    D05ABF_G_DELEGATE G,
    ref double LAMBDA,
    ref double A,
    ref double B,
    ref int ODOREV,
    ref int EV,
    ref int N,
    [Out] double[,] CM,
    [Out] double[,] F1,
    [Out] double[,] WK,
    ref int LDCM,
    ref int NT2P1,
    [Out] double[] F,
    [Out] double[] C,
    ref int IFAIL
   );


public delegate double D05BAF_CK_DELEGATE(
    ref double T
  );

public delegate double D05BAF_CG_DELEGATE(
    ref double S,
    ref double Y
  );

public delegate double D05BAF_CF_DELEGATE(
    ref double T
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D05BAF(
    D05BAF_CK_DELEGATE CK,
    D05BAF_CG_DELEGATE CG,
    D05BAF_CF_DELEGATE CF,
    string METHOD,
    ref int IORDER,
    ref double ALIM,
    ref double TLIM,
    [Out] double[] YN,
    [Out] double[] ERREST,
    ref int NMESH,
    ref double TOL,
    ref double THRESH,
    [Out] double[] WORK,
    ref int LWK,
    ref int IFAIL
,
    long METHODLength
    );


public delegate double D05BDF_CK_DELEGATE(
    ref double T
  );

public delegate double D05BDF_CF_DELEGATE(
    ref double T
  );

public delegate double D05BDF_CG_DELEGATE(
    ref double S,
    ref double Y
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D05BDF(
    D05BDF_CK_DELEGATE CK,
    D05BDF_CF_DELEGATE CF,
    D05BDF_CG_DELEGATE CG,
    string INITWT,
    ref int IORDER,
    ref double TLIM,
    ref double TOLNL,
    ref int NMESH,
    [Out] double[] YN,
    [In,Out] double[] WORK,
    ref int LWK,
    [Out] int[] NCT,
    ref int IFAIL
,
    long INITWTLength
    );


public delegate double D05BEF_CK_DELEGATE(
    ref double T
  );

public delegate double D05BEF_CF_DELEGATE(
    ref double T
  );

public delegate double D05BEF_CG_DELEGATE(
    ref double S,
    ref double Y
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D05BEF(
    D05BEF_CK_DELEGATE CK,
    D05BEF_CF_DELEGATE CF,
    D05BEF_CG_DELEGATE CG,
    string INITWT,
    ref int IORDER,
    ref double TLIM,
    ref double TOLNL,
    ref int NMESH,
    [In,Out] double[] YN,
    [In,Out] double[] WORK,
    ref int LWK,
    [Out] int[] NCT,
    ref int IFAIL
,
    long INITWTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D05BWF(
    string METHOD,
    ref int IORDER,
    [Out] double[] OMEGA,
    ref int NOMG,
    ref int LENSW,
    [Out] double[,] SW,
    ref int LDSW,
    ref int NWT,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D05BYF(
    ref int IORDER,
    ref int IQ,
    ref int LENFW,
    [Out] double[] WT,
    [Out] double[,] SW,
    ref int LDSW,
    [Out] double[] WORK,
    ref int LWK,
    ref int IFAIL
   );


// chapter d06

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06AAF(
    ref int NVB,
    ref int NVMAX,
    ref int NEDGE,
    [In] int[,] EDGE,
    ref int NV,
    ref int NELT,
    [In,Out] double[,] COOR,
    [Out] int[,] CONN,
    [In] double[] BSPACE,
    ref int SMOOTH,
    ref double COEF,
    ref double POWER,
    ref int ITRACE,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06ABF(
    ref int NVB,
    ref int NVINT,
    ref int NVMAX,
    ref int NEDGE,
    [In] int[,] EDGE,
    ref int NV,
    ref int NELT,
    [In,Out] double[,] COOR,
    [Out] int[,] CONN,
    [In] double[] WEIGHT,
    ref int NPROPA,
    ref int ITRACE,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06ACF(
    ref int NVB,
    ref int NVINT,
    ref int NVMAX,
    ref int NEDGE,
    [In] int[,] EDGE,
    ref int NV,
    ref int NELT,
    [In,Out] double[,] COOR,
    [Out] int[,] CONN,
    [In] double[] WEIGHT,
    ref int ITRACE,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
   );


public delegate double D06BAF_FBND_DELEGATE(
    ref int I,
    ref double X,
    ref double Y,
    IntPtr RUSER_rptr,
    IntPtr IUSER_iptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double D06BAD(
    ref int I,
    ref double X,
    ref double Y,
    IntPtr RUSER_rptr,
    IntPtr IUSER_iptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06BAF(
    ref int NLINES, [In] double[,] COORCH, [In] int[,] LINED,
    D06BAF_FBND_DELEGATE FBND, [In] double[,] CRUS, ref int SDCRUS,
    [In] double[] RATE, ref int NCOMP, [In] int[] NLCOMP,
    [In] int[] LCOMP, ref int NVMAX, ref int NEDMX,
    ref int NVB, [Out] double[,] COOR, ref int NEDGE,
    [Out] int[,] EDGE, ref int ITRACE, [In,Out] double[] RUSER,
    [In,Out] int[] IUSER, [Out] double[] RWORK, ref int LRWORK,
    [Out] int[] IWORK, ref int LIWORK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06CAF(
    ref int NV,
    ref int NELT,
    ref int NEDGE,
    [In,Out] double[,] COOR,
    [In] int[,] EDGE,
    [In] int[,] CONN,
    ref int NVFIX,
    [In] int[] NUMFIX,
    ref int ITRACE,
    ref int NQINT,
    [Out] int[] IWORK,
    ref int LIWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06CBF(
    ref int NV,
    ref int NELT,
    ref int NNZMAX,
    [In] int[,] CONN,
    ref int NNZ,
    [Out] int[] IROW,
    [Out] int[] ICOL,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06CCF(
    ref int NV,
    ref int NELT,
    ref int NEDGE,
    ref int NNZMAX,
    ref int NNZ,
    [In,Out] double[,] COOR,
    [In,Out] int[,] EDGE,
    [In,Out] int[,] CONN,
    [Out] int[] IROW,
    [Out] int[] ICOL,
    ref int ITRACE,
    [Out] int[] IWORK,
    ref int LIWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06DAF(
    ref int NV,
    ref int NEDGE,
    ref int NELT,
    ref int NTRANS,
    [In] int[] ITYPE,
    [In] double[,] TRANS,
    [In,Out] double[,] COORI,
    [In,Out] int[,] EDGEI,
    [In,Out] int[,] CONNI,
    [Out] double[,] COORO,
    [Out] int[,] EDGEO,
    [Out] int[,] CONNO,
    ref int ITRACE,
    [Out] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void D06DBF(
    ref double EPS, ref int NV1, ref int NELT1,
    ref int NEDGE1, [In] double[,] COOR1, [In] int[,] EDGE1,
    [In] int[,] CONN1, [In] int[] REFT1, ref int NV2,
    ref int NELT2, ref int NEDGE2, [In] double[,] COOR2,
    [In] int[,] EDGE2, [In] int[,] CONN2, [In] int[] REFT2,
    ref int NV3, ref int NELT3, ref int NEDGE3,
    [Out] double[,] COOR3, [Out] int[,] EDGE3, [Out] int[,] CONN3,
    [Out] int[] REFT3, ref int ITRACE, [Out] int[] IWORK,
    ref int LIWORK, ref int IFAIL
   );


// chapter e01

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01AAF(
    [In,Out] double[] A,
    [In,Out] double[] B,
    [Out] double[] C,
    ref int N1,
    ref int N2,
    ref int N,
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01ABF(
    ref int N,
    ref double P,
    [In,Out] double[] A,
    [Out] double[] G,
    ref int N1,
    ref int N2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01AEF(
    ref int M,
    ref double XMIN,
    ref double XMAX,
    [In] double[] X,
    [In] double[] Y,
    [In] int[] IP,
    ref int N,
    ref int ITMIN,
    ref int ITMAX,
    [Out] double[] A,
    [Out] double[] WRK,
    ref int LWRK,
    [Out] int[] IWRK,
    ref int LIWRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01BAF(
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [Out] double[] LAMDA,
    [Out] double[] C,
    ref int LCK,
    [Out] double[] WRK,
    ref int LWRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01BEF(
    ref int N,
    [In] double[] X,
    [In] double[] F,
    [Out] double[] D,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01BFF(
    ref int N,
    [In] double[] X,
    [In] double[] F,
    [In] double[] D,
    ref int M,
    [In] double[] PX,
    [Out] double[] PF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01BGF(
    ref int N,
    [In] double[] X,
    [In] double[] F,
    [In] double[] D,
    ref int M,
    [In] double[] PX,
    [Out] double[] PF,
    [Out] double[] PD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01BHF(
    ref int N,
    [In] double[] X,
    [In] double[] F,
    [In] double[] D,
    ref double A,
    ref double B,
    ref double PINT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01CEF(
    ref int N,
    ref double LAM,
    ref int NEGFOR,
    ref int YFOR,
    [In] double[] X,
    [In] double[] Y,
    [Out] double[] COMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01CFF(
    ref int M,
    [In] double[] X,
    [Out] double[] VAL,
    [Out] double[] FWD,
    [In,Out] double[] COMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01DAF(
    ref int MX,
    ref int MY,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] F,
    ref int PX,
    ref int PY,
    [Out] double[] LAMDA,
    [Out] double[] MU,
    [Out] double[] C,
    [Out] double[] WRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01EAF(
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    [Out] int[] TRIANG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01EBF(
    ref int M,
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] F,
    [In] int[] TRIANG,
    [In] double[] PX,
    [In] double[] PY,
    [Out] double[] PF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01RAF(
    ref int N,
    [In] double[] X,
    [In] double[] F,
    ref int M,
    [Out] double[] A,
    [Out] double[] U,
    [Out] int[] IW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01RBF(
    ref int M,
    [In] double[] A,
    [In] double[] U,
    ref double X,
    ref double F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01SAF(
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] F,
    [Out] int[] TRIANG,
    [Out] double[,] GRADS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01SBF(
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] F,
    [In] int[] TRIANG,
    [In] double[,] GRADS,
    ref double PX,
    ref double PY,
    ref double PF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01SGF(
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] F,
    ref int NW,
    ref int NQ,
    [Out] int[] IQ,
    ref int LIQ,
    [Out] double[] RQ,
    ref int LRQ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01SHF(
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] F,
    [In] int[] IQ,
    ref int LIQ,
    [In] double[] RQ,
    ref int LRQ,
    ref int N,
    [In] double[] U,
    [In] double[] V,
    [Out] double[] Q,
    [Out] double[] QX,
    [Out] double[] QY,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01TGF(
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] Z,
    [In] double[] F,
    ref int NW,
    ref int NQ,
    [Out] int[] IQ,
    ref int LIQ,
    [Out] double[] RQ,
    ref int LRQ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01THF(
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] Z,
    [In] double[] F,
    [In] int[] IQ,
    ref int LIQ,
    [In] double[] RQ,
    ref int LRQ,
    ref int N,
    [In] double[] U,
    [In] double[] V,
    [In] double[] W,
    [Out] double[] Q,
    [Out] double[] QX,
    [Out] double[] QY,
    [Out] double[] QZ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01TKF(
    ref int M,
    [In] double[,] X,
    [In] double[] F,
    ref int NW,
    ref int NQ,
    [Out] int[] IQ,
    [Out] double[] RQ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01TLF(
    ref int M,
    [In] double[,] X,
    [In] double[] F,
    [In] int[] IQ,
    [In] double[] RQ,
    ref int N,
    [In] double[,] XE,
    [Out] double[] Q,
    [Out] double[,] QX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01TMF(
    ref int M,
    [In] double[,] X,
    [In] double[] F,
    ref int NW,
    ref int NQ,
    [Out] int[] IQ,
    [Out] double[] RQ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01TNF(
    ref int M,
    [In] double[,] X,
    [In] double[] F,
    [In] int[] IQ,
    [In] double[] RQ,
    ref int N,
    [In] double[,] XE,
    [Out] double[] Q,
    [Out] double[,] QX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01ZAF(
    ref int D,
    [In] int[] NARR,
    ref int UNIFORM,
    [In] double[] AXIS,
    ref int LX,
    [In] double[] V,
    [In] double[] POINT,
    ref int METHOD,
    ref int K,
    ref double WF,
    ref double ANS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01ZMF(
    ref int D,
    ref int M,
    [In] double[,] X,
    [In] double[] F,
    ref int NW,
    ref int NQ,
    [Out] int[] IQ,
    [Out] double[] RQ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E01ZNF(
    ref int D,
    ref int M,
    [In] double[,] X,
    [In] double[] F,
    [In] int[] IQ,
    [In] double[] RQ,
    ref int N,
    [In] double[,] XE,
    [Out] double[] Q,
    [Out] double[,] QX,
    ref int IFAIL
   );


// chapter e02

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02ADF(
    ref int M,
    ref int KPLUS1,
    ref int LDA,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] W,
    [Out] double[] WORK1,
    [Out] double[] WORK2,
    [Out] double[,] A,
    [Out] double[] S,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02AEF(
    ref int NPLUS1,
    [In] double[] A,
    ref double XCAP,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02AFF(
    ref int NPLUS1,
    [In] double[] F,
    [Out] double[] A,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02AGF(
    ref int M, ref int KPLUS1, ref int LDA,
    ref double XMIN, ref double XMAX, [In] double[] X,
    [In] double[] Y, [In] double[] W, ref int MF,
    [In] double[] XF, [In] double[] YF, ref int LYF,
    [In] int[] IP, [Out] double[,] A, [Out] double[] S,
    ref int NP1, [Out] double[] WRK, ref int LWRK,
    [Out] int[] IWRK, ref int LIWRK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02AHF(
    ref int NP1,
    ref double XMIN,
    ref double XMAX,
    [In] double[] A,
    ref int IA1,
    ref int LA,
    ref double PATM1,
    [Out] double[] ADIF,
    ref int IADIF1,
    ref int LADIF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02AJF(
    ref int NP1,
    ref double XMIN,
    ref double XMAX,
    [In] double[] A,
    ref int IA1,
    ref int LA,
    ref double QATM1,
    [Out] double[] AINTC,
    ref int IAINT1,
    ref int LAINT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02AKF(
    ref int NP1,
    ref double XMIN,
    ref double XMAX,
    [In] double[] A,
    ref int IA1,
    ref int LA,
    ref double X,
    ref double RESULT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02ALF(
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    ref int M,
    [Out] double[] A,
    ref double REF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02BAF(
    ref int M,
    ref int NCAP7,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] W,
    [In,Out] double[] LAMDA,
    [Out] double[] WORK1,
    [Out] double[] WORK2,
    [Out] double[] C,
    ref double SS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02BBF(
    ref int NCAP7,
    [In] double[] LAMDA,
    [In] double[] C,
    ref double X,
    ref double S,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02BCF(
    ref int NCAP7,
    [In] double[] LAMDA,
    [In] double[] C,
    ref double X,
    ref int LEFT,
    [Out] double[] S,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02BDF(
    ref int NCAP7,
    [In] double[] LAMDA,
    [In] double[] C,
    ref double DINT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02BEF(
    string START,
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] W,
    ref double S,
    ref int NEST,
    ref int N,
    [In,Out] double[] LAMDA,
    [Out] double[] C,
    ref double FP,
    [In,Out] double[] WRK,
    ref int LWRK,
    [In,Out] int[] IWRK,
    ref int IFAIL
,
    long STARTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02BFF(
    ref int START,
    ref int NCAP7,
    [In] double[] LAMDA,
    [In] double[] C,
    ref int DERIV,
    ref int XORD,
    [In] double[] X,
    [In,Out] int[] IXLOC,
    ref int NX,
    [Out] double[,] S,
    ref int LDS,
    [In,Out] int[] IWRK,
    ref int LIWRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02CAF(
    [In] int[] M, ref int N, ref int K,
    ref int L, [In] double[] X, [In] double[] Y,
    [In] double[] F, [In] double[] W, ref int MTOT,
    [Out] double[] A, ref int NA, [In] double[] XMIN,
    [In] double[] XMAX, [In] double[] NUX, ref int INUXP1,
    [In] double[] NUY, ref int INUYP1, [Out] double[] WORK,
    ref int NWORK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02CBF(
    ref int MFIRST,
    ref int MLAST,
    ref int K,
    ref int L,
    [In] double[] X,
    ref double XMIN,
    ref double XMAX,
    ref double Y,
    ref double YMIN,
    ref double YMAX,
    [Out] double[] FF,
    [In] double[] A,
    ref int NA,
    [Out] double[] WORK,
    ref int NWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02DAF(
    ref int M, ref int PX, ref int PY,
    [In] double[] X, [In] double[] Y, [In] double[] F,
    [In] double[] W, [In,Out] double[] LAMDA, [In,Out] double[] MU,
    [In] int[] POINT, ref int NPOINT, [Out] double[] DL,
    [Out] double[] C, ref int NC, [Out] double[] WS,
    ref int NWS, ref double EPS, ref double SIGMA,
    ref int RANK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02DCF(
    string START, ref int MX, [In] double[] X,
    ref int MY, [In] double[] Y, [In] double[] F,
    ref double S, ref int NXEST, ref int NYEST,
    ref int NX, [In,Out] double[] LAMDA, ref int NY,
    [In,Out] double[] MU, [Out] double[] C, ref double FP,
    [In,Out] double[] WRK, ref int LWRK, [In,Out] int[] IWRK,
    ref int LIWRK, ref int IFAIL
,
    long STARTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02DDF(
    string START, ref int M, [In,Out] double[] X,
    [In,Out] double[] Y, [In] double[] F, [In] double[] W,
    ref double S, ref int NXEST, ref int NYEST,
    ref int NX, [In,Out] double[] LAMDA, ref int NY,
    [In,Out] double[] MU, [Out] double[] C, ref double FP,
    ref int RANK, [In,Out] double[] WRK, ref int LWRK,
    [Out] int[] IWRK, ref int LIWRK, ref int IFAIL
,
    long STARTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02DEF(
    ref int M,
    ref int PX,
    ref int PY,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] LAMDA,
    [In] double[] MU,
    [In] double[] C,
    [Out] double[] FF,
    [Out] double[] WRK,
    [Out] int[] IWRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02DFF(
    ref int MX,
    ref int MY,
    ref int PX,
    ref int PY,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] LAMDA,
    [In] double[] MU,
    [In] double[] C,
    [Out] double[] FF,
    [Out] double[] WRK,
    ref int LWRK,
    [Out] int[] IWRK,
    ref int LIWRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02DHF(
    ref int MX,
    ref int MY,
    ref int PX,
    ref int PY,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] LAMDA,
    [In] double[] MU,
    [In] double[] C,
    ref int NUX,
    ref int NUY,
    [Out] double[] Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02GAF(
    ref int M,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[] B,
    ref int NPLUS2,
    ref double TOLER,
    [Out] double[] X,
    ref double RESID,
    ref int IRANK,
    ref int ITER,
    [Out] int[] IWORK,
    ref int IFAIL
   );


public delegate void E02GBF_MONIT_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    ref int NITER,
    ref int K,
    ref double EL1N
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02GBF(
    ref int M,
    ref int N,
    ref int MPL,
    [In,Out] double[,] E,
    ref int LDE,
    [In] double[] F,
    [In,Out] double[] X,
    ref int MXS,
    E02GBF_MONIT_DELEGATE MONIT,
    ref int IPRINT,
    ref int K,
    ref double EL1N,
    [Out] int[] INDX,
    [Out] double[] W,
    ref int IW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02GCF(
    ref int M,
    ref int N,
    ref int SDA,
    ref int LDA,
    [In,Out] double[,] A,
    [In,Out] double[] B,
    ref double TOL,
    ref double RELERR,
    [Out] double[] X,
    ref double RESMAX,
    ref int IRANK,
    ref int ITER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02JDF(
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] F,
    ref int LSMINP,
    ref int LSMAXP,
    ref int NXCELS,
    ref int NYCELS,
    ref int LCOEFS,
    [Out] double[] COEFS,
    [In,Out] int[] IOPTS,
    [In,Out] double[] OPTS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02JEF(
    ref int NEVALV,
    [In] double[] XEVALV,
    [In] double[] YEVALV,
    [In] double[] COEFS,
    [Out] double[] FEVALV,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02JFF(
    ref int NXEVAL,
    ref int NYEVAL,
    [In] double[] XEVALM,
    [In] double[] YEVALM,
    [In] double[] COEFS,
    [Out] double[,] FEVALM,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02RAF(
    ref int IA,
    ref int IB,
    [In] double[] C,
    ref int IC,
    [Out] double[] A,
    [Out] double[] B,
    [Out] double[] W,
    ref int JW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02RBF(
    [In] double[] A,
    ref int IA,
    [In] double[] B,
    ref int IB,
    ref double X,
    ref double ANS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02ZAF(
    ref int PX,
    ref int PY,
    [In] double[] LAMDA,
    [In] double[] MU,
    ref int M,
    [In] double[] X,
    [In] double[] Y,
    [Out] int[] POINT,
    ref int NPOINT,
    [Out] int[] ADRES,
    ref int NADRES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02ZKF(
    string OPTSTR,
    [In,Out] int[] IOPTS,
    ref int LIOPTS,
    [In,Out] double[] OPTS,
    ref int LOPTS,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E02ZLF(
    string OPTSTR,
    ref int IVALUE,
    ref double RVALUE,
    StringBuilder CVALUE,
    ref int OPTYPE,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


// chapter e04

public delegate void E04ABA_FUNCT_DELEGATE(
    ref double XC,
    ref double FC,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04ABA(
    E04ABA_FUNCT_DELEGATE FUNCT,
    ref double E1,
    ref double E2,
    ref double A,
    ref double B,
    ref int MAXCAL,
    ref double X,
    ref double F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );

public delegate void E04ABF_FUNCT_DELEGATE(
    ref double XC,
    ref double FC
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04ABF(
    E04ABF_FUNCT_DELEGATE FUNCT,
    ref double E1,
    ref double E2,
    ref double A,
    ref double B,
    ref int MAXCAL,
    ref double X,
    ref double F,
    ref int IFAIL
   );


public delegate void E04BBA_FUNCT_DELEGATE(
    ref double XC,
    ref double FC,
    ref double GC,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04BBA(
    E04BBA_FUNCT_DELEGATE FUNCT,
    ref double E1,
    ref double E2,
    ref double A,
    ref double B,
    ref int MAXCAL,
    ref double X,
    ref double F,
    ref double G,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );

public delegate void E04BBF_FUNCT_DELEGATE(
    ref double XC,
    ref double FC,
    ref double GC
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04BBF(
    E04BBF_FUNCT_DELEGATE FUNCT,
    ref double E1,
    ref double E2,
    ref double A,
    ref double B,
    ref int MAXCAL,
    ref double X,
    ref double F,
    ref double G,
    ref int IFAIL
   );


public delegate void E04CBF_FUNCT_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04CBF_MONIT_DELEGATE(
    ref double FMIN,
    ref double FMAX,
    IntPtr SIM_rptr,
    ref int N,
    ref int NCALL,
    ref double SERROR,
    ref double VRATIO,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04CBK(
    ref double FMIN,
    ref double FMAX,
    IntPtr SIM_rptr,
    ref int N,
    ref int NCALL,
    ref double SERROR,
    ref double VRATIO,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04CBF(
    ref int N,
    [In,Out] double[] X,
    ref double F,
    ref double TOLF,
    ref double TOLX,
    E04CBF_FUNCT_DELEGATE FUNCT,
    E04CBF_MONIT_DELEGATE MONIT,
    ref int MAXCAL,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );




public delegate void E04DGA_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04DGA(
    ref int N,
    E04DGA_OBJFUN_DELEGATE OBJFUN,
    ref int ITER,
    ref double OBJF,
    [Out] double[] OBJGRD,
    [In,Out] double[] X,
    [Out] int[] IWORK,
    [Out] double[] WORK,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int IFAIL
   );

public delegate void E04DGF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04DGF(
    ref int N,
    E04DGF_OBJFUN_DELEGATE OBJFUN,
    ref int ITER,
    ref double OBJF,
    [Out] double[] OBJGRD,
    [In,Out] double[] X,
    [Out] int[] IWORK,
    [Out] double[] WORK,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04DJA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04DJF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04DKA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04DKF(
    string STR
,
    long STRLength 
    );


public delegate void E04FCF_LSQFUN_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04FCF_LSQMON_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr S_rptr,
    ref int IGRADE,
    ref int NITER,
    ref int NF,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04FDZ(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr S_rptr,
    ref int IGRADE,
    ref int NITER,
    ref int NF,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04FCF(
    ref int M, ref int N, E04FCF_LSQFUN_DELEGATE LSQFUN,
    E04FCF_LSQMON_DELEGATE LSQMON, ref int IPRINT, ref int MAXCAL,
    ref double ETA, ref double XTOL, ref double STEPMX,
    [In,Out] double[] X, ref double FSUMSQ, [Out] double[] FVEC,
    [Out] double[,] FJAC, ref int LDFJAC, [Out] double[] S,
    [Out] double[,] V, ref int LDV, ref int NITER,
    ref int NF, [In,Out] int[] IW, ref int LIW,
    [In,Out] double[] W, ref int LW, ref int IFAIL
   );




public delegate void E04FFF_OBJFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NRES,
    IntPtr RX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04FFF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04FFU(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04FFF(
    ref IntPtr HANDLE,
    E04FFF_OBJFUN_DELEGATE OBJFUN,
    E04FFF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NRES,
    [Out] double[] RX,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04FGF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref int NEVAL,
    ref int MAXEVAL,
    ref int NVAR,
    [In,Out] double[,] X,
    ref int NRES,
    [In,Out] double[,] RX,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    ref int IFAIL
   );


public delegate void E04FYF_LSFUN1_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04FYF(
    ref int M,
    ref int N,
    E04FYF_LSFUN1_DELEGATE LSFUN1,
    [In,Out] double[] X,
    ref double FSUMSQ,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04GBF_LSQLIN_DELEGATE(
    ref int SELCT
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04FCV(
    ref int SELCT
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04HEV(
    ref int SELCT
  );

public delegate void E04GBF_LSQFUN_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04GBF_LSQMON_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr S_rptr,
    ref int IGRADE,
    ref int NITER,
    ref int NF,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GBF(
    ref int M, ref int N, E04GBF_LSQLIN_DELEGATE LSQLIN,
    E04GBF_LSQFUN_DELEGATE LSQFUN, E04GBF_LSQMON_DELEGATE LSQMON, ref int IPRINT,
    ref int MAXCAL, ref double ETA, ref double XTOL,
    ref double STEPMX, [In,Out] double[] X, ref double FSUMSQ,
    [Out] double[] FVEC, [Out] double[,] FJAC, ref int LDFJAC,
    [Out] double[] S, [Out] double[,] V, ref int LDV,
    ref int NITER, ref int NF, [In,Out] int[] IW,
    ref int LIW, [In,Out] double[] W, ref int LW,
    ref int IFAIL
   );


public delegate void E04GDF_LSQFUN_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04GDF_LSQMON_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr S_rptr,
    ref int IGRADE,
    ref int NITER,
    ref int NF,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GDF(
    ref int M, ref int N, E04GDF_LSQFUN_DELEGATE LSQFUN,
    E04GDF_LSQMON_DELEGATE LSQMON, ref int IPRINT, ref int MAXCAL,
    ref double ETA, ref double XTOL, ref double STEPMX,
    [In,Out] double[] X, ref double FSUMSQ, [Out] double[] FVEC,
    [Out] double[,] FJAC, ref int LDFJAC, [Out] double[] S,
    [Out] double[,] V, ref int LDV, ref int NITER,
    ref int NF, [In,Out] int[] IW, ref int LIW,
    [In,Out] double[] W, ref int LW, ref int IFAIL
   );


public delegate void E04GGF_LSQFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NRES,
    IntPtr RX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GGF_LSQGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NRES,
    ref int NNZRD,
    IntPtr RDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GGF_LSQHES_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NRES,
    IntPtr LAMBDA_rptr,
    IntPtr HX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GGU(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NRES,
    IntPtr LAMBDA_rptr,
    IntPtr HX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GGF_LSQHPRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    ref int NRES,
    IntPtr HXY_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GGV(
    ref int NVAR,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    ref int NRES,
    IntPtr HXY_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GGF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GGF(
    ref IntPtr HANDLE,
    E04GGF_LSQFUN_DELEGATE LSQFUN,
    E04GGF_LSQGRD_DELEGATE LSQGRD,
    E04GGF_LSQHES_DELEGATE LSQHES,
    E04GGF_LSQHPRD_DELEGATE LSQHPRD,
    E04GGF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NRES,
    [Out] double[] RX,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


public delegate void E04GNF_LSQFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NRES,
    IntPtr RX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GNF_LSQGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NRES,
    ref int NNZRD,
    IntPtr RDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GNF_CONFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    IntPtr GX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04STX(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    IntPtr GX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GNF_CONGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZGD,
    IntPtr GDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04STY(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZGD,
    IntPtr GDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04GNF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GNF(
    ref IntPtr HANDLE,
    E04GNF_LSQFUN_DELEGATE LSQFUN,
    E04GNF_LSQGRD_DELEGATE LSQGRD,
    E04GNF_CONFUN_DELEGATE CONFUN,
    E04GNF_CONGRD_DELEGATE CONGRD,
    E04GNF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NRES,
    [Out] double[] RX,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


public delegate void E04GYF_LSFUN2_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GYF(
    ref int M,
    ref int N,
    E04GYF_LSFUN2_DELEGATE LSFUN2,
    [In,Out] double[] X,
    ref double FSUMSQ,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04GZF_LSFUN2_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04GZF(
    ref int M,
    ref int N,
    E04GZF_LSFUN2_DELEGATE LSFUN2,
    [In,Out] double[] X,
    ref double FSUMSQ,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04HCF_FUNCT_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04HCF(
    ref int N,
    E04HCF_FUNCT_DELEGATE FUNCT,
    [In] double[] X,
    ref double F,
    [Out] double[] G,
    [In,Out] int[] IW,
    ref int LIW,
    [In,Out] double[] W,
    ref int LW,
    ref int IFAIL
   );


public delegate void E04HDF_FUNCT_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04HDF_H_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FHESL_rptr,
    ref int LH,
    IntPtr FHESD_rptr,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04HDF(
    ref int N,
    E04HDF_FUNCT_DELEGATE FUNCT,
    E04HDF_H_DELEGATE H,
    [In] double[] X,
    [Out] double[] G,
    [Out] double[] HESL,
    ref int LH,
    [Out] double[] HESD,
    [In,Out] int[] IW,
    ref int LIW,
    [In,Out] double[] W,
    ref int LW,
    ref int IFAIL
   );


public delegate void E04HEF_LSQFUN_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04HEF_LSQHES_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr FVEC_rptr,
    IntPtr XC_rptr,
    IntPtr B_rptr,
    ref int LB,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04HEF_LSQMON_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr S_rptr,
    ref int IGRADE,
    ref int NITER,
    ref int NF,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04HEF(
    ref int M, ref int N, E04HEF_LSQFUN_DELEGATE LSQFUN,
    E04HEF_LSQHES_DELEGATE LSQHES, E04HEF_LSQMON_DELEGATE LSQMON, ref int IPRINT,
    ref int MAXCAL, ref double ETA, ref double XTOL,
    ref double STEPMX, [In,Out] double[] X, ref double FSUMSQ,
    [Out] double[] FVEC, [Out] double[,] FJAC, ref int LDFJAC,
    [Out] double[] S, [Out] double[,] V, ref int LDV,
    ref int NITER, ref int NF, [In,Out] int[] IW,
    ref int LIW, [In,Out] double[] W, ref int LW,
    ref int IFAIL
   );


public delegate void E04HYF_LSFUN2_DELEGATE(
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04HYF_LSHES2_DELEGATE(
    ref int M,
    ref int N,
    IntPtr FVEC_rptr,
    IntPtr XC_rptr,
    IntPtr B_rptr,
    ref int LB,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04HYF(
    ref int M,
    ref int N,
    E04HYF_LSFUN2_DELEGATE LSFUN2,
    E04HYF_LSHES2_DELEGATE LSHES2,
    [In,Out] double[] X,
    ref double FSUMSQ,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04JCF_OBJFUN_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    ref double F,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

public delegate void E04JCF_MONFUN_DELEGATE(
    ref int N,
    ref int NF,
    IntPtr X_rptr,
    ref double F,
    ref double RHO,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04JCP(
    ref int N,
    ref int NF,
    IntPtr X_rptr,
    ref double F,
    ref double RHO,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04JCF(
    E04JCF_OBJFUN_DELEGATE OBJFUN,
    ref int N,
    ref int NPT,
    [In,Out] double[] X,
    [In] double[] BL,
    [In] double[] BU,
    ref double RHOBEG,
    ref double RHOEND,
    E04JCF_MONFUN_DELEGATE MONFUN,
    ref int MAXCAL,
    ref double F,
    ref int NF,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04JDF_OBJFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04JDV(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04JDF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04JDU(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04JDF(
    ref IntPtr HANDLE,
    E04JDF_OBJFUN_DELEGATE OBJFUN,
    E04JDF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04JEF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref int NEVAL,
    ref int MAXEVAL,
    ref int NVAR,
    [In,Out] double[,] X,
    [In,Out] double[] F,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    ref int IFAIL
   );


public delegate void E04JYF_FUNCT1_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04JYF(
    ref int N,
    ref int IBOUND,
    E04JYF_FUNCT1_DELEGATE FUNCT1,
    [In,Out] double[] BL,
    [In,Out] double[] BU,
    [In,Out] double[] X,
    ref double F,
    [Out] int[] IW,
    ref int LIW,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04KDF_FUNCT_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04KDF_MONIT_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr ISTATE_iptr,
    ref double GPJNRM,
    ref double COND,
    ref int POSDEF,
    ref int NITER,
    ref int NF,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04KDF(
    ref int N, E04KDF_FUNCT_DELEGATE FUNCT, E04KDF_MONIT_DELEGATE MONIT,
    ref int IPRINT, ref int MAXCAL, ref double ETA,
    ref double XTOL, ref double DELTA, ref double STEPMX,
    ref int IBOUND, [In,Out] double[] BL, [In,Out] double[] BU,
    [In,Out] double[] X, [Out] double[] HESL, ref int LH,
    [Out] double[] HESD, [Out] int[] ISTATE, ref double F,
    [Out] double[] G, [In,Out] int[] IW, ref int LIW,
    [In,Out] double[] W, ref int LW, ref int IFAIL
   );


public delegate void E04KFF_OBJFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04KFV(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04KFF_OBJGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04KFW(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04KFF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04KFU(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04KFF(
    ref IntPtr HANDLE,
    E04KFF_OBJFUN_DELEGATE OBJFUN,
    E04KFF_OBJGRD_DELEGATE OBJGRD,
    E04KFF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




public delegate void E04KYF_FUNCT2_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04KYF(
    ref int N,
    ref int IBOUND,
    E04KYF_FUNCT2_DELEGATE FUNCT2,
    [In,Out] double[] BL,
    [In,Out] double[] BU,
    [In,Out] double[] X,
    ref double F,
    [Out] double[] G,
    [Out] int[] IW,
    ref int LIW,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04KZF_FUNCT2_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04KZF(
    ref int N,
    ref int IBOUND,
    E04KZF_FUNCT2_DELEGATE FUNCT2,
    [In,Out] double[] BL,
    [In,Out] double[] BU,
    [In,Out] double[] X,
    ref double F,
    [Out] double[] G,
    [Out] int[] IW,
    ref int LIW,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


public delegate void E04LBF_FUNCT_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04LBF_H_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FHESL_rptr,
    ref int LH,
    IntPtr FHESD_rptr,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04LBF_MONIT_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr ISTATE_iptr,
    ref double GPJNRM,
    ref double COND,
    ref int POSDEF,
    ref int NITER,
    ref int NF,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04LBF(
    ref int N, E04LBF_FUNCT_DELEGATE FUNCT, E04LBF_H_DELEGATE H,
    E04LBF_MONIT_DELEGATE MONIT, ref int IPRINT, ref int MAXCAL,
    ref double ETA, ref double XTOL, ref double STEPMX,
    ref int IBOUND, [In,Out] double[] BL, [In,Out] double[] BU,
    [In,Out] double[] X, [Out] double[] HESL, ref int LH,
    [Out] double[] HESD, [Out] int[] ISTATE, ref double F,
    [Out] double[] G, [In,Out] int[] IW, ref int LIW,
    [In,Out] double[] W, ref int LW, ref int IFAIL
   );


public delegate void E04LYF_FUNCT2_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    ref double FC,
    IntPtr GC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04LYF_HESS2_DELEGATE(
    ref int N,
    IntPtr XC_rptr,
    IntPtr HESLC_rptr,
    ref int LH,
    IntPtr HESDC_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04LYF(
    ref int N,
    ref int IBOUND,
    E04LYF_FUNCT2_DELEGATE FUNCT2,
    E04LYF_HESS2_DELEGATE HESS2,
    [In,Out] double[] BL,
    [In,Out] double[] BU,
    [In,Out] double[] X,
    ref double F,
    [Out] double[] G,
    [Out] int[] IW,
    ref int LIW,
    [Out] double[] W,
    ref int LW,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MFA(
    ref int N, ref int NCLIN, [In] double[,] A,
    ref int LDA, [In] double[] BL, [In] double[] BU,
    [In] double[] CVEC, [In,Out] int[] ISTATE, [In,Out] double[] X,
    ref int ITER, ref double OBJ, [Out] double[] AX,
    [Out] double[] CLAMDA, [Out] int[] IWORK, ref int LIWORK,
    [Out] double[] WORK, ref int LWORK, [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV, [In,Out] double[] RWSAV, ref int IFAIL
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MFF(
    ref int N,
    ref int NCLIN,
    [In] double[,] A,
    ref int LDA,
    [In] double[] BL,
    [In] double[] BU,
    [In] double[] CVEC,
    [In,Out] int[] ISTATE,
    [In,Out] double[] X,
    ref int ITER,
    ref double OBJ,
    [Out] double[] AX,
    [Out] double[] CLAMDA,
    [Out] int[] IWORK,
    ref int LIWORK,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MGA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MGF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MHA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MHF(
    string STR
,
    long STRLength 
    );


public delegate void E04MKF_MONIT_DELEGATE(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MKU(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MKF(
    ref IntPtr HANDLE,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NNZU,
    [In,Out] double[] U,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    E04MKF_MONIT_DELEGATE MONIT,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




public delegate void E04MTF_MONIT_DELEGATE(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MTU(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MTF(
    ref IntPtr HANDLE,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NNZU,
    [In,Out] double[] U,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    E04MTF_MONIT_DELEGATE MONIT,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MWF(
    ref int OUTFILE, ref int N, ref int M,
    ref int NNZC, ref int NNZA, ref int NCOLH,
    ref int NNZH, ref int LINTVAR, [In] int[] IDXC,
    [In] double[] C, ref int IOBJ, [In] double[] A,
    [In] int[] IROWA, [In] int[] ICCOLA, [In] double[] BL,
    [In] double[] BU, [In,Out] byte[,] PNAMES, ref int NNAME,
    [In,Out] byte[,] CRNAME, [In] double[] H, [In] int[] IROWH,
    [In] int[] ICCOLH, ref int MINMAX, [In] int[] INTVAR,
    ref int IFAIL
,
    long PNAMESLength,
    long CRNAMELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MXF(
    ref int INFILE, ref int MAXN, ref int MAXM,
    ref int MAXNNZ, ref int MAXNCOLH, ref int MAXNNZH,
    ref int MAXLINTVAR, ref int MPSLST, ref int N,
    ref int M, ref int NNZ, ref int NCOLH,
    ref int NNZH, ref int LINTVAR, ref int IOBJ,
    [Out] double[] A, [Out] int[] IROWA, [Out] int[] ICCOLA,
    [Out] double[] BL, [Out] double[] BU, [In,Out] byte[,] PNAMES,
    ref int NNAME, [In,Out] byte[,] CRNAME, [Out] double[] H,
    [Out] int[] IROWH, [Out] int[] ICCOLH, ref int MINMAX,
    [Out] int[] INTVAR, ref int IFAIL
,
    long PNAMESLength,
    long CRNAMELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04MZF(
    ref int INFILE, ref int MAXN, ref int MAXM,
    ref int MAXNNZ, ref double XBLDEF, ref double XBUDEF,
    ref int MPSLST, ref int N, ref int M,
    ref int NNZ, ref int IOBJ, ref int NCOLH,
    [Out] double[] A, [Out] int[] HA, [Out] int[] KA,
    [Out] double[] BL, [Out] double[] BU, StringBuilder START,
    [In,Out] byte[,] NAMES, ref int NNAME, [In,Out] byte[,] CRNAME,
    [Out] double[] XS, [Out] int[] ISTATE, ref int IFAIL
,
    long STARTLength,
    long NAMESLength,
    long CRNAMELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NCA(
    ref int M, ref int N, ref int NCLIN,
    ref int LDC, ref int LDA, [In] double[,] C,
    [In] double[] BL, [In] double[] BU, [In] double[] CVEC,
    [In,Out] int[] ISTATE, [In,Out] int[] KX, [In,Out] double[] X,
    [In,Out] double[,] A, [In,Out] double[] B, ref int ITER,
    ref double OBJ, [Out] double[] CLAMDA, [Out] int[] IWORK,
    ref int LIWORK, [Out] double[] WORK, ref int LWORK,
    [In,Out] int[] LWSAV, [In,Out] int[] IWSAV, [In,Out] double[] RWSAV,
    ref int IFAIL
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NCF(
    ref int M, ref int N, ref int NCLIN,
    ref int LDC, ref int LDA, [In] double[,] C,
    [In] double[] BL, [In] double[] BU, [In] double[] CVEC,
    [In,Out] int[] ISTATE, [In,Out] int[] KX, [In,Out] double[] X,
    [In,Out] double[,] A, [In,Out] double[] B, ref int ITER,
    ref double OBJ, [Out] double[] CLAMDA, [Out] int[] IWORK,
    ref int LIWORK, [Out] double[] WORK, ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NDA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NDF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NEA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NEF(
    string STR
,
    long STRLength 
    );


public delegate void E04NFA_QPHESS_DELEGATE(
    ref int N,
    ref int JTHCOL,
    IntPtr H_rptr,
    ref int LDH,
    IntPtr X_rptr,
    IntPtr HX_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    IntPtr IWSAV_iptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E54NFU(
    ref int N,
    ref int JTHCOL,
    IntPtr H_rptr,
    ref int LDH,
    IntPtr X_rptr,
    IntPtr HX_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    IntPtr IWSAV_iptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NFA(
    ref int N, ref int NCLIN, [In] double[,] A,
    ref int LDA, [In] double[] BL, [In] double[] BU,
    [In] double[] CVEC, [In] double[,] H, ref int LDH,
    E04NFA_QPHESS_DELEGATE QPHESS, [In,Out] int[] ISTATE, [In,Out] double[] X,
    ref int ITER, ref double OBJ, [Out] double[] AX,
    [Out] double[] CLAMDA, [Out] int[] IWORK, ref int LIWORK,
    [Out] double[] WORK, ref int LWORK, [In,Out] int[] IUSER,
    [In,Out] double[] RUSER, [In,Out] int[] LWSAV, [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV, ref int IFAIL
   );

public delegate void E04NFF_QPHESS_DELEGATE(
    ref int N,
    ref int JTHCOL,
    IntPtr H_rptr,
    ref int LDH,
    IntPtr X_rptr,
    IntPtr HX_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NFU(
    ref int N,
    ref int JTHCOL,
    IntPtr H_rptr,
    ref int LDH,
    IntPtr X_rptr,
    IntPtr HX_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NFF(
    ref int N, ref int NCLIN, [In] double[,] A,
    ref int LDA, [In] double[] BL, [In] double[] BU,
    [In] double[] CVEC, [In] double[,] H, ref int LDH,
    E04NFF_QPHESS_DELEGATE QPHESS, [In,Out] int[] ISTATE, [In,Out] double[] X,
    ref int ITER, ref double OBJ, [Out] double[] AX,
    [Out] double[] CLAMDA, [Out] int[] IWORK, ref int LIWORK,
    [Out] double[] WORK, ref int LWORK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NGA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NGF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NHA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NHF(
    string STR
,
    long STRLength 
    );


public delegate void E04NKA_QPHX_DELEGATE(
    ref int NSTATE,
    ref int NCOLH,
    IntPtr X_rptr,
    IntPtr HX_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E54NKU(
    ref int NSTATE,
    ref int NCOLH,
    IntPtr X_rptr,
    IntPtr HX_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NKA(
    ref int N, ref int M, ref int NNZ,
    ref int IOBJ, ref int NCOLH, E04NKA_QPHX_DELEGATE QPHX,
    [In,Out] double[] A, [In] int[] HA, [In] int[] KA,
    [In,Out] double[] BL, [In,Out] double[] BU, string START,
    [In,Out] byte[,] NAMES, ref int NNAME, [In,Out] byte[,] CRNAME,
    ref int NS, [In,Out] double[] XS, [In,Out] int[] ISTATE,
    ref int MINIZ, ref int MINZ, ref int NINF,
    ref double SINF, ref double OBJ, [Out] double[] CLAMDA,
    [Out] int[] IZ, ref int LENIZ, [Out] double[] Z,
    ref int LENZ, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    [In,Out] int[] LWSAV, [In,Out] int[] IWSAV, [In,Out] double[] RWSAV,
    ref int IFAIL
,
    long STARTLength,
    long NAMESLength,
    long CRNAMELength
    );

public delegate void E04NKF_QPHX_DELEGATE(
    ref int NSTATE,
    ref int NCOLH,
    IntPtr X_rptr,
    IntPtr HX_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NKU(
    ref int NSTATE,
    ref int NCOLH,
    IntPtr X_rptr,
    IntPtr HX_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NKF(
    ref int N, ref int M, ref int NNZ,
    ref int IOBJ, ref int NCOLH, E04NKF_QPHX_DELEGATE QPHX,
    [In,Out] double[] A, [In] int[] HA, [In] int[] KA,
    [In,Out] double[] BL, [In,Out] double[] BU, string START,
    [In,Out] byte[,] NAMES, ref int NNAME, [In,Out] byte[,] CRNAME,
    ref int NS, [In,Out] double[] XS, [In,Out] int[] ISTATE,
    ref int MINIZ, ref int MINZ, ref int NINF,
    ref double SINF, ref double OBJ, [Out] double[] CLAMDA,
    [Out] int[] IZ, ref int LENIZ, [Out] double[] Z,
    ref int LENZ, ref int IFAIL
,
    long STARTLength,
    long NAMESLength,
    long CRNAMELength
    );





   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NLA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NLF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NMA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NMF(
    string STR
,
    long STRLength 
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NPF(
    [In,Out] byte[,] CW,
    ref int LENCW,
    [Out] int[] IW,
    ref int LENIW,
    [Out] double[] RW,
    ref int LENRW,
    ref int IFAIL
,
    long CWLength
    );


public delegate void E04NQF_QPHX_DELEGATE(
    ref int NCOLH,
    IntPtr X_rptr,
    IntPtr HX_rptr,
    ref int NSTATE,
    IntPtr CUSER_chptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
,
    long CUSER_chptrLength
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NSH(
    ref int NCOLH,
    IntPtr X_rptr,
    IntPtr HX_rptr,
    ref int NSTATE,
    IntPtr CUSER_chptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
,
    long CUSER_chptrLength
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NQF(
    string START, E04NQF_QPHX_DELEGATE QPHX, ref int M,
    ref int N, ref int NE, ref int NNAME,
    ref int LENC, ref int NCOLH, ref int IOBJ,
    ref double OBJADD, string PROB, [In,Out] double[] ACOL,
    [In] int[] INDA, [In] int[] LOCA, [In,Out] double[] BL,
    [In,Out] double[] BU, [In,Out] double[] C, [In,Out] byte[,] NAMES,
    [In] int[] HELAST, [In,Out] int[] HS, [In,Out] double[] X,
    [Out] double[] PI, [Out] double[] RC, ref int NS,
    ref int NINF, ref double SINF, ref double OBJ,
    [In,Out] byte[,] CW, ref int LENCW, [In,Out] int[] IW,
    ref int LENIW, [In,Out] double[] RW, ref int LENRW,
    [In,Out] byte[,] CUSER, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    ref int IFAIL
,
    long STARTLength,
    long PROBLength,
    long NAMESLength,
    long CWLength,
    long CUSERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NRF(
    ref int ISPECS,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NSF(
    string ST,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NTF(
    string ST,
    ref int IVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NUF(
    string ST,
    ref double RVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NXF(
    string ST,
    ref int IVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04NYF(
    string ST,
    ref double RVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04PCF(
    ref int ITYPE,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[] B,
    [In] double[] BL,
    [In] double[] BU,
    ref double TOL,
    [Out] double[] X,
    ref double RNORM,
    ref int NFREE,
    [Out] double[] W,
    [Out] int[] INDX,
    ref int IFAIL
   );


public delegate void E04PTF_MONIT_DELEGATE(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04PTU(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04PTF(
    ref IntPtr HANDLE,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NNZU,
    [In,Out] double[] U,
    ref int NNZUC,
    [In,Out] double[] UC,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    E04PTF_MONIT_DELEGATE MONIT,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RAF(
    ref IntPtr HANDLE,
    ref int NVAR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RBF(
    ref IntPtr HANDLE,
    string GTYPE,
    ref int LGROUP,
    [In] int[] GROUP,
    ref int IDGROUP,
    ref int IFAIL
,
    long GTYPELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RCF(
    ref IntPtr HANDLE,
    string PTYPE,
    ref int LIDX,
    [In] int[] IDX,
    ref int IFAIL
,
    long PTYPELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RDF(
    ref int INFILE,
    ref int MAXNVAR,
    ref int MAXNBLK,
    ref int MAXNNZ,
    ref int FILELST,
    ref int NVAR,
    ref int NBLK,
    ref int NNZ,
    [Out] double[] CVEC,
    [Out] int[] NNZA,
    [Out] int[] IROWA,
    [Out] int[] ICOLA,
    [Out] double[] A,
    [Out] int[] BLKSIZEA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04REF(
    ref IntPtr HANDLE,
    ref int NVAR,
    [In] double[] CVEC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RFF(
    ref IntPtr HANDLE,
    ref int NNZC,
    [In] int[] IDXC,
    [In] double[] C,
    ref int NNZH,
    [In] int[] IROWH,
    [In] int[] ICOLH,
    [In] double[] H,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RGF(
    ref IntPtr HANDLE,
    ref int NNZFD,
    [In] int[] IDXFD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RHF(
    ref IntPtr HANDLE,
    ref int NVAR,
    [In] double[] BL,
    [In] double[] BU,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RJF(
    ref IntPtr HANDLE,
    ref int NCLIN,
    [In] double[] BL,
    [In] double[] BU,
    ref int NNZB,
    [In] int[] IROWB,
    [In] int[] ICOLB,
    [In] double[] B,
    ref int IDLC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RKF(
    ref IntPtr HANDLE,
    ref int NCNLN,
    [In] double[] BL,
    [In] double[] BU,
    ref int NNZGD,
    [In] int[] IROWGD,
    [In] int[] ICOLGD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RLF(
    ref IntPtr HANDLE,
    ref int IDF,
    ref int NNZH,
    [In] int[] IROWH,
    [In] int[] ICOLH,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RMF(
    ref IntPtr HANDLE,
    ref int NRES,
    ref int ISPARSE,
    ref int NNZRD,
    [In] int[] IROWRD,
    [In] int[] ICOLRD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RNF(
    ref IntPtr HANDLE,
    ref int NVAR,
    ref int DIMA,
    [In] int[] NNZA,
    ref int NNZASUM,
    [In] int[] IROWA,
    [In] int[] ICOLA,
    [In] double[] A,
    ref int NBLK,
    [In] int[] BLKSIZEA,
    ref int IDBLK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RPF(
    ref IntPtr HANDLE,
    ref int NQ,
    [In] int[] QI,
    [In] int[] QJ,
    ref int DIMQ,
    [In] int[] NNZQ,
    ref int NNZQSUM,
    [In] int[] IROWQ,
    [In] int[] ICOLQ,
    [In] double[] Q,
    ref int IDBLK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RSF(
    ref IntPtr HANDLE,
    ref double S,
    ref int NNZR,
    [In] int[] IDXR,
    [In] double[] R,
    ref int NNZQ,
    [In] int[] IROWQ,
    [In] int[] ICOLQ,
    [In] double[] Q,
    ref int IDQC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RTF(
    ref IntPtr HANDLE,
    ref double S,
    ref int NNZR,
    [In] int[] IDXR,
    [In] double[] R,
    ref int MF,
    ref int NNZF,
    [In] int[] IROWF,
    [In] int[] ICOLF,
    [In] double[] F,
    ref int IDQC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RWF(
    ref IntPtr HANDLE,
    string CMDSTR,
    ref int IOFLAG,
    ref int LIARR,
    [In,Out] int[] IARR,
    ref int IFAIL
,
    long CMDSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RXF(
    ref IntPtr HANDLE,
    string CMDSTR,
    ref int IOFLAG,
    ref int LRARR,
    [In,Out] double[] RARR,
    ref int IFAIL
,
    long CMDSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RYF(
    ref IntPtr HANDLE,
    ref int NOUT,
    string CMDSTR,
    ref int IFAIL
,
    long CMDSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04RZF(
    ref IntPtr HANDLE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SAF(
    ref IntPtr HANDLE,
    string FILE,
    string FTYPE,
    [Out] int[] PINFO,
    ref int IFAIL
,
    long FILELength,
    long FTYPELength
    );


public delegate void E04SRF_OBJFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SRV(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04SRF_OBJGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SRW(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04SRF_CONFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    IntPtr GX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SRX(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    IntPtr GX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04SRF_CONGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZGD,
    IntPtr GDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SRY(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZGD,
    IntPtr GDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04SRF_HESS_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    ref int IDF,
    ref double SIGMA,
    IntPtr LAMBDA_rptr,
    ref int NNZH,
    IntPtr HX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SRZ(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    ref int IDF,
    ref double SIGMA,
    IntPtr LAMBDA_rptr,
    ref int NNZH,
    IntPtr HX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04SRF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZU,
    IntPtr U_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SRU(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZU,
    IntPtr U_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SRF(
    ref IntPtr HANDLE,
    E04SRF_OBJFUN_DELEGATE OBJFUN,
    E04SRF_OBJGRD_DELEGATE OBJGRD,
    E04SRF_CONFUN_DELEGATE CONFUN,
    E04SRF_CONGRD_DELEGATE CONGRD,
    E04SRF_HESS_DELEGATE HESS,
    E04SRF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NNZU,
    [In,Out] double[] U,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


public delegate void E04STF_OBJFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04STV(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04STF_OBJGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04STW(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04STF_CONFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    IntPtr GX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );


public delegate void E04STF_CONGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZGD,
    IntPtr GDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );


public delegate void E04STF_HESS_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    ref int IDF,
    ref double SIGMA,
    IntPtr LAMBDA_rptr,
    ref int NNZH,
    IntPtr HX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04STZ(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    ref int IDF,
    ref double SIGMA,
    IntPtr LAMBDA_rptr,
    ref int NNZH,
    IntPtr HX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void E04STF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZU,
    IntPtr U_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04STU(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZU,
    IntPtr U_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04STF(
    ref IntPtr HANDLE,
    E04STF_OBJFUN_DELEGATE OBJFUN,
    E04STF_OBJGRD_DELEGATE OBJGRD,
    E04STF_CONFUN_DELEGATE CONFUN,
    E04STF_CONGRD_DELEGATE CONGRD,
    E04STF_HESS_DELEGATE HESS,
    E04STF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NNZU,
    [In,Out] double[] U,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04SVF(
    ref IntPtr HANDLE,
    ref int NVAR,
    [In,Out] double[] X,
    ref int NNZU,
    [In,Out] double[] U,
    ref int NNZUC,
    [In,Out] double[] UC,
    ref int NNZUA,
    [In,Out] double[] UA,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    ref int INFORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04TAF(
    ref IntPtr HANDLE,
    ref int NADD,
    ref int NVAR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04TBF(
    ref IntPtr HANDLE,
    string COMP,
    ref int LIDX,
    [In] int[] IDX,
    ref int IFAIL
,
    long COMPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04TCF(
    ref IntPtr HANDLE,
    string COMP,
    ref int LIDX,
    [In] int[] IDX,
    ref int IFAIL
,
    long COMPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04TDF(
    ref IntPtr HANDLE,
    string COMP,
    ref int IDX,
    ref double BLI,
    ref double BUI,
    ref int IFAIL
,
    long COMPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04TEF(
    ref IntPtr HANDLE,
    ref int IDXCI,
    ref double CI,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04TJF(
    ref IntPtr HANDLE,
    ref int IDLC,
    ref int ICOLBJ,
    ref double BIJ,
    ref int IFAIL
   );


public delegate void E04UCA_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E54UDM(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04UCA_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UCA(
    ref int N, ref int NCLIN, ref int NCNLN,
    ref int LDA, ref int LDCJ, ref int LDR,
    [In] double[,] A, [In] double[] BL, [In] double[] BU,
    E04UCA_CONFUN_DELEGATE CONFUN, E04UCA_OBJFUN_DELEGATE OBJFUN, ref int ITER,
    [In,Out] int[] ISTATE, [Out] double[] C, [In,Out] double[,] CJAC,
    [In,Out] double[] CLAMDA, ref double OBJF, [Out] double[] OBJGRD,
    [In,Out] double[,] R, [In,Out] double[] X, [Out] int[] IWORK,
    ref int LIWORK, [Out] double[] WORK, ref int LWORK,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV, [In,Out] double[] RWSAV, ref int IFAIL
   );

public delegate void E04UCF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UDM(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04UCF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UCF(
    ref int N, ref int NCLIN, ref int NCNLN,
    ref int LDA, ref int LDCJ, ref int LDR,
    [In] double[,] A, [In] double[] BL, [In] double[] BU,
    E04UCF_CONFUN_DELEGATE CONFUN, E04UCF_OBJFUN_DELEGATE OBJFUN, ref int ITER,
    [In,Out] int[] ISTATE, [Out] double[] C, [In,Out] double[,] CJAC,
    [In,Out] double[] CLAMDA, ref double OBJF, [Out] double[] OBJGRD,
    [In,Out] double[,] R, [In,Out] double[] X, [Out] int[] IWORK,
    ref int LIWORK, [Out] double[] WORK, ref int LWORK,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UDA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UDF(
    ref int IOPTNS,
    ref int INFORM
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UEA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UEF(
    string STR
,
    long STRLength 
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UFA(
    ref int IREVCM, ref int N, ref int NCLIN,
    ref int NCNLN, ref int LDA, ref int LDCJ,
    ref int LDR, [In] double[,] A, [In] double[] BL,
    [In] double[] BU, ref int ITER, [In,Out] int[] ISTATE,
    [In,Out] double[] C, [In,Out] double[,] CJAC, [In,Out] double[] CLAMDA,
    ref double OBJF, [In,Out] double[] OBJGRD, [In,Out] double[,] R,
    [In,Out] double[] X, [Out] int[] NEEDC, [In,Out] int[] IWORK,
    ref int LIWORK, [In,Out] double[] WORK, ref int LWORK,
    [In,Out] byte[,] CWSAV, [In,Out] int[] LWSAV, [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV, ref int IFAIL
,
    long CWSAVLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UFF(
    ref int IREVCM, ref int N, ref int NCLIN,
    ref int NCNLN, ref int LDA, ref int LDCJ,
    ref int LDR, [In] double[,] A, [In] double[] BL,
    [In] double[] BU, ref int ITER, [In,Out] int[] ISTATE,
    [In,Out] double[] C, [In,Out] double[,] CJAC, [In,Out] double[] CLAMDA,
    ref double OBJF, [In,Out] double[] OBJGRD, [In,Out] double[,] R,
    [In,Out] double[] X, [Out] int[] NEEDC, [In,Out] int[] IWORK,
    ref int LIWORK, [In,Out] double[] WORK, ref int LWORK,
    ref int IFAIL
   );


public delegate void E04UGA_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int NJNLN,
    ref int NNZJAC,
    IntPtr X_rptr,
    IntPtr F_rptr,
    IntPtr FJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E54UGM(
    ref int MODE,
    ref int NCNLN,
    ref int NJNLN,
    ref int NNZJAC,
    IntPtr X_rptr,
    IntPtr F_rptr,
    IntPtr FJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04UGA_OBJFUN_DELEGATE(
    ref int MODE,
    ref int NONLN,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E54UGN(
    ref int MODE,
    ref int NONLN,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UGA(
    E04UGA_CONFUN_DELEGATE CONFUN, E04UGA_OBJFUN_DELEGATE OBJFUN, ref int N,
    ref int M, ref int NCNLN, ref int NONLN,
    ref int NJNLN, ref int IOBJ, ref int NNZ,
    [In,Out] double[] A, [In] int[] HA, [In] int[] KA,
    [In,Out] double[] BL, [In,Out] double[] BU, string START,
    ref int NNAME, [In,Out] byte[,] NAMES, ref int NS,
    [In,Out] double[] XS, [In,Out] int[] ISTATE, [In,Out] double[] CLAMDA,
    ref int MINIZ, ref int MINZ, ref int NINF,
    ref double SINF, ref double OBJ, [Out] int[] IZ,
    ref int LENIZ, [Out] double[] Z, ref int LENZ,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV, [In,Out] double[] RWSAV, ref int IFAIL
,
    long STARTLength,
    long NAMESLength
    );

public delegate void E04UGF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int NJNLN,
    ref int NNZJAC,
    IntPtr X_rptr,
    IntPtr F_rptr,
    IntPtr FJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UGM(
    ref int MODE,
    ref int NCNLN,
    ref int NJNLN,
    ref int NNZJAC,
    IntPtr X_rptr,
    IntPtr F_rptr,
    IntPtr FJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04UGF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int NONLN,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UGN(
    ref int MODE,
    ref int NONLN,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UGF(
    E04UGF_CONFUN_DELEGATE CONFUN, E04UGF_OBJFUN_DELEGATE OBJFUN, ref int N,
    ref int M, ref int NCNLN, ref int NONLN,
    ref int NJNLN, ref int IOBJ, ref int NNZ,
    [In,Out] double[] A, [In] int[] HA, [In] int[] KA,
    [In,Out] double[] BL, [In,Out] double[] BU, string START,
    ref int NNAME, [In,Out] byte[,] NAMES, ref int NS,
    [In,Out] double[] XS, [In,Out] int[] ISTATE, [In,Out] double[] CLAMDA,
    ref int MINIZ, ref int MINZ, ref int NINF,
    ref double SINF, ref double OBJ, [Out] int[] IZ,
    ref int LENIZ, [Out] double[] Z, ref int LENZ,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, ref int IFAIL
,
    long STARTLength,
    long NAMESLength
    );






   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UHA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UHF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UJA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UJF(
    string STR
,
    long STRLength 
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UQA(
    ref int IOPTNS,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04UQF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04URA(
    string STR,
    [In,Out] int[] LWSAV,
    [In,Out] int[] IWSAV,
    [In,Out] double[] RWSAV,
    ref int INFORM
,
    long STRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04URF(
    string STR
,
    long STRLength 
    );


public delegate void E04USA_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


public delegate void E04USA_OBJFUN_DELEGATE(
    ref int MODE,
    ref int M,
    ref int N,
    ref int LDFJ,
    ref int NEEDFI,
    IntPtr X_rptr,
    IntPtr F_rptr,
    IntPtr FJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04USA(
    ref int M, ref int N, ref int NCLIN,
    ref int NCNLN, ref int LDA, ref int LDCJ,
    ref int LDFJ, ref int LDR, [In] double[,] A,
    [In] double[] BL, [In] double[] BU, [In] double[] Y,
    E04USA_CONFUN_DELEGATE CONFUN, E04USA_OBJFUN_DELEGATE OBJFUN, ref int ITER,
    [In,Out] int[] ISTATE, [Out] double[] C, [In,Out] double[,] CJAC,
    [Out] double[] F, [In,Out] double[,] FJAC, [In,Out] double[] CLAMDA,
    ref double OBJF, [In,Out] double[,] R, [In,Out] double[] X,
    [Out] int[] IWORK, ref int LIWORK, [Out] double[] WORK,
    ref int LWORK, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    [In,Out] int[] LWSAV, [In,Out] int[] IWSAV, [In,Out] double[] RWSAV,
    ref int IFAIL
   );

public delegate void E04USF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


public delegate void E04USF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int M,
    ref int N,
    ref int LDFJ,
    ref int NEEDFI,
    IntPtr X_rptr,
    IntPtr F_rptr,
    IntPtr FJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04USF(
    ref int M, ref int N, ref int NCLIN,
    ref int NCNLN, ref int LDA, ref int LDCJ,
    ref int LDFJ, ref int LDR, [In] double[,] A,
    [In] double[] BL, [In] double[] BU, [In] double[] Y,
    E04USF_CONFUN_DELEGATE CONFUN, E04USF_OBJFUN_DELEGATE OBJFUN, ref int ITER,
    [In,Out] int[] ISTATE, [Out] double[] C, [In,Out] double[,] CJAC,
    [Out] double[] F, [In,Out] double[,] FJAC, [In,Out] double[] CLAMDA,
    ref double OBJF, [In,Out] double[,] R, [In,Out] double[] X,
    [Out] int[] IWORK, ref int LIWORK, [Out] double[] WORK,
    ref int LWORK, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VGF(
    [In,Out] byte[,] CW,
    ref int LENCW,
    [Out] int[] IW,
    ref int LENIW,
    [Out] double[] RW,
    ref int LENRW,
    ref int IFAIL
,
    long CWLength
    );


public delegate void E04VHF_USRFUN_DELEGATE(
    ref int STATUS,
    ref int N,
    IntPtr X_rptr,
    ref int NEEDF,
    ref int NF,
    IntPtr F_rptr,
    ref int NEEDG,
    ref int LENG,
    IntPtr G_rptr,
    IntPtr CUSER_chptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
,
    long CUSER_chptrLength
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VHF(
    ref int START, ref int NF, ref int N,
    ref int NXNAME, ref int NFNAME, ref double OBJADD,
    ref int OBJROW, string PROB, E04VHF_USRFUN_DELEGATE USRFUN,
    [In] int[] IAFUN, [In] int[] JAVAR, [In] double[] A,
    ref int LENA, ref int NEA, [In] int[] IGFUN,
    [In] int[] JGVAR, ref int LENG, ref int NEG,
    [In] double[] XLOW, [In] double[] XUPP, [In,Out] byte[,] XNAMES,
    [In] double[] FLOW, [In] double[] FUPP, [In,Out] byte[,] FNAMES,
    [In,Out] double[] X, [In,Out] int[] XSTATE, [Out] double[] XMUL,
    [In,Out] double[] F, [In,Out] int[] FSTATE, [In,Out] double[] FMUL,
    ref int NS, ref int NINF, ref double SINF,
    [In,Out] byte[,] CW, ref int LENCW, [In,Out] int[] IW,
    ref int LENIW, [In,Out] double[] RW, ref int LENRW,
    [In,Out] byte[,] CUSER, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    ref int IFAIL
,
    long PROBLength,
    long XNAMESLength,
    long FNAMESLength,
    long CWLength,
    long CUSERLength
    );


public delegate void E04VJF_USRFUN_DELEGATE(
    ref int STATUS,
    ref int N,
    IntPtr X_rptr,
    ref int NEEDF,
    ref int NF,
    IntPtr F_rptr,
    ref int NEEDG,
    ref int LENG,
    IntPtr G_rptr,
    IntPtr CUSER_chptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
,
    long CUSER_chptrLength
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VJF(
    ref int NF, ref int N, E04VJF_USRFUN_DELEGATE USRFUN,
    [Out] int[] IAFUN, [Out] int[] JAVAR, [Out] double[] A,
    ref int LENA, ref int NEA, [Out] int[] IGFUN,
    [Out] int[] JGVAR, ref int LENG, ref int NEG,
    [In] double[] X, [In] double[] XLOW, [In] double[] XUPP,
    [In,Out] byte[,] CW, ref int LENCW, [In,Out] int[] IW,
    ref int LENIW, [In,Out] double[] RW, ref int LENRW,
    [In,Out] byte[,] CUSER, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    ref int IFAIL
,
    long CWLength,
    long CUSERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VKF(
    ref int ISPECS,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VLF(
    string ST,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VMF(
    string ST,
    ref int IVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VNF(
    string ST,
    ref double RVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VRF(
    string ST,
    ref int IVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04VSF(
    string ST,
    ref double RVALUE,
    [In,Out] byte[,] CW,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength,
    long CWLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WBF(
    string RNAME,
    [In,Out] byte[,] CWSAV,
    ref int LCWSAV,
    [Out] int[] LWSAV,
    ref int LLWSAV,
    [Out] int[] IWSAV,
    ref int LIWSAV,
    [Out] double[] RWSAV,
    ref int LRWSAV,
    ref int IFAIL
,
    long RNAMELength,
    long CWSAVLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WCF(
    [Out] int[] IW,
    ref int LENIW,
    [Out] double[] RW,
    ref int LENRW,
    ref int IFAIL
   );


public delegate void E04WDF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr CCON_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WDP(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr CCON_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E04WDF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr GRAD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WDF(
    ref int N, ref int NCLIN, ref int NCNLN,
    ref int LDA, ref int LDCJ, ref int LDH,
    [In] double[,] A, [In] double[] BL, [In] double[] BU,
    E04WDF_CONFUN_DELEGATE CONFUN, E04WDF_OBJFUN_DELEGATE OBJFUN, ref int MAJITS,
    [In,Out] int[] ISTATE, [In,Out] double[] CCON, [In,Out] double[,] CJAC,
    [In,Out] double[] CLAMDA, ref double OBJF, [Out] double[] GRAD,
    [In,Out] double[,] H, [In,Out] double[] X, [In,Out] int[] IW,
    ref int LENIW, [In,Out] double[] RW, ref int LENRW,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WEF(
    ref int ISPECS,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WFF(
    string ST,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WGF(
    string ST,
    ref int IVALUE,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WHF(
    string ST,
    ref double RVALUE,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WKF(
    string ST,
    ref int IVALUE,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04WLF(
    string ST,
    ref double RVALUE,
    [In,Out] int[] IW,
    [In,Out] double[] RW,
    ref int IFAIL
,
    long STLength
    );


public delegate void E04XAA_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04XAA(
    ref int MSGLVL, ref int N, ref double EPSRF,
    [In,Out] double[] X, ref int MODE, E04XAA_OBJFUN_DELEGATE OBJFUN,
    ref int LDH, [In,Out] double[] HFORW, ref double OBJF,
    [Out] double[] OBJGRD, [Out] double[] HCNTRL, [Out] double[,] H,
    ref int IWARN, [Out] double[] WORK, [In,Out] int[] IUSER,
    [In,Out] double[] RUSER, [Out] int[] INFO, [In] int[] LWSAV,
    [In] int[] IWSAV, [In] double[] RWSAV, ref int IFAIL
   );

public delegate void E04XAF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04XAF(
    ref int MSGLVL,
    ref int N,
    ref double EPSRF,
    [In,Out] double[] X,
    ref int MODE,
    E04XAF_OBJFUN_DELEGATE OBJFUN,
    ref int LDH,
    [In,Out] double[] HFORW,
    ref double OBJF,
    [Out] double[] OBJGRD,
    [Out] double[] HCNTRL,
    [Out] double[,] H,
    ref int IWARN,
    [Out] double[] WORK,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    [Out] int[] INFO,
    ref int IFAIL
   );


public delegate void E04YAF_LSQFUN_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04YAF(
    ref int M,
    ref int N,
    E04YAF_LSQFUN_DELEGATE LSQFUN,
    [In] double[] X,
    [Out] double[] FVEC,
    [Out] double[,] FJAC,
    ref int LDFJAC,
    [In,Out] int[] IW,
    ref int LIW,
    [In,Out] double[] W,
    ref int LW,
    ref int IFAIL
   );


public delegate void E04YBF_LSQFUN_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr XC_rptr,
    IntPtr FVEC_rptr,
    IntPtr FJAC_rptr,
    ref int LDFJAC,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

public delegate void E04YBF_LSQHES_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr FVEC_rptr,
    IntPtr XC_rptr,
    IntPtr B_rptr,
    ref int LB,
    IntPtr IW_iptr,
    ref int LIW,
    IntPtr W_rptr,
    ref int LW
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04YBF(
    ref int M,
    ref int N,
    E04YBF_LSQFUN_DELEGATE LSQFUN,
    E04YBF_LSQHES_DELEGATE LSQHES,
    [In] double[] X,
    [Out] double[] FVEC,
    [Out] double[,] FJAC,
    ref int LDFJAC,
    [Out] double[] B,
    ref int LB,
    [In,Out] int[] IW,
    ref int LIW,
    [In,Out] double[] W,
    ref int LW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04YCF(
    ref int JOB,
    ref int M,
    ref int N,
    ref double FSUMSQ,
    [In] double[] S,
    [In,Out] double[,] V,
    ref int LDV,
    [Out] double[] CJ,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04ZMF(
    ref IntPtr HANDLE,
    string OPTSTR,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04ZNF(
    ref IntPtr HANDLE,
    string OPTSTR,
    ref int IVALUE,
    ref double RVALUE,
    StringBuilder CVALUE,
    ref int OPTYPE,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E04ZPF(
    ref IntPtr HANDLE,
    ref int INFILE,
    ref int IFAIL
   );


// chapter e05

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JAF(
    ref int N_R,
    [Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


public delegate void E05JBF_OBJFUN_DELEGATE(
    ref int N,
    IntPtr X_rptr,
    ref double F,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

public delegate void E05JBF_MONIT_DELEGATE(
    ref int N,
    ref int NCALL,
    IntPtr XBEST_rptr,
    IntPtr ICOUNT_iptr,
    ref int NINIT,
    IntPtr LIST_rptr,
    IntPtr NUMPTS_iptr,
    IntPtr INITPT_iptr,
    ref int NBASKT,
    IntPtr XBASKT_rptr,
    IntPtr BOXL_rptr,
    IntPtr BOXU_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JBK(
    ref int N,
    ref int NCALL,
    IntPtr XBEST_rptr,
    IntPtr ICOUNT_iptr,
    ref int NINIT,
    IntPtr LIST_rptr,
    IntPtr NUMPTS_iptr,
    IntPtr INITPT_iptr,
    ref int NBASKT,
    IntPtr XBASKT_rptr,
    IntPtr BOXL_rptr,
    IntPtr BOXU_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JBF(
    ref int N,
    E05JBF_OBJFUN_DELEGATE OBJFUN,
    ref int IBOUND,
    ref int IINIT,
    [In,Out] double[] BL,
    [In,Out] double[] BU,
    ref int SDLIST,
    [In,Out] double[,] LIST,
    [In,Out] int[] NUMPTS,
    [In,Out] int[] INITPT,
    E05JBF_MONIT_DELEGATE MONIT,
    [Out] double[] X,
    ref double OBJ,
    [In,Out] double[] COMM,
    ref int LCOMM,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JCF(
    ref int IOPTS,
    [In,Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JDF(
    string OPTSTR,
    [In,Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JEF(
    string OPTSTR,
    string CVALUE,
    [In,Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JFF(
    string OPTSTR,
    ref int IVALUE,
    [In,Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JGF(
    string OPTSTR,
    ref double RVALUE,
    [In,Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int E05JHF(
    string OPTSTR,
    [In] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JJF(
    string OPTSTR,
    StringBuilder CVALUE,
    [In] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JKF(
    string OPTSTR,
    ref int IVALUE,
    [In] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05JLF(
    string OPTSTR,
    ref double RVALUE,
    [In] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
,
    long OPTSTRLength
    );


public delegate void E05KBF_OBJFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );


public delegate void E05KBF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05KBF(
    ref IntPtr HANDLE,
    E05KBF_OBJFUN_DELEGATE OBJFUN,
    E05KBF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [Out] double[] X,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );


public delegate void E05SAF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int NDIM,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr VECOUT_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E05SAF_MONMOD_DELEGATE(
    ref int NDIM,
    ref int NPAR,
    IntPtr X_rptr,
    IntPtr XB_rptr,
    ref double FB,
    IntPtr XBEST_rptr,
    IntPtr FBEST_rptr,
    IntPtr ITT_iptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05SXM(
    ref int NDIM,
    ref int NPAR,
    IntPtr X_rptr,
    IntPtr XB_rptr,
    ref double FB,
    IntPtr XBEST_rptr,
    IntPtr FBEST_rptr,
    IntPtr ITT_iptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05SAF(
    ref int NDIM,
    ref int NPAR,
    [Out] double[] XB,
    ref double FB,
    [In] double[] BL,
    [In] double[] BU,
    E05SAF_OBJFUN_DELEGATE OBJFUN,
    E05SAF_MONMOD_DELEGATE MONMOD,
    [In,Out] int[] IOPTS,
    [In,Out] double[] OPTS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    [Out] int[] ITT,
    ref int INFORM,
    ref int IFAIL
   );


public delegate void E05SBF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int NDIM,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr VECOUT_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E05SBF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCON,
    ref int NDIM,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05SZM(
    ref int MODE,
    ref int NCON,
    ref int NDIM,
    ref int LDCJ,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E05SBF_MONMOD_DELEGATE(
    ref int NDIM,
    ref int NCON,
    ref int NPAR,
    IntPtr X_rptr,
    IntPtr XB_rptr,
    ref double FB,
    IntPtr CB_rptr,
    IntPtr XBEST_rptr,
    IntPtr FBEST_rptr,
    IntPtr CBEST_rptr,
    IntPtr ITT_iptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05SYM(
    ref int NDIM,
    ref int NCON,
    ref int NPAR,
    IntPtr X_rptr,
    IntPtr XB_rptr,
    ref double FB,
    IntPtr CB_rptr,
    IntPtr XBEST_rptr,
    IntPtr FBEST_rptr,
    IntPtr CBEST_rptr,
    IntPtr ITT_iptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05SBF(
    ref int NDIM, ref int NCON, ref int NPAR,
    [Out] double[] XB, ref double FB, [Out] double[] CB,
    [In] double[] BL, [In] double[] BU, [In,Out] double[,] XBEST,
    [In,Out] double[] FBEST, [In,Out] double[,] CBEST, E05SBF_OBJFUN_DELEGATE OBJFUN,
    E05SBF_CONFUN_DELEGATE CONFUN, E05SBF_MONMOD_DELEGATE MONMOD, [In,Out] int[] IOPTS,
    [In,Out] double[] OPTS, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    [Out] int[] ITT, ref int INFORM, ref int IFAIL
   );






public delegate void E05UCF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJSL,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJSL_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


public delegate void E05UCF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr X_rptr,
    ref double OBJF,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E05UCF_START_DELEGATE(
    ref int NPTS,
    IntPtr QUAS_rptr,
    ref int N,
    ref int REPEAT,
    IntPtr BL_rptr,
    IntPtr BU_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int MODE
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05UCZ(
    ref int NPTS,
    IntPtr QUAS_rptr,
    ref int N,
    ref int REPEAT,
    IntPtr BL_rptr,
    IntPtr BU_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int MODE
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05UCF(
    ref int N, ref int NCLIN, ref int NCNLN,
    [In] double[,] A, ref int LDA, [In] double[] BL,
    [In] double[] BU, E05UCF_CONFUN_DELEGATE CONFUN, E05UCF_OBJFUN_DELEGATE OBJFUN,
    ref int NPTS, [Out] double[,] X, ref int LDX,
    E05UCF_START_DELEGATE START, ref int REPEAT, ref int NB,
    [Out] double[] OBJF, [Out] double[,] OBJGRD, ref int LDOBJD,
    [Out] int[] ITER, [Out] double[,] C, ref int LDC,
    [Out] double[,,] CJAC, ref int LDCJAC, ref int SDCJAC,
    [Out] double[,,] R, ref int LDR, ref int SDR,
    [Out] double[,] CLAMDA, ref int LDCLDA, [Out] int[,] ISTATE,
    ref int LISTAT, [In,Out] int[] IOPTS, [In,Out] double[] OPTS,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, [Out] int[] INFO,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05UDM(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJSL,
    [In] int[] NEEDC,
    [In] double[] X,
    [Out] double[] C,
    [In,Out] double[,] CJSL,
    ref int NSTATE,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER
   );


public delegate void E05USF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    ref int LDCJSL,
    IntPtr NEEDC_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJSL_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


public delegate void E05USF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int M,
    ref int N,
    ref int LDFJSL,
    ref int NEEDFI,
    IntPtr X_rptr,
    IntPtr F_rptr,
    IntPtr FJSL_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void E05USF_START_DELEGATE(
    ref int NPTS,
    IntPtr QUAS_rptr,
    ref int N,
    ref int REPEAT1,
    IntPtr BL_rptr,
    IntPtr BU_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int MODE
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05USF(
    ref int M, ref int N, ref int NCLIN,
    ref int NCNLN, [In] double[,] A, ref int LDA,
    [In] double[] BL, [In] double[] BU, [In] double[] Y,
    E05USF_CONFUN_DELEGATE CONFUN, E05USF_OBJFUN_DELEGATE OBJFUN, ref int NPTS,
    [Out] double[,] X, ref int LDX, E05USF_START_DELEGATE START,
    ref int REPEAT1, ref int NB, [Out] double[] OBJF,
    [Out] double[,] F, [Out] double[,,] FJAC, ref int LDFJAC,
    ref int SDFJAC, [Out] int[] ITER, [Out] double[,] C,
    ref int LDC, [Out] double[,,] CJAC, ref int LDCJAC,
    ref int SDCJAC, [Out] double[,] CLAMDA, ref int LDCLDA,
    [Out] int[,] ISTATE, ref int LISTAT, [In,Out] int[] IOPTS,
    [In,Out] double[] OPTS, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    [Out] int[] INFO, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05ZKF(
    string OPTSTR,
    [In,Out] int[] IOPTS,
    ref int LIOPTS,
    [In,Out] double[] OPTS,
    ref int LOPTS,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void E05ZLF(
    string OPTSTR,
    ref int IVALUE,
    ref double RVALUE,
    StringBuilder CVALUE,
    ref int OPTYPE,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


// chapter f01

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ABF(
    [In,Out] double[,] A,
    ref int LDA,
    ref int N,
    [Out] double[,] B,
    ref int LDB,
    [Out] double[] Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ADF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01BLF(
    ref int M,
    ref int N,
    ref double T,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] AIJMAX,
    ref int IRANK,
    [Out] int[] INC,
    [Out] double[] D,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[] DU,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01BRF(
    ref int N,
    ref int NZ,
    [In,Out] double[] A,
    ref int LICN,
    [In,Out] int[] IRN,
    ref int LIRN,
    [In,Out] int[] ICN,
    ref double PIVOT,
    [Out] int[] IKEEP,
    [Out] int[] IW,
    [Out] double[] W,
    ref int LBLOCK,
    ref int GROW,
    [In] int[] ABORT,
    [Out] int[] IDISP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01BSF(
    ref int N,
    ref int NZ,
    [In,Out] double[] A,
    ref int LICN,
    [In] int[] IVECT,
    [In] int[] JVECT,
    [In,Out] int[] ICN,
    [In] int[] IKEEP,
    [Out] int[] IW,
    [Out] double[] W,
    ref int GROW,
    ref double ETA,
    ref double RPMIN,
    ref int ABORT,
    [In] int[] IDISP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01BUF(
    ref int N,
    ref int M1,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] W,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01BVF(
    ref int N,
    ref int MA1,
    ref int MB1,
    ref int M3,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[,] V,
    ref int LDV,
    [Out] double[] W,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01CKF(
    [Out] double[,] A,
    [In,Out] double[,] B,
    [In,Out] double[,] C,
    ref int N,
    ref int P,
    ref int M,
    [Out] double[] Z,
    ref int IZ,
    ref int OPT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01CRF(
    [In,Out] double[] A,
    ref int M,
    ref int N,
    ref int MN,
    [Out] int[] MOVE,
    ref int LMOVE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01CTF(
    string TRANSA,
    string TRANSB,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    ref double BETA,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] C,
    ref int LDC,
    ref int IFAIL
,
    long TRANSALength,
    long TRANSBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01CWF(
    string TRANSA,
    string TRANSB,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    ref Complex BETA,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] C,
    ref int LDC,
    ref int IFAIL
,
    long TRANSALength,
    long TRANSBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01DFF(
    string UPLO,
    string TRANSA,
    string TRANSB,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC,
    ref int IFAIL
,
    long UPLOLength,
    long TRANSALength,
    long TRANSBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01DGF(
    string SIDE,
    string UPLO,
    string TRANSA,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int IFAIL
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01DTF(
    string UPLO,
    string TRANSA,
    string TRANSB,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC,
    ref int IFAIL
,
    long UPLOLength,
    long TRANSALength,
    long TRANSBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01DUF(
    string SIDE,
    string UPLO,
    string TRANSA,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int IFAIL
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ECF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01EDF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int IFAIL
,
    long UPLOLength
    );


public delegate void F01EFF_F_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr X_rptr,
    IntPtr FX_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01EFF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    F01EFF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01EJF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double IMNORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01EKF(
    string FUN,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double IMNORM,
    ref int IFAIL
,
    long FUNLength
    );


public delegate void F01ELF_F_DELEGATE(
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ELF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    F01ELF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref double IMNORM,
    ref int IFAIL
   );


public delegate void F01EMF_F_DELEGATE(
    ref int M,
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01EMF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    F01EMF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref double IMNORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ENF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01EPF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01EQF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FCF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FDF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int IFAIL
,
    long UPLOLength
    );


public delegate void F01FFF_F_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr X_rptr,
    IntPtr FX_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FFF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    F01FFF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FJF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FKF(
    string FUN,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int IFAIL
,
    long FUNLength
    );


public delegate void F01FLF_F_DELEGATE(
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FLF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    F01FLF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref int IFAIL
   );


public delegate void F01FMF_F_DELEGATE(
    ref int M,
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FMF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    F01FMF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FNF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FPF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01FQF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01GAF(
    ref int N,
    ref int M,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref double T,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01GBF(
    ref int IREVCM,
    ref int N,
    ref int M,
    [In,Out] double[,] B,
    ref int LDB,
    ref double T,
    ref double TR,
    [In,Out] double[,] B2,
    ref int LDB2,
    [In,Out] double[,] X,
    ref int LDX,
    [In,Out] double[,] Y,
    ref int LDY,
    [In,Out] double[] P,
    [In,Out] double[] R,
    [In,Out] double[] Z,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01HAF(
    ref int N,
    ref int M,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref Complex T,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01HBF(
    ref int IREVCM, ref int N, ref int M,
    [In,Out] Complex[,] B, ref int LDB, ref Complex T,
    ref Complex TR, [In,Out] Complex[,] B2, ref int LDB2,
    [In,Out] Complex[,] X, ref int LDX, [In,Out] Complex[,] Y,
    ref int LDY, [In,Out] Complex[] P, [In,Out] Complex[] R,
    [In,Out] Complex[] Z, [In,Out] Complex[] CCOMM, [In,Out] double[] COMM,
    [In,Out] int[] ICOMM, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JAF(
    string FUN,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double CONDA,
    ref double NORMA,
    ref double NORMFA,
    ref int IFAIL
,
    long FUNLength
    );


public delegate void F01JBF_F_DELEGATE(
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JBF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    F01JBF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref double CONDA,
    ref double NORMA,
    ref double NORMFA,
    ref int IFAIL
   );


public delegate void F01JCF_F_DELEGATE(
    ref int M,
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JCF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    F01JCF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref double CONDA,
    ref double NORMA,
    ref double NORMFA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JDF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double ALPHA,
    ref double CONDSA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JEF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double P,
    ref double CONDPA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JFF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] E,
    ref int LDE,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JGF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double CONDEA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JHF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] E,
    ref int LDE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JJF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double CONDLA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01JKF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] E,
    ref int LDE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KAF(
    string FUN,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref double CONDA,
    ref double NORMA,
    ref double NORMFA,
    ref int IFAIL
,
    long FUNLength
    );


public delegate void F01KBF_F_DELEGATE(
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KBF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    F01KBF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref double CONDA,
    ref double NORMA,
    ref double NORMFA,
    ref int IFAIL
   );


public delegate void F01KCF_F_DELEGATE(
    ref int M,
    ref int IFLAG,
    ref int NZ,
    IntPtr Z_cptr,
    IntPtr FZ_cptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KCF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    F01KCF_F_DELEGATE F,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFLAG,
    ref double CONDA,
    ref double NORMA,
    ref double NORMFA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KDF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref double ALPHA,
    ref double CONDSA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KEF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref double P,
    ref double CONDPA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KFF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] E,
    ref int LDE,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KGF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref double CONDEA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KHF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] E,
    ref int LDE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KJF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref double CONDLA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01KKF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] E,
    ref int LDE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01LEF(
    ref int N,
    [In,Out] double[] A,
    ref double LAMBDA,
    [In,Out] double[] B,
    [In,Out] double[] C,
    ref double TOL,
    [Out] double[] D,
    [Out] int[] IPIV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01LHF(
    ref int N,
    ref int NBLOKS,
    [In] int[,] BLKSTR,
    [In,Out] double[] A,
    ref int LENA,
    [Out] int[] PIVOT,
    ref double TOL,
    ref int KPIVOT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01MCF(
    ref int N,
    [In] double[] A,
    ref int LAL,
    [In,Out] int[] NROW,
    [Out] double[] AL,
    [Out] double[] D,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01MDF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] OFFDIAG,
    [Out] int[] IPIV,
    ref double DELTA,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01MEF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] OFFDIAG,
    [In] int[] IPIV,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01QGF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] ZETA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01QJF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] ZETA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01QKF(
    string WHERET,
    ref int M,
    ref int N,
    ref int NROWP,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] ZETA,
    [Out] double[] WORK,
    ref int IFAIL
,
    long WHERETLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01RGF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] THETA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01RJF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] THETA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01RKF(
    string WHERET,
    ref int M,
    ref int N,
    ref int NROWP,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] THETA,
    [Out] Complex[] WORK,
    ref int IFAIL
,
    long WHERETLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01SAF(
    ref int M,
    ref int N,
    ref int K,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] W,
    ref int LDW,
    [In,Out] double[,] H,
    ref int LDH,
    ref int SEED,
    ref double ERRTOL,
    ref int MAXIT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01SBF(
    ref int IREVCM,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] W,
    ref int LDW,
    [In,Out] double[,] H,
    ref int LDH,
    [In,Out] double[,] HT,
    ref int LDHT,
    ref int SEED,
    ref double ERRTOL,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRTTP(
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] AP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VAF(
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] AP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRTTP(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VBF(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPTTR(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VCF(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPTTR(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VDF(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRTTF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VEF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRTTF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VFF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTFTTR(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] AR,
    [Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VGF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] AR,
    [Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTFTTR(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] AR,
    [Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VHF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] AR,
    [Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPTTF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] AP,
    [Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VJF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] AP,
    [Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPTTF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VKF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTFTTP(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] AR,
    [Out] double[] AP,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VLF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] AR,
    [Out] double[] AP,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTFTTP(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] AR,
    [Out] Complex[] AP,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01VMF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] AR,
    [Out] Complex[] AP,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ZAF(
    string JOB,
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[] B,
    ref int IFAIL
,
    long JOBLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ZBF(
    string JOB,
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] B,
    ref int IFAIL
,
    long JOBLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ZCF(
    string JOB,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int IFAIL
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F01ZDF(
    string JOB,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int IFAIL
,
    long JOBLength
    );


// chapter f02

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02ECF(
    string CRIT,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref double WL,
    ref double WU,
    ref int MEST,
    ref int M,
    [Out] double[] WR,
    [Out] double[] WI,
    [Out] double[,] VR,
    ref int LDVR,
    [Out] double[,] VI,
    ref int LDVI,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    [Out] int[] BWORK,
    ref int IFAIL
,
    long CRITLength
    );


public delegate void F02EKF_MONIT_DELEGATE(
    ref int NCV,
    ref int NITER,
    ref int NCONV,
    IntPtr W_cptr,
    IntPtr RZEST_rptr,
    ref int ISTAT,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02EKZ(
    ref int NCV,
    ref int NITER,
    ref int NCONV,
    IntPtr W_cptr,
    IntPtr RZEST_rptr,
    ref int ISTAT,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void F02EKF_OPTIO_DELEGATE(
    IntPtr ICOMM_iptr,
    IntPtr COMM_rptr,
    ref int ISTAT,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02EKY(
    IntPtr ICOMM_iptr,
    IntPtr COMM_rptr,
    ref int ISTAT,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02EKF(
    ref int N,
    ref int NNZ,
    [In,Out] double[] A,
    [In] int[] ICOLZP,
    [In] int[] IROWIX,
    ref int NEV,
    ref int NCV,
    ref double SIGMA,
    F02EKF_MONIT_DELEGATE MONIT,
    F02EKF_OPTIO_DELEGATE OPTIO,
    ref int NCONV,
    [Out] Complex[] W,
    [Out] double[,] V,
    ref int LDV,
    [Out] double[] RESID,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );






public delegate double F02FJF_DOT_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr Z_rptr,
    IntPtr W_rptr,
    IntPtr RUSER_rptr,
    ref int LRUSER,
    IntPtr IUSER_iptr,
    ref int LIUSER
  );

public delegate void F02FJF_IMAGE_DELEGATE(
    ref int IFLAG,
    ref int N,
    IntPtr Z_rptr,
    IntPtr W_rptr,
    IntPtr RUSER_rptr,
    ref int LRUSER,
    IntPtr IUSER_iptr,
    ref int LIUSER
  );

public delegate void F02FJF_MONIT_DELEGATE(
    ref int ISTATE,
    ref int NEXTIT,
    ref int NEVALS,
    ref int NEVECS,
    ref int K,
    IntPtr F_rptr,
    IntPtr D_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02FJZ(
    ref int ISTATE,
    ref int NEXTIT,
    ref int NEVALS,
    ref int NEVECS,
    ref int K,
    IntPtr F_rptr,
    IntPtr D_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02FJF(
    ref int N,
    ref int M,
    ref int K,
    ref int NOITS,
    ref double TOL,
    F02FJF_DOT_DELEGATE DOT,
    F02FJF_IMAGE_DELEGATE IMAGE,
    F02FJF_MONIT_DELEGATE MONIT,
    ref int NOVECS,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] D,
    [Out] double[] WORK,
    ref int LWORK,
    [In,Out] double[] RUSER,
    ref int LRUSER,
    [In,Out] int[] IUSER,
    ref int LIUSER,
    ref int IFAIL
   );




public delegate void F02FKF_MONIT_DELEGATE(
    ref int NCV,
    ref int NITER,
    ref int NCONV,
    IntPtr W_rptr,
    IntPtr RZEST_rptr,
    ref int ISTAT,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02FKZ(
    ref int NCV,
    ref int NITER,
    ref int NCONV,
    IntPtr W_rptr,
    IntPtr RZEST_rptr,
    ref int ISTAT,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void F02FKF_OPTIO_DELEGATE(
    IntPtr ICOMM_iptr,
    IntPtr COMM_rptr,
    ref int ISTAT,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02FKF(
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    ref int NEV,
    ref int NCV,
    ref double SIGMA,
    F02FKF_MONIT_DELEGATE MONIT,
    F02FKF_OPTIO_DELEGATE OPTIO,
    ref int NCONV,
    [Out] double[] W,
    [Out] double[,] V,
    ref int LDV,
    [Out] double[] RESID,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02GCF(
    string CRIT,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref double WL,
    ref double WU,
    ref int MEST,
    ref int M,
    [Out] Complex[] W,
    [Out] Complex[,] V,
    ref int LDV,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] IWORK,
    [Out] int[] BWORK,
    ref int IFAIL
,
    long CRITLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02JCF(
    ref int SCAL, string JOBVL, string JOBVR,
    ref int SENSE, ref double TOL, ref int N,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, [In,Out] double[,] C, ref int LDC,
    [Out] double[] ALPHAR, [Out] double[] ALPHAI, [Out] double[] BETA,
    [Out] double[,] VL, ref int LDVL, [Out] double[,] VR,
    ref int LDVR, [Out] double[] S, [Out] double[] BEVL,
    [Out] double[] BEVR, ref int IWARN, ref int IFAIL
,
    long JOBVLLength,
    long JOBVRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02JQF(
    ref int SCAL, string JOBVL, string JOBVR,
    ref int SENSE, ref double TOL, ref int N,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, [In,Out] Complex[,] C, ref int LDC,
    [Out] Complex[] ALPHA, [Out] Complex[] BETA, [Out] Complex[,] VL,
    ref int LDVL, [Out] Complex[,] VR, ref int LDVR,
    [Out] double[] S, [Out] double[] BEVL, [Out] double[] BEVR,
    ref int IWARN, ref int IFAIL
,
    long JOBVLLength,
    long JOBVRLength
    );


public delegate void F02WGF_AV_DELEGATE(
    ref int IFLAG,
    ref int M,
    ref int N,
    IntPtr X_rptr,
    IntPtr AX_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02WGF(
    ref int M,
    ref int N,
    ref int K,
    ref int NCV,
    F02WGF_AV_DELEGATE AV,
    ref int NCONV,
    [Out] double[] SIGMA,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] V,
    ref int LDV,
    [Out] double[] RESID,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02WUF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int NCOLB,
    [In,Out] double[,] B,
    ref int LDB,
    ref int WANTQ,
    [Out] double[,] Q,
    ref int LDQ,
    [Out] double[] SV,
    ref int WANTP,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F02XUF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int NCOLB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int WANTQ,
    [Out] Complex[,] Q,
    ref int LDQ,
    [Out] double[] SV,
    ref int WANTP,
    [Out] double[] RWORK,
    [Out] Complex[] CWORK,
    ref int IFAIL
   );


// chapter f03

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F03BAF(
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref double D,
    ref int ID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F03BFF(
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref double D,
    ref int ID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F03BHF(
    string UPLO,
    ref int N,
    ref int KD,
    [In] double[,] AB,
    ref int LDAB,
    ref double D,
    ref int ID,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F03BNF(
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref Complex D,
    [Out] int[] ID,
    ref int IFAIL
   );


// chapter f04

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04AMF(
    [In] double[,] A,
    ref int LDA,
    [Out] double[,] X,
    ref int LDX,
    [In] double[,] B,
    ref int LDB,
    ref int M,
    ref int N,
    ref int IR,
    ref double EPS,
    [Out] double[,] QR,
    ref int LDQR,
    [Out] double[] ALPHA,
    [Out] double[] E,
    [Out] double[] Y,
    [Out] double[] Z,
    [Out] double[] R,
    [Out] int[] IPIV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04AXF(
    ref int N,
    [In] double[] A,
    ref int LICN,
    [In] int[] ICN,
    [In,Out] int[] IKEEP,
    [In,Out] double[] RHS,
    [Out] double[] W,
    ref int MTYPE,
    [In] int[] IDISP,
    ref double RESID
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BAF(
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BBF(
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BCF(
    ref int N,
    ref int NRHS,
    [In,Out] double[] DL,
    [In,Out] double[] D,
    [In,Out] double[] DU,
    [Out] double[] DU2,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BDF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BEF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BFF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BGF(
    ref int N,
    ref int NRHS,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BHF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04BJF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CAF(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CBF(
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CCF(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] DL,
    [In,Out] Complex[] D,
    [In,Out] Complex[] DU,
    [Out] Complex[] DU2,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CDF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CEF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CFF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CGF(
    ref int N,
    ref int NRHS,
    [In,Out] double[] D,
    [In,Out] Complex[] E,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CHF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04CJF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04DHF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04DJF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref double RCOND,
    ref double ERRBND,
    ref int IFAIL
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04FEF(
    ref int N,
    [In] double[] T,
    [Out] double[] X,
    ref int WANTP,
    [Out] double[] P,
    ref int WANTV,
    [Out] double[] V,
    ref double VLAST,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04FFF(
    ref int N,
    [In] double[] T,
    [In] double[] B,
    [Out] double[] X,
    ref int WANTP,
    [Out] double[] P,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04JGF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[] B,
    ref double TOL,
    ref int SVD,
    ref double SIGMA,
    ref int IRANK,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04LEF(
    ref int JOB,
    ref int N,
    [In] double[] A,
    [In] double[] B,
    [In] double[] C,
    [In] double[] D,
    [In] int[] IPIV,
    [In,Out] double[] Y,
    ref double TOL,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04LHF(
    string TRANS,
    ref int N,
    ref int NBLOKS,
    [In] int[,] BLKSTR,
    [In] double[] A,
    ref int LENA,
    [In] int[] PIVOT,
    [In,Out] double[,] B,
    ref int LDB,
    ref int IR,
    ref int IFAIL
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04MCF(
    ref int N,
    [In] double[] AL,
    ref int LAL,
    [In] double[] D,
    [In] int[] NROW,
    ref int IR,
    [In] double[,] B,
    ref int LDB,
    ref int ISELCT,
    [Out] double[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04MEF(
    ref int N,
    [In] double[] T,
    [In,Out] double[] X,
    ref double V,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04MFF(
    ref int N,
    [In] double[] T,
    [In] double[] B,
    [In,Out] double[] X,
    ref double P,
    [In,Out] double[] WORK,
    ref int IFAIL
   );


public delegate void F04QAF_APROD_DELEGATE(
    ref int MODE,
    ref int M,
    ref int N,
    IntPtr X_rptr,
    IntPtr Y_rptr,
    IntPtr RUSER_rptr,
    ref int LRUSER,
    IntPtr IUSER_iptr,
    ref int LIUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04QAF(
    ref int M, ref int N, [In,Out] double[] B,
    [Out] double[] X, [Out] double[] SE, F04QAF_APROD_DELEGATE APROD,
    ref double DAMP, ref double ATOL, ref double BTOL,
    ref double CONLIM, ref int ITNLIM, ref int MSGLVL,
    ref int ITN, ref double ANORM, ref double ACOND,
    ref double RNORM, ref double ARNORM, ref double XNORM,
    [Out] double[,] WORK, [In,Out] double[] RUSER, ref int LRUSER,
    [In,Out] int[] IUSER, ref int LIUSER, ref int INFORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04YAF(
    ref int JOB,
    ref int P,
    ref double SIGMA,
    [In,Out] double[,] A,
    ref int LDA,
    ref int SVD,
    ref int IRANK,
    [In] double[] SV,
    [Out] double[] CJ,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04YDF(
    ref int IREVCM,
    ref int M,
    ref int N,
    [In,Out] double[,] X,
    ref int LDX,
    [In,Out] double[,] Y,
    ref int LDY,
    ref double ESTNRM,
    ref int T,
    ref int SEED,
    [In,Out] double[] WORK,
    [In,Out] int[] IWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F04ZDF(
    ref int IREVCM,
    ref int M,
    ref int N,
    [In,Out] Complex[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref double ESTNRM,
    ref int T,
    ref int SEED,
    [In,Out] Complex[] WORK,
    [In,Out] double[] RWORK,
    [In,Out] int[] IWORK,
    ref int IFAIL
   );


// chapter f05

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F05AAF(
    [In,Out] double[,] A,
    ref int LDA,
    ref int M,
    ref int N1,
    ref int N2,
    [Out] double[] S,
    ref double CC,
    ref int ICOL,
    ref int IFAIL
   );


// chapter f06

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DROTG(
    ref double A,
    ref double B,
    ref double C,
    ref double S
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06AAF(
    ref double A,
    ref double B,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06BAF(
    ref double A,
    ref double B,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06BCF(
    ref double T,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06BEF(
    string JOB,
    ref double X,
    ref double Y,
    ref double Z,
    ref double C,
    ref double S
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06BHF(
    ref double X,
    ref double Y,
    ref double Z,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06BLF(
    ref double A,
    ref double B,
    ref int FAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06BMF(
    ref double SCAL,
    ref double SSQ
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06BNF(
    ref double A,
    ref double B
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06BPF(
    ref double A,
    ref double B,
    ref double C
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06CAF(
    ref Complex A,
    ref Complex B,
    ref double C,
    ref Complex S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06CBF(
    ref Complex A,
    ref Complex B,
    ref Complex C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06CCF(
    ref Complex T,
    ref double C,
    ref Complex S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06CDF(
    ref Complex T,
    ref Complex C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06CHF(
    ref Complex X,
    ref Complex Y,
    ref Complex Z,
    ref double C,
    ref Complex S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex F06CLF(
    ref Complex A,
    ref Complex B,
    ref int FAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06DBF(
    ref int N,
    ref int CON,
    [In,Out] int[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06DFF(
    ref int N,
    [In] int[] X,
    ref int INCX,
    [In,Out] int[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double DDOT(
    ref int N,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06EAF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DAXPY(
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ECF(
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSCAL(
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EDF(
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DCOPY(
    ref int N,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EFF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSWAP(
    ref int N,
    [In,Out] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EGF(
    ref int N,
    [In,Out] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double DNRM2(
    ref int N,
    [In] double[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06EJF(
    ref int N,
    [In] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double DASUM(
    ref int N,
    [In] double[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06EKF(
    ref int N,
    [In] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DROT(
    ref int N,
    [In,Out] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY,
    ref double C,
    ref double S
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EPF(
    ref int N,
    [In,Out] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double DDOTI(
    ref int NZ,
    [In] double[] X,
    [In] int[] INDX,
    [In] double[] Y
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06ERF(
    ref int NZ,
    [In] double[] X,
    [In] int[] INDX,
    [In] double[] Y
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DAXPYI(
    ref int NZ,
    ref double A,
    [In] double[] X,
    [In] int[] INDX,
    [In,Out] double[] Y
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ETF(
    ref int NZ,
    ref double A,
    [In] double[] X,
    [In] int[] INDX,
    [In,Out] double[] Y
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTHR(
    ref int NZ,
    [In] double[] Y,
    [Out] double[] X,
    [In] int[] INDX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EUF(
    ref int NZ,
    [In] double[] Y,
    [Out] double[] X,
    [In] int[] INDX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTHRZ(
    ref int NZ,
    [In,Out] double[] Y,
    [Out] double[] X,
    [In] int[] INDX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EVF(
    ref int NZ,
    [In,Out] double[] Y,
    [Out] double[] X,
    [In] int[] INDX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSCTR(
    ref int NZ,
    [In] double[] X,
    [In] int[] INDX,
    [In,Out] double[] Y
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EWF(
    ref int NZ,
    [In] double[] X,
    [In] int[] INDX,
    [In,Out] double[] Y
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DROTI(
    ref int NZ,
    [In,Out] double[] X,
    [In] int[] INDX,
    [In,Out] double[] Y,
    ref double C,
    ref double S
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06EXF(
    ref int NZ,
    [In,Out] double[] X,
    [In] int[] INDX,
    [In,Out] double[] Y,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06FAF(
    ref int N,
    ref int J,
    ref double TOLX,
    [In] double[] X,
    ref int INCX,
    ref double TOLY,
    [In] double[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FBF(
    ref int N,
    ref double CON,
    [In,Out] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FCF(
    ref int N,
    [In] double[] D,
    ref int INCD,
    [In,Out] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FDF(
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FEF(
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FGF(
    ref int N,
    [In,Out] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FJF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref double SCAL,
    ref double SUMSQ
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06FKF(
    ref int N,
    [In] double[] W,
    ref int INCW,
    [In] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FLF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref double XMAX,
    ref double XMIN
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FPF(
    ref int N,
    [In,Out] double[] X,
    ref int INCX,
    [In,Out] double[] Y,
    ref int INCY,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FQF(
    string PIVOT,
    string DIRECT,
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX,
    [Out] double[] C,
    [Out] double[] S
,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FRF(
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX,
    ref double TOL,
    ref double ZETA
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FSF(
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX,
    ref double TOL,
    ref double Z1
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FTF(
    ref int N,
    ref double DELTA,
    [In,Out] double[] Y,
    ref int INCY,
    ref double ZETA,
    [In] double[] Z,
    ref int INCZ
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06FUF(
    ref int N,
    [In] double[] Z,
    ref int INCZ,
    ref double Z1,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex ZDOTU(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex F06GAF(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex ZDOTC(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex F06GBF(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZAXPY(
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GCF(
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSCAL(
    ref int N,
    ref Complex ALPHA,
    [In,Out] Complex[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GDF(
    ref int N,
    ref Complex ALPHA,
    [In,Out] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZCOPY(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GFF(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSWAP(
    ref int N,
    [In,Out] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GGF(
    ref int N,
    [In,Out] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex ZDOTUI(
    ref int NZ,
    [In] Complex[] X,
    [In] int[] INDX,
    [In] Complex[] Y
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex F06GRF(
    ref int NZ,
    [In] Complex[] X,
    [In] int[] INDX,
    [In] Complex[] Y
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex ZDOTCI(
    ref int NZ,
    [In] Complex[] X,
    [In] int[] INDX,
    [In] Complex[] Y
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex F06GSF(
    ref int NZ,
    [In] Complex[] X,
    [In] int[] INDX,
    [In] Complex[] Y
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZAXPYI(
    ref int NZ,
    ref Complex A,
    [In] Complex[] X,
    [In] int[] INDX,
    [In,Out] Complex[] Y
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GTF(
    ref int NZ,
    ref Complex A,
    [In] Complex[] X,
    [In] int[] INDX,
    [In,Out] Complex[] Y
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTHR(
    ref int NZ,
    [In] Complex[] Y,
    [Out] Complex[] X,
    [In] int[] INDX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GUF(
    ref int NZ,
    [In] Complex[] Y,
    [Out] Complex[] X,
    [In] int[] INDX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTHRZ(
    ref int NZ,
    [In,Out] Complex[] Y,
    [Out] Complex[] X,
    [In] int[] INDX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GVF(
    ref int NZ,
    [In,Out] Complex[] Y,
    [Out] Complex[] X,
    [In] int[] INDX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSCTR(
    ref int NZ,
    [In] Complex[] X,
    [In] int[] INDX,
    [In,Out] Complex[] Y
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06GWF(
    ref int NZ,
    [In] Complex[] X,
    [In] int[] INDX,
    [In,Out] Complex[] Y
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HBF(
    ref int N,
    ref Complex CON,
    [In,Out] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HCF(
    ref int N,
    [In] Complex[] D,
    ref int INCD,
    [In,Out] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HDF(
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HGF(
    ref int N,
    [In,Out] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZROT(
    ref int N,
    [In,Out] Complex[] CX,
    ref int INCX,
    [In,Out] Complex[] CY,
    ref int INCY,
    ref double C,
    ref Complex S
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HMF(
    ref int N,
    [In,Out] Complex[] CX,
    ref int INCX,
    [In,Out] Complex[] CY,
    ref int INCY,
    ref double C,
    ref Complex S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HPF(
    ref int N,
    [In,Out] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY,
    ref Complex C,
    ref Complex S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HQF(
    string PIVOT,
    string DIRECT,
    ref int N,
    ref Complex ALPHA,
    [In,Out] Complex[] X,
    ref int INCX,
    [Out] double[] C,
    [Out] Complex[] S
,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HRF(
    ref int N,
    ref Complex ALPHA,
    [In,Out] Complex[] X,
    ref int INCX,
    ref double TOL,
    ref Complex THETA
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06HTF(
    ref int N,
    ref Complex DELTA,
    [In,Out] Complex[] Y,
    ref int INCY,
    ref Complex THETA,
    [In] Complex[] Z,
    ref int INCZ
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZDSCAL(
    ref int N,
    ref double ALPHA,
    [In,Out] Complex[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06JDF(
    ref int N,
    ref double ALPHA,
    [In,Out] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double DZNRM2(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06JJF(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double DZASUM(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06JKF(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int IDAMAX(
    ref int N,
    [In] double[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int F06JLF(
    ref int N,
    [In] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int IZAMAX(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int F06JMF(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06KCF(
    ref int N,
    [In] double[] D,
    ref int INCD,
    [In,Out] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06KDF(
    ref int N,
    ref double ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06KEF(
    ref int N,
    ref double ALPHA,
    [In,Out] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06KFF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06KJF(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    ref double SCAL,
    ref double SUMSQ
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int F06KLF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref double TOL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZDROT(
    ref int N,
    [In,Out] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY,
    ref double C,
    ref double S
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06KPF(
    ref int N,
    [In,Out] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] Y,
    ref int INCY,
    ref double C,
    ref double S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEMV(
    string TRANS,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PAF(
    string TRANS,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBMV(
    string TRANS,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PBF(
    string TRANS,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYMV(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PCF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBMV(
    string UPLO,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PDF(
    string UPLO,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPMV(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] AP,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PEF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] AP,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRMV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PFF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTBMV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PGF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPMV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[] AP,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PHF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[] AP,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRSV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PJF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTBSV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PKF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPSV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[] AP,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PLF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] double[] AP,
    [In,Out] double[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGER(
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[,] A,
    ref int LDA
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PMF(
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[,] A,
    ref int LDA
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYR(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[,] A,
    ref int LDA
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PPF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[,] A,
    ref int LDA
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPR(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[] AP
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PQF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In,Out] double[] AP
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYR2(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[,] A,
    ref int LDA
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PRF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[,] A,
    ref int LDA
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPR2(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[] AP
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06PSF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[] AP
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QFF(
    string MATRIX,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[,] B,
    ref int LDB
,
    long MATRIXLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QHF(
    string MATRIX,
    ref int M,
    ref int N,
    ref double CON,
    ref double DIAG,
    [Out] double[,] A,
    ref int LDA
,
    long MATRIXLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QJF(
    string SIDE,
    string TRANS,
    ref int N,
    [In] int[] PERM,
    ref int K,
    [In,Out] double[,] B,
    ref int LDB
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QKF(
    string SIDE,
    string TRANS,
    ref int N,
    [In] double[] PERM,
    ref int K,
    [In,Out] double[,] B,
    ref int LDB
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QMF(
    string UPLO,
    string PIVOT,
    string DIRECT,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In] double[] S,
    [In,Out] double[,] A,
    ref int LDA
,
    long UPLOLength,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QPF(
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] C,
    [Out] double[] S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QQF(
    ref int N,
    ref double ALPHA,
    [In,Out] double[] X,
    ref int INCX,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] C,
    [Out] double[] S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QRF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [Out] double[] C,
    [In,Out] double[] S,
    [In,Out] double[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QSF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [Out] double[] C,
    [In,Out] double[] S,
    [In,Out] double[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QTF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [In,Out] double[] C,
    [In,Out] double[] S,
    [In,Out] double[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QVF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In,Out] double[] S,
    [In,Out] double[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QWF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In,Out] double[] S,
    [In,Out] double[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06QXF(
    string SIDE,
    string PIVOT,
    string DIRECT,
    ref int M,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In] double[] S,
    [In,Out] double[,] A,
    ref int LDA
,
    long SIDELength,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RAF(
    string NORM,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RBF(
    string NORM,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB,
    [Out] double[] WORK
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RCF(
    string NORM,
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RDF(
    string NORM,
    string UPLO,
    ref int N,
    [In] double[] AP,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06REF(
    string NORM,
    string UPLO,
    ref int N,
    ref int K,
    [In] double[,] AB,
    ref int LDAB,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RJF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RKF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] double[] AP,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RLF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    ref int K,
    [In] double[,] AB,
    ref int LDAB,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RMF(
    string NORM,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RNF(
    string NORM,
    ref int N,
    [In] double[] DL,
    [In] double[] D,
    [In] double[] DU
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06RPF(
    string NORM,
    ref int N,
    [In] double[] D,
    [In] double[] E
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEMV(
    string TRANS,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SAF(
    string TRANS,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBMV(
    string TRANS,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SBF(
    string TRANS,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEMV(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SCF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBMV(
    string UPLO,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SDF(
    string UPLO,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPMV(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] AP,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SEF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] AP,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRMV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SFF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTBMV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SGF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPMV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[] AP,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SHF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[] AP,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRSV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SJF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTBSV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SKF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int K,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPSV(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[] AP,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SLF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    [In] Complex[] AP,
    [In,Out] Complex[] X,
    ref int INCX
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGERU(
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[,] A,
    ref int LDA
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SMF(
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[,] A,
    ref int LDA
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGERC(
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[,] A,
    ref int LDA
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SNF(
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[,] A,
    ref int LDA
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHER(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SPF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPR(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] AP
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SQF(
    string UPLO,
    ref int N,
    ref double ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] AP
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHER2(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SRF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPR2(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[] AP
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06SSF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[] AP
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TAF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TBF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TCF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] AP,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TDF(
    string UPLO,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    [In,Out] Complex[] AP
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TFF(
    string MATRIX,
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] Complex[,] B,
    ref int LDB
,
    long MATRIXLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06THF(
    string MATRIX,
    ref int M,
    ref int N,
    ref Complex CON,
    ref Complex DIAG,
    [Out] Complex[,] A,
    ref int LDA
,
    long MATRIXLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TMF(
    string UPLO,
    string PIVOT,
    string DIRECT,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In] Complex[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long UPLOLength,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TPF(
    ref int N,
    ref Complex ALPHA,
    [In,Out] Complex[] X,
    ref int INCX,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] C,
    [Out] Complex[] S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TQF(
    ref int N,
    ref Complex ALPHA,
    [In,Out] Complex[] X,
    ref int INCX,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] C,
    [Out] Complex[] S
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TRF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [Out] Complex[] C,
    [In,Out] double[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TSF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [Out] double[] C,
    [In,Out] Complex[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TTF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [In,Out] double[] C,
    [In,Out] Complex[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TVF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [In] Complex[] C,
    [In,Out] double[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TWF(
    string SIDE,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In,Out] Complex[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TXF(
    string SIDE,
    string PIVOT,
    string DIRECT,
    ref int M,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In] Complex[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06TYF(
    string SIDE,
    string PIVOT,
    string DIRECT,
    ref int M,
    ref int N,
    ref int K1,
    ref int K2,
    [In] Complex[] C,
    [In] double[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UAF(
    string NORM,
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UBF(
    string NORM,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] WORK
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UCF(
    string NORM,
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UDF(
    string NORM,
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UEF(
    string NORM,
    string UPLO,
    ref int N,
    ref int K,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UFF(
    string NORM,
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UGF(
    string NORM,
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UHF(
    string NORM,
    string UPLO,
    ref int N,
    ref int K,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UJF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UKF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] Complex[] AP,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06ULF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    ref int K,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] WORK
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UMF(
    string NORM,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] WORK
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UNF(
    string NORM,
    ref int N,
    [In] Complex[] DL,
    [In] Complex[] D,
    [In] Complex[] DU
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06UPF(
    string NORM,
    ref int N,
    [In] double[] D,
    [In] Complex[] E
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06VJF(
    string SIDE,
    string TRANS,
    ref int N,
    [In] int[] PERM,
    ref int K,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06VKF(
    string SIDE,
    string TRANS,
    ref int N,
    [In] double[] PERM,
    ref int K,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06VXF(
    string SIDE,
    string PIVOT,
    string DIRECT,
    ref int M,
    ref int N,
    ref int K1,
    ref int K2,
    [In] double[] C,
    [In] double[] S,
    [In,Out] Complex[,] A,
    ref int LDA
,
    long SIDELength,
    long PIVOTLength,
    long DIRECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double DLANSF(
    string NORM,
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] A,
    [Out] double[] WORK
,
    long NORMLength,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06WAF(
    string NORM,
    string TRANSR,
    string UPLO,
    ref int N,
    [In] double[] A,
    [Out] double[] WORK
,
    long NORMLength,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTFSM(
    string TRANSR,
    string SIDE,
    string UPLO,
    string TRANS,
    string DIAG,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[] A,
    [In,Out] double[,] B,
    ref int LDB
,
    long TRANSRLength,
    long SIDELength,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06WBF(
    string TRANSR,
    string SIDE,
    string UPLO,
    string TRANS,
    string DIAG,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[] A,
    [In,Out] double[,] B,
    ref int LDB
,
    long TRANSRLength,
    long SIDELength,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSFRK(
    string TRANSR,
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] double[] C
,
    long TRANSRLength,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06WCF(
    string TRANSR,
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] double[] C
,
    long TRANSRLength,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double ZLANHF(
    string NORM,
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] A,
    [Out] double[] WORK
,
    long NORMLength,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F06WNF(
    string NORM,
    string TRANSR,
    string UPLO,
    ref int N,
    [In] Complex[] A,
    [Out] double[] WORK
,
    long NORMLength,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTFSM(
    string TRANSR,
    string SIDE,
    string UPLO,
    string TRANS,
    string DIAG,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] A,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long TRANSRLength,
    long SIDELength,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06WPF(
    string TRANSR,
    string SIDE,
    string UPLO,
    string TRANS,
    string DIAG,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] A,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long TRANSRLength,
    long SIDELength,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHFRK(
    string TRANSR,
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] Complex[] C
,
    long TRANSRLength,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06WQF(
    string TRANSR,
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] Complex[] C
,
    long TRANSRLength,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEMM(
    string TRANSA,
    string TRANSB,
    ref int M,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long TRANSALength,
    long TRANSBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06YAF(
    string TRANSA,
    string TRANSB,
    ref int M,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long TRANSALength,
    long TRANSBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYMM(
    string SIDE,
    string UPLO,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long SIDELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06YCF(
    string SIDE,
    string UPLO,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long SIDELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRMM(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06YFF(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRSM(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06YJF(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYRK(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06YPF(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYR2K(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06YRF(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEMM(
    string TRANSA,
    string TRANSB,
    ref int M,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long TRANSALength,
    long TRANSBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZAF(
    string TRANSA,
    string TRANSB,
    ref int M,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long TRANSALength,
    long TRANSBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEMM(
    string SIDE,
    string UPLO,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long SIDELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZCF(
    string SIDE,
    string UPLO,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long SIDELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRMM(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZFF(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRSM(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZJF(
    string SIDE,
    string UPLO,
    string TRANSA,
    string DIAG,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB
,
    long SIDELength,
    long UPLOLength,
    long TRANSALength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHERK(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZPF(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref double ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    ref double BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHER2K(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZRF(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYMM(
    string SIDE,
    string UPLO,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long SIDELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZTF(
    string SIDE,
    string UPLO,
    ref int M,
    ref int N,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long SIDELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYRK(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZUF(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYR2K(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F06ZWF(
    string UPLO,
    string TRANS,
    ref int N,
    ref int K,
    ref Complex ALPHA,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    ref Complex BETA,
    [In,Out] Complex[,] C,
    ref int LDC
,
    long UPLOLength,
    long TRANSLength
    );


// chapter f07

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGESV(
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AAF(
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGESVX(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In,Out] double[,] A, ref int LDA,
    [In,Out] double[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    StringBuilder EQUED, [In,Out] double[] R, [In,Out] double[] C,
    [In,Out] double[,] B, ref int LDB, [Out] double[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] double[] WORK, [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07ABF(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In,Out] double[,] A, ref int LDA,
    [In,Out] double[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    StringBuilder EQUED, [In,Out] double[] R, [In,Out] double[] C,
    [In,Out] double[,] B, ref int LDB, [Out] double[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] double[] WORK, [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSGESV(
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    [Out] double[] WORK,
    [Out] float[] SWORK,
    ref int ITER,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07ACF(
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    [Out] double[] WORK,
    [Out] float[] SWORK,
    ref int ITER,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGETRF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07ADF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGETRS(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AEF(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEEQU(
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AFF(
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGECON(
    string NORM,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AGF(
    string NORM,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGERFS(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AHF(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGETRI(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AJF(
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGESV(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07ANF(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGESVX(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In,Out] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    StringBuilder EQUED, [In,Out] double[] R, [In,Out] double[] C,
    [In,Out] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07APF(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In,Out] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    StringBuilder EQUED, [In,Out] double[] R, [In,Out] double[] C,
    [In,Out] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZCGESV(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    [Out] Complex[] WORK,
    [Out] ComplexSingle[] SWORK,
    [Out] double[] RWORK,
    ref int ITER,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AQF(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    [Out] Complex[] WORK,
    [Out] ComplexSingle[] SWORK,
    [Out] double[] RWORK,
    ref int ITER,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGETRF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07ARF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGETRS(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07ASF(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEEQU(
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07ATF(
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGECON(
    string NORM,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AUF(
    string NORM,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGERFS(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AVF(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGETRI(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07AWF(
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBSV(
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BAF(
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBSVX(
    string FACT, string TRANS, ref int N,
    ref int KL, ref int KU, ref int NRHS,
    [In,Out] double[,] AB, ref int LDAB, [In,Out] double[,] AFB,
    ref int LDAFB, [In,Out] int[] IPIV, StringBuilder EQUED,
    [In,Out] double[] R, [In,Out] double[] C, [In,Out] double[,] B,
    ref int LDB, [Out] double[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] double[] WORK, [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BBF(
    string FACT, string TRANS, ref int N,
    ref int KL, ref int KU, ref int NRHS,
    [In,Out] double[,] AB, ref int LDAB, [In,Out] double[,] AFB,
    ref int LDAFB, [In,Out] int[] IPIV, StringBuilder EQUED,
    [In,Out] double[] R, [In,Out] double[] C, [In,Out] double[,] B,
    ref int LDB, [Out] double[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] double[] WORK, [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBTRF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BDF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBTRS(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BEF(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBEQU(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BFF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBCON(
    string NORM,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BGF(
    string NORM,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBRFS(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] AFB,
    ref int LDAFB,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BHF(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] AFB,
    ref int LDAFB,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBSV(
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BNF(
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBSVX(
    string FACT, string TRANS, ref int N,
    ref int KL, ref int KU, ref int NRHS,
    [In,Out] Complex[,] AB, ref int LDAB, [In,Out] Complex[,] AFB,
    ref int LDAFB, [In,Out] int[] IPIV, StringBuilder EQUED,
    [In,Out] double[] R, [In,Out] double[] C, [In,Out] Complex[,] B,
    ref int LDB, [Out] Complex[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] Complex[] WORK, [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BPF(
    string FACT, string TRANS, ref int N,
    ref int KL, ref int KU, ref int NRHS,
    [In,Out] Complex[,] AB, ref int LDAB, [In,Out] Complex[,] AFB,
    ref int LDAFB, [In,Out] int[] IPIV, StringBuilder EQUED,
    [In,Out] double[] R, [In,Out] double[] C, [In,Out] Complex[,] B,
    ref int LDB, [Out] Complex[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] Complex[] WORK, [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long TRANSLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBTRF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BRF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] int[] IPIV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBTRS(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BSF(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBEQU(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BTF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] R,
    [Out] double[] C,
    ref double ROWCND,
    ref double COLCND,
    ref double AMAX,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBCON(
    string NORM,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BUF(
    string NORM,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBRFS(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] AFB,
    ref int LDAFB,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07BVF(
    string TRANS,
    ref int N,
    ref int KL,
    ref int KU,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] AFB,
    ref int LDAFB,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTSV(
    ref int N,
    ref int NRHS,
    [In,Out] double[] DL,
    [In,Out] double[] D,
    [In,Out] double[] DU,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CAF(
    ref int N,
    ref int NRHS,
    [In,Out] double[] DL,
    [In,Out] double[] D,
    [In,Out] double[] DU,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTSVX(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In] double[] DL, [In] double[] D,
    [In] double[] DU, [In,Out] double[] DLF, [In,Out] double[] DF,
    [In,Out] double[] DUF, [In,Out] double[] DU2, [In,Out] int[] IPIV,
    [In] double[,] B, ref int LDB, [Out] double[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] double[] WORK, [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CBF(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In] double[] DL, [In] double[] D,
    [In] double[] DU, [In,Out] double[] DLF, [In,Out] double[] DF,
    [In,Out] double[] DUF, [In,Out] double[] DU2, [In,Out] int[] IPIV,
    [In] double[,] B, ref int LDB, [Out] double[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] double[] WORK, [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTTRF(
    ref int N,
    [In,Out] double[] DL,
    [In,Out] double[] D,
    [In,Out] double[] DU,
    [Out] double[] DU2,
    [Out] int[] IPIV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CDF(
    ref int N,
    [In,Out] double[] DL,
    [In,Out] double[] D,
    [In,Out] double[] DU,
    [Out] double[] DU2,
    [Out] int[] IPIV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTTRS(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] double[] DL,
    [In] double[] D,
    [In] double[] DU,
    [In] double[] DU2,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CEF(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] double[] DL,
    [In] double[] D,
    [In] double[] DU,
    [In] double[] DU2,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTCON(
    string NORM,
    ref int N,
    [In] double[] DL,
    [In] double[] D,
    [In] double[] DU,
    [In] double[] DU2,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CGF(
    string NORM,
    ref int N,
    [In] double[] DL,
    [In] double[] D,
    [In] double[] DU,
    [In] double[] DU2,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGTRFS(
    string TRANS, ref int N, ref int NRHS,
    [In] double[] DL, [In] double[] D, [In] double[] DU,
    [In] double[] DLF, [In] double[] DF, [In] double[] DUF,
    [In] double[] DU2, [In] int[] IPIV, [In] double[,] B,
    ref int LDB, [In,Out] double[,] X, ref int LDX,
    [Out] double[] FERR, [Out] double[] BERR, [Out] double[] WORK,
    [Out] int[] IWORK, ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CHF(
    string TRANS, ref int N, ref int NRHS,
    [In] double[] DL, [In] double[] D, [In] double[] DU,
    [In] double[] DLF, [In] double[] DF, [In] double[] DUF,
    [In] double[] DU2, [In] int[] IPIV, [In] double[,] B,
    ref int LDB, [In,Out] double[,] X, ref int LDX,
    [Out] double[] FERR, [Out] double[] BERR, [Out] double[] WORK,
    [Out] int[] IWORK, ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTSV(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] DL,
    [In,Out] Complex[] D,
    [In,Out] Complex[] DU,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CNF(
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] DL,
    [In,Out] Complex[] D,
    [In,Out] Complex[] DU,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTSVX(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In] Complex[] DL, [In] Complex[] D,
    [In] Complex[] DU, [In,Out] Complex[] DLF, [In,Out] Complex[] DF,
    [In,Out] Complex[] DUF, [In,Out] Complex[] DU2, [In,Out] int[] IPIV,
    [In] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CPF(
    string FACT, string TRANS, ref int N,
    ref int NRHS, [In] Complex[] DL, [In] Complex[] D,
    [In] Complex[] DU, [In,Out] Complex[] DLF, [In,Out] Complex[] DF,
    [In,Out] Complex[] DUF, [In,Out] Complex[] DU2, [In,Out] int[] IPIV,
    [In] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTTRF(
    ref int N,
    [In,Out] Complex[] DL,
    [In,Out] Complex[] D,
    [In,Out] Complex[] DU,
    [Out] Complex[] DU2,
    [Out] int[] IPIV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CRF(
    ref int N,
    [In,Out] Complex[] DL,
    [In,Out] Complex[] D,
    [In,Out] Complex[] DU,
    [Out] Complex[] DU2,
    [Out] int[] IPIV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTTRS(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] Complex[] DL,
    [In] Complex[] D,
    [In] Complex[] DU,
    [In] Complex[] DU2,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CSF(
    string TRANS,
    ref int N,
    ref int NRHS,
    [In] Complex[] DL,
    [In] Complex[] D,
    [In] Complex[] DU,
    [In] Complex[] DU2,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTCON(
    string NORM,
    ref int N,
    [In] Complex[] DL,
    [In] Complex[] D,
    [In] Complex[] DU,
    [In] Complex[] DU2,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long NORMLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CUF(
    string NORM,
    ref int N,
    [In] Complex[] DL,
    [In] Complex[] D,
    [In] Complex[] DU,
    [In] Complex[] DU2,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGTRFS(
    string TRANS, ref int N, ref int NRHS,
    [In] Complex[] DL, [In] Complex[] D, [In] Complex[] DU,
    [In] Complex[] DLF, [In] Complex[] DF, [In] Complex[] DUF,
    [In] Complex[] DU2, [In] int[] IPIV, [In] Complex[,] B,
    ref int LDB, [In,Out] Complex[,] X, ref int LDX,
    [Out] double[] FERR, [Out] double[] BERR, [Out] Complex[] WORK,
    [Out] double[] RWORK, ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07CVF(
    string TRANS, ref int N, ref int NRHS,
    [In] Complex[] DL, [In] Complex[] D, [In] Complex[] DU,
    [In] Complex[] DLF, [In] Complex[] DF, [In] Complex[] DUF,
    [In] Complex[] DU2, [In] int[] IPIV, [In] Complex[,] B,
    ref int LDB, [In,Out] Complex[,] X, ref int LDX,
    [Out] double[] FERR, [Out] double[] BERR, [Out] Complex[] WORK,
    [Out] double[] RWORK, ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPOSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FAF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPOSVX(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In,Out] double[,] A, ref int LDA,
    [In,Out] double[,] AF, ref int LDAF, StringBuilder EQUED,
    [In,Out] double[] S, [In,Out] double[,] B, ref int LDB,
    [Out] double[,] X, ref int LDX, ref double RCOND,
    [Out] double[] FERR, [Out] double[] BERR, [Out] double[] WORK,
    [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FBF(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In,Out] double[,] A, ref int LDA,
    [In,Out] double[,] AF, ref int LDAF, StringBuilder EQUED,
    [In,Out] double[] S, [In,Out] double[,] B, ref int LDB,
    [Out] double[,] X, ref int LDX, ref double RCOND,
    [Out] double[] FERR, [Out] double[] BERR, [Out] double[] WORK,
    [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPOSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    [Out] double[,] WORK,
    [Out] float[] SWORK,
    ref int ITER,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FCF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    [Out] double[,] WORK,
    [Out] float[] SWORK,
    ref int ITER,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPOTRF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FDF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPOTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FEF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPOEQU(
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FFF(
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPOCON(
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FGF(
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPORFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] AF,
    ref int LDAF,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FHF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] AF,
    ref int LDAF,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPOTRI(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FJF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPOSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FNF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPOSVX(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In,Out] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, StringBuilder EQUED,
    [In,Out] double[] S, [In,Out] Complex[,] B, ref int LDB,
    [Out] Complex[,] X, ref int LDX, ref double RCOND,
    [Out] double[] FERR, [Out] double[] BERR, [Out] Complex[] WORK,
    [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FPF(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In,Out] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, StringBuilder EQUED,
    [In,Out] double[] S, [In,Out] Complex[,] B, ref int LDB,
    [Out] Complex[,] X, ref int LDX, ref double RCOND,
    [Out] double[] FERR, [Out] double[] BERR, [Out] Complex[] WORK,
    [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZCPOSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    [Out] Complex[,] WORK,
    [Out] ComplexSingle[] SWORK,
    [Out] double[] RWORK,
    ref int ITER,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FQF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    [Out] Complex[,] WORK,
    [Out] ComplexSingle[] SWORK,
    [Out] double[] RWORK,
    ref int ITER,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPOTRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPOTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FSF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPOEQU(
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FTF(
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPOCON(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FUF(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPORFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FVF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPOTRI(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07FWF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GAF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPSVX(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [In,Out] double[] AFP,
    StringBuilder EQUED,
    [In,Out] double[] S,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GBF(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [In,Out] double[] AFP,
    StringBuilder EQUED,
    [In,Out] double[] S,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPTRF(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GDF(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GEF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPEQU(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GFF(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPCON(
    string UPLO,
    ref int N,
    [In] double[] AP,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GGF(
    string UPLO,
    ref int N,
    [In] double[] AP,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] double[] AFP,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GHF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] double[] AFP,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPPTRI(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GJF(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GNF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPSVX(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [In,Out] Complex[] AFP,
    StringBuilder EQUED,
    [In,Out] double[] S,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GPF(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [In,Out] Complex[] AFP,
    StringBuilder EQUED,
    [In,Out] double[] S,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPTRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GSF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPEQU(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GTF(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPCON(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GUF(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[] AFP,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GVF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[] AFP,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPPTRI(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07GWF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBSV(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HAF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBSVX(
    string FACT, string UPLO, ref int N,
    ref int KD, ref int NRHS, [In,Out] double[,] AB,
    ref int LDAB, [In,Out] double[,] AFB, ref int LDAFB,
    StringBuilder EQUED, [In,Out] double[] S, [In,Out] double[,] B,
    ref int LDB, [Out] double[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] double[] WORK, [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HBF(
    string FACT, string UPLO, ref int N,
    ref int KD, ref int NRHS, [In,Out] double[,] AB,
    ref int LDAB, [In,Out] double[,] AFB, ref int LDAFB,
    StringBuilder EQUED, [In,Out] double[] S, [In,Out] double[,] B,
    ref int LDB, [Out] double[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] double[] WORK, [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBTRF(
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HDF(
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBTRS(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HEF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBEQU(
    string UPLO,
    ref int N,
    ref int KD,
    [In] double[,] AB,
    ref int LDAB,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HFF(
    string UPLO,
    ref int N,
    ref int KD,
    [In] double[,] AB,
    ref int LDAB,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBCON(
    string UPLO,
    ref int N,
    ref int KD,
    [In] double[,] AB,
    ref int LDAB,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HGF(
    string UPLO,
    ref int N,
    ref int KD,
    [In] double[,] AB,
    ref int LDAB,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBRFS(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] AFB,
    ref int LDAFB,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HHF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] AFB,
    ref int LDAFB,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBSV(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HNF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBSVX(
    string FACT, string UPLO, ref int N,
    ref int KD, ref int NRHS, [In,Out] Complex[,] AB,
    ref int LDAB, [In,Out] Complex[,] AFB, ref int LDAFB,
    StringBuilder EQUED, [In,Out] double[] S, [In,Out] Complex[,] B,
    ref int LDB, [Out] Complex[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] Complex[] WORK, [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HPF(
    string FACT, string UPLO, ref int N,
    ref int KD, ref int NRHS, [In,Out] Complex[,] AB,
    ref int LDAB, [In,Out] Complex[,] AFB, ref int LDAFB,
    StringBuilder EQUED, [In,Out] double[] S, [In,Out] Complex[,] B,
    ref int LDB, [Out] Complex[,] X, ref int LDX,
    ref double RCOND, [Out] double[] FERR, [Out] double[] BERR,
    [Out] Complex[] WORK, [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength,
    long EQUEDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBTRF(
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HRF(
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBTRS(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HSF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBEQU(
    string UPLO,
    ref int N,
    ref int KD,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HTF(
    string UPLO,
    ref int N,
    ref int KD,
    [In] Complex[,] AB,
    ref int LDAB,
    [Out] double[] S,
    ref double SCOND,
    ref double AMAX,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBCON(
    string UPLO,
    ref int N,
    ref int KD,
    [In] Complex[,] AB,
    ref int LDAB,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HUF(
    string UPLO,
    ref int N,
    ref int KD,
    [In] Complex[,] AB,
    ref int LDAB,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBRFS(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] AFB,
    ref int LDAFB,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07HVF(
    string UPLO,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] AFB,
    ref int LDAFB,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPTSV(
    ref int N,
    ref int NRHS,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JAF(
    ref int N,
    ref int NRHS,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPTSVX(
    string FACT,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] double[] E,
    [In,Out] double[] DF,
    [In,Out] double[] EF,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    ref int INFO
,
    long FACTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JBF(
    string FACT,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] double[] E,
    [In,Out] double[] DF,
    [In,Out] double[] EF,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    ref int INFO
,
    long FACTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPTTRF(
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JDF(
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPTTRS(
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] double[] E,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JEF(
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] double[] E,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPTCON(
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JGF(
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPTRFS(
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] double[] E,
    [In] double[] DF,
    [In] double[] EF,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JHF(
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] double[] E,
    [In] double[] DF,
    [In] double[] EF,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPTSV(
    ref int N,
    ref int NRHS,
    [In,Out] double[] D,
    [In,Out] Complex[] E,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JNF(
    ref int N,
    ref int NRHS,
    [In,Out] double[] D,
    [In,Out] Complex[] E,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPTSVX(
    string FACT,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] Complex[] E,
    [In,Out] double[] DF,
    [In,Out] Complex[] EF,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JPF(
    string FACT,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] Complex[] E,
    [In,Out] double[] DF,
    [In,Out] Complex[] EF,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPTTRF(
    ref int N,
    [In,Out] double[] D,
    [In,Out] Complex[] E,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JRF(
    ref int N,
    [In,Out] double[] D,
    [In,Out] Complex[] E,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPTTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] Complex[] E,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JSF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] Complex[] E,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPTCON(
    ref int N,
    [In] double[] D,
    [In] Complex[] E,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] RWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JUF(
    ref int N,
    [In] double[] D,
    [In] Complex[] E,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] RWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPTRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] Complex[] E,
    [In] double[] DF,
    [In] Complex[] EF,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07JVF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] D,
    [In] Complex[] E,
    [In] double[] DF,
    [In] Complex[] EF,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPSTRF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] PIV,
    ref int RANK,
    ref double TOL,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07KDF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] PIV,
    ref int RANK,
    ref double TOL,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPSTRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] PIV,
    ref int RANK,
    ref double TOL,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07KRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] PIV,
    ref int RANK,
    ref double TOL,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MAF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYSVX(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In] double[,] A, ref int LDA,
    [In,Out] double[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    [In] double[,] B, ref int LDB, [Out] double[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MBF(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In] double[,] A, ref int LDA,
    [In,Out] double[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    [In] double[,] B, ref int LDB, [Out] double[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYTRF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MDF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MEF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYCON(
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MGF(
    string UPLO,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MHF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYTRI(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MJF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHESV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MNF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHESVX(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    [In] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MPF(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    [In] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHETRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHETRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MSF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHECON(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MUF(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHERFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MVF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHETRI(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07MWF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07NNF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYSVX(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    [In] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07NPF(
    string FACT, string UPLO, ref int N,
    ref int NRHS, [In] Complex[,] A, ref int LDA,
    [In,Out] Complex[,] AF, ref int LDAF, [In,Out] int[] IPIV,
    [In] Complex[,] B, ref int LDB, [Out] Complex[,] X,
    ref int LDX, ref double RCOND, [Out] double[] FERR,
    [Out] double[] BERR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int INFO
,
    long FACTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYTRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07NRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] int[] IPIV,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07NSF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYCON(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07NUF(
    string UPLO,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07NVF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] AF,
    ref int LDAF,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSYTRI(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07NWF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PAF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] double[] AP,
    [Out] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPSVX(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In,Out] double[] AFP,
    [In,Out] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PBF(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In,Out] double[] AFP,
    [In,Out] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [Out] double[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPTRF(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] int[] IPIV,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PDF(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] int[] IPIV,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PEF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] int[] IPIV,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPCON(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PGF(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] double[] AFP,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PHF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] double[] AFP,
    [In] int[] IPIV,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPTRI(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In] int[] IPIV,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PJF(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In] int[] IPIV,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PNF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPSVX(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[] AFP,
    [In,Out] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PPF(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[] AFP,
    [In,Out] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPTRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PSF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPCON(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PUF(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[] AFP,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PVF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[] AFP,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPTRI(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07PWF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSPSV(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07QNF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSPSVX(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[] AFP,
    [In,Out] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07QPF(
    string FACT,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[] AFP,
    [In,Out] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] X,
    ref int LDX,
    ref double RCOND,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long FACTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSPTRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07QRF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] int[] IPIV,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSPTRS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07QSF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] int[] IPIV,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSPCON(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07QUF(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [In] int[] IPIV,
    ref double ANORM,
    ref double RCOND,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSPRFS(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[] AFP,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07QVF(
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[] AFP,
    [In] int[] IPIV,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSPTRI(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07QWF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In] int[] IPIV,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRTRS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07TEF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRCON(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07TGF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRRFS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07THF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRTRI(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07TJF(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRTRS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07TSF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRCON(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07TUF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRRFS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [In] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07TVF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [In] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRTRI(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07TWF(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPTRS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07UEF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPCON(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] double[] AP,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07UGF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] double[] AP,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPRFS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] double[,] B,
    ref int LDB,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07UHF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] double[] AP,
    [In] double[,] B,
    ref int LDB,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPTRI(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] double[] AP,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07UJF(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] double[] AP,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPTRS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07USF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPCON(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] Complex[] AP,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07UUF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    [In] Complex[] AP,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPRFS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[,] B,
    ref int LDB,
    [In] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07UVF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int NRHS,
    [In] Complex[] AP,
    [In] Complex[,] B,
    ref int LDB,
    [In] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPTRI(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07UWF(
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] Complex[] AP,
    ref int INFO
,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTBTRS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07VEF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTBCON(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    ref int KD,
    [In] double[,] AB,
    ref int LDAB,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07VGF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    ref int KD,
    [In] double[,] AB,
    ref int LDAB,
    ref double RCOND,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTBRFS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] B,
    ref int LDB,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07VHF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] B,
    ref int LDB,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTBTRS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07VSF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTBCON(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    ref int KD,
    [In] Complex[,] AB,
    ref int LDAB,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07VUF(
    string NORM,
    string UPLO,
    string DIAG,
    ref int N,
    ref int KD,
    [In] Complex[,] AB,
    ref int LDAB,
    ref double RCOND,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long NORMLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTBRFS(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] B,
    ref int LDB,
    [In] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07VVF(
    string UPLO,
    string TRANS,
    string DIAG,
    ref int N,
    ref int KD,
    ref int NRHS,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] B,
    ref int LDB,
    [In] Complex[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long UPLOLength,
    long TRANSLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPFTRF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WDF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPFTRS(
    string TRANSR,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AR,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WEF(
    string TRANSR,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] double[] AR,
    [In,Out] double[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPFTRI(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WJF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTFTRI(
    string TRANSR,
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WKF(
    string TRANSR,
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] double[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength,
    long DIAGLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPFTRF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WRF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPFTRS(
    string TRANSR,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AR,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WSF(
    string TRANSR,
    string UPLO,
    ref int N,
    ref int NRHS,
    [In] Complex[] AR,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPFTRI(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WWF(
    string TRANSR,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTFTRI(
    string TRANSR,
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength,
    long DIAGLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F07WXF(
    string TRANSR,
    string UPLO,
    string DIAG,
    ref int N,
    [In,Out] Complex[] AR,
    ref int INFO
,
    long TRANSRLength,
    long UPLOLength,
    long DIAGLength
    );


// chapter f08

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGELS(
    string TRANS,
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AAF(
    string TRANS,
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEQRT(
    ref int M,
    ref int N,
    ref int NB,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[,] T,
    ref int LDT,
    [Out] double[] WORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ABF(
    ref int M,
    ref int N,
    ref int NB,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[,] T,
    ref int LDT,
    [Out] double[] WORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEMQRT(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int NB,
    [In,Out] double[,] V,
    ref int LDV,
    [In] double[,] T,
    ref int LDT,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ACF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int NB,
    [In,Out] double[,] V,
    ref int LDV,
    [In] double[,] T,
    ref int LDT,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEQRF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AEF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORGQR(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AFF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMQR(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AGF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGELQF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AHF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORGLQ(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AJF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMLQ(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AKF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGELS(
    string TRANS,
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ANF(
    string TRANS,
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEQRT(
    ref int M,
    ref int N,
    ref int NB,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[,] T,
    ref int LDT,
    [Out] Complex[] WORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08APF(
    ref int M,
    ref int N,
    ref int NB,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[,] T,
    ref int LDT,
    [Out] Complex[] WORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEMQRT(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int NB,
    [In,Out] Complex[,] V,
    ref int LDV,
    [In] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AQF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int NB,
    [In,Out] Complex[,] V,
    ref int LDV,
    [In] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEQRF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ASF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNGQR(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ATF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMQR(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AUF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGELQF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AVF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNGLQ(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AWF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMLQ(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08AXF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGELSY(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] int[] JPVT,
    ref double RCOND,
    ref int RANK,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BAF(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] int[] JPVT,
    ref double RCOND,
    ref int RANK,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPQRT(
    ref int M,
    ref int N,
    ref int L,
    ref int NB,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[,] T,
    ref int LDT,
    [Out] double[] WORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BBF(
    ref int M,
    ref int N,
    ref int L,
    ref int NB,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[,] T,
    ref int LDT,
    [Out] double[] WORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTPMQRT(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    ref int NB,
    [In] double[,] V,
    ref int LDV,
    [In] double[,] T,
    ref int LDT,
    [In,Out] double[,] C1,
    ref int LDC1,
    [In,Out] double[,] C2,
    ref int LDC2,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BCF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    ref int NB,
    [In] double[,] V,
    ref int LDV,
    [In] double[,] T,
    ref int LDT,
    [In,Out] double[,] C1,
    ref int LDC1,
    [In,Out] double[,] C2,
    ref int LDC2,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEQPF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BEF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEQP3(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BFF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTZRZF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BHF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMRZ(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BKF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGELSY(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] int[] JPVT,
    ref double RCOND,
    ref int RANK,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BNF(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] int[] JPVT,
    ref double RCOND,
    ref int RANK,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPQRT(
    ref int M,
    ref int N,
    ref int L,
    ref int NB,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] T,
    ref int LDT,
    [Out] Complex[] WORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BPF(
    ref int M,
    ref int N,
    ref int L,
    ref int NB,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[,] T,
    ref int LDT,
    [Out] Complex[] WORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTPMQRT(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    ref int NB,
    [In] Complex[,] V,
    ref int LDV,
    [In] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] C1,
    ref int LDC1,
    [In,Out] Complex[,] C2,
    ref int LDC2,
    [Out] Complex[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BQF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    ref int NB,
    [In] Complex[,] V,
    ref int LDV,
    [In] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] C1,
    ref int LDC1,
    [In,Out] Complex[,] C2,
    ref int LDC2,
    [Out] Complex[] WORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEQPF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BSF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEQP3(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BTF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] int[] JPVT,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTZRZF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BVF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMRZ(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08BXF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    ref int L,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEQLF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CEF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORGQL(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CFF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMQL(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CGF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGERQF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CHF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORGRQ(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CJF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMRQ(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CKF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEQLF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CSF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNGQL(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CTF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMQL(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CUF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGERQF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CVF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNGRQ(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CWF(
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMRQ(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08CXF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYEV(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FAF(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYEVX(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] double[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FBF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] double[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYEVD(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FCF(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYEVR(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] double[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] int[] ISUPPZ, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FDF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] double[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] int[] ISUPPZ, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYTRD(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FEF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORGTR(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FFF(
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMTR(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FGF(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DDISNA(
    string JOB,
    ref int M,
    ref int N,
    [In] double[] D,
    [Out] double[] SEP,
    ref int INFO
,
    long JOBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FLF(
    string JOB,
    ref int M,
    ref int N,
    [In] double[] D,
    [Out] double[] SEP,
    ref int INFO
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEEV(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FNF(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEEVX(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] Complex[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, ref int LWORK, [Out] double[] RWORK,
    [Out] int[] IWORK, [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FPF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] Complex[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, ref int LWORK, [Out] double[] RWORK,
    [Out] int[] IWORK, [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEEVD(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FQF(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEEVR(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] Complex[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] int[] ISUPPZ, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int LRWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FRF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, [In,Out] Complex[,] A, ref int LDA,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] int[] ISUPPZ, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int LRWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHETRD(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FSF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNGTR(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FTF(
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMTR(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08FUF(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPEV(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GAF(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPEVX(
    string JOBZ,
    string RANGE,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    ref int M,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GBF(
    string JOBZ,
    string RANGE,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    ref int M,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPEVD(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GCF(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPTRD(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[] TAU,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GEF(
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[] TAU,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DOPGTR(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [In] double[] TAU,
    [Out] double[,] Q,
    ref int LDQ,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GFF(
    string UPLO,
    ref int N,
    [In] double[] AP,
    [In] double[] TAU,
    [Out] double[,] Q,
    ref int LDQ,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DOPMTR(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] double[] AP,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GGF(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] double[] AP,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPEV(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GNF(
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPEVX(
    string JOBZ,
    string RANGE,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    ref int M,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    [Out] int[] IWORK,
    [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GPF(
    string JOBZ,
    string RANGE,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    ref int M,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    [Out] int[] IWORK,
    [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPEVD(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GQF(
    string JOB,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPTRD(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[] TAU,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GSF(
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[] TAU,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUPGTR(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [In] Complex[] TAU,
    [Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GTF(
    string UPLO,
    ref int N,
    [In] Complex[] AP,
    [In] Complex[] TAU,
    [Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUPMTR(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] Complex[] AP,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08GUF(
    string SIDE,
    string UPLO,
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] Complex[] AP,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int INFO
,
    long SIDELength,
    long UPLOLength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBEV(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HAF(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBEVX(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KD, [In,Out] double[,] AB,
    ref int LDAB, [Out] double[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, [Out] int[] IWORK, [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HBF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KD, [In,Out] double[,] AB,
    ref int LDAB, [Out] double[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, [Out] int[] IWORK, [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBEVD(
    string JOB,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HCF(
    string JOB,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBTRD(
    string VECT,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [In,Out] double[,] Q,
    ref int LDQ,
    [Out] double[] WORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HEF(
    string VECT,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [In,Out] double[,] Q,
    ref int LDQ,
    [Out] double[] WORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBEV(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HNF(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBEVX(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KD, [In,Out] Complex[,] AB,
    ref int LDAB, [Out] Complex[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, [Out] double[] RWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HPF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KD, [In,Out] Complex[,] AB,
    ref int LDAB, [Out] Complex[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, [Out] double[] RWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBEVD(
    string JOB,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HQF(
    string JOB,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBTRD(
    string VECT,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[] WORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08HSF(
    string VECT,
    string UPLO,
    ref int N,
    ref int KD,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[] WORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEV(
    string JOBZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JAF(
    string JOBZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEVX(
    string JOBZ,
    string RANGE,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    ref int M,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JBF(
    string JOBZ,
    string RANGE,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    ref int M,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEVD(
    string JOB,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JCF(
    string JOB,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEVR(
    string JOBZ, string RANGE, ref int N,
    [In,Out] double[] D, [In,Out] double[] E, ref double VL,
    ref double VU, ref int IL, ref int IU,
    ref double ABSTOL, ref int M, [Out] double[] W,
    [Out] double[,] Z, ref int LDZ, [Out] int[] ISUPPZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JDF(
    string JOBZ, string RANGE, ref int N,
    [In,Out] double[] D, [In,Out] double[] E, ref double VL,
    ref double VU, ref int IL, ref int IU,
    ref double ABSTOL, ref int M, [Out] double[] W,
    [Out] double[,] Z, ref int LDZ, [Out] int[] ISUPPZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEQR(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JEF(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTERF(
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JFF(
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPTEQR(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JGF(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEDC(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JHF(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEBZ(
    string RANGE,
    string ORDER,
    ref int N,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    [In] double[] D,
    [In] double[] E,
    ref int M,
    ref int NSPLIT,
    [Out] double[] W,
    [Out] int[] IBLOCK,
    [Out] int[] ISPLIT,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long RANGELength,
    long ORDERLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JJF(
    string RANGE,
    string ORDER,
    ref int N,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref double ABSTOL,
    [In] double[] D,
    [In] double[] E,
    ref int M,
    ref int NSPLIT,
    [Out] double[] W,
    [Out] int[] IBLOCK,
    [Out] int[] ISPLIT,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long RANGELength,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEIN(
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref int M,
    [In] double[] W,
    [In] int[] IBLOCK,
    [In] int[] ISPLIT,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] IFAILV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JKF(
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref int M,
    [In] double[] W,
    [In] int[] IBLOCK,
    [In] int[] ISPLIT,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] IFAILV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSTEGR(
    string JOBZ, string RANGE, ref int N,
    [In,Out] double[] D, [In,Out] double[] E, ref double VL,
    ref double VU, ref int IL, ref int IU,
    ref double ABSTOL, ref int M, [Out] double[] W,
    [Out] double[,] Z, ref int LDZ, [Out] int[] ISUPPZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JLF(
    string JOBZ, string RANGE, ref int N,
    [In,Out] double[] D, [In,Out] double[] E, ref double VL,
    ref double VU, ref int IL, ref int IU,
    ref double ABSTOL, ref int M, [Out] double[] W,
    [Out] double[,] Z, ref int LDZ, [Out] int[] ISUPPZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSTEQR(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JSF(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPTEQR(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JUF(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSTEDC(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JVF(
    string COMPZ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSTEIN(
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref int M,
    [In] double[] W,
    [In] int[] IBLOCK,
    [In] int[] ISPLIT,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] IFAILV,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JXF(
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref int M,
    [In] double[] W,
    [In] int[] IBLOCK,
    [In] int[] ISPLIT,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    [Out] int[] IFAILV,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZSTEGR(
    string JOBZ, string RANGE, ref int N,
    [In,Out] double[] D, [In,Out] double[] E, ref double VL,
    ref double VU, ref int IL, ref int IU,
    ref double ABSTOL, ref int M, [Out] double[] W,
    [Out] Complex[,] Z, ref int LDZ, [Out] int[] ISUPPZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08JYF(
    string JOBZ, string RANGE, ref int N,
    [In,Out] double[] D, [In,Out] double[] E, ref double VL,
    ref double VU, ref int IL, ref int IU,
    ref double ABSTOL, ref int M, [Out] double[] W,
    [Out] Complex[,] Z, ref int LDZ, [Out] int[] ISUPPZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int LIWORK, ref int INFO
,
    long JOBZLength,
    long RANGELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGELSS(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KAF(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGESVD(
    string JOBU,
    string JOBVT,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] VT,
    ref int LDVT,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KBF(
    string JOBU,
    string JOBVT,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] VT,
    ref int LDVT,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGELSD(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KCF(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGESDD(
    string JOBZ,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] VT,
    ref int LDVT,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KDF(
    string JOBZ,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] VT,
    ref int LDVT,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEBRD(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[] TAUQ,
    [Out] double[] TAUP,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KEF(
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[] TAUQ,
    [Out] double[] TAUP,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORGBR(
    string VECT,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KFF(
    string VECT,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMBR(
    string VECT,
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KGF(
    string VECT,
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEJSV(
    string JOBA,
    string JOBU,
    string JOBV,
    string JOBR,
    string JOBT,
    string JOBP,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] SVA,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] V,
    ref int LDV,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength,
    long JOBRLength,
    long JOBTLength,
    long JOBPLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KHF(
    string JOBA,
    string JOBU,
    string JOBV,
    string JOBR,
    string JOBT,
    string JOBP,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] SVA,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] V,
    ref int LDV,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength,
    long JOBRLength,
    long JOBTLength,
    long JOBPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGESVJ(
    string JOBA,
    string JOBU,
    string JOBV,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] SVA,
    ref int MV,
    [In,Out] double[,] V,
    ref int LDV,
    [In,Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KJF(
    string JOBA,
    string JOBU,
    string JOBV,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] SVA,
    ref int MV,
    [In,Out] double[,] V,
    ref int LDV,
    [In,Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGESVDX(
    string JOBU, string JOBVT, string RANGE,
    ref int M, ref int N, [In,Out] double[,] A,
    ref int LDA, ref double VL, ref double VU,
    ref int IL, ref int IU, ref int NS,
    [Out] double[] S, [Out] double[,] U, ref int LDU,
    [Out] double[,] VT, ref int LDVT, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVTLength,
    long RANGELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KMF(
    string JOBU, string JOBVT, string RANGE,
    ref int M, ref int N, [In,Out] double[,] A,
    ref int LDA, ref double VL, ref double VU,
    ref int IL, ref int IU, ref int NS,
    [Out] double[] S, [Out] double[,] U, ref int LDU,
    [Out] double[,] VT, ref int LDVT, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVTLength,
    long RANGELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGELSS(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KNF(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGESVD(
    string JOBU,
    string JOBVT,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] Complex[,] U,
    ref int LDU,
    [Out] Complex[,] VT,
    ref int LDVT,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KPF(
    string JOBU,
    string JOBVT,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] Complex[,] U,
    ref int LDU,
    [Out] Complex[,] VT,
    ref int LDVT,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGELSD(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] IWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KQF(
    ref int M,
    ref int N,
    ref int NRHS,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] S,
    ref double RCOND,
    ref int RANK,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] IWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGESDD(
    string JOBZ,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] Complex[,] U,
    ref int LDU,
    [Out] Complex[,] VT,
    ref int LDVT,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KRF(
    string JOBZ,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] S,
    [Out] Complex[,] U,
    ref int LDU,
    [Out] Complex[,] VT,
    ref int LDVT,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEBRD(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[] TAUQ,
    [Out] Complex[] TAUP,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KSF(
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[] TAUQ,
    [Out] Complex[] TAUP,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNGBR(
    string VECT,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KTF(
    string VECT,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMBR(
    string VECT,
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KUF(
    string VECT,
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int K,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long VECTLength,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEJSV(
    string JOBA, string JOBU, string JOBV,
    string JOBR, string JOBT, string JOBP,
    ref int M, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [Out] double[] SVA, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[] CWORK, ref int LWORK, [Out] double[] RWORK,
    ref int LRWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength,
    long JOBRLength,
    long JOBTLength,
    long JOBPLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KVF(
    string JOBA, string JOBU, string JOBV,
    string JOBR, string JOBT, string JOBP,
    ref int M, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [Out] double[] SVA, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[] CWORK, ref int LWORK, [Out] double[] RWORK,
    ref int LRWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength,
    long JOBRLength,
    long JOBTLength,
    long JOBPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGESVJ(
    string JOBA,
    string JOBU,
    string JOBV,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] SVA,
    ref int MV,
    [In,Out] Complex[,] V,
    ref int LDV,
    [Out] Complex[] CWORK,
    ref int LWORK,
    [In,Out] double[] RWORK,
    ref int LRWORK,
    ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KWF(
    string JOBA,
    string JOBU,
    string JOBV,
    ref int M,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] double[] SVA,
    ref int MV,
    [In,Out] Complex[,] V,
    ref int LDV,
    [Out] Complex[] CWORK,
    ref int LWORK,
    [In,Out] double[] RWORK,
    ref int LRWORK,
    ref int INFO
,
    long JOBALength,
    long JOBULength,
    long JOBVLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGESVDX(
    string JOBU, string JOBVT, string RANGE,
    ref int M, ref int N, [In,Out] Complex[,] A,
    ref int LDA, ref double VL, ref double VU,
    ref int IL, ref int IU, ref int NS,
    [Out] double[] S, [Out] Complex[,] U, ref int LDU,
    [Out] Complex[,] VT, ref int LDVT, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, [Out] int[] IWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVTLength,
    long RANGELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08KZF(
    string JOBU, string JOBVT, string RANGE,
    ref int M, ref int N, [In,Out] Complex[,] A,
    ref int LDA, ref double VL, ref double VU,
    ref int IL, ref int IU, ref int NS,
    [Out] double[] S, [Out] Complex[,] U, ref int LDU,
    [Out] Complex[,] VT, ref int LDVT, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, [Out] int[] IWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVTLength,
    long RANGELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGBBRD(
    string VECT,
    ref int M,
    ref int N,
    ref int NCC,
    ref int KL,
    ref int KU,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[,] Q,
    ref int LDQ,
    [Out] double[,] PT,
    ref int LDPT,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long VECTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08LEF(
    string VECT,
    ref int M,
    ref int N,
    ref int NCC,
    ref int KL,
    ref int KU,
    [In,Out] double[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [Out] double[,] Q,
    ref int LDQ,
    [Out] double[,] PT,
    ref int LDPT,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long VECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGBBRD(
    string VECT,
    ref int M,
    ref int N,
    ref int NCC,
    ref int KL,
    ref int KU,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[,] PT,
    ref int LDPT,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long VECTLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08LSF(
    string VECT,
    ref int M,
    ref int N,
    ref int NCC,
    ref int KL,
    ref int KU,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [Out] double[] D,
    [Out] double[] E,
    [Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[,] PT,
    ref int LDPT,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long VECTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DBDSVDX(
    string UPLO,
    string JOBZ,
    string RANGE,
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref int NS,
    [Out] double[] S,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long JOBZLength,
    long RANGELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08MBF(
    string UPLO,
    string JOBZ,
    string RANGE,
    ref int N,
    [In] double[] D,
    [In] double[] E,
    ref double VL,
    ref double VU,
    ref int IL,
    ref int IU,
    ref int NS,
    [Out] double[] S,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long JOBZLength,
    long RANGELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DBDSDC(
    string UPLO,
    string COMPQ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] VT,
    ref int LDVT,
    [Out] double[] Q,
    [Out] int[] IQ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long COMPQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08MDF(
    string UPLO,
    string COMPQ,
    ref int N,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] VT,
    ref int LDVT,
    [Out] double[] Q,
    [Out] int[] IQ,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long UPLOLength,
    long COMPQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DBDSQR(
    string UPLO,
    ref int N,
    ref int NCVT,
    ref int NRU,
    ref int NCC,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] VT,
    ref int LDVT,
    [In,Out] double[,] U,
    ref int LDU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08MEF(
    string UPLO,
    ref int N,
    ref int NCVT,
    ref int NRU,
    ref int NCC,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] double[,] VT,
    ref int LDVT,
    [In,Out] double[,] U,
    ref int LDU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZBDSQR(
    string UPLO,
    ref int N,
    ref int NCVT,
    ref int NRU,
    ref int NCC,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] VT,
    ref int LDVT,
    [In,Out] Complex[,] U,
    ref int LDU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08MSF(
    string UPLO,
    ref int N,
    ref int NCVT,
    ref int NRU,
    ref int NCC,
    [In,Out] double[] D,
    [In,Out] double[] E,
    [In,Out] Complex[,] VT,
    ref int LDVT,
    [In,Out] Complex[,] U,
    ref int LDU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEEV(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] WR,
    [Out] double[] WI,
    [Out] double[,] VL,
    ref int LDVL,
    [Out] double[,] VR,
    ref int LDVR,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NAF(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] WR,
    [Out] double[] WI,
    [Out] double[,] VL,
    ref int LDVL,
    [Out] double[,] VR,
    ref int LDVR,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEEVX(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] double[,] A,
    ref int LDA, [Out] double[] WR, [Out] double[] WI,
    [Out] double[,] VL, ref int LDVL, [Out] double[,] VR,
    ref int LDVR, ref int ILO, ref int IHI,
    [Out] double[] SCAL, ref double ABNRM, [Out] double[] RCONDE,
    [Out] double[] RCONDV, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NBF(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] double[,] A,
    ref int LDA, [Out] double[] WR, [Out] double[] WI,
    [Out] double[,] VL, ref int LDVL, [Out] double[,] VR,
    ref int LDVR, ref int ILO, ref int IHI,
    [Out] double[] SCAL, ref double ABNRM, [Out] double[] RCONDE,
    [Out] double[] RCONDV, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEHRD(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NEF(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORGHR(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NFF(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORMHR(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NGF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[] TAU,
    [In,Out] double[,] C,
    ref int LDC,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEBAL(
    string JOB,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int ILO,
    ref int IHI,
    [Out] double[] SCAL,
    ref int INFO
,
    long JOBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NHF(
    string JOB,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int ILO,
    ref int IHI,
    [Out] double[] SCAL,
    ref int INFO
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEBAK(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] SCAL,
    ref int M,
    [In,Out] double[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NJF(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] SCAL,
    ref int M,
    [In,Out] double[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEEV(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] W,
    [Out] Complex[,] VL,
    ref int LDVL,
    [Out] Complex[,] VR,
    ref int LDVR,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NNF(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] W,
    [Out] Complex[,] VL,
    ref int LDVL,
    [Out] Complex[,] VR,
    ref int LDVR,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEEVX(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [Out] Complex[] W, [Out] Complex[,] VL,
    ref int LDVL, [Out] Complex[,] VR, ref int LDVR,
    ref int ILO, ref int IHI, [Out] double[] SCAL,
    ref double ABNRM, [Out] double[] RCONDE, [Out] double[] RCONDV,
    [Out] Complex[] WORK, ref int LWORK, [Out] double[] RWORK,
    ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NPF(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [Out] Complex[] W, [Out] Complex[,] VL,
    ref int LDVL, [Out] Complex[,] VR, ref int LDVR,
    ref int ILO, ref int IHI, [Out] double[] SCAL,
    ref double ABNRM, [Out] double[] RCONDE, [Out] double[] RCONDV,
    [Out] Complex[] WORK, ref int LWORK, [Out] double[] RWORK,
    ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEHRD(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NSF(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNGHR(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NTF(
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNMHR(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NUF(
    string SIDE,
    string TRANS,
    ref int M,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In] Complex[] TAU,
    [In,Out] Complex[,] C,
    ref int LDC,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long SIDELength,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEBAL(
    string JOB,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int ILO,
    ref int IHI,
    [Out] double[] SCAL,
    ref int INFO
,
    long JOBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NVF(
    string JOB,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int ILO,
    ref int IHI,
    [Out] double[] SCAL,
    ref int INFO
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEBAK(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] SCAL,
    ref int M,
    [In,Out] Complex[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08NWF(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] SCAL,
    ref int M,
    [In,Out] Complex[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );


public delegate bool DGEES_SEL_DELEGATE(
    ref double WR,
    ref double WI
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool F08PAZ(
    ref double WR,
    ref double WI
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEES(
    string JOBVS,
    string SORT,
    DGEES_SEL_DELEGATE SEL,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int SDIM,
    [Out] double[] WR,
    [Out] double[] WI,
    [Out] double[,] VS,
    ref int LDVS,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] BWORK,
    ref int INFO
,
    long JOBVSLength,
    long SORTLength
    );

public delegate bool F08PAF_SEL_DELEGATE(
    ref double WR,
    ref double WI
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PAF(
    string JOBVS,
    string SORT,
    F08PAF_SEL_DELEGATE SEL,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int SDIM,
    [Out] double[] WR,
    [Out] double[] WI,
    [Out] double[,] VS,
    ref int LDVS,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] BWORK,
    ref int INFO
,
    long JOBVSLength,
    long SORTLength
    );


public delegate bool DGEESX_SEL_DELEGATE(
    ref double WR,
    ref double WI
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGEESX(
    string JOBVS, string SORT, DGEESX_SEL_DELEGATE SEL,
    string SENSE, ref int N, [In,Out] double[,] A,
    ref int LDA, ref int SDIM, [Out] double[] WR,
    [Out] double[] WI, [Out] double[,] VS, ref int LDVS,
    ref double RCONDE, ref double RCONDV, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int LIWORK,
    [Out] int[] BWORK, ref int INFO
,
    long JOBVSLength,
    long SORTLength,
    long SENSELength
    );

public delegate bool F08PBF_SEL_DELEGATE(
    ref double WR,
    ref double WI
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PBF(
    string JOBVS, string SORT, F08PBF_SEL_DELEGATE SEL,
    string SENSE, ref int N, [In,Out] double[,] A,
    ref int LDA, ref int SDIM, [Out] double[] WR,
    [Out] double[] WI, [Out] double[,] VS, ref int LDVS,
    ref double RCONDE, ref double RCONDV, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int LIWORK,
    [Out] int[] BWORK, ref int INFO
,
    long JOBVSLength,
    long SORTLength,
    long SENSELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DHSEQR(
    string JOB,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] H,
    ref int LDH,
    [Out] double[] WR,
    [Out] double[] WI,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PEF(
    string JOB,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] H,
    ref int LDH,
    [Out] double[] WR,
    [Out] double[] WI,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBLength,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DHSEIN(
    string JOB,
    string EIGSRC,
    string INITV,
    [In,Out] int[] SEL,
    ref int N,
    [In] double[,] H,
    ref int LDH,
    [In,Out] double[] WR,
    [In] double[] WI,
    [In,Out] double[,] VL,
    ref int LDVL,
    [In,Out] double[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] double[] WORK,
    [Out] int[] IFAILL,
    [Out] int[] IFAILR,
    ref int INFO
,
    long JOBLength,
    long EIGSRCLength,
    long INITVLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PKF(
    string JOB,
    string EIGSRC,
    string INITV,
    [In,Out] int[] SEL,
    ref int N,
    [In] double[,] H,
    ref int LDH,
    [In,Out] double[] WR,
    [In] double[] WI,
    [In,Out] double[,] VL,
    ref int LDVL,
    [In,Out] double[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] double[] WORK,
    [Out] int[] IFAILL,
    [Out] int[] IFAILR,
    ref int INFO
,
    long JOBLength,
    long EIGSRCLength,
    long INITVLength
    );


public delegate bool ZGEES_SEL_DELEGATE(
    ref Complex W
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool F08PNZ(
    ref Complex W
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEES(
    string JOBVS,
    string SORT,
    ZGEES_SEL_DELEGATE SEL,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int SDIM,
    [Out] Complex[] W,
    [Out] Complex[,] VS,
    ref int LDVS,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] BWORK,
    ref int INFO
,
    long JOBVSLength,
    long SORTLength
    );

public delegate bool F08PNF_SEL_DELEGATE(
    ref Complex W
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PNF(
    string JOBVS,
    string SORT,
    F08PNF_SEL_DELEGATE SEL,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int SDIM,
    [Out] Complex[] W,
    [Out] Complex[,] VS,
    ref int LDVS,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] BWORK,
    ref int INFO
,
    long JOBVSLength,
    long SORTLength
    );


public delegate bool ZGEESX_SEL_DELEGATE(
    ref Complex W
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGEESX(
    string JOBVS,
    string SORT,
    ZGEESX_SEL_DELEGATE SEL,
    string SENSE,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int SDIM,
    [Out] Complex[] W,
    [Out] Complex[,] VS,
    ref int LDVS,
    ref double RCONDE,
    ref double RCONDV,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] BWORK,
    ref int INFO
,
    long JOBVSLength,
    long SORTLength,
    long SENSELength
    );

public delegate bool F08PPF_SEL_DELEGATE(
    ref Complex W
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PPF(
    string JOBVS,
    string SORT,
    F08PPF_SEL_DELEGATE SEL,
    string SENSE,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    ref int SDIM,
    [Out] Complex[] W,
    [Out] Complex[,] VS,
    ref int LDVS,
    ref double RCONDE,
    ref double RCONDV,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    [Out] int[] BWORK,
    ref int INFO
,
    long JOBVSLength,
    long SORTLength,
    long SENSELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHSEQR(
    string JOB,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] H,
    ref int LDH,
    [Out] Complex[] W,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PSF(
    string JOB,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] H,
    ref int LDH,
    [Out] Complex[] W,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBLength,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHSEIN(
    string JOB,
    string EIGSRC,
    string INITV,
    [In] int[] SEL,
    ref int N,
    [In] Complex[,] H,
    ref int LDH,
    [In,Out] Complex[] W,
    [In,Out] Complex[,] VL,
    ref int LDVL,
    [In,Out] Complex[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    [Out] int[] IFAILL,
    [Out] int[] IFAILR,
    ref int INFO
,
    long JOBLength,
    long EIGSRCLength,
    long INITVLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08PXF(
    string JOB,
    string EIGSRC,
    string INITV,
    [In] int[] SEL,
    ref int N,
    [In] Complex[,] H,
    ref int LDH,
    [In,Out] Complex[] W,
    [In,Out] Complex[,] VL,
    ref int LDVL,
    [In,Out] Complex[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    [Out] int[] IFAILL,
    [Out] int[] IFAILR,
    ref int INFO
,
    long JOBLength,
    long EIGSRCLength,
    long INITVLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTREXC(
    string COMPQ,
    ref int N,
    [In,Out] double[,] T,
    ref int LDT,
    [In,Out] double[,] Q,
    ref int LDQ,
    ref int IFST,
    ref int ILST,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QFF(
    string COMPQ,
    ref int N,
    [In,Out] double[,] T,
    ref int LDT,
    [In,Out] double[,] Q,
    ref int LDQ,
    ref int IFST,
    ref int ILST,
    [Out] double[] WORK,
    ref int INFO
,
    long COMPQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRSEN(
    string JOB,
    string COMPQ,
    [In] int[] SEL,
    ref int N,
    [In,Out] double[,] T,
    ref int LDT,
    [In,Out] double[,] Q,
    ref int LDQ,
    [Out] double[] WR,
    [Out] double[] WI,
    ref int M,
    ref double S,
    ref double SEP,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long COMPQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QGF(
    string JOB,
    string COMPQ,
    [In] int[] SEL,
    ref int N,
    [In,Out] double[,] T,
    ref int LDT,
    [In,Out] double[,] Q,
    ref int LDQ,
    [Out] double[] WR,
    [Out] double[] WI,
    ref int M,
    ref double S,
    ref double SEP,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBLength,
    long COMPQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRSYL(
    string TRANA,
    string TRANB,
    ref int ISGN,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] C,
    ref int LDC,
    ref double SCAL,
    ref int INFO
,
    long TRANALength,
    long TRANBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QHF(
    string TRANA,
    string TRANB,
    ref int ISGN,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] C,
    ref int LDC,
    ref double SCAL,
    ref int INFO
,
    long TRANALength,
    long TRANBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTREVC(
    string JOB,
    string HOWMNY,
    [In,Out] int[] SEL,
    ref int N,
    [In] double[,] T,
    ref int LDT,
    [In,Out] double[,] VL,
    ref int LDVL,
    [In,Out] double[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QKF(
    string JOB,
    string HOWMNY,
    [In,Out] int[] SEL,
    ref int N,
    [In] double[,] T,
    ref int LDT,
    [In,Out] double[,] VL,
    ref int LDVL,
    [In,Out] double[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTRSNA(
    string JOB,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] double[,] T,
    ref int LDT,
    [In] double[,] VL,
    ref int LDVL,
    [In] double[,] VR,
    ref int LDVR,
    [Out] double[] S,
    [Out] double[] SEP,
    ref int MM,
    ref int M,
    [Out] double[,] WORK,
    ref int LDWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QLF(
    string JOB,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] double[,] T,
    ref int LDT,
    [In] double[,] VL,
    ref int LDVL,
    [In] double[,] VR,
    ref int LDVR,
    [Out] double[] S,
    [Out] double[] SEP,
    ref int MM,
    ref int M,
    [Out] double[,] WORK,
    ref int LDWORK,
    [Out] int[] IWORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTREXC(
    string COMPQ,
    ref int N,
    [In,Out] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    ref int IFST,
    ref int ILST,
    ref int INFO
,
    long COMPQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QTF(
    string COMPQ,
    ref int N,
    [In,Out] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    ref int IFST,
    ref int ILST,
    ref int INFO
,
    long COMPQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRSEN(
    string JOB,
    string COMPQ,
    [In] int[] SEL,
    ref int N,
    [In,Out] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[] W,
    ref int M,
    ref double S,
    ref double SEP,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBLength,
    long COMPQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QUF(
    string JOB,
    string COMPQ,
    [In] int[] SEL,
    ref int N,
    [In,Out] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [Out] Complex[] W,
    ref int M,
    ref double S,
    ref double SEP,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBLength,
    long COMPQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRSYL(
    string TRANA,
    string TRANB,
    ref int ISGN,
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] C,
    ref int LDC,
    ref double SCAL,
    ref int INFO
,
    long TRANALength,
    long TRANBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QVF(
    string TRANA,
    string TRANB,
    ref int ISGN,
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] C,
    ref int LDC,
    ref double SCAL,
    ref int INFO
,
    long TRANALength,
    long TRANBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTREVC(
    string JOB,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In,Out] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] VL,
    ref int LDVL,
    [In,Out] Complex[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QXF(
    string JOB,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In,Out] Complex[,] T,
    ref int LDT,
    [In,Out] Complex[,] VL,
    ref int LDVL,
    [In,Out] Complex[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTRSNA(
    string JOB,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] Complex[,] T,
    ref int LDT,
    [In] Complex[,] VL,
    ref int LDVL,
    [In] Complex[,] VR,
    ref int LDVR,
    [Out] double[] S,
    [Out] double[] SEP,
    ref int MM,
    ref int M,
    [Out] Complex[,] WORK,
    ref int LDWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08QYF(
    string JOB,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] Complex[,] T,
    ref int LDT,
    [In] Complex[,] VL,
    ref int LDVL,
    [In] Complex[,] VR,
    ref int LDVR,
    [Out] double[] S,
    [Out] double[] SEP,
    ref int MM,
    ref int M,
    [Out] Complex[,] WORK,
    ref int LDWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DORCSD(
    string JOBU1, string JOBU2, string JOBV1T,
    string JOBV2T, string TRANS, string SIGNS,
    ref int M, ref int P, ref int Q,
    [In,Out] double[,] X11, ref int LDX11, [In,Out] double[,] X12,
    ref int LDX12, [In,Out] double[,] X21, ref int LDX21,
    [In,Out] double[,] X22, ref int LDX22, [Out] double[] THETA,
    [Out] double[,] U1, ref int LDU1, [Out] double[,] U2,
    ref int LDU2, [Out] double[,] V1T, ref int LDV1T,
    [Out] double[,] V2T, ref int LDV2T, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBU1Length,
    long JOBU2Length,
    long JOBV1TLength,
    long JOBV2TLength,
    long TRANSLength,
    long SIGNSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08RAF(
    string JOBU1, string JOBU2, string JOBV1T,
    string JOBV2T, string TRANS, string SIGNS,
    ref int M, ref int P, ref int Q,
    [In,Out] double[,] X11, ref int LDX11, [In,Out] double[,] X12,
    ref int LDX12, [In,Out] double[,] X21, ref int LDX21,
    [In,Out] double[,] X22, ref int LDX22, [Out] double[] THETA,
    [Out] double[,] U1, ref int LDU1, [Out] double[,] U2,
    ref int LDU2, [Out] double[,] V1T, ref int LDV1T,
    [Out] double[,] V2T, ref int LDV2T, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBU1Length,
    long JOBU2Length,
    long JOBV1TLength,
    long JOBV2TLength,
    long TRANSLength,
    long SIGNSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZUNCSD(
    string JOBU1, string JOBU2, string JOBV1T,
    string JOBV2T, string TRANS, string SIGNS,
    ref int M, ref int P, ref int Q,
    [In,Out] Complex[,] X11, ref int LDX11, [In,Out] Complex[,] X12,
    ref int LDX12, [In,Out] Complex[,] X21, ref int LDX21,
    [In,Out] Complex[,] X22, ref int LDX22, [Out] double[] THETA,
    [Out] Complex[,] U1, ref int LDU1, [Out] Complex[,] U2,
    ref int LDU2, [Out] Complex[,] V1T, ref int LDV1T,
    [Out] Complex[,] V2T, ref int LDV2T, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, ref int LRWORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBU1Length,
    long JOBU2Length,
    long JOBV1TLength,
    long JOBV2TLength,
    long TRANSLength,
    long SIGNSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08RNF(
    string JOBU1, string JOBU2, string JOBV1T,
    string JOBV2T, string TRANS, string SIGNS,
    ref int M, ref int P, ref int Q,
    [In,Out] Complex[,] X11, ref int LDX11, [In,Out] Complex[,] X12,
    ref int LDX12, [In,Out] Complex[,] X21, ref int LDX21,
    [In,Out] Complex[,] X22, ref int LDX22, [Out] double[] THETA,
    [Out] Complex[,] U1, ref int LDU1, [Out] Complex[,] U2,
    ref int LDU2, [Out] Complex[,] V1T, ref int LDV1T,
    [Out] Complex[,] V2T, ref int LDV2T, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, ref int LRWORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBU1Length,
    long JOBU2Length,
    long JOBV1TLength,
    long JOBV2TLength,
    long TRANSLength,
    long SIGNSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYGV(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SAF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYGVX(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SBF(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYGVD(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SCF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSYGST(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SEF(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEGV(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SNF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEGVX(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, ref int LWORK, [Out] double[] RWORK,
    [Out] int[] IWORK, [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SPF(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, ref int LWORK, [Out] double[] RWORK,
    [Out] int[] IWORK, [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEGVD(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SQF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] double[] W,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHEGST(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08SSF(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPGV(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In,Out] double[] BP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TAF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In,Out] double[] BP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPGVX(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] double[] AP,
    [In,Out] double[] BP, ref double VL, ref double VU,
    ref int IL, ref int IU, ref double ABSTOL,
    ref int M, [Out] double[] W, [Out] double[,] Z,
    ref int LDZ, [Out] double[] WORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TBF(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] double[] AP,
    [In,Out] double[] BP, ref double VL, ref double VU,
    ref int IL, ref int IU, ref double ABSTOL,
    ref int M, [Out] double[] W, [Out] double[,] Z,
    ref int LDZ, [Out] double[] WORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPGVD(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In,Out] double[] BP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TCF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In,Out] double[] BP,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSPGST(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In] double[] BP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TEF(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] double[] AP,
    [In] double[] BP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPGV(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In,Out] Complex[] BP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TNF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In,Out] Complex[] BP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPGVX(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] Complex[] AP,
    [In,Out] Complex[] BP, ref double VL, ref double VU,
    ref int IL, ref int IU, ref double ABSTOL,
    ref int M, [Out] double[] W, [Out] Complex[,] Z,
    ref int LDZ, [Out] Complex[] WORK, [Out] double[] RWORK,
    [Out] int[] IWORK, [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TPF(
    ref int ITYPE, string JOBZ, string RANGE,
    string UPLO, ref int N, [In,Out] Complex[] AP,
    [In,Out] Complex[] BP, ref double VL, ref double VU,
    ref int IL, ref int IU, ref double ABSTOL,
    ref int M, [Out] double[] W, [Out] Complex[,] Z,
    ref int LDZ, [Out] Complex[] WORK, [Out] double[] RWORK,
    [Out] int[] IWORK, [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPGVD(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In,Out] Complex[] BP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TQF(
    ref int ITYPE,
    string JOBZ,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In,Out] Complex[] BP,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHPGST(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In] Complex[] BP,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08TSF(
    ref int ITYPE,
    string UPLO,
    ref int N,
    [In,Out] Complex[] AP,
    [In] Complex[] BP,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBGV(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UAF(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBGVX(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KA, ref int KB,
    [In,Out] double[,] AB, ref int LDAB, [In,Out] double[,] BB,
    ref int LDBB, [Out] double[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, [Out] int[] IWORK, [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UBF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KA, ref int KB,
    [In,Out] double[,] AB, ref int LDAB, [In,Out] double[,] BB,
    ref int LDBB, [Out] double[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] double[,] Z, ref int LDZ,
    [Out] double[] WORK, [Out] int[] IWORK, [Out] int[] JFAIL,
    ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBGVD(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UCF(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In,Out] double[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DSBGST(
    string VECT,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In] double[,] BB,
    ref int LDBB,
    [Out] double[,] X,
    ref int LDX,
    [Out] double[] WORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UEF(
    string VECT,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] double[,] AB,
    ref int LDAB,
    [In] double[,] BB,
    ref int LDBB,
    [Out] double[,] X,
    ref int LDX,
    [Out] double[] WORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DPBSTF(
    string UPLO,
    ref int N,
    ref int KB,
    [In,Out] double[,] BB,
    ref int LDBB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UFF(
    string UPLO,
    ref int N,
    ref int KB,
    [In,Out] double[,] BB,
    ref int LDBB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBGV(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UNF(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBGVX(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KA, ref int KB,
    [In,Out] Complex[,] AB, ref int LDAB, [In,Out] Complex[,] BB,
    ref int LDBB, [Out] Complex[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, [Out] double[] RWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UPF(
    string JOBZ, string RANGE, string UPLO,
    ref int N, ref int KA, ref int KB,
    [In,Out] Complex[,] AB, ref int LDAB, [In,Out] Complex[,] BB,
    ref int LDBB, [Out] Complex[,] Q, ref int LDQ,
    ref double VL, ref double VU, ref int IL,
    ref int IU, ref double ABSTOL, ref int M,
    [Out] double[] W, [Out] Complex[,] Z, ref int LDZ,
    [Out] Complex[] WORK, [Out] double[] RWORK, [Out] int[] IWORK,
    [Out] int[] JFAIL, ref int INFO
,
    long JOBZLength,
    long RANGELength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBGVD(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UQF(
    string JOBZ,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In,Out] Complex[,] BB,
    ref int LDBB,
    [Out] double[] W,
    [Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int INFO
,
    long JOBZLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHBGST(
    string VECT,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] BB,
    ref int LDBB,
    [Out] Complex[,] X,
    ref int LDX,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08USF(
    string VECT,
    string UPLO,
    ref int N,
    ref int KA,
    ref int KB,
    [In,Out] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] BB,
    ref int LDBB,
    [Out] Complex[,] X,
    ref int LDX,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long VECTLength,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZPBSTF(
    string UPLO,
    ref int N,
    ref int KB,
    [In,Out] Complex[,] BB,
    ref int LDBB,
    ref int INFO
,
    long UPLOLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08UTF(
    string UPLO,
    ref int N,
    ref int KB,
    [In,Out] Complex[,] BB,
    ref int LDBB,
    ref int INFO
,
    long UPLOLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGSVD(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] double[] WORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VAF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] double[] WORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGSVD3(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VCF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGSVP(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] TAU, [Out] double[] WORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VEF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] TAU, [Out] double[] WORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGSVP3(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] TAU, [Out] double[] WORK, ref int LWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VGF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] double[,] U,
    ref int LDU, [Out] double[,] V, ref int LDV,
    [Out] double[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] TAU, [Out] double[] WORK, ref int LWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGSVD(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] Complex[] WORK,
    [Out] double[] RWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VNF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] Complex[] WORK,
    [Out] double[] RWORK, [Out] int[] IWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGSVD3(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, [Out] int[] IWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VQF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int N, ref int P,
    ref int K, ref int L, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] double[] ALPHA, [Out] double[] BETA, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, [Out] int[] IWORK,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGSVP(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] RWORK, [Out] Complex[] TAU, [Out] Complex[] WORK,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VSF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] RWORK, [Out] Complex[] TAU, [Out] Complex[] WORK,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGSVP3(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] RWORK, [Out] Complex[] TAU, [Out] Complex[] WORK,
    ref int LWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08VUF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, ref double TOLA, ref double TOLB,
    ref int K, ref int L, [Out] Complex[,] U,
    ref int LDU, [Out] Complex[,] V, ref int LDV,
    [Out] Complex[,] Q, ref int LDQ, [Out] int[] IWORK,
    [Out] double[] RWORK, [Out] Complex[] TAU, [Out] Complex[] WORK,
    ref int LWORK, ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGEV(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] ALPHAR,
    [Out] double[] ALPHAI,
    [Out] double[] BETA,
    [Out] double[,] VL,
    ref int LDVL,
    [Out] double[,] VR,
    ref int LDVR,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WAF(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] ALPHAR,
    [Out] double[] ALPHAI,
    [Out] double[] BETA,
    [Out] double[,] VL,
    ref int LDVL,
    [Out] double[,] VR,
    ref int LDVR,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGEVX(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHAR, [Out] double[] ALPHAI, [Out] double[] BETA,
    [Out] double[,] VL, ref int LDVL, [Out] double[,] VR,
    ref int LDVR, ref int ILO, ref int IHI,
    [Out] double[] LSCALE, [Out] double[] RSCALE, ref double ABNRM,
    ref double BBNRM, [Out] double[] RCONDE, [Out] double[] RCONDV,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    [Out] int[] BWORK, ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WBF(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHAR, [Out] double[] ALPHAI, [Out] double[] BETA,
    [Out] double[,] VL, ref int LDVL, [Out] double[,] VR,
    ref int LDVR, ref int ILO, ref int IHI,
    [Out] double[] LSCALE, [Out] double[] RSCALE, ref double ABNRM,
    ref double BBNRM, [Out] double[] RCONDE, [Out] double[] RCONDV,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    [Out] int[] BWORK, ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGEV3(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] ALPHAR,
    [Out] double[] ALPHAI,
    [Out] double[] BETA,
    [Out] double[,] VL,
    ref int LDVL,
    [Out] double[,] VR,
    ref int LDVR,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WCF(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] ALPHAR,
    [Out] double[] ALPHAI,
    [Out] double[] BETA,
    [Out] double[,] VL,
    ref int LDVL,
    [Out] double[,] VR,
    ref int LDVR,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGHRD(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[,] Q,
    ref int LDQ,
    [In,Out] double[,] Z,
    ref int LDZ,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WEF(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[,] Q,
    ref int LDQ,
    [In,Out] double[,] Z,
    ref int LDZ,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGHD3(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[,] Q,
    ref int LDQ,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WFF(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[,] Q,
    ref int LDQ,
    [In,Out] double[,] Z,
    ref int LDZ,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGBAL(
    string JOB,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int ILO,
    ref int IHI,
    [Out] double[] LSCALE,
    [Out] double[] RSCALE,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WHF(
    string JOB,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    ref int ILO,
    ref int IHI,
    [Out] double[] LSCALE,
    [Out] double[] RSCALE,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGBAK(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] LSCALE,
    [In] double[] RSCALE,
    ref int M,
    [In,Out] double[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WJF(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] LSCALE,
    [In] double[] RSCALE,
    ref int M,
    [In,Out] double[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGEV(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] ALPHA,
    [Out] Complex[] BETA,
    [Out] Complex[,] VL,
    ref int LDVL,
    [Out] Complex[,] VR,
    ref int LDVR,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WNF(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] ALPHA,
    [Out] Complex[] BETA,
    [Out] Complex[,] VL,
    ref int LDVL,
    [Out] Complex[,] VR,
    ref int LDVR,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGEVX(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] Complex[] ALPHA, [Out] Complex[] BETA, [Out] Complex[,] VL,
    ref int LDVL, [Out] Complex[,] VR, ref int LDVR,
    ref int ILO, ref int IHI, [Out] double[] LSCALE,
    [Out] double[] RSCALE, ref double ABNRM, ref double BBNRM,
    [Out] double[] RCONDE, [Out] double[] RCONDV, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, [Out] int[] IWORK,
    [Out] int[] BWORK, ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WPF(
    string BALANC, string JOBVL, string JOBVR,
    string SENSE, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] Complex[] ALPHA, [Out] Complex[] BETA, [Out] Complex[,] VL,
    ref int LDVL, [Out] Complex[,] VR, ref int LDVR,
    ref int ILO, ref int IHI, [Out] double[] LSCALE,
    [Out] double[] RSCALE, ref double ABNRM, ref double BBNRM,
    [Out] double[] RCONDE, [Out] double[] RCONDV, [Out] Complex[] WORK,
    ref int LWORK, [Out] double[] RWORK, [Out] int[] IWORK,
    [Out] int[] BWORK, ref int INFO
,
    long BALANCLength,
    long JOBVLLength,
    long JOBVRLength,
    long SENSELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGEV3(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] ALPHA,
    [Out] Complex[] BETA,
    [Out] Complex[,] VL,
    ref int LDVL,
    [Out] Complex[,] VR,
    ref int LDVR,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WQF(
    string JOBVL,
    string JOBVR,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] ALPHA,
    [Out] Complex[] BETA,
    [Out] Complex[,] VL,
    ref int LDVL,
    [Out] Complex[,] VR,
    ref int LDVR,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long JOBVLLength,
    long JOBVRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGHRD(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WSF(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGHD3(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WTF(
    string COMPQ,
    string COMPZ,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
,
    long COMPQLength,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGBAL(
    string JOB,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int ILO,
    ref int IHI,
    [Out] double[] LSCALE,
    [Out] double[] RSCALE,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WVF(
    string JOB,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    ref int ILO,
    ref int IHI,
    [Out] double[] LSCALE,
    [Out] double[] RSCALE,
    [Out] double[] WORK,
    ref int INFO
,
    long JOBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGBAK(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] LSCALE,
    [In] double[] RSCALE,
    ref int M,
    [In,Out] Complex[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08WWF(
    string JOB,
    string SIDE,
    ref int N,
    ref int ILO,
    ref int IHI,
    [In] double[] LSCALE,
    [In] double[] RSCALE,
    ref int M,
    [In,Out] Complex[,] V,
    ref int LDV,
    ref int INFO
,
    long JOBLength,
    long SIDELength
    );


public delegate bool DGGES_SELCTG_DELEGATE(
    ref double AR,
    ref double AI,
    ref double B
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool F08XAZ(
    ref double AR,
    ref double AI,
    ref double B
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGES(
    string JOBVSL, string JOBVSR, string SORT,
    DGGES_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref int SDIM, [Out] double[] ALPHAR, [Out] double[] ALPHAI,
    [Out] double[] BETA, [Out] double[,] VSL, ref int LDVSL,
    [Out] double[,] VSR, ref int LDVSR, [Out] double[] WORK,
    ref int LWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );

public delegate bool F08XAF_SELCTG_DELEGATE(
    ref double AR,
    ref double AI,
    ref double B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XAF(
    string JOBVSL, string JOBVSR, string SORT,
    F08XAF_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref int SDIM, [Out] double[] ALPHAR, [Out] double[] ALPHAI,
    [Out] double[] BETA, [Out] double[,] VSL, ref int LDVSL,
    [Out] double[,] VSR, ref int LDVSR, [Out] double[] WORK,
    ref int LWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );


public delegate bool DGGESX_SELCTG_DELEGATE(
    ref double AR,
    ref double AI,
    ref double B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGESX(
    string JOBVSL, string JOBVSR, string SORT,
    DGGESX_SELCTG_DELEGATE SELCTG, string SENSE, ref int N,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, ref int SDIM, [Out] double[] ALPHAR,
    [Out] double[] ALPHAI, [Out] double[] BETA, [Out] double[,] VSL,
    ref int LDVSL, [Out] double[,] VSR, ref int LDVSR,
    [Out] double[] RCONDE, [Out] double[] RCONDV, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int LIWORK,
    [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength,
    long SENSELength
    );

public delegate bool F08XBF_SELCTG_DELEGATE(
    ref double AR,
    ref double AI,
    ref double B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XBF(
    string JOBVSL, string JOBVSR, string SORT,
    F08XBF_SELCTG_DELEGATE SELCTG, string SENSE, ref int N,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, ref int SDIM, [Out] double[] ALPHAR,
    [Out] double[] ALPHAI, [Out] double[] BETA, [Out] double[,] VSL,
    ref int LDVSL, [Out] double[,] VSR, ref int LDVSR,
    [Out] double[] RCONDE, [Out] double[] RCONDV, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int LIWORK,
    [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength,
    long SENSELength
    );


public delegate bool DGGES3_SELCTG_DELEGATE(
    ref double AR,
    ref double AI,
    ref double B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGES3(
    string JOBVSL, string JOBVSR, string SORT,
    DGGES3_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref int SDIM, [Out] double[] ALPHAR, [Out] double[] ALPHAI,
    [Out] double[] BETA, [Out] double[,] VSL, ref int LDVSL,
    [Out] double[,] VSR, ref int LDVSR, [Out] double[] WORK,
    ref int LWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );

public delegate bool F08XCF_SELCTG_DELEGATE(
    ref double AR,
    ref double AI,
    ref double B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XCF(
    string JOBVSL, string JOBVSR, string SORT,
    F08XCF_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref int SDIM, [Out] double[] ALPHAR, [Out] double[] ALPHAI,
    [Out] double[] BETA, [Out] double[,] VSL, ref int LDVSL,
    [Out] double[,] VSR, ref int LDVSR, [Out] double[] WORK,
    ref int LWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DHGEQZ(
    string JOB, string COMPQ, string COMPZ,
    ref int N, ref int ILO, ref int IHI,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, [Out] double[] ALPHAR, [Out] double[] ALPHAI,
    [Out] double[] BETA, [In,Out] double[,] Q, ref int LDQ,
    [In,Out] double[,] Z, ref int LDZ, [Out] double[] WORK,
    ref int LWORK, ref int INFO
,
    long JOBLength,
    long COMPQLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XEF(
    string JOB, string COMPQ, string COMPZ,
    ref int N, ref int ILO, ref int IHI,
    [In,Out] double[,] A, ref int LDA, [In,Out] double[,] B,
    ref int LDB, [Out] double[] ALPHAR, [Out] double[] ALPHAI,
    [Out] double[] BETA, [In,Out] double[,] Q, ref int LDQ,
    [In,Out] double[,] Z, ref int LDZ, [Out] double[] WORK,
    ref int LWORK, ref int INFO
,
    long JOBLength,
    long COMPQLength,
    long COMPZLength
    );


public delegate bool ZGGES_SELCTG_DELEGATE(
    ref Complex A,
    ref Complex B
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool F08XNZ(
    ref Complex A,
    ref Complex B
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGES(
    string JOBVSL, string JOBVSR, string SORT,
    ZGGES_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref int SDIM, [Out] Complex[] ALPHA, [Out] Complex[] BETA,
    [Out] Complex[,] VSL, ref int LDVSL, [Out] Complex[,] VSR,
    ref int LDVSR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );

public delegate bool F08XNF_SELCTG_DELEGATE(
    ref Complex A,
    ref Complex B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XNF(
    string JOBVSL, string JOBVSR, string SORT,
    F08XNF_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref int SDIM, [Out] Complex[] ALPHA, [Out] Complex[] BETA,
    [Out] Complex[,] VSL, ref int LDVSL, [Out] Complex[,] VSR,
    ref int LDVSR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );


public delegate bool ZGGESX_SELCTG_DELEGATE(
    ref Complex A,
    ref Complex B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGESX(
    string JOBVSL, string JOBVSR, string SORT,
    ZGGESX_SELCTG_DELEGATE SELCTG, string SENSE, ref int N,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, ref int SDIM, [Out] Complex[] ALPHA,
    [Out] Complex[] BETA, [Out] Complex[,] VSL, ref int LDVSL,
    [Out] Complex[,] VSR, ref int LDVSR, [Out] double[] RCONDE,
    [Out] double[] RCONDV, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, [Out] int[] IWORK, ref int LIWORK,
    [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength,
    long SENSELength
    );

public delegate bool F08XPF_SELCTG_DELEGATE(
    ref Complex A,
    ref Complex B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XPF(
    string JOBVSL, string JOBVSR, string SORT,
    F08XPF_SELCTG_DELEGATE SELCTG, string SENSE, ref int N,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, ref int SDIM, [Out] Complex[] ALPHA,
    [Out] Complex[] BETA, [Out] Complex[,] VSL, ref int LDVSL,
    [Out] Complex[,] VSR, ref int LDVSR, [Out] double[] RCONDE,
    [Out] double[] RCONDV, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, [Out] int[] IWORK, ref int LIWORK,
    [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength,
    long SENSELength
    );


public delegate bool ZGGES3_SELCTG_DELEGATE(
    ref Complex A,
    ref Complex B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGES3(
    string JOBVSL, string JOBVSR, string SORT,
    ZGGES3_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref int SDIM, [Out] Complex[] ALPHA, [Out] Complex[] BETA,
    [Out] Complex[,] VSL, ref int LDVSL, [Out] Complex[,] VSR,
    ref int LDVSR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );

public delegate bool F08XQF_SELCTG_DELEGATE(
    ref Complex A,
    ref Complex B
  );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XQF(
    string JOBVSL, string JOBVSR, string SORT,
    F08XQF_SELCTG_DELEGATE SELCTG, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref int SDIM, [Out] Complex[] ALPHA, [Out] Complex[] BETA,
    [Out] Complex[,] VSL, ref int LDVSL, [Out] Complex[,] VSR,
    ref int LDVSR, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, [Out] int[] BWORK, ref int INFO
,
    long JOBVSLLength,
    long JOBVSRLength,
    long SORTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZHGEQZ(
    string JOB, string COMPQ, string COMPZ,
    ref int N, ref int ILO, ref int IHI,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, [Out] Complex[] ALPHA, [Out] Complex[] BETA,
    [In,Out] Complex[,] Q, ref int LDQ, [In,Out] Complex[,] Z,
    ref int LDZ, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int INFO
,
    long JOBLength,
    long COMPQLength,
    long COMPZLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08XSF(
    string JOB, string COMPQ, string COMPZ,
    ref int N, ref int ILO, ref int IHI,
    [In,Out] Complex[,] A, ref int LDA, [In,Out] Complex[,] B,
    ref int LDB, [Out] Complex[] ALPHA, [Out] Complex[] BETA,
    [In,Out] Complex[,] Q, ref int LDQ, [In,Out] Complex[,] Z,
    ref int LDZ, [Out] Complex[] WORK, ref int LWORK,
    [Out] double[] RWORK, ref int INFO
,
    long JOBLength,
    long COMPQLength,
    long COMPZLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTGSJA(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    ref int K, ref int L, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref double TOLA, ref double TOLB, [Out] double[] ALPHA,
    [Out] double[] BETA, [In,Out] double[,] U, ref int LDU,
    [In,Out] double[,] V, ref int LDV, [In,Out] double[,] Q,
    ref int LDQ, [Out] double[] WORK, ref int NCYCLE,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YEF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    ref int K, ref int L, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    ref double TOLA, ref double TOLB, [Out] double[] ALPHA,
    [Out] double[] BETA, [In,Out] double[,] U, ref int LDU,
    [In,Out] double[,] V, ref int LDV, [In,Out] double[,] Q,
    ref int LDQ, [Out] double[] WORK, ref int NCYCLE,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTGEXC(
    ref int WANTQ,
    ref int WANTZ,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[,] Q,
    ref int LDQ,
    [In,Out] double[,] Z,
    ref int LDZ,
    ref int IFST,
    ref int ILST,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YFF(
    ref int WANTQ,
    ref int WANTZ,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[,] Q,
    ref int LDQ,
    [In,Out] double[,] Z,
    ref int LDZ,
    ref int IFST,
    ref int ILST,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTGSEN(
    ref int IJOB, ref int WANTQ, ref int WANTZ,
    [In] int[] SEL, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHAR, [Out] double[] ALPHAI, [Out] double[] BETA,
    [In,Out] double[,] Q, ref int LDQ, [In,Out] double[,] Z,
    ref int LDZ, ref int M, ref double PL,
    ref double PR, [Out] double[] DIF, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int LIWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YGF(
    ref int IJOB, ref int WANTQ, ref int WANTZ,
    [In] int[] SEL, ref int N, [In,Out] double[,] A,
    ref int LDA, [In,Out] double[,] B, ref int LDB,
    [Out] double[] ALPHAR, [Out] double[] ALPHAI, [Out] double[] BETA,
    [In,Out] double[,] Q, ref int LDQ, [In,Out] double[,] Z,
    ref int LDZ, ref int M, ref double PL,
    ref double PR, [Out] double[] DIF, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWORK, ref int LIWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTGSYL(
    string TRANS, ref int IJOB, ref int M,
    ref int N, [In] double[,] A, ref int LDA,
    [In] double[,] B, ref int LDB, [In,Out] double[,] C,
    ref int LDC, [In] double[,] D, ref int LDD,
    [In] double[,] E, ref int LDE, [In,Out] double[,] F,
    ref int LDF, ref double SCAL, ref double DIF,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YHF(
    string TRANS, ref int IJOB, ref int M,
    ref int N, [In] double[,] A, ref int LDA,
    [In] double[,] B, ref int LDB, [In,Out] double[,] C,
    ref int LDC, [In] double[,] D, ref int LDD,
    [In] double[,] E, ref int LDE, [In,Out] double[,] F,
    ref int LDF, ref double SCAL, ref double DIF,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTGEVC(
    string SIDE,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] VL,
    ref int LDVL,
    [In,Out] double[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YKF(
    string SIDE,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] VL,
    ref int LDVL,
    [In,Out] double[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] double[] WORK,
    ref int INFO
,
    long SIDELength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DTGSNA(
    string JOB, string HOWMNY, [In] int[] SEL,
    ref int N, [In] double[,] A, ref int LDA,
    [In] double[,] B, ref int LDB, [In] double[,] VL,
    ref int LDVL, [In] double[,] VR, ref int LDVR,
    [Out] double[] S, [Out] double[] DIF, ref int MM,
    ref int M, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YLF(
    string JOB, string HOWMNY, [In] int[] SEL,
    ref int N, [In] double[,] A, ref int LDA,
    [In] double[,] B, ref int LDB, [In] double[,] VL,
    ref int LDVL, [In] double[,] VR, ref int LDVR,
    [Out] double[] S, [Out] double[] DIF, ref int MM,
    ref int M, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTGSJA(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    ref int K, ref int L, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref double TOLA, ref double TOLB, [Out] double[] ALPHA,
    [Out] double[] BETA, [In,Out] Complex[,] U, ref int LDU,
    [In,Out] Complex[,] V, ref int LDV, [In,Out] Complex[,] Q,
    ref int LDQ, [Out] Complex[] WORK, ref int NCYCLE,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YSF(
    string JOBU, string JOBV, string JOBQ,
    ref int M, ref int P, ref int N,
    ref int K, ref int L, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    ref double TOLA, ref double TOLB, [Out] double[] ALPHA,
    [Out] double[] BETA, [In,Out] Complex[,] U, ref int LDU,
    [In,Out] Complex[,] V, ref int LDV, [In,Out] Complex[,] Q,
    ref int LDQ, [Out] Complex[] WORK, ref int NCYCLE,
    ref int INFO
,
    long JOBULength,
    long JOBVLength,
    long JOBQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTGEXC(
    ref int WANTQ,
    ref int WANTZ,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref int IFST,
    ref int ILST,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YTF(
    ref int WANTQ,
    ref int WANTZ,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] Q,
    ref int LDQ,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref int IFST,
    ref int ILST,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTGSEN(
    ref int IJOB, ref int WANTQ, ref int WANTZ,
    [In] int[] SEL, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] Complex[] ALPHA, [Out] Complex[] BETA, [In,Out] Complex[,] Q,
    ref int LDQ, [In,Out] Complex[,] Z, ref int LDZ,
    ref int M, ref double PL, ref double PR,
    [Out] double[] DIF, [Out] Complex[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int LIWORK, ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YUF(
    ref int IJOB, ref int WANTQ, ref int WANTZ,
    [In] int[] SEL, ref int N, [In,Out] Complex[,] A,
    ref int LDA, [In,Out] Complex[,] B, ref int LDB,
    [Out] Complex[] ALPHA, [Out] Complex[] BETA, [In,Out] Complex[,] Q,
    ref int LDQ, [In,Out] Complex[,] Z, ref int LDZ,
    ref int M, ref double PL, ref double PR,
    [Out] double[] DIF, [Out] Complex[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int LIWORK, ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTGSYL(
    string TRANS, ref int IJOB, ref int M,
    ref int N, [In] Complex[,] A, ref int LDA,
    [In] Complex[,] B, ref int LDB, [In,Out] Complex[,] C,
    ref int LDC, [In] Complex[,] D, ref int LDD,
    [In] Complex[,] E, ref int LDE, [In,Out] Complex[,] F,
    ref int LDF, ref double SCAL, ref double DIF,
    [Out] Complex[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YVF(
    string TRANS, ref int IJOB, ref int M,
    ref int N, [In] Complex[,] A, ref int LDA,
    [In] Complex[,] B, ref int LDB, [In,Out] Complex[,] C,
    ref int LDC, [In] Complex[,] D, ref int LDD,
    [In] Complex[,] E, ref int LDE, [In,Out] Complex[,] F,
    ref int LDF, ref double SCAL, ref double DIF,
    [Out] Complex[] WORK, ref int LWORK, [Out] int[] IWORK,
    ref int INFO
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTGEVC(
    string SIDE,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] VL,
    ref int LDVL,
    [In,Out] Complex[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long SIDELength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YXF(
    string SIDE,
    string HOWMNY,
    [In] int[] SEL,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    [In] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[,] VL,
    ref int LDVL,
    [In,Out] Complex[,] VR,
    ref int LDVR,
    ref int MM,
    ref int M,
    [Out] Complex[] WORK,
    [Out] double[] RWORK,
    ref int INFO
,
    long SIDELength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZTGSNA(
    string JOB, string HOWMNY, [In] int[] SEL,
    ref int N, [In] Complex[,] A, ref int LDA,
    [In] Complex[,] B, ref int LDB, [In] Complex[,] VL,
    ref int LDVL, [In] Complex[,] VR, ref int LDVR,
    [Out] double[] S, [Out] double[] DIF, ref int MM,
    ref int M, [Out] Complex[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08YYF(
    string JOB, string HOWMNY, [In] int[] SEL,
    ref int N, [In] Complex[,] A, ref int LDA,
    [In] Complex[,] B, ref int LDB, [In] Complex[,] VL,
    ref int LDVL, [In] Complex[,] VR, ref int LDVR,
    [Out] double[] S, [Out] double[] DIF, ref int MM,
    ref int M, [Out] Complex[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int INFO
,
    long JOBLength,
    long HOWMNYLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGLSE(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[] C,
    [In,Out] double[] D,
    [Out] double[] X,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZAF(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[] C,
    [In,Out] double[] D,
    [Out] double[] X,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGGLM(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[] D,
    [Out] double[] X,
    [Out] double[] Y,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZBF(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] double[,] A,
    ref int LDA,
    [In,Out] double[,] B,
    ref int LDB,
    [In,Out] double[] D,
    [Out] double[] X,
    [Out] double[] Y,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGQRF(
    ref int N,
    ref int M,
    ref int P,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAUA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] TAUB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZEF(
    ref int N,
    ref int M,
    ref int P,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAUA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] TAUB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void DGGRQF(
    ref int M,
    ref int P,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAUA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] TAUB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZFF(
    ref int M,
    ref int P,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    [Out] double[] TAUA,
    [In,Out] double[,] B,
    ref int LDB,
    [Out] double[] TAUB,
    [Out] double[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGLSE(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[] C,
    [In,Out] Complex[] D,
    [Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZNF(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[] C,
    [In,Out] Complex[] D,
    [Out] Complex[] X,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGGLM(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[] D,
    [Out] Complex[] X,
    [Out] Complex[] Y,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZPF(
    ref int M,
    ref int N,
    ref int P,
    [In,Out] Complex[,] A,
    ref int LDA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [In,Out] Complex[] D,
    [Out] Complex[] X,
    [Out] Complex[] Y,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGQRF(
    ref int N,
    ref int M,
    ref int P,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAUA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] TAUB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZSF(
    ref int N,
    ref int M,
    ref int P,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAUA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] TAUB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void ZGGRQF(
    ref int M,
    ref int P,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAUA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] TAUB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F08ZTF(
    ref int M,
    ref int P,
    ref int N,
    [In,Out] Complex[,] A,
    ref int LDA,
    [Out] Complex[] TAUA,
    [In,Out] Complex[,] B,
    ref int LDB,
    [Out] Complex[] TAUB,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int INFO
   );


// chapter f10

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F10CAF(
    string JOBU,
    string JOBVT,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    ref int K,
    ref double RTOL_ABS,
    ref double RTOL_REL,
    [In,Out] int[] STATE,
    [Out] double[] S,
    [Out] double[,] U,
    ref int LDU,
    [Out] double[,] VT,
    ref int LDVT,
    ref int R,
    ref int IFAIL
,
    long JOBULength,
    long JOBVTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F10DAF(
    string TRANS,
    ref int M,
    ref int N,
    [In,Out] double[,] A,
    ref int LDA,
    ref int K,
    [In,Out] int[] STATE,
    ref int IFAIL
,
    long TRANSLength
    );


// chapter f11

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11BDF(
    string METHOD,
    string PRECON,
    string NORM,
    string WEIGHT,
    ref int ITERM,
    ref int N,
    ref int M,
    ref double TOL,
    ref int MAXITN,
    ref double ANORM,
    ref double SIGMAX,
    ref int MONIT,
    ref int LWREQ,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength,
    long NORMLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11BEF(
    ref int IREVCM,
    [In,Out] double[] U,
    [In,Out] double[] V,
    [In] double[] WGT,
    [In,Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11BFF(
    ref int ITN,
    ref double STPLHS,
    ref double STPRHS,
    ref double ANORM,
    ref double SIGMAX,
    [In] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11BRF(
    string METHOD,
    string PRECON,
    string NORM,
    string WEIGHT,
    ref int ITERM,
    ref int N,
    ref int M,
    ref double TOL,
    ref int MAXITN,
    ref double ANORM,
    ref double SIGMAX,
    ref int MONIT,
    ref int LWREQ,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength,
    long NORMLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11BSF(
    ref int IREVCM,
    [In,Out] Complex[] U,
    [In,Out] Complex[] V,
    [In] double[] WGT,
    [In,Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11BTF(
    ref int ITN,
    ref double STPLHS,
    ref double STPRHS,
    ref double ANORM,
    ref double SIGMAX,
    [In,Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DAF(
    ref int N,
    ref int NNZ,
    [In,Out] double[] A,
    ref int LA,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    ref int LFILL,
    ref double DTOL,
    string PSTRAT,
    string MILU,
    [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ,
    [Out] int[] ISTR,
    [Out] int[] IDIAG,
    ref int NNZC,
    ref int NPIVM,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
,
    long PSTRATLength,
    long MILULength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DBF(
    string TRANS,
    ref int N,
    [In] double[] A,
    ref int LA,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ,
    [In] int[] ISTR,
    [In] int[] IDIAG,
    string CHECK,
    [In] double[] Y,
    [Out] double[] X,
    ref int IFAIL
,
    long TRANSLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DCF(
    string METHOD, ref int N, ref int NNZ,
    [In] double[] A, ref int LA, [In] int[] IROW,
    [In] int[] ICOL, [In,Out] int[] IPIVP, [In,Out] int[] IPIVQ,
    [In] int[] ISTR, [In] int[] IDIAG, [In] double[] B,
    ref int M, ref double TOL, ref int MAXITN,
    [In,Out] double[] X, ref double RNORM, ref int ITN,
    [Out] double[] WORK, ref int LWORK, ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DDF(
    string TRANS,
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In] double[] RDIAG,
    ref double OMEGA,
    string CHECK,
    [In] double[] Y,
    [Out] double[] X,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long TRANSLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DEF(
    string METHOD,
    string PRECON,
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    ref double OMEGA,
    [In] double[] B,
    ref int M,
    ref double TOL,
    ref int MAXITN,
    [In,Out] double[] X,
    ref double RNORM,
    ref int ITN,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DFF(
    ref int N, ref int NNZ, [In,Out] double[] A,
    ref int LA, [In,Out] int[] IROW, [In,Out] int[] ICOL,
    ref int NB, [In] int[] ISTB, [In] int[] INDB,
    ref int LINDB, [In] int[] LFILL, [In] double[] DTOL,
    [In,Out] byte[,] PSTRAT, [In,Out] byte[,] MILU, [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ, [Out] int[] ISTR, [Out] int[] IDIAG,
    ref int NNZC, [Out] int[] NPIVM, [Out] int[] IWORK,
    ref int LIWORK, ref int IFAIL
,
    long PSTRATLength,
    long MILULength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DGF(
    string METHOD, ref int N, ref int NNZ,
    [In] double[] A, ref int LA, [In] int[] IROW,
    [In] int[] ICOL, ref int NB, [In] int[] ISTB,
    [In] int[] INDB, ref int LINDB, [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ, [In] int[] ISTR, [In] int[] IDIAG,
    [In] double[] B, ref int M, ref double TOL,
    ref int MAXITN, [In,Out] double[] X, ref double RNORM,
    ref int ITN, [Out] double[] WORK, ref int LWORK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DKF(
    string STORE,
    string TRANS,
    string INIT,
    ref int NITER,
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    string CHECK,
    [In] double[] B,
    [Out] double[] X,
    [In,Out] double[] DIAG,
    [Out] double[] WORK,
    ref int IFAIL
,
    long STORELength,
    long TRANSLength,
    long INITLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DNF(
    ref int N,
    ref int NNZ,
    [In,Out] Complex[] A,
    ref int LA,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    ref int LFILL,
    ref double DTOL,
    string PSTRAT,
    string MILU,
    [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ,
    [Out] int[] ISTR,
    [Out] int[] IDIAG,
    ref int NNZC,
    ref int NPIVM,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
,
    long PSTRATLength,
    long MILULength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DPF(
    string TRANS,
    ref int N,
    [In] Complex[] A,
    ref int LA,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ,
    [In] int[] ISTR,
    [In] int[] IDIAG,
    string CHECK,
    [In] Complex[] Y,
    [Out] Complex[] X,
    ref int IFAIL
,
    long TRANSLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DQF(
    string METHOD, ref int N, ref int NNZ,
    [In] Complex[] A, ref int LA, [In] int[] IROW,
    [In] int[] ICOL, [In,Out] int[] IPIVP, [In,Out] int[] IPIVQ,
    [In] int[] ISTR, [In] int[] IDIAG, [In] Complex[] B,
    ref int M, ref double TOL, ref int MAXITN,
    [In,Out] Complex[] X, ref double RNORM, ref int ITN,
    [Out] Complex[] WORK, ref int LWORK, ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DRF(
    string TRANS,
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In] Complex[] RDIAG,
    ref double OMEGA,
    string CHECK,
    [In] Complex[] Y,
    [Out] Complex[] X,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long TRANSLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DSF(
    string METHOD,
    string PRECON,
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    ref double OMEGA,
    [In] Complex[] B,
    ref int M,
    ref double TOL,
    ref int MAXITN,
    [In,Out] Complex[] X,
    ref double RNORM,
    ref int ITN,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DTF(
    ref int N, ref int NNZ, [In,Out] Complex[] A,
    ref int LA, [In,Out] int[] IROW, [In,Out] int[] ICOL,
    ref int NB, [In] int[] ISTB, [In] int[] INDB,
    ref int LINDB, [In] int[] LFILL, [In] double[] DTOL,
    [In,Out] byte[,] PSTRAT, [In,Out] byte[,] MILU, [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ, [Out] int[] ISTR, [Out] int[] IDIAG,
    ref int NNZC, [Out] int[] NPIVM, [Out] int[] IWORK,
    ref int LIWORK, ref int IFAIL
,
    long PSTRATLength,
    long MILULength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DUF(
    string METHOD, ref int N, ref int NNZ,
    [In] Complex[] A, ref int LA, [In] int[] IROW,
    [In] int[] ICOL, ref int NB, [In] int[] ISTB,
    [In] int[] INDB, ref int LINDB, [In,Out] int[] IPIVP,
    [In,Out] int[] IPIVQ, [In] int[] ISTR, [In] int[] IDIAG,
    [In] Complex[] B, ref int M, ref double TOL,
    ref int MAXITN, [In,Out] Complex[] X, ref double RNORM,
    ref int ITN, [Out] Complex[] WORK, ref int LWORK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11DXF(
    string STORE,
    string TRANS,
    string INIT,
    ref int NITER,
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    string CHECK,
    [In] Complex[] B,
    [Out] Complex[] X,
    [In,Out] Complex[] DIAG,
    [Out] Complex[] WORK,
    ref int IFAIL
,
    long STORELength,
    long TRANSLength,
    long INITLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11GDF(
    string METHOD,
    string PRECON,
    string SIGCMP,
    string NORM,
    string WEIGHT,
    ref int ITERM,
    ref int N,
    ref double TOL,
    ref int MAXITN,
    ref double ANORM,
    ref double SIGMAX,
    ref double SIGTOL,
    ref int MAXITS,
    ref int MONIT,
    ref int LWREQ,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength,
    long SIGCMPLength,
    long NORMLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11GEF(
    ref int IREVCM,
    [In,Out] double[] U,
    [In,Out] double[] V,
    [In] double[] WGT,
    [In,Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11GFF(
    ref int ITN,
    ref double STPLHS,
    ref double STPRHS,
    ref double ANORM,
    ref double SIGMAX,
    ref int ITS,
    ref double SIGERR,
    [In] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11GRF(
    string METHOD,
    string PRECON,
    string SIGCMP,
    string NORM,
    string WEIGHT,
    ref int ITERM,
    ref int N,
    ref double TOL,
    ref int MAXITN,
    ref double ANORM,
    ref double SIGMAX,
    ref double SIGTOL,
    ref int MAXITS,
    ref int MONIT,
    ref int LWREQ,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength,
    long SIGCMPLength,
    long NORMLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11GSF(
    ref int IREVCM,
    [In,Out] Complex[] U,
    [In,Out] Complex[] V,
    [In] double[] WGT,
    [In,Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11GTF(
    ref int ITN,
    ref double STPLHS,
    ref double STPRHS,
    ref double ANORM,
    ref double SIGMAX,
    ref int ITS,
    ref double SIGERR,
    [In] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JAF(
    ref int N,
    ref int NNZ,
    [In,Out] double[] A,
    ref int LA,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    ref int LFILL,
    ref double DTOL,
    string MIC,
    ref double DSCALE,
    string PSTRAT,
    [In,Out] int[] IPIV,
    [Out] int[] ISTR,
    ref int NNZC,
    ref int NPIVM,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
,
    long MICLength,
    long PSTRATLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JBF(
    ref int N,
    [In] double[] A,
    ref int LA,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In,Out] int[] IPIV,
    [In] int[] ISTR,
    string CHECK,
    [In] double[] Y,
    [Out] double[] X,
    ref int IFAIL
,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JCF(
    string METHOD,
    ref int N,
    ref int NNZ,
    [In] double[] A,
    ref int LA,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In,Out] int[] IPIV,
    [In] int[] ISTR,
    [In] double[] B,
    ref double TOL,
    ref int MAXITN,
    [In,Out] double[] X,
    ref double RNORM,
    ref int ITN,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JDF(
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In] double[] RDIAG,
    ref double OMEGA,
    string CHECK,
    [In] double[] Y,
    [Out] double[] X,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JEF(
    string METHOD,
    string PRECON,
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    ref double OMEGA,
    [In] double[] B,
    ref double TOL,
    ref int MAXITN,
    [In,Out] double[] X,
    ref double RNORM,
    ref int ITN,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JNF(
    ref int N,
    ref int NNZ,
    [In,Out] Complex[] A,
    ref int LA,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    ref int LFILL,
    ref double DTOL,
    string MIC,
    ref double DSCALE,
    string PSTRAT,
    [In,Out] int[] IPIV,
    [Out] int[] ISTR,
    ref int NNZC,
    ref int NPIVM,
    [Out] int[] IWORK,
    ref int LIWORK,
    ref int IFAIL
,
    long MICLength,
    long PSTRATLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JPF(
    ref int N,
    [In] Complex[] A,
    ref int LA,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In,Out] int[] IPIV,
    [In] int[] ISTR,
    string CHECK,
    [In] Complex[] Y,
    [Out] Complex[] X,
    ref int IFAIL
,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JQF(
    string METHOD,
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    ref int LA,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In,Out] int[] IPIV,
    [In] int[] ISTR,
    [In] Complex[] B,
    ref double TOL,
    ref int MAXITN,
    [In,Out] Complex[] X,
    ref double RNORM,
    ref int ITN,
    [Out] Complex[] WORK,
    ref int LWORK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JRF(
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    [In] double[] RDIAG,
    ref double OMEGA,
    string CHECK,
    [In] Complex[] Y,
    [Out] Complex[] X,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11JSF(
    string METHOD,
    string PRECON,
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    ref double OMEGA,
    [In] Complex[] B,
    ref double TOL,
    ref int MAXITN,
    [In,Out] Complex[] X,
    ref double RNORM,
    ref int ITN,
    [Out] double[] RDIAG,
    [Out] Complex[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long METHODLength,
    long PRECONLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MDF(
    string SPEC,
    ref int N,
    [In] int[] ICOLZP,
    [In] int[] IROWIX,
    [In,Out] int[] IPRM,
    ref int IFAIL
,
    long SPECLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MEF(
    ref int N,
    [In] int[] IROWIX,
    [In] double[] A,
    [In,Out] int[] IPRM,
    ref double THRESH,
    ref int NZLMX,
    ref int NZLUMX,
    ref int NZUMX,
    [Out] int[] IL,
    [Out] double[] LVAL,
    [Out] int[] IU,
    [Out] double[] UVAL,
    ref int NNZL,
    ref int NNZU,
    ref double FLOP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MFF(
    string TRANS,
    ref int N,
    [In] int[] IPRM,
    [In] int[] IL,
    [In] double[] LVAL,
    [In] int[] IU,
    [In] double[] UVAL,
    ref int NRHS,
    [In,Out] double[,] B,
    ref int LDB,
    ref int IFAIL
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MGF(
    string NORM,
    ref int N,
    [In] int[] IL,
    [In] double[] LVAL,
    [In] int[] IU,
    [In] double[] UVAL,
    ref double ANORM,
    ref double RCOND,
    ref int IFAIL
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MHF(
    string TRANS,
    ref int N,
    [In] int[] ICOLZP,
    [In] int[] IROWIX,
    [In] double[] A,
    [In] int[] IPRM,
    [In] int[] IL,
    [In] double[] LVAL,
    [In] int[] IU,
    [In] double[] UVAL,
    ref int NRHS,
    [In] double[,] B,
    ref int LDB,
    [In,Out] double[,] X,
    ref int LDX,
    [Out] double[] FERR,
    [Out] double[] BERR,
    ref int IFAIL
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MKF(
    string TRANS,
    ref int N,
    ref int M,
    ref double ALPHA,
    [In] int[] ICOLZP,
    [In] int[] IROWIX,
    [In] double[] A,
    [In] double[,] B,
    ref int LDB,
    ref double BETA,
    [In,Out] double[,] C,
    ref int LDC,
    ref int IFAIL
,
    long TRANSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MLF(
    string NORM,
    ref double ANORM,
    ref int N,
    [In] int[] ICOLZP,
    [In] int[] IROWIX,
    [In] double[] A,
    ref int IFAIL
,
    long NORMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11MMF(
    ref int N,
    [In] int[] ICOLZP,
    [In] double[] A,
    [In] int[] IPRM,
    [In] int[] IL,
    [In] double[] LVAL,
    [In] int[] IU,
    [In] double[] UVAL,
    ref double RPG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11XAF(
    string TRANS,
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    string CHECK,
    [In] double[] X,
    [Out] double[] Y,
    ref int IFAIL
,
    long TRANSLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11XEF(
    ref int N,
    ref int NNZ,
    [In] double[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    string CHECK,
    [In] double[] X,
    [Out] double[] Y,
    ref int IFAIL
,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11XNF(
    string TRANS,
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    string CHECK,
    [In] Complex[] X,
    [Out] Complex[] Y,
    ref int IFAIL
,
    long TRANSLength,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11XSF(
    ref int N,
    ref int NNZ,
    [In] Complex[] A,
    [In] int[] IROW,
    [In] int[] ICOL,
    string CHECK,
    [In] Complex[] X,
    [Out] Complex[] Y,
    ref int IFAIL
,
    long CHECKLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11YEF(
    ref int N,
    ref int NNZ,
    [In] int[] ICOLZP,
    [In] int[] IROWIX,
    [In] int[] LOPTS,
    [In] int[] MASK,
    [Out] int[] PERM,
    [Out] int[] INFO,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11ZAF(
    ref int N,
    ref int NNZ,
    [In,Out] double[] A,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    string DUP,
    string ZER,
    [Out] int[] ISTR,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long DUPLength,
    long ZERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11ZBF(
    ref int N,
    ref int NNZ,
    [In,Out] double[] A,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    string DUP,
    string ZER,
    [Out] int[] ISTR,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long DUPLength,
    long ZERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11ZCF(
    ref int M,
    ref int N,
    ref int NNZ,
    [In,Out] double[] A,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    [In,Out] int[] ISTC,
    ref int STORE,
    string DUP,
    string ZER,
    ref int IFAIL
,
    long DUPLength,
    long ZERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11ZNF(
    ref int N,
    ref int NNZ,
    [In,Out] Complex[] A,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    string DUP,
    string ZER,
    [Out] int[] ISTR,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long DUPLength,
    long ZERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F11ZPF(
    ref int N,
    ref int NNZ,
    [In,Out] Complex[] A,
    [In,Out] int[] IROW,
    [In,Out] int[] ICOL,
    string DUP,
    string ZER,
    [Out] int[] ISTR,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long DUPLength,
    long ZERLength
    );


// chapter f12

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12AAF(
    ref int N,
    ref int NEV,
    ref int NCV,
    [Out] int[] ICOMM,
    ref int LICOMM,
    [Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12ABF(
    ref int IREVCM,
    [In,Out] double[] RESID,
    [In,Out] double[,] V,
    ref int LDV,
    [In,Out] double[] X,
    [In,Out] double[] MX,
    ref int NSHIFT,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12ACF(
    ref int NCONV,
    [Out] double[] DR,
    [Out] double[] DI,
    [Out] double[,] Z,
    ref int LDZ,
    ref double SIGMAR,
    ref double SIGMAI,
    [In] double[] RESID,
    [In,Out] double[,] V,
    ref int LDV,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12ADF(
    string STR,
    [In,Out] int[] ICOMM,
    [In,Out] double[] COMM,
    ref int IFAIL
,
    long STRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12AEF(
    ref int NITER,
    ref int NCONV,
    [Out] double[] RITZR,
    [Out] double[] RITZI,
    [Out] double[] RZEST,
    [In] int[] ICOMM,
    [In] double[] COMM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12AFF(
    ref int N,
    ref int NEV,
    ref int NCV,
    [Out] int[] ICOMM,
    ref int LICOMM,
    [Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12AGF(
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] MB,
    ref int LDMB,
    ref double SIGMAR,
    ref double SIGMAI,
    ref int NCONV,
    [Out] double[] DR,
    [Out] double[] DI,
    [Out] double[,] Z,
    ref int LDZ,
    [In,Out] double[] RESID,
    [Out] double[,] V,
    ref int LDV,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12ANF(
    ref int N,
    ref int NEV,
    ref int NCV,
    [Out] int[] ICOMM,
    ref int LICOMM,
    [Out] Complex[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12APF(
    ref int IREVCM,
    [In,Out] Complex[] RESID,
    [In,Out] Complex[,] V,
    ref int LDV,
    [In,Out] Complex[] X,
    [In,Out] Complex[] MX,
    ref int NSHIFT,
    [In,Out] Complex[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12AQF(
    ref int NCONV,
    [Out] Complex[] D,
    [Out] Complex[,] Z,
    ref int LDZ,
    ref Complex SIGMA,
    [In] Complex[] RESID,
    [In,Out] Complex[,] V,
    ref int LDV,
    [In,Out] Complex[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12ARF(
    string STR,
    [In,Out] int[] ICOMM,
    [In,Out] Complex[] COMM,
    ref int IFAIL
,
    long STRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12ASF(
    ref int NITER,
    ref int NCONV,
    [Out] Complex[] RITZ,
    [Out] Complex[] RZEST,
    [In] int[] ICOMM,
    [In] Complex[] COMM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12ATF(
    ref int N,
    ref int NEV,
    ref int NCV,
    [Out] int[] ICOMM,
    ref int LICOMM,
    [Out] Complex[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12AUF(
    ref int KL,
    ref int KU,
    [In] Complex[,] AB,
    ref int LDAB,
    [In] Complex[,] MB,
    ref int LDMB,
    ref Complex SIGMA,
    ref int NCONV,
    [Out] Complex[] D,
    [Out] Complex[,] Z,
    ref int LDZ,
    [In,Out] Complex[] RESID,
    [Out] Complex[,] V,
    ref int LDV,
    [In,Out] Complex[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12FAF(
    ref int N,
    ref int NEV,
    ref int NCV,
    [Out] int[] ICOMM,
    ref int LICOMM,
    [Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12FBF(
    ref int IREVCM,
    [In,Out] double[] RESID,
    [In,Out] double[,] V,
    ref int LDV,
    [In,Out] double[] X,
    [In,Out] double[] MX,
    ref int NSHIFT,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12FCF(
    ref int NCONV,
    [Out] double[] D,
    [Out] double[,] Z,
    ref int LDZ,
    ref double SIGMA,
    [In] double[] RESID,
    [In,Out] double[,] V,
    ref int LDV,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12FDF(
    string STR,
    [In,Out] int[] ICOMM,
    [In,Out] double[] COMM,
    ref int IFAIL
,
    long STRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12FEF(
    ref int NITER,
    ref int NCONV,
    [Out] double[] RITZ,
    [Out] double[] RZEST,
    [In] int[] ICOMM,
    [In] double[] COMM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12FFF(
    ref int N,
    ref int NEV,
    ref int NCV,
    [Out] int[] ICOMM,
    ref int LICOMM,
    [Out] double[] COMM,
    ref int LCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12FGF(
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB,
    [In] double[,] MB,
    ref int LDMB,
    ref double SIGMA,
    ref int NCONV,
    [Out] double[] D,
    [Out] double[,] Z,
    ref int LDZ,
    [In,Out] double[] RESID,
    [Out] double[,] V,
    ref int LDV,
    [In,Out] double[] COMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JAF(
    ref IntPtr HANDLE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JBF(
    ref IntPtr HANDLE,
    string STR,
    ref int IFAIL
,
    long STRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JEF(
    ref IntPtr HANDLE,
    ref double EMIN,
    ref double EMAX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JFF(
    ref IntPtr HANDLE,
    ref Complex EMID,
    ref double R,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JGF(
    ref IntPtr HANDLE,
    ref int CCN,
    [In] int[] NEDGE,
    [In] int[] TEDGE,
    [In] Complex[] ZEDGE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JJF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref Complex ZE,
    ref int N,
    [In,Out] double[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref int M0,
    ref int NCONV,
    [In,Out] double[] D,
    [In,Out] double[,] Z,
    ref int LDZ,
    ref double EPS,
    ref int ITER,
    [In,Out] double[] RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JKF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref Complex ZE,
    ref int N,
    [In,Out] double[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref int M0,
    ref int NCONV,
    [In,Out] Complex[] D,
    [In,Out] double[,] Z,
    ref int LDZ,
    ref double EPS,
    ref int ITER,
    [In,Out] double[] RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JRF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref Complex ZE,
    ref int N,
    [In,Out] Complex[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref int M0,
    ref int NCONV,
    [In,Out] double[] D,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref double EPS,
    ref int ITER,
    [In,Out] double[] RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JSF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref Complex ZE,
    ref int N,
    [In,Out] Complex[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref int M0,
    ref int NCONV,
    [In,Out] Complex[] D,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref double EPS,
    ref int ITER,
    [In,Out] double[] RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JTF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref Complex ZE,
    ref int N,
    [In,Out] Complex[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref int M0,
    ref int NCONV,
    [In,Out] Complex[] D,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref double EPS,
    ref int ITER,
    [In,Out] double[] RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JUF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref int DEG,
    ref Complex ZE,
    ref int N,
    [In,Out] Complex[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref int K,
    ref int M0,
    ref int NCONV,
    [In,Out] Complex[] D,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref double EPS,
    ref int ITER,
    [In,Out] double[] RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JVF(
    ref IntPtr HANDLE,
    ref int IREVCM,
    ref int DEG,
    ref Complex ZE,
    ref int N,
    [In,Out] Complex[,] X,
    ref int LDX,
    [In,Out] Complex[,] Y,
    ref int LDY,
    ref int K,
    ref int M0,
    ref int NCONV,
    [In,Out] Complex[] D,
    [In,Out] Complex[,] Z,
    ref int LDZ,
    ref double EPS,
    ref int ITER,
    [In,Out] double[] RESID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F12JZF(
    ref IntPtr HANDLE,
    ref int IFAIL
   );


// chapter f16

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int F16DLF(
    ref int N,
    [In] int[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16DNF(
    ref int N,
    [In] int[] X,
    ref int INCX,
    ref int K,
    ref int I
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16DPF(
    ref int N,
    [In] int[] X,
    ref int INCX,
    ref int K,
    ref int I
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16DQF(
    ref int N,
    [In] int[] X,
    ref int INCX,
    ref int K,
    ref int I
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16DRF(
    ref int N,
    [In] int[] X,
    ref int INCX,
    ref int K,
    ref int I
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_DDOT(
    ref int CONJ,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In] double[] Y,
    ref int INCY,
    ref double R
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16EAF(
    ref int CONJ,
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In] double[] Y,
    ref int INCY,
    ref double R
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_DAXPBY(
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16ECF(
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In,Out] double[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_DWAXPBY(
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[] W,
    ref int INCW
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16EHF(
    ref int N,
    ref double ALPHA,
    [In] double[] X,
    ref int INCX,
    ref double BETA,
    [In] double[] Y,
    ref int INCY,
    [In,Out] double[] W,
    ref int INCW
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double BLAS_DSUM(
    ref int N,
    [In] double[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F16ELF(
    ref int N,
    [In] double[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_ZAXPBY(
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16GCF(
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In,Out] Complex[] Y,
    ref int INCY
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_ZWAXPBY(
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[] W,
    ref int INCW
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16GHF(
    ref int N,
    ref Complex ALPHA,
    [In] Complex[] X,
    ref int INCX,
    ref Complex BETA,
    [In] Complex[] Y,
    ref int INCY,
    [In,Out] Complex[] W,
    ref int INCW
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex BLAS_ZSUM(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex F16GLF(
    ref int N,
    [In] Complex[] X,
    ref int INCX
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_DMAX_VAL(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16JNF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_DMIN_VAL(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16JPF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_DAMAX_VAL(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16JQF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_DAMIN_VAL(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16JRF(
    ref int N,
    [In] double[] X,
    ref int INCX,
    ref int K,
    ref double R
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_ZAMAX_VAL(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    ref int K,
    ref double R
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16JSF(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    ref int K,
    ref double R
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void BLAS_ZAMIN_VAL(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    ref int K,
    ref double R
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void F16JTF(
    ref int N,
    [In] Complex[] X,
    ref int INCX,
    ref int K,
    ref double R
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F16RBF(
    ref int INORM,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] AB,
    ref int LDAB
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double F16UBF(
    ref int INORM,
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] AB,
    ref int LDAB
   );


// chapter g01

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ABF(
    ref int N,
    [In] double[] X1,
    [In] double[] X2,
    ref int IWT,
    [In,Out] double[] WT,
    [Out] double[] RES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ADF(
    ref int K,
    [In] double[] X,
    [In] int[] IFREQ,
    ref double XMEAN,
    ref double S2,
    ref double S3,
    ref double S4,
    ref int N,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01AEF(
    ref int N,
    ref int K,
    [In] double[] X,
    ref int ICLASS,
    [In,Out] double[] CB,
    [Out] int[] IFREQ,
    ref double XMIN,
    ref double XMAX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01AFF(
    ref int LDNOB,
    ref int LDPRED,
    ref int M,
    ref int N,
    [In,Out] int[,] NOBS,
    ref int NUM,
    [Out] double[,] PRED,
    ref double CHIS,
    [Out] double[] P,
    ref int NPOS,
    ref int NDF,
    ref int M1,
    ref int N1,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ALF(
    ref int N,
    [In] double[] X,
    [Out] int[] IWRK,
    [Out] double[] RES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01AMF(
    ref int N,
    [In,Out] double[] RV,
    ref int NQ,
    [In] double[] Q,
    [Out] double[] QV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ANF(
    ref int IND,
    ref int N,
    [In] double[] RV,
    ref int NB,
    ref double EPS,
    ref int NP,
    [In] double[] Q,
    [Out] double[] QV,
    ref int NQ,
    [In,Out] double[] RCOMM,
    ref int LRCOMM,
    [In,Out] int[] ICOMM,
    ref int LICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01APF(
    ref int IND,
    [In] double[] RV,
    ref int NB,
    ref double EPS,
    ref int NP,
    [In] double[] Q,
    [Out] double[] QV,
    ref int NQ,
    [In,Out] double[] RCOMM,
    ref int LRCOMM,
    [In,Out] int[] ICOMM,
    ref int LICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ARF(
    string RANGE,
    string PRT,
    ref int N,
    [In] double[] Y,
    ref int NSTEPX,
    ref int NSTEPY,
    ref double UNIT,
    [In,Out] byte[,,] PLOT,
    ref int LDPLOT,
    ref int LINES,
    [Out] double[] SORTY,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long RANGELength,
    long PRTLength,
    long PLOTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ASF(
    string PRT,
    ref int M,
    [In] int[] N,
    [In] double[,] X,
    ref int LDX,
    ref int NSTEPX,
    ref int NSTEPY,
    [In,Out] byte[,,] PLOT,
    ref int LDPLOT,
    [Out] double[] FIVEPT,
    [Out] int[] IWORK,
    ref int IFAIL
,
    long PRTLength,
    long PLOTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ATF(
    ref int NB,
    [In] double[] X,
    ref int IWT,
    [In] double[] WT,
    ref int PN,
    ref double XMEAN,
    ref double XSD,
    ref double XSKEW,
    ref double XKURT,
    ref double XMIN,
    ref double XMAX,
    [In,Out] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01AUF(
    ref int B,
    [In] double[,] MRCOMM,
    ref int PN,
    ref double XMEAN,
    ref double XSD,
    ref double XSKEW,
    ref double XKURT,
    ref double XMIN,
    ref double XMAX,
    [Out] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01BJF(
    ref int N,
    ref double P,
    ref int K,
    ref double PLEK,
    ref double PGTK,
    ref double PEQK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01BKF(
    ref double RLAMDA,
    ref int K,
    ref double PLEK,
    ref double PGTK,
    ref double PEQK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01BLF(
    ref int N,
    ref int L,
    ref int M,
    ref int K,
    ref double PLEK,
    ref double PGTK,
    ref double PEQK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01DAF(
    ref int N,
    [Out] double[] PP,
    ref double ETOL,
    ref double ERREST,
    [Out] double[] WORK,
    ref int IW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01DBF(
    ref int N,
    [Out] double[] PP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01DCF(
    ref int N,
    ref double EXP1,
    ref double EXP2,
    ref double SUMSSQ,
    [Out] double[] VEC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01DDF(
    [In] double[] X,
    ref int N,
    ref int CALWTS,
    [In,Out] double[] A,
    ref double W,
    ref double PW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01DHF(
    string SCORES,
    string TIES,
    ref int N,
    [In] double[] X,
    [Out] double[] R,
    [Out] int[] IWRK,
    ref int IFAIL
,
    long SCORESLength,
    long TIESLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EAF(
    string TAIL,
    ref double X,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EBF(
    string TAIL,
    ref double T,
    ref double DF,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01ECF(
    string TAIL,
    ref double X,
    ref double DF,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EDF(
    string TAIL,
    ref double F,
    ref double DF1,
    ref double DF2,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01EEF(
    ref double X,
    ref double A,
    ref double B,
    ref double TOL,
    ref double P,
    ref double Q,
    ref double PDF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EFF(
    string TAIL,
    ref double G,
    ref double A,
    ref double B,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EMF(
    ref double Q,
    ref double V,
    ref int IR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01EPF(
    ref int N,
    ref int IP,
    ref double D,
    ref double PDL,
    ref double PDU,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01ERF(
    ref double T,
    ref double VK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01ETF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EUF(
    ref double X,
    [In] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EWF(
    ref int METHOD,
    ref int TYP,
    ref int N,
    ref double TS,
    ref int NSAMP,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EYF(
    ref int N,
    ref double D,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01EZF(
    ref int N1,
    ref int N2,
    ref double D,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FAF(
    string TAIL,
    ref double P,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FBF(
    string TAIL,
    ref double P,
    ref double DF,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FCF(
    ref double P,
    ref double DF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FDF(
    ref double P,
    ref double DF1,
    ref double DF2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FEF(
    ref double P,
    ref double A,
    ref double B,
    ref double TOL,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FFF(
    ref double P,
    ref double A,
    ref double B,
    ref double TOL,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FMF(
    ref double P,
    ref double V,
    ref int IR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01FTF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01GBF(
    ref double T,
    ref double DF,
    ref double DELTA,
    ref double TOL,
    ref int MAXIT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01GCF(
    ref double X,
    ref double DF,
    ref double RLAMDA,
    ref double TOL,
    ref int MAXIT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01GDF(
    ref double F,
    ref double DF1,
    ref double DF2,
    ref double RLAMDA,
    ref double TOL,
    ref int MAXIT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01GEF(
    ref double X,
    ref double A,
    ref double B,
    ref double RLAMDA,
    ref double TOL,
    ref int MAXIT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01HAF(
    ref double X,
    ref double Y,
    ref double RHO,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01HBF(
    string TAIL,
    ref int N,
    [In] double[] A,
    [In] double[] B,
    [In] double[] XMU,
    [In] double[,] SIG,
    ref int LDSIG,
    ref double TOL,
    [Out] double[] WK,
    ref int LWK,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01HCF(
    string TAIL,
    [In] double[] A,
    [In] double[] B,
    ref int DF,
    ref double RHO,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01HDF(
    ref int N,
    [In,Out] byte[,] TAIL,
    [In] double[] A,
    [In] double[] B,
    ref double NU,
    [In] double[] DELTA,
    ref int ISCOV,
    [In,Out] double[,] RC,
    ref int LDRC,
    ref double EPSABS,
    ref double EPSREL,
    ref int NUMSUB,
    ref int NSAMPL,
    ref int FMAX,
    ref double ERREST,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01JCF(
    [In] double[] A,
    [In] int[] MULT,
    [In] double[] RLAMDA,
    ref int N,
    ref double C,
    ref double P,
    ref double PDF,
    ref double TOL,
    ref int MAXIT,
    [Out] double[] WRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01JDF(
    string METHOD,
    ref int N,
    [In] double[] RLAM,
    ref double D,
    ref double C,
    ref double PROB,
    [Out] double[] WORK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01KAF(
    ref double X,
    ref double XMEAN,
    ref double XSTD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01KFF(
    ref double X,
    ref double A,
    ref double B,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01KKF(
    ref int ILOG,
    ref int LX,
    [In] double[] X,
    ref int LA,
    [In] double[] A,
    ref int LB,
    [In] double[] B,
    [Out] double[] PDF,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01KQF(
    ref int ILOG,
    ref int LX,
    [In] double[] X,
    ref int LXMU,
    [In] double[] XMU,
    ref int LXSTD,
    [In] double[] XSTD,
    [Out] double[] PDF,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01LBF(
    ref int ILOG,
    ref int K,
    ref int N,
    [In] double[,] X,
    ref int LDX,
    [In] double[] XMU,
    ref int IULD,
    [In] double[,] SIG,
    ref int LDSIG,
    [Out] double[] PDF,
    ref int RANK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01MBF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01MTF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01MUF(
    ref double X,
    [In] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01NAF(
    string MOM,
    string MEAN,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    [In] double[] EMU,
    [In] double[,] SIGMA,
    ref int LDSIG,
    ref int L,
    [Out] double[] RKUM,
    [Out] double[] RMOM,
    [Out] double[] WK,
    ref int IFAIL
,
    long MOMLength,
    long MEANLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01NBF(
    string CAS, string MEAN, ref int N,
    [In] double[,] A, ref int LDA, [In] double[,] B,
    ref int LDB, [In] double[,] C, ref int LDC,
    [In] double[] ELA, [In] double[] EMU, [In] double[,] SIGMA,
    ref int LDSIG, ref int L1, ref int L2,
    ref int LMAX, [Out] double[] RMOM, ref double ABSERR,
    ref double EPS, [Out] double[] WK, ref int IFAIL
,
    long CASLength,
    long MEANLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01PTF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01QTF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G01RTF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SAF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LX,
    [In] double[] X,
    ref int LXMU,
    [In] double[] XMU,
    ref int LXSTD,
    [In] double[] XSTD,
    [Out] double[] P,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SBF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LT,
    [In] double[] T,
    ref int LDF,
    [In] double[] DF,
    [Out] double[] P,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SCF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LX,
    [In] double[] X,
    ref int LDF,
    [In] double[] DF,
    [Out] double[] P,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SDF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LF,
    [In] double[] F,
    ref int LDF1,
    [In] double[] DF1,
    ref int LDF2,
    [In] double[] DF2,
    [Out] double[] P,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SEF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LBETA,
    [In] double[] BETA,
    ref int LA,
    [In] double[] A,
    ref int LB,
    [In] double[] B,
    [Out] double[] P,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SFF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LG,
    [In] double[] G,
    ref int LA,
    [In] double[] A,
    ref int LB,
    [In] double[] B,
    [Out] double[] P,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SJF(
    ref int LN,
    [In] int[] N,
    ref int LP,
    [In] double[] P,
    ref int LK,
    [In] int[] K,
    [Out] double[] PLEK,
    [Out] double[] PGTK,
    [Out] double[] PEQK,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SKF(
    ref int LL,
    [In] double[] L,
    ref int LK,
    [In] int[] K,
    [Out] double[] PLEK,
    [Out] double[] PGTK,
    [Out] double[] PEQK,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01SLF(
    ref int LN,
    [In] int[] N,
    ref int LL,
    [In] int[] L,
    ref int LM,
    [In] int[] M,
    ref int LK,
    [In] int[] K,
    [Out] double[] PLEK,
    [Out] double[] PGTK,
    [Out] double[] PEQK,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01TAF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LP,
    [In] double[] P,
    ref int LXMU,
    [In] double[] XMU,
    ref int LXSTD,
    [In] double[] XSTD,
    [Out] double[] X,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01TBF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LP,
    [In] double[] P,
    ref int LDF,
    [In] double[] DF,
    [Out] double[] T,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01TCF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LP,
    [In] double[] P,
    ref int LDF,
    [In] double[] DF,
    [Out] double[] X,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01TDF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LP,
    [In] double[] P,
    ref int LDF1,
    [In] double[] DF1,
    ref int LDF2,
    [In] double[] DF2,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01TEF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LP,
    [In] double[] P,
    ref int LA,
    [In] double[] A,
    ref int LB,
    [In] double[] B,
    ref double TOL,
    [Out] double[] BETA,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01TFF(
    ref int LTAIL,
    [In,Out] byte[,] TAIL,
    ref int LP,
    [In] double[] P,
    ref int LA,
    [In] double[] A,
    ref int LB,
    [In] double[] B,
    ref double TOL,
    [Out] double[] G,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01WAF(
    ref int M,
    ref int NB,
    [In] double[] X,
    ref int IWT,
    [In] double[] WT,
    ref int PN,
    [Out] double[] RMEAN,
    [Out] double[] RSD,
    ref int LRSD,
    [In,Out] double[] RCOMM,
    ref int LRCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G01ZUF(
    ref double RKAPPA,
    ref double BETA2,
    ref int MODE,
    ref double XL,
    ref double XU,
    [Out] double[] RCOMM,
    ref int IFAIL
   );


// chapter g02

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02AAF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    ref double ERRTOL,
    ref int MAXITS,
    ref int MAXIT,
    [Out] double[,] X,
    ref int LDX,
    ref int ITER,
    ref int FEVAL,
    ref double NRMGRD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02ABF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    string OPT,
    ref double ALPHA,
    [In,Out] double[] W,
    ref double ERRTOL,
    ref int MAXITS,
    ref int MAXIT,
    [Out] double[,] X,
    ref int LDX,
    ref int ITER,
    ref int FEVAL,
    ref double NRMGRD,
    ref int IFAIL
,
    long OPTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02AEF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    ref int K,
    ref double ERRTOL,
    ref int MAXIT,
    [Out] double[,] X,
    ref int LDX,
    ref int ITER,
    ref int FEVAL,
    ref double NRMPGD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02AJF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    ref double ALPHA,
    [In,Out] double[,] H,
    ref int LDH,
    ref double ERRTOL,
    ref int MAXIT,
    [Out] double[,] X,
    ref int LDX,
    ref int ITER,
    ref double NORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02AKF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    ref int RANK,
    ref double ERRTOL,
    ref double RANKTOL,
    ref int MAXITS,
    ref int MAXIT,
    [Out] double[,] X,
    ref int LDX,
    ref double F,
    ref double RANKERR,
    ref int NSUB,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02ANF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    ref int K,
    ref double ERRTOL,
    ref double EIGTOL,
    [Out] double[,] X,
    ref int LDX,
    ref double ALPHA,
    ref int ITER,
    ref double EIGMIN,
    ref double NORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02APF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    ref double THETA,
    [In,Out] double[,] H,
    ref int LDH,
    ref double ERRTOL,
    ref double EIGTOL,
    [Out] double[,] X,
    ref int LDX,
    ref double ALPHA,
    ref int ITER,
    ref double EIGMIN,
    ref double NORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02ASF(
    [In,Out] double[,] G,
    ref int LDG,
    ref int N,
    ref double ALPHA,
    [In] int[,] H,
    ref int LDH,
    ref double ERRTOL,
    ref int MAXIT,
    ref int M,
    [Out] double[,] X,
    ref int LDX,
    ref int ITS,
    ref double FNORM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BAF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSP,
    ref int LDSSP,
    [Out] double[,] R,
    ref int LDR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BBF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In,Out] int[] MISS,
    [In,Out] double[] XMISS,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSP,
    ref int LDSSP,
    [Out] double[,] R,
    ref int LDR,
    ref int NCASES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BCF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] MISS,
    [In] double[] XMISS,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSP,
    ref int LDSSP,
    [Out] double[,] R,
    ref int LDR,
    ref int NCASES,
    [Out] double[,] CNT,
    ref int LDCNT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BDF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSPZ,
    ref int LDSSPZ,
    [Out] double[,] RZ,
    ref int LDRZ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BEF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In,Out] int[] MISS,
    [In,Out] double[] XMISS,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSPZ,
    ref int LDSSPZ,
    [Out] double[,] RZ,
    ref int LDRZ,
    ref int NCASES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BFF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] MISS,
    [In] double[] XMISS,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSPZ,
    ref int LDSSPZ,
    [Out] double[,] RZ,
    ref int LDRZ,
    ref int NCASES,
    [Out] double[,] CNT,
    ref int LDCNT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BGF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    ref int NVARS,
    [In] int[] KVAR,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSP,
    ref int LDSSP,
    [Out] double[,] R,
    ref int LDR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BHF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In,Out] int[] MISS,
    [In,Out] double[] XMISS,
    ref int MISTYP,
    ref int NVARS,
    [In] int[] KVAR,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSP,
    ref int LDSSP,
    [Out] double[,] R,
    ref int LDR,
    ref int NCASES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BJF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] MISS,
    [In] double[] XMISS,
    ref int NVARS,
    [In] int[] KVAR,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSP,
    ref int LDSSP,
    [Out] double[,] R,
    ref int LDR,
    ref int NCASES,
    [Out] double[,] CNT,
    ref int LDCNT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BKF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    ref int NVARS,
    [In] int[] KVAR,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSPZ,
    ref int LDSSPZ,
    [Out] double[,] RZ,
    ref int LDRZ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BLF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In,Out] int[] MISS,
    [In,Out] double[] XMISS,
    ref int MISTYP,
    ref int NVARS,
    [In] int[] KVAR,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSPZ,
    ref int LDSSPZ,
    [Out] double[,] RZ,
    ref int LDRZ,
    ref int NCASES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BMF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] MISS,
    [In] double[] XMISS,
    ref int NVARS,
    [In] int[] KVAR,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] SSPZ,
    ref int LDSSPZ,
    [Out] double[,] RZ,
    ref int LDRZ,
    ref int NCASES,
    [Out] double[,] CNT,
    ref int LDCNT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BNF(
    ref int N,
    ref int M,
    [In,Out] double[,] X,
    ref int LDX,
    ref int ITYPE,
    [Out] double[,] RR,
    ref int LDRR,
    [Out] int[] KWORKA,
    [Out] int[] KWORKB,
    [Out] double[] WORK1,
    [Out] double[] WORK2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BPF(
    ref int N,
    ref int M,
    [In,Out] double[,] X,
    ref int LDX,
    [In,Out] int[] MISS,
    [In,Out] double[] XMISS,
    ref int ITYPE,
    [Out] double[,] RR,
    ref int LDRR,
    ref int NCASES,
    [Out] int[] INCASE,
    [Out] int[] KWORKA,
    [Out] int[] KWORKB,
    [Out] int[] KWORKC,
    [Out] double[] WORK1,
    [Out] double[] WORK2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BQF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    ref int ITYPE,
    [Out] double[,] RR,
    ref int LDRR,
    [Out] int[] KWORKA,
    [Out] int[] KWORKB,
    [Out] double[] WORK1,
    [Out] double[] WORK2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BRF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In,Out] int[] MISS,
    [In,Out] double[] XMISS,
    ref int ITYPE,
    [Out] double[,] RR,
    ref int LDRR,
    ref int NCASES,
    [Out] int[] INCASE,
    [Out] int[] KWORKA,
    [Out] int[] KWORKB,
    [Out] int[] KWORKC,
    [Out] double[] WORK1,
    [Out] double[] WORK2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BSF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] MISS,
    [In] double[] XMISS,
    ref int ITYPE,
    [Out] double[,] RR,
    ref int LDRR,
    ref int NCASES,
    [Out] double[,] CNT,
    ref int LDCNT,
    [Out] int[] KWORKA,
    [Out] int[] KWORKB,
    [Out] int[] KWORKC,
    [Out] int[] KWORKD,
    [Out] double[] WORK1,
    [Out] double[] WORK2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BTF(
    string MEAN,
    ref int M,
    ref double WT,
    [In] double[] X,
    ref int INCX,
    ref double SW,
    [In,Out] double[] XBAR,
    [In,Out] double[] C,
    ref int IFAIL
,
    long MEANLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BUF(
    string MEAN,
    string WEIGHT,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] double[] WT,
    ref double SW,
    [Out] double[] WMEAN,
    [Out] double[] C,
    ref int IFAIL
,
    long MEANLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BWF(
    ref int M,
    [In,Out] double[] R,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BXF(
    string WEIGHT,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] double[] WT,
    [Out] double[] XBAR,
    [Out] double[] STD,
    [Out] double[,] V,
    ref int LDV,
    [Out] double[,] R,
    ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BYF(
    ref int M,
    ref int NY,
    ref int NX,
    [In] int[] ISZ,
    [In] double[,] R,
    ref int LDR,
    [Out] double[,] P,
    ref int LDP,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02BZF(
    string MEAN,
    ref int M,
    ref double XSW,
    [In,Out] double[] XMEAN,
    [In,Out] double[] XC,
    ref double YSW,
    [In] double[] YMEAN,
    [In] double[] YC,
    ref int IFAIL
,
    long MEANLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CAF(
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    [Out] double[] RESULT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CBF(
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    [Out] double[] RESULT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CCF(
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    ref double XMISS,
    ref double YMISS,
    [Out] double[] RESULT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CDF(
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    ref double XMISS,
    ref double YMISS,
    [Out] double[] RESULT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CEF(
    ref int N,
    [In] double[] XBAR,
    [In] double[] STD,
    [In] double[,] SSP,
    ref int LDSSP,
    [In] double[,] R,
    ref int LDR,
    ref int M,
    [In] int[] KORDER,
    [Out] double[] XBAR2,
    [Out] double[] STD2,
    [Out] double[,] SSP2,
    ref int LDSSP2,
    [Out] double[,] R2,
    ref int LDR2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CFF(
    ref int N,
    [In] int[] KORDER,
    [In,Out] double[] XBAR,
    [In,Out] double[] STD,
    [In,Out] double[,] SSP,
    ref int LDSSP,
    [In,Out] double[,] R,
    ref int LDR,
    [Out] int[] KWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CGF(
    ref int N,
    ref int K1,
    ref int K,
    [In] double[] XBAR,
    [In] double[,] SSP,
    ref int LDSSP,
    [In,Out] double[,] R,
    ref int LDR,
    [Out] double[] RESULT,
    [Out] double[,] COEF,
    ref int LDCOEF,
    [Out] double[] CON,
    [Out] double[,] RINV,
    ref int LDRINV,
    [Out] double[,] C,
    ref int LDC,
    [Out] double[,] WKZ,
    ref int LDWKZ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02CHF(
    ref int N,
    ref int K1,
    ref int K,
    [In] double[,] SSPZ,
    ref int LDSSPZ,
    [In,Out] double[,] RZ,
    ref int LDRZ,
    [Out] double[] RESULT,
    [Out] double[,] COEF,
    ref int LDCOEF,
    [Out] double[,] RZNV,
    ref int LDRZNV,
    [Out] double[,] CZ,
    ref int LDCZ,
    [Out] double[,] WKZ,
    ref int LDWKZ,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DAF(
    string MEAN, string WEIGHT, ref int N,
    [In] double[,] X, ref int LDX, ref int M,
    [In] int[] ISX, ref int IP, [In] double[] Y,
    [In] double[] WT, ref double RSS, ref int IDF,
    [Out] double[] B, [Out] double[] SE, [Out] double[] COV,
    [Out] double[] RES, [Out] double[] H, [Out] double[,] Q,
    ref int LDQ, ref int SVD, ref int IRANK,
    [Out] double[] P, ref double TOL, [Out] double[] WK,
    ref int IFAIL
,
    long MEANLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DCF(
    string UPDATE,
    string MEAN,
    string WEIGHT,
    ref int M,
    [In] int[] ISX,
    [In,Out] double[,] Q,
    ref int LDQ,
    ref int IP,
    [In] double[] X,
    ref int IX,
    ref double Y,
    ref double WT,
    ref double RSS,
    [Out] double[] WK,
    ref int IFAIL
,
    long UPDATELength,
    long MEANLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DDF(
    ref int N,
    ref int IP,
    [In] double[,] Q,
    ref int LDQ,
    ref double RSS,
    ref int IDF,
    [Out] double[] B,
    [Out] double[] SE,
    [Out] double[] COV,
    ref int SVD,
    ref int IRANK,
    [In,Out] double[] P,
    ref double TOL,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DEF(
    string WEIGHT,
    ref int N,
    ref int IP,
    [In,Out] double[,] Q,
    ref int LDQ,
    [In,Out] double[] P,
    [In] double[] WT,
    [In] double[] X,
    ref double RSS,
    ref double TOL,
    ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DFF(
    ref int IP,
    [In,Out] double[,] Q,
    ref int LDQ,
    ref int INDX,
    ref double RSS,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DGF(
    string WEIGHT,
    ref int N,
    [In] double[] WT,
    ref double RSS,
    ref int IP,
    ref int IRANK,
    [In,Out] double[] COV,
    [In,Out] double[,] Q,
    ref int LDQ,
    ref int SVD,
    [In] double[] P,
    [In] double[] Y,
    [Out] double[] B,
    [Out] double[] SE,
    [Out] double[] RES,
    [In] double[] WK,
    ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DKF(
    ref int IP,
    ref int ICONST,
    [In] double[] P,
    [In] double[,] C,
    ref int LDC,
    [In,Out] double[] B,
    ref double RSS,
    ref int IDF,
    [Out] double[] SE,
    [Out] double[] COV,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02DNF(
    ref int IP,
    ref int IRANK,
    [In] double[] B,
    [In] double[] COV,
    [In] double[] P,
    [In] double[] F,
    ref int EST,
    ref double STAT,
    ref double SESTAT,
    ref double T,
    ref double TOL,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02EAF(
    string MEAN,
    string WEIGHT,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In,Out] byte[,] VNAME,
    [In] int[] ISX,
    [In] double[] Y,
    [In] double[] WT,
    ref int NMOD,
    [In,Out] byte[,,] MODL,
    ref int LDMODL,
    [Out] double[] RSS,
    [Out] int[] NTERMS,
    [Out] int[] MRANK,
    [Out] double[] WK,
    ref int IFAIL
,
    long MEANLength,
    long WEIGHTLength,
    long VNAMELength,
    long MODLLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02ECF(
    string MEAN,
    ref int N,
    ref double SIGSQ,
    ref double TSS,
    ref int NMOD,
    [In] int[] NTERMS,
    [In] double[] RSS,
    [Out] double[] RSQ,
    [Out] double[] CP,
    ref int IFAIL
,
    long MEANLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02EEF(
    ref int ISTEP, string MEAN, string WEIGHT,
    ref int N, ref int M, [In] double[,] X,
    ref int LDX, [In,Out] byte[,] VNAME, [In] int[] ISX,
    ref int MAXIP, [In] double[] Y, [In] double[] WT,
    ref double FIN, ref int ADDVAR, StringBuilder NEWVAR,
    ref double CHRSS, ref double F, [In,Out] byte[,] MODEL,
    ref int NTERM, ref double RSS, ref int IDF,
    ref int IFR, [In,Out] byte[,] FREE, [Out] double[] EXSS,
    [In,Out] double[,] Q, ref int LDQ, [In,Out] double[] P,
    [Out] double[] WK, ref int IFAIL
,
    long MEANLength,
    long WEIGHTLength,
    long VNAMELength,
    long NEWVARLength,
    long MODELLength,
    long FREELength
    );


public delegate void G02EFF_MONFUN_DELEGATE(
    string FLAG,
    ref int VAR,
    ref double VAL,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
,
    long FLAGLength
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02EFH(
    string FLAG,
    ref int VAR,
    ref double VAL,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
,
    long FLAGLength
   );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02EFF(
    ref int M,
    ref int N,
    [In] double[] WMEAN,
    [In] double[] C,
    ref double SW,
    [In,Out] int[] ISX,
    ref double FIN,
    ref double FOUT,
    ref double TAU,
    [Out] double[] B,
    [Out] double[] SE,
    ref double RSQ,
    ref double RMS,
    ref int DF,
    ref int MONLEV,
    G02EFF_MONFUN_DELEGATE MONFUN,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02FAF(
    ref int N,
    ref int IP,
    ref int NRES,
    [In] double[] RES,
    [In] double[] H,
    ref double RMS,
    [Out] double[,] SRES,
    ref int LDSRES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02FCF(
    ref int N,
    ref int IP,
    [In] double[] RES,
    ref double D,
    ref double PDL,
    ref double PDU,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02GAF(
    string LINK, string MEAN, string OFFSET,
    string WEIGHT, ref int N, [In] double[,] X,
    ref int LDX, ref int M, [In] int[] ISX,
    ref int IP, [In] double[] Y, [In] double[] WT,
    ref double S, ref double A, ref double RSS,
    ref int IDF, [Out] double[] B, ref int IRANK,
    [Out] double[] SE, [Out] double[] COV, [In,Out] double[,] V,
    ref int LDV, ref double TOL, ref int MAXIT,
    ref int IPRINT, ref double EPS, [Out] double[] WK,
    ref int IFAIL
,
    long LINKLength,
    long MEANLength,
    long OFFSETLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02GBF(
    string LINK, string MEAN, string OFFSET,
    string WEIGHT, ref int N, [In] double[,] X,
    ref int LDX, ref int M, [In] int[] ISX,
    ref int IP, [In] double[] Y, [In] double[] T,
    [In] double[] WT, ref double DEV, ref int IDF,
    [Out] double[] B, ref int IRANK, [Out] double[] SE,
    [Out] double[] COV, [In,Out] double[,] V, ref int LDV,
    ref double TOL, ref int MAXIT, ref int IPRINT,
    ref double EPS, [Out] double[] WK, ref int IFAIL
,
    long LINKLength,
    long MEANLength,
    long OFFSETLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02GCF(
    string LINK, string MEAN, string OFFSET,
    string WEIGHT, ref int N, [In] double[,] X,
    ref int LDX, ref int M, [In] int[] ISX,
    ref int IP, [In] double[] Y, [In] double[] WT,
    ref double A, ref double DEV, ref int IDF,
    [Out] double[] B, ref int IRANK, [Out] double[] SE,
    [Out] double[] COV, [In,Out] double[,] V, ref int LDV,
    ref double TOL, ref int MAXIT, ref int IPRINT,
    ref double EPS, [Out] double[] WK, ref int IFAIL
,
    long LINKLength,
    long MEANLength,
    long OFFSETLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02GDF(
    string LINK, string MEAN, string OFFSET,
    string WEIGHT, ref int N, [In] double[,] X,
    ref int LDX, ref int M, [In] int[] ISX,
    ref int IP, [In] double[] Y, [In] double[] WT,
    ref double S, ref double A, ref double DEV,
    ref int IDF, [Out] double[] B, ref int IRANK,
    [Out] double[] SE, [Out] double[] COV, [In,Out] double[,] V,
    ref int LDV, ref double TOL, ref int MAXIT,
    ref int IPRINT, ref double EPS, [Out] double[] WK,
    ref int IFAIL
,
    long LINKLength,
    long MEANLength,
    long OFFSETLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02GKF(
    ref int IP,
    ref int ICONST,
    [In] double[,] V,
    ref int LDV,
    [In] double[,] C,
    ref int LDC,
    [In,Out] double[] B,
    ref double S,
    [Out] double[] SE,
    [Out] double[] COV,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02GNF(
    ref int IP,
    ref int IRANK,
    [In] double[] B,
    [In] double[] COV,
    [In] double[,] V,
    ref int LDV,
    [In] double[] F,
    ref int EST,
    ref double STAT,
    ref double SESTAT,
    ref double Z,
    ref double TOL,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02GPF(
    string ERRFN, string LINK, string MEAN,
    string OFFSET, string WEIGHT, ref int N,
    [In] double[,] X, ref int LDX, ref int M,
    [In] int[] ISX, ref int IP, [In] double[] T,
    [In] double[] OFF, [In] double[] WT, ref double S,
    ref double A, [In] double[] B, [In] double[] COV,
    ref int VFOBS, [Out] double[] ETA, [Out] double[] SEETA,
    [Out] double[] PRED, [Out] double[] SEPRED, ref int IFAIL
,
    long ERRFNLength,
    long LINKLength,
    long MEANLength,
    long OFFSETLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02HAF(
    ref int INDW, ref int IPSI, ref int ISIGMA,
    ref int INDC, ref int N, ref int M,
    [In,Out] double[,] X, ref int LDX, [In,Out] double[] Y,
    ref double CPSI, ref double H1, ref double H2,
    ref double H3, ref double CUCV, ref double DCHI,
    [In,Out] double[] THETA, ref double SIGMA, [Out] double[,] C,
    ref int LDC, [Out] double[] RS, [Out] double[] WGT,
    ref double TOL, ref int MAXIT, ref int NITMON,
    [Out] double[] STAT, ref int IFAIL
   );


public delegate double G02HBF_UCV_DELEGATE(
    ref double T
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02HBF(
    G02HBF_UCV_DELEGATE UCV,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In,Out] double[] A,
    [Out] double[] Z,
    ref double BL,
    ref double BD,
    ref double TOL,
    ref int MAXIT,
    ref int NITMON,
    ref int NIT,
    [Out] double[] WK,
    ref int IFAIL
   );


public delegate double G02HDF_CHI_DELEGATE(
    ref double T
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G02HDZ(
    ref double T
  );

public delegate double G02HDF_PSI_DELEGATE(
    ref double T
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02HDF(
    G02HDF_CHI_DELEGATE CHI, G02HDF_PSI_DELEGATE PSI, ref double PSIP0,
    ref double BETA, ref int INDW, ref int ISIGMA,
    ref int N, ref int M, [In,Out] double[,] X,
    ref int LDX, [In,Out] double[] Y, [In,Out] double[] WGT,
    [In,Out] double[] THETA, ref int K, ref double SIGMA,
    [Out] double[] RS, ref double TOL, ref double EPS,
    ref int MAXIT, ref int NITMON, ref int NIT,
    [Out] double[] WK, ref int IFAIL
   );


public delegate double G02HFF_PSI_DELEGATE(
    ref double T
  );

public delegate double G02HFF_PSP_DELEGATE(
    ref double T
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02HFF(
    G02HFF_PSI_DELEGATE PSI,
    G02HFF_PSP_DELEGATE PSP,
    ref int INDW,
    ref int INDC,
    ref double SIGMA,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] double[] RS,
    [In] double[] WGT,
    [Out] double[,] C,
    ref int LDC,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02HKF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    ref double EPS,
    [Out] double[] COV,
    [Out] double[] THETA,
    ref int MAXIT,
    ref int NITMON,
    ref double TOL,
    ref int NIT,
    [Out] double[] WK,
    ref int IFAIL
   );


public delegate void G02HLF_UCV_DELEGATE(
    ref double T,
    IntPtr RUSER_rptr,
    ref double U,
    ref double UD,
    ref double W,
    ref double WD
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02HLF(
    G02HLF_UCV_DELEGATE UCV,
    [In,Out] double[] RUSER,
    ref int INDM,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] COV,
    [In,Out] double[] A,
    [Out] double[] WT,
    [In,Out] double[] THETA,
    ref double BL,
    ref double BD,
    ref int MAXIT,
    ref int NITMON,
    ref double TOL,
    ref int NIT,
    [Out] double[] WK,
    ref int IFAIL
   );


public delegate void G02HMF_UCV_DELEGATE(
    ref double T,
    IntPtr RUSER_rptr,
    ref double U,
    ref double W
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02HMF(
    G02HMF_UCV_DELEGATE UCV,
    [In,Out] double[] RUSER,
    ref int INDM,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [Out] double[] COV,
    [In,Out] double[] A,
    [Out] double[] WT,
    [In,Out] double[] THETA,
    ref double BL,
    ref double BD,
    ref int MAXIT,
    ref int NITMON,
    ref double TOL,
    ref int NIT,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JAF(
    ref int N, ref int NCOL, ref int LDDAT,
    [In] double[,] DAT, [In] int[] LEVELS, ref int YVID,
    ref int CWID, ref int NFV, [In] int[] FVID,
    ref int FINT, ref int NRV, [In] int[] RVID,
    ref int NVPR, [In] int[] VPR, ref int RINT,
    ref int SVID, [In,Out] double[] GAMMA, ref int NFF,
    ref int NRF, ref int DF, ref double REML,
    ref int LB, [Out] double[] B, [Out] double[] SE,
    ref int MAXIT, ref double TOL, ref int WARN,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JBF(
    ref int N, ref int NCOL, ref int LDDAT,
    [In] double[,] DAT, [In] int[] LEVELS, ref int YVID,
    ref int CWID, ref int NFV, [In] int[] FVID,
    ref int FINT, ref int NRV, [In] int[] RVID,
    ref int NVPR, [In] int[] VPR, ref int RINT,
    ref int SVID, [In,Out] double[] GAMMA, ref int NFF,
    ref int NRF, ref int DF, ref double ML,
    ref int LB, [Out] double[] B, [Out] double[] SE,
    ref int MAXIT, ref double TOL, ref int WARN,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JCF(
    string WEIGHT, ref int N, ref int NCOL,
    [In] double[,] DAT, ref int LDDAT, [In] int[] LEVELS,
    [In] double[] Y, [In] double[] WT, [In] int[] FIXED,
    ref int LFIXED, ref int NRNDM, [In] int[,] RNDM,
    ref int LDRNDM, ref int NFF, ref int NLSV,
    ref int NRF, [Out] double[] RCOMM, ref int LRCOMM,
    [Out] int[] ICOMM, ref int LICOMM, ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JDF(
    ref int LVPR, [In] int[] VPR, ref int NVPR,
    [In,Out] double[] GAMMA, ref int EFFN, ref int RNKX,
    ref int NCOV, ref double LNLIKE, ref int LB,
    [Out] int[,] ID, ref int LDID, [Out] double[] B,
    [Out] double[] SE, [Out] double[,] CZZ, ref int LDCZZ,
    [Out] double[,] CXX, ref int LDCXX, [Out] double[,] CXZ,
    ref int LDCXZ, [In,Out] double[] RCOMM, [In,Out] int[] ICOMM,
    [In] int[] IOPT, ref int LIOPT, [In] double[] ROPT,
    ref int LROPT, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JEF(
    ref int LVPR, [In] int[] VPR, ref int NVPR,
    [In,Out] double[] GAMMA, ref int EFFN, ref int RNKX,
    ref int NCOV, ref double LNLIKE, ref int LB,
    [Out] int[,] ID, ref int LDID, [Out] double[] B,
    [Out] double[] SE, [Out] double[,] CZZ, ref int LDCZZ,
    [Out] double[,] CXX, ref int LDCXX, [Out] double[,] CXZ,
    ref int LDCXZ, [In,Out] double[] RCOMM, [In,Out] int[] ICOMM,
    [In] int[] IOPT, ref int LIOPT, [In] double[] ROPT,
    ref int LROPT, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JFF(
    ref IntPtr HLMM, ref IntPtr HDDESC, ref IntPtr HFIXED,
    ref int NRNDM, [In] IntPtr[] HRNDM, string WEIGHT,
    ref int N, [In] double[] Y, [In] double[] WT,
    [In] double[,] DAT, ref int LDDAT, ref int SDDAT,
    ref int FNLSV, ref int NFF, ref int RNLSV,
    ref int NRF, ref int NVPR, [Out] double[] RCOMM,
    ref int LRCOMM, [Out] int[] ICOMM, ref int LICOMM,
    ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JGF(
    ref IntPtr HLMM,
    [In,Out] double[] XRCOMM,
    ref int XLRCOMM,
    [In,Out] int[] XICOMM,
    ref int XLICOMM,
    [In] double[] YRCOMM,
    [In] int[] YICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02JHF(
    ref IntPtr HLMM,
    ref int NVPR,
    [In,Out] double[] GAMMA,
    ref int EFFN,
    ref int RNKX,
    ref int NCOV,
    ref double LNLIKE,
    ref int LB,
    [Out] double[] B,
    [Out] double[] SE,
    [Out] double[,] CZZ,
    ref int LDCZZ,
    [Out] double[,] CXX,
    ref int LDCXX,
    [Out] double[,] CXZ,
    ref int LDCXZ,
    [In,Out] double[] RCOMM,
    [In,Out] int[] ICOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02KAF(
    ref int N, ref int M, [In] double[,] X,
    ref int LDX, [In] int[] ISX, ref int IP,
    ref double TAU, [In] double[] Y, ref double H,
    ref int OPT, ref int NITER, ref double TOL,
    ref double NEP, ref int ORIG, [Out] double[] B,
    [Out] double[] VIF, [Out] double[] RES, ref double RSS,
    ref int DF, ref int OPTLOO, [Out] double[] PERR,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02KBF(
    ref int N, ref int M, [In] double[,] X,
    ref int LDX, [In] int[] ISX, ref int IP,
    [In] double[] Y, ref int LH, [In] double[] H,
    [Out] double[] NEP, ref int WANTB, [Out] double[,] B,
    ref int LDB, ref int WANTVF, [Out] double[,] VF,
    ref int LDVF, ref int LPEC, [In,Out] byte[,] PEC,
    [Out] double[,] PE, ref int LDPE, ref int IFAIL
,
    long PECLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02LAF(
    ref int N, ref int MX, [In] double[,] X,
    ref int LDX, [In] int[] ISX, ref int IP,
    ref int MY, [In] double[,] Y, ref int LDY,
    [Out] double[] XBAR, [Out] double[] YBAR, ref int ISCALE,
    [In,Out] double[] XSTD, [In,Out] double[] YSTD, ref int MAXFAC,
    [Out] double[,] XRES, ref int LDXRES, [Out] double[,] YRES,
    ref int LDYRES, [Out] double[,] W, ref int LDW,
    [Out] double[,] P, ref int LDP, [Out] double[,] T,
    ref int LDT, [Out] double[,] C, ref int LDC,
    [Out] double[,] U, ref int LDU, [Out] double[] XCV,
    [Out] double[,] YCV, ref int LDYCV, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02LBF(
    ref int N, ref int MX, [In] double[,] X,
    ref int LDX, [In] int[] ISX, ref int IP,
    ref int MY, [In] double[,] Y, ref int LDY,
    [Out] double[] XBAR, [Out] double[] YBAR, ref int ISCALE,
    [In,Out] double[] XSTD, [In,Out] double[] YSTD, ref int MAXFAC,
    ref int MAXIT, ref double TAU, [Out] double[,] XRES,
    ref int LDXRES, [Out] double[,] YRES, ref int LDYRES,
    [Out] double[,] W, ref int LDW, [Out] double[,] P,
    ref int LDP, [Out] double[,] T, ref int LDT,
    [Out] double[,] C, ref int LDC, [Out] double[,] U,
    ref int LDU, [Out] double[] XCV, [Out] double[,] YCV,
    ref int LDYCV, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02LCF(
    ref int IP, ref int MY, ref int MAXFAC,
    ref int NFACT, [In] double[,] P, ref int LDP,
    [In] double[,] C, ref int LDC, [In] double[,] W,
    ref int LDW, ref double RCOND, [Out] double[,] B,
    ref int LDB, ref int ORIG, [In] double[] XBAR,
    [In] double[] YBAR, ref int ISCALE, [In] double[] XSTD,
    [In] double[] YSTD, [Out] double[,] OB, ref int LDOB,
    ref int VIPOPT, [In] double[,] YCV, ref int LDYCV,
    [Out] double[,] VIP, ref int LDVIP, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02LDF(
    ref int IP,
    ref int MY,
    ref int ORIG,
    [In] double[] XBAR,
    [In] double[] YBAR,
    ref int ISCALE,
    [In] double[] XSTD,
    [In] double[] YSTD,
    [In] double[,] B,
    ref int LDB,
    ref int N,
    ref int MZ,
    [In] int[] ISZ,
    [In] double[,] Z,
    ref int LDZ,
    [Out] double[,] YHAT,
    ref int LDYHAT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02MAF(
    ref int MTYPE,
    ref int PRED,
    ref int PREY,
    ref int N,
    ref int M,
    [In] double[,] D,
    ref int LDD,
    [In] int[] ISX,
    ref int LISX,
    [In] double[] Y,
    ref int MNSTEP,
    ref int IP,
    ref int NSTEP,
    [Out] double[,] B,
    ref int LDB,
    [Out] double[,] FITSUM,
    [In] double[] ROPT,
    ref int LROPT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02MBF(
    ref int MTYPE, ref int PRED, ref int INTCPT,
    ref int N, ref int M, [In] double[,] DTD,
    ref int LDDTD, [In] int[] ISX, ref int LISX,
    [In] double[] DTY, ref double YTY, ref int MNSTEP,
    ref int IP, ref int NSTEP, [Out] double[,] B,
    ref int LDB, [Out] double[,] FITSUM, [In] double[] ROPT,
    ref int LROPT, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02MCF(
    ref int NSTEP,
    ref int IP,
    [In] double[,] B,
    ref int LDB,
    [In] double[,] FITSUM,
    ref int KTYPE,
    [In] double[] NK,
    ref int LNK,
    [Out] double[,] NB,
    ref int LDNB,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02QFF(
    ref int N,
    ref int M,
    [In] double[,] X,
    [In] double[] Y,
    ref int NTAU,
    [In] double[] TAU,
    ref double DF,
    [Out] double[,] B,
    [Out] double[,] BL,
    [Out] double[,] BU,
    [Out] int[] INFO,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02QGF(
    ref int SORDER, string INTCPT, string WEIGHT,
    ref int N, ref int M, [In] double[,] DAT,
    ref int LDDAT, [In] int[] ISX, ref int IP,
    [In] double[] Y, [In] double[] WT, ref int NTAU,
    [In] double[] TAU, ref double DF, [In,Out] double[,] B,
    [Out] double[,] BL, [Out] double[,] BU, [Out] double[,,] CH,
    [Out] double[,] RES, [In] int[] IOPTS, [In] double[] OPTS,
    [In,Out] int[] STATE, [Out] int[] INFO, ref int IFAIL
,
    long INTCPTLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02ZKF(
    string OPTSTR,
    [In,Out] int[] IOPTS,
    ref int LIOPTS,
    [In,Out] double[] OPTS,
    ref int LOPTS,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G02ZLF(
    string OPTSTR,
    ref int IVALUE,
    ref double RVALUE,
    StringBuilder CVALUE,
    ref int OPTYPE,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


// chapter g03

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03AAF(
    string MATRIX,
    string STD,
    string WEIGHT,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] ISX,
    [In,Out] double[] S,
    [In] double[] WT,
    ref int NVAR,
    [Out] double[,] E,
    ref int LDE,
    [Out] double[,] P,
    ref int LDP,
    [Out] double[,] V,
    ref int LDV,
    [In] double[] WK,
    ref int IFAIL
,
    long MATRIXLength,
    long STDLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03ACF(
    string WEIGHT, ref int N, ref int M,
    [In] double[,] X, ref int LDX, [In] int[] ISX,
    ref int NX, [In] int[] ING, ref int NG,
    [In] double[] WT, [Out] int[] NIG, [Out] double[,] CVM,
    ref int LDCVM, [Out] double[,] E, ref int LDE,
    ref int NCV, [Out] double[,] CVX, ref int LDCVX,
    ref double TOL, ref int IRANKX, [Out] double[] WK,
    ref int IWK, ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03ADF(
    string WEIGHT, ref int N, ref int M,
    [In] double[,] Z, ref int LDZ, [In] int[] ISZ,
    ref int NX, ref int NY, [In] double[] WT,
    [Out] double[,] E, ref int LDE, ref int NCV,
    [Out] double[,] CVX, ref int LDCVX, ref int MCV,
    [Out] double[,] CVY, ref int LDCVY, ref double TOL,
    [Out] double[] WK, ref int IWK, ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03BAF(
    string STAND,
    ref double G,
    ref int NVAR,
    ref int K,
    [In,Out] double[,] FL,
    ref int LDFL,
    [Out] double[,] FLR,
    [Out] double[,] R,
    ref int LDR,
    ref double ACC,
    ref int MAXIT,
    ref int ITER,
    [Out] double[] WK,
    ref int IFAIL
,
    long STANDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03BCF(
    string STAND,
    string PSCALE,
    ref int N,
    ref int M,
    [In,Out] double[,] X,
    ref int LDX,
    [In,Out] double[,] Y,
    ref int LDY,
    [Out] double[,] YHAT,
    [Out] double[,] R,
    ref int LDR,
    ref double ALPHA,
    ref double RSS,
    [Out] double[] RES,
    [Out] double[] WK,
    ref int IFAIL
,
    long STANDLength,
    long PSCALELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03BDF(
    string STAND,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] double[,] RO,
    ref int LDRO,
    ref double POWER,
    [Out] double[,] FP,
    ref int LDFP,
    [Out] double[,] R,
    ref int LDR,
    [Out] double[,] PHI,
    ref int LDPHI,
    [Out] double[,] FS,
    ref int LDFS,
    ref int IFAIL
,
    long STANDLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03CAF(
    string MATRIX, string WEIGHT, ref int N,
    ref int M, [In] double[,] X, ref int LDX,
    ref int NVAR, [In] int[] ISX, ref int NFAC,
    [In] double[] WT, [Out] double[] E, [Out] double[] STAT,
    [Out] double[] COM, [Out] double[] PSI, [Out] double[] RES,
    [Out] double[,] FL, ref int LDFL, [In] int[] IOP,
    [Out] int[] IWK, [Out] double[] WK, ref int LWK,
    ref int IFAIL
,
    long MATRIXLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03CCF(
    string METHOD,
    string ROTATE,
    ref int NVAR,
    ref int NFAC,
    [In] double[,] FL,
    ref int LDFL,
    [In] double[] PSI,
    [In] double[] E,
    [In] double[,] R,
    ref int LDR,
    [Out] double[,] FS,
    ref int LDFS,
    [Out] double[] WK,
    ref int IFAIL
,
    long METHODLength,
    long ROTATELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03DAF(
    string WEIGHT, ref int N, ref int M,
    [In] double[,] X, ref int LDX, [In] int[] ISX,
    ref int NVAR, [In] int[] ING, ref int NG,
    [In] double[] WT, [Out] int[] NIG, [Out] double[,] GMN,
    ref int LDGMN, [Out] double[] DET, [Out] double[] GC,
    ref double STAT, ref double DF, ref double SIG,
    [Out] double[] WK, [Out] int[] IWK, ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03DBF(
    string EQUAL,
    string MODE,
    ref int NVAR,
    ref int NG,
    [In] double[,] GMN,
    ref int LDGMN,
    [In] double[] GC,
    ref int NOBS,
    ref int M,
    [In] int[] ISX,
    [In] double[,] X,
    ref int LDX,
    [Out] double[,] D,
    ref int LDD,
    [Out] double[] WK,
    ref int IFAIL
,
    long EQUALLength,
    long MODELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03DCF(
    string TYP, string EQUAL, string PRIORS,
    ref int NVAR, ref int NG, [In] int[] NIG,
    [In] double[,] GMN, ref int LDGMN, [In] double[] GC,
    [In] double[] DET, ref int NOBS, ref int M,
    [In] int[] ISX, [In] double[,] X, ref int LDX,
    [In,Out] double[] PRIOR, [Out] double[,] P, ref int LDP,
    [Out] int[] IAG, ref int ATIQ, [Out] double[,] ATI,
    [Out] double[] WK, ref int IFAIL
,
    long TYPLength,
    long EQUALLength,
    long PRIORSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03EAF(
    string UPDATE,
    string DIST,
    string SCAL,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] ISX,
    [In,Out] double[] S,
    [In,Out] double[] D,
    ref int IFAIL
,
    long UPDATELength,
    long DISTLength,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03EBF(
    string UPDATE,
    string SCAL,
    string STYPE,
    ref double P,
    ref int M,
    ref int N,
    ref int L,
    [In] double[,] X,
    ref int LDX,
    [In] int[] ISV,
    [In] double[,] Y,
    ref int LDY,
    [In,Out] double[] SX,
    [In,Out] double[] SY,
    [In,Out] double[,] D,
    ref int IFAIL
,
    long UPDATELength,
    long SCALLength,
    long STYPELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03ECF(
    ref int METHOD,
    ref int N,
    [In,Out] double[] D,
    [Out] int[] ILC,
    [Out] int[] IUC,
    [Out] double[] CD,
    [Out] int[] IORD,
    [Out] double[] DORD,
    [Out] int[] IWK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03EFF(
    string WEIGHT,
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    [In] int[] ISX,
    ref int NVAR,
    ref int K,
    [In,Out] double[,] CMEANS,
    ref int LDC,
    [In] double[] WT,
    [Out] int[] INC,
    [Out] int[] NIC,
    [Out] double[] CSS,
    [Out] double[] CSW,
    ref int MAXIT,
    [Out] int[] IWK,
    [Out] double[] WK,
    ref int IFAIL
,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03EHF(
    string ORIENT,
    ref int N,
    [In] double[] DORD,
    ref double DMIN,
    ref double DSTEP,
    ref int NSYM,
    [In,Out] byte[,] C,
    ref int LENC,
    ref int IFAIL
,
    long ORIENTLength,
    long CLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03EJF(
    ref int N,
    [In] double[] CD,
    [In] int[] IORD,
    [In] double[] DORD,
    ref int K,
    ref double DLEVEL,
    [Out] int[] IC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03FAF(
    string ROOTS,
    ref int N,
    [In] double[] D,
    ref int NDIM,
    [Out] double[,] X,
    ref int LDX,
    [Out] double[] EVAL,
    [Out] double[] WK,
    [Out] int[] IWK,
    ref int IFAIL
,
    long ROOTSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03FCF(
    string TYP,
    ref int N,
    ref int NDIM,
    [In] double[] D,
    [In,Out] double[,] X,
    ref int LDX,
    ref double STRESS,
    [Out] double[] DFIT,
    ref int ITER,
    ref int IOPT,
    [Out] double[] WK,
    [Out] int[] IWK,
    ref int IFAIL
,
    long TYPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03GAF(
    ref int N, ref int M, [In] double[,] X,
    ref int LDX, [In] int[] ISX, ref int NVAR,
    ref int NG, ref int POPT, [In,Out] double[,] PROB,
    ref int LPROB, ref int NITER, ref int RITER,
    [Out] double[] W, [Out] double[,] G, ref int SOPT,
    [Out] double[,,] S, ref int LDS, ref int SDS,
    [Out] double[,] F, ref double TOL, ref double LOGLIK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03GBF(
    ref int N, ref int M, [In] double[,] X,
    ref int LDX, [In] int[] ISX, ref int NVAR,
    ref int NG, ref int POPT, [In,Out] double[,] PROB,
    ref int LPROB, ref int NITER, ref int RITER,
    [Out] double[] W, [Out] double[,] G, ref int LDG,
    ref int SOPT, [Out] double[,,] S, ref int LDS,
    ref int SDS, [Out] double[,] F, ref int LDF,
    ref double TOL, ref double LOGLIK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G03ZAF(
    ref int N,
    ref int M,
    [In] double[,] X,
    ref int LDX,
    ref int NVAR,
    [In] int[] ISX,
    [In] double[] S,
    [In] double[] E,
    [Out] double[,] Z,
    ref int LDZ,
    ref int IFAIL
   );


// chapter g04

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04AGF(
    [In] double[] Y,
    ref int N,
    ref int K,
    [In] int[] LSUB,
    [In] int[] NOBS,
    ref int L,
    [Out] int[] NGP,
    [Out] double[] GBAR,
    [Out] double[] SGBAR,
    ref double GM,
    [Out] double[] SS,
    [Out] int[] IDF,
    [Out] double[] F,
    [Out] double[] FP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04BBF(
    ref int N,
    [In] double[] Y,
    ref int IBLOCK,
    ref int NT,
    [In] int[] IT,
    ref double GMEAN,
    [Out] double[] BMEAN,
    [Out] double[] TMEAN,
    [Out] double[,] TABL,
    ref int LDTABL,
    [Out] double[,] C,
    ref int LDC,
    [Out] int[] IREP,
    [Out] double[] R,
    [Out] double[] EF,
    ref double TOL,
    ref int IRDF,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04BCF(
    ref int NREP, ref int NROW, ref int NCOL,
    [In] double[] Y, ref int NT, [In] int[] IT,
    ref double GMEAN, [Out] double[] TMEAN, [Out] double[,] TABL,
    ref int LDTABL, [Out] double[,] C, ref int LDC,
    [Out] int[] IREP, [Out] double[] RPMEAN, [Out] double[] RMEAN,
    [Out] double[] CMEAN, [Out] double[] R, [Out] double[] EF,
    ref double TOL, ref int IRDF, [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04CAF(
    ref int N,
    [In] double[] Y,
    ref int NFAC,
    [In] int[] LFAC,
    ref int NBLOCK,
    ref int INTER,
    ref int IRDF,
    ref int MTERM,
    [Out] double[,] TABLE,
    ref int ITOTAL,
    [Out] double[] TMEAN,
    ref int MAXT,
    [Out] double[] E,
    [Out] int[] IMEAN,
    [Out] double[] SEMEAN,
    [Out] double[] BMEAN,
    [Out] double[] R,
    [Out] int[] IWK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04DAF(
    ref int NT,
    [In] double[] TMEAN,
    [In] int[] IREP,
    ref double RMS,
    ref double RDF,
    ref int NC,
    [In] double[,] CT,
    ref int LDCT,
    [Out] double[] EST,
    [In,Out] double[,] TABL,
    ref int LDTABL,
    ref double TOL,
    ref int USETX,
    [In] double[] TX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04DBF(
    string TYP,
    ref int NT,
    [In] double[] TMEAN,
    ref double RDF,
    [In] double[,] C,
    ref int LDC,
    ref double CLEVEL,
    [Out] double[] CIL,
    [Out] double[] CIU,
    [Out] int[] ISIG,
    ref int IFAIL
,
    long TYPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04EAF(
    string TYP,
    ref int N,
    ref int LEVELS,
    [In] int[] IFACT,
    [Out] double[,] X,
    ref int LDX,
    [In] double[] V,
    [Out] double[] REP,
    ref int IFAIL
,
    long TYPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G04GAF(
    ref int MTYPE,
    ref int RTYPE,
    ref int NREP,
    ref int NSUBJ,
    ref int NRATER,
    [In] double[,,] SCORE,
    ref int MSCORE,
    ref double SMISS,
    ref double ALPHA,
    ref double ICC,
    ref double LCI,
    ref double UCI,
    ref double FSTAT,
    ref double DF1,
    ref double DF2,
    ref double PVALUE,
    ref int IFAIL
   );


// chapter g05

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05KFF(
    ref int GENID,
    ref int SUBID,
    [In] int[] SEED,
    ref int LSEED,
    [Out] int[] STATE,
    ref int LSTATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05KGF(
    ref int GENID,
    ref int SUBID,
    [Out] int[] STATE,
    ref int LSTATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05KHF(
    ref int N,
    ref int K,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05KJF(
    ref int N,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05KKF(
    ref int N,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05NCF(
    [In,Out] int[] INDX,
    ref int N,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05NDF(
    [In] int[] IPOP,
    ref int N,
    [Out] int[] ISAMPL,
    ref int M,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05NEF(
    string ORDER,
    [In] double[] WT,
    string POP,
    [In] int[] IPOP,
    ref int N,
    [Out] int[] ISAMPL,
    ref int M,
    [In,Out] int[] STATE,
    ref int IFAIL
,
    long ORDERLength,
    long POPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05NFF(
    ref int RTYPE,
    ref int N,
    [In] double[] WT,
    [In] int[] IPOP,
    ref int LIPOP,
    ref int M,
    ref int NRS,
    ref int OTYPE,
    [Out] int[,] ISAMPL,
    ref int LDISAMPL,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PDF(
    string DIST,
    ref int NUM,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    ref double GAMMA,
    ref int DF,
    [Out] double[] HT,
    [Out] double[] ET,
    ref int FCALL,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PEF(
    string DIST,
    ref int NUM,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    ref double GAMMA,
    ref int DF,
    [Out] double[] HT,
    [Out] double[] ET,
    ref int FCALL,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PFF(
    string DIST,
    ref int NUM,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    ref double GAMMA,
    ref int DF,
    [Out] double[] HT,
    [Out] double[] ET,
    ref int FCALL,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PGF(
    string DIST,
    ref int NUM,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    ref int DF,
    [Out] double[] HT,
    [Out] double[] ET,
    ref int FCALL,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PHF(
    ref int MODE,
    ref int N,
    ref double XMEAN,
    ref int IP,
    [In] double[] PHI,
    ref int IQ,
    [In] double[] THETA,
    ref double AVAR,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    ref double VAR,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PJF(
    ref int MODE,
    ref int N,
    ref int K,
    [In] double[] XMEAN,
    ref int IP,
    [In] double[] PHI,
    ref int IQ,
    [In] double[] THETA,
    [In] double[,] VAR,
    ref int LDVAR,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PMF(
    ref int MODE,
    ref int N,
    ref int ITYPE,
    ref int P,
    [In] double[] PARAM,
    [In] double[] INIT,
    ref double VAR,
    [In,Out] double[] R,
    [In,Out] int[] STATE,
    [In] double[] E,
    ref int EN,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PVF(
    ref int K,
    ref int FOLD,
    ref int N,
    ref int M,
    ref int SORDX,
    [In,Out] double[,] X,
    ref int LDX,
    ref int USEY,
    [In,Out] double[] Y,
    ref int USEW,
    [In,Out] double[] W,
    ref int NT,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PWF(
    ref int NT,
    ref int N,
    ref int M,
    ref int SORDX,
    [In,Out] double[,] X,
    ref int LDX,
    ref int USEY,
    [In,Out] double[] Y,
    ref int USEW,
    [In,Out] double[] W,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PXF(
    string SIDE,
    string INIT,
    ref int M,
    ref int N,
    [In,Out] int[] STATE,
    [In,Out] double[,] A,
    ref int LDA,
    ref int IFAIL
,
    long SIDELength,
    long INITLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PYF(
    ref int N,
    [In] double[] D,
    ref double EPS,
    [In,Out] int[] STATE,
    [Out] double[,] C,
    ref int LDC,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05PZF(
    ref int MODE,
    ref int NROW,
    ref int NCOL,
    [In] int[] TOTR,
    [In] int[] TOTC,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RCF(
    ref int MODE,
    ref int N,
    ref int DF,
    ref int M,
    [In] double[,] C,
    ref int LDC,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RDF(
    ref int MODE,
    ref int N,
    ref int M,
    [In] double[,] C,
    ref int LDC,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05REF(
    ref int N,
    ref double THETA,
    ref int SORDER,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int SDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RFF(
    ref int N,
    ref double THETA,
    ref int SORDER,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int SDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RGF(
    ref int N,
    ref double THETA,
    ref int SORDER,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int SDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RHF(
    ref int N,
    ref int M,
    ref double THETA,
    ref int SORDER,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int SDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RJF(
    ref int N,
    ref int M,
    ref double THETA,
    ref int SORDER,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int SDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RKF(
    ref int N,
    ref int M,
    ref double THETA,
    ref int SORDER,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int SDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RYF(
    ref int MODE,
    ref int N,
    ref int DF,
    ref int M,
    [In] double[] XMU,
    [In] double[,] C,
    ref int LDC,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05RZF(
    ref int MODE,
    ref int N,
    ref int M,
    [In] double[] XMU,
    [In] double[,] C,
    ref int LDC,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SAF(
    ref int N,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SBF(
    ref int N,
    ref double A,
    ref double B,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SCF(
    ref int N,
    ref double XMED,
    ref double SEMIQR,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SDF(
    ref int N,
    ref int DF,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SEF(
    ref int N,
    ref int M,
    [In] double[] A,
    [In,Out] int[] STATE,
    [Out] double[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SFF(
    ref int N,
    ref double A,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SGF(
    ref int N,
    ref int NMIX,
    [In] double[] A,
    [In] double[] WGT,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SHF(
    ref int N,
    ref int DF1,
    ref int DF2,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SJF(
    ref int N,
    ref double A,
    ref double B,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SKF(
    ref int N,
    ref double XMU,
    ref double VAR,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SLF(
    ref int N,
    ref double A,
    ref double B,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SMF(
    ref int N,
    ref double XMU,
    ref double VAR,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SNF(
    ref int N,
    ref int DF,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SPF(
    ref int N,
    ref double XMIN,
    ref double XMED,
    ref double XMAX,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SQF(
    ref int N,
    ref double A,
    ref double B,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SRF(
    ref int N,
    ref double VK,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05SSF(
    ref int N,
    ref double A,
    ref double B,
    [In,Out] int[] STATE,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TAF(
    ref int MODE,
    ref int N,
    ref int M,
    ref double P,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TBF(
    ref int N,
    ref double P,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TCF(
    ref int MODE,
    ref int N,
    ref double P,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TDF(
    ref int MODE,
    ref int N,
    [In] double[] P,
    ref int NP,
    ref int IP1,
    ref int ITYPE,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TEF(
    ref int MODE,
    ref int N,
    ref int NS,
    ref int NP,
    ref int M,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TFF(
    ref int MODE,
    ref int N,
    ref double A,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TGF(
    ref int MODE,
    ref int N,
    ref int M,
    ref int K,
    [In] double[] P,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[,] X,
    ref int LDX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05THF(
    ref int MODE,
    ref int N,
    ref int M,
    ref double P,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TJF(
    ref int MODE,
    ref int N,
    ref double LAMBDA,
    [In,Out] double[] R,
    ref int LR,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TKF(
    ref int M,
    [In] double[] VLAMDA,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05TLF(
    ref int N,
    ref int A,
    ref int B,
    [In,Out] int[] STATE,
    [Out] int[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05XAF(
    ref double T0,
    ref double TEND,
    [In] double[] TIMES,
    ref int NTIMES,
    [Out] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05XBF(
    ref int NPATHS,
    ref int RCORD,
    ref int D,
    [In] double[] START,
    ref int A,
    [In] double[] TERM,
    [In,Out] double[,] Z,
    ref int LDZ,
    [In] double[,] C,
    ref int LDC,
    [Out] double[,] B,
    ref int LDB,
    [In] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05XCF(
    ref double T0,
    ref double TEND,
    [In] double[] TIMES,
    ref int NTIMES,
    [Out] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05XDF(
    ref int NPATHS,
    ref int RCORD,
    ref int D,
    ref int A,
    [In] double[] DIFF,
    [In,Out] double[,] Z,
    ref int LDZ,
    [In] double[,] C,
    ref int LDC,
    [Out] double[,] B,
    ref int LDB,
    [In] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05XEF(
    ref int BGORD,
    ref double T0,
    ref double TEND,
    ref int NTIMES,
    [In] double[] INTIME,
    ref int NMOVE,
    [In] int[] MOVE,
    [Out] double[] TIMES,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YJF(
    [In] double[] XMEAN,
    [In] double[] STD,
    ref int N,
    [Out] double[,] QUAS,
    [In,Out] int[] IREF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YKF(
    [In] double[] XMEAN,
    [In] double[] STD,
    ref int N,
    [Out] double[,] QUAS,
    [In,Out] int[] IREF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YLF(
    ref int GENID,
    ref int IDIM,
    [Out] int[] IREF,
    ref int LIREF,
    ref int ISKIP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YMF(
    ref int N,
    ref int RCORD,
    [Out] double[,] QUAS,
    ref int LDQUAS,
    [In,Out] int[] IREF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YNF(
    ref int GENID,
    ref int STYPE,
    ref int IDIM,
    [Out] int[] IREF,
    ref int LIREF,
    ref int ISKIP,
    ref int NSDIGI,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YPF(
    ref int SORDER,
    ref int N,
    ref int FDIM,
    ref int LDIM,
    [Out] double[,] QUAS,
    ref int LDQUAS,
    [In,Out] int[] IREF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YQF(
    ref int SORDER,
    ref int N,
    [In] double[] XMEAN,
    [In] double[] STD,
    ref int FDIM,
    ref int LDIM,
    [Out] double[,] QUAS,
    ref int LDQUAS,
    [In,Out] int[] IREF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05YRF(
    ref int SORDER,
    ref int N,
    [In] double[] XMEAN,
    [In] double[] STD,
    ref int FDIM,
    ref int LDIM,
    [Out] double[,] QUAS,
    ref int LDQUAS,
    [In,Out] int[] IREF,
    ref int IFAIL
   );


public delegate void G05ZMF_COV1_DELEGATE(
    ref double X,
    ref double GAMMA,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05ZMF(
    ref int NS,
    ref double XMIN,
    ref double XMAX,
    ref int MAXM,
    ref double VAR,
    G05ZMF_COV1_DELEGATE COV1,
    ref int PAD,
    ref int ICORR,
    [Out] double[] LAM,
    [Out] double[] XX,
    ref int M,
    ref int APPROX,
    ref double RHO,
    ref int ICOUNT,
    [Out] double[] EIG,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05ZNF(
    ref int NS,
    ref double XMIN,
    ref double XMAX,
    ref int MAXM,
    ref double VAR,
    ref int ICOV1,
    ref int NP,
    [In] double[] PARAMS,
    ref int PAD,
    ref int ICORR,
    [Out] double[] LAM,
    [Out] double[] XX,
    ref int M,
    ref int APPROX,
    ref double RHO,
    ref int ICOUNT,
    [Out] double[] EIG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05ZPF(
    ref int NS,
    ref int S,
    ref int M,
    [In] double[] LAM,
    ref double RHO,
    [In,Out] int[] STATE,
    [Out] double[,] Z,
    ref int IFAIL
   );


public delegate void G05ZQF_COV2_DELEGATE(
    ref double X,
    ref double Y,
    ref double GAMMA,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05ZQF(
    [In] int[] NS, ref double XMIN, ref double XMAX,
    ref double YMIN, ref double YMAX, [In] int[] MAXM,
    ref double VAR, G05ZQF_COV2_DELEGATE COV2, ref int EVEN,
    ref int PAD, ref int ICORR, [Out] double[] LAM,
    [Out] double[] XX, [Out] double[] YY, [Out] int[] M,
    ref int APPROX, ref double RHO, ref int ICOUNT,
    [Out] double[] EIG, [In,Out] int[] IUSER, [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05ZRF(
    [In] int[] NS, ref double XMIN, ref double XMAX,
    ref double YMIN, ref double YMAX, [In] int[] MAXM,
    ref double VAR, ref int ICOV2, ref int NORM,
    ref int NP, [In] double[] PARAMS, ref int PAD,
    ref int ICORR, [Out] double[] LAM, [Out] double[] XX,
    [Out] double[] YY, [Out] int[] M, ref int APPROX,
    ref double RHO, ref int ICOUNT, [Out] double[] EIG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05ZSF(
    [In] int[] NS,
    ref int S,
    [In] int[] M,
    [In] double[] LAM,
    ref double RHO,
    [In,Out] int[] STATE,
    [Out] double[,] Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G05ZTF(
    ref int NS,
    ref int S,
    ref int M,
    ref double XMAX,
    ref double H,
    [In] double[] LAM,
    ref double RHO,
    [In,Out] int[] STATE,
    [Out] double[,] Z,
    [Out] double[] XX,
    ref int IFAIL
   );


// chapter g07

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07AAF(
    ref int N,
    ref int K,
    ref double CLEVEL,
    ref double PL,
    ref double PU,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07ABF(
    ref int N,
    ref double XMEAN,
    ref double CLEVEL,
    ref double TL,
    ref double TU,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07BBF(
    string METHOD,
    ref int N,
    [In] double[] X,
    [In] double[] XC,
    [In] int[] IC,
    ref double XMU,
    ref double XSIG,
    ref double TOL,
    ref int MAXIT,
    ref double SEXMU,
    ref double SEXSIG,
    ref double CORR,
    ref double DEV,
    [Out] int[] NOBS,
    ref int NIT,
    [Out] double[] WK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07BEF(
    string CENS,
    ref int N,
    [In] double[] X,
    [In] int[] IC,
    ref double BETA,
    ref double GAMMA,
    ref double TOL,
    ref int MAXIT,
    ref double SEBETA,
    ref double SEGAM,
    ref double CORR,
    ref double DEV,
    ref int NIT,
    [Out] double[] WK,
    ref int IFAIL
,
    long CENSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07BFF(
    ref int N,
    [In] double[] Y,
    ref int OPTOPT,
    ref double XI,
    ref double BETA,
    [Out] double[] ASVC,
    [Out] double[] OBSVC,
    ref double LL,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07CAF(
    string TAIL,
    string EQUAL,
    ref int NX,
    ref int NY,
    ref double XMEAN,
    ref double YMEAN,
    ref double XSTD,
    ref double YSTD,
    ref double CLEVEL,
    ref double T,
    ref double DF,
    ref double PROB,
    ref double DL,
    ref double DU,
    ref int IFAIL
,
    long TAILLength,
    long EQUALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07DAF(
    ref int N,
    [In] double[] X,
    [Out] double[] Y,
    ref double XME,
    ref double XMD,
    ref double XSD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07DBF(
    ref int ISIGMA,
    ref int N,
    [In] double[] X,
    ref int IPSI,
    ref double C,
    ref double H1,
    ref double H2,
    ref double H3,
    ref double DCHI,
    ref double THETA,
    ref double SIGMA,
    ref int MAXIT,
    ref double TOL,
    [Out] double[] RS,
    ref int NIT,
    [Out] double[] WRK,
    ref int IFAIL
   );


public delegate double G07DCF_CHI_DELEGATE(
    ref double T
  );

public delegate double G07DCF_PSI_DELEGATE(
    ref double T
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07DCF(
    G07DCF_CHI_DELEGATE CHI,
    G07DCF_PSI_DELEGATE PSI,
    ref int ISIGMA,
    ref int N,
    [In] double[] X,
    ref double BETA,
    ref double THETA,
    ref double SIGMA,
    ref int MAXIT,
    ref double TOL,
    [Out] double[] RS,
    ref int NIT,
    [Out] double[] WRK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07DDF(
    ref int N,
    [In] double[] X,
    ref double ALPHA,
    ref double TMEAN,
    ref double WMEAN,
    ref double TVAR,
    ref double WVAR,
    ref int K,
    [Out] double[] SX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07EAF(
    string METHOD,
    ref int N,
    [In] double[] X,
    ref double CLEVEL,
    ref double THETA,
    ref double THETAL,
    ref double THETAU,
    ref double ESTCL,
    ref double WLOWER,
    ref double WUPPER,
    [Out] double[] WRK,
    [Out] int[] IWRK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07EBF(
    string METHOD,
    ref int N,
    [In] double[] X,
    ref int M,
    [In] double[] Y,
    ref double CLEVEL,
    ref double THETA,
    ref double THETAL,
    ref double THETAU,
    ref double ESTCL,
    ref double ULOWER,
    ref double UUPPER,
    [Out] double[] WRK,
    [Out] int[] IWRK,
    ref int IFAIL
,
    long METHODLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G07GAF(
    ref int N,
    ref int P,
    [In] double[] Y,
    ref double MEAN,
    ref double VAR,
    [Out] int[] IOUT,
    ref int NIOUT,
    ref int LDIFF,
    [Out] double[] DIFF,
    [Out] double[] LLAMB,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool G07GBF(
    ref int N,
    ref double E,
    ref double VAR1,
    ref double VAR2,
    ref double X,
    ref double LX,
    ref double UX,
    ref int IFAIL
   );


// chapter g08

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08AAF(
    [In] double[] X,
    [In] double[] Y,
    ref int N,
    ref int ISGN,
    ref int N1,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08ACF(
    [In] double[] X,
    ref int N,
    ref int N1,
    [Out] double[] W,
    ref int I1,
    ref int I2,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08AEF(
    [In] double[,] X,
    ref int LDX,
    ref int K,
    ref int N,
    [Out] double[] W1,
    [Out] double[] W2,
    ref double FR,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08AFF(
    [In] double[] X,
    ref int LX,
    [In] int[] L,
    ref int K,
    [Out] double[] W,
    ref double H,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08AGF(
    ref int N,
    [In] double[] X,
    ref double XME,
    string TAIL,
    string ZER,
    ref double W,
    ref double WNOR,
    ref double P,
    ref int N1,
    [Out] double[] WRK,
    ref int IFAIL
,
    long TAILLength,
    long ZERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08AHF(
    ref int N1,
    [In] double[] X,
    ref int N2,
    [In] double[] Y,
    string TAIL,
    ref double U,
    ref double UNOR,
    ref double P,
    ref int TIES,
    [Out] double[] RANKS,
    [Out] double[] WRK,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08AJF(
    ref int N1,
    ref int N2,
    string TAIL,
    ref double U,
    ref double P,
    [Out] double[] WRK,
    ref int LWRK,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08AKF(
    ref int N1,
    ref int N2,
    string TAIL,
    [In] double[] RANKS,
    ref double U,
    ref double P,
    [Out] double[] WRK,
    ref int LWRK,
    [Out] int[] IWRK,
    ref int IFAIL
,
    long TAILLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08ALF(
    ref int N,
    ref int K,
    [In] double[,] X,
    ref int LDX,
    ref double Q,
    ref double PROB,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08BAF(
    [In] double[] X,
    ref int N,
    ref int N1,
    [Out] double[] R,
    ref int ITEST,
    ref double W,
    ref double V,
    ref double PW,
    ref double PV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08CBF(
    ref int N,
    [In] double[] X,
    string DIST,
    [In,Out] double[] PAR,
    string ESTIMA,
    ref int NTYPE,
    ref double D,
    ref double Z,
    ref double P,
    [Out] double[] SX,
    ref int IFAIL
,
    long DISTLength,
    long ESTIMALength
    );


public delegate double G08CCF_CDF_DELEGATE(
    ref double X
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08CCF(
    ref int N,
    [In] double[] X,
    G08CCF_CDF_DELEGATE CDF,
    ref int NTYPE,
    ref double D,
    ref double Z,
    ref double P,
    [Out] double[] SX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08CDF(
    ref int N1,
    [In] double[] X,
    ref int N2,
    [In] double[] Y,
    ref int NTYPE,
    ref double D,
    ref double Z,
    ref double P,
    [Out] double[] SX,
    [Out] double[] SY,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08CGF(
    ref int NCLASS,
    [In] int[] IFREQ,
    [In] double[] CB,
    string DIST,
    [In] double[] PAR,
    ref int NPEST,
    [In] double[] PROB,
    ref double CHISQ,
    ref double P,
    ref int NDF,
    [Out] double[] EVAL,
    [Out] double[] CHISQI,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G08CHF(
    ref int N,
    ref int ISSORT,
    [In,Out] double[] Y,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08CJF(
    ref int N,
    ref int ISSORT,
    [In,Out] double[] Y,
    ref double A2,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08CKF(
    ref int N,
    ref int ISSORT,
    [In] double[] Y,
    ref double YBAR,
    ref double YVAR,
    ref double A2,
    ref double AA2,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08CLF(
    ref int N,
    ref int ISSORT,
    [In] double[] Y,
    ref double YBAR,
    ref double A2,
    ref double AA2,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08DAF(
    [In] double[,] X,
    ref int LDX,
    ref int K,
    ref int N,
    [Out] double[,] RNK,
    ref double W,
    ref double P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08EAF(
    string CL,
    ref int N,
    [In] double[] X,
    ref int M,
    ref int MAXR,
    ref int NRUNS,
    [In,Out] int[] NCOUNT,
    [Out] double[] EX,
    [Out] double[,] COV,
    ref int LDCOV,
    ref double CHI,
    ref double DF,
    ref double PROB,
    [Out] double[] WRK,
    ref int LWRK,
    ref int IFAIL
,
    long CLLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08EBF(
    string CL,
    ref int N,
    [In] double[] X,
    ref int MSIZE,
    ref int LAG,
    [In,Out] int[,] NCOUNT,
    ref int LDC,
    ref double EX,
    ref double CHI,
    ref double DF,
    ref double PROB,
    [In,Out] double[] WRK,
    ref int IFAIL
,
    long CLLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08ECF(
    string CL,
    ref int N,
    [In] double[] X,
    ref int MSIZE,
    [In,Out] int[,,] NCOUNT,
    ref int LDC,
    ref double EX,
    ref double CHI,
    ref double DF,
    ref double PROB,
    ref int IFAIL
,
    long CLLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08EDF(
    string CL,
    ref int N,
    [In] double[] X,
    ref int M,
    ref int MAXG,
    ref double RLO,
    ref double RUP,
    ref double TOTLEN,
    ref int NGAPS,
    [In,Out] int[] NCOUNT,
    [Out] double[] EX,
    ref double CHI,
    ref double DF,
    ref double PROB,
    ref int IFAIL
,
    long CLLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08RAF(
    ref int NS, [In,Out] int[] NV, ref int NSUM,
    [In] double[] Y, ref int IP, [In] double[,] X,
    ref int LDX, ref int IDIST, ref int NMAX,
    ref double TOL, [Out] double[,] PRVR, ref int LDPRVR,
    [Out] int[] IRANK, [Out] double[] ZIN, [Out] double[] ETA,
    [Out] double[] VAPVEC, [Out] double[] PAREST, [Out] double[] WORK,
    ref int LWORK, [Out] int[] IWA, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G08RBF(
    ref int NS, [In] int[] NV, ref int NSUM,
    [In] double[] Y, ref int IP, [In] double[,] X,
    ref int LDX, [In] int[] ICEN, ref double GAMMA,
    ref int NMAX, ref double TOL, [Out] double[,] PRVR,
    ref int LDPRVR, [Out] int[] IRANK, [Out] double[] ZIN,
    [Out] double[] ETA, [Out] double[] VAPVEC, [Out] double[] PAREST,
    [Out] double[] WORK, ref int LWORK, [Out] int[] IWA,
    ref int IFAIL
   );


// chapter g10

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G10ABF(
    string MODE,
    string WEIGHT,
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] WT,
    ref double RHO,
    [Out] double[] YHAT,
    [In,Out] double[,] C,
    ref int LDC,
    ref double RSS,
    ref double DF,
    [Out] double[] RES,
    [Out] double[] H,
    [In,Out] double[] COMM,
    ref int IFAIL
,
    long MODELength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G10ACF(
    string METHOD, string WEIGHT, ref int N,
    [In] double[] X, [In] double[] Y, [In] double[] WT,
    [Out] double[] YHAT, [Out] double[,] C, ref int LDC,
    ref double RSS, ref double DF, [Out] double[] RES,
    [Out] double[] H, ref double CRIT, ref double RHO,
    ref double U, ref double TOL, ref int MAXCAL,
    [Out] double[] WK, ref int IFAIL
,
    long METHODLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G10BBF(
    ref int N,
    [In] double[] X,
    ref int WTYPE,
    ref double WINDOW,
    ref double SLO,
    ref double SHI,
    ref int NS,
    [Out] double[] SMOOTH,
    [Out] double[] T,
    ref int FCALL,
    [In,Out] double[] RCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G10CAF(
    ref int ITYPE,
    ref int N,
    [In] double[] Y,
    [Out] double[] SMOOTH,
    [Out] double[] ROUGH,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G10ZAF(
    string WEIGHT,
    ref int N,
    [In] double[] X,
    [In] double[] Y,
    [In] double[] WT,
    ref int NORD,
    [Out] double[] XORD,
    [Out] double[] YORD,
    [Out] double[] WTORD,
    ref double RSS,
    [Out] int[] IWRK,
    ref int IFAIL
,
    long WEIGHTLength
    );


// chapter g11

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G11AAF(
    ref int NROW,
    ref int NCOL,
    [In] int[,] NOBS,
    ref int LDNOBS,
    [Out] double[,] EXPT,
    [Out] double[,] CHIST,
    ref double PROB,
    ref double CHI,
    ref double G,
    ref double DF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G11BAF(
    string STAT, string UPDATE, string WEIGHT,
    ref int N, ref int NFAC, [In] int[] ISF,
    [In] int[] LFAC, [In] int[,] IFAC, ref int LDF,
    [In] double[] Y, [In] double[] WT, [In,Out] double[] TABLE,
    ref int MAXT, ref int NCELLS, ref int NDIM,
    [Out] int[] IDIM, [In,Out] int[] ICOUNT, [In,Out] double[] AUXT,
    [Out] int[] IWK, ref int IFAIL
,
    long STATLength,
    long UPDATELength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G11BBF(
    string TYP, string WEIGHT, ref int N,
    ref int NFAC, [In] int[] ISF, [In] int[] LFAC,
    [In] int[,] IFAC, ref int LDF, ref double PERCNT,
    [In] double[] Y, [In] double[] WT, [Out] double[] TABLE,
    ref int MAXT, ref int NCELLS, ref int NDIM,
    [Out] int[] IDIM, [Out] int[] ICOUNT, [Out] int[] IWK,
    [Out] double[] WK, ref int IFAIL
,
    long TYPLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G11BCF(
    string STAT,
    [In] double[] TABLE,
    ref int NCELLS,
    ref int NDIM,
    [In] int[] IDIM,
    [In] int[] ISDIM,
    [Out] double[] STABLE,
    ref int MAXST,
    ref int MCELLS,
    ref int MDIM,
    [Out] int[] MLEVEL,
    [Out] double[] AUXT,
    [Out] int[] IWK,
    [Out] double[] WK,
    ref int IFAIL
,
    long STATLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G11CAF(
    ref int N, ref int M, ref int NS,
    [In] double[,] Z, ref int LDZ, [In] int[] ISZ,
    ref int IP, [In] int[] IC, [In] int[] ISI,
    ref double DEV, [In,Out] double[] B, [Out] double[] SE,
    [Out] double[] SC, [Out] double[] COV, [Out] int[] NCA,
    [Out] int[] NCT, ref double TOL, ref int MAXIT,
    ref int IPRINT, [Out] double[] WK, ref int LWK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G11SAF(
    ref int IP, ref int N, ref int GPROB,
    ref int NS, [In,Out] int[,] X, ref int LDX,
    [In,Out] int[] IRL, [In,Out] double[] A, [In,Out] double[] C,
    ref int IPRINT, ref double CGETOL, ref int MAXIT,
    ref int CHISQR, ref int ISHOW, ref int NITER,
    [Out] double[] ALPHA, [Out] double[] PIGAM, [Out] double[,] CM,
    ref int LDCM, [Out] double[] G, [Out] double[,] EXPP,
    ref int LDEXPP, [Out] double[,] OBS, [Out] double[] EXF,
    [Out] double[] Y, [Out] double[] XL, [Out] int[] IOB,
    ref double RLOGL, ref double CHI, ref int IDF,
    ref double SIGLEV, [Out] double[] W, ref int LW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G11SBF(
    ref int IP,
    ref int N,
    ref int NS,
    [In,Out] int[,] X,
    ref int LDX,
    [Out] int[] IRL,
    ref int IFAIL
   );


// chapter g12

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G12AAF(
    ref int N,
    [In] double[] T,
    [In] int[] IC,
    string FREQ,
    [In] int[] IFREQ,
    ref int ND,
    [Out] double[] TP,
    [Out] double[] P,
    [Out] double[] PSIG,
    [Out] int[] IWK,
    ref int IFAIL
,
    long FREQLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G12ABF(
    ref int N,
    [In] double[] T,
    [In] int[] IC,
    [In] int[] GRP,
    ref int NGRP,
    string FREQ,
    [In] int[] IFREQ,
    string WEIGHT,
    [In] double[] WT,
    ref double TS,
    ref int DF,
    ref double P,
    [Out] double[] OBSD,
    [Out] double[] EXPT,
    ref int ND,
    [Out] int[] DI,
    [Out] int[] NI,
    ref int LDN,
    ref int IFAIL
,
    long FREQLength,
    long WEIGHTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G12BAF(
    string OFFSET, ref int N, ref int M,
    ref int NS, [In] double[,] Z, ref int LDZ,
    [In] int[] ISZ, ref int IP, [In] double[] T,
    [In] int[] IC, [In] double[] OMEGA, [In] int[] ISI,
    ref double DEV, [In,Out] double[] B, [Out] double[] SE,
    [Out] double[] SC, [Out] double[] COV, [Out] double[] RES,
    ref int ND, [Out] double[] TP, [Out] double[,] SUR,
    ref int NDMAX, ref double TOL, ref int MAXIT,
    ref int IPRINT, [Out] double[] WK, [Out] int[] IWK,
    ref int IFAIL
,
    long OFFSETLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G12ZAF(
    ref int N, ref int M, ref int NS,
    [In] double[,] Z, ref int LDZ, [In] int[] ISZ,
    ref int IP, [In] double[] T, [In] int[] IC,
    [In] int[] ISI, ref int NUM, [Out] int[] IXS,
    ref int NXS, [Out] double[,] X, ref int MXN,
    [Out] int[] ID, ref int ND, [Out] double[] TP,
    [Out] int[] IRS, ref int IFAIL
   );


// chapter g13

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AAF(
    [In] double[] X,
    ref int NX,
    ref int ND,
    ref int NDS,
    ref int NS,
    [Out] double[] XD,
    ref int NXD,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13ABF(
    [In] double[] X,
    ref int NX,
    ref int NK,
    ref double XM,
    ref double XV,
    [Out] double[] R,
    ref double STAT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13ACF(
    [In] double[] R,
    ref int NK,
    ref int NL,
    [Out] double[] P,
    [Out] double[] V,
    [Out] double[] AR,
    ref int NVL,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13ADF(
    [In] int[] MR,
    [In] double[] R,
    ref int NK,
    ref double XV,
    ref int NPAR,
    [Out] double[] WA,
    ref int NWA,
    [Out] double[] PAR,
    ref double RV,
    [Out] int[] ISF,
    ref int IFAIL
   );


public delegate void G13AEF_PIV_DELEGATE(
    IntPtr MR_iptr,
    IntPtr PAR_rptr,
    ref int NPAR,
    ref double C,
    ref int KFC,
    IntPtr ICOUNT_iptr,
    ref double S,
    IntPtr G_rptr,
    IntPtr H_rptr,
    ref int LDH,
    ref int IGH,
    ref int ITC,
    IntPtr ZSP_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AFZ(
    IntPtr MR_iptr,
    IntPtr PAR_rptr,
    ref int NPAR,
    ref double C,
    ref int KFC,
    IntPtr ICOUNT_iptr,
    ref double S,
    IntPtr G_rptr,
    IntPtr H_rptr,
    ref int LDH,
    ref int IGH,
    ref int ITC,
    IntPtr ZSP_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AEF(
    [In] int[] MR, [In,Out] double[] PAR, ref int NPAR,
    ref double C, ref int KFC, [In] double[] X,
    ref int NX, [Out] int[] ICOUNT, [Out] double[] EX,
    [Out] double[] EXR, [Out] double[] AL, ref int IEX,
    ref double S, [Out] double[] G, ref int IGH,
    [Out] double[] SD, [Out] double[,] H, ref int LDH,
    [Out] double[] ST, ref int IST, ref int NST,
    G13AEF_PIV_DELEGATE PIV, ref int KPIV, ref int NIT,
    ref int ITC, [In,Out] double[] ZSP, ref int KZSP,
    [Out] int[] ISF, [Out] double[] WA, ref int IWA,
    [Out] double[,] HC, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AFF(
    [In] int[] MR, [In,Out] double[] PAR, ref int NPAR,
    ref double C, ref int KFC, [In] double[] X,
    ref int NX, ref double S, ref int NDF,
    [Out] double[] SD, ref int NPPC, [Out] double[,] CM,
    ref int LDCM, [Out] double[] ST, ref int NST,
    ref int KPIV, ref int NIT, ref int ITC,
    [Out] int[] ISF, [Out] double[] RES, ref int IRES,
    ref int NRES, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AGF(
    [In,Out] double[] ST,
    ref int NST,
    [In] int[] MR,
    [In] double[] PAR,
    ref int NPAR,
    ref double C,
    [In] double[] ANX,
    ref int NUV,
    [Out] double[] ANEXR,
    [Out] double[] WA,
    ref int NWA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AHF(
    [In] double[] ST,
    ref int NST,
    [In] int[] MR,
    [In] double[] PAR,
    ref int NPAR,
    ref double C,
    ref double RMS,
    ref int NFV,
    [Out] double[] FVA,
    [Out] double[] FSD,
    [Out] double[] WA,
    ref int NWA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AJF(
    [In] int[] MR,
    [In] double[] PAR,
    ref int NPAR,
    ref double C,
    ref int KFC,
    [In] double[] X,
    ref int NX,
    ref double RMS,
    [Out] double[] ST,
    ref int IST,
    ref int NST,
    ref int NFV,
    [Out] double[] FVA,
    [Out] double[] FSD,
    ref int IFV,
    [Out] int[] ISF,
    [Out] double[] W,
    ref int IW,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AMF(
    ref int MODE,
    ref int ITYPE,
    ref int P,
    [In] double[] PARAM,
    ref int N,
    [In] double[] Y,
    ref int K,
    [In,Out] double[] INIT,
    ref int NF,
    [Out] double[] FV,
    [Out] double[] FSE,
    [Out] double[] YHAT,
    [Out] double[] RES,
    ref double DV,
    ref double AD,
    [In,Out] double[] R,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13ASF(
    ref int N,
    [In] double[] V,
    [In] int[] MR,
    ref int M,
    [In] double[] PAR,
    ref int NPAR,
    ref int ISHOW,
    [Out] double[] R,
    [Out] double[,] RCM,
    ref int LDRCM,
    ref double CHI,
    ref int IDF,
    ref double SIGLEV,
    [Out] int[] IW,
    ref int LIW,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13AUF(
    ref int N,
    [In] double[] Z,
    ref int M,
    ref int NGRPS,
    string RS,
    [Out] double[] Y,
    [Out] double[] MEAN,
    ref int IFAIL
,
    long RSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double G13AWF(
    ref int TYP,
    ref int P,
    ref int N,
    [In] double[] Y,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BAF(
    [In] double[] Y,
    ref int NY,
    [In] int[] MR,
    ref int NMR,
    [In] double[] PAR,
    ref int NPAR,
    ref double CY,
    [Out] double[] WA,
    ref int NWA,
    [Out] double[] B,
    ref int NB,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BBF(
    [In] double[] Y,
    ref int NY,
    [In] int[] MR,
    ref int NMR,
    [In] double[] PAR,
    ref int NPAR,
    ref double CY,
    [Out] double[] WA,
    ref int IWA,
    [Out] double[] B,
    ref int NB,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BCF(
    [In] double[] X,
    [In] double[] Y,
    ref int NXY,
    ref int NL,
    ref double S,
    ref double R0,
    [Out] double[] R,
    ref double STAT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BDF(
    ref double R0,
    [In] double[] R,
    ref int NL,
    [In] int[] NNA,
    ref double S,
    ref int NWDS,
    [Out] double[] WA,
    ref int IWA,
    [Out] double[] WDS,
    [Out] int[] ISF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BEF(
    [In] int[] MR, ref int NSER, [In] int[,] MT,
    [In,Out] double[] PARA, ref int NPARA, ref int KFC,
    ref int NXXY, [In,Out] double[,] XXY, ref int LDXXY,
    ref int KEF, ref int NIT, ref int KZSP,
    [In,Out] double[] ZSP, ref int ITC, [Out] double[] SD,
    [Out] double[,] CM, ref int LDCM, ref double S,
    ref double D, ref int NDF, ref int KZEF,
    [Out] double[] RES, [Out] double[] STTF, ref int ISTTF,
    ref int NSTTF, [Out] double[] WA, ref int IWA,
    [Out] int[] MWA, ref int IMWA, ref int KPRIV,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BGF(
    [In,Out] double[] STTF,
    ref int NSTTF,
    [In] int[] MR,
    ref int NSER,
    [In] int[,] MT,
    [In] double[] PARA,
    ref int NPARA,
    ref int NNV,
    [In,Out] double[,] XXYN,
    ref int LDXXYN,
    ref int KZEF,
    [Out] double[] RES,
    [Out] double[] WA,
    ref int IWA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BHF(
    [In] double[] STTF, ref int NSTTF, [In,Out] int[] MR,
    ref int NSER, [In] int[,] MT, [In] double[] PARA,
    ref int NPARA, ref int NFV, [In,Out] double[,] XXYN,
    ref int LDXXYN, [In,Out] int[,] MRX, [In] double[,] PARX,
    ref int LDPARX, [In] double[] RMSXY, ref int KZEF,
    [Out] double[] FVA, [Out] double[] FSD, [Out] double[] WA,
    ref int IWA, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13BJF(
    [In,Out] int[] MR, ref int NSER, [In] int[,] MT,
    [In,Out] double[] PARA, ref int NPARA, ref int KFC,
    ref int NEV, ref int NFV, [In,Out] double[,] XXY,
    ref int LDXXY, ref int KZEF, [In,Out] double[] RMSXY,
    [In,Out] int[,] MRX, [In] double[,] PARX, ref int LDPARX,
    [Out] double[] FVA, [Out] double[] FSD, [Out] double[] STTF,
    ref int ISTTF, ref int NSTTF, [Out] double[] WA,
    ref int IWA, [Out] int[] MWA, ref int IMWA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13CAF(
    ref int NX,
    ref int MTX,
    ref double PX,
    ref int IW,
    ref int MW,
    ref int IC,
    ref int NC,
    [In,Out] double[] C,
    ref int KC,
    ref int L,
    ref int LG,
    ref int NXG,
    [In,Out] double[] XG,
    ref int NG,
    [Out] double[] STATS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13CBF(
    ref int NX,
    ref int MTX,
    ref double PX,
    ref int MW,
    ref double PW,
    ref int L,
    ref int KC,
    ref int LG,
    [In,Out] double[] XG,
    ref int NG,
    [Out] double[] STATS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13CCF(
    ref int NXY,
    ref int MTXY,
    ref double PXY,
    ref int IW,
    ref int MW,
    ref int ISH,
    ref int IC,
    ref int NC,
    [In,Out] double[] CXY,
    [In,Out] double[] CYX,
    ref int KC,
    ref int L,
    ref int NXYG,
    [In,Out] double[] XG,
    [In,Out] double[] YG,
    ref int NG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13CDF(
    ref int NXY,
    ref int MTXY,
    ref double PXY,
    ref int MW,
    ref int ISH,
    ref double PW,
    ref int L,
    ref int KC,
    [In,Out] double[] XG,
    [In,Out] double[] YG,
    ref int NG,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13CEF(
    [In] double[] XG,
    [In] double[] YG,
    [In] double[] XYRG,
    [In] double[] XYIG,
    ref int NG,
    [In] double[] STATS,
    [Out] double[] CA,
    [Out] double[] CALW,
    [Out] double[] CAUP,
    ref double T,
    [Out] double[] SC,
    [Out] double[] SCLW,
    [Out] double[] SCUP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13CFF(
    [In] double[] XG,
    [In] double[] YG,
    [In] double[] XYRG,
    [In] double[] XYIG,
    ref int NG,
    [In] double[] STATS,
    [Out] double[] GN,
    [Out] double[] GNLW,
    [Out] double[] GNUP,
    [Out] double[] PH,
    [Out] double[] PHLW,
    [Out] double[] PHUP,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13CGF(
    [In] double[] XG,
    [In] double[] YG,
    [In] double[] XYRG,
    [In] double[] XYIG,
    ref int NG,
    [In] double[] STATS,
    ref int L,
    ref int N,
    [Out] double[] ER,
    ref double ERLW,
    ref double ERUP,
    [Out] double[] RF,
    ref double RFSE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DBF(
    [In] double[,] C0,
    [In] double[,,] C,
    ref int LDC0,
    ref int NS,
    ref int NL,
    ref int NK,
    [Out] double[] P,
    ref double V0,
    [Out] double[] V,
    [Out] double[,,] D,
    [Out] double[,] DB,
    [Out] double[,,] W,
    [Out] double[,,] WB,
    ref int NVP,
    [Out] double[] WA,
    ref int IWA,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DDF(
    ref int K, ref int N, ref int IP,
    ref int IQ, ref int MEAN, [In,Out] double[] PAR,
    ref int NPAR, [In,Out] double[,] QQ, ref int KMAX,
    [In] double[,] W, [In] int[] PARHLD, ref int EXACT,
    ref int IPRINT, ref double CGETOL, ref int MAXCAL,
    ref int ISHOW, ref int NITER, ref double RLOGL,
    [Out] double[,] V, [Out] double[] G, [Out] double[,] CM,
    ref int LDCM, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DJF(
    ref int K, ref int N, [In] double[,] Z,
    ref int KMAX, [In,Out] byte[,] TR, [In] int[] ID,
    [In] double[,] DELTA, ref int IP, ref int IQ,
    string MEAN, [In] double[] PAR, ref int LPAR,
    [In,Out] double[,] QQ, [In] double[,] V, ref int LMAX,
    [Out] double[,] PREDZ, [Out] double[,] SEFZ, [Out] double[] REF,
    ref int LREF, [Out] double[] WORK, ref int LWORK,
    [Out] int[] IWORK, ref int LIWORK, ref int IFAIL
,
    long TRLength,
    long MEANLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DKF(
    ref int K,
    ref int LMAX,
    ref int M,
    ref int MLAST,
    [In] double[,] Z,
    ref int KMAX,
    [In,Out] double[] REF,
    ref int LREF,
    [Out] double[,] V,
    [In,Out] double[,] PREDZ,
    [In,Out] double[,] SEFZ,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DLF(
    ref int K,
    ref int N,
    [In] double[,] Z,
    ref int KMAX,
    [In,Out] byte[,] TR,
    [In] int[] ID,
    [In] double[,] DELTA,
    [Out] double[,] W,
    ref int ND,
    [Out] double[] WORK,
    ref int IFAIL
,
    long TRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DMF(
    string MATRIX,
    ref int K,
    ref int N,
    ref int M,
    [In] double[,] W,
    ref int KMAX,
    [Out] double[] WMEAN,
    [Out] double[,] R0,
    [Out] double[,,] R,
    ref int IFAIL
,
    long MATRIXLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DNF(
    ref int K,
    ref int N,
    ref int M,
    ref int KMAX,
    [In] double[,] R0,
    [In] double[,,] R,
    ref int MAXLAG,
    [Out] double[,,] PARLAG,
    [Out] double[] X,
    [Out] double[] PVALUE,
    [Out] double[] WORK,
    ref int LWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DPF(
    ref int K,
    ref int N,
    [In] double[,] Z,
    ref int KMAX,
    ref int M,
    ref int MAXLAG,
    [Out] double[,,] PARLAG,
    [Out] double[,,] SE,
    [Out] double[,,] QQ,
    [Out] double[] X,
    [Out] double[] PVALUE,
    [Out] double[] LOGLHD,
    [Out] double[] WORK,
    ref int LWORK,
    [Out] int[] IWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DSF(
    ref int K, ref int N, [In] double[,] V,
    ref int KMAX, ref int IP, ref int IQ,
    ref int M, [In] double[] PAR, [In] int[] PARHLD,
    [In,Out] double[,] QQ, ref int ISHOW, [Out] double[,] R0,
    [Out] double[,,] R, [Out] double[,] RCM, ref int LDRCM,
    ref double CHI, ref int IDF, ref double SIGLEV,
    [Out] int[] IW, ref int LIW, [Out] double[] WORK,
    ref int LWORK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13DXF(
    ref int K,
    ref int IP,
    [In] double[] PAR,
    [Out] double[] RR,
    [Out] double[] RI,
    [Out] double[] RMOD,
    [Out] double[] WORK,
    [Out] int[] IWORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13EAF(
    ref int N,
    ref int M,
    ref int L,
    [In] double[,] A,
    ref int LDS,
    [In] double[,] B,
    ref int STQ,
    [In] double[,] Q,
    ref int LDQ,
    [In] double[,] C,
    ref int LDM,
    [In] double[,] R,
    [In,Out] double[,] S,
    [Out] double[,] K,
    [Out] double[,] H,
    ref double TOL,
    [Out] int[] IWK,
    [Out] double[] WK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13EBF(
    string TRANSF, ref int N, ref int M,
    ref int L, [In,Out] double[,] A, ref int LDS,
    [In,Out] double[,] B, ref int STQ, [In] double[,] Q,
    ref int LDQ, [In,Out] double[,] C, ref int LDM,
    [In] double[,] R, [In,Out] double[,] S, [Out] double[,] K,
    [Out] double[,] H, [Out] double[,] U, ref double TOL,
    [Out] int[] IWK, [Out] double[] WK, ref int IFAIL
,
    long TRANSFLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13EJF(
    ref int IREVCM, ref int MX, ref int MY,
    [In] double[] Y, [In] double[,] LX, ref int LDLX,
    [In] double[,] LY, ref int LDLY, [In,Out] double[] X,
    [In,Out] double[,] ST, ref int LDST, ref int N,
    [In,Out] double[,] XT, ref int LDXT, [In,Out] double[,] FXT,
    ref int LDFXT, [In] double[] ROPT, ref int LROPT,
    [In,Out] int[] ICOMM, ref int LICOMM, [In,Out] double[] RCOMM,
    ref int LRCOMM, ref int IFAIL
   );


public delegate void G13EKF_F_DELEGATE(
    ref int MX,
    ref int N,
    IntPtr XT_rptr,
    IntPtr FXT_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFO
  );

public delegate void G13EKF_H_DELEGATE(
    ref int MX,
    ref int MY,
    ref int N,
    IntPtr YT_rptr,
    IntPtr HYT_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFO
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13EKF(
    ref int MX,
    ref int MY,
    [In] double[] Y,
    [In] double[,] LX,
    [In] double[,] LY,
    G13EKF_F_DELEGATE F,
    G13EKF_H_DELEGATE H,
    [In,Out] double[] X,
    [In,Out] double[,] ST,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FAF(
    string DIST, [In] double[] YT, [In] double[,] X,
    ref int LDX, ref int NUM, ref int IP,
    ref int IQ, ref int NREG, ref int MN,
    ref int ISYM, ref int NPAR, [In,Out] double[] THETA,
    [Out] double[] SE, [Out] double[] SC, [Out] double[,] COVR,
    ref int LDCOVR, ref double PHT, [Out] double[] ET,
    [Out] double[] HT, ref double LGF, [In] int[] COPTS,
    ref int MAXIT, ref double TOL, [Out] double[] WORK,
    ref int LWORK, ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FBF(
    ref int NUM,
    ref int NT,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    ref double GAMMA,
    [Out] double[] FHT,
    [In] double[] HT,
    [In] double[] ET,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FCF(
    string DIST, [In] double[] YT, [In] double[,] X,
    ref int LDX, ref int NUM, ref int IP,
    ref int IQ, ref int NREG, ref int MN,
    ref int NPAR, [In,Out] double[] THETA, [Out] double[] SE,
    [Out] double[] SC, [Out] double[,] COVR, ref int LDCOVR,
    ref double PHT, [Out] double[] ET, [Out] double[] HT,
    ref double LGF, [In] int[] COPTS, ref int MAXIT,
    ref double TOL, [Out] double[] WORK, ref int LWORK,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FDF(
    ref int NUM,
    ref int NT,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    ref double GAMMA,
    [Out] double[] FHT,
    [In] double[] HT,
    [In] double[] ET,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FEF(
    string DIST, [In] double[] YT, [In] double[,] X,
    ref int LDX, ref int NUM, ref int IP,
    ref int IQ, ref int NREG, ref int MN,
    ref int NPAR, [In,Out] double[] THETA, [Out] double[] SE,
    [Out] double[] SC, [Out] double[,] COVR, ref int LDCOVR,
    ref double PHT, [Out] double[] ET, [Out] double[] HT,
    ref double LGF, [In] int[] COPTS, ref int MAXIT,
    ref double TOL, [Out] double[] WORK, ref int LWORK,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FFF(
    ref int NUM,
    ref int NT,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    ref double GAMMA,
    [Out] double[] FHT,
    [In] double[] HT,
    [In] double[] ET,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FGF(
    string DIST, [In] double[] YT, [In] double[,] X,
    ref int LDX, ref int NUM, ref int IP,
    ref int IQ, ref int NREG, ref int MN,
    ref int NPAR, [In,Out] double[] THETA, [Out] double[] SE,
    [Out] double[] SC, [Out] double[,] COVR, ref int LDCOVR,
    ref double PHT, [Out] double[] ET, [Out] double[] HT,
    ref double LGF, ref int COPTS, ref int MAXIT,
    ref double TOL, [Out] double[] WORK, ref int LWORK,
    ref int IFAIL
,
    long DISTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13FHF(
    ref int NUM,
    ref int NT,
    ref int IP,
    ref int IQ,
    [In] double[] THETA,
    [Out] double[] FHT,
    [In] double[] HT,
    [In] double[] ET,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13MEF(
    ref int NB,
    [In,Out] double[] IEMA,
    [In] double[] T,
    ref double TAU,
    ref int M,
    [In] double[] SINIT,
    [In] int[] INTER,
    ref int PN,
    [In,Out] double[] RCOMM,
    ref int LRCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13MFF(
    ref int SORDER,
    ref int NB,
    [In] double[] Z,
    [Out] double[,] IEMA,
    ref int LDIEMA,
    [In] double[] T,
    ref double TAU,
    ref int M1,
    ref int M2,
    [In] double[] SINIT,
    [In] int[] INTER,
    ref int FTYPE,
    ref double P,
    [In] double[] X,
    ref int PN,
    [In,Out] double[] RCOMM,
    ref int LRCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13MGF(
    ref int NB,
    [In,Out] double[] MA,
    [In] double[] T,
    ref double TAU,
    ref int M1,
    ref int M2,
    [In] double[] SINIT,
    [In] int[] INTER,
    ref int FTYPE,
    ref double P,
    ref int PN,
    [Out] double[] WMA,
    [In,Out] double[] RCOMM,
    ref int LRCOMM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13NAF(
    ref int CTYP,
    ref int N,
    [In] double[] Y,
    ref double BETA,
    ref int MINSS,
    ref int IPARAM,
    [In] double[] PARAM,
    ref int NTAU,
    [Out] int[] TAU,
    [Out] double[] SPARAM,
    ref int IFAIL
   );


public delegate void G13NBF_COSTFN_DELEGATE(
    ref int TS,
    ref int NR,
    IntPtr R_iptr,
    IntPtr C_rptr,
    IntPtr Y_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFO
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13NBF(
    ref int N,
    ref double BETA,
    ref int MINSS,
    ref double K,
    G13NBF_COSTFN_DELEGATE COSTFN,
    ref int NTAU,
    [Out] int[] TAU,
    [In,Out] double[] Y,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13NDF(
    ref int CTYP,
    ref int N,
    [In] double[] Y,
    ref double BETA,
    ref int MINSS,
    ref int IPARAM,
    [In] double[] PARAM,
    ref int MDEPTH,
    ref int NTAU,
    [Out] int[] TAU,
    [Out] double[] SPARAM,
    ref int IFAIL
   );


public delegate void G13NEF_CHGPFN_DELEGATE(
    ref int SIDE,
    ref int U,
    ref int W,
    ref int MINSS,
    ref int V,
    IntPtr COST_rptr,
    IntPtr Y_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFO
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G13NEF(
    ref int N,
    ref double BETA,
    ref int MINSS,
    ref int MDEPTH,
    G13NEF_CHGPFN_DELEGATE CHGPFN,
    ref int NTAU,
    [Out] int[] TAU,
    [In,Out] double[] Y,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


// chapter g22

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G22YAF(
    ref IntPtr HFORM,
    string FORMULA,
    ref int IFAIL
,
    long FORMULALength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G22YBF(
    ref IntPtr HDDESC,
    ref int NOBS,
    ref int NVAR,
    [In] int[] LEVELS,
    ref int LVNAMES,
    [In,Out] byte[,] VNAMES,
    ref int IFAIL
,
    long VNAMESLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G22YCF(
    ref IntPtr HFORM,
    ref IntPtr HDDESC,
    [In] double[,] DAT,
    ref int LDDAT,
    ref int SDDAT,
    ref IntPtr HXDESC,
    [Out] double[,] X,
    ref int LDX,
    ref int SDX,
    ref int MX,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G22YDF(
    string WHAT,
    ref IntPtr HFORM,
    ref IntPtr HXDESC,
    StringBuilder INTCPT,
    ref int IP,
    ref int LISX,
    [Out] int[] ISX,
    ref int LPLAB,
    [In,Out] byte[,] PLAB,
    ref int LENLAB,
    ref int LVINFO,
    [Out] int[] VINFO,
    ref int IFAIL
,
    long WHATLength,
    long INTCPTLength,
    long PLABLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G22ZAF(
    ref IntPtr HANDLE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G22ZMF(
    ref IntPtr HANDLE,
    string OPTSTR,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void G22ZNF(
    ref IntPtr HANDLE,
    string OPTSTR,
    ref int IVALUE,
    ref double RVALUE,
    StringBuilder CVALUE,
    ref int OPTYPE,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


// chapter h

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02BBF(
    ref int ITMAX, ref int MSGLVL, ref int N,
    ref int M, [In] double[,] A, ref int LDA,
    [In] double[] BL, [In] double[] BU, [In] int[] INTVAR,
    [In] double[] CVEC, ref int MAXNOD, ref int INTFST,
    ref int MAXDPT, ref double TOLIV, ref double TOLFES,
    ref double BIGBND, [In,Out] double[] X, ref double OBJMIP,
    [Out] int[] IWORK, ref int LIWORK, [Out] double[] RWORK,
    ref int LRWORK, ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02BFF(
    ref int INFILE,
    ref int MAXN,
    ref int MAXM,
    string OPTIM,
    ref double XBLDEF,
    ref double XBUDEF,
    ref int MAXDPT,
    ref int MSGLVL,
    ref int N,
    ref int M,
    [Out] double[] X,
    [In,Out] byte[,] CRNAME,
    [Out] int[] IWORK,
    ref int LIWORK,
    [Out] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
,
    long OPTIMLength,
    long CRNAMELength
    );


public delegate void H02BKF_MONIT_DELEGATE(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02BKU(
    ref IntPtr HANDLE,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER,
    ref int INFORM
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02BKF(
    ref IntPtr HANDLE,
    ref int NVAR,
    [In,Out] double[] X,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    H02BKF_MONIT_DELEGATE MONIT,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02BUF(
    ref int INFILE, ref int MAXN, ref int MAXM,
    string OPTIM, ref double XBLDEF, ref double XBUDEF,
    StringBuilder NMOBJ, StringBuilder NMRHS, StringBuilder NMRNG,
    StringBuilder NMBND, ref int MPSLST, ref int N,
    ref int M, [Out] double[,] A, [Out] double[] BL,
    [Out] double[] BU, [Out] double[] CVEC, [Out] double[] X,
    [Out] int[] INTVAR, [In,Out] byte[,] CRNAME, StringBuilder NMPROB,
    [Out] int[] IWORK, ref int IFAIL
,
    long OPTIMLength,
    long NMOBJLength,
    long NMRHSLength,
    long NMRNGLength,
    long NMBNDLength,
    long CRNAMELength,
    long NMPROBLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02BVF(
    ref int N,
    ref int M,
    [In] double[,] A,
    ref int LDA,
    [In] double[] BL,
    [In] double[] BU,
    [In] double[] X,
    [In] double[] CLAMDA,
    [In] int[] ISTATE,
    [In,Out] byte[,] CRNAME,
    ref int IFAIL
,
    long CRNAMELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02BZF(
    ref int N,
    ref int M,
    [Out] double[] BL,
    [Out] double[] BU,
    [Out] double[] CLAMDA,
    [Out] int[] ISTATE,
    [In] int[] IWORK,
    ref int LIWORK,
    [In] double[] RWORK,
    ref int LRWORK,
    ref int IFAIL
   );


public delegate void H02CBF_QPHESS_DELEGATE(
    ref int N,
    ref int JTHCOL,
    IntPtr H_rptr,
    ref int LDH,
    IntPtr X_rptr,
    IntPtr HX_rptr
  );


public delegate void H02CBF_MONIT_DELEGATE(
    ref int INTFND,
    ref int NODES,
    ref int DEPTH,
    ref double OBJ,
    IntPtr X_rptr,
    ref double BSTVAL,
    IntPtr BSTSOL_rptr,
    IntPtr BL_rptr,
    IntPtr BU_rptr,
    ref int N,
    ref int HALT,
    ref int COUNT
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CBU(
    ref int INTFND,
    ref int NODES,
    ref int DEPTH,
    ref double OBJ,
    IntPtr X_rptr,
    ref double BSTVAL,
    IntPtr BSTSOL_rptr,
    IntPtr BL_rptr,
    IntPtr BU_rptr,
    ref int N,
    ref int HALT,
    ref int COUNT
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CBF(
    ref int N, ref int NCLIN, [In] double[,] A,
    ref int LDA, [In,Out] double[] BL, [In,Out] double[] BU,
    [In] double[] CVEC, [In] double[,] H, ref int LDH,
    H02CBF_QPHESS_DELEGATE QPHESS, [In] int[] INTVAR, ref int LINTVR,
    ref int MDEPTH, [In,Out] int[] ISTATE, [In,Out] double[] XS,
    ref double OBJ, [Out] double[] AX, [Out] double[] CLAMDA,
    ref int STRTGY, [Out] int[] IWRK, ref int LIWRK,
    [Out] double[] WRK, ref int LWRK, H02CBF_MONIT_DELEGATE MONIT,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CCF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CDF(
    string STR
,
    long STRLength 
    );


public delegate void H02CEF_QPHX_DELEGATE(
    ref int NSTATE,
    ref int NCOLH,
    IntPtr X_rptr,
    IntPtr HX_rptr
  );


public delegate void H02CEF_MONIT_DELEGATE(
    ref int INTFND,
    ref int NODES,
    ref int DEPTH,
    ref double OBJ,
    IntPtr X_rptr,
    ref double BSTVAL,
    IntPtr BSTSOL_rptr,
    IntPtr BL_rptr,
    IntPtr BU_rptr,
    ref int N,
    ref int HALT,
    ref int COUNT
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CEY(
    ref int INTFND,
    ref int NODES,
    ref int DEPTH,
    ref double OBJ,
    IntPtr X_rptr,
    ref double BSTVAL,
    IntPtr BSTSOL_rptr,
    IntPtr BL_rptr,
    IntPtr BU_rptr,
    ref int N,
    ref int HALT,
    ref int COUNT
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CEF(
    ref int N, ref int M, ref int NNZ,
    ref int IOBJ, ref int NCOLH, H02CEF_QPHX_DELEGATE QPHX,
    [In,Out] double[] A, [In] int[] HA, [In] int[] KA,
    [In,Out] double[] BL, [In,Out] double[] BU, string START,
    [In,Out] byte[,] NAMES, ref int NNAME, [In,Out] byte[,] CRNAME,
    ref int NS, [In,Out] double[] XS, [In] int[] INTVAR,
    ref int LINTVR, ref int MDEPTH, [In,Out] int[] ISTATE,
    ref int MINIZ, ref int MINZ, ref double OBJ,
    [Out] double[] CLAMDA, ref int STRTGY, [Out] int[] IZ,
    ref int LENIZ, [Out] double[] Z, ref int LENZ,
    H02CEF_MONIT_DELEGATE MONIT, ref int IFAIL
,
    long STARTLength,
    long NAMESLength,
    long CRNAMELength
    );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CFF(
    ref int IOPTNS,
    ref int INFORM
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02CGF(
    string STR
,
    long STRLength 
    );


public delegate void H02DAF_CONFUN_DELEGATE(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    IntPtr VARCON_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DDM(
    ref int MODE,
    ref int NCNLN,
    ref int N,
    IntPtr VARCON_iptr,
    IntPtr X_rptr,
    IntPtr C_rptr,
    IntPtr CJAC_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

public delegate void H02DAF_OBJFUN_DELEGATE(
    ref int MODE,
    ref int N,
    IntPtr VARCON_iptr,
    IntPtr X_rptr,
    ref double OBJMIP,
    IntPtr OBJGRD_rptr,
    ref int NSTATE,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DAF(
    ref int N, ref int NCLIN, ref int NCNLN,
    [In] double[,] A, ref int LDA, [In] double[] D,
    [Out] double[] AX, [In] double[] BL, [In] double[] BU,
    [In] int[] VARCON, [In,Out] double[] X, H02DAF_CONFUN_DELEGATE CONFUN,
    [Out] double[] C, [Out] double[,] CJAC, H02DAF_OBJFUN_DELEGATE OBJFUN,
    [Out] double[] OBJGRD, ref int MAXIT, ref double ACC,
    ref double OBJMIP, [In] int[] IOPTS, [In] double[] OPTS,
    [In,Out] int[] IUSER, [In,Out] double[] RUSER, ref int IFAIL
   );


public delegate void H02DDF_OBJFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DDV(
    ref int NVAR,
    IntPtr X_rptr,
    ref double FX,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void H02DDF_OBJGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DDW(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZFD,
    IntPtr FDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void H02DDF_CONFUN_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    IntPtr GX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DDX(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NCNLN,
    IntPtr GX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void H02DDF_CONGRD_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZGD,
    IntPtr GDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DDY(
    ref int NVAR,
    IntPtr X_rptr,
    ref int NNZGD,
    IntPtr GDX_rptr,
    ref int INFORM,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

public delegate void H02DDF_MONIT_DELEGATE(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DDU(
    ref int NVAR,
    IntPtr X_rptr,
    ref int INFORM,
    IntPtr RINFO_rptr,
    IntPtr STATS_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref IntPtr CPUSER
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02DDF(
    ref IntPtr HANDLE,
    H02DDF_OBJFUN_DELEGATE OBJFUN,
    H02DDF_OBJGRD_DELEGATE OBJGRD,
    H02DDF_CONFUN_DELEGATE CONFUN,
    H02DDF_CONGRD_DELEGATE CONGRD,
    H02DDF_MONIT_DELEGATE MONIT,
    ref int NVAR,
    [In,Out] double[] X,
    [Out] double[] RINFO,
    [Out] double[] STATS,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref IntPtr CPUSER,
    ref int IFAIL
   );




   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02ZKF(
    string OPTSTR,
    [In,Out] int[] IOPTS,
    ref int LIOPTS,
    [In,Out] double[] OPTS,
    ref int LOPTS,
    ref int IFAIL
,
    long OPTSTRLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H02ZLF(
    string OPTSTR,
    ref int IVALUE,
    ref double RVALUE,
    StringBuilder CVALUE,
    ref int OPTYPE,
    [In] int[] IOPTS,
    [In] double[] OPTS,
    ref int IFAIL
,
    long OPTSTRLength,
    long CVALUELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H03ABF(
    [In] int[,] KOST,
    ref int LDKOST,
    ref int MA,
    ref int MB,
    ref int M,
    [In,Out] int[] K15,
    ref int MAXIT,
    [Out] int[] K7,
    [Out] int[] K9,
    ref int NUMIT,
    [Out] int[] K6,
    [Out] int[] K8,
    [Out] int[] K11,
    [Out] int[] K12,
    ref double Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H03ADF(
    ref int N,
    ref int NS,
    ref int NE,
    ref int DIRECT,
    ref int NNZ,
    [In] double[] D,
    [In,Out] int[] IROW,
    [In] int[] ICOL,
    ref double SPLEN,
    [Out] int[] PATH,
    [Out] int[] IWORK,
    [Out] double[] WORK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H03BBF(
    ref int NC,
    [In] double[,] DM,
    ref double BOUND,
    ref double TARGC,
    [Out] int[] PATH,
    ref double COST,
    ref int TMODE,
    [Out] double[] ALG_STATS,
    [In,Out] int[] STATE,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H05AAF(
    ref int IREVCM, ref int MINCR, ref int M,
    ref int IP, ref int NBEST, ref int DROP,
    ref int LZ, [In,Out] int[] Z, ref int LA,
    [In,Out] int[] A, [In,Out] double[] BSCORE, [In,Out] int[,] BZ,
    ref int MINCNT, ref double GAMMA, [In] double[] ACC,
    [In,Out] int[] ICOMM, ref int LICOMM, [In,Out] double[] RCOMM,
    ref int LRCOMM, ref int IFAIL
   );


public delegate void H05ABF_F_DELEGATE(
    ref int M,
    ref int DROP,
    ref int LZ,
    IntPtr Z_iptr,
    ref int LA,
    IntPtr A_iptr,
    IntPtr SCORE_rptr,
    IntPtr IUSER_iptr,
    IntPtr RUSER_rptr,
    ref int INFO
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void H05ABF(
    ref int MINCR,
    ref int M,
    ref int IP,
    ref int NBEST,
    ref int LA,
    [Out] double[] BSCORE,
    [Out] int[,] BZ,
    H05ABF_F_DELEGATE F,
    ref int MINCNT,
    ref double GAMMA,
    [In] double[] ACC,
    [In,Out] int[] IUSER,
    [In,Out] double[] RUSER,
    ref int IFAIL
   );


// chapter m01

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01CAF(
    [In,Out] double[] RV,
    ref int M1,
    ref int M2,
    string ORDER,
    ref int IFAIL
,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01CBF(
    [In,Out] int[] IV,
    ref int M1,
    ref int M2,
    string ORDER,
    ref int IFAIL
,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01CCF(
    [In,Out] byte[,] CH,
    ref int M1,
    ref int M2,
    ref int L1,
    ref int L2,
    string ORDER,
    ref int IFAIL
,
    long CHLength,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DAF(
    [In] double[] RV,
    ref int M1,
    ref int M2,
    string ORDER,
    [Out] int[] IRANK,
    ref int IFAIL
,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DBF(
    [In] int[] IV,
    ref int M1,
    ref int M2,
    string ORDER,
    [Out] int[] IRANK,
    ref int IFAIL
,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DCF(
    [In,Out] byte[,] CH,
    ref int M1,
    ref int M2,
    ref int L1,
    ref int L2,
    string ORDER,
    [Out] int[] IRANK,
    ref int IFAIL
,
    long CHLength,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DEF(
    [In] double[,] RM,
    ref int LDM,
    ref int M1,
    ref int M2,
    ref int N1,
    ref int N2,
    string ORDER,
    [Out] int[] IRANK,
    ref int IFAIL
,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DFF(
    [In] int[,] IM,
    ref int LDM,
    ref int M1,
    ref int M2,
    ref int N1,
    ref int N2,
    string ORDER,
    [Out] int[] IRANK,
    ref int IFAIL
,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DJF(
    [In] double[,] RM,
    ref int LDM,
    ref int M1,
    ref int M2,
    ref int N1,
    ref int N2,
    string ORDER,
    [Out] int[] IRANK,
    ref int IFAIL
,
    long ORDERLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DKF(
    [In] int[,] IM,
    ref int LDM,
    ref int M1,
    ref int M2,
    ref int N1,
    ref int N2,
    string ORDER,
    [Out] int[] IRANK,
    ref int IFAIL
,
    long ORDERLength
    );


public delegate bool M01DZF_COMPAR_DELEGATE(
    ref int I,
    ref int J
  );

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01DZF(
    M01DZF_COMPAR_DELEGATE COMPAR,
    ref int M1,
    ref int M2,
    [Out] int[] IRANK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01EAF(
    [In,Out] double[] RV,
    ref int M1,
    ref int M2,
    [In,Out] int[] IRANK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01EBF(
    [In,Out] int[] IV,
    ref int M1,
    ref int M2,
    [In,Out] int[] IRANK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01ECF(
    [In,Out] byte[,] CH,
    ref int M1,
    ref int M2,
    [In,Out] int[] IRANK,
    ref int IFAIL
,
    long CHLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01EDF(
    [In,Out] Complex[] CV,
    ref int M1,
    ref int M2,
    [In,Out] int[] IRANK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int M01NAF(
    ref int VALID,
    [In] double[] RV,
    ref int M1,
    ref int M2,
    ref double ITEM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int M01NBF(
    ref int VALID,
    [In] int[] IV,
    ref int M1,
    ref int M2,
    ref int ITEM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int M01NCF(
    ref int VALID,
    [In,Out] byte[,] CH,
    ref int M1,
    ref int M2,
    string ITEM,
    ref int IFAIL
,
    long CHLength,
    long ITEMLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01NDF(
    ref int VALID,
    ref int MODE,
    [In] double[] RV,
    ref int N,
    ref int M1,
    ref int M2,
    [In] double[] ITEM,
    ref int M,
    [Out] int[] IDX,
    ref double H,
    [In,Out] int[] K,
    ref int LK,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01ZAF(
    [In,Out] int[] IPERM,
    ref int M1,
    ref int M2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01ZBF(
    [In,Out] int[] IPERM,
    ref int M1,
    ref int M2,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void M01ZCF(
    [In,Out] int[] IPERM,
    ref int M1,
    ref int M2,
    [Out] int[] ICYCL,
    ref int IFAIL
   );


// chapter s

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S01BAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex S01EAF(
    ref Complex Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S07AAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S09AAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S09ABF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S10AAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S10ABF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S10ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S11AAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S11ABF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S11ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S13AAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S13ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S13ADF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S14AAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S14ABF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S14ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14ADF(
    ref double X,
    ref int N,
    ref int M,
    [Out] double[] ANS,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S14AEF(
    ref double X,
    ref int K,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex S14AFF(
    ref Complex Z,
    ref int K,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex S14AGF(
    ref Complex Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S14AHF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14ANF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14APF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14BAF(
    ref double A,
    ref double X,
    ref double TOL,
    ref double P,
    ref double Q,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14BNF(
    ref int N,
    [In] double[] A,
    [In] double[] X,
    ref double TOL,
    [Out] double[] P,
    [Out] double[] Q,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S14CBF(
    ref double A,
    ref double B,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14CCF(
    ref double A,
    ref double B,
    ref double X,
    ref double W,
    ref double W1,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14CPF(
    ref int N,
    [In] double[] A,
    [In] double[] B,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S14CQF(
    ref int N,
    [In] double[] A,
    [In] double[] B,
    [In] double[] X,
    [Out] double[] W,
    [Out] double[] W1,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S15ABF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S15ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S15ADF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S15AEF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S15AFF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S15AGF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S15APF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S15AQF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S15ARF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S15ASF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S15ATF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S15AUF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex S15DDF(
    ref Complex Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S15DRF(
    ref int N,
    [In] Complex[] Z,
    [Out] Complex[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17ADF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17AEF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17AFF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17AGF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17AHF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17AJF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17AKF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17ALF(
    ref double A,
    ref int N,
    ref int MODE,
    ref double REL,
    [Out] double[] X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17AQF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17ARF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17ASF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17ATF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17AUF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17AVF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17AWF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17AXF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17DCF(
    ref double FNU,
    ref Complex Z,
    ref int N,
    string SCAL,
    [Out] Complex[] CY,
    ref int NZ,
    [Out] Complex[] CWRK,
    ref int IFAIL
,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17DEF(
    ref double FNU,
    ref Complex Z,
    ref int N,
    string SCAL,
    [Out] Complex[] CY,
    ref int NZ,
    ref int IFAIL
,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17DGF(
    string DERIV,
    ref Complex Z,
    string SCAL,
    ref Complex AI,
    ref int NZ,
    ref int IFAIL
,
    long DERIVLength,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17DHF(
    string DERIV,
    ref Complex Z,
    string SCAL,
    ref Complex BI,
    ref int IFAIL
,
    long DERIVLength,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S17DLF(
    ref int M,
    ref double FNU,
    ref Complex Z,
    ref int N,
    string SCAL,
    [Out] Complex[] CY,
    ref int NZ,
    ref int IFAIL
,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17GAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S17GBF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18ADF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18AEF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18AFF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18AQF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18ARF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18ASF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18ATF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18CCF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18CDF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18CEF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18CFF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18CQF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18CRF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18CSF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18CTF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18DCF(
    ref double FNU,
    ref Complex Z,
    ref int N,
    string SCAL,
    [Out] Complex[] CY,
    ref int NZ,
    ref int IFAIL
,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18DEF(
    ref double FNU,
    ref Complex Z,
    ref int N,
    string SCAL,
    [Out] Complex[] CY,
    ref int NZ,
    ref int IFAIL
,
    long SCALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18GAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18GBF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18GCF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S18GDF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S18GKF(
    ref Complex Z,
    ref double A,
    ref int NL,
    [Out] Complex[] B,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S19AAF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S19ABF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S19ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S19ADF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S19ANF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S19APF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S19AQF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S19ARF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] int[] IVALID,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S20ACF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S20ADF(
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S20AQF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S20ARF(
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BAF(
    ref double X,
    ref double Y,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BBF(
    ref double X,
    ref double Y,
    ref double Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BCF(
    ref double X,
    ref double Y,
    ref double Z,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BDF(
    ref double X,
    ref double Y,
    ref double Z,
    ref double R,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BEF(
    ref double PHI,
    ref double DM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BFF(
    ref double PHI,
    ref double DM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BGF(
    ref double DN,
    ref double PHI,
    ref double DM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BHF(
    ref double DM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21BJF(
    ref double DM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S21CAF(
    ref double U,
    ref double M,
    ref double SN,
    ref double CN,
    ref double DN,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S21CBF(
    ref Complex Z,
    ref double AK2,
    ref Complex SN,
    ref Complex CN,
    ref Complex DN,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S21CCF(
    ref int K,
    ref double X,
    ref double Q,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern Complex S21DAF(
    ref Complex Z,
    ref double AKP,
    ref double A,
    ref double B,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S22AAF(
    ref int MODE,
    ref double X,
    ref int M,
    ref int NL,
    [Out] double[] P,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S22BAF(
    ref double A,
    ref double B,
    ref double X,
    ref double M,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S22BBF(
    ref double ANI,
    ref double ADR,
    ref double BNI,
    ref double BDR,
    ref double X,
    ref double FRM,
    ref int SCM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double S22BEF(
    ref double A,
    ref double B,
    ref double C,
    ref double X,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S22BFF(
    ref double ANI,
    ref double ADR,
    ref double BNI,
    ref double BDR,
    ref double CNI,
    ref double CDR,
    ref double X,
    ref double FRF,
    ref int SCF,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S22CAF(
    ref int ORDVAL,
    ref double Q,
    ref int PARITY,
    ref int MODE,
    ref int N,
    [In] double[] X,
    [Out] double[] F,
    [Out] double[] F_DERIV,
    ref double A,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30AAF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double Q,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30ABF(
    string CALPUT, ref int M, ref int N,
    [In] double[] X, ref double S, [In] double[] T,
    ref double SIGMA, ref double R, ref double Q,
    [Out] double[,] P, ref int LDP, [Out] double[,] DELTA,
    [Out] double[,] GAMMA, [Out] double[,] VEGA, [Out] double[,] THETA,
    [Out] double[,] RHO, [Out] double[,] CRHO, [Out] double[,] VANNA,
    [Out] double[,] CHARM, [Out] double[,] SPEED, [Out] double[,] COLOUR,
    [Out] double[,] ZOMMA, [Out] double[,] VOMMA, ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30ACF(
    string CALPUT,
    ref int N,
    [In] double[] P,
    [In] double[] K,
    [In] double[] S0,
    [In] double[] T,
    [In] double[] R,
    [Out] double[] SIGMA,
    ref int MODE,
    [Out] int[] IVALID,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30BAF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] SM,
    ref double S,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double Q,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30BBF(
    string CALPUT, ref int M, ref int N,
    [In] double[] SM, ref double S, [In] double[] T,
    ref double SIGMA, ref double R, ref double Q,
    [Out] double[,] P, ref int LDP, [Out] double[,] DELTA,
    [Out] double[,] GAMMA, [Out] double[,] VEGA, [Out] double[,] THETA,
    [Out] double[,] RHO, [Out] double[,] CRHO, [Out] double[,] VANNA,
    [Out] double[,] CHARM, [Out] double[,] SPEED, [Out] double[,] COLOUR,
    [Out] double[,] ZOMMA, [Out] double[,] VOMMA, ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30CAF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    ref double K,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double Q,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30CBF(
    string CALPUT, ref int M, ref int N,
    [In] double[] X, ref double S, ref double K,
    [In] double[] T, ref double SIGMA, ref double R,
    ref double Q, [Out] double[,] P, ref int LDP,
    [Out] double[,] DELTA, [Out] double[,] GAMMA, [Out] double[,] VEGA,
    [Out] double[,] THETA, [Out] double[,] RHO, [Out] double[,] CRHO,
    [Out] double[,] VANNA, [Out] double[,] CHARM, [Out] double[,] SPEED,
    [Out] double[,] COLOUR, [Out] double[,] ZOMMA, [Out] double[,] VOMMA,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30CCF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double Q,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30CDF(
    string CALPUT, ref int M, ref int N,
    [In] double[] X, ref double S, [In] double[] T,
    ref double SIGMA, ref double R, ref double Q,
    [Out] double[,] P, ref int LDP, [Out] double[,] DELTA,
    [Out] double[,] GAMMA, [Out] double[,] VEGA, [Out] double[,] THETA,
    [Out] double[,] RHO, [Out] double[,] CRHO, [Out] double[,] VANNA,
    [Out] double[,] CHARM, [Out] double[,] SPEED, [Out] double[,] COLOUR,
    [Out] double[,] ZOMMA, [Out] double[,] VOMMA, ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30FAF(
    string CALPUT,
    string TYP,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    ref double H,
    ref double K,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double Q,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength,
    long TYPLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30JAF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double LAMBDA,
    ref double JVOL,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30JBF(
    string CALPUT, ref int M, ref int N,
    [In] double[] X, ref double S, [In] double[] T,
    ref double SIGMA, ref double R, ref double LAMBDA,
    ref double JVOL, [Out] double[,] P, ref int LDP,
    [Out] double[,] DELTA, [Out] double[,] GAMMA, [Out] double[,] VEGA,
    [Out] double[,] THETA, [Out] double[,] RHO, [Out] double[,] VANNA,
    [Out] double[,] CHARM, [Out] double[,] SPEED, [Out] double[,] COLOUR,
    [Out] double[,] ZOMMA, [Out] double[,] VOMMA, ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30NAF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    [In] double[] T,
    ref double SIGMAV,
    ref double KAPPA,
    ref double CORR,
    ref double VAR0,
    ref double ETA,
    ref double GRISK,
    ref double R,
    ref double Q,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30NBF(
    string CALPUT, ref int M, ref int N,
    [In] double[] X, ref double S, [In] double[] T,
    ref double SIGMAV, ref double KAPPA, ref double CORR,
    ref double VAR0, ref double ETA, ref double GRISK,
    ref double R, ref double Q, [Out] double[,] P,
    ref int LDP, [Out] double[,] DELTA, [Out] double[,] GAMMA,
    [Out] double[,] VEGA, [Out] double[,] THETA, [Out] double[,] RHO,
    [Out] double[,] VANNA, [Out] double[,] CHARM, [Out] double[,] SPEED,
    [Out] double[,] ZOMMA, [Out] double[,] VOMMA, ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30NCF(
    string CALPUT,
    ref int M,
    ref int NUMTS,
    [In] double[] X,
    ref double FWD,
    ref double DISC,
    [In] double[] TS,
    ref double T,
    [In] double[] ALPHA,
    [In] double[] LAMBDA,
    [In] double[] CORR,
    [In] double[] SIGMAT,
    ref double VAR0,
    [Out] double[] P,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30NDF(
    string CALPUT, ref int M, ref int N,
    [In] double[] X, ref double S, [In] double[] T,
    ref double SIGMAV, ref double KAPPA, ref double CORR,
    ref double VAR0, ref double ETA, ref double GRISK,
    [In] double[] R, [In] double[] Q, [Out] double[,] P,
    ref int LDP, [Out] double[,] DELTA, [Out] double[,] GAMMA,
    [Out] double[,] VEGA, [Out] double[,] THETA, [Out] double[,] RHO,
    [Out] double[,] VANNA, [Out] double[,] CHARM, [Out] double[,] SPEED,
    [Out] double[,] ZOMMA, [Out] double[,] VOMMA, [Out] double[,] DP_DX,
    [Out] double[,] DP_DQ, [Out] double[,] DP_DETA, [Out] double[,] DP_DKAPPA,
    [Out] double[,] DP_DSIGMAV, [Out] double[,] DP_DCORR, [Out] double[,] DP_DGRISK,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30QCF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double Q,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30SAF(
    string CALPUT,
    ref int M,
    ref int N,
    [In] double[] X,
    ref double S,
    [In] double[] T,
    ref double SIGMA,
    ref double R,
    ref double B,
    [Out] double[,] P,
    ref int LDP,
    ref int IFAIL
,
    long CALPUTLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void S30SBF(
    string CALPUT, ref int M, ref int N,
    [In] double[] X, ref double S, [In] double[] T,
    ref double SIGMA, ref double R, ref double B,
    [Out] double[,] P, ref int LDP, [Out] double[,] DELTA,
    [Out] double[,] GAMMA, [Out] double[,] VEGA, [Out] double[,] THETA,
    [Out] double[,] RHO, [Out] double[,] CRHO, [Out] double[,] VANNA,
    [Out] double[,] CHARM, [Out] double[,] SPEED, [Out] double[,] COLOUR,
    [Out] double[,] ZOMMA, [Out] double[,] VOMMA, ref int IFAIL
,
    long CALPUTLength
    );


// chapter x01

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X01AAF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X01ABF(
    ref double X
   );


// chapter x02

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X02AHF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X02AJF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X02AKF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X02ALF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X02AMF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X02ANF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X02BBF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X02BEF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X02BHF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X02BJF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X02BKF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X02BLF(
   );


// chapter x04

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04AAF(
    ref int IFLAG,
    ref int NERR
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04ABF(
    ref int IFLAG,
    ref int NADV
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04ACF(
    ref int IOUNIT,
    string FILE,
    ref int MODE,
    ref int IFAIL
,
    long FILELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04ADF(
    ref int IOUNIT,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04BAF(
    ref int NOUT,
    string REC
,
    long RECLength 
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04BBF(
    ref int NIN,
    StringBuilder RECIN,
    ref int IFAIL
,
    long RECINLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04CAF(
    string MATRIX,
    string DIAG,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    string TITLE,
    ref int IFAIL
,
    long MATRIXLength,
    long DIAGLength,
    long TITLELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04CBF(
    string MATRIX,
    string DIAG,
    ref int M,
    ref int N,
    [In] double[,] A,
    ref int LDA,
    string FORM,
    string TITLE,
    string LABROW,
    [In,Out] byte[,] RLABS,
    string LABCOL,
    [In,Out] byte[,] CLABS,
    ref int NCOLS,
    ref int INDENT,
    ref int IFAIL
,
    long MATRIXLength,
    long DIAGLength,
    long FORMLength,
    long TITLELength,
    long LABROWLength,
    long RLABSLength,
    long LABCOLLength,
    long CLABSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04CCF(
    string UPLO,
    string DIAG,
    ref int N,
    [In] double[] A,
    string TITLE,
    ref int IFAIL
,
    long UPLOLength,
    long DIAGLength,
    long TITLELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04CDF(
    string UPLO,
    string DIAG,
    ref int N,
    [In] double[] A,
    string FORM,
    string TITLE,
    string LABROW,
    [In,Out] byte[,] RLABS,
    string LABCOL,
    [In,Out] byte[,] CLABS,
    ref int NCOLS,
    ref int INDENT,
    ref int IFAIL
,
    long UPLOLength,
    long DIAGLength,
    long FORMLength,
    long TITLELength,
    long LABROWLength,
    long RLABSLength,
    long LABCOLLength,
    long CLABSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04CEF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] A,
    ref int LDA,
    string TITLE,
    ref int IFAIL
,
    long TITLELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04CFF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] double[,] A,
    ref int LDA,
    string FORM,
    string TITLE,
    string LABROW,
    [In,Out] byte[,] RLABS,
    string LABCOL,
    [In,Out] byte[,] CLABS,
    ref int NCOLS,
    ref int INDENT,
    ref int IFAIL
,
    long FORMLength,
    long TITLELength,
    long LABROWLength,
    long RLABSLength,
    long LABCOLLength,
    long CLABSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04DAF(
    string MATRIX,
    string DIAG,
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    string TITLE,
    ref int IFAIL
,
    long MATRIXLength,
    long DIAGLength,
    long TITLELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04DBF(
    string MATRIX,
    string DIAG,
    ref int M,
    ref int N,
    [In] Complex[,] A,
    ref int LDA,
    string USEFRM,
    string FORM,
    string TITLE,
    string LABROW,
    [In,Out] byte[,] RLABS,
    string LABCOL,
    [In,Out] byte[,] CLABS,
    ref int NCOLS,
    ref int INDENT,
    ref int IFAIL
,
    long MATRIXLength,
    long DIAGLength,
    long USEFRMLength,
    long FORMLength,
    long TITLELength,
    long LABROWLength,
    long RLABSLength,
    long LABCOLLength,
    long CLABSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04DCF(
    string UPLO,
    string DIAG,
    ref int N,
    [In] Complex[] A,
    string TITLE,
    ref int IFAIL
,
    long UPLOLength,
    long DIAGLength,
    long TITLELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04DDF(
    string UPLO,
    string DIAG,
    ref int N,
    [In] Complex[] A,
    string USEFRM,
    string FORM,
    string TITLE,
    string LABROW,
    [In,Out] byte[,] RLABS,
    string LABCOL,
    [In,Out] byte[,] CLABS,
    ref int NCOLS,
    ref int INDENT,
    ref int IFAIL
,
    long UPLOLength,
    long DIAGLength,
    long USEFRMLength,
    long FORMLength,
    long TITLELength,
    long LABROWLength,
    long RLABSLength,
    long LABCOLLength,
    long CLABSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04DEF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] A,
    ref int LDA,
    string TITLE,
    ref int IFAIL
,
    long TITLELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04DFF(
    ref int M,
    ref int N,
    ref int KL,
    ref int KU,
    [In] Complex[,] A,
    ref int LDA,
    string USEFRM,
    string FORM,
    string TITLE,
    string LABROW,
    [In,Out] byte[,] RLABS,
    string LABCOL,
    [In,Out] byte[,] CLABS,
    ref int NCOLS,
    ref int INDENT,
    ref int IFAIL
,
    long USEFRMLength,
    long FORMLength,
    long TITLELength,
    long LABROWLength,
    long RLABSLength,
    long LABCOLLength,
    long CLABSLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04EAF(
    string MATRIX,
    string DIAG,
    ref int M,
    ref int N,
    [In] int[,] A,
    ref int LDA,
    string TITLE,
    ref int IFAIL
,
    long MATRIXLength,
    long DIAGLength,
    long TITLELength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X04EBF(
    string MATRIX,
    string DIAG,
    ref int M,
    ref int N,
    [In] int[,] A,
    ref int LDA,
    string FORM,
    string TITLE,
    string LABROW,
    [In,Out] byte[,] RLABS,
    string LABCOL,
    [In,Out] byte[,] CLABS,
    ref int NCOLS,
    ref int INDENT,
    ref int IFAIL
,
    long MATRIXLength,
    long DIAGLength,
    long FORMLength,
    long TITLELength,
    long LABROWLength,
    long RLABSLength,
    long LABCOLLength,
    long CLABSLength
    );


// chapter x05

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X05AAF(
    [Out] int[] ITIME
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern string X05ABF(
    string RETVAL,
    [In] int[] ITIME
,
    long RETVALLength
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X05ACF(
    string CTIME1,
    string CTIME2
,
    long CTIME1Length,
    long CTIME2Length 
    );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern double X05BAF(
   );


// chapter x06

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X06AAF(
    ref int NUM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X06ABF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X06ACF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X06ADF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X06AFF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X06AGF(
    ref int NESTING
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X06AHF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X06AJF(
    ref int NUM,
    ref int IFAIL
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X06AKF(
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern int X06XAF(
   );


// chapter x07

   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool X07AAF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern bool X07ABF(
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X07BAF(
    ref int ISIGN,
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X07BBF(
    ref int QUIET,
    ref double X
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X07CAF(
    [Out] int[] EXCEPTIONMODE
   );


   [DllImport("NLW6I31DE_nag.dll")]
   public static extern void X07CBF(
    [In] int[] EXCEPTIONMODE
   );

}
}

