using System;
using System.Runtime.InteropServices;/* Provides mappings between C# and native code */

/* This example calls either a Windows or Linux version of the NAG Library based on
 * which OS the example is being executed on*/

namespace NumericalAlgorithmsGroup
{
    class tanfunc {

        /* NAG routine declarations copied from flcsdnet64.cs & flcsdnet64_linux.cs*/

        /* Both Windows and Linux routine declarations included as the dll is not 
         * loaded unless the routine is called explicitly.
         * The Linux declaration has an underscore appended to differentiate it*/

        [DllImport("NLW6I31DE_nag.dll")] /* Import from DLL, the C# compiler provides a rudimentary check of the signature */
        public static extern double S07AAF(
                                            ref double X,
                                            ref int IFAIL
                                            );


       [DllImport("libnag_nag.so", EntryPoint="s07aaf_")]
         public static extern double S07AAF_(
                                            ref double X,
                                            ref int IFAIL
                                            );

        public static void Main()
        {
            double tanresult = 0.0;
            int ifail = 1;
            double x = Math.PI / 4;
            if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows)) {
              tanresult = S07AAF(ref x, ref ifail);
            } else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux)) {
              tanresult = S07AAF_(ref x, ref ifail);
            } else {
              Console.WriteLine("Unsupported OS Platform");
            }
            if (ifail != 0) {
              Console.WriteLine("ifail = {0}", ifail);
            } else {
              Console.WriteLine("tan pi/4 = {0, 4:f2}", tanresult);
            }
        }
    }
}
