using System;
using System.Runtime.InteropServices;/* Provides mappings between C# and native code */

/* This example calls either a Windows or Linux version of the NAG Library based on
 * which OS the example is being executed on*/

namespace NumericalAlgorithmsGroup
{
  class OptNlp
    {

        /* NAG routine declarations copied from flcsdnet64.cs & flcsdnet64_linux.cs*/

        /* Both Windows and Linux routine declarations included as the dll is not 
         * loaded unless the routine is called explicitly.
         * The Linux declaration has an underscore appended to differentiate it*/

        [DllImport("NLW6I31DE_nag.dll")] /* Import from DLL, the C# compiler provides a rudimentary check of the signature */
        public static extern void E04UEF(
                                         string STR,
                                         long STRLength 
                                         );

      [DllImport("libnag_nag.so", EntryPoint="e04uef_")]
        public static extern void E04UEF_(
                                         string STR,
                                         long STRLength 
                                         );

      [DllImport("NLW6I31DE_nag.dll")]
        public static extern void E04UFF(
                                         ref int IREVCM, ref int N, ref int NCLIN,
                                         ref int NCNLN, ref int LDA, ref int LDCJ,
                                         ref int LDR, [In] double[,] A, [In] double[] BL,
                                         [In] double[] BU, ref int ITER, [In,Out] int[] ISTATE,
                                         [In,Out] double[] C, [In,Out] double[,] CJAC, [In,Out] double[] CLAMDA,
                                         ref double OBJF, [In,Out] double[] OBJGRD, [In,Out] double[,] R,
                                         [In,Out] double[] X, [Out] int[] NEEDC, [In,Out] int[] IWORK,
                                         ref int LIWORK, [In,Out] double[] WORK, ref int LWORK,
                                         ref int IFAIL
                                         );

      [DllImport("libnag_nag.so", EntryPoint="e04uff_")]
        public static extern void E04UFF_(
                                         ref int IREVCM, ref int N, ref int NCLIN,
                                         ref int NCNLN, ref int LDA, ref int LDCJ,
                                         ref int LDR, [In] double[,] A, [In] double[] BL,
                                         [In] double[] BU, ref int ITER, [In,Out] int[] ISTATE,
                                         [In,Out] double[] C, [In,Out] double[,] CJAC, [In,Out] double[] CLAMDA,
                                         ref double OBJF, [In,Out] double[] OBJGRD, [In,Out] double[,] R,
                                         [In,Out] double[] X, [Out] int[] NEEDC, [In,Out] int[] IWORK,
                                         ref int LIWORK, [In,Out] double[] WORK, ref int LWORK,
                                         ref int IFAIL
                                         );

      [DllImport("NLW6I31DE_nag.dll")]
        public static extern void X04AAF(
                                         ref int IFLAG,
                                         ref int NERR
                                         );

      [DllImport("libnag_nag.so", EntryPoint="x04aaf_")]
        public static extern void X04AAF_(
                                         ref int IFLAG,
                                         ref int NERR
                                         );

      [DllImport("NLW6I31DE_nag.dll")]
        public static extern void X04ABF(
                                         ref int IFLAG,
                                         ref int NADV
                                         );

      [DllImport("libnag_nag.so", EntryPoint="x04abf_")]
        public static extern void X04ABF_(
                                         ref int IFLAG,
                                         ref int NADV
                                         );

      [DllImport("NLW6I31DE_nag.dll")]
        public static extern void X04ACF(
                                         ref int IOUNIT,
                                         string FILE,
                                         ref int MODE,
                                         ref int IFAIL,
                                         long FILELength
                                         );

      [DllImport("libnag_nag.so", EntryPoint="x04acf_")]
        public static extern void X04ACF_(
                                         ref int IOUNIT,
                                         string FILE,
                                         ref int MODE,
                                         ref int IFAIL,
                                         long FILELength
                                         );

      [DllImport("NLW6I31DE_nag.dll")]
        public static extern void X04ADF(
                                         ref int IOUNIT,
                                         ref int IFAIL
                                         );

      [DllImport("libnag_nag.so", EntryPoint="x04adf_")]
        public static extern void X04ADF_(
                                         ref int IOUNIT,
                                         ref int IFAIL
                                         );

        public static void Main()
        {
          int n = 4;
          int nclin = 1;
          int ncnln = 2;
          int totalvars=n+nclin+ncnln;
          double [,] a = new double[nclin,n];
          double [] bl = new double[totalvars];
          double [] bu = new double[totalvars];
          int iter=0;
          int [] istate = new int[totalvars];
          int [] needc = new int[ncnln];
          double [] c = new double[ncnln];
          double [,] cjac = new double[n,ncnln];
          double [] clamda = new double[totalvars];
          double objf=0.0;
          double [] objgrd = new double[n];
          double [,] r = new double [n,n];
          double [] x = new double[n];
          int liwork = 3*n + nclin + 2*ncnln;
          int [] iwork = new int[liwork];
          int lwork;
          int ifail;
          int nerr = 7;
          int nadv = nerr;

          if ( ncnln == 0 && nclin == 0)
            {
              lwork = 21*n+2;
            }
          else if (ncnln == 0 && nclin > 0)
            {
              lwork = 2*n*n + 21*n + 11*nclin + 2;
            }
          else
            {
              lwork = 2*n*n + n *nclin + 2*n*ncnln + 21*n +11*nclin + 22*ncnln + 1;
            }
          double [] work = new double[lwork];
          int i, j;

          for (i = 0; i < nclin; ++i)
            {
              for (j = 0; j < n; ++j)
                {
                  a[i,j] = 1.0;
                }
            }
          bl[0] = 1.0;
          bl[1] = 1.0;
          bl[2] = 1.0;
          bl[3] = 1.0;
          bl[4] = -1.0E+25;
          bl[5] = -1.0E+25;
          bl[6] = 25.0;

          bu[0] = 5.0;
          bu[1] = 5.0;
          bu[2] = 5.0;
          bu[3] = 5.0;
          bu[4] = 20.0;
          bu[5] = 40.0;
          bu[6] = 1.0E+25;

          x[0] = 1.0;
          x[1] = 5.0;
          x[2] = 5.0;
          x[3] = 1.0;

          // Set this to true to send E04UFF results to a file
          // instead of console window:
          bool send_output_to_file = false;
          if (send_output_to_file)
            {
              // Set the error and advisory unit numbers using X04AAF() and
              // X04ABF(), and open a file with that unit number using X04ACF()
              int iflag = 1;
              X04AAF(ref iflag, ref nerr);
              X04ABF(ref iflag, ref nadv);
              string monFile = "NAG_e04uff_results.txt";
              int lfname = monFile.Length;
              int mode =  1;    // 0 reading; 1 writing; 2 appending;
              ifail = -1;
              if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                {
                  X04ACF(ref nadv, monFile, ref mode, ref ifail, lfname);
                }
              else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                {
                  X04ACF_(ref nadv, monFile, ref mode, ref ifail, lfname);
                }
            }

          double [] ruser = new double[1];
          int [] iuser = new int [1];
          if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
            {
              E04UEF("Print Level = 10", "Print Level = 10".Length);
              E04UEF("Derivative Level = 3", "Derivative Level = 3".Length);
            }
          else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
            {
              E04UEF_("Print Level = 10", "Print Level = 10".Length);
              E04UEF_("Derivative Level = 3", "Derivative Level = 3".Length);
            }
          else
            {
              Console.WriteLine("Unsupported OS Platform");
              return;
            }
          int irevcm = 0;
          int lda = nclin;
          int ldcj = ncnln;
          int ldr=n;
          ifail = 1;
          do {
            if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
              {
                E04UFF(ref irevcm, ref n, ref nclin, ref ncnln, ref lda, ref ldcj, ref ldr, a, bl, bu, ref iter, istate,
                       c, cjac, clamda, ref objf, objgrd, r, x, needc, iwork, ref liwork, work, ref lwork, ref ifail);
              }
            else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
              {
                E04UFF_(ref irevcm, ref n, ref nclin, ref ncnln, ref lda, ref ldcj, ref ldr, a, bl, bu, ref iter, istate,
                       c, cjac, clamda, ref objf, objgrd, r, x, needc, iwork, ref liwork, work, ref lwork, ref ifail);
              }
            if (irevcm != 0)
              {
                if ((irevcm == 1) || (irevcm == 3)) // calculate value of objective function
                  {
                    objf = x[0]*x[3]*(x[0]+x[1]+x[2]) + x[2];
                  }
                if ((irevcm == 2) || (irevcm == 3)) // Evaluate the objective gradient
                  {
                    objgrd[0] = x[3]*(2.0*x[0]+x[1]+x[2]);
                    objgrd[1] = x[0]*x[3];
                    objgrd[2] = x[0]*x[3] + 1.0;
                    objgrd[3] = x[0]*(x[0]+x[1]+x[2]);
                  }
                if ((irevcm == 4) || (irevcm == 6)) // Evaluate the nonlinear constraints
                  {
                    if (needc[0]>0)
                      c[0] = x[0]*x[0] + x[1]*x[1] + x[2]*x[2] + x[3]*x[3];
                    if (needc[1]>0)
                      c[1] = x[0]*x[1]*x[2]*x[3];
                  }
                if ((irevcm == 5) || (irevcm == 6)) // Evaluate the constraint Jacobian
                  {
                    if (needc[0]>0)
                      {
                        cjac[0,0] = 2.0*x[0];
                        cjac[1,0] = 2.0*x[1];
                        cjac[2,0] = 2.0*x[2];
                        cjac[3,0] = 2.0*x[3];
                      }
                    if (needc[1]>0)
                      {
                        cjac[0,1] = x[1]*x[2]*x[3];
                        cjac[1,1] = x[0]*x[2]*x[3];
                        cjac[2,1] = x[0]*x[1]*x[3];
                        cjac[3,1] = x[0]*x[1]*x[2];
                      }
                  }
              }
          } while (irevcm != 0);
          if (ifail != 0)
            {
                Console.WriteLine("ifail = {0}", ifail);
            }
          if (send_output_to_file)
            {
              // Close the file we opened earlier
              ifail = -1;
              if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                {
                  X04ADF(ref nadv, ref ifail);
                }
              else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                {
                  X04ADF(ref nadv, ref ifail);
                }
            }
        }

    }
}
