﻿using System;
using System.Runtime.InteropServices; /* Provides mappings between C# and native code */
using NagLibrary;


/* Use the C# header file (flcsdnet64.cs for Windows or
flcsdnet64_linux.cs for Linux) to provide the NAG Library declarations */


namespace NumericalAlgorithmsGroup
{
    class E04ff

    {

        static void Main(string[] args)
        {
            int nvar = 4;
            int nres = 11;
            int ifail;
            double[] rinfo = new double[100];
            double[] ruser = new double[1];
            double[] stats = new double[100];
            int[] iuser = new int[1];
            IntPtr cpuser = (IntPtr)0;

            Pdata pdata = new Pdata();
            nag_declarations.E04FFF_OBJFUN_DELEGATE objfund = new nag_declarations.E04FFF_OBJFUN_DELEGATE(pdata.objfun);
            nag_declarations.E04FFF_MONIT_DELEGATE monitd = new nag_declarations.E04FFF_MONIT_DELEGATE(nag_declarations.E04FFU);

            double infbnd = 1.0e20;

            // Initialize handle
            IntPtr handle = (IntPtr)0;

            ifail = 1;
            nag_declarations.E04RAF(ref handle, ref nvar, ref ifail);
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));


            // Define residuals structure, isparse = 0 means the residual structure is
            // dense => irowrd and icolrd are not accessed
            int isparse = 0;
            int nnzrd = 1;
            int[] irowrd = new int[1];
            int[] icolrd = new int[1];

            ifail = 1;
            nag_declarations.E04RMF(ref handle, ref nres, ref isparse, ref nnzrd, irowrd, icolrd, ref ifail);
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));

            // Set options
            string opt;
            //     relax the main convergence criteria a bit

            opt = "DFO Trust Region Tolerance = 5.0e-6";
            ifail = 1;
            nag_declarations.E04ZMF(ref handle, opt, ref ifail, Convert.ToInt64(opt.Length));
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));

            //    Print the solution
            ifail = 1;
            opt = "Print Solution = YES";
            nag_declarations.E04ZMF(ref handle, opt, ref ifail, Convert.ToInt64(opt.Length));
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));

            ifail = 1;
            opt = "DFO version = latest";
            nag_declarations.E04ZMF(ref handle, opt, ref ifail, Convert.ToInt64(opt.Length));
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));


            // Define starting point
            double[] x = { 0.25, 0.39, 0.415, 0.39 };
            double[] rx = new double[nres];

            // Define bounds for the second and the fourth variable
            double[] lx = { -infbnd, 0.2, -infbnd, 0.3 };
            double[] ux = { infbnd, 1.0, infbnd, infbnd };

            ifail = 1;
            nag_declarations.E04RHF(ref handle, ref nvar, lx, ux, ref ifail);
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));

            // Call the solver
            ifail = 1;
            nag_declarations.E04FFF(ref handle, objfund, monitd, ref nvar, x, ref nres, rx, rinfo, stats, iuser, ruser, ref cpuser, ref ifail);
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));


            // Free the handle memory
            ifail = 1;
            nag_declarations.E04RZF(ref handle, ref ifail);
            if (ifail != 0) throw new Exception(String.Format("NAG Call Returned ifail {0}", ifail));

        }



    }

    class Pdata
    {
        double[] y = { 4.0e0, 2.0e0, 1.0e0, 5.0e-1, 2.5e-1, 1.67e-1, 1.25e-1, 1.0e-1, 8.33e-2, 7.14e-2, 6.25e-2 };
        double[] z = { 1.957e-1, 1.947e-1, 1.735e-1, 1.6e-1, 8.44e-2, 6.27e-2, 4.56e-2, 3.42e-2, 3.23e-2, 2.35e-2, 2.46e-2 };

        public void objfun(ref int nvar, IntPtr x_ptr, ref int nres, IntPtr rx_ptr, ref int inform, IntPtr IUSER_iptr, IntPtr RUSER_rptr,
   ref IntPtr CPUSER)
        {
            double r1, r2;
            double[] x, rx;
            //  Interrupt solver if the dimensions are incorrect

            if (nres != 11 || nvar != 4)
            {
                inform = -1;
                return;
            }
            if (y.Length != nres || z.Length != nres)
            {
                inform = -1;
                return;
            }

            // get data from callback pointers
            x = new double[nvar];
            rx = new double[nres];
            Marshal.Copy(x_ptr, x, 0, nvar);
            for (int i = 0; i < nres; i++)
            {
                r1 = y[i] * (y[i] + x[1]);
                r2 = y[i] * (y[i] + x[2]) + x[3];
                rx[i] = z[i] - x[0] * r1 / r2;
            }

            // return result array
            Marshal.Copy(rx, 0, rx_ptr, nres);

        }
    }
}