using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

/* This example calls either a Windows or Linux version of the NAG Library based on
 * which OS the example is being executed on*/

namespace E02ADF
{
    class Program
    {

        /* NAG routine declarations copied from flcsdnet64.cs & flcsdnet64_linux.cs*/

        /* Both Windows and Linux routine declarations included as the dll is not 
         * loaded unless the routine is called explicitly.
         * The Linux declaration has an underscore appended to differentiate it*/

        [DllImport("NLW6I31DE_nag.dll")] /* Import from DLL, the C# compiler provides a rudimentary check of the signature */
        public static extern void E02ADF(
                                         ref int M,
                                         ref int KPLUS1,
                                         ref int LDA,
                                         [In] double[] X,
                                         [In] double[] Y,
                                         [In] double[] W,
                                         [Out] double[] WORK1,
                                         [Out] double[] WORK2,
                                         [Out] double[,] A,
                                         [Out] double[] S,
                                         ref int IFAIL
                                         );

      [DllImport("libnag_nag.so", EntryPoint="e02adf_")]
        public static extern void E02ADF_(
                                         ref int M,
                                         ref int KPLUS1,
                                         ref int LDA,
                                         [In] double[] X,
                                         [In] double[] Y,
                                         [In] double[] W,
                                         [Out] double[] WORK1,
                                         [Out] double[] WORK2,
                                         [Out] double[,] A,
                                         [Out] double[] S,
                                         ref int IFAIL
                                         );

      [DllImport("NLW6I31DE_nag.dll")]
        public static extern void E02AEF(
                                         ref int NPLUS1,
                                         [In] double[] A,
                                         ref double XCAP,
                                         ref double P,
                                         ref int IFAIL
                                         );

      [DllImport("libnag_nag.so", EntryPoint="e02aef_")]
        public static extern void E02AEF_(
                                         ref int NPLUS1,
                                         [In] double[] A,
                                         ref double XCAP,
                                         ref double P,
                                         ref int IFAIL
                                         );

        static void Main(string[] args)
        {
            double[] x = { 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0 };
            double[] y = { 0, 0.841470985, 0.909297427, 0.141120008, -0.756802495, -0.958924275, -0.279415498, 0.656986599, 0.989358247, 0.412118485, -0.544021111, -0.999990207, -0.536572918, 0.420167037 };
            double[] w = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };

            int k = 3;
            int kplus1 = k + 1;
            int lda = kplus1;
            int m = x.Length;
            double[] work1a = new double[3 * m];
            double[] work2a = new double[2 * kplus1];
            double[,] a = new double[kplus1, kplus1];
            double[] s = new double[kplus1];
            double[] ak = new double[kplus1];
            double fit = 0.0D;
            double xcap, xarg;
            int ifail;

            ifail = 1;

            try
            {
                if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                {
                    E02ADF(ref m, ref kplus1, ref lda, x, y, w, work1a, work2a, a, s, ref ifail);
                }
                else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                {
                    E02ADF_(ref m, ref kplus1, ref lda, x, y, w, work1a, work2a, a, s, ref ifail);
                }
                
                switch (ifail)
                {
                    case 1:
                        throw new Exception("The weights are not all strictly positive.");
                    case 2:
                        throw new Exception("The values of x[r], for r = 0, 1, 2, . . . ,m-1, are not in nondecreasing order.");
                    case 3:
                        throw new Exception("All x[r] have the same value: thus the normalization of x is not possible.");
                    case 4:
                        throw new Exception("On entry, kplus1 < 1 (so the maximum degree required is negative) or kplus1 > mdist, where mdist is the number of distinct x values in the data (so there cannot be a unique solution for degree k = kplus1 - 1).");
                    case 5:
                        throw new Exception("lda < kplus1.");
                    default:
                        if (ifail < 0)
                        {
                            throw new Exception(String.Format("E02ADF returned error code ifail = {0}", ifail));
                        }                       
                        break;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }


            for (int j = 0; j <= k; j++)
            {
                ak[j] = a[j, k];
            }

            if (ifail == 0)
            {
                Console.WriteLine("\nAbscissa    Polynomial\n");
                for (int i = 0; i <= m - 1; i++)
                {
                    xcap = ((x[i] - x[0]) - (x[m - 1] - x[i])) / (x[m - 1] - x[0]);

                    try
                    {
                        ifail = 1;

                        if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                        {
                            E02AEF(ref kplus1, ak, ref xcap, ref fit, ref ifail);
                        }
                        else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                        {
                            E02AEF_(ref kplus1, ak, ref xcap, ref fit, ref ifail);
                        }
                        switch (ifail)
                        {
                            case 1:
                                throw new Exception("ABS(xcap)> 1.0 + 4*eps, where eps is the machine precision. In this case the value of p is set arbitrarily to zero");
                            case 2:
                                throw new Exception("On entry, nplus1 < 1.");
                            default:
                                if (ifail < 0)
                                {
                                    throw new Exception(String.Format("E02AEF returned error code ifail = {0}", ifail));
                                }                       
                                break;
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        break;
                    }
                    Console.WriteLine("{0} \t {1, 10:f4}", x[i], fit);

                    if (i < m - 1)
                    {
                        xarg = 0.5 * (x[i] + x[i + 1]);
                        xcap = ((xarg - x[0]) - (x[m - 1] - xarg)) / (x[m - 1] - x[0]);

                        try
                        {
                            ifail = 1;
                            if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                            {
                                E02AEF(ref kplus1, ak, ref xcap, ref fit, ref ifail);
                            }
                            else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                            {
                                E02AEF_(ref kplus1, ak, ref xcap, ref fit, ref ifail);
                            }
                            switch (ifail)
                            {
                                case 1:
                                    throw new Exception("ABS(xcap)> 1.0 + 4*eps, where eps is the machine precision. In this case the value of p is set arbitrarily to zero.");
                                case 2:
                                    throw new Exception("On entry, nplus1 < 1.");
                                default:
                                    if (ifail < 0)
                                    {
                                        throw new Exception(String.Format("E02AEF returned error code ifail = {0}", ifail));
                                    }                       
                                    break;
                            }
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine(ex.Message);
                            break;
                        }
                        Console.WriteLine("{0} \t {1, 10:f4}", xarg, fit);

                    }
                }
            }
        }
    }
}
