using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

/* This example calls either a Windows or Linux version of the NAG Library based on
 * which OS the example is being executed on*/

namespace E01BEF
{
    class HermiteInterpolant
    {

        /* NAG routine declarations copied from flcsdnet64.cs & flcsdnet64_linux.cs*/

        /* Both Windows and Linux routine declarations included as the dll is not 
         * loaded unless the routine is called explicitly.
         * The Linux declaration has an underscore appended to differentiate it*/

        [DllImport("NLW6I31DE_nag.dll")] /* Import from DLL, the C# compiler provides a rudimentary check of the signature */
        public static extern void E01BEF(
                                         ref int N,
                                         [In] double[] X,
                                         [In] double[] F,
                                         [Out] double[] D,
                                         ref int IFAIL
                                         );

      [DllImport("libnag_nag.so", EntryPoint="e01bef_")]
        public static extern void E01BEF_(
                                         ref int N,
                                         [In] double[] X,
                                         [In] double[] F,
                                         [Out] double[] D,
                                         ref int IFAIL
                                         );

      [DllImport("NLW6I31DE_nag.dll")]
        public static extern void E01BFF(
                                         ref int N,
                                         [In] double[] X,
                                         [In] double[] F,
                                         [In] double[] D,
                                         ref int M,
                                         [In] double[] PX,
                                         [Out] double[] PF,
                                         ref int IFAIL
                                         );

      [DllImport("libnag_nag.so", EntryPoint="e01bff_")]
        public static extern void E01BFF_(
                                         ref int N,
                                         [In] double[] X,
                                         [In] double[] F,
                                         [In] double[] D,
                                         ref int M,
                                         [In] double[] PX,
                                         [Out] double[] PF,
                                         ref int IFAIL
                                         );

        static void Main(string[] args)
        {
            double[] x = { 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0 };
            double[] y = { 0, 0.841470985, 0.909297427, 0.141120008, -0.756802495, -0.958924275, -0.279415498, 0.656986599, 0.989358247, 0.412118485, -0.544021111, -0.999990207, -0.536572918, 0.420167037 };
            int m = x.Length;
            int n = 2 * m - 1;
            double[] d = new double[m];
            double[] px = new double[n];
            double[] pf = new double[n];
            int ifail;
            
            ifail = 1;

            try
            {
                if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                {
                   E01BEF(ref m, x, y, d, ref ifail);
                }
                else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                {
                   E01BEF_(ref m, x, y, d, ref ifail);
                }
                switch (ifail)
                {
                    case 1:
                        throw new Exception("On entry, n < 2.");

                    case 2:
                        throw new Exception("The values of x[r], for r = 0,1,...,m-1, are not in strictly increasing order.");

                    default:
                        if (ifail < 0)
                        {
                            throw new Exception(String.Format("E01BEF returned error code ifail = {0}", ifail));
                        }
                        break;
                }

            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
           
            //fill px with values to be evaluated 
            for (int i = 0; i < m; i++)
            {
                px[2 * i] = x[i];
                if (i > 0)
                    px[2 * i - 1] = 0.5 * (x[i - 1] + x[i]);
            }

            if (ifail == 0)
            {
            try
            {
                ifail = 1;
                if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                {
                   E01BFF(ref m, x, y, d, ref n, px, pf, ref ifail);
                }
                else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                {
                   E01BFF_(ref m, x, y, d, ref n, px, pf, ref ifail);
                }
                switch (ifail)
                {
                    case 1:
                        throw new Exception("On entry, n < 2.");

                    case 2:
                        throw new Exception("The values of x[r], for r = 0,1,...,m-1, are not in strictly increasing order.");

                    case 3:
                        throw new Exception("On entry, m < 1.");

                    case 4:
                        throw new Exception("At least one of the points px[i], for i= 0,1,...,n-1, lies outside the interval [x[0],x[m-1]], and the extrapolation was performed at all such points. Values computed at such points may be very unreliable.");

                    default:
                        if (ifail < 0)
                        {
                            throw new Exception(String.Format("E01BFF returned error code ifail = {0}", ifail));
                        }
                        break;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }

            Console.WriteLine("Abscissa    Interpolant\n");
             
             for (int i = 1; i <= n; i++)
             {
                Console.WriteLine("{0} \t {1, 10:f4}", px[i - 1], pf[i - 1]);
             }

            }
        }
    }
}
