using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

/* This example calls either a Windows or Linux version of the NAG Library based on
 * which OS the example is being executed on*/

namespace E01BAF
{
    class Program
    {

        /* NAG routine declarations copied from flcsdnet64.cs & flcsdnet64_linux.cs*/

        /* Both Windows and Linux routine declarations included as the dll is not 
         * loaded unless the routine is called explicitly.
         * The Linux declaration has an underscore appended to differentiate it*/

        [DllImport("NLW6I31DE_nag.dll")] /* Import from DLL, the C# compiler provides a rudimentary check of the signature */
        public static extern void E01BAF(
                                          ref int M,
                                          [In] double[] X,
                                          [In] double[] Y,
                                          [Out] double[] LAMDA,
                                          [Out] double[] C,
                                          ref int LCK,
                                          [Out] double[] WRK,
                                          ref int LWRK,
                                          ref int IFAIL
                                          );

       [DllImport("libnag_nag.so", EntryPoint="e01baf_")]
         public static extern void E01BAF_(
                                          ref int M,
                                          [In] double[] X,
                                          [In] double[] Y,
                                          [Out] double[] LAMDA,
                                          [Out] double[] C,
                                          ref int LCK,
                                          [Out] double[] WRK,
                                          ref int LWRK,
                                          ref int IFAIL
                                          );


       [DllImport("NLW6I31DE_nag.dll")]
         public static extern void E02BBF(
                                          ref int NCAP7,
                                          [In] double[] LAMDA,
                                          [In] double[] C,
                                          ref double X,
                                          ref double S,
                                          ref int IFAIL
                                          );

       [DllImport("libnag_nag.so", EntryPoint="e02bbf_")]
         public static extern void E02BBF_(
                                          ref int NCAP7,
                                          [In] double[] LAMDA,
                                          [In] double[] C,
                                          ref double X,
                                          ref double S,
                                          ref int IFAIL
                                          );



        static void Main(string[] args)
        {
            double[] x = { 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0 };
            double[] y = { 0, 0.841470985, 0.909297427, 0.141120008, -0.756802495, -0.958924275, -0.279415498, 0.656986599, 0.989358247, 0.412118485, -0.544021111, -0.999990207, -0.536572918, 0.420167037 };
            int m = x.Length;
            int n = 2 * m - 1;
            int lck = m + 4;
            int lwrk = 6 * m + 16;
            double[] wrk = new double[lwrk];
            double[] c = new double[lck];
            double[] lamda = new double[lck];
            double[] xx = new double[n];
            double fit = 0.0D;
            int ifail;

            ifail = 1;

            try
            {
                if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                {
                    E01BAF(ref m, x, y, lamda, c, ref lck, wrk, ref lwrk, ref ifail);
                }
                else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                {
                    E01BAF_(ref m, x, y, lamda, c, ref lck, wrk, ref lwrk, ref ifail);
                }
                switch (ifail)
                {
                    case 1:
                        throw new Exception("On entry, m < 4 or lck < m + 4 or lwrk < 6 * m + 16");
                    case 2:
                        throw new Exception("The x-values fail to satisfy the condition x[0] < x[1] <...< x[m-1].");
                    default:
                        if (ifail < 0)
                        {
                            throw new Exception(String.Format("E01BAF returned error code ifail = {0}", ifail));
                        }
                        break;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
            //new array with values to be evaluated
            for (int i = 0; i < m; i++)
            {
                xx[2 * i] = x[i];
                if (i > 0)
                    xx[2 * i - 1] = 0.5 * (x[i - 1] + x[i]);
            }

            

            if (ifail == 0)
            {
                Console.WriteLine("Abscissa    Spline\n");
                for (int i = 0; i < xx.Length; i++)
                {

                    try
                    {
                        ifail = 1;
                        if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
                        {
                            E02BBF(ref lck, lamda, c, ref xx[i], ref fit, ref ifail);
                        }
                        else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                        {
                           E02BBF_(ref lck, lamda, c, ref xx[i], ref fit, ref ifail);
                        }
                        switch (ifail)
                        {
                            case 1:
                                throw new Exception("The parameter x does not satisfy lamda[4] <= x <= lamda[ncap7-3]. In this case the value of s is set arbitrarily to zero.");
                            case 2:
                                throw new Exception("ncap7 < 8, i.e., the number of interior knots is negative.");

                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        break;
                    }

                    Console.WriteLine("{0} \t {1, 10:f4}", xx[i], fit);
                }
            }

        }
    }
}
