using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;
using System.ComponentModel;
using System.Threading;
using System.Diagnostics;

/* This example calls either a Windows or Linux version of the NAG Library based on
 * which OS the example is being executed on*/

namespace C06PKF
{
    class Program
    {

        /* NAG routine declarations copied from flcsdnet64.cs & flcsdnet64_linux.cs*/

        /* Both Windows and Linux routine declarations included as the dll is not 
         * loaded unless the routine is called explicitly.
         * The Linux declaration has an underscore appended to differentiate it*/

        [StructLayout(LayoutKind.Sequential)]/* Force sequential mapping */
        public struct Complex
        {
            public double Real_Part;
            public double Imag_Part;
        }

        [DllImport("NLW6I31DE_nag.dll")] /* Import from DLL, the C# compiler provides a rudimentary check of the signature */
        public static extern void C06PKF(
         ref int JOB,
         [In, Out] Complex[] X,
         [In, Out] Complex[] Y,
         ref int N,
         [Out] Complex[] WORK,
         ref int IFAIL
        );


        [DllImport("libnag_nag.so", EntryPoint = "c06pkf_")]
        public static extern void C06PKF_(
           ref int JOB,
           [In, Out] Complex[] X,
           [In, Out] Complex[] Y,
           ref int N,
           [Out] Complex[] WORK,
           ref int IFAIL
          );

        static void Main(string[] args)
        {
            int ifail;
            int n = 5000000;
            Complex[] x = new Complex[n];
            Complex[] y = new Complex[n];
            Complex[] work = new Complex[4 * n];

            for (int j = 0; j < n; j++)
            {
                x[j].Real_Part = (double)1.0 + Math.Cos(j);
                x[j].Imag_Part = (double)-0.5 + Math.Sin(j);
            }


            for (int i = 0; i < n; i++)
            {
                y[i].Real_Part = (double)0.5 + Math.Sin(i);
                y[i].Imag_Part = (double)-0.25 + Math.Cos(i);
            }

            ifail = 1;
            int job = 2;

            Stopwatch stopWatch = new Stopwatch();
            stopWatch.Start();

            if (RuntimeInformation.IsOSPlatform(OSPlatform.Windows))
            {
                C06PKF(ref job, x, y, ref n, work, ref ifail);
            }
            else if (RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
            {
                C06PKF_(ref job, x, y, ref n, work, ref ifail);
            }
            else
            {
                Console.WriteLine("Unsupported OS Platform");
            }

            stopWatch.Stop();

            TimeSpan ts = stopWatch.Elapsed;

            if (ifail != 0)
            {
                Console.WriteLine("An error occurred: ifail = {0}\n", ifail);
            }
            else
            {
                Console.WriteLine("For n = {0}, duration = {1} sec\n", n, ts.TotalSeconds);
            }

        }
    }
}
